package org.jboss.tools.vpe.preview.core.exceptions;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.xulrunner.XulRunnerBundleNotFoundException;
import org.jboss.tools.vpe.xulrunner.XulRunnerException;
import org.jboss.tools.vpe.xulrunner.browser.XulRunnerBrowser;

public class XulRunnerErrorWrapper {
	public static final String ID = "org.jboss.tools.vpe.editor";  //$NON-NLS-1$
	
	/**
	 * Logs given {@code throwable} (may be wrapped) and shows error message in 
	 * the {@code parent} composite.
	 */
	public void showError(Composite parent,
			Throwable originalThrowable) {
		Throwable throwable = wrapXulRunnerError(originalThrowable);
		String errorMessage;
		// TODO: remove this check when XULRunner becomes not experimental
		if (throwable instanceof XulRunnerBundleNotFoundException
				&& "org.mozilla.xulrunner.win32.win32.x86_64".equals(((XulRunnerBundleNotFoundException) throwable).getBundleId())) { //$NON-NLS-1$
			errorMessage = Messages.MOZILLA_EXPERIMENTAL_SUPPORT;
		} else {
			errorMessage = MessageFormat.format(Messages.MOZILLA_LOADING_ERROR, throwable.getMessage());
		}
		Activator.logError(throwable, errorMessage);

		parent.setLayout(new GridLayout());
		Composite statusComposite = new Composite(parent, SWT.NONE);
		Color bgColor= parent.getDisplay().getSystemColor(SWT.COLOR_LIST_BACKGROUND);
		Color fgColor= parent.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND);
		parent.setBackground(bgColor);
		parent.setForeground(fgColor);
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		gridData.widthHint = 0;
		gridData.heightHint = 0;
		statusComposite.setLayoutData(gridData);

		IStatus displayStatus = new Status(IStatus.ERROR,
				Activator.PLUGIN_ID, errorMessage, throwable);
		new LinkStatusPart(statusComposite, displayStatus, new Composite(parent, SWT.NONE));
		
		final Link link = new Link(parent, SWT.WRAP);
		link.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		link.setBackground(bgColor);
		link.setText(Messages.MOZILLA_LOADING_ERROR_LINK_TEXT);
		link.setToolTipText(Messages.MOZILLA_LOADING_ERROR_LINK);
		link.setForeground(link.getDisplay().getSystemColor(SWT.COLOR_BLUE));

		link.addMouseListener(new MouseListener() {
			public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
				BusyIndicator.showWhile(link.getDisplay(), new Runnable() {
					public void run() {
						URL theURL = null;
						;
						try {
							theURL = new URL(Messages.MOZILLA_LOADING_ERROR_LINK);
						} catch (MalformedURLException e) {
							Activator.logError(e);
						}
						new BrowserUtility().checkedCreateExternalBrowser(theURL.toString(), Activator.PLUGIN_ID, Activator.getDefault().getLog());
					}
				});
			}

			public void mouseDoubleClick(MouseEvent e) {
			}
			public void mouseUp(MouseEvent e) {
			}
		});
		parent.getParent().layout(true, true);
	}
	
	/**
	 * Wraps instances of {@code SWTError} generated by XULRunner
	 * into a {@code XulRunnerException}. All other throwables are
	 * returned as is. In certain cases, error's messages may be
	 * substituted by messages that are more clear to the user.
	 */
	/* There is a workaround for JBIDE-7601 (Show XULRunner exception only once).
	 * 
	 * The problem is that the method {@code VpePlugin.getPluginLog().logError(...)}
	 * shows pop-ups for instances of {@code SWTError} because it considers
	 * them as {@code fatal}. To workaround of it, these errors are wrapped
	 * to an {@code XulRunnerException}.
	 * 
	 * @see org.eclipse.ui.internal.ide.IDEWorkbenchErrorHandler#isFatal(StatusAdapter)
	 * @see org.eclipse.swt.browser.Mozilla
	 */
	protected Throwable wrapXulRunnerError(Throwable originalThrowable) {
		Throwable throwable = originalThrowable;
		if (throwable instanceof SWTError && throwable.getMessage() != null) {
			String message = throwable.getMessage(); 
			if(message.contains("XPCOM error ") //$NON-NLS-1$
					|| message.contains(" [Failed to use detected XULRunner: ") //$NON-NLS-1$
					|| message.contains(" [Unknown Mozilla path (MOZILLA_FIVE_HOME not set)]") //$NON-NLS-1$
					|| message.contains(" [Mozilla GTK2 required (GTK1.2 detected)]") //$NON-NLS-1$
					|| message.contains(" [MOZILLA_FIVE_HOME='") //$NON-NLS-1$
					|| message.contains(" [MOZILLA_FIVE_HOME may not point at an embeddable GRE] [NS_InitEmbedding ")) { //$NON-NLS-1$
				throwable = new XulRunnerException(originalThrowable);
			} else if (message.contains(" [Could not detect registered XULRunner to use]")) {//$NON-NLS-1$
				if (System.getProperty(XulRunnerBrowser.XULRUNNER_PATH) == null
						&& !XulRunnerBrowser.isCurrentPlatformOfficiallySupported()) {
					throwable = new XulRunnerException(
							MessageFormat.format(
									Messages.CURRENT_PLATFORM_IS_NOT_SUPPORTED,
									XulRunnerBrowser.CURRENT_PLATFORM_ID),
							originalThrowable);
				} else {
					throwable = new XulRunnerException(originalThrowable);
				}
			} else if (message.contains("not supported with GTK 3 as XULRunner is not ported for GTK 3 yet")) { //$NON-NLS-1$
				throwable = new XulRunnerException(Messages.GTK3_IS_NOT_SUPPORTED, originalThrowable);
			}
		}
		return throwable;
	}
}
