(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    return mod(require("tern/lib/infer"), require("tern/lib/tern"));
  if (typeof define == "function" && define.amd) // AMD
    return define([ "tern/lib/infer", "tern/lib/tern" ], mod);
  mod(tern, tern);
})(function(infer, tern) {
  "use strict";

  tern.registerPlugin("extjs4.2.1", function(server, options) {
    server._extjs = {};
    return {
      defs : defs
    };
  });

  var defs = {"!name":"extjs","!define":{},"Ext":{"AbstractComponent":{"!doc":"<p>An abstract base class which provides shared methods for Components across the Sencha product line.</p>\n\n<p>Please refer to sub class's documentation.</p>\n\n<p><strong>From override Ext.rtl.AbstractComponent:</strong> This override adds RTL support and the <code>rtl</code> config option to AbstactComponent.</p>\n","!type":"fn(config?: ?)","prototype":{"autoEl":{"!doc":"<p>A tag name or <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> spec used to create the <a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a> which will\nencapsulate this Component.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong>'div'</strong>. The more complex Sencha classes use a more\ncomplex DOM structure specified by their own <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a>s.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components encapsulated by\ndifferent DOM elements. Example usage:</p>\n\n<pre><code>{\n    xtype: 'component',\n    autoEl: {\n        tag: 'img',\n        src: 'http://www.example.com/example.jpg'\n    }\n}, {\n    xtype: 'component',\n    autoEl: {\n        tag: 'blockquote',\n        html: 'autoEl is cool!'\n    }\n}, {\n    xtype: 'container',\n    autoEl: 'ul',\n    cls: 'ux-unordered-list',\n    items: {\n        xtype: 'component',\n        autoEl: 'li',\n        html: 'First list item'\n    }\n}\n</code></pre>\n"},"autoLoad":{"!doc":"<p>An alias for <a href=\"#!/api/Ext.AbstractComponent-cfg-loader\" rel=\"Ext.AbstractComponent-cfg-loader\" class=\"docClass\">loader</a> config which also allows to specify just a string which will be\nused as the url that's automatically loaded:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    autoLoad: 'content.html',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>()\n});\n</code></pre>\n\n<p>The above is the same as:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    loader: {\n        url: 'content.html',\n        autoLoad: true\n    },\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>()\n});\n</code></pre>\n\n<p>Don't use it together with <a href=\"#!/api/Ext.AbstractComponent-cfg-loader\" rel=\"Ext.AbstractComponent-cfg-loader\" class=\"docClass\">loader</a> config.</p>\n"},"autoRender":{"!doc":"<p>This config is intended mainly for non-<a href=\"#!/api/Ext.AbstractComponent-cfg-floating\" rel=\"Ext.AbstractComponent-cfg-floating\" class=\"docClass\">floating</a> Components which may or may not be shown. Instead of using\n<a href=\"#!/api/Ext.AbstractComponent-cfg-renderTo\" rel=\"Ext.AbstractComponent-cfg-renderTo\" class=\"docClass\">renderTo</a> in the configuration, and rendering upon construction, this allows a Component to render itself\nupon first <em><a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a></em>. If <a href=\"#!/api/Ext.AbstractComponent-cfg-floating\" rel=\"Ext.AbstractComponent-cfg-floating\" class=\"docClass\">floating</a> is <code>true</code>, the value of this config is omitted as if it is <code>true</code>.</p>\n\n<p>Specify as <code>true</code> to have this Component render to the document body upon first show.</p>\n\n<p>Specify as an element, or the ID of an element to have this Component render to a specific element upon first\nshow.</p>\n"},"autoShow":{"!type":"bool","!doc":"<p><code>true</code> to automatically show the component upon creation. This config option may only be used for\n<a href=\"#!/api/Ext.AbstractComponent-cfg-floating\" rel=\"Ext.AbstractComponent-cfg-floating\" class=\"docClass\">floating</a> components or components that use <a href=\"#!/api/Ext.AbstractComponent-cfg-autoRender\" rel=\"Ext.AbstractComponent-cfg-autoRender\" class=\"docClass\">autoRender</a>.</p>\n"},"baseCls":{"!type":"string","!doc":"<p>The base CSS class to apply to this component's element. This will also be prepended to elements within this\ncomponent like Panel's body will get a class <code>x-panel-body</code>. This means that if you create a subclass of Panel, and\nyou want it to get all the Panels styling for the element and the body, you leave the <code>baseCls</code> <code>x-panel</code> and use\n<code>componentCls</code> to add specific styling for this component.</p>\n"},"border":{"!doc":"<p>Specifies the border size for this component. The border can be a single numeric value to apply to all sides or it can\nbe a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n\n<p>For components that have no border by default, setting this won't make the border appear by itself.\nYou also need to specify border color and style:</p>\n\n<pre><code>border: 5,\nstyle: {\n    borderColor: 'red',\n    borderStyle: 'solid'\n}\n</code></pre>\n\n<p>To turn off the border, use <code>border: false</code>.</p>\n"},"childEls":{"!doc":"<p>An array describing the child elements of the Component. Each member of the array\nis an object with these properties:</p>\n\n<ul>\n<li><code>name</code> - The property name on the Component for the child element.</li>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the child element.</li>\n<li><code>id</code> - The id of the child element.</li>\n</ul>\n\n\n<p>If the array member is a string, it is equivalent to <code>{ name: m, itemId: m }</code>.</p>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>A more flexible, but somewhat slower, approach is <a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a>.</p>\n"},"cls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element. This can be useful\nfor adding customized styles to the component or any of its children using standard CSS rules.</p>\n"},"componentCls":{"!type":"string","!doc":"<p>CSS Class to be added to a components root level element to give distinction to it via styling.</p>\n"},"componentLayout":{"!doc":"<p>The sizing and positioning of a Component's internal Elements is the responsibility of the Component's layout\nmanager which sizes a Component's internal structure in response to the Component being sized.</p>\n\n<p>Generally, developers will not use this configuration as all provided Components which need their internal\nelements sizing (Such as <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">input fields</a>) come with their own componentLayout managers.</p>\n\n<p>The <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used on instances of the base <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nclass which simply sizes the Component's encapsulating element to the height and width specified in the\n<a href=\"#!/api/Ext.AbstractComponent-method-setSize\" rel=\"Ext.AbstractComponent-method-setSize\" class=\"docClass\">setSize</a> method.</p>\n"},"contentEl":{"!type":"string","!doc":"<p>Specify an existing HTML element, or the <code>id</code> of an existing HTML element to use as the content for this component.</p>\n\n<p>This config option is used to take an existing HTML element and place it in the layout element of a new component\n(it simply moves the specified DOM element <em>after the Component is rendered</em> to use as the content.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>The specified HTML element is appended to the layout element of the component <em>after any configured\n<a href=\"#!/api/Ext.AbstractComponent-cfg-html\" rel=\"Ext.AbstractComponent-cfg-html\" class=\"docClass\">HTML</a> has been inserted</em>, and so the document will not contain this element at the time\nthe <a href=\"#!/api/Ext.AbstractComponent-event-render\" rel=\"Ext.AbstractComponent-event-render\" class=\"docClass\">render</a> event is fired.</p>\n\n<p>The specified HTML element used will not participate in any <strong><code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code></strong>\nscheme that the Component may use. It is just HTML. Layouts operate on child\n<strong><code><a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a></code></strong>.</p>\n\n<p>Add either the <code>x-hidden</code> or the <code>x-hide-display</code> CSS class to prevent a brief flicker of the content before it\nis rendered to the panel.</p>\n"},"data":{"!doc":"<p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.AbstractComponent-cfg-tpl\" rel=\"Ext.AbstractComponent-cfg-tpl\" class=\"docClass\">tpl</a></code> to update the content area of the Component.</p>\n"},"disabled":{"!type":"bool","!doc":"<p><code>true</code> to disable the component.</p>\n"},"disabledCls":{"!type":"string","!doc":"<p>CSS class to add when the Component is disabled.</p>\n"},"draggable":{"!type":"bool","!doc":"<p>Indicates whether or not the component can be dragged.</p>\n"},"floating":{"!type":"bool","!doc":"<p>Create the Component as a floating and use absolute positioning.</p>\n\n<p>The z-index of floating Components is handled by a ZIndexManager. If you simply render a floating Component into the DOM, it will be managed\nby the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">WindowManager</a>.</p>\n\n<p>If you include a floating Component as a child item of a Container, then upon render, Ext JS will seek an ancestor floating Component to house a new\nZIndexManager instance to manage its descendant floaters. If no floating ancestor can be found, the global WindowManager will be used.</p>\n\n<p>When a floating Component which has a ZindexManager managing descendant floaters is destroyed, those descendant floaters will also be destroyed.</p>\n"},"frame":{"!type":"bool","!doc":"<p>Specify as <code>true</code> to have the Component inject framing elements within the Component at render time to provide a\ngraphical rounded frame around the Component content.</p>\n\n<p>This is only necessary when running on outdated, or non standard-compliant browsers such as Microsoft's Internet\nExplorer prior to version 9 which do not support rounded corners natively.</p>\n\n<p>The extra space taken up by this framing is available from the read only property <a href=\"#!/api/Ext.AbstractComponent-property-frameSize\" rel=\"Ext.AbstractComponent-property-frameSize\" class=\"docClass\">frameSize</a>.</p>\n"},"height":{"!type":"number","!doc":"<p>The height of this component in pixels.</p>\n"},"hidden":{"!type":"bool","!doc":"<p><code>true</code> to hide the component.</p>\n"},"hideMode":{"!type":"string","!doc":"<p>A String which specifies how this Component's encapsulating DOM element will be hidden. Values may be:</p>\n\n<ul>\n<li><code>'display'</code> : The Component will be hidden using the <code>display: none</code> style.</li>\n<li><code>'visibility'</code> : The Component will be hidden using the <code>visibility: hidden</code> style.</li>\n<li><code>'offsets'</code> : The Component will be hidden by absolutely positioning it out of the visible area of the document.\nThis is useful when a hidden Component must maintain measurable dimensions. Hiding using <code>display</code> results in a\nComponent having zero dimensions.</li>\n</ul>\n\n"},"html":{"!doc":"<p>An HTML fragment, or a <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> specification to use as the layout element content.\nThe HTML content is added after the component is rendered, so the document will not contain this HTML at the time\nthe <a href=\"#!/api/Ext.AbstractComponent-event-render\" rel=\"Ext.AbstractComponent-event-render\" class=\"docClass\">render</a> event is fired. This content is inserted into the body <em>before</em> any configured <a href=\"#!/api/Ext.AbstractComponent-cfg-contentEl\" rel=\"Ext.AbstractComponent-cfg-contentEl\" class=\"docClass\">contentEl</a>\nis appended.</p>\n"},"id":{"!type":"string","!doc":"<p>The <strong>unique id of this component instance.</strong></p>\n\n<p>It should not be necessary to use this configuration except for singleton objects in your application. Components\ncreated with an <code>id</code> may be accessed globally using <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>.</p>\n\n<p>Instead of using assigned ids, use the <a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a> config, and <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a>\nwhich provides selector-based searching for Sencha Components analogous to DOM querying. The <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> class contains <a href=\"#!/api/Ext.container.Container-method-down\" rel=\"Ext.container.Container-method-down\" class=\"docClass\">shortcut methods</a> to query\nits descendant Components by selector.</p>\n\n<p>Note that this <code>id</code> will also be used as the element id for the containing HTML element that is rendered to the\npage for this component. This allows you to write id-based CSS rules to style the specific instance of this\ncomponent uniquely, and also to select sub-elements using this component's <code>id</code> as the parent.</p>\n\n<p><strong>Note:</strong> To avoid complications imposed by a unique <code>id</code> also see <code><a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a></code>.</p>\n\n<p><strong>Note:</strong> To access the container of a Component see <code><a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n<p>Defaults to an <a href=\"#!/api/Ext.AbstractComponent-method-getId\" rel=\"Ext.AbstractComponent-method-getId\" class=\"docClass\">auto-assigned id</a>.</p>\n"},"itemId":{"!type":"string","!doc":"<p>An <code>itemId</code> can be used as an alternative way to get a reference to a component when no object reference is\navailable. Instead of using an <code><a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a></code> with <a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>, use <code>itemId</code> with\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a> which will retrieve\n<code>itemId</code>'s or <a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a>'s. Since <code>itemId</code>'s are an index to the container's internal MixedCollection, the\n<code>itemId</code> is scoped locally to the container -- avoiding potential conflicts with <a href=\"#!/api/Ext.ComponentManager\" rel=\"Ext.ComponentManager\" class=\"docClass\">Ext.ComponentManager</a>\nwhich requires a <strong>unique</strong> <code><a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a></code>.</p>\n\n<pre><code>var c = new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({ //\n    <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 300,\n    <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTo\" rel=\"Ext.AbstractComponent-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>: 'auto',\n    <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a>: [\n        {\n            itemId: 'p1',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 1',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        },\n        {\n            itemId: 'p2',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 2',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        }\n    ]\n})\np1 = c.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p1'); // not the same as <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp()</a>\np2 = p1.<a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a>.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p2'); // reference via a sibling\n</code></pre>\n\n<p>Also see <a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a>, <code><a href=\"#!/api/Ext.container.Container-method-query\" rel=\"Ext.container.Container-method-query\" class=\"docClass\">Ext.container.Container.query</a></code>, <code><a href=\"#!/api/Ext.container.Container-method-down\" rel=\"Ext.container.Container-method-down\" class=\"docClass\">Ext.container.Container.down</a></code> and\n<code><a href=\"#!/api/Ext.container.Container-method-child\" rel=\"Ext.container.Container-method-child\" class=\"docClass\">Ext.container.Container.child</a></code>.</p>\n\n<p><strong>Note</strong>: to access the container of an item see <a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a>.</p>\n"},"loader":{"!doc":"<p>A configuration object or an instance of a <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> to load remote content\nfor this Component.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    loader: {\n        url: 'content.html',\n        autoLoad: true\n    },\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>()\n});\n</code></pre>\n"},"margin":{"!doc":"<p>Specifies the margin for this component. The margin can be a single numeric value to apply to all sides or it can\nbe a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n"},"maxHeight":{"!type":"number","!doc":"<p>The maximum value in pixels which this Component will set its height to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n"},"maxWidth":{"!type":"number","!doc":"<p>The maximum value in pixels which this Component will set its width to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n"},"minHeight":{"!type":"number","!doc":"<p>The minimum value in pixels which this Component will set its height to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n"},"minWidth":{"!type":"number","!doc":"<p>The minimum value in pixels which this Component will set its width to.</p>\n\n<p><strong>Warning:</strong> This will override any size management applied by layout managers.</p>\n"},"overCls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element when the mouse moves over the Element,\nand removed when the mouse moves out. This can be useful for adding customized 'active' or 'hover' styles to the\ncomponent or any of its children using standard CSS rules.</p>\n"},"padding":{"!doc":"<p>Specifies the padding for this component. The padding can be a single numeric value to apply to all sides or it\ncan be a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n"},"plugins":{"!doc":"<p>An array of plugins to be added to this component. Can also be just a single plugin instead of array.</p>\n\n<p>Plugins provide custom functionality for a component. The only requirement for\na valid plugin is that it contain an <code>init</code> method that accepts a reference of type <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>. When a component\nis created, if any plugins are available, the component will call the init method on each plugin, passing a\nreference to itself. Each plugin can then call methods or respond to events on the component as needed to provide\nits functionality.</p>\n\n<p>Plugins can be added to component by either directly referencing the plugin instance:</p>\n\n<pre><code>plugins: [<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.grid.plugin.CellEditing\" rel=\"Ext.grid.plugin.CellEditing\" class=\"docClass\">Ext.grid.plugin.CellEditing</a>', {clicksToEdit: 1})],\n</code></pre>\n\n<p>By using config object with ptype:</p>\n\n<pre><code>plugins: [{ptype: 'cellediting', clicksToEdit: 1}],\n</code></pre>\n\n<p>Or with just a ptype:</p>\n\n<pre><code>plugins: ['cellediting', 'gridviewdragdrop'],\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.enums.Plugin\" rel=\"Ext.enums.Plugin\" class=\"docClass\">Ext.enums.Plugin</a> for list of all ptypes.</p>\n"},"renderData":{"!doc":"<p>The data used by <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a> in addition to the following property values of the component:</p>\n\n<ul>\n<li>id</li>\n<li>ui</li>\n<li>uiCls</li>\n<li>baseCls</li>\n<li>componentCls</li>\n<li>frame</li>\n</ul>\n\n\n<p>See <a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> for usage examples.</p>\n"},"renderSelectors":{"!doc":"<p>An object containing properties specifying <a href=\"#!/api/Ext.dom.Query\" rel=\"Ext.dom.Query\" class=\"docClass\">DomQuery</a> selectors which identify child elements\ncreated by the render process.</p>\n\n<p>After the Component's internal structure is rendered according to the <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a>, this object is iterated through,\nand the found Elements are added as properties to the Component using the <code>renderSelector</code> property name.</p>\n\n<p>For example, a Component which renders a title and description into its element:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    renderTpl: [\n        '&lt;h1 class=\"title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{desc}&lt;/p&gt;'\n    ],\n    renderData: {\n        title: \"Error\",\n        desc: \"Something went wrong\"\n    },\n    renderSelectors: {\n        titleEl: 'h1.title',\n        descEl: 'p'\n    },\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a titleEl and descEl properties\n            cmp.titleEl.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>For a faster, but less flexible, alternative that achieves the same end result (properties for child elements on the\nComponent after render), see <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> and <a href=\"#!/api/Ext.AbstractComponent-method-addChildEls\" rel=\"Ext.AbstractComponent-method-addChildEls\" class=\"docClass\">addChildEls</a>.</p>\n"},"renderTo":{"!doc":"<p>Specify the <code>id</code> of the element, a DOM element or an existing Element that this component will be rendered into.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>Do <em>not</em> use this option if the Component is to be a child item of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>.\nIt is the responsibility of the <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>'s\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout manager</a> to render and manage its child items.</p>\n\n<p>When using this config, a call to <code>render()</code> is not required.</p>\n\n<p>See also: <a href=\"#!/api/Ext.AbstractComponent-method-render\" rel=\"Ext.AbstractComponent-method-render\" class=\"docClass\">render</a>.</p>\n"},"renderTpl":{"!doc":"<p>An <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">XTemplate</a> used to create the internal structure inside this Component's encapsulating\n<a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a>.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong><code>null</code></strong> which means that they will be initially rendered\nwith no internal structure; they render their <a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a> empty. The more specialized Ext JS and Sencha Touch\nclasses which use a more complex DOM structure, provide their own template definitions.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components with customized\ninternal structure.</p>\n\n<p>Upon rendering, any created child elements may be automatically imported into object properties using the\n<a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> options.</p>\n"},"rtl":{"!type":"bool","!doc":"<p>True to layout this component and its descendants in \"rtl\" (right-to-left) mode.\nCan be explicitly set to false to override a true value inherited from an ancestor.</p>\n\n<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"shrinkWrap":{"!doc":"<p>If this property is a number, it is interpreted as follows:</p>\n\n<ul>\n<li>0: Neither width nor height depend on content. This is equivalent to <code>false</code>.</li>\n<li>1: Width depends on content (shrink wraps), but height does not.</li>\n<li>2: Height depends on content (shrink wraps), but width does not. The default.</li>\n<li>3: Both width and height depend on content (shrink wrap). This is equivalent to <code>true</code>.</li>\n</ul>\n\n\n<p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed\nto a block-level element. Some container layouts always shrink-wrap their children,\neffectively ignoring this property (e.g., <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">Ext.layout.container.HBox</a>,\n<a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">Ext.layout.container.VBox</a>, <a href=\"#!/api/Ext.layout.component.Dock\" rel=\"Ext.layout.component.Dock\" class=\"docClass\">Ext.layout.component.Dock</a>).</p>\n"},"style":{"!doc":"<p>A custom style specification to be applied to this component's Element. Should be a valid argument to\n<a href=\"#!/api/Ext.dom.Element-method-applyStyles\" rel=\"Ext.dom.Element-method-applyStyles\" class=\"docClass\">Ext.Element.applyStyles</a>.</p>\n\n<pre><code>new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    title: 'Some Title',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    width: 400, height: 300,\n    layout: 'form',\n    items: [{\n        xtype: 'textarea',\n        style: {\n            width: '95%',\n            marginBottom: '10px'\n        }\n    },\n    new <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>({\n        text: 'Send',\n        minWidth: '100',\n        style: {\n            marginBottom: '10px'\n        }\n    })\n    ]\n});\n</code></pre>\n"},"tpl":{"!doc":"<p>An <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a>, <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a> or an array of strings to form an <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>. Used in\nconjunction with the <code><a href=\"#!/api/Ext.AbstractComponent-cfg-data\" rel=\"Ext.AbstractComponent-cfg-data\" class=\"docClass\">data</a></code> and <code><a href=\"#!/api/Ext.AbstractComponent-cfg-tplWriteMode\" rel=\"Ext.AbstractComponent-cfg-tplWriteMode\" class=\"docClass\">tplWriteMode</a></code> configurations.</p>\n"},"tplWriteMode":{"!type":"string","!doc":"<p>The Ext.(X)Template method to use when updating the content area of the Component.\nSee <code><a href=\"#!/api/Ext.XTemplate-method-overwrite\" rel=\"Ext.XTemplate-method-overwrite\" class=\"docClass\">Ext.XTemplate.overwrite</a></code> for information on default mode.</p>\n"},"ui":{"!type":"string","!doc":"<p>A UI style for a component.</p>\n"},"uiCls":{"!doc":"<p>An array of of <code>classNames</code> which are currently applied to this component.</p>\n"},"width":{"!type":"number","!doc":"<p>The width of this component in pixels.</p>\n"},"xtype":{"!doc":"<p>This property provides a shorter alternative to creating objects than using a full\nclass name. Using <code>xtype</code> is the most common way to define component instances,\nespecially in a container. For example, the items in a form containing text fields\ncould be created explicitly like so:</p>\n\n<pre><code> items: [\n     <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n         fieldLabel: 'Foo'\n     }),\n     <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n         fieldLabel: 'Bar'\n     }),\n     <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.field.Number\" rel=\"Ext.form.field.Number\" class=\"docClass\">Ext.form.field.Number</a>', {\n         fieldLabel: 'Num'\n     })\n ]\n</code></pre>\n\n<p>But by using <code>xtype</code>, the above becomes:</p>\n\n<pre><code> items: [\n     {\n         xtype: 'textfield',\n         fieldLabel: 'Foo'\n     },\n     {\n         xtype: 'textfield',\n         fieldLabel: 'Bar'\n     },\n     {\n         xtype: 'numberfield',\n         fieldLabel: 'Num'\n     }\n ]\n</code></pre>\n\n<p>When the <code>xtype</code> is common to many items, <a href=\"#!/api/Ext.container.AbstractContainer-cfg-defaultType\" rel=\"Ext.container.AbstractContainer-cfg-defaultType\" class=\"docClass\">Ext.container.AbstractContainer.defaultType</a>\nis another way to specify the <code>xtype</code> for all items that don't have an explicit <code>xtype</code>:</p>\n\n<pre><code> defaultType: 'textfield',\n items: [\n     { fieldLabel: 'Foo' },\n     { fieldLabel: 'Bar' },\n     { fieldLabel: 'Num', xtype: 'numberfield' }\n ]\n</code></pre>\n\n<p>Each member of the <code>items</code> array is now just a \"configuration object\". These objects\nare used to create and configure component instances. A configuration object can be\nmanually used to instantiate a component using <a href=\"#!/api/Ext-method-widget\" rel=\"Ext-method-widget\" class=\"docClass\">Ext.widget</a>:</p>\n\n<pre><code> var text1 = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n     fieldLabel: 'Foo'\n });\n\n // or alternatively:\n\n var text1 = <a href=\"#!/api/Ext-method-widget\" rel=\"Ext-method-widget\" class=\"docClass\">Ext.widget</a>({\n     xtype: 'textfield',\n     fieldLabel: 'Foo'\n });\n</code></pre>\n\n<p>This conversion of configuration objects into instantiated components is done when\na container is created as part of its {<a href=\"#!/api/Ext.container.AbstractContainer-method-initComponent\" rel=\"Ext.container.AbstractContainer-method-initComponent\" class=\"docClass\">Ext.container.AbstractContainer.initComponent</a>}\nprocess. As part of the same process, the <code>items</code> array is converted from its raw\narray form into a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a> instance.</p>\n\n<p>You can define your own <code>xtype</code> on a custom <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">component</a> by specifying\nthe <code>xtype</code> property in <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>. For example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.PressMeButton', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n    xtype: 'pressmebutton',\n    text: 'Press Me'\n});\n</code></pre>\n\n<p>Care should be taken when naming an <code>xtype</code> in a custom component because there is\na single, shared scope for all xtypes. Third part components should consider using\na prefix to avoid collisions.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Foo.form.CoolButton', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n    xtype: 'ux-coolbutton',\n    text: 'Cool!'\n});\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.enums.Widget\" rel=\"Ext.enums.Widget\" class=\"docClass\">Ext.enums.Widget</a> for list of all available xtypes.</p>\n"},"_isLayoutRoot":{"!type":"bool","!doc":"<p>Setting this property to <code>true</code> causes the <a href=\"#!/api/Ext.AbstractComponent-method-isLayoutRoot\" rel=\"Ext.AbstractComponent-method-isLayoutRoot\" class=\"docClass\">isLayoutRoot</a> method to return\n<code>true</code> and stop the search for the top-most component for a layout.</p>\n"},"allowDomMove":{"!type":"bool"},"autoGenId":{"!type":"bool","!doc":"<p><code>true</code> indicates an <code>id</code> was auto-generated rather than provided by configuration.</p>\n"},"borderBoxCls":{"!type":"string","!doc":"<p>private</p>\n"},"componentLayoutCounter":{"!type":"number","!doc":"<p>The number of component layout calls made on this object.</p>\n"},"contentPaddingProperty":{"!type":"string","!doc":"<p>The name of the padding property that is used by the layout to manage\npadding.  See <a href=\"#!/api/Ext.layout.container.Auto-property-managePadding\" rel=\"Ext.layout.container.Auto-property-managePadding\" class=\"docClass\">managePadding</a></p>\n"},"deferLayouts":{"!type":"bool"},"frameElementsArray":{},"frameSize":{"!doc":"<p>Indicates the width of any framing elements which were added within the encapsulating\nelement to provide graphical, rounded borders. See the <a href=\"#!/api/Ext.AbstractComponent-cfg-frame\" rel=\"Ext.AbstractComponent-cfg-frame\" class=\"docClass\">frame</a> config. This\nproperty is <code>null</code> if the component is not framed.</p>\n\n<p>This is an object containing the frame width in pixels for all four sides of the\nComponent containing the following properties:</p>\n"},"horizontalPosProp":{"!type":"string"},"isComponent":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Component, or subclass thereof.</p>\n"},"layoutSuspendCount":{"!type":"number"},"maskOnDisable":{"!type":"bool","!doc":"<p>This is an internal flag that you use when creating custom components. By default this is set to <code>true</code> which means\nthat every component gets a mask when it's disabled. Components like FieldContainer, FieldSet, Field, Button, Tab\noverride this property to <code>false</code> since they want to implement custom disable logic.</p>\n"},"ownerCt":{"!doc":"<p>This Component's owner <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> (is set automatically\nwhen this Component is added to a Container).</p>\n\n<p><em>Important.</em> This is not a universal upwards navigation pointer. It indicates the Container which owns and manages\nthis Component if any. There are other similar relationships such as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by the <a href=\"#!/api/Ext.AbstractComponent-method-up\" rel=\"Ext.AbstractComponent-method-up\" class=\"docClass\">up</a> method.</p>\n\n<p><strong>Note</strong>: to access items within the Container see <a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a>.</p>\n"},"rendered":{"!type":"bool","!doc":"<p>Indicates whether or not the component has been rendered.</p>\n"},"weight":{"!type":"number"},"AUTO_ID":{"!type":"number"},"pendingLayouts":{},"addClass":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the top level element representing this component.</p>\n"},"addCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the top level element representing this component.</p>\n"},"addClsWithUI":{"!type":"fn(classes: ?, skip: ?) -> !this","!doc":"<p>Adds a <code>cls</code> to the <code>uiCls</code> array, which will also call <a href=\"#!/api/Ext.AbstractComponent-method-addUIClsToElement\" rel=\"Ext.AbstractComponent-method-addUIClsToElement\" class=\"docClass\">addUIClsToElement</a> and adds to all elements of this\ncomponent.</p>\n"},"addFocusListener":{"!type":"fn() -> !this","!doc":"<p>Sets up the focus listener on this Component's <a href=\"#!/api/Ext.AbstractComponent-method-getFocusEl\" rel=\"Ext.AbstractComponent-method-getFocusEl\" class=\"docClass\">focusEl</a> if it has one.</p>\n\n<p>Form Components which must implicitly participate in tabbing order usually have a naturally focusable\nelement as their <a href=\"#!/api/Ext.AbstractComponent-method-getFocusEl\" rel=\"Ext.AbstractComponent-method-getFocusEl\" class=\"docClass\">focusEl</a>, and it is the DOM event of that receiving focus which drives\nthe Component's <code>onFocus</code> handling, and the DOM event of it being blurred which drives the <code>onBlur</code> handling.</p>\n\n<p>If the <a href=\"#!/api/Ext.AbstractComponent-method-getFocusEl\" rel=\"Ext.AbstractComponent-method-getFocusEl\" class=\"docClass\">focusEl</a> is <strong>not</strong> naturally focusable, then the listeners are only added\nif the <a href=\"#!/api/Ext.FocusManager\" rel=\"Ext.FocusManager\" class=\"docClass\">FocusManager</a> is enabled.</p>\n"},"addListener":{"!type":"fn(element: ?, listeners: ?, scope: ?, options: ?) -> ?","!doc":"<p>Appends an event handler to this object.  For example:</p>\n\n<pre><code>myGridPanel.on(\"mouseover\", this.onMouseOver, this);\n</code></pre>\n\n<p>The method also allows for a single argument to be passed which is a config object\ncontaining properties which specify multiple events. For example:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: this.onCellClick,\n    mouseover: this.onMouseOver,\n    mouseout: this.onMouseOut,\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n<p>One can also specify options for each event handler separately:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: this.onCellClick, scope: this, single: true},\n    mouseover: {fn: panel.onMouseOver, scope: panel}\n});\n</code></pre>\n\n<p><em>Names</em> of methods in a specified scope may also be used. Note that\n<code>scope</code> MUST be specified to use this option:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: 'onCellClick', scope: this, single: true},\n    mouseover: {fn: 'onMouseOver', scope: panel}\n});\n</code></pre>\n"},"addOverCls":{"!type":"fn() -> !this","!doc":"<p></p>\n"},"addPlugin":{"!type":"fn(plugin: ?) -> !this","!doc":"<p>Adds a plugin. May be called at any time in the component's lifecycle.</p>\n"},"addPropertyToState":{"!type":"fn(state: ?, propName: ?, value?: ?) -> bool","!doc":"<p>Save a property to the given state object if it is not its default or configured\nvalue.</p>\n"},"addUIClsToElement":{"!type":"fn(ui: ?) -> !this","!doc":"<p>Method which adds a specified UI + <code>uiCls</code> to the components element. Can be overridden to remove the UI from more\nthan just the components element.</p>\n"},"addUIToElement":{"!type":"fn() -> !this","!doc":"<p>Method which adds a specified UI to the components element.</p>\n"},"afterComponentLayout":{"!type":"fn(width: ?, height: ?, oldWidth: ?, oldHeight: ?) -> !this","!doc":"<p>Called by the layout system after the Component has been laid out.</p>\n"},"afterSetPosition":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Template method called after a Component has been positioned.</p>\n"},"animate":{"!type":"fn(animObj: ?) -> ?","!doc":"<p>Performs custom animation on this object.</p>\n\n<p>This method is applicable to both the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> class and the <a href=\"#!/api/Ext.draw.Sprite\" rel=\"Ext.draw.Sprite\" class=\"docClass\">Sprite</a>\nclass. It performs animated transitions of certain properties of this object over a specified timeline.</p>\n\n<h3>Animating a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a></h3>\n\n<p>When animating a Component, the following properties may be specified in <code>from</code>, <code>to</code>, and <code>keyframe</code> objects:</p>\n\n<ul>\n<li><p><code>x</code> - The Component's page X position in pixels.</p></li>\n<li><p><code>y</code> - The Component's page Y position in pixels</p></li>\n<li><p><code>left</code> - The Component's <code>left</code> value in pixels.</p></li>\n<li><p><code>top</code> - The Component's <code>top</code> value in pixels.</p></li>\n<li><p><code>width</code> - The Component's <code>width</code> value in pixels.</p></li>\n<li><p><code>height</code> - The Component's <code>height</code> value in pixels.</p></li>\n<li><p><code>dynamic</code> - Specify as true to update the Component's layout (if it is a Container) at every frame of the animation.\n<em>Use sparingly as laying out on every intermediate size change is an expensive operation.</em></p></li>\n</ul>\n\n\n<p>For example, to animate a Window to a new size, ensuring that its internal layout and any shadow is correct:</p>\n\n<pre><code>myWindow = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>', {\n    title: 'Test Component animation',\n    width: 500,\n    height: 300,\n    layout: {\n        type: 'hbox',\n        align: 'stretch'\n    },\n    items: [{\n        title: 'Left: 33%',\n        margins: '5 0 5 5',\n        flex: 1\n    }, {\n        title: 'Left: 66%',\n        margins: '5 5 5 5',\n        flex: 2\n    }]\n});\nmyWindow.show();\nmyWindow.header.el.on('click', function() {\n    myWindow.animate({\n        to: {\n            width: (myWindow.getWidth() == 500) ? 700 : 500,\n            height: (myWindow.getHeight() == 300) ? 400 : 300\n        }\n    });\n});\n</code></pre>\n\n<p>For performance reasons, by default, the internal layout is only updated when the Window reaches its final <code>\"to\"</code>\nsize. If dynamic updating of the Window's child Components is required, then configure the animation with\n<code>dynamic: true</code> and the two child items will maintain their proportions during the animation.</p>\n"},"beforeBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any pre-blur processing.</p>\n"},"beforeComponentLayout":{"!type":"fn(adjWidth: ?, adjHeight: ?) -> !this","!doc":"<p>Occurs before <code>componentLayout</code> is run. Returning <code>false</code> from this method will prevent the <code>componentLayout</code> from\nbeing executed.</p>\n"},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"beforeFocus":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any pre-focus processing.</p>\n"},"beforeLayout":{"!type":"fn() -> !this","!doc":"<p>Occurs before componentLayout is run. In previous releases, this method could\nreturn <code>false</code> to prevent its layout but that is not supported in Ext JS 4.1 or\nhigher. This method is simply a notification of the impending layout to give the\ncomponent a chance to adjust the DOM. Ideally, DOM reads should be avoided at this\ntime to reduce expensive document reflows.</p>\n"},"beforeSetPosition":{"!type":"fn(x: ?, y: ?, animate: ?) -> !this","!doc":"<p>Template method called before a Component is positioned.</p>\n\n<p>Ensures that the position is adjusted so that the Component is constrained if so configured.</p>\n"},"constructPlugin":{"!type":"fn(ptype: ?) -> !this"},"constructPlugins":{"!type":"fn() -> !this","!doc":"<p>Returns an array of fully constructed plugin instances. This converts any configs into their\nappropriate instances.</p>\n\n<p>It does not mutate the plugins array. It creates a new array.</p>\n"},"convertPositionSpec":{"!type":"fn(posSpec: ?) -> !this","!doc":"<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"destroy":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is <a href=\"#!/api/Ext.AbstractComponent-method-destroy\" rel=\"Ext.AbstractComponent-method-destroy\" class=\"docClass\">destroy</a>ed.</p>\n"},"disable":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is disabled.</p>\n"},"doComponentLayout":{"!type":"fn() -> ?","!doc":"<p>This method needs to be called whenever you change something on this component that requires the Component's\nlayout to be recalculated.</p>\n"},"enable":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is enabled.</p>\n"},"findPlugin":{"!type":"fn(ptype: ?) -> ?","!doc":"<p>Retrieves plugin from this component's collection by its <code>ptype</code>.</p>\n"},"forceComponentLayout":{"!type":"fn() -> !this","!doc":"<p>Forces this component to redo its componentLayout.</p>\n"},"getAnchorToXY":{"!type":"fn(el: ?, anchor?: ?, local?: ?, size?: ?) -> ?","!doc":"<hr />\n\n<p> Begin Positionable methods</p>\n\n<hr />\n\n<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"getAutoId":{"!type":"fn() -> !this"},"getBorderPadding":{"!type":"fn() -> ?","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"getBubbleTarget":{"!type":"fn() -> ?","!doc":"<p>Provides the link for Observable's <code>fireEvent</code> method to bubble up the ownership hierarchy.</p>\n"},"getComponentLayout":{"!type":"fn() -> !this"},"getEl":{"!type":"fn() -> ?","!doc":"<p>Retrieves the top level element representing this component.</p>\n"},"getFocusEl":{"!type":"fn() -> ?","!doc":"<p>Returns the focus holder element associated with this Component. At the Component base class level, this function returns <code>undefined</code>.</p>\n\n<p>Subclasses which use embedded focusable elements (such as Window, Field and Button) should override this\nfor use by the <a href=\"#!/api/Ext.Component-method-focus\" rel=\"Ext.Component-method-focus\" class=\"docClass\">focus</a> method.</p>\n\n<p>Containers which need to participate in the <a href=\"#!/api/Ext.FocusManager\" rel=\"Ext.FocusManager\" class=\"docClass\">FocusManager</a>'s navigation and Container focusing scheme also\nneed to return a <code>focusEl</code>, although focus is only listened for in this case if the <a href=\"#!/api/Ext.FocusManager\" rel=\"Ext.FocusManager\" class=\"docClass\">FocusManager</a> is <a href=\"#!/api/Ext.FocusManager-method-enable\" rel=\"Ext.FocusManager-method-enable\" class=\"docClass\">enable</a>d.</p>\n"},"getHeight":{"!type":"fn() -> number","!doc":"<p>Gets the current height of the component's underlying element.</p>\n"},"getHierarchyState":{"!type":"fn(inner: ?) -> !this","!doc":"<p>A component's hierarchyState is used to keep track of aspects of a component's\nstate that affect its descendants hierarchically like \"collapsed\" and \"hidden\".\nFor example, if this.hierarchyState.hidden == true, it means that either this\ncomponent, or one of its ancestors is hidden.</p>\n\n<p>Hierarchical state management is implemented by chaining each component's\nhierarchyState property to its parent container's hierarchyState property via the\nprototype. The result is such that if a component's hierarchyState does not have\nit's own property, it inherits the property from the nearest ancestor that does.</p>\n\n<p>To set a hierarchical \"hidden\" value:</p>\n\n<pre><code>this.getHierarchyState().hidden = true;\n</code></pre>\n\n<p>It is important to remember when unsetting hierarchyState properties to delete\nthem instead of just setting them to a falsy value.  This ensures that the\nhierarchyState returns to a state of inheriting the value instead of overriding it\nTo unset the hierarchical \"hidden\" value:</p>\n\n<pre><code>delete this.getHierarchyState().hidden;\n</code></pre>\n\n<p>IMPORTANT! ALWAYS access hierarchyState using this method, not by accessing\nthis.hierarchyState directly.  The hierarchyState property does not exist until\nthe first time getHierarchyState() is called.  At that point getHierarchyState()\nwalks up the component tree to establish the hierarchyState prototype chain.\nAdditionally the hierarchyState property should NOT be relied upon even after\nthe initial call to getHierarchyState() because  it is possible for the\nhierarchyState to be invalidated. Invalidation typically happens when a component\nis moved to a new container. In such a case the hierarchy state remains invalid\nuntil the next time getHierarchyState() is called on the component or one of its\ndescendants.</p>\n"},"getId":{"!type":"fn() -> string","!doc":"<p>Retrieves the <code>id</code> of this component. Will auto-generate an <code>id</code> if one has not already been set.</p>\n"},"getItemId":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a> assigned to this component, or when that\nis not set, returns the value of <a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a>.</p>\n"},"getLoader":{"!type":"fn() -> ?","!doc":"<p>Gets the <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> for this Component.</p>\n"},"getLocalX":{"!type":"fn() -> number","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"getLocalXY":{"!type":"fn() -> ?","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"getLocalY":{"!type":"fn() -> number","!doc":"<p>Returns the y coordinate of this element reletive to its <code>offsetParent</code>.</p>\n"},"getMaskTarget":{"!type":"fn() -> !this"},"getOverflowEl":{"!type":"fn() -> !this","!doc":"<p>Get an el for overflowing, defaults to the target el</p>\n"},"getOverflowStyle":{"!type":"fn() -> !this","!doc":"<p>Returns the CSS style object which will set the Component's scroll styles. This must be applied\nto the <a href=\"#!/api/Ext.AbstractComponent-method-getTargetEl\" rel=\"Ext.AbstractComponent-method-getTargetEl\" class=\"docClass\">target element</a>.</p>\n"},"getPlugin":{"!type":"fn(pluginId: ?) -> ?","!doc":"<p>Retrieves a plugin from this component's collection by its <code>pluginId</code>.</p>\n"},"getSize":{"!type":"fn() -> ?","!doc":"<p>Gets the current size of the component's underlying element.</p>\n"},"getSizeModel":{"!type":"fn(ownerCtSizeModel: ?) -> ?","!doc":"<p>Returns an object that describes how this component's width and height are managed.\nAll of these objects are shared and should not be modified.</p>\n"},"getState":{"!type":"fn() -> ?","!doc":"<p>The supplied default state gathering method for the AbstractComponent class.</p>\n\n<p>This method returns dimension settings such as <code>flex</code>, <code>anchor</code>, <code>width</code> and <code>height</code> along with <code>collapsed</code>\nstate.</p>\n\n<p>Subclasses which implement more complex state should call the superclass's implementation, and apply their state\nto the result if this basic state is to be saved.</p>\n\n<p>Note that Component state will only be saved if the Component has a <a href=\"#!/api/Ext.AbstractComponent-cfg-stateId\" rel=\"Ext.AbstractComponent-cfg-stateId\" class=\"docClass\">stateId</a> and there as a StateProvider\nconfigured for the document.</p>\n"},"getTargetEl":{"!type":"fn() -> !this","!doc":"<p>This is used to determine where to insert the 'html', 'contentEl' and 'items' in this component.</p>\n"},"getTpl":{"!type":"fn(name: ?) -> !this"},"getWidth":{"!type":"fn() -> number","!doc":"<p>Gets the current width of the component's underlying element.</p>\n"},"getX":{"!type":"fn() -> number","!doc":"<p>Gets the current X position of the DOM element based on page coordinates.</p>\n"},"getXTypes":{"!type":"fn() -> string","!doc":"<p>Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all available xtypes, see the\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nalert(t.getXTypes());  // alerts 'component/field/textfield'\n</code></pre>\n"},"getXY":{"!type":"fn() -> ?","!doc":"<p>Gets the current position of the DOM element based on page coordinates.</p>\n"},"getY":{"!type":"fn() -> number","!doc":"<p>Gets the current Y position of the DOM element based on page coordinates.</p>\n"},"hasCls":{"!type":"fn(className: ?) -> bool","!doc":"<p>Checks if the specified CSS class exists on this element's DOM node.</p>\n"},"hasUICls":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Checks if there is currently a specified <code>uiCls</code>.</p>\n"},"initCls":{"!type":"fn() -> !this"},"initComponent":{"!type":"fn() -> !this"},"initEvents":{"!type":"fn() -> !this","!doc":"<p>Initialize any events on this component</p>\n"},"initHierarchyState":{"!type":"fn(hierarchyState: ?) -> !this","!doc":"<p>Called by <a href=\"#!/api/Ext.AbstractComponent-method-getHierarchyState\" rel=\"Ext.AbstractComponent-method-getHierarchyState\" class=\"docClass\">getHierarchyState</a> to initialize the hierarchyState the first\ntime it is requested.</p>\n\n<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"initPadding":{"!type":"fn(targetEl: ?) -> !this","!doc":"<p>Initializes padding by applying it to the target element, or if the layout manages\npadding ensures that the padding on the target element is \"0\".</p>\n"},"initPlugin":{"!type":"fn(plugin: ?) -> !this"},"initStyles":{"!type":"fn(targetEl: ?) -> !this","!doc":"<p>Applies padding, margin, border, top, left, height, and width configs to the\nappropriate elements.</p>\n"},"is":{"!type":"fn(selector: ?) -> bool","!doc":"<p>Tests whether this Component matches the selector string.</p>\n"},"isDescendant":{"!type":"fn(ancestor: ?) -> !this"},"isDescendantOf":{"!type":"fn(container: ?) -> bool","!doc":"<p>Determines whether this component is the descendant of a particular container.</p>\n"},"isDisabled":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is currently disabled.</p>\n"},"isDraggable":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is draggable.</p>\n"},"isDroppable":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is droppable.</p>\n"},"isFloating":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is floating.</p>\n"},"isFocusable":{"!type":"fn() -> !this"},"isHidden":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is currently set to hidden.</p>\n"},"isHierarchicallyHidden":{"!type":"fn() -> !this"},"isLayoutRoot":{"!type":"fn() -> !this","!doc":"<p>Determines whether this Component is the root of a layout. This returns <code>true</code> if\nthis component can run its layout without assistance from or impact on its owner.\nIf this component cannot run its layout given these restrictions, <code>false</code> is returned\nand its owner will be considered as the next candidate for the layout root.</p>\n\n<p>Setting the <a href=\"#!/api/Ext.AbstractComponent-property-_isLayoutRoot\" rel=\"Ext.AbstractComponent-property-_isLayoutRoot\" class=\"docClass\">_isLayoutRoot</a> property to <code>true</code> causes this method to always\nreturn <code>true</code>. This may be useful when updating a layout of a Container which shrink\nwraps content, and you know that it will not change size, and so can safely be the\ntopmost participant in the layout run.</p>\n"},"isLayoutSuspended":{"!type":"fn() -> bool","!doc":"<p>Returns <code>true</code> if layout is suspended for this component. This can come from direct\nsuspension of this component's layout activity (<a href=\"#!/api/Ext.container.Container-cfg-suspendLayout\" rel=\"Ext.container.Container-cfg-suspendLayout\" class=\"docClass\">Ext.Container.suspendLayout</a>) or if one\nof this component's containers is suspended.</p>\n"},"isLocalRtl":{"!type":"fn() -> bool","!doc":"<p>Returns true if this component's local coordinate system is rtl. For normal\ncomponents this equates to the value of isParentRtl().  Floaters are a bit different\nbecause a floater's element can be a childNode of something other than its\nparent component's element.  For floaters we have to read the dom to see if the\ncomponent's element's parentNode has a css direction value of \"rtl\".</p>\n\n<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"isOppositeRootDirection":{"!type":"fn() -> !this","!doc":"<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"isParentRtl":{"!type":"fn() -> bool","!doc":"<p>Returns true if this component's parent container is rtl. Used by rtl positioning\nmethods to determine if the component should be positioned using a right-to-left\ncoordinate system.</p>\n\n<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"isVisible":{"!type":"fn(deep?: ?) -> bool","!doc":"<p>Returns <code>true</code> if this component is visible.</p>\n"},"isXType":{"!type":"fn(xtype: ?, shallow?: ?) -> bool","!doc":"<p>Tests whether or not this Component is of a specific xtype. This can test whether this Component is descended\nfrom the xtype (default) or whether it is directly of the xtype specified (<code>shallow = true</code>).</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>For a list of all available xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nvar isText = t.isXType('textfield');        // true\nvar isBoxSubclass = t.isXType('field');       // true, descended from <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>\nvar isBoxInstance = t.isXType('field', true); // false, not a direct <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> instance\n</code></pre>\n"},"mask":{"!type":"fn() -> !this"},"nextNode":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the next node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree to attempt to find a match. Contrast with <a href=\"#!/api/Ext.AbstractComponent-method-nextSibling\" rel=\"Ext.AbstractComponent-method-nextSibling\" class=\"docClass\">nextSibling</a>.</p>\n"},"nextSibling":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the next sibling of this Component.</p>\n\n<p>Optionally selects the next sibling which matches the passed <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selector.</p>\n\n<p>May also be referred to as <strong><code>next()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.AbstractComponent-method-nextNode\" rel=\"Ext.AbstractComponent-method-nextNode\" class=\"docClass\">nextNode</a></p>\n"},"onAdded":{"!type":"fn(container: ?, pos: ?) -> !this","!doc":"<p>Method to manage awareness of when components are added to their\nrespective Container, firing an <a href=\"#!/api/Ext.AbstractComponent-event-added\" rel=\"Ext.AbstractComponent-event-added\" class=\"docClass\">added</a> event. References are\nestablished at add time rather than at render time.</p>\n\n<p>Allows addition of behavior when a Component is added to a\nContainer. At this stage, the Component is in the parent\nContainer's collection of child items. After calling the\nsuperclass's <code>onAdded</code>, the <code>ownerCt</code> reference will be present,\nand if configured with a ref, the <code>refOwner</code> will be set.</p>\n"},"onBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>private</p>\n"},"onBoxReady":{"!type":"fn(width: ?, height: ?) -> !this"},"onDestroy":{"!type":"fn() -> !this"},"onDisable":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the disable operation.\nAfter calling the superclass's <code>onDisable</code>, the Component will be disabled.</p>\n"},"onEnable":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the enable operation.\nAfter calling the superclass's <code>onEnable</code>, the Component will be enabled.</p>\n"},"onFocus":{"!type":"fn(e: ?) -> !this","!doc":"<p>private</p>\n"},"onHide":{"!type":"fn() -> !this"},"onPosition":{"!type":"fn(x: ?, y: ?) -> !this","!doc":"<p>Called after the component is moved, this method is empty by default but can be implemented by any\nsubclass that needs to perform custom logic after a move occurs.</p>\n"},"onRemoved":{"!type":"fn(destroying: ?) -> !this","!doc":"<p>Method to manage awareness of when components are removed from their\nrespective Container, firing a <a href=\"#!/api/Ext.AbstractComponent-event-removed\" rel=\"Ext.AbstractComponent-event-removed\" class=\"docClass\">removed</a> event. References are properly\ncleaned up after removing a component from its owning container.</p>\n\n<p>Allows addition of behavior when a Component is removed from\nits parent Container. At this stage, the Component has been\nremoved from its parent Container's collection of child items,\nbut has not been destroyed (It will be destroyed if the parent\nContainer's <code>autoDestroy</code> is <code>true</code>, or if the remove call was\npassed a truthy second parameter). After calling the\nsuperclass's <code>onRemoved</code>, the <code>ownerCt</code> and the <code>refOwner</code> will not\nbe present.</p>\n"},"onResize":{"!type":"fn(width: ?, height: ?, oldWidth: ?, oldHeight: ?) -> !this","!doc":"<p>Allows addition of behavior to the resize operation.</p>\n\n<p>Called when Ext.resizer.Resizer#drag event is fired.</p>\n"},"onShow":{"!type":"fn() -> !this"},"parseBox":{"!type":"fn(box: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"postBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any post-blur processing.</p>\n"},"previousNode":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the previous node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree in reverse order to attempt to find a match. Contrast with <a href=\"#!/api/Ext.AbstractComponent-method-previousSibling\" rel=\"Ext.AbstractComponent-method-previousSibling\" class=\"docClass\">previousSibling</a>.</p>\n"},"previousSibling":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the previous sibling of this Component.</p>\n\n<p>Optionally selects the previous sibling which matches the passed <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a>\nselector.</p>\n\n<p>May also be referred to as <strong><code>prev()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.AbstractComponent-method-previousNode\" rel=\"Ext.AbstractComponent-method-previousNode\" class=\"docClass\">previousNode</a></p>\n"},"registerFloatingItem":{"!type":"fn(cmp: ?) -> !this","!doc":"<p>Called by Component#doAutoRender</p>\n\n<p>Register a Container configured <code>floating: true</code> with this Component's <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a>.</p>\n\n<p>Components added in this way will not participate in any layout, but will be rendered\nupon first show in the way that <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s are.</p>\n"},"removeClass":{"!type":"fn() -> !this","!doc":"<p><debug></debug></p>\n"},"removeCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes a CSS class from the top level element representing this component.</p>\n"},"removeClsWithUI":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Removes a <code>cls</code> to the <code>uiCls</code> array, which will also call <a href=\"#!/api/Ext.AbstractComponent-method-removeUIClsFromElement\" rel=\"Ext.AbstractComponent-method-removeUIClsFromElement\" class=\"docClass\">removeUIClsFromElement</a> and removes it from all\nelements of this component.</p>\n"},"removeManagedListenerItem":{"!type":"fn(isClear: ?, managedListener: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"removeOverCls":{"!type":"fn() -> !this"},"removePlugin":{"!type":"fn(plugin: ?) -> !this"},"removeUIClsFromElement":{"!type":"fn(ui: ?) -> !this","!doc":"<p>Method which removes a specified UI + <code>uiCls</code> from the components element. The <code>cls</code> which is added to the element\nwill be: <code>this.baseCls + '-' + ui</code>.</p>\n"},"removeUIFromElement":{"!type":"fn() -> !this","!doc":"<p>Method which removes a specified UI from the components element.</p>\n"},"resumeLayouts":{"!type":"fn(flushOptions: ?) -> !this"},"setBorder":{"!type":"fn(border: ?) -> !this"},"setComponentLayout":{"!type":"fn(layout: ?) -> !this"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Enable or disable the component.</p>\n"},"setDocked":{"!type":"fn(dock: ?, layoutParent?: ?) -> ?","!doc":"<p>Sets the dock position of this component in its parent panel. Note that this only has effect if this item is part\nof the <code>dockedItems</code> collection of a parent that has a DockLayout (note that any Panel has a DockLayout by default)</p>\n"},"setHeight":{"!type":"fn(height: ?) -> ?","!doc":"<p>Sets the height of the component. This method fires the <a href=\"#!/api/Ext.AbstractComponent-event-resize\" rel=\"Ext.AbstractComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n"},"setHiddenState":{"!type":"fn(hidden: ?) -> !this"},"setLocalX":{"!type":"fn(x: ?) -> ?","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"setLocalXY":{"!type":"fn(x: ?, y: ?) -> ?","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"setLocalY":{"!type":"fn(y: ?) -> ?","!doc":"<p>Sets the local y coordinate of this element using CSS style. When used on an\nabsolute positioned element this method is symmetrical with <a href=\"#!/api/Ext.AbstractComponent-method-getLocalY\" rel=\"Ext.AbstractComponent-method-getLocalY\" class=\"docClass\">getLocalY</a>, but\nmay not be symmetrical when used on a relatively positioned element.</p>\n"},"setMargin":{"!type":"fn(margin: ?) -> !this","!doc":"<p>Sets the margin on the target element.</p>\n"},"setSize":{"!type":"fn(width: ?, height: ?) -> ?","!doc":"<p>Sets the width and height of this Component. This method fires the <a href=\"#!/api/Ext.AbstractComponent-event-resize\" rel=\"Ext.AbstractComponent-event-resize\" class=\"docClass\">resize</a> event. This method can accept\neither width and height as separate arguments, or you can pass a size object like <code>{width:10, height:20}</code>.</p>\n"},"setUI":{"!type":"fn(ui: ?) -> !this","!doc":"<p>Sets the UI for the component. This will remove any existing UIs on the component. It will also loop through any\n<code>uiCls</code> set on the component and rename them so they include the new UI.</p>\n"},"setVisible":{"!type":"fn(visible: ?) -> ?","!doc":"<p>Convenience function to hide or show this component by Boolean.</p>\n"},"setWidth":{"!type":"fn(width: ?) -> ?","!doc":"<p>Sets the width of the component. This method fires the <a href=\"#!/api/Ext.AbstractComponent-event-resize\" rel=\"Ext.AbstractComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n"},"setX":{"!type":"fn(x: ?, animate: ?) -> ?","!doc":"<p>Sets the X position of the DOM element based on page coordinates.</p>\n"},"setXY":{"!type":"fn(xy: ?, animate: ?) -> ?","!doc":"<p>Sets the position of the DOM element in page coordinates.</p>\n"},"setY":{"!type":"fn(y: ?, animate: ?) -> ?","!doc":"<p>Sets the Y position of the DOM element based on page coordinates.</p>\n"},"setupProtoEl":{"!type":"fn() -> !this"},"show":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.</p>\n"},"suspendLayouts":{"!type":"fn() -> !this"},"unitizeBox":{"!type":"fn(box: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"unmask":{"!type":"fn() -> !this"},"unregisterFloatingItem":{"!type":"fn(cmp: ?) -> !this"},"up":{"!type":"fn(selector?: ?, limit?: ?) -> ?","!doc":"<p>Navigates up the ownership hierarchy searching for an ancestor Container which matches any passed simple selector or component.</p>\n\n<p><em>Important.</em> There is not a universal upwards navigation pointer. There are several upwards relationships\nsuch as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by this method.</p>\n\n<p>Example:</p>\n\n<pre><code>var owningTabPanel = grid.up('tabpanel');\n</code></pre>\n"},"update":{"!type":"fn(htmlOrData: ?, loadScripts?: ?, callback?: ?) -> !this","!doc":"<p>Update the content area of a component.</p>\n"},"updateAria":{"!type":"fn() -> !this","!doc":"<p>Injected as an override by Ext.Aria.initialize</p>\n"},"updateLayout":{"!type":"fn(options?: ?) -> !this","!doc":"<p>Updates this component's layout. If this update affects this components <a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a>,\nthat component's <code>updateLayout</code> method will be called to perform the layout instead.\nOtherwise, just this component (and its child items) will layout.</p>\n"},"cancelLayout":{"!type":"fn(comp: ?) -> !this","!doc":"<p>Cancels layout of a component.</p>\n"},"flushLayouts":{"!type":"fn() -> !this","!doc":"<p>Performs all pending layouts that were scheduled while\n<a href=\"#!/api/Ext.AbstractComponent-method-suspendLayouts\" rel=\"Ext.AbstractComponent-method-suspendLayouts\" class=\"docClass\">suspendLayouts</a> was in effect.</p>\n"},"activate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after a Component has been visually activated.</p>\n"},"added":{"!type":"fn(this: ?, container: ?, pos: ?, eOpts: ?)","!doc":"<p>Fires after a Component had been added to a Container.</p>\n"},"afterrender":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component rendering is finished.</p>\n\n<p>The <code>afterrender</code> event is fired after this Component has been <a href=\"#!/api/Ext.AbstractComponent-property-rendered\" rel=\"Ext.AbstractComponent-property-rendered\" class=\"docClass\">rendered</a>, been postprocessed by any\n<code>afterRender</code> method defined for the Component.</p>\n"},"beforeactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before a Component has been visually activated. Returning <code>false</code> from an event listener can prevent\nthe activate from occurring.</p>\n"},"beforedeactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before a Component has been visually deactivated. Returning <code>false</code> from an event listener can\nprevent the deactivate from occurring.</p>\n"},"beforedestroy":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is <a href=\"#!/api/Ext.AbstractComponent-method-destroy\" rel=\"Ext.AbstractComponent-method-destroy\" class=\"docClass\">destroy</a>ed. Return <code>false</code> from an event handler to stop the\n<a href=\"#!/api/Ext.AbstractComponent-method-destroy\" rel=\"Ext.AbstractComponent-method-destroy\" class=\"docClass\">destroy</a>.</p>\n"},"beforehide":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method. Return <code>false</code> from an event\nhandler to stop the hide.</p>\n"},"beforerender":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is <a href=\"#!/api/Ext.AbstractComponent-property-rendered\" rel=\"Ext.AbstractComponent-property-rendered\" class=\"docClass\">rendered</a>. Return <code>false</code> from an event handler to stop the\n<a href=\"#!/api/Ext.AbstractComponent-method-render\" rel=\"Ext.AbstractComponent-method-render\" class=\"docClass\">render</a>.</p>\n"},"beforeshow":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method. Return <code>false</code> from an event\nhandler to stop the show.</p>\n"},"blur":{"!type":"fn(this: ?, The: ?, eOpts: ?)","!doc":"<p>Fires when this Component loses focus.</p>\n"},"boxready":{"!type":"fn(this: ?, width: ?, height: ?, eOpts: ?)","!doc":"<p>Fires <em>one time</em> - after the component has been laid out for the first time at its initial size.</p>\n"},"deactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after a Component has been visually deactivated.</p>\n"},"focus":{"!type":"fn(this: ?, The: ?, eOpts: ?)","!doc":"<p>Fires when this Component receives focus.</p>\n"},"hide":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is hidden. Fires after the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a>\nmethod.</p>\n"},"move":{"!type":"fn(this: ?, x: ?, y: ?, eOpts: ?)","!doc":"<p>Fires after the component is moved.</p>\n"},"removed":{"!type":"fn(this: ?, ownerCt: ?, eOpts: ?)","!doc":"<p>Fires when a component is removed from an <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></p>\n"},"render":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component markup is <a href=\"#!/api/Ext.AbstractComponent-property-rendered\" rel=\"Ext.AbstractComponent-property-rendered\" class=\"docClass\">rendered</a>.</p>\n"},"resize":{"!type":"fn(this: ?, width: ?, height: ?, oldWidth: ?, oldHeight: ?, eOpts: ?)","!doc":"<p>Fires after the component is resized. Note that this does <em>not</em> fire when the component is first laid out at its initial\nsize. To hook that point in the life cycle, use the <a href=\"#!/api/Ext.AbstractComponent-event-boxready\" rel=\"Ext.AbstractComponent-event-boxready\" class=\"docClass\">boxready</a> event.</p>\n"}},"autoEl":{"!doc":"<p>A tag name or <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> spec used to create the <a href=\"#!/api/Ext.AbstractComponent-method-getEl\" rel=\"Ext.AbstractComponent-method-getEl\" class=\"docClass\">Element</a> which will\nencapsulate this Component.</p>\n\n<p>You do not normally need to specify this. For the base classes <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> and\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>, this defaults to <strong>'div'</strong>. The more complex Sencha classes use a more\ncomplex DOM structure specified by their own <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a>s.</p>\n\n<p>This is intended to allow the developer to create application-specific utility Components encapsulated by\ndifferent DOM elements. Example usage:</p>\n\n<pre><code>{\n    xtype: 'component',\n    autoEl: {\n        tag: 'img',\n        src: 'http://www.example.com/example.jpg'\n    }\n}, {\n    xtype: 'component',\n    autoEl: {\n        tag: 'blockquote',\n        html: 'autoEl is cool!'\n    }\n}, {\n    xtype: 'container',\n    autoEl: 'ul',\n    cls: 'ux-unordered-list',\n    items: {\n        xtype: 'component',\n        autoEl: 'li',\n        html: 'First list item'\n    }\n}\n</code></pre>\n"},"autoLoad":{"!doc":"<p>An alias for <a href=\"#!/api/Ext.AbstractComponent-cfg-loader\" rel=\"Ext.AbstractComponent-cfg-loader\" class=\"docClass\">loader</a> config which also allows to specify just a string which will be\nused as the url that's automatically loaded:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    autoLoad: 'content.html',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>()\n});\n</code></pre>\n\n<p>The above is the same as:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    loader: {\n        url: 'content.html',\n        autoLoad: true\n    },\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>()\n});\n</code></pre>\n\n<p>Don't use it together with <a href=\"#!/api/Ext.AbstractComponent-cfg-loader\" rel=\"Ext.AbstractComponent-cfg-loader\" class=\"docClass\">loader</a> config.</p>\n"},"autoShow":{"!type":"bool","!doc":"<p><code>true</code> to automatically show the component upon creation. This config option may only be used for\n<a href=\"#!/api/Ext.AbstractComponent-cfg-floating\" rel=\"Ext.AbstractComponent-cfg-floating\" class=\"docClass\">floating</a> components or components that use <a href=\"#!/api/Ext.AbstractComponent-cfg-autoRender\" rel=\"Ext.AbstractComponent-cfg-autoRender\" class=\"docClass\">autoRender</a>.</p>\n"},"childEls":{"!doc":"<p>An array describing the child elements of the Component. Each member of the array\nis an object with these properties:</p>\n\n<ul>\n<li><code>name</code> - The property name on the Component for the child element.</li>\n<li><code>itemId</code> - The id to combine with the Component's id that is the id of the child element.</li>\n<li><code>id</code> - The id of the child element.</li>\n</ul>\n\n\n<p>If the array member is a string, it is equivalent to <code>{ name: m, itemId: m }</code>.</p>\n\n<p>For example, a Component which renders a title and body text:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    renderTpl: [\n        '&lt;h1 id=\"{id}-title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{msg}&lt;/p&gt;',\n    ],\n    renderData: {\n        title: \"Error\",\n        msg: \"Something went wrong\"\n    },\n    childEls: [\"title\"],\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a title property\n            cmp.title.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>A more flexible, but somewhat slower, approach is <a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a>.</p>\n"},"componentCls":{"!type":"string","!doc":"<p>CSS Class to be added to a components root level element to give distinction to it via styling.</p>\n"},"contentEl":{"!type":"string","!doc":"<p>Specify an existing HTML element, or the <code>id</code> of an existing HTML element to use as the content for this component.</p>\n\n<p>This config option is used to take an existing HTML element and place it in the layout element of a new component\n(it simply moves the specified DOM element <em>after the Component is rendered</em> to use as the content.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>The specified HTML element is appended to the layout element of the component <em>after any configured\n<a href=\"#!/api/Ext.AbstractComponent-cfg-html\" rel=\"Ext.AbstractComponent-cfg-html\" class=\"docClass\">HTML</a> has been inserted</em>, and so the document will not contain this element at the time\nthe <a href=\"#!/api/Ext.AbstractComponent-event-render\" rel=\"Ext.AbstractComponent-event-render\" class=\"docClass\">render</a> event is fired.</p>\n\n<p>The specified HTML element used will not participate in any <strong><code><a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a></code></strong>\nscheme that the Component may use. It is just HTML. Layouts operate on child\n<strong><code><a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a></code></strong>.</p>\n\n<p>Add either the <code>x-hidden</code> or the <code>x-hide-display</code> CSS class to prevent a brief flicker of the content before it\nis rendered to the panel.</p>\n"},"data":{"!doc":"<p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.AbstractComponent-cfg-tpl\" rel=\"Ext.AbstractComponent-cfg-tpl\" class=\"docClass\">tpl</a></code> to update the content area of the Component.</p>\n"},"disabled":{"!type":"bool","!doc":"<p><code>true</code> to disable the component.</p>\n"},"disabledCls":{"!type":"string","!doc":"<p>CSS class to add when the Component is disabled.</p>\n"},"height":{"!type":"number","!doc":"<p>The height of this component in pixels.</p>\n"},"html":{"!doc":"<p>An HTML fragment, or a <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> specification to use as the layout element content.\nThe HTML content is added after the component is rendered, so the document will not contain this HTML at the time\nthe <a href=\"#!/api/Ext.AbstractComponent-event-render\" rel=\"Ext.AbstractComponent-event-render\" class=\"docClass\">render</a> event is fired. This content is inserted into the body <em>before</em> any configured <a href=\"#!/api/Ext.AbstractComponent-cfg-contentEl\" rel=\"Ext.AbstractComponent-cfg-contentEl\" class=\"docClass\">contentEl</a>\nis appended.</p>\n"},"id":{"!type":"string","!doc":"<p>The <strong>unique id of this component instance.</strong></p>\n\n<p>It should not be necessary to use this configuration except for singleton objects in your application. Components\ncreated with an <code>id</code> may be accessed globally using <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>.</p>\n\n<p>Instead of using assigned ids, use the <a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a> config, and <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a>\nwhich provides selector-based searching for Sencha Components analogous to DOM querying. The <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> class contains <a href=\"#!/api/Ext.container.Container-method-down\" rel=\"Ext.container.Container-method-down\" class=\"docClass\">shortcut methods</a> to query\nits descendant Components by selector.</p>\n\n<p>Note that this <code>id</code> will also be used as the element id for the containing HTML element that is rendered to the\npage for this component. This allows you to write id-based CSS rules to style the specific instance of this\ncomponent uniquely, and also to select sub-elements using this component's <code>id</code> as the parent.</p>\n\n<p><strong>Note:</strong> To avoid complications imposed by a unique <code>id</code> also see <code><a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a></code>.</p>\n\n<p><strong>Note:</strong> To access the container of a Component see <code><a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n<p>Defaults to an <a href=\"#!/api/Ext.AbstractComponent-method-getId\" rel=\"Ext.AbstractComponent-method-getId\" class=\"docClass\">auto-assigned id</a>.</p>\n"},"itemId":{"!type":"string","!doc":"<p>An <code>itemId</code> can be used as an alternative way to get a reference to a component when no object reference is\navailable. Instead of using an <code><a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a></code> with <a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>, use <code>itemId</code> with\n<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a>.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a> which will retrieve\n<code>itemId</code>'s or <a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a>'s. Since <code>itemId</code>'s are an index to the container's internal MixedCollection, the\n<code>itemId</code> is scoped locally to the container -- avoiding potential conflicts with <a href=\"#!/api/Ext.ComponentManager\" rel=\"Ext.ComponentManager\" class=\"docClass\">Ext.ComponentManager</a>\nwhich requires a <strong>unique</strong> <code><a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a></code>.</p>\n\n<pre><code>var c = new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({ //\n    <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 300,\n    <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTo\" rel=\"Ext.AbstractComponent-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>: 'auto',\n    <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a>: [\n        {\n            itemId: 'p1',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 1',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        },\n        {\n            itemId: 'p2',\n            <a href=\"#!/api/Ext.panel.Panel-cfg-title\" rel=\"Ext.panel.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 2',\n            <a href=\"#!/api/Ext.Component-cfg-height\" rel=\"Ext.Component-cfg-height\" class=\"docClass\">height</a>: 150\n        }\n    ]\n})\np1 = c.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p1'); // not the same as <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp()</a>\np2 = p1.<a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a>.<a href=\"#!/api/Ext.container.Container-method-getComponent\" rel=\"Ext.container.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p2'); // reference via a sibling\n</code></pre>\n\n<p>Also see <a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a>, <code><a href=\"#!/api/Ext.container.Container-method-query\" rel=\"Ext.container.Container-method-query\" class=\"docClass\">Ext.container.Container.query</a></code>, <code><a href=\"#!/api/Ext.container.Container-method-down\" rel=\"Ext.container.Container-method-down\" class=\"docClass\">Ext.container.Container.down</a></code> and\n<code><a href=\"#!/api/Ext.container.Container-method-child\" rel=\"Ext.container.Container-method-child\" class=\"docClass\">Ext.container.Container.child</a></code>.</p>\n\n<p><strong>Note</strong>: to access the container of an item see <a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a>.</p>\n"},"loader":{"!doc":"<p>A configuration object or an instance of a <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> to load remote content\nfor this Component.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    loader: {\n        url: 'content.html',\n        autoLoad: true\n    },\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>()\n});\n</code></pre>\n"},"margin":{"!doc":"<p>Specifies the margin for this component. The margin can be a single numeric value to apply to all sides or it can\nbe a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n"},"overCls":{"!type":"string","!doc":"<p>An optional extra CSS class that will be added to this component's Element when the mouse moves over the Element,\nand removed when the mouse moves out. This can be useful for adding customized 'active' or 'hover' styles to the\ncomponent or any of its children using standard CSS rules.</p>\n"},"padding":{"!doc":"<p>Specifies the padding for this component. The padding can be a single numeric value to apply to all sides or it\ncan be a CSS style specification for each style, for example: '10 5 3 10' (top, right, bottom, left).</p>\n"},"plugins":{"!doc":"<p>An array of plugins to be added to this component. Can also be just a single plugin instead of array.</p>\n\n<p>Plugins provide custom functionality for a component. The only requirement for\na valid plugin is that it contain an <code>init</code> method that accepts a reference of type <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>. When a component\nis created, if any plugins are available, the component will call the init method on each plugin, passing a\nreference to itself. Each plugin can then call methods or respond to events on the component as needed to provide\nits functionality.</p>\n\n<p>Plugins can be added to component by either directly referencing the plugin instance:</p>\n\n<pre><code>plugins: [<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.grid.plugin.CellEditing\" rel=\"Ext.grid.plugin.CellEditing\" class=\"docClass\">Ext.grid.plugin.CellEditing</a>', {clicksToEdit: 1})],\n</code></pre>\n\n<p>By using config object with ptype:</p>\n\n<pre><code>plugins: [{ptype: 'cellediting', clicksToEdit: 1}],\n</code></pre>\n\n<p>Or with just a ptype:</p>\n\n<pre><code>plugins: ['cellediting', 'gridviewdragdrop'],\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.enums.Plugin\" rel=\"Ext.enums.Plugin\" class=\"docClass\">Ext.enums.Plugin</a> for list of all ptypes.</p>\n"},"renderData":{"!doc":"<p>The data used by <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a> in addition to the following property values of the component:</p>\n\n<ul>\n<li>id</li>\n<li>ui</li>\n<li>uiCls</li>\n<li>baseCls</li>\n<li>componentCls</li>\n<li>frame</li>\n</ul>\n\n\n<p>See <a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a> and <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> for usage examples.</p>\n"},"renderSelectors":{"!doc":"<p>An object containing properties specifying <a href=\"#!/api/Ext.dom.Query\" rel=\"Ext.dom.Query\" class=\"docClass\">DomQuery</a> selectors which identify child elements\ncreated by the render process.</p>\n\n<p>After the Component's internal structure is rendered according to the <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a>, this object is iterated through,\nand the found Elements are added as properties to the Component using the <code>renderSelector</code> property name.</p>\n\n<p>For example, a Component which renders a title and description into its element:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    renderTpl: [\n        '&lt;h1 class=\"title\"&gt;{title}&lt;/h1&gt;',\n        '&lt;p&gt;{desc}&lt;/p&gt;'\n    ],\n    renderData: {\n        title: \"Error\",\n        desc: \"Something went wrong\"\n    },\n    renderSelectors: {\n        titleEl: 'h1.title',\n        descEl: 'p'\n    },\n    listeners: {\n        afterrender: function(cmp){\n            // After rendering the component will have a titleEl and descEl properties\n            cmp.titleEl.setStyle({color: \"red\"});\n        }\n    }\n});\n</code></pre>\n\n<p>For a faster, but less flexible, alternative that achieves the same end result (properties for child elements on the\nComponent after render), see <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> and <a href=\"#!/api/Ext.AbstractComponent-method-addChildEls\" rel=\"Ext.AbstractComponent-method-addChildEls\" class=\"docClass\">addChildEls</a>.</p>\n"},"renderTo":{"!doc":"<p>Specify the <code>id</code> of the element, a DOM element or an existing Element that this component will be rendered into.</p>\n\n<p><strong>Notes:</strong></p>\n\n<p>Do <em>not</em> use this option if the Component is to be a child item of a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>.\nIt is the responsibility of the <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>'s\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout manager</a> to render and manage its child items.</p>\n\n<p>When using this config, a call to <code>render()</code> is not required.</p>\n\n<p>See also: <a href=\"#!/api/Ext.AbstractComponent-method-render\" rel=\"Ext.AbstractComponent-method-render\" class=\"docClass\">render</a>.</p>\n"},"rtl":{"!type":"bool","!doc":"<p>True to layout this component and its descendants in \"rtl\" (right-to-left) mode.\nCan be explicitly set to false to override a true value inherited from an ancestor.</p>\n\n<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"shrinkWrap":{"!doc":"<p>If this property is a number, it is interpreted as follows:</p>\n\n<ul>\n<li>0: Neither width nor height depend on content. This is equivalent to <code>false</code>.</li>\n<li>1: Width depends on content (shrink wraps), but height does not.</li>\n<li>2: Height depends on content (shrink wraps), but width does not. The default.</li>\n<li>3: Both width and height depend on content (shrink wrap). This is equivalent to <code>true</code>.</li>\n</ul>\n\n\n<p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed\nto a block-level element. Some container layouts always shrink-wrap their children,\neffectively ignoring this property (e.g., <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">Ext.layout.container.HBox</a>,\n<a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">Ext.layout.container.VBox</a>, <a href=\"#!/api/Ext.layout.component.Dock\" rel=\"Ext.layout.component.Dock\" class=\"docClass\">Ext.layout.component.Dock</a>).</p>\n"},"style":{"!doc":"<p>A custom style specification to be applied to this component's Element. Should be a valid argument to\n<a href=\"#!/api/Ext.dom.Element-method-applyStyles\" rel=\"Ext.dom.Element-method-applyStyles\" class=\"docClass\">Ext.Element.applyStyles</a>.</p>\n\n<pre><code>new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    title: 'Some Title',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    width: 400, height: 300,\n    layout: 'form',\n    items: [{\n        xtype: 'textarea',\n        style: {\n            width: '95%',\n            marginBottom: '10px'\n        }\n    },\n    new <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>({\n        text: 'Send',\n        minWidth: '100',\n        style: {\n            marginBottom: '10px'\n        }\n    })\n    ]\n});\n</code></pre>\n"},"tpl":{"!doc":"<p>An <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a>, <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a> or an array of strings to form an <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>. Used in\nconjunction with the <code><a href=\"#!/api/Ext.AbstractComponent-cfg-data\" rel=\"Ext.AbstractComponent-cfg-data\" class=\"docClass\">data</a></code> and <code><a href=\"#!/api/Ext.AbstractComponent-cfg-tplWriteMode\" rel=\"Ext.AbstractComponent-cfg-tplWriteMode\" class=\"docClass\">tplWriteMode</a></code> configurations.</p>\n"},"tplWriteMode":{"!type":"string","!doc":"<p>The Ext.(X)Template method to use when updating the content area of the Component.\nSee <code><a href=\"#!/api/Ext.XTemplate-method-overwrite\" rel=\"Ext.XTemplate-method-overwrite\" class=\"docClass\">Ext.XTemplate.overwrite</a></code> for information on default mode.</p>\n"},"ui":{"!type":"string","!doc":"<p>A UI style for a component.</p>\n"},"uiCls":{"!doc":"<p>An array of of <code>classNames</code> which are currently applied to this component.</p>\n"},"width":{"!type":"number","!doc":"<p>The width of this component in pixels.</p>\n"},"xtype":{"!doc":"<p>This property provides a shorter alternative to creating objects than using a full\nclass name. Using <code>xtype</code> is the most common way to define component instances,\nespecially in a container. For example, the items in a form containing text fields\ncould be created explicitly like so:</p>\n\n<pre><code> items: [\n     <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n         fieldLabel: 'Foo'\n     }),\n     <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n         fieldLabel: 'Bar'\n     }),\n     <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.field.Number\" rel=\"Ext.form.field.Number\" class=\"docClass\">Ext.form.field.Number</a>', {\n         fieldLabel: 'Num'\n     })\n ]\n</code></pre>\n\n<p>But by using <code>xtype</code>, the above becomes:</p>\n\n<pre><code> items: [\n     {\n         xtype: 'textfield',\n         fieldLabel: 'Foo'\n     },\n     {\n         xtype: 'textfield',\n         fieldLabel: 'Bar'\n     },\n     {\n         xtype: 'numberfield',\n         fieldLabel: 'Num'\n     }\n ]\n</code></pre>\n\n<p>When the <code>xtype</code> is common to many items, <a href=\"#!/api/Ext.container.AbstractContainer-cfg-defaultType\" rel=\"Ext.container.AbstractContainer-cfg-defaultType\" class=\"docClass\">Ext.container.AbstractContainer.defaultType</a>\nis another way to specify the <code>xtype</code> for all items that don't have an explicit <code>xtype</code>:</p>\n\n<pre><code> defaultType: 'textfield',\n items: [\n     { fieldLabel: 'Foo' },\n     { fieldLabel: 'Bar' },\n     { fieldLabel: 'Num', xtype: 'numberfield' }\n ]\n</code></pre>\n\n<p>Each member of the <code>items</code> array is now just a \"configuration object\". These objects\nare used to create and configure component instances. A configuration object can be\nmanually used to instantiate a component using <a href=\"#!/api/Ext-method-widget\" rel=\"Ext-method-widget\" class=\"docClass\">Ext.widget</a>:</p>\n\n<pre><code> var text1 = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>', {\n     fieldLabel: 'Foo'\n });\n\n // or alternatively:\n\n var text1 = <a href=\"#!/api/Ext-method-widget\" rel=\"Ext-method-widget\" class=\"docClass\">Ext.widget</a>({\n     xtype: 'textfield',\n     fieldLabel: 'Foo'\n });\n</code></pre>\n\n<p>This conversion of configuration objects into instantiated components is done when\na container is created as part of its {<a href=\"#!/api/Ext.container.AbstractContainer-method-initComponent\" rel=\"Ext.container.AbstractContainer-method-initComponent\" class=\"docClass\">Ext.container.AbstractContainer.initComponent</a>}\nprocess. As part of the same process, the <code>items</code> array is converted from its raw\narray form into a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a> instance.</p>\n\n<p>You can define your own <code>xtype</code> on a custom <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">component</a> by specifying\nthe <code>xtype</code> property in <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>. For example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.PressMeButton', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n    xtype: 'pressmebutton',\n    text: 'Press Me'\n});\n</code></pre>\n\n<p>Care should be taken when naming an <code>xtype</code> in a custom component because there is\na single, shared scope for all xtypes. Third part components should consider using\na prefix to avoid collisions.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Foo.form.CoolButton', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n    xtype: 'ux-coolbutton',\n    text: 'Cool!'\n});\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.enums.Widget\" rel=\"Ext.enums.Widget\" class=\"docClass\">Ext.enums.Widget</a> for list of all available xtypes.</p>\n"},"_isLayoutRoot":{"!type":"bool","!doc":"<p>Setting this property to <code>true</code> causes the <a href=\"#!/api/Ext.AbstractComponent-method-isLayoutRoot\" rel=\"Ext.AbstractComponent-method-isLayoutRoot\" class=\"docClass\">isLayoutRoot</a> method to return\n<code>true</code> and stop the search for the top-most component for a layout.</p>\n"},"allowDomMove":{"!type":"bool"},"autoGenId":{"!type":"bool","!doc":"<p><code>true</code> indicates an <code>id</code> was auto-generated rather than provided by configuration.</p>\n"},"borderBoxCls":{"!type":"string","!doc":"<p>private</p>\n"},"componentLayoutCounter":{"!type":"number","!doc":"<p>The number of component layout calls made on this object.</p>\n"},"deferLayouts":{"!type":"bool"},"draggable":{"!type":"bool","!doc":"<p>Indicates whether or not the component can be dragged.</p>\n"},"frameElementsArray":{},"frameSize":{"!doc":"<p>Indicates the width of any framing elements which were added within the encapsulating\nelement to provide graphical, rounded borders. See the <a href=\"#!/api/Ext.AbstractComponent-cfg-frame\" rel=\"Ext.AbstractComponent-cfg-frame\" class=\"docClass\">frame</a> config. This\nproperty is <code>null</code> if the component is not framed.</p>\n\n<p>This is an object containing the frame width in pixels for all four sides of the\nComponent containing the following properties:</p>\n"},"horizontalPosProp":{"!type":"string"},"isComponent":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Component, or subclass thereof.</p>\n"},"layoutSuspendCount":{"!type":"number"},"maskOnDisable":{"!type":"bool","!doc":"<p>This is an internal flag that you use when creating custom components. By default this is set to <code>true</code> which means\nthat every component gets a mask when it's disabled. Components like FieldContainer, FieldSet, Field, Button, Tab\noverride this property to <code>false</code> since they want to implement custom disable logic.</p>\n"},"ownerCt":{"!doc":"<p>This Component's owner <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> (is set automatically\nwhen this Component is added to a Container).</p>\n\n<p><em>Important.</em> This is not a universal upwards navigation pointer. It indicates the Container which owns and manages\nthis Component if any. There are other similar relationships such as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by the <a href=\"#!/api/Ext.AbstractComponent-method-up\" rel=\"Ext.AbstractComponent-method-up\" class=\"docClass\">up</a> method.</p>\n\n<p><strong>Note</strong>: to access items within the Container see <a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a>.</p>\n"},"rendered":{"!type":"bool","!doc":"<p>Indicates whether or not the component has been rendered.</p>\n"},"weight":{"!type":"number"},"addClass":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the top level element representing this component.</p>\n"},"addCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds a CSS class to the top level element representing this component.</p>\n"},"addClsWithUI":{"!type":"fn(classes: ?, skip: ?) -> !this","!doc":"<p>Adds a <code>cls</code> to the <code>uiCls</code> array, which will also call <a href=\"#!/api/Ext.AbstractComponent-method-addUIClsToElement\" rel=\"Ext.AbstractComponent-method-addUIClsToElement\" class=\"docClass\">addUIClsToElement</a> and adds to all elements of this\ncomponent.</p>\n"},"addFocusListener":{"!type":"fn() -> !this","!doc":"<p>Sets up the focus listener on this Component's <a href=\"#!/api/Ext.AbstractComponent-method-getFocusEl\" rel=\"Ext.AbstractComponent-method-getFocusEl\" class=\"docClass\">focusEl</a> if it has one.</p>\n\n<p>Form Components which must implicitly participate in tabbing order usually have a naturally focusable\nelement as their <a href=\"#!/api/Ext.AbstractComponent-method-getFocusEl\" rel=\"Ext.AbstractComponent-method-getFocusEl\" class=\"docClass\">focusEl</a>, and it is the DOM event of that receiving focus which drives\nthe Component's <code>onFocus</code> handling, and the DOM event of it being blurred which drives the <code>onBlur</code> handling.</p>\n\n<p>If the <a href=\"#!/api/Ext.AbstractComponent-method-getFocusEl\" rel=\"Ext.AbstractComponent-method-getFocusEl\" class=\"docClass\">focusEl</a> is <strong>not</strong> naturally focusable, then the listeners are only added\nif the <a href=\"#!/api/Ext.FocusManager\" rel=\"Ext.FocusManager\" class=\"docClass\">FocusManager</a> is enabled.</p>\n"},"addListener":{"!type":"fn(element: ?, listeners: ?, scope: ?, options: ?) -> ?","!doc":"<p>Appends an event handler to this object.  For example:</p>\n\n<pre><code>myGridPanel.on(\"mouseover\", this.onMouseOver, this);\n</code></pre>\n\n<p>The method also allows for a single argument to be passed which is a config object\ncontaining properties which specify multiple events. For example:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: this.onCellClick,\n    mouseover: this.onMouseOver,\n    mouseout: this.onMouseOut,\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n<p>One can also specify options for each event handler separately:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: this.onCellClick, scope: this, single: true},\n    mouseover: {fn: panel.onMouseOver, scope: panel}\n});\n</code></pre>\n\n<p><em>Names</em> of methods in a specified scope may also be used. Note that\n<code>scope</code> MUST be specified to use this option:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: 'onCellClick', scope: this, single: true},\n    mouseover: {fn: 'onMouseOver', scope: panel}\n});\n</code></pre>\n"},"addOverCls":{"!type":"fn() -> !this","!doc":"<p></p>\n"},"addPlugin":{"!type":"fn(plugin: ?) -> !this","!doc":"<p>Adds a plugin. May be called at any time in the component's lifecycle.</p>\n"},"addPropertyToState":{"!type":"fn(state: ?, propName: ?, value?: ?) -> bool","!doc":"<p>Save a property to the given state object if it is not its default or configured\nvalue.</p>\n"},"animate":{"!type":"fn(animObj: ?) -> ?","!doc":"<p>Performs custom animation on this object.</p>\n\n<p>This method is applicable to both the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> class and the <a href=\"#!/api/Ext.draw.Sprite\" rel=\"Ext.draw.Sprite\" class=\"docClass\">Sprite</a>\nclass. It performs animated transitions of certain properties of this object over a specified timeline.</p>\n\n<h3>Animating a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a></h3>\n\n<p>When animating a Component, the following properties may be specified in <code>from</code>, <code>to</code>, and <code>keyframe</code> objects:</p>\n\n<ul>\n<li><p><code>x</code> - The Component's page X position in pixels.</p></li>\n<li><p><code>y</code> - The Component's page Y position in pixels</p></li>\n<li><p><code>left</code> - The Component's <code>left</code> value in pixels.</p></li>\n<li><p><code>top</code> - The Component's <code>top</code> value in pixels.</p></li>\n<li><p><code>width</code> - The Component's <code>width</code> value in pixels.</p></li>\n<li><p><code>height</code> - The Component's <code>height</code> value in pixels.</p></li>\n<li><p><code>dynamic</code> - Specify as true to update the Component's layout (if it is a Container) at every frame of the animation.\n<em>Use sparingly as laying out on every intermediate size change is an expensive operation.</em></p></li>\n</ul>\n\n\n<p>For example, to animate a Window to a new size, ensuring that its internal layout and any shadow is correct:</p>\n\n<pre><code>myWindow = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>', {\n    title: 'Test Component animation',\n    width: 500,\n    height: 300,\n    layout: {\n        type: 'hbox',\n        align: 'stretch'\n    },\n    items: [{\n        title: 'Left: 33%',\n        margins: '5 0 5 5',\n        flex: 1\n    }, {\n        title: 'Left: 66%',\n        margins: '5 5 5 5',\n        flex: 2\n    }]\n});\nmyWindow.show();\nmyWindow.header.el.on('click', function() {\n    myWindow.animate({\n        to: {\n            width: (myWindow.getWidth() == 500) ? 700 : 500,\n            height: (myWindow.getHeight() == 300) ? 400 : 300\n        }\n    });\n});\n</code></pre>\n\n<p>For performance reasons, by default, the internal layout is only updated when the Window reaches its final <code>\"to\"</code>\nsize. If dynamic updating of the Window's child Components is required, then configure the animation with\n<code>dynamic: true</code> and the two child items will maintain their proportions during the animation.</p>\n"},"beforeBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any pre-blur processing.</p>\n"},"beforeComponentLayout":{"!type":"fn(adjWidth: ?, adjHeight: ?) -> !this","!doc":"<p>Occurs before <code>componentLayout</code> is run. Returning <code>false</code> from this method will prevent the <code>componentLayout</code> from\nbeing executed.</p>\n"},"beforeFocus":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any pre-focus processing.</p>\n"},"constructPlugin":{"!type":"fn(ptype: ?) -> !this"},"constructPlugins":{"!type":"fn() -> !this","!doc":"<p>Returns an array of fully constructed plugin instances. This converts any configs into their\nappropriate instances.</p>\n\n<p>It does not mutate the plugins array. It creates a new array.</p>\n"},"convertPositionSpec":{"!type":"fn(posSpec: ?) -> !this","!doc":"<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"doComponentLayout":{"!type":"fn() -> ?","!doc":"<p>This method needs to be called whenever you change something on this component that requires the Component's\nlayout to be recalculated.</p>\n"},"findPlugin":{"!type":"fn(ptype: ?) -> ?","!doc":"<p>Retrieves plugin from this component's collection by its <code>ptype</code>.</p>\n"},"forceComponentLayout":{"!type":"fn() -> !this","!doc":"<p>Forces this component to redo its componentLayout.</p>\n"},"getAnchorToXY":{"!type":"fn(el: ?, anchor?: ?, local?: ?, size?: ?) -> ?","!doc":"<hr />\n\n<p> Begin Positionable methods</p>\n\n<hr />\n\n<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"getAutoId":{"!type":"fn() -> !this"},"getBorderPadding":{"!type":"fn() -> ?","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"getComponentLayout":{"!type":"fn() -> !this"},"getHeight":{"!type":"fn() -> number","!doc":"<p>Gets the current height of the component's underlying element.</p>\n"},"getHierarchyState":{"!type":"fn(inner: ?) -> !this","!doc":"<p>A component's hierarchyState is used to keep track of aspects of a component's\nstate that affect its descendants hierarchically like \"collapsed\" and \"hidden\".\nFor example, if this.hierarchyState.hidden == true, it means that either this\ncomponent, or one of its ancestors is hidden.</p>\n\n<p>Hierarchical state management is implemented by chaining each component's\nhierarchyState property to its parent container's hierarchyState property via the\nprototype. The result is such that if a component's hierarchyState does not have\nit's own property, it inherits the property from the nearest ancestor that does.</p>\n\n<p>To set a hierarchical \"hidden\" value:</p>\n\n<pre><code>this.getHierarchyState().hidden = true;\n</code></pre>\n\n<p>It is important to remember when unsetting hierarchyState properties to delete\nthem instead of just setting them to a falsy value.  This ensures that the\nhierarchyState returns to a state of inheriting the value instead of overriding it\nTo unset the hierarchical \"hidden\" value:</p>\n\n<pre><code>delete this.getHierarchyState().hidden;\n</code></pre>\n\n<p>IMPORTANT! ALWAYS access hierarchyState using this method, not by accessing\nthis.hierarchyState directly.  The hierarchyState property does not exist until\nthe first time getHierarchyState() is called.  At that point getHierarchyState()\nwalks up the component tree to establish the hierarchyState prototype chain.\nAdditionally the hierarchyState property should NOT be relied upon even after\nthe initial call to getHierarchyState() because  it is possible for the\nhierarchyState to be invalidated. Invalidation typically happens when a component\nis moved to a new container. In such a case the hierarchy state remains invalid\nuntil the next time getHierarchyState() is called on the component or one of its\ndescendants.</p>\n"},"getItemId":{"!type":"fn() -> string","!doc":"<p>Returns the value of <a href=\"#!/api/Ext.AbstractComponent-cfg-itemId\" rel=\"Ext.AbstractComponent-cfg-itemId\" class=\"docClass\">itemId</a> assigned to this component, or when that\nis not set, returns the value of <a href=\"#!/api/Ext.AbstractComponent-cfg-id\" rel=\"Ext.AbstractComponent-cfg-id\" class=\"docClass\">id</a>.</p>\n"},"getLoader":{"!type":"fn() -> ?","!doc":"<p>Gets the <a href=\"#!/api/Ext.ComponentLoader\" rel=\"Ext.ComponentLoader\" class=\"docClass\">Ext.ComponentLoader</a> for this Component.</p>\n"},"getLocalX":{"!type":"fn() -> number","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"getLocalXY":{"!type":"fn() -> ?","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"getLocalY":{"!type":"fn() -> number","!doc":"<p>Returns the y coordinate of this element reletive to its <code>offsetParent</code>.</p>\n"},"getMaskTarget":{"!type":"fn() -> !this"},"getOverflowEl":{"!type":"fn() -> !this","!doc":"<p>Get an el for overflowing, defaults to the target el</p>\n"},"getOverflowStyle":{"!type":"fn() -> !this","!doc":"<p>Returns the CSS style object which will set the Component's scroll styles. This must be applied\nto the <a href=\"#!/api/Ext.AbstractComponent-method-getTargetEl\" rel=\"Ext.AbstractComponent-method-getTargetEl\" class=\"docClass\">target element</a>.</p>\n"},"getPlugin":{"!type":"fn(pluginId: ?) -> ?","!doc":"<p>Retrieves a plugin from this component's collection by its <code>pluginId</code>.</p>\n"},"getSize":{"!type":"fn() -> ?","!doc":"<p>Gets the current size of the component's underlying element.</p>\n"},"getSizeModel":{"!type":"fn(ownerCtSizeModel: ?) -> ?","!doc":"<p>Returns an object that describes how this component's width and height are managed.\nAll of these objects are shared and should not be modified.</p>\n"},"getTpl":{"!type":"fn(name: ?) -> !this"},"getWidth":{"!type":"fn() -> number","!doc":"<p>Gets the current width of the component's underlying element.</p>\n"},"getX":{"!type":"fn() -> number","!doc":"<p>Gets the current X position of the DOM element based on page coordinates.</p>\n"},"getXTypes":{"!type":"fn() -> string","!doc":"<p>Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all available xtypes, see the\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nalert(t.getXTypes());  // alerts 'component/field/textfield'\n</code></pre>\n"},"getXY":{"!type":"fn() -> ?","!doc":"<p>Gets the current position of the DOM element based on page coordinates.</p>\n"},"getY":{"!type":"fn() -> number","!doc":"<p>Gets the current Y position of the DOM element based on page coordinates.</p>\n"},"hasCls":{"!type":"fn(className: ?) -> bool","!doc":"<p>Checks if the specified CSS class exists on this element's DOM node.</p>\n"},"hasUICls":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Checks if there is currently a specified <code>uiCls</code>.</p>\n"},"initCls":{"!type":"fn() -> !this"},"initEvents":{"!type":"fn() -> !this","!doc":"<p>Initialize any events on this component</p>\n"},"initHierarchyState":{"!type":"fn(hierarchyState: ?) -> !this","!doc":"<p>Called by <a href=\"#!/api/Ext.AbstractComponent-method-getHierarchyState\" rel=\"Ext.AbstractComponent-method-getHierarchyState\" class=\"docClass\">getHierarchyState</a> to initialize the hierarchyState the first\ntime it is requested.</p>\n\n<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"initPadding":{"!type":"fn(targetEl: ?) -> !this","!doc":"<p>Initializes padding by applying it to the target element, or if the layout manages\npadding ensures that the padding on the target element is \"0\".</p>\n"},"initPlugin":{"!type":"fn(plugin: ?) -> !this"},"initStyles":{"!type":"fn(targetEl: ?) -> !this","!doc":"<p>Applies padding, margin, border, top, left, height, and width configs to the\nappropriate elements.</p>\n"},"is":{"!type":"fn(selector: ?) -> bool","!doc":"<p>Tests whether this Component matches the selector string.</p>\n"},"isDescendant":{"!type":"fn(ancestor: ?) -> !this"},"isDescendantOf":{"!type":"fn(container: ?) -> bool","!doc":"<p>Determines whether this component is the descendant of a particular container.</p>\n"},"isDisabled":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is currently disabled.</p>\n"},"isDraggable":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is draggable.</p>\n"},"isDroppable":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is droppable.</p>\n"},"isFloating":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is floating.</p>\n"},"isFocusable":{"!type":"fn() -> !this"},"isHidden":{"!type":"fn() -> bool","!doc":"<p>Method to determine whether this Component is currently set to hidden.</p>\n"},"isHierarchicallyHidden":{"!type":"fn() -> !this"},"isLayoutSuspended":{"!type":"fn() -> bool","!doc":"<p>Returns <code>true</code> if layout is suspended for this component. This can come from direct\nsuspension of this component's layout activity (<a href=\"#!/api/Ext.container.Container-cfg-suspendLayout\" rel=\"Ext.container.Container-cfg-suspendLayout\" class=\"docClass\">Ext.Container.suspendLayout</a>) or if one\nof this component's containers is suspended.</p>\n"},"isLocalRtl":{"!type":"fn() -> bool","!doc":"<p>Returns true if this component's local coordinate system is rtl. For normal\ncomponents this equates to the value of isParentRtl().  Floaters are a bit different\nbecause a floater's element can be a childNode of something other than its\nparent component's element.  For floaters we have to read the dom to see if the\ncomponent's element's parentNode has a css direction value of \"rtl\".</p>\n\n<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"isOppositeRootDirection":{"!type":"fn() -> !this","!doc":"<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"isParentRtl":{"!type":"fn() -> bool","!doc":"<p>Returns true if this component's parent container is rtl. Used by rtl positioning\nmethods to determine if the component should be positioned using a right-to-left\ncoordinate system.</p>\n\n<p><strong>Defined in override Ext.rtl.AbstractComponent.</strong></p>\n"},"isXType":{"!type":"fn(xtype: ?, shallow?: ?) -> bool","!doc":"<p>Tests whether or not this Component is of a specific xtype. This can test whether this Component is descended\nfrom the xtype (default) or whether it is directly of the xtype specified (<code>shallow = true</code>).</p>\n\n<p><strong>If using your own subclasses, be aware that a Component must register its own xtype to participate in\ndetermination of inherited xtypes.</strong></p>\n\n<p>For a list of all available xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nvar isText = t.isXType('textfield');        // true\nvar isBoxSubclass = t.isXType('field');       // true, descended from <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>\nvar isBoxInstance = t.isXType('field', true); // false, not a direct <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a> instance\n</code></pre>\n"},"mask":{"!type":"fn() -> !this"},"nextNode":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the next node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree to attempt to find a match. Contrast with <a href=\"#!/api/Ext.AbstractComponent-method-nextSibling\" rel=\"Ext.AbstractComponent-method-nextSibling\" class=\"docClass\">nextSibling</a>.</p>\n"},"nextSibling":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the next sibling of this Component.</p>\n\n<p>Optionally selects the next sibling which matches the passed <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selector.</p>\n\n<p>May also be referred to as <strong><code>next()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.AbstractComponent-method-nextNode\" rel=\"Ext.AbstractComponent-method-nextNode\" class=\"docClass\">nextNode</a></p>\n"},"onBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>private</p>\n"},"onDisable":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the disable operation.\nAfter calling the superclass's <code>onDisable</code>, the Component will be disabled.</p>\n"},"onEnable":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the enable operation.\nAfter calling the superclass's <code>onEnable</code>, the Component will be enabled.</p>\n"},"parseBox":{"!type":"fn(box: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"postBlur":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method to do any post-blur processing.</p>\n"},"previousNode":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the previous node in the Component tree in tree traversal order.</p>\n\n<p>Note that this is not limited to siblings, and if invoked upon a node with no matching siblings, will walk the\ntree in reverse order to attempt to find a match. Contrast with <a href=\"#!/api/Ext.AbstractComponent-method-previousSibling\" rel=\"Ext.AbstractComponent-method-previousSibling\" class=\"docClass\">previousSibling</a>.</p>\n"},"previousSibling":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Returns the previous sibling of this Component.</p>\n\n<p>Optionally selects the previous sibling which matches the passed <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a>\nselector.</p>\n\n<p>May also be referred to as <strong><code>prev()</code></strong></p>\n\n<p>Note that this is limited to siblings, and if no siblings of the item match, <code>null</code> is returned. Contrast with\n<a href=\"#!/api/Ext.AbstractComponent-method-previousNode\" rel=\"Ext.AbstractComponent-method-previousNode\" class=\"docClass\">previousNode</a></p>\n"},"registerFloatingItem":{"!type":"fn(cmp: ?) -> !this","!doc":"<p>Called by Component#doAutoRender</p>\n\n<p>Register a Container configured <code>floating: true</code> with this Component's <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a>.</p>\n\n<p>Components added in this way will not participate in any layout, but will be rendered\nupon first show in the way that <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s are.</p>\n"},"removeClass":{"!type":"fn() -> !this","!doc":"<p><debug></debug></p>\n"},"removeCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes a CSS class from the top level element representing this component.</p>\n"},"removeClsWithUI":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Removes a <code>cls</code> to the <code>uiCls</code> array, which will also call <a href=\"#!/api/Ext.AbstractComponent-method-removeUIClsFromElement\" rel=\"Ext.AbstractComponent-method-removeUIClsFromElement\" class=\"docClass\">removeUIClsFromElement</a> and removes it from all\nelements of this component.</p>\n"},"removeManagedListenerItem":{"!type":"fn(isClear: ?, managedListener: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"removeOverCls":{"!type":"fn() -> !this"},"removePlugin":{"!type":"fn(plugin: ?) -> !this"},"resumeLayouts":{"!type":"fn(flushOptions: ?) -> !this"},"setComponentLayout":{"!type":"fn(layout: ?) -> !this"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Enable or disable the component.</p>\n"},"setDocked":{"!type":"fn(dock: ?, layoutParent?: ?) -> ?","!doc":"<p>Sets the dock position of this component in its parent panel. Note that this only has effect if this item is part\nof the <code>dockedItems</code> collection of a parent that has a DockLayout (note that any Panel has a DockLayout by default)</p>\n"},"setHeight":{"!type":"fn(height: ?) -> ?","!doc":"<p>Sets the height of the component. This method fires the <a href=\"#!/api/Ext.AbstractComponent-event-resize\" rel=\"Ext.AbstractComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n"},"setHiddenState":{"!type":"fn(hidden: ?) -> !this"},"setLocalX":{"!type":"fn(x: ?) -> ?","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"setLocalXY":{"!type":"fn(x: ?, y: ?) -> ?","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"setLocalY":{"!type":"fn(y: ?) -> ?","!doc":"<p>Sets the local y coordinate of this element using CSS style. When used on an\nabsolute positioned element this method is symmetrical with <a href=\"#!/api/Ext.AbstractComponent-method-getLocalY\" rel=\"Ext.AbstractComponent-method-getLocalY\" class=\"docClass\">getLocalY</a>, but\nmay not be symmetrical when used on a relatively positioned element.</p>\n"},"setMargin":{"!type":"fn(margin: ?) -> !this","!doc":"<p>Sets the margin on the target element.</p>\n"},"setSize":{"!type":"fn(width: ?, height: ?) -> ?","!doc":"<p>Sets the width and height of this Component. This method fires the <a href=\"#!/api/Ext.AbstractComponent-event-resize\" rel=\"Ext.AbstractComponent-event-resize\" class=\"docClass\">resize</a> event. This method can accept\neither width and height as separate arguments, or you can pass a size object like <code>{width:10, height:20}</code>.</p>\n"},"setVisible":{"!type":"fn(visible: ?) -> ?","!doc":"<p>Convenience function to hide or show this component by Boolean.</p>\n"},"setWidth":{"!type":"fn(width: ?) -> ?","!doc":"<p>Sets the width of the component. This method fires the <a href=\"#!/api/Ext.AbstractComponent-event-resize\" rel=\"Ext.AbstractComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n"},"setX":{"!type":"fn(x: ?, animate: ?) -> ?","!doc":"<p>Sets the X position of the DOM element based on page coordinates.</p>\n"},"setXY":{"!type":"fn(xy: ?, animate: ?) -> ?","!doc":"<p>Sets the position of the DOM element in page coordinates.</p>\n"},"setY":{"!type":"fn(y: ?, animate: ?) -> ?","!doc":"<p>Sets the Y position of the DOM element based on page coordinates.</p>\n"},"setupProtoEl":{"!type":"fn() -> !this"},"suspendLayouts":{"!type":"fn() -> !this"},"unitizeBox":{"!type":"fn(box: ?) -> !this","!doc":"<p><strong>Overridden in Ext.rtl.AbstractComponent.</strong></p>\n"},"unmask":{"!type":"fn() -> !this"},"unregisterFloatingItem":{"!type":"fn(cmp: ?) -> !this"},"up":{"!type":"fn(selector?: ?, limit?: ?) -> ?","!doc":"<p>Navigates up the ownership hierarchy searching for an ancestor Container which matches any passed simple selector or component.</p>\n\n<p><em>Important.</em> There is not a universal upwards navigation pointer. There are several upwards relationships\nsuch as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by this method.</p>\n\n<p>Example:</p>\n\n<pre><code>var owningTabPanel = grid.up('tabpanel');\n</code></pre>\n"},"update":{"!type":"fn(htmlOrData: ?, loadScripts?: ?, callback?: ?) -> !this","!doc":"<p>Update the content area of a component.</p>\n"},"updateAria":{"!type":"fn() -> !this","!doc":"<p>Injected as an override by Ext.Aria.initialize</p>\n"},"updateLayout":{"!type":"fn(options?: ?) -> !this","!doc":"<p>Updates this component's layout. If this update affects this components <a href=\"#!/api/Ext.AbstractComponent-property-ownerCt\" rel=\"Ext.AbstractComponent-property-ownerCt\" class=\"docClass\">ownerCt</a>,\nthat component's <code>updateLayout</code> method will be called to perform the layout instead.\nOtherwise, just this component (and its child items) will layout.</p>\n"},"added":{"!type":"fn(this: ?, container: ?, pos: ?, eOpts: ?)","!doc":"<p>Fires after a Component had been added to a Container.</p>\n"},"afterrender":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component rendering is finished.</p>\n\n<p>The <code>afterrender</code> event is fired after this Component has been <a href=\"#!/api/Ext.AbstractComponent-property-rendered\" rel=\"Ext.AbstractComponent-property-rendered\" class=\"docClass\">rendered</a>, been postprocessed by any\n<code>afterRender</code> method defined for the Component.</p>\n"},"beforeactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before a Component has been visually activated. Returning <code>false</code> from an event listener can prevent\nthe activate from occurring.</p>\n"},"beforedeactivate":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before a Component has been visually deactivated. Returning <code>false</code> from an event listener can\nprevent the deactivate from occurring.</p>\n"},"beforedestroy":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is <a href=\"#!/api/Ext.AbstractComponent-method-destroy\" rel=\"Ext.AbstractComponent-method-destroy\" class=\"docClass\">destroy</a>ed. Return <code>false</code> from an event handler to stop the\n<a href=\"#!/api/Ext.AbstractComponent-method-destroy\" rel=\"Ext.AbstractComponent-method-destroy\" class=\"docClass\">destroy</a>.</p>\n"},"beforehide":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method. Return <code>false</code> from an event\nhandler to stop the hide.</p>\n"},"beforerender":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is <a href=\"#!/api/Ext.AbstractComponent-property-rendered\" rel=\"Ext.AbstractComponent-property-rendered\" class=\"docClass\">rendered</a>. Return <code>false</code> from an event handler to stop the\n<a href=\"#!/api/Ext.AbstractComponent-method-render\" rel=\"Ext.AbstractComponent-method-render\" class=\"docClass\">render</a>.</p>\n"},"beforeshow":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method. Return <code>false</code> from an event\nhandler to stop the show.</p>\n"},"blur":{"!type":"fn(this: ?, The: ?, eOpts: ?)","!doc":"<p>Fires when this Component loses focus.</p>\n"},"boxready":{"!type":"fn(this: ?, width: ?, height: ?, eOpts: ?)","!doc":"<p>Fires <em>one time</em> - after the component has been laid out for the first time at its initial size.</p>\n"},"destroy":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is <a href=\"#!/api/Ext.AbstractComponent-method-destroy\" rel=\"Ext.AbstractComponent-method-destroy\" class=\"docClass\">destroy</a>ed.</p>\n"},"disable":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is disabled.</p>\n"},"enable":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is enabled.</p>\n"},"focus":{"!type":"fn(this: ?, The: ?, eOpts: ?)","!doc":"<p>Fires when this Component receives focus.</p>\n"},"hide":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is hidden. Fires after the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a>\nmethod.</p>\n"},"move":{"!type":"fn(this: ?, x: ?, y: ?, eOpts: ?)","!doc":"<p>Fires after the component is moved.</p>\n"},"removed":{"!type":"fn(this: ?, ownerCt: ?, eOpts: ?)","!doc":"<p>Fires when a component is removed from an <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.container.Container</a></p>\n"},"render":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component markup is <a href=\"#!/api/Ext.AbstractComponent-property-rendered\" rel=\"Ext.AbstractComponent-property-rendered\" class=\"docClass\">rendered</a>.</p>\n"},"show":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires after the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.</p>\n"}},"util":{"Observable":{"prototype":{"listeners":{"!doc":"<p>A config object containing one or more event handlers to be added to this object during initialization. This\nshould be a valid listeners config object as specified in the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple\nhandlers at once.</p>\n\n<p><strong>DOM events from Ext JS <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></strong></p>\n\n<p>While <em>some</em> Ext JS Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this is usually\nonly done when extra value can be added. For example the <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">DataView</a>'s <strong><code><a href=\"#!/api/Ext.view.View-event-itemclick\" rel=\"Ext.view.View-event-itemclick\" class=\"docClass\">itemclick</a></code></strong> event passing the node clicked on. To access DOM events directly from a\nchild element of a Component, we need to specify the <code>element</code> option to identify the Component property to add a\nDOM listener to:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    width: 400,\n    height: 200,\n    dockedItems: [{\n        xtype: 'toolbar'\n    }],\n    listeners: {\n        click: {\n            element: 'el', //bind to the underlying el property on the panel\n            fn: function(){ console.log('click el'); }\n        },\n        dblclick: {\n            element: 'body', //bind to the underlying body property on the panel\n            fn: function(){ console.log('dblclick body'); }\n        }\n    }\n});\n</code></pre>\n"},"eventsSuspended":{"!type":"number","!doc":"<p>Initial suspended call count. Incremented when <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a> is called, decremented when <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> is called.</p>\n"},"hasListeners":{"!doc":"<p>This object holds a key for any event that has a listener. The listener may be set\ndirectly on the instance, or on its class or a super class (via <a href=\"#!/api/Ext.util.Observable-static-method-observe\" rel=\"Ext.util.Observable-static-method-observe\" class=\"docClass\">observe</a>) or\non the <a href=\"#!/api/Ext.app.EventBus\" rel=\"Ext.app.EventBus\" class=\"docClass\">MVC EventBus</a>. The values of this object are truthy\n(a non-zero number) and falsy (0 or undefined). They do not represent an exact count\nof listeners. The value for an event is truthy if the event must be fired and is\nfalsy if there is no need to fire the event.</p>\n\n<p>The intended use of this property is to avoid the expense of fireEvent calls when\nthere are no listeners. This can be particularly helpful when one would otherwise\nhave to call fireEvent hundreds or thousands of times. It is used like this:</p>\n\n<pre><code> if (this.hasListeners.foo) {\n     this.fireEvent('foo', this, arg1);\n }\n</code></pre>\n"},"isObservable":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Observable, or subclass thereof.</p>\n"},"addEvents":{"!type":"fn(eventNames: ?) -> !this","!doc":"<p>Adds the specified events to the list of events which this Observable may fire.</p>\n"},"addManagedListener":{"!type":"fn(item: ?, ename: ?, fn?: ?, scope?: ?, options?: ?) -> ?","!doc":"<p>Adds listeners to any Observable object (or <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a>) which are automatically removed when this Component is\ndestroyed.</p>\n"},"captureArgs":{"!type":"fn(o: ?, fn: ?, scope: ?) -> !this"},"clearListeners":{"!type":"fn() -> !this","!doc":"<p>Removes all listeners for this object including the managed listeners</p>\n"},"clearManagedListeners":{"!type":"fn() -> !this","!doc":"<p>Removes all managed listeners for this object.</p>\n"},"continueFireEvent":{"!type":"fn(eventName: ?, args: ?, bubbles: ?) -> !this","!doc":"<p>Continue to fire event.</p>\n"},"createRelayer":{"!type":"fn(newName: ?, beginEnd?: ?) -> ?","!doc":"<p>Creates an event handling function which refires the event from this object as the passed event name.</p>\n"},"enableBubble":{"!type":"fn(eventNames: ?) -> !this","!doc":"<p>Enables events fired by this Observable to bubble up an owner hierarchy by calling <code>this.getBubbleTarget()</code> if\npresent. There is no implementation in the Observable base class.</p>\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers.\nSee <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>. The default implementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the\nComponent's immediate owner. But if a known target is required, this can be overridden to access the\nrequired target more quickly.</p>\n\n<p>Example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.overrides.form.field.Base', {\n    override: '<a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>',\n\n    //  Add functionality to Field's initComponent to enable the change event to bubble\n    initComponent: function () {\n        this.callParent();\n        this.enableBubble('change');\n    }\n});\n\nvar myForm = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>', {\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n"},"fireEvent":{"!type":"fn(eventName: ?, args: ?) -> bool","!doc":"<p>Fires the specified event with the passed parameters (minus the event name, plus the <code>options</code> object passed\nto <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>).</p>\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>) by\ncalling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n"},"fireEventArgs":{"!type":"fn(eventName: ?, args: ?) -> bool","!doc":"<p>Fires the specified event with the passed parameter list.</p>\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>) by\ncalling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n"},"getBubbleParent":{"!type":"fn() -> ?","!doc":"<p>Gets the bubbling parent for an Observable</p>\n"},"hasListener":{"!type":"fn(eventName: ?) -> bool","!doc":"<p>Checks to see if this object has any listeners for a specified event, or whether the event bubbles. The answer\nindicates whether the event needs firing or not.</p>\n"},"mon":{"!type":"fn(item: ?, ename: ?, fn?: ?, scope?: ?, options?: ?) -> ?","!doc":"<p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-addManagedListener\" rel=\"Ext.util.Observable-method-addManagedListener\" class=\"docClass\">addManagedListener</a>.</p>\n"},"mun":{"!type":"fn(item: ?, ename: ?, fn?: ?, scope?: ?) -> !this","!doc":"<p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeManagedListener\" rel=\"Ext.util.Observable-method-removeManagedListener\" class=\"docClass\">removeManagedListener</a>.</p>\n"},"on":{"!type":"fn(eventName: ?, fn?: ?, scope?: ?, options?: ?) -> ?","!doc":"<p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.</p>\n"},"prepareClass":{"!type":"fn(T: ?) -> !this","!doc":"<p>Prepares a given class for observable instances. This method is called when a\nclass derives from this class or uses this class as a mixin.</p>\n"},"relayEvents":{"!type":"fn(origin: ?, events: ?, prefix?: ?) -> ?","!doc":"<p>Relays selected events from the specified Observable as if the events were fired by <code>this</code>.</p>\n\n<p>For example if you are extending Grid, you might decide to forward some events from store.\nSo you can do this inside your initComponent:</p>\n\n<pre><code>this.relayEvents(this.getStore(), ['load']);\n</code></pre>\n\n<p>The grid instance will then have an observable 'load' event which will be passed the\nparameters of the store's load event and any function fired with the grid's load event\nwould have access to the grid using the <code>this</code> keyword.</p>\n"},"removeListener":{"!type":"fn(eventName: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Removes an event handler.</p>\n"},"removeManagedListener":{"!type":"fn(item: ?, ename: ?, fn?: ?, scope?: ?) -> !this","!doc":"<p>Removes listeners that were added by the <a href=\"#!/api/Ext.util.Observable-method-mon\" rel=\"Ext.util.Observable-method-mon\" class=\"docClass\">mon</a> method.</p>\n"},"resumeEvent":{"!type":"fn(eventName: ?) -> !this","!doc":"<p>Resumes firing of the named event(s).</p>\n\n<p>After calling this method to resume events, the events will fire when requested to fire.</p>\n\n<p><strong>Note that if the <a href=\"#!/api/Ext.util.Observable-method-suspendEvent\" rel=\"Ext.util.Observable-method-suspendEvent\" class=\"docClass\">suspendEvent</a> method is called multiple times for a certain event,\nthis converse method will have to be called the same number of times for it to resume firing.</strong></p>\n"},"resumeEvents":{"!type":"fn() -> !this","!doc":"<p>Resumes firing events (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>).</p>\n\n<p>If events were suspended using the <code>queueSuspended</code> parameter, then all events fired\nduring event suspension will be sent to any listeners now.</p>\n"},"suspendEvent":{"!type":"fn(eventName: ?) -> !this","!doc":"<p>Suspends firing of the named event(s).</p>\n\n<p>After calling this method to suspend events, the events will no longer fire when requested to fire.</p>\n\n<p><strong>Note that if this is called multiple times for a certain event, the converse method\n<a href=\"#!/api/Ext.util.Observable-method-resumeEvent\" rel=\"Ext.util.Observable-method-resumeEvent\" class=\"docClass\">resumeEvent</a> will have to be called the same number of times for it to resume firing.</strong></p>\n"},"suspendEvents":{"!type":"fn(queueSuspended: ?) -> !this","!doc":"<p>Suspends the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n"},"un":{"!type":"fn(eventName: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.</p>\n"},"addListener":{"!type":"fn(eventName: ?, fn?: ?, scope?: ?, options?: ?) -> ?","!doc":"<p>Appends an event handler to this object.  For example:</p>\n\n<pre><code>myGridPanel.on(\"mouseover\", this.onMouseOver, this);\n</code></pre>\n\n<p>The method also allows for a single argument to be passed which is a config object\ncontaining properties which specify multiple events. For example:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: this.onCellClick,\n    mouseover: this.onMouseOver,\n    mouseout: this.onMouseOut,\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n<p>One can also specify options for each event handler separately:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: this.onCellClick, scope: this, single: true},\n    mouseover: {fn: panel.onMouseOver, scope: panel}\n});\n</code></pre>\n\n<p><em>Names</em> of methods in a specified scope may also be used. Note that\n<code>scope</code> MUST be specified to use this option:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: 'onCellClick', scope: this, single: true},\n    mouseover: {fn: 'onMouseOver', scope: panel}\n});\n</code></pre>\n"},"removeManagedListenerItem":{"!type":"fn(isClear: ?, managedListener: ?) -> !this","!doc":"<p>Remove a single managed listener item</p>\n"},"capture":{"!type":"fn(o: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Starts capture on the specified Observable. All events will be passed to the supplied function with the event\nname + standard signature of the event <strong>before</strong> the event is fired. If the supplied function returns false,\nthe event will not fire.</p>\n"},"observe":{"!type":"fn(c: ?, listeners: ?) -> !this","!doc":"<p>Sets observability on the passed class constructor.</p>\n\n<p>This makes any event fired on any instance of the passed class also fire a single event through\nthe <strong>class</strong> allowing for central handling of events on many instances at once.</p>\n\n<p>Usage:</p>\n\n<pre><code><a href=\"#!/api/Ext.util.Observable-static-method-observe\" rel=\"Ext.util.Observable-static-method-observe\" class=\"docClass\">Ext.util.Observable.observe</a>(<a href=\"#!/api/Ext.data.Connection\" rel=\"Ext.data.Connection\" class=\"docClass\">Ext.data.Connection</a>);\n<a href=\"#!/api/Ext.data.Connection-method-on\" rel=\"Ext.data.Connection-method-on\" class=\"docClass\">Ext.data.Connection.on</a>('beforerequest', function(con, options) {\n    console.log('Ajax request made to ' + options.url);\n});\n</code></pre>\n"},"releaseCapture":{"!type":"fn(o: ?) -> !this","!doc":"<p>Removes <strong>all</strong> added captures from the Observable.</p>\n"}},"listeners":{"!doc":"<p>A config object containing one or more event handlers to be added to this object during initialization. This\nshould be a valid listeners config object as specified in the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple\nhandlers at once.</p>\n\n<p><strong>DOM events from Ext JS <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></strong></p>\n\n<p>While <em>some</em> Ext JS Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this is usually\nonly done when extra value can be added. For example the <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">DataView</a>'s <strong><code><a href=\"#!/api/Ext.view.View-event-itemclick\" rel=\"Ext.view.View-event-itemclick\" class=\"docClass\">itemclick</a></code></strong> event passing the node clicked on. To access DOM events directly from a\nchild element of a Component, we need to specify the <code>element</code> option to identify the Component property to add a\nDOM listener to:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    width: 400,\n    height: 200,\n    dockedItems: [{\n        xtype: 'toolbar'\n    }],\n    listeners: {\n        click: {\n            element: 'el', //bind to the underlying el property on the panel\n            fn: function(){ console.log('click el'); }\n        },\n        dblclick: {\n            element: 'body', //bind to the underlying body property on the panel\n            fn: function(){ console.log('dblclick body'); }\n        }\n    }\n});\n</code></pre>\n"},"eventsSuspended":{"!type":"number","!doc":"<p>Initial suspended call count. Incremented when <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a> is called, decremented when <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> is called.</p>\n"},"hasListeners":{"!doc":"<p>This object holds a key for any event that has a listener. The listener may be set\ndirectly on the instance, or on its class or a super class (via <a href=\"#!/api/Ext.util.Observable-static-method-observe\" rel=\"Ext.util.Observable-static-method-observe\" class=\"docClass\">observe</a>) or\non the <a href=\"#!/api/Ext.app.EventBus\" rel=\"Ext.app.EventBus\" class=\"docClass\">MVC EventBus</a>. The values of this object are truthy\n(a non-zero number) and falsy (0 or undefined). They do not represent an exact count\nof listeners. The value for an event is truthy if the event must be fired and is\nfalsy if there is no need to fire the event.</p>\n\n<p>The intended use of this property is to avoid the expense of fireEvent calls when\nthere are no listeners. This can be particularly helpful when one would otherwise\nhave to call fireEvent hundreds or thousands of times. It is used like this:</p>\n\n<pre><code> if (this.hasListeners.foo) {\n     this.fireEvent('foo', this, arg1);\n }\n</code></pre>\n"},"isObservable":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Observable, or subclass thereof.</p>\n"},"addEvents":{"!type":"fn(eventNames: ?) -> !this","!doc":"<p>Adds the specified events to the list of events which this Observable may fire.</p>\n"},"addListener":{"!type":"fn(eventName: ?, fn?: ?, scope?: ?, options?: ?) -> ?","!doc":"<p>Appends an event handler to this object.  For example:</p>\n\n<pre><code>myGridPanel.on(\"mouseover\", this.onMouseOver, this);\n</code></pre>\n\n<p>The method also allows for a single argument to be passed which is a config object\ncontaining properties which specify multiple events. For example:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: this.onCellClick,\n    mouseover: this.onMouseOver,\n    mouseout: this.onMouseOut,\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n<p>One can also specify options for each event handler separately:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: this.onCellClick, scope: this, single: true},\n    mouseover: {fn: panel.onMouseOver, scope: panel}\n});\n</code></pre>\n\n<p><em>Names</em> of methods in a specified scope may also be used. Note that\n<code>scope</code> MUST be specified to use this option:</p>\n\n<pre><code>myGridPanel.on({\n    cellClick: {fn: 'onCellClick', scope: this, single: true},\n    mouseover: {fn: 'onMouseOver', scope: panel}\n});\n</code></pre>\n"},"addManagedListener":{"!type":"fn(item: ?, ename: ?, fn?: ?, scope?: ?, options?: ?) -> ?","!doc":"<p>Adds listeners to any Observable object (or <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a>) which are automatically removed when this Component is\ndestroyed.</p>\n"},"captureArgs":{"!type":"fn(o: ?, fn: ?, scope: ?) -> !this"},"clearListeners":{"!type":"fn() -> !this","!doc":"<p>Removes all listeners for this object including the managed listeners</p>\n"},"clearManagedListeners":{"!type":"fn() -> !this","!doc":"<p>Removes all managed listeners for this object.</p>\n"},"continueFireEvent":{"!type":"fn(eventName: ?, args: ?, bubbles: ?) -> !this","!doc":"<p>Continue to fire event.</p>\n"},"createRelayer":{"!type":"fn(newName: ?, beginEnd?: ?) -> ?","!doc":"<p>Creates an event handling function which refires the event from this object as the passed event name.</p>\n"},"enableBubble":{"!type":"fn(eventNames: ?) -> !this","!doc":"<p>Enables events fired by this Observable to bubble up an owner hierarchy by calling <code>this.getBubbleTarget()</code> if\npresent. There is no implementation in the Observable base class.</p>\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers.\nSee <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>. The default implementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the\nComponent's immediate owner. But if a known target is required, this can be overridden to access the\nrequired target more quickly.</p>\n\n<p>Example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.overrides.form.field.Base', {\n    override: '<a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">Ext.form.field.Base</a>',\n\n    //  Add functionality to Field's initComponent to enable the change event to bubble\n    initComponent: function () {\n        this.callParent();\n        this.enableBubble('change');\n    }\n});\n\nvar myForm = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a>', {\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n"},"fireEvent":{"!type":"fn(eventName: ?, args: ?) -> bool","!doc":"<p>Fires the specified event with the passed parameters (minus the event name, plus the <code>options</code> object passed\nto <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>).</p>\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>) by\ncalling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n"},"fireEventArgs":{"!type":"fn(eventName: ?, args: ?) -> bool","!doc":"<p>Fires the specified event with the passed parameter list.</p>\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>) by\ncalling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n"},"getBubbleParent":{"!type":"fn() -> ?","!doc":"<p>Gets the bubbling parent for an Observable</p>\n"},"hasListener":{"!type":"fn(eventName: ?) -> bool","!doc":"<p>Checks to see if this object has any listeners for a specified event, or whether the event bubbles. The answer\nindicates whether the event needs firing or not.</p>\n"},"mon":{"!type":"fn(item: ?, ename: ?, fn?: ?, scope?: ?, options?: ?) -> ?","!doc":"<p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-addManagedListener\" rel=\"Ext.util.Observable-method-addManagedListener\" class=\"docClass\">addManagedListener</a>.</p>\n"},"mun":{"!type":"fn(item: ?, ename: ?, fn?: ?, scope?: ?) -> !this","!doc":"<p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeManagedListener\" rel=\"Ext.util.Observable-method-removeManagedListener\" class=\"docClass\">removeManagedListener</a>.</p>\n"},"on":{"!type":"fn(eventName: ?, fn?: ?, scope?: ?, options?: ?) -> ?","!doc":"<p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.</p>\n"},"prepareClass":{"!type":"fn(T: ?) -> !this","!doc":"<p>Prepares a given class for observable instances. This method is called when a\nclass derives from this class or uses this class as a mixin.</p>\n"},"relayEvents":{"!type":"fn(origin: ?, events: ?, prefix?: ?) -> ?","!doc":"<p>Relays selected events from the specified Observable as if the events were fired by <code>this</code>.</p>\n\n<p>For example if you are extending Grid, you might decide to forward some events from store.\nSo you can do this inside your initComponent:</p>\n\n<pre><code>this.relayEvents(this.getStore(), ['load']);\n</code></pre>\n\n<p>The grid instance will then have an observable 'load' event which will be passed the\nparameters of the store's load event and any function fired with the grid's load event\nwould have access to the grid using the <code>this</code> keyword.</p>\n"},"removeListener":{"!type":"fn(eventName: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Removes an event handler.</p>\n"},"removeManagedListener":{"!type":"fn(item: ?, ename: ?, fn?: ?, scope?: ?) -> !this","!doc":"<p>Removes listeners that were added by the <a href=\"#!/api/Ext.util.Observable-method-mon\" rel=\"Ext.util.Observable-method-mon\" class=\"docClass\">mon</a> method.</p>\n"},"removeManagedListenerItem":{"!type":"fn(isClear: ?, managedListener: ?) -> !this","!doc":"<p>Remove a single managed listener item</p>\n"},"resumeEvent":{"!type":"fn(eventName: ?) -> !this","!doc":"<p>Resumes firing of the named event(s).</p>\n\n<p>After calling this method to resume events, the events will fire when requested to fire.</p>\n\n<p><strong>Note that if the <a href=\"#!/api/Ext.util.Observable-method-suspendEvent\" rel=\"Ext.util.Observable-method-suspendEvent\" class=\"docClass\">suspendEvent</a> method is called multiple times for a certain event,\nthis converse method will have to be called the same number of times for it to resume firing.</strong></p>\n"},"resumeEvents":{"!type":"fn() -> !this","!doc":"<p>Resumes firing events (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>).</p>\n\n<p>If events were suspended using the <code>queueSuspended</code> parameter, then all events fired\nduring event suspension will be sent to any listeners now.</p>\n"},"suspendEvent":{"!type":"fn(eventName: ?) -> !this","!doc":"<p>Suspends firing of the named event(s).</p>\n\n<p>After calling this method to suspend events, the events will no longer fire when requested to fire.</p>\n\n<p><strong>Note that if this is called multiple times for a certain event, the converse method\n<a href=\"#!/api/Ext.util.Observable-method-resumeEvent\" rel=\"Ext.util.Observable-method-resumeEvent\" class=\"docClass\">resumeEvent</a> will have to be called the same number of times for it to resume firing.</strong></p>\n"},"suspendEvents":{"!type":"fn(queueSuspended: ?) -> !this","!doc":"<p>Suspends the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n"},"un":{"!type":"fn(eventName: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.</p>\n"},"!doc":"<p>Base class that provides a common interface for publishing events. Subclasses are expected to to have a property\n\"events\" with all the events defined, and, optionally, a property \"listeners\" with configured listeners defined.</p>\n\n<p>For example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Employee', {\n    mixins: {\n        observable: '<a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a>'\n    },\n\n    constructor: function (config) {\n        // The Observable constructor copies all of the properties of `config` on\n        // to `this` using <a href=\"#!/api/Ext-method-apply\" rel=\"Ext-method-apply\" class=\"docClass\">Ext.apply</a>. Further, the `listeners` property is\n        // processed to add listeners.\n        //\n        this.mixins.observable.constructor.call(this, config);\n\n        this.addEvents(\n            'fired',\n            'quit'\n        );\n    }\n});\n</code></pre>\n\n<p>This could then be used like this:</p>\n\n<pre><code>var newEmployee = new Employee({\n    name: employeeName,\n    listeners: {\n        quit: function() {\n            // By default, \"this\" will be the object that fired the event.\n            alert(this.name + \" has quit!\");\n        }\n    }\n});\n</code></pre>\n"},"Positionable":{"prototype":{"_alignRe":{},"_positionTopLeft":{},"convertPositionSpec":{"!doc":"<p>By default this method does nothing but return the position spec passed to it. In\nrtl mode it is overridden to convert \"l\" to \"r\" and vice versa when required.</p>\n"},"adjustForConstraints":{"!type":"fn(xy: ?, parent: ?) -> !this","!doc":"<p>private ==>  used outside of core\nTODO: currently only used by ToolTip. does this method belong here?</p>\n"},"alignTo":{"!type":"fn(element: ?, position?: ?, offsets?: ?, animate?: ?) -> ?","!doc":"<p>Aligns the element with another element relative to the specified anchor points. If\nthe other element is the document it aligns it to the viewport. The position\nparameter is optional, and can be specified in any one of the following formats:</p>\n\n<ul>\n<li><strong>Blank</strong>: Defaults to aligning the element's top-left corner to the target's\nbottom-left corner (\"tl-bl\").</li>\n<li><strong>One anchor (deprecated)</strong>: The passed anchor position is used as the target\nelement's anchor point.  The element being aligned will position its top-left\ncorner (tl) to that point. <em>This method has been deprecated in favor of the newer\ntwo anchor syntax below</em>.</li>\n<li><strong>Two anchors</strong>: If two values from the table below are passed separated by a dash,\nthe first value is used as the element's anchor point, and the second value is\nused as the target's anchor point.</li>\n</ul>\n\n\n<p>In addition to the anchor points, the position parameter also supports the \"?\"\ncharacter. If \"?\" is passed at the end of the position string, the element will\nattempt to align as specified, but the position will be adjusted to constrain to\nthe viewport if necessary. Note that the element being aligned might be swapped to\nalign to a different position than that specified in order to enforce the viewport\nconstraints. Following are all of the supported anchor positions:</p>\n\n<pre>Value  Description\n-----  -----------------------------\ntl     The top left corner (default)\nt      The center of the top edge\ntr     The top right corner\nl      The center of the left edge\nc      In the center of the element\nr      The center of the right edge\nbl     The bottom left corner\nb      The center of the bottom edge\nbr     The bottom right corner\n</pre>\n\n\n<p>Example Usage:</p>\n\n<pre><code>// align el to other-el using the default positioning\n// (\"tl-bl\", non-constrained)\nel.alignTo(\"other-el\");\n\n// align the top left corner of el with the top right corner of other-el\n// (constrained to viewport)\nel.alignTo(\"other-el\", \"tr?\");\n\n// align the bottom right corner of el with the center left edge of other-el\nel.alignTo(\"other-el\", \"br-l?\");\n\n// align the center of el with the bottom left corner of other-el and\n// adjust the x position by -6 pixels (and the y position by 0)\nel.alignTo(\"other-el\", \"c-bl\", [-6, 0]);\n</code></pre>\n"},"anchorTo":{"!type":"fn(element: ?, position?: ?, offsets?: ?, animate?: ?, monitorScroll?: ?, callback?: ?) -> ?","!doc":"<p>Anchors an element to another element and realigns it when the window is resized.</p>\n"},"calculateAnchorXY":{"!type":"fn(anchor?: ?, extraX?: ?, extraY?: ?, size?: ?) -> ?","!doc":"<p>Calculates x,y coordinates specified by the anchor position on the element, adding\nextraX and extraY values.</p>\n"},"calculateConstrainedPosition":{"!type":"fn(constrainTo?: ?, proposedPosition?: ?, local?: ?, proposedSize?: ?) -> ?","!doc":"<p>Calculates the new [x,y] position to move this Positionable into a constrain region.</p>\n\n<p>By default, this Positionable is constrained to be within the container it was added to, or the element it was\nrendered to.</p>\n\n<p>Priority is given to constraining the top and left within the constraint.</p>\n\n<p>An alternative constraint may be passed.</p>\n"},"getAlignToXY":{"!type":"fn(element: ?, position?: ?, offsets?: ?) -> ?","!doc":"<p>Gets the x,y coordinates to align this element with another element. See\n<a href=\"#!/api/Ext.util.Positionable-method-alignTo\" rel=\"Ext.util.Positionable-method-alignTo\" class=\"docClass\">alignTo</a> for more info on the supported position values.</p>\n"},"getAnchor":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"getAnchorXY":{"!type":"fn(anchor?: ?, local?: ?, size?: ?) -> ?","!doc":"<p>Gets the x,y coordinates specified by the anchor position on the element.</p>\n"},"getBox":{"!type":"fn(contentBox?: ?, local?: ?) -> ?","!doc":"<p>Return an object defining the area of this Element which can be passed to\n<a href=\"#!/api/Ext.util.Positionable-method-setBox\" rel=\"Ext.util.Positionable-method-setBox\" class=\"docClass\">setBox</a> to set another Element's size/location to match this element.</p>\n"},"getConstrainVector":{"!type":"fn(constrainTo?: ?, proposedPosition?: ?, proposedSize?: ?) -> ?","!doc":"<p>Returns the <code>[X, Y]</code> vector by which this Positionable's element must be translated to make a best\nattempt to constrain within the passed constraint. Returns <code>false</code> if the element\ndoes not need to be moved.</p>\n\n<p>Priority is given to constraining the top and left within the constraint.</p>\n\n<p>The constraint may either be an existing element into which the element is to be\nconstrained, or a <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Region</a> into which this element is to be\nconstrained.</p>\n\n<p>By default, any extra shadow around the element is <strong>not</strong> included in the constrain calculations - the edges\nof the element are used as the element bounds. To constrain the shadow within the constrain region, set the\n<code>constrainShadow</code> property on this element to <code>true</code>.</p>\n"},"getOffsetsTo":{"!type":"fn(offsetsTo: ?) -> ?","!doc":"<p>Returns the offsets of this element from the passed element. The element must both\nbe part of the DOM tree and not have display:none to have page coordinates.</p>\n"},"getRegion":{"!type":"fn() -> ?","!doc":"<p>Returns a region object that defines the area of this element.</p>\n"},"getViewRegion":{"!type":"fn() -> ?","!doc":"<p>Returns the <strong>content</strong> region of this element. That is the region within the borders\nand padding.</p>\n"},"move":{"!type":"fn(direction: ?, distance: ?, animate?: ?) -> !this","!doc":"<p>Move the element relative to its current position.</p>\n"},"removeAnchor":{"!type":"fn() -> ?","!doc":"<p>Remove any anchor to this element. See <a href=\"#!/api/Ext.util.Positionable-method-anchorTo\" rel=\"Ext.util.Positionable-method-anchorTo\" class=\"docClass\">anchorTo</a>.</p>\n"},"setBox":{"!type":"fn(box: ?, animate?: ?) -> ?","!doc":"<p>Sets the element's box. If animate is true then x, y, width, and height will be\nanimated concurrently.</p>\n"},"setRegion":{"!type":"fn(region: ?, animate?: ?) -> ?","!doc":"<p>Sets the element's position and size to the specified region. If animation is true\nthen width, height, x and y will be animated concurrently.</p>\n"},"translatePoints":{"!type":"fn(x: ?, y?: ?) -> ?","!doc":"<p>Translates the passed page coordinates into left/top css values for the element</p>\n"},"translateXY":{"!type":"fn(x: ?, y?: ?) -> ?","!doc":"<p>Translates the passed page coordinates into x and y css values for the element</p>\n"},"afterSetPosition":{"!type":"fn() -> !this","!doc":"<p>Stub implementation called after positioning.\nMay be implemented in subclasses. AbstractComponent has an implementation.</p>\n"},"getAnchorToXY":{"!type":"fn(el: ?, anchor?: ?, local?: ?, size?: ?) -> ?","!doc":"<p>Gets the x,y coordinates of an element specified by the anchor position on the\nelement.</p>\n"},"getBorderPadding":{"!type":"fn() -> ?","!doc":"<p>Returns the size of the element's borders and padding.</p>\n"},"getLocalX":{"!type":"fn() -> number","!doc":"<p>Returns the x coordinate of this element reletive to its <code>offsetParent</code>.</p>\n"},"getLocalXY":{"!type":"fn() -> ?","!doc":"<p>Returns the x and y coordinates of this element relative to its <code>offsetParent</code>.</p>\n"},"getLocalY":{"!type":"fn() -> number","!doc":"<p>Returns the y coordinate of this element reletive to its <code>offsetParent</code>.</p>\n"},"getX":{"!type":"fn() -> number","!doc":"<p>Gets the current X position of the DOM element based on page coordinates.</p>\n"},"getXY":{"!type":"fn() -> ?","!doc":"<p>Gets the current position of the DOM element based on page coordinates.</p>\n"},"getY":{"!type":"fn() -> number","!doc":"<p>Gets the current Y position of the DOM element based on page coordinates.</p>\n"},"setLocalX":{"!type":"fn(x: ?) -> ?","!doc":"<p>Sets the local x coordinate of this element using CSS style. When used on an\nabsolute positioned element this method is symmetrical with <a href=\"#!/api/Ext.util.Positionable-method-getLocalX\" rel=\"Ext.util.Positionable-method-getLocalX\" class=\"docClass\">getLocalX</a>, but\nmay not be symmetrical when used on a relatively positioned element.</p>\n"},"setLocalXY":{"!type":"fn(x: ?, y?: ?) -> ?","!doc":"<p>Sets the local x and y coordinates of this element using CSS style. When used on an\nabsolute positioned element this method is symmetrical with <a href=\"#!/api/Ext.util.Positionable-method-getLocalXY\" rel=\"Ext.util.Positionable-method-getLocalXY\" class=\"docClass\">getLocalXY</a>, but\nmay not be symmetrical when used on a relatively positioned element.</p>\n"},"setLocalY":{"!type":"fn(y: ?) -> ?","!doc":"<p>Sets the local y coordinate of this element using CSS style. When used on an\nabsolute positioned element this method is symmetrical with <a href=\"#!/api/Ext.util.Positionable-method-getLocalY\" rel=\"Ext.util.Positionable-method-getLocalY\" class=\"docClass\">getLocalY</a>, but\nmay not be symmetrical when used on a relatively positioned element.</p>\n"},"setX":{"!type":"fn(The: ?, animate?: ?) -> ?","!doc":"<p>Sets the X position of the DOM element based on page coordinates.</p>\n"},"setXY":{"!type":"fn(pos: ?, animate?: ?) -> ?","!doc":"<p>Sets the position of the DOM element in page coordinates.</p>\n"},"setY":{"!type":"fn(The: ?, animate?: ?) -> ?","!doc":"<p>Sets the Y position of the DOM element based on page coordinates.</p>\n"}},"_alignRe":{},"_positionTopLeft":{},"convertPositionSpec":{"!doc":"<p>By default this method does nothing but return the position spec passed to it. In\nrtl mode it is overridden to convert \"l\" to \"r\" and vice versa when required.</p>\n"},"adjustForConstraints":{"!type":"fn(xy: ?, parent: ?) -> !this","!doc":"<p>private ==>  used outside of core\nTODO: currently only used by ToolTip. does this method belong here?</p>\n"},"alignTo":{"!type":"fn(element: ?, position?: ?, offsets?: ?, animate?: ?) -> ?","!doc":"<p>Aligns the element with another element relative to the specified anchor points. If\nthe other element is the document it aligns it to the viewport. The position\nparameter is optional, and can be specified in any one of the following formats:</p>\n\n<ul>\n<li><strong>Blank</strong>: Defaults to aligning the element's top-left corner to the target's\nbottom-left corner (\"tl-bl\").</li>\n<li><strong>One anchor (deprecated)</strong>: The passed anchor position is used as the target\nelement's anchor point.  The element being aligned will position its top-left\ncorner (tl) to that point. <em>This method has been deprecated in favor of the newer\ntwo anchor syntax below</em>.</li>\n<li><strong>Two anchors</strong>: If two values from the table below are passed separated by a dash,\nthe first value is used as the element's anchor point, and the second value is\nused as the target's anchor point.</li>\n</ul>\n\n\n<p>In addition to the anchor points, the position parameter also supports the \"?\"\ncharacter. If \"?\" is passed at the end of the position string, the element will\nattempt to align as specified, but the position will be adjusted to constrain to\nthe viewport if necessary. Note that the element being aligned might be swapped to\nalign to a different position than that specified in order to enforce the viewport\nconstraints. Following are all of the supported anchor positions:</p>\n\n<pre>Value  Description\n-----  -----------------------------\ntl     The top left corner (default)\nt      The center of the top edge\ntr     The top right corner\nl      The center of the left edge\nc      In the center of the element\nr      The center of the right edge\nbl     The bottom left corner\nb      The center of the bottom edge\nbr     The bottom right corner\n</pre>\n\n\n<p>Example Usage:</p>\n\n<pre><code>// align el to other-el using the default positioning\n// (\"tl-bl\", non-constrained)\nel.alignTo(\"other-el\");\n\n// align the top left corner of el with the top right corner of other-el\n// (constrained to viewport)\nel.alignTo(\"other-el\", \"tr?\");\n\n// align the bottom right corner of el with the center left edge of other-el\nel.alignTo(\"other-el\", \"br-l?\");\n\n// align the center of el with the bottom left corner of other-el and\n// adjust the x position by -6 pixels (and the y position by 0)\nel.alignTo(\"other-el\", \"c-bl\", [-6, 0]);\n</code></pre>\n"},"anchorTo":{"!type":"fn(element: ?, position?: ?, offsets?: ?, animate?: ?, monitorScroll?: ?, callback?: ?) -> ?","!doc":"<p>Anchors an element to another element and realigns it when the window is resized.</p>\n"},"calculateAnchorXY":{"!type":"fn(anchor?: ?, extraX?: ?, extraY?: ?, size?: ?) -> ?","!doc":"<p>Calculates x,y coordinates specified by the anchor position on the element, adding\nextraX and extraY values.</p>\n"},"calculateConstrainedPosition":{"!type":"fn(constrainTo?: ?, proposedPosition?: ?, local?: ?, proposedSize?: ?) -> ?","!doc":"<p>Calculates the new [x,y] position to move this Positionable into a constrain region.</p>\n\n<p>By default, this Positionable is constrained to be within the container it was added to, or the element it was\nrendered to.</p>\n\n<p>Priority is given to constraining the top and left within the constraint.</p>\n\n<p>An alternative constraint may be passed.</p>\n"},"getAlignToXY":{"!type":"fn(element: ?, position?: ?, offsets?: ?) -> ?","!doc":"<p>Gets the x,y coordinates to align this element with another element. See\n<a href=\"#!/api/Ext.util.Positionable-method-alignTo\" rel=\"Ext.util.Positionable-method-alignTo\" class=\"docClass\">alignTo</a> for more info on the supported position values.</p>\n"},"getAnchor":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"getAnchorXY":{"!type":"fn(anchor?: ?, local?: ?, size?: ?) -> ?","!doc":"<p>Gets the x,y coordinates specified by the anchor position on the element.</p>\n"},"getBox":{"!type":"fn(contentBox?: ?, local?: ?) -> ?","!doc":"<p>Return an object defining the area of this Element which can be passed to\n<a href=\"#!/api/Ext.util.Positionable-method-setBox\" rel=\"Ext.util.Positionable-method-setBox\" class=\"docClass\">setBox</a> to set another Element's size/location to match this element.</p>\n"},"getConstrainVector":{"!type":"fn(constrainTo?: ?, proposedPosition?: ?, proposedSize?: ?) -> ?","!doc":"<p>Returns the <code>[X, Y]</code> vector by which this Positionable's element must be translated to make a best\nattempt to constrain within the passed constraint. Returns <code>false</code> if the element\ndoes not need to be moved.</p>\n\n<p>Priority is given to constraining the top and left within the constraint.</p>\n\n<p>The constraint may either be an existing element into which the element is to be\nconstrained, or a <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Region</a> into which this element is to be\nconstrained.</p>\n\n<p>By default, any extra shadow around the element is <strong>not</strong> included in the constrain calculations - the edges\nof the element are used as the element bounds. To constrain the shadow within the constrain region, set the\n<code>constrainShadow</code> property on this element to <code>true</code>.</p>\n"},"getOffsetsTo":{"!type":"fn(offsetsTo: ?) -> ?","!doc":"<p>Returns the offsets of this element from the passed element. The element must both\nbe part of the DOM tree and not have display:none to have page coordinates.</p>\n"},"getRegion":{"!type":"fn() -> ?","!doc":"<p>Returns a region object that defines the area of this element.</p>\n"},"getViewRegion":{"!type":"fn() -> ?","!doc":"<p>Returns the <strong>content</strong> region of this element. That is the region within the borders\nand padding.</p>\n"},"removeAnchor":{"!type":"fn() -> ?","!doc":"<p>Remove any anchor to this element. See <a href=\"#!/api/Ext.util.Positionable-method-anchorTo\" rel=\"Ext.util.Positionable-method-anchorTo\" class=\"docClass\">anchorTo</a>.</p>\n"},"setBox":{"!type":"fn(box: ?, animate?: ?) -> ?","!doc":"<p>Sets the element's box. If animate is true then x, y, width, and height will be\nanimated concurrently.</p>\n"},"setRegion":{"!type":"fn(region: ?, animate?: ?) -> ?","!doc":"<p>Sets the element's position and size to the specified region. If animation is true\nthen width, height, x and y will be animated concurrently.</p>\n"},"translatePoints":{"!type":"fn(x: ?, y?: ?) -> ?","!doc":"<p>Translates the passed page coordinates into left/top css values for the element</p>\n"},"translateXY":{"!type":"fn(x: ?, y?: ?) -> ?","!doc":"<p>Translates the passed page coordinates into x and y css values for the element</p>\n"},"!doc":"<p>This mixin provides a common interface for objects that can be positioned, e.g.\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a> and <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Elements</a></p>\n"},"ElementContainer":{"prototype":{"childEls":{},"addChildEls":{"!type":"fn() -> !this","!doc":"<p>Adds each argument passed to this method to the <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> array.</p>\n"},"applyChildEls":{"!type":"fn(el: ?, id: ?) -> !this","!doc":"<p>Sets references to elements inside the component.</p>\n"},"getChildEls":{"!type":"fn() -> !this"},"getClassChildEls":{"!type":"fn(cls: ?) -> !this"},"prune":{"!type":"fn(childEls: ?, shared: ?) -> !this"},"removeChildEls":{"!type":"fn(testFn: ?) -> !this","!doc":"<p>Removes items in the childEls array based on the return value of a supplied test\nfunction. The function is called with a entry in childEls and if the test function\nreturn true, that entry is removed. If false, that entry is kept.</p>\n"},"destroy":{"!type":"fn() -> !this"}},"addChildEls":{"!type":"fn() -> !this","!doc":"<p>Adds each argument passed to this method to the <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a> array.</p>\n"},"applyChildEls":{"!type":"fn(el: ?, id: ?) -> !this","!doc":"<p>Sets references to elements inside the component.</p>\n"},"getChildEls":{"!type":"fn() -> !this"},"getClassChildEls":{"!type":"fn(cls: ?) -> !this"},"prune":{"!type":"fn(childEls: ?, shared: ?) -> !this"},"removeChildEls":{"!type":"fn(testFn: ?) -> !this","!doc":"<p>Removes items in the childEls array based on the return value of a supplied test\nfunction. The function is called with a entry in childEls and if the test function\nreturn true, that entry is removed. If false, that entry is kept.</p>\n"},"!doc":"<p>This mixin enables classes to declare relationships to child elements and provides the\nmechanics for acquiring the <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">elements</a> and storing them on an object\ninstance as properties.</p>\n\n<p>This class is used by <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">components</a> and <a href=\"#!/api/Ext.layout.container.Container\" rel=\"Ext.layout.container.Container\" class=\"docClass\">container layouts</a> to\nmanage their child elements.</p>\n\n<p>A typical component that uses these features might look something like this:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.ux.SomeComponent', {\n     extend: '<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>',\n\n     childEls: [\n         'bodyEl'\n     ],\n\n     renderTpl: [\n         '&lt;div id=\"{id}-bodyEl\"&gt;&lt;/div&gt;'\n     ],\n\n     // ...\n });\n</code></pre>\n\n<p>The <code>childEls</code> array lists one or more relationships to child elements managed by the\ncomponent. The items in this array can be either of the following types:</p>\n\n<ul>\n<li>String: the id suffix and property name in one. For example, \"bodyEl\" in the above\nexample means a \"bodyEl\" property will be added to the instance with the result of\n<a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a> given \"componentId-bodyEl\" where \"componentId\" is the component instance's\nid.</li>\n<li>Object: with a <code>name</code> property that names the instance property for the element, and\none of the following additional properties:\n\n<ul>\n<li> <code>id</code>: The full id of the child element.</li>\n<li> <code>itemId</code>: The suffix part of the id to which \"componentId-\" is prepended.</li>\n<li> <code>select</code>: A selector that will be passed to <a href=\"#!/api/Ext-method-select\" rel=\"Ext-method-select\" class=\"docClass\">Ext.select</a>.</li>\n<li> <code>selectNode</code>: A selector that will be passed to <a href=\"#!/api/Ext.dom.Query-method-selectNode\" rel=\"Ext.dom.Query-method-selectNode\" class=\"docClass\">Ext.DomQuery.selectNode</a>.</li>\n</ul>\n</li>\n</ul>\n\n\n<p>The example above could have used this instead to achieve the same result:</p>\n\n<pre><code> childEls: [\n     { name: 'bodyEl', itemId: 'bodyEl' }\n ]\n</code></pre>\n\n<p>When using <code>select</code>, the property will be an instance of <a href=\"#!/api/Ext.dom.CompositeElement\" rel=\"Ext.dom.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a>. In\nall other cases, the property will be an <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a> or <code>null</code> if not found.</p>\n\n<p>Care should be taken when using <code>select</code> or <code>selectNode</code> to find child elements. The\nfollowing issues should be considered:</p>\n\n<ul>\n<li>Performance: using selectors can be slower than id lookup by a factor 10x or more.</li>\n<li>Over-selecting: selectors are applied after the DOM elements for all children have\nbeen rendered, so selectors can match elements from child components (including nested\nversions of the same component) accidentally.</li>\n</ul>\n\n\n<p>This above issues are most important when using <code>select</code> since it returns multiple\nelements.</p>\n\n<p><strong>IMPORTANT</strong>\nUnlike a <code>renderTpl</code> where there is a single value for an instance, <code>childEls</code> are aggregated\nup the class hierarchy so that they are effectively inherited. In other words, if a\nclass where to derive from <code>Ext.ux.SomeComponent</code> in the example above, it could also\nhave a <code>childEls</code> property in the same way as <code>Ext.ux.SomeComponent</code>.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.ux.AnotherComponent', {\n     extend: 'Ext.ux.SomeComponent',\n\n     childEls: [\n         // 'bodyEl' is inherited\n         'innerEl'\n     ],\n\n     renderTpl: [\n         '&lt;div id=\"{id}-bodyEl\"&gt;'\n             '&lt;div id=\"{id}-innerEl\"&gt;&lt;/div&gt;'\n         '&lt;/div&gt;'\n     ],\n\n     // ...\n });\n</code></pre>\n\n<p>The <code>renderTpl</code> contains both child elements and unites them in the desired markup, but\nthe <code>childEls</code> only contains the new child element. The <a href=\"#!/api/Ext.util.ElementContainer-method-applyChildEls\" rel=\"Ext.util.ElementContainer-method-applyChildEls\" class=\"docClass\">applyChildEls</a> method\ntakes care of looking up all <code>childEls</code> for an instance and considers <code>childEls</code>\nproperties on all the super classes and mixins.</p>\n","!type":"fn()"},"Renderable":{"prototype":{"frameCls":{"!type":"string"},"frameElNames":{},"frameIdRegex":{},"frameInfoCache":{"!doc":"<p>Cache the frame information object so as not to cause style recalculations</p>\n"},"frameTableTpl":{},"frameTpl":{},"afterFirstLayout":{"!type":"fn(width: ?, height: ?) -> !this"},"afterRender":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior after rendering is complete. At this stage the Component’s Element\nwill have been styled according to the configuration, will have had any configured CSS class\nnames added, and will be in the configured visibility and the configured enable state.</p>\n"},"applyRenderSelectors":{"!type":"fn() -> !this","!doc":"<p>Sets references to elements inside the component. This applies <a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a>\nas well as <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a>.</p>\n"},"beforeRender":{"!type":"fn() -> !this"},"doApplyRenderTpl":{"!type":"fn(out: ?, values: ?) -> !this","!doc":"<p>Called from the selected frame generation template to insert this Component's inner structure inside the framing structure.</p>\n\n<p>When framing is used, a selected frame generation template is used as the primary template of the <a href=\"#!/api/Ext.util.Renderable-method-getElConfig\" rel=\"Ext.util.Renderable-method-getElConfig\" class=\"docClass\">getElConfig</a> instead\nof the configured <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a>. The renderTpl is invoked by this method which is injected into the framing template.</p>\n"},"doAutoRender":{"!type":"fn() -> !this","!doc":"<p>Handles autoRender.\nFloating Components may have an ownerCt. If they are asking to be constrained, constrain them within that\nownerCt, and have their z-index managed locally. Floating Components are always rendered to document.body</p>\n"},"doRenderContent":{"!type":"fn(out: ?, renderData: ?) -> !this"},"doRenderFramingDockedItems":{"!type":"fn(out: ?, renderData: ?, after: ?) -> !this"},"ensureAttachedToBody":{"!type":"fn(runLayout?: ?) -> !this","!doc":"<p>Ensures that this component is attached to <code>document.body</code>. If the component was\nrendered to <a href=\"#!/api/Ext-method-getDetachedBody\" rel=\"Ext-method-getDetachedBody\" class=\"docClass\">Ext.getDetachedBody</a>, then it will be appended to <code>document.body</code>.\nAny configured position is also restored.</p>\n"},"finishRender":{"!type":"fn(containerIdx: ?) -> !this","!doc":"<p>This method visits the rendered component tree in a \"top-down\" order. That is, this\ncode runs on a parent component before running on a child. This method calls the\n<a href=\"#!/api/Ext.util.Renderable-method-onRender\" rel=\"Ext.util.Renderable-method-onRender\" class=\"docClass\">onRender</a> method of each component.</p>\n"},"finishRenderChildren":{"!type":"fn() -> !this"},"getElConfig":{"!type":"fn() -> !this"},"getFrameInfo":{"!type":"fn() -> !this","!doc":"<p>On render, reads an encoded style attribute, \"filter\" from the style of this Component's element.\nThis information is memoized based upon the CSS class name of this Component's element.\nBecause child Components are rendered as textual HTML as part of the topmost Container, a dummy div is inserted\ninto the document to receive the document element's CSS class name, and therefore style attributes.</p>\n"},"getFrameRenderData":{"!type":"fn() -> !this"},"getFrameTpl":{"!type":"fn(table: ?) -> !this"},"getFramingInfoCls":{"!type":"fn() -> !this"},"getInsertPosition":{"!type":"fn(position: ?) -> ?","!doc":"<p>This function takes the position argument passed to onRender and returns a\nDOM element that you can use in the insertBefore.</p>\n"},"getRenderTree":{"!type":"fn() -> !this"},"getStyleProxy":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Returns an offscreen div with the same class name as the element this is being rendered.\nThis is because child item rendering takes place in a detached div which, being not\npart of the document, has no styling.</p>\n"},"initContainer":{"!type":"fn(container: ?) -> !this"},"initFrame":{"!type":"fn() -> !this"},"initFramingTpl":{"!type":"fn(table: ?) -> !this","!doc":"<p>Create the framingTpl from the string.\nPoke in a reference to applyRenderTpl(frameInfo, out)</p>\n"},"initRenderData":{"!type":"fn() -> ?","!doc":"<p>Initialized the renderData to be used when rendering the renderTpl.</p>\n"},"initRenderTpl":{"!type":"fn() -> ?","!doc":"<p>Initializes the renderTpl.</p>\n"},"onRender":{"!type":"fn(parentNode: ?, containerIdx: ?) -> !this","!doc":"<p>Template method called when this Component's DOM structure is created.</p>\n\n<p>At this point, this Component's (and all descendants') DOM structure <em>exists</em> but it has not\nbeen layed out (positioned and sized).</p>\n\n<p>Subclasses which override this to gain access to the structure at render time should\ncall the parent class's method before attempting to access any child elements of the Component.</p>\n"},"render":{"!type":"fn(container?: ?, position?: ?) -> !this","!doc":"<p>Renders the Component into the passed HTML element.</p>\n\n<p><strong>If you are using a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> object to house this\nComponent, then do not use the render method.</strong></p>\n\n<p>A Container's child Components are rendered by that Container's\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a> manager when the Container is first rendered.</p>\n\n<p>If the Container is already rendered when a new child Component is added, you may need to call\nthe Container's <a href=\"#!/api/Ext.container.Container-method-doLayout\" rel=\"Ext.container.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which\ncauses any unrendered child Components to be rendered. This is required so that you can add\nmultiple child components if needed while only refreshing the layout once.</p>\n\n<p>When creating complex UIs, it is important to remember that sizing and positioning\nof child items is the responsibility of the Container's <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>\nmanager.  If you expect child items to be sized in response to user interactions, you must\nconfigure the Container with a layout manager which creates and manages the type of layout you\nhave in mind.</p>\n\n<p><strong>Omitting the Container's <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a> config means that a basic\nlayout manager is used which does nothing but render child components sequentially into the\nContainer. No sizing or positioning will be performed in this situation.</strong></p>\n"},"setupFramingTpl":{"!type":"fn(frameTpl: ?) -> !this","!doc":"<p>Inject a reference to the function which applies the render template into the framing template. The framing template\nwraps the content.</p>\n"},"setupRenderTpl":{"!type":"fn(renderTpl: ?) -> !this"},"updateFrame":{"!type":"fn() -> !this"},"wrapPrimaryEl":{"!type":"fn(dom: ?) -> !this"}},"frameCls":{"!type":"string"},"frameElNames":{},"frameIdRegex":{},"frameInfoCache":{"!doc":"<p>Cache the frame information object so as not to cause style recalculations</p>\n"},"frameTableTpl":{},"frameTpl":{},"afterFirstLayout":{"!type":"fn(width: ?, height: ?) -> !this"},"applyRenderSelectors":{"!type":"fn() -> !this","!doc":"<p>Sets references to elements inside the component. This applies <a href=\"#!/api/Ext.AbstractComponent-cfg-renderSelectors\" rel=\"Ext.AbstractComponent-cfg-renderSelectors\" class=\"docClass\">renderSelectors</a>\nas well as <a href=\"#!/api/Ext.AbstractComponent-cfg-childEls\" rel=\"Ext.AbstractComponent-cfg-childEls\" class=\"docClass\">childEls</a>.</p>\n"},"doApplyRenderTpl":{"!type":"fn(out: ?, values: ?) -> !this","!doc":"<p>Called from the selected frame generation template to insert this Component's inner structure inside the framing structure.</p>\n\n<p>When framing is used, a selected frame generation template is used as the primary template of the <a href=\"#!/api/Ext.util.Renderable-method-getElConfig\" rel=\"Ext.util.Renderable-method-getElConfig\" class=\"docClass\">getElConfig</a> instead\nof the configured <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTpl\" rel=\"Ext.AbstractComponent-cfg-renderTpl\" class=\"docClass\">renderTpl</a>. The renderTpl is invoked by this method which is injected into the framing template.</p>\n"},"doAutoRender":{"!type":"fn() -> !this","!doc":"<p>Handles autoRender.\nFloating Components may have an ownerCt. If they are asking to be constrained, constrain them within that\nownerCt, and have their z-index managed locally. Floating Components are always rendered to document.body</p>\n"},"doRenderContent":{"!type":"fn(out: ?, renderData: ?) -> !this"},"doRenderFramingDockedItems":{"!type":"fn(out: ?, renderData: ?, after: ?) -> !this"},"ensureAttachedToBody":{"!type":"fn(runLayout?: ?) -> !this","!doc":"<p>Ensures that this component is attached to <code>document.body</code>. If the component was\nrendered to <a href=\"#!/api/Ext-method-getDetachedBody\" rel=\"Ext-method-getDetachedBody\" class=\"docClass\">Ext.getDetachedBody</a>, then it will be appended to <code>document.body</code>.\nAny configured position is also restored.</p>\n"},"finishRender":{"!type":"fn(containerIdx: ?) -> !this","!doc":"<p>This method visits the rendered component tree in a \"top-down\" order. That is, this\ncode runs on a parent component before running on a child. This method calls the\n<a href=\"#!/api/Ext.util.Renderable-method-onRender\" rel=\"Ext.util.Renderable-method-onRender\" class=\"docClass\">onRender</a> method of each component.</p>\n"},"getFrameInfo":{"!type":"fn() -> !this","!doc":"<p>On render, reads an encoded style attribute, \"filter\" from the style of this Component's element.\nThis information is memoized based upon the CSS class name of this Component's element.\nBecause child Components are rendered as textual HTML as part of the topmost Container, a dummy div is inserted\ninto the document to receive the document element's CSS class name, and therefore style attributes.</p>\n"},"getFrameRenderData":{"!type":"fn() -> !this"},"getFrameTpl":{"!type":"fn(table: ?) -> !this"},"getFramingInfoCls":{"!type":"fn() -> !this"},"getInsertPosition":{"!type":"fn(position: ?) -> ?","!doc":"<p>This function takes the position argument passed to onRender and returns a\nDOM element that you can use in the insertBefore.</p>\n"},"getRenderTree":{"!type":"fn() -> !this"},"getStyleProxy":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Returns an offscreen div with the same class name as the element this is being rendered.\nThis is because child item rendering takes place in a detached div which, being not\npart of the document, has no styling.</p>\n"},"initContainer":{"!type":"fn(container: ?) -> !this"},"initFrame":{"!type":"fn() -> !this"},"initFramingTpl":{"!type":"fn(table: ?) -> !this","!doc":"<p>Create the framingTpl from the string.\nPoke in a reference to applyRenderTpl(frameInfo, out)</p>\n"},"initRenderTpl":{"!type":"fn() -> ?","!doc":"<p>Initializes the renderTpl.</p>\n"},"render":{"!type":"fn(container?: ?, position?: ?) -> !this","!doc":"<p>Renders the Component into the passed HTML element.</p>\n\n<p><strong>If you are using a <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a> object to house this\nComponent, then do not use the render method.</strong></p>\n\n<p>A Container's child Components are rendered by that Container's\n<a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a> manager when the Container is first rendered.</p>\n\n<p>If the Container is already rendered when a new child Component is added, you may need to call\nthe Container's <a href=\"#!/api/Ext.container.Container-method-doLayout\" rel=\"Ext.container.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which\ncauses any unrendered child Components to be rendered. This is required so that you can add\nmultiple child components if needed while only refreshing the layout once.</p>\n\n<p>When creating complex UIs, it is important to remember that sizing and positioning\nof child items is the responsibility of the Container's <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a>\nmanager.  If you expect child items to be sized in response to user interactions, you must\nconfigure the Container with a layout manager which creates and manages the type of layout you\nhave in mind.</p>\n\n<p><strong>Omitting the Container's <a href=\"#!/api/Ext.container.Container-cfg-layout\" rel=\"Ext.container.Container-cfg-layout\" class=\"docClass\">layout</a> config means that a basic\nlayout manager is used which does nothing but render child components sequentially into the\nContainer. No sizing or positioning will be performed in this situation.</strong></p>\n"},"setupFramingTpl":{"!type":"fn(frameTpl: ?) -> !this","!doc":"<p>Inject a reference to the function which applies the render template into the framing template. The framing template\nwraps the content.</p>\n"},"updateFrame":{"!type":"fn() -> !this"},"!doc":"<p>Given a component hierarchy of this:</p>\n\n<pre><code> {\n     xtype: 'panel',\n     id: 'ContainerA',\n     layout: 'hbox',\n     renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n     items: [\n         {\n             id: 'ContainerB',\n             xtype: 'container',\n             items: [\n                 { id: 'ComponentA' }\n             ]\n         }\n     ]\n }\n</code></pre>\n\n<p>The rendering of the above proceeds roughly like this:</p>\n\n<ul>\n<li>ContainerA's initComponent calls <a href=\"#!/api/Ext.util.Renderable-method-render\" rel=\"Ext.util.Renderable-method-render\" class=\"docClass\">render</a> passing the <code>renderTo</code> property as the\ncontainer argument.</li>\n<li><code>render</code> calls the <code>getRenderTree</code> method to get a complete <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">Ext.DomHelper</a> spec.</li>\n<li><code>getRenderTree</code> fires the \"beforerender\" event and calls the <a href=\"#!/api/Ext.util.Renderable-method-beforeRender\" rel=\"Ext.util.Renderable-method-beforeRender\" class=\"docClass\">beforeRender</a>\nmethod. Its result is obtained by calling <a href=\"#!/api/Ext.util.Renderable-method-getElConfig\" rel=\"Ext.util.Renderable-method-getElConfig\" class=\"docClass\">getElConfig</a>.</li>\n<li>The <a href=\"#!/api/Ext.util.Renderable-method-getElConfig\" rel=\"Ext.util.Renderable-method-getElConfig\" class=\"docClass\">getElConfig</a> method uses the <code>renderTpl</code> and its render data as the content\nof the <code>autoEl</code> described element.</li>\n<li>The result of <code>getRenderTree</code> is passed to <a href=\"#!/api/Ext.DomHelper-method-append\" rel=\"Ext.DomHelper-method-append\" class=\"docClass\">Ext.DomHelper.append</a>.</li>\n<li>The <code>renderTpl</code> contains calls to render things like docked items, container items\nand raw markup (such as the <code>html</code> or <code>tpl</code> config properties). These calls are to\nmethods added to the <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a> instance by <a href=\"#!/api/Ext.util.Renderable-method-setupRenderTpl\" rel=\"Ext.util.Renderable-method-setupRenderTpl\" class=\"docClass\">setupRenderTpl</a>.</li>\n<li>The <a href=\"#!/api/Ext.util.Renderable-method-setupRenderTpl\" rel=\"Ext.util.Renderable-method-setupRenderTpl\" class=\"docClass\">setupRenderTpl</a> method adds methods such as <code>renderItems</code>, <code>renderContent</code>, etc.\nto the template. These are directed to \"doRenderItems\", \"doRenderContent\" etc..</li>\n<li>The <a href=\"#!/api/Ext.util.Renderable-method-setupRenderTpl\" rel=\"Ext.util.Renderable-method-setupRenderTpl\" class=\"docClass\">setupRenderTpl</a> calls traverse from components to their <a href=\"#!/api/Ext.layout.Layout\" rel=\"Ext.layout.Layout\" class=\"docClass\">Ext.layout.Layout</a>\nobject.</li>\n<li>When a container is rendered, it also has a <code>renderTpl</code>. This is processed when the\n<code>renderContainer</code> method is called in the component's <code>renderTpl</code>. This call goes to\n<a href=\"#!/api/Ext.layout.container.Container-method-doRenderContainer\" rel=\"Ext.layout.container.Container-method-doRenderContainer\" class=\"docClass\">Ext.layout.container.Container.doRenderContainer</a>. This method repeats this\nprocess for all components in the container.</li>\n<li>After the top-most component's markup is generated and placed in to the DOM, the next\nstep is to link elements to their components and finish calling the component methods\n<code>onRender</code> and <code>afterRender</code> as well as fire the corresponding events.</li>\n<li>The first step in this is to call <a href=\"#!/api/Ext.util.Renderable-method-finishRender\" rel=\"Ext.util.Renderable-method-finishRender\" class=\"docClass\">finishRender</a>. This method descends the\ncomponent hierarchy and calls <code>onRender</code> and fires the <code>render</code> event. These calls\nare delivered top-down to approximate the timing of these calls/events from previous\nversions.</li>\n<li>During the pass, the component's <code>el</code> is set. Likewise, the <code>renderSelectors</code> and\n<code>childEls</code> are applied to capture references to the component's elements.</li>\n<li>These calls are also made on the <a href=\"#!/api/Ext.layout.container.Container\" rel=\"Ext.layout.container.Container\" class=\"docClass\">Ext.layout.container.Container</a> layout to\ncapture its elements. Both of these classes use <a href=\"#!/api/Ext.util.ElementContainer\" rel=\"Ext.util.ElementContainer\" class=\"docClass\">Ext.util.ElementContainer</a> to\nhandle <code>childEls</code> processing.</li>\n<li>Once this is complete, a similar pass is made by calling #finishAfterRender.\nThis call also descends the component hierarchy, but this time the calls are made in\na bottom-up order to <code>afterRender</code>.</li>\n</ul>\n\n"},"Animate":{"prototype":{"isAnimate":{"!type":"bool"},"anim":{"!type":"fn(config: ?) -> !this","!doc":"<ul>\n<li>process the passed fx configuration.</li>\n</ul>\n\n"},"getActiveAnimation":{"!type":"fn() -> ?","!doc":"<p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n"},"hasActiveFx":{"!type":"fn() -> ?","!doc":"<p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n"},"sequenceFx":{"!type":"fn() -> ?","!doc":"<p>Ensures that all effects queued after sequenceFx is called on this object are run in sequence. This is the\nopposite of <a href=\"#!/api/Ext.util.Animate-method-syncFx\" rel=\"Ext.util.Animate-method-syncFx\" class=\"docClass\">syncFx</a>.</p>\n"},"stopAnimation":{"!type":"fn() -> ?","!doc":"<p>Stops any running effects and clears this object's internal effects queue if it contains any additional effects\nthat haven't started yet.</p>\n"},"stopFx":{"!type":"fn() -> ?","!doc":"<p>Stops any running effects and clears this object's internal effects queue if it contains any additional effects\nthat haven't started yet.</p>\n"},"syncFx":{"!type":"fn() -> ?","!doc":"<p>Ensures that all effects queued after syncFx is called on this object are run concurrently. This is the opposite\nof <a href=\"#!/api/Ext.util.Animate-method-sequenceFx\" rel=\"Ext.util.Animate-method-sequenceFx\" class=\"docClass\">sequenceFx</a>.</p>\n"},"animate":{"!type":"fn(config: ?) -> ?","!doc":"<p>Performs custom animation on this object.</p>\n\n<p>This method is applicable to both the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> class and the <a href=\"#!/api/Ext.draw.Sprite\" rel=\"Ext.draw.Sprite\" class=\"docClass\">Sprite</a>\nclass. It performs animated transitions of certain properties of this object over a specified timeline.</p>\n\n<h3>Animating a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a></h3>\n\n<p>When animating a Component, the following properties may be specified in <code>from</code>, <code>to</code>, and <code>keyframe</code> objects:</p>\n\n<ul>\n<li><p><code>x</code> - The Component's page X position in pixels.</p></li>\n<li><p><code>y</code> - The Component's page Y position in pixels</p></li>\n<li><p><code>left</code> - The Component's <code>left</code> value in pixels.</p></li>\n<li><p><code>top</code> - The Component's <code>top</code> value in pixels.</p></li>\n<li><p><code>width</code> - The Component's <code>width</code> value in pixels.</p></li>\n<li><p><code>height</code> - The Component's <code>height</code> value in pixels.</p></li>\n<li><p><code>dynamic</code> - Specify as true to update the Component's layout (if it is a Container) at every frame of the animation.\n<em>Use sparingly as laying out on every intermediate size change is an expensive operation.</em></p></li>\n</ul>\n\n\n<p>For example, to animate a Window to a new size, ensuring that its internal layout and any shadow is correct:</p>\n\n<pre><code>myWindow = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>', {\n    title: 'Test Component animation',\n    width: 500,\n    height: 300,\n    layout: {\n        type: 'hbox',\n        align: 'stretch'\n    },\n    items: [{\n        title: 'Left: 33%',\n        margins: '5 0 5 5',\n        flex: 1\n    }, {\n        title: 'Left: 66%',\n        margins: '5 5 5 5',\n        flex: 2\n    }]\n});\nmyWindow.show();\nmyWindow.header.el.on('click', function() {\n    myWindow.animate({\n        to: {\n            width: (myWindow.getWidth() == 500) ? 700 : 500,\n            height: (myWindow.getHeight() == 300) ? 400 : 300\n        }\n    });\n});\n</code></pre>\n\n<p>For performance reasons, by default, the internal layout is only updated when the Window reaches its final <code>\"to\"</code>\nsize. If dynamic updating of the Window's child Components is required, then configure the animation with\n<code>dynamic: true</code> and the two child items will maintain their proportions during the animation.</p>\n"}},"isAnimate":{"!type":"bool"},"anim":{"!type":"fn(config: ?) -> !this","!doc":"<ul>\n<li>process the passed fx configuration.</li>\n</ul>\n\n"},"getActiveAnimation":{"!type":"fn() -> ?","!doc":"<p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n"},"hasActiveFx":{"!type":"fn() -> ?","!doc":"<p>Returns the current animation if this object has any effects actively running or queued, else returns false.</p>\n"},"sequenceFx":{"!type":"fn() -> ?","!doc":"<p>Ensures that all effects queued after sequenceFx is called on this object are run in sequence. This is the\nopposite of <a href=\"#!/api/Ext.util.Animate-method-syncFx\" rel=\"Ext.util.Animate-method-syncFx\" class=\"docClass\">syncFx</a>.</p>\n"},"stopAnimation":{"!type":"fn() -> ?","!doc":"<p>Stops any running effects and clears this object's internal effects queue if it contains any additional effects\nthat haven't started yet.</p>\n"},"stopFx":{"!type":"fn() -> ?","!doc":"<p>Stops any running effects and clears this object's internal effects queue if it contains any additional effects\nthat haven't started yet.</p>\n"},"syncFx":{"!type":"fn() -> ?","!doc":"<p>Ensures that all effects queued after syncFx is called on this object are run concurrently. This is the opposite\nof <a href=\"#!/api/Ext.util.Animate-method-sequenceFx\" rel=\"Ext.util.Animate-method-sequenceFx\" class=\"docClass\">sequenceFx</a>.</p>\n"},"!doc":"<p>This animation class is a mixin.</p>\n\n<p><a href=\"#!/api/Ext.util.Animate\" rel=\"Ext.util.Animate\" class=\"docClass\">Ext.util.Animate</a> provides an API for the creation of animated transitions of properties and styles.\nThis class is used as a mixin and currently applied to <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Ext.Element</a>, <a href=\"#!/api/Ext.dom.CompositeElement\" rel=\"Ext.dom.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a>,\n<a href=\"#!/api/Ext.draw.Sprite\" rel=\"Ext.draw.Sprite\" class=\"docClass\">Ext.draw.Sprite</a>, <a href=\"#!/api/Ext.draw.CompositeSprite\" rel=\"Ext.draw.CompositeSprite\" class=\"docClass\">Ext.draw.CompositeSprite</a>, and <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.  Note that Components\nhave a limited subset of what attributes can be animated such as top, left, x, y, height, width, and\nopacity (color, paddings, and margins can not be animated).</p>\n\n<h2>Animation Basics</h2>\n\n<p>All animations require three things - <code>easing</code>, <code>duration</code>, and <code>to</code> (the final end value for each property)\nyou wish to animate. Easing and duration are defaulted values specified below.\nEasing describes how the intermediate values used during a transition will be calculated.\n<a href=\"#!/api/Ext.fx.Anim-cfg-easing\" rel=\"Ext.fx.Anim-cfg-easing\" class=\"docClass\">Easing</a> allows for a transition to change speed over its duration.\nYou may use the defaults for easing and duration, but you must always set a\n<a href=\"#!/api/Ext.fx.Anim-cfg-to\" rel=\"Ext.fx.Anim-cfg-to\" class=\"docClass\">to</a> property which is the end value for all animations.</p>\n\n<p>Popular element 'to' configurations are:</p>\n\n<ul>\n<li>opacity</li>\n<li>x</li>\n<li>y</li>\n<li>color</li>\n<li>height</li>\n<li>width</li>\n</ul>\n\n\n<p>Popular sprite 'to' configurations are:</p>\n\n<ul>\n<li>translation</li>\n<li>path</li>\n<li>scale</li>\n<li>stroke</li>\n<li>rotation</li>\n</ul>\n\n\n<p>The default duration for animations is 250 (which is a 1/4 of a second).  Duration is denoted in\nmilliseconds.  Therefore 1 second is 1000, 1 minute would be 60000, and so on. The default easing curve\nused for all animations is 'ease'.  Popular easing functions are included and can be found in <a href=\"#!/api/Ext.fx.Anim-cfg-easing\" rel=\"Ext.fx.Anim-cfg-easing\" class=\"docClass\">Easing</a>.</p>\n\n<p>For example, a simple animation to fade out an element with a default easing and duration:</p>\n\n<pre><code>var p1 = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>('myElementId');\n\np1.animate({\n    to: {\n        opacity: 0\n    }\n});\n</code></pre>\n\n<p>To make this animation fade out in a tenth of a second:</p>\n\n<pre><code>var p1 = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>('myElementId');\n\np1.animate({\n   duration: 100,\n    to: {\n        opacity: 0\n    }\n});\n</code></pre>\n\n<h2>Animation Queues</h2>\n\n<p>By default all animations are added to a queue which allows for animation via a chain-style API.\nFor example, the following code will queue 4 animations which occur sequentially (one right after the other):</p>\n\n<pre><code>p1.animate({\n    to: {\n        x: 500\n    }\n}).animate({\n    to: {\n        y: 150\n    }\n}).animate({\n    to: {\n        backgroundColor: '#f00'  //red\n    }\n}).animate({\n    to: {\n        opacity: 0\n    }\n});\n</code></pre>\n\n<p>You can change this behavior by calling the <a href=\"#!/api/Ext.util.Animate-method-syncFx\" rel=\"Ext.util.Animate-method-syncFx\" class=\"docClass\">syncFx</a> method and all\nsubsequent animations for the specified target will be run concurrently (at the same time).</p>\n\n<pre><code>p1.syncFx();  //this will make all animations run at the same time\n\np1.animate({\n    to: {\n        x: 500\n    }\n}).animate({\n    to: {\n        y: 150\n    }\n}).animate({\n    to: {\n        backgroundColor: '#f00'  //red\n    }\n}).animate({\n    to: {\n        opacity: 0\n    }\n});\n</code></pre>\n\n<p>This works the same as:</p>\n\n<pre><code>p1.animate({\n    to: {\n        x: 500,\n        y: 150,\n        backgroundColor: '#f00'  //red\n        opacity: 0\n    }\n});\n</code></pre>\n\n<p>The <a href=\"#!/api/Ext.util.Animate-method-stopAnimation\" rel=\"Ext.util.Animate-method-stopAnimation\" class=\"docClass\">stopAnimation</a> method can be used to stop any\ncurrently running animations and clear any queued animations.</p>\n\n<h2>Animation Keyframes</h2>\n\n<p>You can also set up complex animations with <a href=\"#!/api/Ext.fx.Anim-cfg-keyframes\" rel=\"Ext.fx.Anim-cfg-keyframes\" class=\"docClass\">keyframes</a> which follow the\nCSS3 Animation configuration pattern. Note rotation, translation, and scaling can only be done for sprites.\nThe previous example can be written with the following syntax:</p>\n\n<pre><code>p1.animate({\n    duration: 1000,  //one second total\n    keyframes: {\n        25: {     //from 0 to 250ms (25%)\n            x: 0\n        },\n        50: {   //from 250ms to 500ms (50%)\n            y: 0\n        },\n        75: {  //from 500ms to 750ms (75%)\n            backgroundColor: '#f00'  //red\n        },\n        100: {  //from 750ms to 1sec\n            opacity: 0\n        }\n    }\n});\n</code></pre>\n\n<h2>Animation Events</h2>\n\n<p>Each animation you create has events for <a href=\"#!/api/Ext.fx.Anim-event-beforeanimate\" rel=\"Ext.fx.Anim-event-beforeanimate\" class=\"docClass\">beforeanimate</a>,\n<a href=\"#!/api/Ext.fx.Anim-event-afteranimate\" rel=\"Ext.fx.Anim-event-afteranimate\" class=\"docClass\">afteranimate</a>, and <a href=\"#!/api/Ext.fx.Anim-event-lastframe\" rel=\"Ext.fx.Anim-event-lastframe\" class=\"docClass\">lastframe</a>.\nKeyframed animations adds an additional <a href=\"#!/api/Ext.fx.Animator-event-keyframe\" rel=\"Ext.fx.Animator-event-keyframe\" class=\"docClass\">keyframe</a> event which\nfires for each keyframe in your animation.</p>\n\n<p>All animations support the <a href=\"#!/api/Ext.util.Observable-cfg-listeners\" rel=\"Ext.util.Observable-cfg-listeners\" class=\"docClass\">listeners</a> configuration to attact functions to these events.</p>\n\n<pre><code>startAnimate: function() {\n    var p1 = <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>('myElementId');\n    p1.animate({\n       duration: 100,\n        to: {\n            opacity: 0\n        },\n        listeners: {\n            beforeanimate:  function() {\n                // Execute my custom method before the animation\n                this.myBeforeAnimateFn();\n            },\n            afteranimate: function() {\n                // Execute my custom method after the animation\n                this.myAfterAnimateFn();\n            },\n            scope: this\n    });\n},\nmyBeforeAnimateFn: function() {\n  // My custom logic\n},\nmyAfterAnimateFn: function() {\n  // My custom logic\n}\n</code></pre>\n\n<p>Due to the fact that animations run asynchronously, you can determine if an animation is currently\nrunning on any target by using the <a href=\"#!/api/Ext.util.Animate-method-getActiveAnimation\" rel=\"Ext.util.Animate-method-getActiveAnimation\" class=\"docClass\">getActiveAnimation</a>\nmethod.  This method will return false if there are no active animations or return the currently\nrunning <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a> instance.</p>\n\n<p>In this example, we're going to wait for the current animation to finish, then stop any other\nqueued animations before we fade our element's opacity to 0:</p>\n\n<pre><code>var curAnim = p1.getActiveAnimation();\nif (curAnim) {\n    curAnim.on('afteranimate', function() {\n        p1.stopAnimation();\n        p1.animate({\n            to: {\n                opacity: 0\n            }\n        });\n    });\n}\n</code></pre>\n"},"Floating":{"prototype":{"constrain":{"!type":"bool","!doc":"<p>True to constrain this Components within its containing element, false to allow it to fall outside of its containing\nelement. By default this Component will be rendered to <code>document.body</code>. To render and constrain this Component within\nanother element specify <a href=\"#!/api/Ext.AbstractComponent-cfg-renderTo\" rel=\"Ext.AbstractComponent-cfg-renderTo\" class=\"docClass\">renderTo</a>.</p>\n"},"fixed":{"!type":"bool","!doc":"<p>Configure as <code>true</code> to have this Component fixed at its <code>X, Y</code> coordinates in the browser viewport, immune\nto scrolling the document.</p>\n\n<p><em>Only in browsers that support <code>position:fixed</code></em></p>\n\n<p><em>IE6 and IE7, 8 and 9 quirks do not support <code>position: fixed</code></em></p>\n"},"focusOnToFront":{"!type":"bool","!doc":"<p>Specifies whether the floated component should be automatically <a href=\"#!/api/Ext.Component-method-focus\" rel=\"Ext.Component-method-focus\" class=\"docClass\">focused</a> when\nit is <a href=\"#!/api/Ext.util.Floating-method-toFront\" rel=\"Ext.util.Floating-method-toFront\" class=\"docClass\">brought to the front</a>.</p>\n"},"shadow":{"!doc":"<p>Specifies whether the floating component should be given a shadow. Set to true to automatically create an\n<a href=\"#!/api/Ext.Shadow\" rel=\"Ext.Shadow\" class=\"docClass\">Ext.Shadow</a>, or a string indicating the shadow's display <a href=\"#!/api/Ext.Shadow-cfg-mode\" rel=\"Ext.Shadow-cfg-mode\" class=\"docClass\">Ext.Shadow.mode</a>. Set to false to\ndisable the shadow.</p>\n"},"shadowOffset":{"!type":"number","!doc":"<p>Number of pixels to offset the shadow.</p>\n"},"center":{"!type":"fn() -> ?","!doc":"<p>Center this Component in its container.</p>\n"},"doConstrain":{"!type":"fn(constrainTo?: ?) -> !this","!doc":"<p>Moves this floating Component into a constrain region.</p>\n\n<p>By default, this Component is constrained to be within the container it was added to, or the element it was\nrendered to.</p>\n\n<p>An alternative constraint may be passed.</p>\n"},"fitContainer":{"!type":"fn(animate: ?) -> !this"},"initHierarchyEvents":{"!type":"fn() -> !this"},"onAfterFloatLayout":{"!type":"fn() -> !this"},"onBeforeFloatLayout":{"!type":"fn() -> !this"},"onFloatShow":{"!type":"fn() -> !this"},"onKeyDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Listen for TAB events and wrap round if tabbing of either end of the Floater</p>\n"},"registerWithOwnerCt":{"!type":"fn() -> !this"},"setActive":{"!type":"fn(active?: ?, newActive?: ?) -> !this","!doc":"<p>This method is called internally by <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">Ext.ZIndexManager</a> to signal that a floating Component has either been\nmoved to the top of its zIndex stack, or pushed from the top of its zIndex stack.</p>\n\n<p>If a <em>Window</em> is superceded by another Window, deactivating it hides its shadow.</p>\n\n<p>This method also fires the <a href=\"#!/api/Ext.Component-event-activate\" rel=\"Ext.Component-event-activate\" class=\"docClass\">activate</a> or\n<a href=\"#!/api/Ext.Component-event-deactivate\" rel=\"Ext.Component-event-deactivate\" class=\"docClass\">deactivate</a> event depending on which action occurred.</p>\n"},"setFloatParent":{"!type":"fn(floatParent: ?) -> !this"},"setZIndex":{"!type":"fn(index: ?) -> !this","!doc":"<p>z-index is managed by the zIndexManager and may be overwritten at any time.\nReturns the next z-index to be used.\nIf this is a Container, then it will have rebased any managed floating Components,\nand so the next available z-index will be approximately 10000 above that.</p>\n"},"syncHidden":{"!type":"fn() -> !this","!doc":"<p>synchronizes the hidden state of this component with the state of its hierarchy</p>\n"},"syncShadow":{"!type":"fn() -> !this"},"toBack":{"!type":"fn() -> ?","!doc":"<p>Sends this Component to the back of (lower z-index than) any other visible windows</p>\n"},"toFront":{"!type":"fn(preventFocus?: ?) -> ?","!doc":"<p>Brings this floating Component to the front of any other visible, floating Components managed by the same\n<a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<p>If this Component is modal, inserts the modal mask just below this Component in the z-index stack.</p>\n"},"onMouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Mousedown brings to front, and programatically grabs focus <em>unless the mousedown was on a focusable element</em></p>\n"}},"fixed":{"!type":"bool","!doc":"<p>Configure as <code>true</code> to have this Component fixed at its <code>X, Y</code> coordinates in the browser viewport, immune\nto scrolling the document.</p>\n\n<p><em>Only in browsers that support <code>position:fixed</code></em></p>\n\n<p><em>IE6 and IE7, 8 and 9 quirks do not support <code>position: fixed</code></em></p>\n"},"focusOnToFront":{"!type":"bool","!doc":"<p>Specifies whether the floated component should be automatically <a href=\"#!/api/Ext.Component-method-focus\" rel=\"Ext.Component-method-focus\" class=\"docClass\">focused</a> when\nit is <a href=\"#!/api/Ext.util.Floating-method-toFront\" rel=\"Ext.util.Floating-method-toFront\" class=\"docClass\">brought to the front</a>.</p>\n"},"shadow":{"!doc":"<p>Specifies whether the floating component should be given a shadow. Set to true to automatically create an\n<a href=\"#!/api/Ext.Shadow\" rel=\"Ext.Shadow\" class=\"docClass\">Ext.Shadow</a>, or a string indicating the shadow's display <a href=\"#!/api/Ext.Shadow-cfg-mode\" rel=\"Ext.Shadow-cfg-mode\" class=\"docClass\">Ext.Shadow.mode</a>. Set to false to\ndisable the shadow.</p>\n"},"shadowOffset":{"!type":"number","!doc":"<p>Number of pixels to offset the shadow.</p>\n"},"center":{"!type":"fn() -> ?","!doc":"<p>Center this Component in its container.</p>\n"},"doConstrain":{"!type":"fn(constrainTo?: ?) -> !this","!doc":"<p>Moves this floating Component into a constrain region.</p>\n\n<p>By default, this Component is constrained to be within the container it was added to, or the element it was\nrendered to.</p>\n\n<p>An alternative constraint may be passed.</p>\n"},"fitContainer":{"!type":"fn(animate: ?) -> !this"},"initHierarchyEvents":{"!type":"fn() -> !this"},"onAfterFloatLayout":{"!type":"fn() -> !this"},"onBeforeFloatLayout":{"!type":"fn() -> !this"},"onFloatShow":{"!type":"fn() -> !this"},"onKeyDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Listen for TAB events and wrap round if tabbing of either end of the Floater</p>\n"},"onMouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Mousedown brings to front, and programatically grabs focus <em>unless the mousedown was on a focusable element</em></p>\n"},"registerWithOwnerCt":{"!type":"fn() -> !this"},"setActive":{"!type":"fn(active?: ?, newActive?: ?) -> !this","!doc":"<p>This method is called internally by <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">Ext.ZIndexManager</a> to signal that a floating Component has either been\nmoved to the top of its zIndex stack, or pushed from the top of its zIndex stack.</p>\n\n<p>If a <em>Window</em> is superceded by another Window, deactivating it hides its shadow.</p>\n\n<p>This method also fires the <a href=\"#!/api/Ext.Component-event-activate\" rel=\"Ext.Component-event-activate\" class=\"docClass\">activate</a> or\n<a href=\"#!/api/Ext.Component-event-deactivate\" rel=\"Ext.Component-event-deactivate\" class=\"docClass\">deactivate</a> event depending on which action occurred.</p>\n"},"setFloatParent":{"!type":"fn(floatParent: ?) -> !this"},"setZIndex":{"!type":"fn(index: ?) -> !this","!doc":"<p>z-index is managed by the zIndexManager and may be overwritten at any time.\nReturns the next z-index to be used.\nIf this is a Container, then it will have rebased any managed floating Components,\nand so the next available z-index will be approximately 10000 above that.</p>\n"},"syncHidden":{"!type":"fn() -> !this","!doc":"<p>synchronizes the hidden state of this component with the state of its hierarchy</p>\n"},"syncShadow":{"!type":"fn() -> !this"},"toBack":{"!type":"fn() -> ?","!doc":"<p>Sends this Component to the back of (lower z-index than) any other visible windows</p>\n"},"toFront":{"!type":"fn(preventFocus?: ?) -> ?","!doc":"<p>Brings this floating Component to the front of any other visible, floating Components managed by the same\n<a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<p>If this Component is modal, inserts the modal mask just below this Component in the z-index stack.</p>\n"},"!doc":"<p>A mixin to add floating capability to a Component.</p>\n"},"Bindable":{"prototype":{"bindStoreListeners":{"!type":"fn(store: ?) -> !this","!doc":"<p>Binds listeners for this component to the store. By default it will add\nanything bound by the getStoreListeners method, however it can be overridden\nin a subclass to provide any more complicated handling.</p>\n"},"getStore":{"!type":"fn() -> ?","!doc":"<p>Gets the current store instance.</p>\n"},"onBindStore":{"!type":"fn(store: ?, initial: ?) -> !this","!doc":"<p>Template method, it is called when a new store is bound\nto the current instance.</p>\n"},"onUnbindStore":{"!type":"fn(store: ?, initial: ?) -> !this","!doc":"<p>Template method, it is called when an existing store is unbound\nfrom the current instance.</p>\n"},"unbindStoreListeners":{"!type":"fn(store: ?) -> !this","!doc":"<p>Unbinds listeners from this component to the store. By default it will remove\nanything bound by the bindStoreListeners method, however it can be overridden\nin a subclass to provide any more complicated handling.</p>\n"},"bindStore":{"!type":"fn(store?: ?) -> !this","!doc":"<p>Binds a store to this instance.</p>\n"},"getStoreListeners":{"!type":"fn(store: ?) -> ?","!doc":"<p>Gets the listeners to bind to a new store.</p>\n"}},"!doc":"<p>This class is used as a mixin.</p>\n\n<p>This class is to be used to provide basic methods for binding/unbinding stores to other\nclasses. In general it will not be used directly.</p>\n"},"MixedCollection":{"prototype":{"allowFunctions":{"!type":"bool","!doc":"<p>Configure as <code>true</code> if the <a href=\"#!/api/Ext.util.MixedCollection-method-addAll\" rel=\"Ext.util.MixedCollection-method-addAll\" class=\"docClass\">addAll</a> function should add function references to the collection.</p>\n"},"_sort":{"!type":"fn(property: ?, dir?: ?, fn?: ?) -> !this","!doc":"<p>Performs the actual sorting based on a direction and a sorting function. Internally,\nthis creates a temporary array of all items in the MixedCollection, sorts it and then writes\nthe sorted array data back into this.items and this.keys</p>\n"},"doSort":{"!type":"fn(sorterFn: ?) -> !this"},"findInsertionIndex":{"!type":"fn(newItem: ?, sorterFn?: ?) -> number","!doc":"<p>Calculates the insertion index of the new item based upon the comparison function passed, or the current sort order.</p>\n"},"reorder":{"!type":"fn(mapping: ?) -> !this","!doc":"<p>Reorders each of the items based on a mapping from old index to new index. Internally this\njust translates into a sort. The 'sort' event is fired whenever reordering has occured.</p>\n"},"sortBy":{"!type":"fn(sorterFn: ?) -> !this","!doc":"<p>Sorts the collection by a single sorter function</p>\n"},"sortByKey":{"!type":"fn(direction?: ?, fn?: ?) -> !this","!doc":"<p>Sorts this collection by <b>key</b>s.</p>\n"}},"allowFunctions":{"!type":"bool","!doc":"<p>Configure as <code>true</code> if the <a href=\"#!/api/Ext.util.MixedCollection-method-addAll\" rel=\"Ext.util.MixedCollection-method-addAll\" class=\"docClass\">addAll</a> function should add function references to the collection.</p>\n"},"_sort":{"!type":"fn(property: ?, dir?: ?, fn?: ?) -> !this","!doc":"<p>Performs the actual sorting based on a direction and a sorting function. Internally,\nthis creates a temporary array of all items in the MixedCollection, sorts it and then writes\nthe sorted array data back into this.items and this.keys</p>\n"},"doSort":{"!type":"fn(sorterFn: ?) -> !this"},"findInsertionIndex":{"!type":"fn(newItem: ?, sorterFn?: ?) -> number","!doc":"<p>Calculates the insertion index of the new item based upon the comparison function passed, or the current sort order.</p>\n"},"reorder":{"!type":"fn(mapping: ?) -> !this","!doc":"<p>Reorders each of the items based on a mapping from old index to new index. Internally this\njust translates into a sort. The 'sort' event is fired whenever reordering has occured.</p>\n"},"sortBy":{"!type":"fn(sorterFn: ?) -> !this","!doc":"<p>Sorts the collection by a single sorter function</p>\n"},"sortByKey":{"!type":"fn(direction?: ?, fn?: ?) -> !this","!doc":"<p>Sorts this collection by <b>key</b>s.</p>\n"},"!doc":"<p>Represents a collection of a set of key and value pairs. Each key in the MixedCollection\nmust be unique, the same key cannot exist twice. This collection is ordered, items in the\ncollection can be accessed by index  or via the key. Newly added items are added to\nthe end of the collection. This class is similar to <a href=\"#!/api/Ext.util.HashMap\" rel=\"Ext.util.HashMap\" class=\"docClass\">Ext.util.HashMap</a> however it\nis heavier and provides more functionality. Sample usage:</p>\n\n<pre><code>var coll = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\ncoll.add('key1', 'val1');\ncoll.add('key2', 'val2');\ncoll.add('key3', 'val3');\n\nconsole.log(coll.get('key1')); // prints 'val1'\nconsole.log(coll.indexOfKey('key3')); // prints 2\n</code></pre>\n\n<p>The MixedCollection also has support for sorting and filtering of the values in the collection.</p>\n\n<pre><code>var coll = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\ncoll.add('key1', 100);\ncoll.add('key2', -100);\ncoll.add('key3', 17);\ncoll.add('key4', 0);\nvar biggerThanZero = coll.filterBy(function(value){\n    return value &gt; 0;\n});\nconsole.log(biggerThanZero.getCount()); // prints 2\n</code></pre>\n","!type":"fn(config: ?)"},"Sortable":{"prototype":{"defaultSortDirection":{"!type":"string","!doc":"<p>The default sort direction to use if one is not specified.</p>\n"},"sortRoot":{"!type":"string","!doc":"<p>The property in each item that contains the data to sort.</p>\n"},"sorters":{"!doc":"<p>The collection of <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Sorters</a> currently applied to this Store</p>\n"},"isSortable":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Sortable, or subclass thereof.</p>\n"},"decodeSorters":{"!type":"fn(sorters: ?) -> ?","!doc":"<p>Normalizes an array of sorter objects, ensuring that they are all <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a> instances</p>\n"},"emptyComparator":{"!type":"fn() -> !this"},"generateComparator":{"!type":"fn() -> !this","!doc":"<p>Returns a comparator function which compares two items and returns -1, 0, or 1 depending\non the currently defined set of <a href=\"#!/api/Ext.util.Sortable-cfg-sorters\" rel=\"Ext.util.Sortable-cfg-sorters\" class=\"docClass\">sorters</a>.</p>\n\n<p>If there are no <a href=\"#!/api/Ext.util.Sortable-cfg-sorters\" rel=\"Ext.util.Sortable-cfg-sorters\" class=\"docClass\">sorters</a> defined, it returns a function which returns <code>0</code> meaning\nthat no sorting will occur.</p>\n"},"getFirstSorter":{"!type":"fn() -> ?","!doc":"<p>Gets the first sorter from the sorters collection, excluding\nany groupers that may be in place</p>\n"},"getSorters":{"!type":"fn() -> !this"},"initSortable":{"!type":"fn() -> !this","!doc":"<p>Performs initialization of this mixin. Component classes using this mixin should call this method during their\nown initialization.</p>\n"},"onBeforeSort":{"!type":"fn() -> !this"},"sort":{"!type":"fn(sorters?: ?, direction?: ?) -> ?","!doc":"<p>Sorts the data in the Store by one or more of its properties. Example usage:</p>\n\n<pre><code>//sort by a single field\nmyStore.sort('myField', 'DESC');\n\n//sorting by multiple fields\nmyStore.sort([\n    {\n        property : 'age',\n        direction: 'ASC'\n    },\n    {\n        property : 'name',\n        direction: 'DESC'\n    }\n]);\n</code></pre>\n\n<p>Internally, Store converts the passed arguments into an array of <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a> instances, and delegates\nthe actual sorting to its internal <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>.</p>\n\n<p>When passing a single string argument to sort, Store maintains a ASC/DESC toggler per field, so this code:</p>\n\n<pre><code>store.sort('myField');\nstore.sort('myField');\n</code></pre>\n\n<p>Is equivalent to this code, because Store handles the toggling automatically:</p>\n\n<pre><code>store.sort('myField', 'ASC');\nstore.sort('myField', 'DESC');\n</code></pre>\n"},"createComparator":{"!type":"fn(sorters: ?) -> ?","!doc":"<p>Creates a single comparator function which encapsulates the passed Sorter array.</p>\n"}},"defaultSortDirection":{"!type":"string","!doc":"<p>The default sort direction to use if one is not specified.</p>\n"},"sortRoot":{"!type":"string","!doc":"<p>The property in each item that contains the data to sort.</p>\n"},"sorters":{"!doc":"<p>The collection of <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Sorters</a> currently applied to this Store</p>\n"},"isSortable":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Sortable, or subclass thereof.</p>\n"},"decodeSorters":{"!type":"fn(sorters: ?) -> ?","!doc":"<p>Normalizes an array of sorter objects, ensuring that they are all <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a> instances</p>\n"},"emptyComparator":{"!type":"fn() -> !this"},"generateComparator":{"!type":"fn() -> !this","!doc":"<p>Returns a comparator function which compares two items and returns -1, 0, or 1 depending\non the currently defined set of <a href=\"#!/api/Ext.util.Sortable-cfg-sorters\" rel=\"Ext.util.Sortable-cfg-sorters\" class=\"docClass\">sorters</a>.</p>\n\n<p>If there are no <a href=\"#!/api/Ext.util.Sortable-cfg-sorters\" rel=\"Ext.util.Sortable-cfg-sorters\" class=\"docClass\">sorters</a> defined, it returns a function which returns <code>0</code> meaning\nthat no sorting will occur.</p>\n"},"getFirstSorter":{"!type":"fn() -> ?","!doc":"<p>Gets the first sorter from the sorters collection, excluding\nany groupers that may be in place</p>\n"},"getSorters":{"!type":"fn() -> !this"},"initSortable":{"!type":"fn() -> !this","!doc":"<p>Performs initialization of this mixin. Component classes using this mixin should call this method during their\nown initialization.</p>\n"},"onBeforeSort":{"!type":"fn() -> !this"},"sort":{"!type":"fn(sorters?: ?, direction?: ?) -> ?","!doc":"<p>Sorts the data in the Store by one or more of its properties. Example usage:</p>\n\n<pre><code>//sort by a single field\nmyStore.sort('myField', 'DESC');\n\n//sorting by multiple fields\nmyStore.sort([\n    {\n        property : 'age',\n        direction: 'ASC'\n    },\n    {\n        property : 'name',\n        direction: 'DESC'\n    }\n]);\n</code></pre>\n\n<p>Internally, Store converts the passed arguments into an array of <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a> instances, and delegates\nthe actual sorting to its internal <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>.</p>\n\n<p>When passing a single string argument to sort, Store maintains a ASC/DESC toggler per field, so this code:</p>\n\n<pre><code>store.sort('myField');\nstore.sort('myField');\n</code></pre>\n\n<p>Is equivalent to this code, because Store handles the toggling automatically:</p>\n\n<pre><code>store.sort('myField', 'ASC');\nstore.sort('myField', 'DESC');\n</code></pre>\n"},"!doc":"<p>A mixin which allows a data component to be sorted. This is used by e.g. <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> and <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>.</p>\n\n<p><strong>NOTE</strong>: This mixin is mainly for internal use and most users should not need to use it directly. It\nis more likely you will want to use one of the component classes that import this mixin, such as\n<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> or <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>.</p>\n"},"AbstractMixedCollection":{"prototype":{"generation":{"!type":"number","!doc":"<p>Mutation counter which is incremented upon add and remove.</p>\n"},"indexGeneration":{"!type":"number","!doc":"<p>Mutation counter for the index map which is synchronized with the collection's mutation counter\nwhen the index map is interrogated and found to be out of sync and needed a rebuild.</p>\n"},"isMixedCollection":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated MixedCollection, or subclass thereof.</p>\n"},"addAll":{"!type":"fn(objs: ?) -> !this","!doc":"<p>Adds all elements of an Array or an Object to the collection.</p>\n"},"clear":{"!type":"fn(eOpts: ?)","!doc":"<p>Fires when the collection is cleared.</p>\n"},"clone":{"!type":"fn() -> ?","!doc":"<p>Creates a shallow copy of this collection</p>\n"},"collect":{"!type":"fn(property: ?, root?: ?, allowBlank?: ?) -> ?","!doc":"<p>Collects unique values of a particular property in this MixedCollection</p>\n"},"contains":{"!type":"fn(o: ?) -> bool","!doc":"<p>Returns true if the collection contains the passed Object as an item.</p>\n"},"containsKey":{"!type":"fn(key: ?) -> bool","!doc":"<p>Returns true if the collection contains the passed Object as a key.</p>\n"},"createValueMatcher":{"!type":"fn(value: ?, anyMatch: ?, caseSensitive: ?, exactMatch: ?) -> !this","!doc":"<p>Returns a regular expression based on the given value and matching options. This is used internally for finding and filtering,\nand by <a href=\"#!/api/Ext.data.Store-method-filter\" rel=\"Ext.data.Store-method-filter\" class=\"docClass\">Ext.data.Store.filter</a></p>\n"},"doInsert":{"!type":"fn(index: ?, keys: ?, objects: ?) -> !this","!doc":"<p>Private multi insert implementation.</p>\n"},"each":{"!type":"fn(fn: ?, scope?: ?) -> !this","!doc":"<p>Executes the specified function once for every item in the collection.\nThe function should return a boolean value.\nReturning false from the function will stop the iteration.</p>\n"},"eachKey":{"!type":"fn(fn: ?, scope?: ?) -> !this","!doc":"<p>Executes the specified function once for every key in the collection, passing each\nkey, and its associated item as the first two parameters.</p>\n"},"extractValues":{"!type":"fn(property: ?, root?: ?) -> ?","!doc":"<p>Extracts all of the given property values from the items in the MC. Mainly used as a supporting method for\nfunctions like sum and collect.</p>\n"},"filter":{"!type":"fn(property: ?, value: ?, anyMatch?: ?, caseSensitive?: ?) -> ?","!doc":"<p>Filters the objects in this collection by a set of <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Filter</a>s, or by a single\nproperty/value pair with optional parameters for substring matching and case sensitivity. See\n<a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Filter</a> for an example of using Filter objects (preferred). Alternatively,\nMixedCollection can be easily filtered by property like this:</p>\n\n\n<p>   //create a simple store with a few people defined\n   var people = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\n   people.addAll([\n       {id: 1, age: 25, name: 'Ed'},\n       {id: 2, age: 24, name: 'Tommy'},\n       {id: 3, age: 24, name: 'Arne'},\n       {id: 4, age: 26, name: 'Aaron'}\n   ]);</p>\n\n<p>   //a new MixedCollection containing only the items where age == 24\n   var middleAged = people.filter('age', 24);</p>\n"},"filterBy":{"!type":"fn(fn: ?, scope?: ?) -> ?","!doc":"<p>Filter by a function. Returns a <i>new</i> collection that has been filtered.\nThe passed function will be called with each object in the collection.\nIf the function returns true, the value is included otherwise it is filtered.</p>\n"},"find":{"!type":"fn() -> !this","!doc":"<p>Returns the first item in the collection which elicits a true return value from the passed selection function.</p>\n"},"findBy":{"!type":"fn(fn: ?, scope?: ?) -> ?","!doc":"<p>Returns the first item in the collection which elicits a true return value from the\npassed selection function.</p>\n"},"findIndex":{"!type":"fn(property: ?, value: ?, start?: ?, anyMatch?: ?, caseSensitive?: ?) -> number","!doc":"<p>Finds the index of the first matching object in this collection by a specific property/value.</p>\n"},"findIndexBy":{"!type":"fn(fn: ?, scope?: ?, start?: ?) -> number","!doc":"<p>Find the index of the first matching object in this collection by a function.\nIf the function returns <i>true</i> it is considered a match.</p>\n"},"first":{"!type":"fn() -> ?","!doc":"<p>Returns the first item in the collection.</p>\n"},"get":{"!type":"fn(key: ?) -> ?","!doc":"<p>Returns the item associated with the passed key OR index.\nKey has priority over index.  This is the equivalent\nof calling <a href=\"#!/api/Ext.util.AbstractMixedCollection-method-getByKey\" rel=\"Ext.util.AbstractMixedCollection-method-getByKey\" class=\"docClass\">getByKey</a> first, then if nothing matched calling <a href=\"#!/api/Ext.util.AbstractMixedCollection-method-getAt\" rel=\"Ext.util.AbstractMixedCollection-method-getAt\" class=\"docClass\">getAt</a>.</p>\n"},"getAt":{"!type":"fn(index: ?) -> ?","!doc":"<p>Returns the item at the specified index.</p>\n"},"getByKey":{"!type":"fn(key: ?) -> ?","!doc":"<p>Returns the item associated with the passed key.</p>\n"},"getCount":{"!type":"fn() -> number","!doc":"<p>Returns the number of items in the collection.</p>\n"},"getKey":{"!type":"fn(item: ?) -> ?","!doc":"<p>A function which will be called, passing a newly added object\nwhen the object is added without a separate id.  The function\nshould yield the key by which that object will be indexed.</p>\n\n<p>If no key is yielded, then the object will be added, but it\ncannot be accessed or removed quickly. Finding it in this\ncollection for interrogation or removal will require a linear\nscan of this collection's items.</p>\n\n<p>The default implementation simply returns <code>item.id</code> but you can\nprovide your own implementation to return a different value as\nin the following examples:</p>\n\n<pre><code>// normal way\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\nmc.add(someEl.dom.id, someEl);\nmc.add(otherEl.dom.id, otherEl);\n//and so on\n\n// using getKey\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>({\n    getKey: function(el){\n        return el.dom.id;\n    }\n});\nmc.add(someEl);\nmc.add(otherEl);\n</code></pre>\n"},"getRange":{"!type":"fn(startIndex?: ?, endIndex?: ?) -> ?","!doc":"<p>Returns a range of items in this collection</p>\n"},"hasRange":{"!type":"fn(start: ?, end: ?) -> !this","!doc":"<p>For API parity with Store's PageMap class. Buffered rendering checks if the Store has the range\nrequired to render. The Store delegates this question to its backing data object which may be an instance\nof its private PageMap class, or a MixedCollection.</p>\n"},"indexOf":{"!type":"fn(o: ?) -> number","!doc":"<p>Returns index within the collection of the passed Object.</p>\n"},"indexOfKey":{"!type":"fn(key: ?) -> number","!doc":"<p>Returns index within the collection of the passed key.</p>\n"},"last":{"!type":"fn() -> ?","!doc":"<p>Returns the last item in the collection.</p>\n"},"rebuildIndexMap":{"!type":"fn() -> !this"},"removeAll":{"!type":"fn(items?: ?) -> ?","!doc":"<p>Remove all items in the collection. Can also be used\nto remove only the items in the passed array.</p>\n"},"removeAt":{"!type":"fn(index: ?) -> ?","!doc":"<p>Remove an item from a specified index in the collection. Fires the <a href=\"#!/api/Ext.util.AbstractMixedCollection-event-remove\" rel=\"Ext.util.AbstractMixedCollection-event-remove\" class=\"docClass\">remove</a> event when complete.</p>\n"},"removeAtKey":{"!type":"fn(key: ?) -> ?","!doc":"<p>Removes an item associated with the passed key fom the collection.</p>\n"},"removeRange":{"!type":"fn(index: ?, removeCount?: ?) -> ?","!doc":"<p>Remove a range of items starting at a specified index in the collection.\nDoes not fire the remove event.</p>\n"},"replace":{"!type":"fn(key: ?, old: ?, new: ?, eOpts: ?)","!doc":"<p>Fires when an item is replaced in the collection.</p>\n"},"sum":{"!type":"fn(property: ?, root?: ?, start?: ?, end?: ?) -> number","!doc":"<p>Collects all of the values of the given property and returns their sum</p>\n"},"updateKey":{"!type":"fn(oldKey: ?, newKey: ?) -> !this","!doc":"<p>Change the key for an existing item in the collection. If the old key\ndoes not exist this is a no-op.</p>\n"},"add":{"!type":"fn(index: ?, o: ?, key: ?, eOpts: ?)","!doc":"<p>Fires when an item is added to the collection.</p>\n"},"remove":{"!type":"fn(o: ?, key?: ?, eOpts: ?)","!doc":"<p>Fires when an item is removed from the collection.</p>\n"},"insert":{"!type":"fn(index: ?, key: ?, o?: ?) -> ?","!doc":"<p>Inserts an item at the specified index in the collection. Fires the <a href=\"#!/api/Ext.util.AbstractMixedCollection-event-add\" rel=\"Ext.util.AbstractMixedCollection-event-add\" class=\"docClass\">add</a> event when complete.</p>\n"},"allowFunctions":{"!type":"bool","!doc":"<p>Specify <code>true</code> if the <a href=\"#!/api/Ext.util.AbstractMixedCollection-method-addAll\" rel=\"Ext.util.AbstractMixedCollection-method-addAll\" class=\"docClass\">addAll</a>\nfunction should add function references to the collection. Defaults to\n<code>false</code>.</p>\n"}},"generation":{"!type":"number","!doc":"<p>Mutation counter which is incremented upon add and remove.</p>\n"},"indexGeneration":{"!type":"number","!doc":"<p>Mutation counter for the index map which is synchronized with the collection's mutation counter\nwhen the index map is interrogated and found to be out of sync and needed a rebuild.</p>\n"},"isMixedCollection":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated MixedCollection, or subclass thereof.</p>\n"},"add":{"!type":"fn(index: ?, o: ?, key: ?, eOpts: ?)","!doc":"<p>Fires when an item is added to the collection.</p>\n"},"addAll":{"!type":"fn(objs: ?) -> !this","!doc":"<p>Adds all elements of an Array or an Object to the collection.</p>\n"},"clear":{"!type":"fn(eOpts: ?)","!doc":"<p>Fires when the collection is cleared.</p>\n"},"clone":{"!type":"fn() -> ?","!doc":"<p>Creates a shallow copy of this collection</p>\n"},"collect":{"!type":"fn(property: ?, root?: ?, allowBlank?: ?) -> ?","!doc":"<p>Collects unique values of a particular property in this MixedCollection</p>\n"},"contains":{"!type":"fn(o: ?) -> bool","!doc":"<p>Returns true if the collection contains the passed Object as an item.</p>\n"},"containsKey":{"!type":"fn(key: ?) -> bool","!doc":"<p>Returns true if the collection contains the passed Object as a key.</p>\n"},"createValueMatcher":{"!type":"fn(value: ?, anyMatch: ?, caseSensitive: ?, exactMatch: ?) -> !this","!doc":"<p>Returns a regular expression based on the given value and matching options. This is used internally for finding and filtering,\nand by <a href=\"#!/api/Ext.data.Store-method-filter\" rel=\"Ext.data.Store-method-filter\" class=\"docClass\">Ext.data.Store.filter</a></p>\n"},"doInsert":{"!type":"fn(index: ?, keys: ?, objects: ?) -> !this","!doc":"<p>Private multi insert implementation.</p>\n"},"each":{"!type":"fn(fn: ?, scope?: ?) -> !this","!doc":"<p>Executes the specified function once for every item in the collection.\nThe function should return a boolean value.\nReturning false from the function will stop the iteration.</p>\n"},"eachKey":{"!type":"fn(fn: ?, scope?: ?) -> !this","!doc":"<p>Executes the specified function once for every key in the collection, passing each\nkey, and its associated item as the first two parameters.</p>\n"},"extractValues":{"!type":"fn(property: ?, root?: ?) -> ?","!doc":"<p>Extracts all of the given property values from the items in the MC. Mainly used as a supporting method for\nfunctions like sum and collect.</p>\n"},"filter":{"!type":"fn(property: ?, value: ?, anyMatch?: ?, caseSensitive?: ?) -> ?","!doc":"<p>Filters the objects in this collection by a set of <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Filter</a>s, or by a single\nproperty/value pair with optional parameters for substring matching and case sensitivity. See\n<a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Filter</a> for an example of using Filter objects (preferred). Alternatively,\nMixedCollection can be easily filtered by property like this:</p>\n\n\n<p>   //create a simple store with a few people defined\n   var people = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\n   people.addAll([\n       {id: 1, age: 25, name: 'Ed'},\n       {id: 2, age: 24, name: 'Tommy'},\n       {id: 3, age: 24, name: 'Arne'},\n       {id: 4, age: 26, name: 'Aaron'}\n   ]);</p>\n\n<p>   //a new MixedCollection containing only the items where age == 24\n   var middleAged = people.filter('age', 24);</p>\n"},"filterBy":{"!type":"fn(fn: ?, scope?: ?) -> ?","!doc":"<p>Filter by a function. Returns a <i>new</i> collection that has been filtered.\nThe passed function will be called with each object in the collection.\nIf the function returns true, the value is included otherwise it is filtered.</p>\n"},"find":{"!type":"fn() -> !this","!doc":"<p>Returns the first item in the collection which elicits a true return value from the passed selection function.</p>\n"},"findBy":{"!type":"fn(fn: ?, scope?: ?) -> ?","!doc":"<p>Returns the first item in the collection which elicits a true return value from the\npassed selection function.</p>\n"},"findIndex":{"!type":"fn(property: ?, value: ?, start?: ?, anyMatch?: ?, caseSensitive?: ?) -> number","!doc":"<p>Finds the index of the first matching object in this collection by a specific property/value.</p>\n"},"findIndexBy":{"!type":"fn(fn: ?, scope?: ?, start?: ?) -> number","!doc":"<p>Find the index of the first matching object in this collection by a function.\nIf the function returns <i>true</i> it is considered a match.</p>\n"},"first":{"!type":"fn() -> ?","!doc":"<p>Returns the first item in the collection.</p>\n"},"get":{"!type":"fn(key: ?) -> ?","!doc":"<p>Returns the item associated with the passed key OR index.\nKey has priority over index.  This is the equivalent\nof calling <a href=\"#!/api/Ext.util.AbstractMixedCollection-method-getByKey\" rel=\"Ext.util.AbstractMixedCollection-method-getByKey\" class=\"docClass\">getByKey</a> first, then if nothing matched calling <a href=\"#!/api/Ext.util.AbstractMixedCollection-method-getAt\" rel=\"Ext.util.AbstractMixedCollection-method-getAt\" class=\"docClass\">getAt</a>.</p>\n"},"getAt":{"!type":"fn(index: ?) -> ?","!doc":"<p>Returns the item at the specified index.</p>\n"},"getByKey":{"!type":"fn(key: ?) -> ?","!doc":"<p>Returns the item associated with the passed key.</p>\n"},"getCount":{"!type":"fn() -> number","!doc":"<p>Returns the number of items in the collection.</p>\n"},"getRange":{"!type":"fn(startIndex?: ?, endIndex?: ?) -> ?","!doc":"<p>Returns a range of items in this collection</p>\n"},"hasRange":{"!type":"fn(start: ?, end: ?) -> !this","!doc":"<p>For API parity with Store's PageMap class. Buffered rendering checks if the Store has the range\nrequired to render. The Store delegates this question to its backing data object which may be an instance\nof its private PageMap class, or a MixedCollection.</p>\n"},"indexOf":{"!type":"fn(o: ?) -> number","!doc":"<p>Returns index within the collection of the passed Object.</p>\n"},"indexOfKey":{"!type":"fn(key: ?) -> number","!doc":"<p>Returns index within the collection of the passed key.</p>\n"},"insert":{"!type":"fn(index: ?, key: ?, o?: ?) -> ?","!doc":"<p>Inserts an item at the specified index in the collection. Fires the <a href=\"#!/api/Ext.util.AbstractMixedCollection-event-add\" rel=\"Ext.util.AbstractMixedCollection-event-add\" class=\"docClass\">add</a> event when complete.</p>\n"},"last":{"!type":"fn() -> ?","!doc":"<p>Returns the last item in the collection.</p>\n"},"rebuildIndexMap":{"!type":"fn() -> !this"},"remove":{"!type":"fn(o: ?, key?: ?, eOpts: ?)","!doc":"<p>Fires when an item is removed from the collection.</p>\n"},"removeAll":{"!type":"fn(items?: ?) -> ?","!doc":"<p>Remove all items in the collection. Can also be used\nto remove only the items in the passed array.</p>\n"},"removeAt":{"!type":"fn(index: ?) -> ?","!doc":"<p>Remove an item from a specified index in the collection. Fires the <a href=\"#!/api/Ext.util.AbstractMixedCollection-event-remove\" rel=\"Ext.util.AbstractMixedCollection-event-remove\" class=\"docClass\">remove</a> event when complete.</p>\n"},"removeAtKey":{"!type":"fn(key: ?) -> ?","!doc":"<p>Removes an item associated with the passed key fom the collection.</p>\n"},"removeRange":{"!type":"fn(index: ?, removeCount?: ?) -> ?","!doc":"<p>Remove a range of items starting at a specified index in the collection.\nDoes not fire the remove event.</p>\n"},"replace":{"!type":"fn(key: ?, old: ?, new: ?, eOpts: ?)","!doc":"<p>Fires when an item is replaced in the collection.</p>\n"},"sum":{"!type":"fn(property: ?, root?: ?, start?: ?, end?: ?) -> number","!doc":"<p>Collects all of the values of the given property and returns their sum</p>\n"},"updateKey":{"!type":"fn(oldKey: ?, newKey: ?) -> !this","!doc":"<p>Change the key for an existing item in the collection. If the old key\ndoes not exist this is a no-op.</p>\n"},"getKey":{"!type":"fn(item: ?) -> ?","!doc":"<p>A function which will be called, passing a newly added object\nwhen the object is added without a separate id.  The function\nshould yield the key by which that object will be indexed.</p>\n\n<p>If no key is yielded, then the object will be added, but it\ncannot be accessed or removed quickly. Finding it in this\ncollection for interrogation or removal will require a linear\nscan of this collection's items.</p>\n\n<p>The default implementation simply returns <code>item.id</code> but you can\nprovide your own implementation to return a different value as\nin the following examples:</p>\n\n<pre><code>// normal way\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\nmc.add(someEl.dom.id, someEl);\nmc.add(otherEl.dom.id, otherEl);\n//and so on\n\n// using getKey\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>({\n    getKey: function(el){\n        return el.dom.id;\n    }\n});\nmc.add(someEl);\nmc.add(otherEl);\n</code></pre>\n"},"!type":"fn(allowFunctions: ?, keyFn: ?)"},"HashMap":{"prototype":{"keyFn":{"!doc":"<p>A function that is used to retrieve a default key for a passed object.\nA default is provided that returns the <code>id</code> property on the object. This function is only used\nif the <code>add</code> method is called with a single argument.</p>\n"},"generation":{"!type":"number","!doc":"<p>Mutation counter which is incremented upon add and remove.</p>\n"},"getData":{"!type":"fn(key: ?, value: ?) -> ?","!doc":"<p>Implementation for being able to extract the key from an object if only\na single argument is passed.</p>\n"},"getKey":{"!type":"fn(o: ?) -> string","!doc":"<p>Extracts the key from an object. This is a default implementation, it may be overridden</p>\n"},"replace":{"!type":"fn(this: ?, key: ?, value: ?, old: ?, eOpts: ?)","!doc":"<p>Fires when an item is replaced in the hash.</p>\n"},"add":{"!type":"fn(this: ?, key: ?, value: ?, eOpts: ?)","!doc":"<p>Fires when a new item is added to the hash.</p>\n"},"clear":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires when the hash is cleared.</p>\n"},"remove":{"!type":"fn(this: ?, key: ?, value: ?, eOpts: ?)","!doc":"<p>Fires when an item is removed from the hash.</p>\n"},"clone":{"!type":"fn() -> ?","!doc":"<p>Performs a shallow copy on this hash.</p>\n"},"contains":{"!type":"fn(value: ?) -> bool","!doc":"<p>Checks whether a value exists in the hash.</p>\n"},"containsKey":{"!type":"fn(key: ?) -> bool","!doc":"<p>Checks whether a key exists in the hash.</p>\n"},"each":{"!type":"fn(fn: ?, scope?: ?) -> ?","!doc":"<p>Executes the specified function once for each item in the hash.\nReturning false from the function will cease iteration.</p>\n"},"findKey":{"!type":"fn(value: ?) -> ?","!doc":"<p>Find the key for a value.</p>\n"},"get":{"!type":"fn(key: ?) -> ?","!doc":"<p>Retrieves an item with a particular key.</p>\n"},"getArray":{"!type":"fn(isKey: ?) -> ?","!doc":"<p>Gets either the keys/values in an array from the hash.</p>\n"},"getCount":{"!type":"fn() -> number","!doc":"<p>Gets the number of items in the hash.</p>\n"},"getKeys":{"!type":"fn() -> ?","!doc":"<p>Return all of the keys in the hash.</p>\n"},"getValues":{"!type":"fn() -> ?","!doc":"<p>Return all of the values in the hash.</p>\n"},"removeAtKey":{"!type":"fn(key: ?) -> bool","!doc":"<p>Remove an item from the hash.</p>\n"}},"!doc":"<p>Represents a collection of a set of key and value pairs. Each key in the HashMap\nmust be unique, the same key cannot exist twice. Access to items is provided via\nthe key only. Sample usage:</p>\n\n<pre><code>var map = new <a href=\"#!/api/Ext.util.HashMap\" rel=\"Ext.util.HashMap\" class=\"docClass\">Ext.util.HashMap</a>();\nmap.add('key1', 1);\nmap.add('key2', 2);\nmap.add('key3', 3);\n\nmap.each(function(key, value, length){\n    console.log(key, value, length);\n});\n</code></pre>\n\n<p>The HashMap is an unordered class,\nthere is no guarantee when iterating over the items that they will be in any particular\norder. If this is required, then use a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>.</p>\n","!type":"fn(config?: ?)"},"LruCache":{"prototype":{"maxSize":{"!type":"number","!doc":"<p>The maximum size the cache is allowed to grow to before further additions cause\nremoval of the least recently used entry.</p>\n"},"add":{"!type":"fn(key: ?, newValue: ?) -> ?","!doc":"<p>Adds an item to the collection. Fires the <a href=\"#!/api/Ext.util.LruCache-event-add\" rel=\"Ext.util.LruCache-event-add\" class=\"docClass\">add</a> event when complete.</p>\n"},"clone":{"!type":"fn() -> ?","!doc":"<p>Performs a shallow copy on this haLruCachesh.</p>\n"},"contains":{"!type":"fn()"},"containsKey":{"!type":"fn()"},"each":{"!type":"fn(fn: ?, scope: ?, reverse?: ?) -> ?","!doc":"<p>Executes the specified function once for each item in the cache.\nReturning false from the function will cease iteration.</p>\n\n<p>By default, iteration is from least recently used to most recent.</p>\n\n<p>The paramaters passed to the function are:</p>\n\n<div class=\"mdetail-params\"><ul>\n<li><b>key</b> : String<p class=\"sub-desc\">The key of the item</p></li>\n<li><b>value</b> : Number<p class=\"sub-desc\">The value of the item</p></li>\n<li><b>length</b> : Number<p class=\"sub-desc\">The total number of items in the hash</p></li>\n</ul></div>\n\n"},"findKey":{"!type":"fn(value: ?) -> !this"},"get":{"!type":"fn(key: ?) -> ?","!doc":"<p>Retrieves an item with a particular key.</p>\n"},"getArray":{"!type":"fn(isKey: ?) -> ?","!doc":"<p>Gets either the keys/values in an array from the hash.</p>\n"},"getKeys":{"!type":"fn()"},"getValues":{"!type":"fn()"},"insertBefore":{"!type":"fn(key: ?, newValue: ?, sibling: ?) -> !this"},"moveToEnd":{"!type":"fn(entry: ?) -> !this","!doc":"<p>private. Only used by internal methods.</p>\n"},"prune":{"!type":"fn() -> !this","!doc":"<p>Purge the least recently used entries if the maxSize has been exceeded.</p>\n"},"removeAtKey":{"!type":"fn(key: ?) -> bool","!doc":"<p>Remove an item from the hash.</p>\n"},"unlinkEntry":{"!type":"fn(entry: ?) -> !this","!doc":"<p>private. Only used by internal methods.</p>\n"},"clear":{"!type":"fn(initial: ?) -> ?","!doc":"<p>Removes all items from the hash.</p>\n"}},"!doc":"<p>A linked <a href=\"#!/api/Ext.util.HashMap\" rel=\"Ext.util.HashMap\" class=\"docClass\">HashMap</a> implementation which maintains most recently accessed\nitems at the end of the list, and purges the cache down to the most recently accessed <a href=\"#!/api/Ext.util.LruCache-cfg-maxSize\" rel=\"Ext.util.LruCache-cfg-maxSize\" class=\"docClass\">maxSize</a> items\nupon add.</p>\n","!type":"fn(config?: ?)"},"KeyNav":{"prototype":{"defaultEventAction":{"!type":"string","!doc":"<p>The method to call on the <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> after this KeyNav intercepts a key. Valid values are <a href=\"#!/api/Ext.EventObject-method-stopEvent\" rel=\"Ext.EventObject-method-stopEvent\" class=\"docClass\">Ext.EventObject.stopEvent</a>, <a href=\"#!/api/Ext.EventObject-method-preventDefault\" rel=\"Ext.EventObject-method-preventDefault\" class=\"docClass\">Ext.EventObject.preventDefault</a> and <a href=\"#!/api/Ext.EventObject-method-stopPropagation\" rel=\"Ext.EventObject-method-stopPropagation\" class=\"docClass\">Ext.EventObject.stopPropagation</a>.</p>\n\n<p>If a falsy value is specified, no method is called on the key event.</p>\n"},"disabled":{"!type":"bool","!doc":"<p>True to disable this KeyNav instance.</p>\n"},"eventName":{"!type":"string","!doc":"<p>The event to listen for to pick up key events.</p>\n"},"forceKeyDown":{"!type":"bool","!doc":"<p>Handle the keydown event instead of keypress. KeyNav automatically does this for IE since IE does not propagate\nspecial keys on keypress, but setting this to true will force other browsers to also handle keydown instead of\nkeypress.</p>\n"},"ignoreInputFields":{"!type":"bool","!doc":"<p>Configure this as <code>true</code> if there are any input fields within the <a href=\"#!/api/Ext.util.KeyNav-cfg-target\" rel=\"Ext.util.KeyNav-cfg-target\" class=\"docClass\">target</a>, and this KeyNav\nshould not process events from input fields, (<code>&amp;lt;input&gt;, &amp;lt;textarea&gt; and elements with</code>contentEditable=\"true\"`)</p>\n"},"keyMap":{"!doc":"<p>An optional pre-existing <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">KeyMap</a> to use to listen for key events. If not specified,\none is created.</p>\n"},"processEvent":{"!doc":"<p>An optional event processor function which accepts the argument list provided by the <a href=\"#!/api/Ext.util.KeyNav-cfg-eventName\" rel=\"Ext.util.KeyNav-cfg-eventName\" class=\"docClass\">configured\nevent</a> of the <a href=\"#!/api/Ext.util.KeyNav-cfg-target\" rel=\"Ext.util.KeyNav-cfg-target\" class=\"docClass\">target</a>, and returns a keyEvent for processing by the KeyMap.</p>\n\n<p>This may be useful when the <a href=\"#!/api/Ext.util.KeyNav-cfg-target\" rel=\"Ext.util.KeyNav-cfg-target\" class=\"docClass\">target</a> is a Component with s complex event signature. Extra information from\nthe event arguments may be injected into the event for use by the handler functions before returning it.</p>\n"},"processEventScope":{"!doc":"<p>The scope (<code>this</code> context) in which the <a href=\"#!/api/Ext.util.KeyNav-cfg-processEvent\" rel=\"Ext.util.KeyNav-cfg-processEvent\" class=\"docClass\">processEvent</a> method is executed.</p>\n"},"target":{"!doc":"<p>The object on which to listen for the event specified by the <a href=\"#!/api/Ext.util.KeyNav-cfg-eventName\" rel=\"Ext.util.KeyNav-cfg-eventName\" class=\"docClass\">eventName</a> config option.</p>\n"},"destroy":{"!type":"fn(removeEl: ?) -> !this","!doc":"<p>Destroy this KeyNav.</p>\n"},"disable":{"!type":"fn() -> !this","!doc":"<p>Disables this KeyNav.</p>\n"},"enable":{"!type":"fn() -> !this","!doc":"<p>Enables this KeyNav.</p>\n"},"getKeyEvent":{"!type":"fn(forceKeyDown: ?, configuredEventName: ?) -> string","!doc":"<p>Determines the event to bind to listen for keys. Defaults to the <a href=\"#!/api/Ext.util.KeyNav-cfg-eventName\" rel=\"Ext.util.KeyNav-cfg-eventName\" class=\"docClass\">eventName</a> value, but\nmay be overridden the <a href=\"#!/api/Ext.util.KeyNav-cfg-forceKeyDown\" rel=\"Ext.util.KeyNav-cfg-forceKeyDown\" class=\"docClass\">forceKeyDown</a> setting.</p>\n\n<p>The useKeyDown option on the EventManager modifies the default <a href=\"#!/api/Ext.util.KeyNav-cfg-eventName\" rel=\"Ext.util.KeyNav-cfg-eventName\" class=\"docClass\">eventName</a> to be <code>keydown</code>,\nbut a configured <a href=\"#!/api/Ext.util.KeyNav-cfg-eventName\" rel=\"Ext.util.KeyNav-cfg-eventName\" class=\"docClass\">eventName</a> takes priority over this.</p>\n"},"handleEvent":{"!type":"fn(keyCode: ?, event: ?, options: ?) -> !this","!doc":"<p>Method for filtering out the map argument</p>\n"},"legacyConstructor":{"!type":"fn(el: ?, config: ?) -> !this","!doc":"<p>Old constructor signature.</p>\n"},"setConfig":{"!type":"fn(config: ?) -> !this","!doc":"<p>Sets up a configuration for the KeyNav.</p>\n"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Convenience function for setting disabled/enabled by boolean.</p>\n"},"keyOptions":{}},"!doc":"<p>Provides a convenient wrapper for normalized keyboard navigation. KeyNav allows you to bind navigation keys to\nfunction calls that will get called when the keys are pressed, providing an easy way to implement custom navigation\nschemes for any UI component.</p>\n\n<p>The following are all of the possible keys that can be implemented: enter, space, left, right, up, down, tab, esc,\npageUp, pageDown, del, backspace, home, end.</p>\n\n<p>Usage:</p>\n\n<pre><code>var nav = new <a href=\"#!/api/Ext.util.KeyNav\" rel=\"Ext.util.KeyNav\" class=\"docClass\">Ext.util.KeyNav</a>({\n    target : \"my-element\",\n    left   : function(e){\n        this.moveLeft(e.ctrlKey);\n    },\n    right  : function(e){\n        this.moveRight(e.ctrlKey);\n    },\n    enter  : function(e){\n        this.save();\n    },\n\n    // Binding may be a function specifiying fn, scope and defaultAction\n    esc: {\n        fn: this.onEsc,\n        defaultEventAction: false\n    },\n    scope : this\n});\n</code></pre>\n","!type":"fn(config: ?)"},"ClickRepeater":{"!doc":"<p>A wrapper class which can be applied to any element. Fires a \"click\" event while the\nmouse is pressed. The interval between firings may be specified in the config but\ndefaults to 20 milliseconds.</p>\n\n<p>Optionally, a CSS class may be applied to the element during the time it is pressed.</p>\n","!type":"fn(el: ?, config?: ?)","prototype":{"accelerate":{"!type":"bool","!doc":"<p>True if autorepeating should start slowly and accelerate.\n\"interval\" and \"delay\" are ignored.</p>\n"},"delay":{"!type":"number","!doc":"<p>The initial delay before the repeating event begins firing.\nSimilar to an autorepeat key delay.</p>\n"},"el":{"!doc":"<p>The element to act as a button.</p>\n"},"interval":{"!type":"number","!doc":"<p>The interval between firings of the \"click\" event (in milliseconds).</p>\n"},"pressedCls":{"!type":"string","!doc":"<p>A CSS class name to be applied to the element while pressed.</p>\n"},"preventDefault":{"!type":"bool","!doc":"<p>True to prevent the default click event</p>\n"},"stopDefault":{"!type":"bool","!doc":"<p>True to stop the default click event</p>\n"},"timer":{"!type":"number"},"click":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires on a specified interval during the time the element is pressed.</p>\n"},"destroy":{"!type":"fn() -> !this"},"disable":{"!type":"fn(force: ?) -> !this","!doc":"<p>Disables the repeater and stops events from firing.</p>\n"},"easeOutExpo":{"!type":"fn(t: ?, b: ?, c: ?, d: ?) -> !this"},"enable":{"!type":"fn() -> !this","!doc":"<p>Enables the repeater and allows events to fire.</p>\n"},"eventOptions":{"!type":"fn(e: ?) -> !this"},"handleDblClick":{"!type":"fn(e: ?) -> !this"},"handleMouseDown":{"!type":"fn(e: ?) -> !this"},"handleMouseOut":{"!type":"fn() -> !this"},"handleMouseReturn":{"!type":"fn() -> !this"},"handleMouseUp":{"!type":"fn(e: ?) -> !this"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Convenience function for setting disabled/enabled by boolean.</p>\n"},"mousedown":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse button is depressed.</p>\n"},"mouseup":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse key is released.</p>\n"}}},"ComponentDragger":{"!doc":"<p>A subclass of <a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">Ext.dd.DragTracker</a> which handles dragging any Component.</p>\n\n<p>This is configured with a Component to be made draggable, and a config object for the <a href=\"#!/api/Ext.dd.DragTracker\" rel=\"Ext.dd.DragTracker\" class=\"docClass\">Ext.dd.DragTracker</a>\nclass.</p>\n\n<p>A <a href=\"#!/api/Ext.util.ComponentDragger-cfg-delegate\" rel=\"Ext.util.ComponentDragger-cfg-delegate\" class=\"docClass\">delegate</a> may be provided which may be either the element to use as the mousedown target or a <a href=\"#!/api/Ext.dom.Query\" rel=\"Ext.dom.Query\" class=\"docClass\">Ext.DomQuery</a> selector to activate multiple mousedown targets.</p>\n\n<p>When the Component begins to be dragged, its <code>beginDrag</code> method will be called if implemented.</p>\n\n<p>When the drag ends, its <code>endDrag</code> method will be called if implemented.</p>\n","!type":"fn(comp: ?, config?: ?)","prototype":{"constrain":{"!type":"bool","!doc":"<p>Specify as <code>true</code> to constrain the Component to within the bounds of the <a href=\"#!/api/Ext.util.ComponentDragger-cfg-constrainTo\" rel=\"Ext.util.ComponentDragger-cfg-constrainTo\" class=\"docClass\">constrainTo</a> region.</p>\n"},"constrainDelegate":{"!type":"bool","!doc":"<p>Specify as <code>true</code> to constrain the drag handles within the <a href=\"#!/api/Ext.util.ComponentDragger-cfg-constrainTo\" rel=\"Ext.util.ComponentDragger-cfg-constrainTo\" class=\"docClass\">constrainTo</a> region.</p>\n"},"delegate":{"!doc":"<p>A <a href=\"#!/api/Ext.dom.Query\" rel=\"Ext.dom.Query\" class=\"docClass\">DomQuery</a> selector which identifies child elements within the Component's encapsulating\nElement which are the drag handles. This limits dragging to only begin when the matching elements are\nmousedowned.</p>\n\n<p>This may also be a specific child element within the Component's encapsulating element to use as the drag handle.</p>\n"},"calculateConstrainRegion":{"!type":"fn() -> !this"},"onDrag":{"!type":"fn(e: ?) -> !this","!doc":"<p>Move either the ghost Component or the target Component to its new position on drag</p>\n"},"onEnd":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method which should be overridden by each DragTracker instance. Called when a drag operation has been completed\n(e.g. the user clicked and held the mouse down, dragged the element and then released the mouse button)</p>\n"},"onStart":{"!type":"fn(e: ?) -> !this","!doc":"<p>Template method which should be overridden by each DragTracker instance. Called when a drag operation starts\n(e.g. the user has moved the tracked element beyond the specified tolerance)</p>\n"}}},"Cookies":{"!doc":"<p>Utility class for setting/reading values from browser cookies.\nValues can be written using the <a href=\"#!/api/Ext.util.Cookies-method-set\" rel=\"Ext.util.Cookies-method-set\" class=\"docClass\">set</a> method.\nValues can be read using the <a href=\"#!/api/Ext.util.Cookies-method-get\" rel=\"Ext.util.Cookies-method-get\" class=\"docClass\">get</a> method.\nA cookie can be invalidated on the client machine using the <a href=\"#!/api/Ext.util.Cookies-method-clear\" rel=\"Ext.util.Cookies-method-clear\" class=\"docClass\">clear</a> method.</p>\n","clear":{"!type":"fn(name: ?, path?: ?) -> !this","!doc":"<p>Removes a cookie with the provided name from the browser\nif found by setting its expiration date to sometime in the past.</p>\n"},"get":{"!type":"fn(name: ?) -> ?","!doc":"<p>Retrieves cookies that are accessible by the current page. If a cookie does not exist, <code>get()</code> returns null. The\nfollowing example retrieves the cookie called \"valid\" and stores the String value in the variable validStatus.</p>\n\n<pre><code>var validStatus = <a href=\"#!/api/Ext.util.Cookies-method-get\" rel=\"Ext.util.Cookies-method-get\" class=\"docClass\">Ext.util.Cookies.get</a>(\"valid\");\n</code></pre>\n"},"getCookieVal":{"!type":"fn(offset: ?) -> !this"},"set":{"!type":"fn(name: ?, value: ?, expires?: ?, path?: ?, domain?: ?, secure?: ?) -> !this","!doc":"<p>Creates a cookie with the specified name and value. Additional settings for the cookie may be optionally specified\n(for example: expiration, access restriction, SSL).</p>\n"}},"CSS":{"!doc":"<p>Utility class for manipulating CSS rules</p>\n","createRule":{"!type":"fn(styleSheet: ?, selector: ?, property: ?) -> ?","!doc":"<p>Creates a rule.</p>\n"},"createStyleSheet":{"!type":"fn(cssText: ?, id: ?) -> ?","!doc":"<p>Creates a stylesheet from a text blob of rules.\nThese rules will be wrapped in a STYLE tag and appended to the HEAD of the document.</p>\n"},"getRule":{"!type":"fn(selector: ?, refreshCache: ?) -> ?","!doc":"<p>Gets an an individual CSS rule by selector(s)</p>\n"},"getRules":{"!type":"fn(refreshCache: ?) -> ?","!doc":"<p>Gets all css rules for the document</p>\n"},"refreshCache":{"!type":"fn() -> ?","!doc":"<p>Refresh the rule cache if you have dynamically added stylesheets</p>\n"},"removeStyleSheet":{"!type":"fn(id: ?) -> !this","!doc":"<p>Removes a style or link tag by id</p>\n"},"swapStyleSheet":{"!type":"fn(id: ?, url: ?) -> !this","!doc":"<p>Dynamically swaps an existing stylesheet reference for a new one</p>\n"},"updateRule":{"!type":"fn(selector: ?, property: ?, value: ?) -> bool","!doc":"<p>Updates a rule property</p>\n"}},"DelayedTask":{"!doc":"<p>The DelayedTask class provides a convenient way to \"buffer\" the execution of a method,\nperforming setTimeout where a new timeout cancels the old timeout. When called, the\ntask will wait the specified time period before executing. If durng that time period,\nthe task is called again, the original call will be cancelled. This continues so that\nthe function is only called a single time for each iteration.</p>\n\n<p>This method is especially useful for things like detecting whether a user has finished\ntyping in a text field. An example would be performing validation on a keypress. You can\nuse this class to buffer the keypress events for a certain number of milliseconds, and\nperform only if they stop for that amount of time.</p>\n\n<h2>Usage</h2>\n\n<pre><code>var task = new <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a>(function(){\n    alert(<a href=\"#!/api/Ext-method-getDom\" rel=\"Ext-method-getDom\" class=\"docClass\">Ext.getDom</a>('myInputField').value.length);\n});\n\n// Wait 500ms before calling our function. If the user presses another key\n// during that 500ms, it will be cancelled and we'll wait another 500ms.\n<a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>('myInputField').on('keypress', function() {\n    task.<a href=\"#!/api/Ext.util.DelayedTask-method-delay\" rel=\"Ext.util.DelayedTask-method-delay\" class=\"docClass\">delay</a>(500);\n});\n</code></pre>\n\n<p>Note that we are using a DelayedTask here to illustrate a point. The configuration\noption <code>buffer</code> for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener/on</a> will\nalso setup a delayed task for you to buffer events.</p>\n","!type":"fn(fn?: ?, scope?: ?, args?: ?, cancelOnDelay?: ?)","prototype":{"id":{"!type":"number","!doc":"<p>The id of the currently pending invocation.  Will be set to <code>null</code> if there is no\ninvocation pending.</p>\n"},"cancel":{"!type":"fn() -> !this","!doc":"<p>Cancel the last queued timeout</p>\n"},"delay":{"!type":"fn(newDelay: ?, newFn?: ?, newScope?: ?, newArgs?: ?) -> !this","!doc":"<p>By default, cancels any pending timeout and queues a new one.</p>\n\n<p>If the <code>cancelOnDelay</code> parameter was specified as <code>false</code> in the constructor, this does not cancel and\nreschedule, but just updates the call settings, <code>newDelay</code>, <code>newFn</code>, <code>newScope</code> or <code>newArgs</code>, whichever are passed.</p>\n"}}},"Event":{"!doc":"<p>Represents single event type that an Observable object listens to.\nAll actual listeners are tracked inside here.  When the event fires,\nit calls all the registered listener functions.</p>\n","prototype":{"isEvent":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Event, or subclass thereof.</p>\n"}}},"Filter":{"!doc":"<p>Represents a filter that can be applied to a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">MixedCollection</a>. Can either simply\nfilter on a property/value pair or pass in a filter function with custom logic. Filters are always used in the\ncontext of MixedCollections, though <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>s frequently create them when filtering and searching\non their records. Example usage:</p>\n\n<pre><code>//set up a fictional MixedCollection containing a few people to filter on\nvar allNames = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\nallNames.addAll([\n    {id: 1, name: 'Ed',    age: 25},\n    {id: 2, name: 'Jamie', age: 37},\n    {id: 3, name: 'Abe',   age: 32},\n    {id: 4, name: 'Aaron', age: 26},\n    {id: 5, name: 'David', age: 32}\n]);\n\nvar ageFilter = new <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Ext.util.Filter</a>({\n    property: 'age',\n    value   : 32\n});\n\nvar longNameFilter = new <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Ext.util.Filter</a>({\n    filterFn: function(item) {\n        return item.name.length &gt; 4;\n    }\n});\n\n//a new MixedCollection with the 3 names longer than 4 characters\nvar longNames = allNames.filter(longNameFilter);\n\n//a new MixedCollection with the 2 people of age 32:\nvar youngFolk = allNames.filter(ageFilter);\n</code></pre>\n","!type":"fn(config?: ?)","prototype":{"anyMatch":{"!type":"bool","!doc":"<p>True to allow any match - no regex start/end line anchors will be added.</p>\n"},"caseSensitive":{"!type":"bool","!doc":"<p>True to make the regex case sensitive (adds 'i' switch to regex).</p>\n"},"exactMatch":{"!type":"bool","!doc":"<p>True to force exact match (^ and $ characters added to the regex). Ignored if anyMatch is true.</p>\n"},"filterFn":{"!doc":"<p>A custom filter function which is passed each item in the <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a> in turn. Should return\n<code>true</code> to accept each item or <code>false</code> to reject it.</p>\n"},"id":{"!type":"string","!doc":"<p>An identifier by which this Filter is indexed in a <a href=\"#!/api/Ext.data.Store-property-filters\" rel=\"Ext.data.Store-property-filters\" class=\"docClass\">Store's filters collection</a></p>\n\n<p>Identified Filters may be individually removed from a Store's filter set by using <a href=\"#!/api/Ext.data.Store-method-removeFilter\" rel=\"Ext.data.Store-method-removeFilter\" class=\"docClass\">Ext.data.Store.removeFilter</a>.</p>\n\n<p>Anonymous Filters may be removed en masse by passing <code>null</code> to <a href=\"#!/api/Ext.data.Store-method-removeFilter\" rel=\"Ext.data.Store-method-removeFilter\" class=\"docClass\">Ext.data.Store.removeFilter</a>.</p>\n"},"operator":{"!type":"string","!doc":"<p>The operator to use to compare the <a href=\"#!/api/Ext.util.Filter-cfg-property\" rel=\"Ext.util.Filter-cfg-property\" class=\"docClass\">property</a> to this Filter's <a href=\"#!/api/Ext.util.Filter-cfg-value\" rel=\"Ext.util.Filter-cfg-value\" class=\"docClass\">value</a></p>\n\n<p>Possible values are:\n   * &lt;\n   * &lt;=\n   * =\n   * >=\n   * >\n   * !=</p>\n"},"property":{"!type":"string","!doc":"<p>The property to filter on. Required unless a <a href=\"#!/api/Ext.util.Filter-cfg-filterFn\" rel=\"Ext.util.Filter-cfg-filterFn\" class=\"docClass\">filterFn</a> is passed</p>\n"},"root":{"!type":"string","!doc":"<p>Optional root property. This is mostly useful when filtering a Store, in which case we set the root to 'data' to\nmake the filter pull the <a href=\"#!/api/Ext.util.Filter-cfg-property\" rel=\"Ext.util.Filter-cfg-property\" class=\"docClass\">property</a> out of the data object of each item</p>\n"},"value":{"!doc":"<p>The value to filter on. Required unless a <a href=\"#!/api/Ext.util.Filter-cfg-filterFn\" rel=\"Ext.util.Filter-cfg-filterFn\" class=\"docClass\">filterFn</a> is passed.</p>\n"},"disabled":{"!type":"bool","!doc":"<p>Setting this property to <code>true</code> disables this individual Filter so that it no longer contributes to a <a href=\"#!/api/Ext.data.Store-property-filters\" rel=\"Ext.data.Store-property-filters\" class=\"docClass\">Store's filter set</a></p>\n\n<p>When disabled, the next time the store is filtered, the Filter plays no part in filtering and records eliminated by it may rejoin the dataset.</p>\n"},"operatorFns":{},"createFilterFn":{"!type":"fn(filters: ?) -> ?","!doc":"<p>Creates a single filter function which encapsulates the passed Filter array.</p>\n"},"createValueMatcher":{"!type":"fn() -> !this","!doc":"<p>Returns a regular expression based on the given value and matching options</p>\n"},"getRoot":{"!type":"fn(item: ?) -> ?","!doc":"<p>Returns the root property of the given item, based on the configured <a href=\"#!/api/Ext.util.Filter-cfg-root\" rel=\"Ext.util.Filter-cfg-root\" class=\"docClass\">root</a> property</p>\n"},"serialize":{"!type":"fn() -> !this"},"setFilterFn":{"!type":"fn(filterFn: ?) -> !this","!doc":"<p>Changes the filtering function which this Filter uses to choose items to include.</p>\n\n<p>This replaces any configured <a href=\"#!/api/Ext.util.Filter-cfg-filterFn\" rel=\"Ext.util.Filter-cfg-filterFn\" class=\"docClass\">filterFn</a> and overrides any <a href=\"#!/api/Ext.util.Filter-cfg-property\" rel=\"Ext.util.Filter-cfg-property\" class=\"docClass\">property</a> and {@link #cfg-value) settings.</p>\n"},"setValue":{"!type":"fn(value: ?) -> !this","!doc":"<p>Changes the value that this filter tests its configured (@link #cfg-property} with.</p>\n"}}},"Format":{"!doc":"<p>This class is a centralized place for formatting functions. It includes\nfunctions to format various different types of data, such as text, dates and numeric values.</p>\n\n<h2>Localization</h2>\n\n<p>This class contains several options for localization. These can be set once the library has loaded,\nall calls to the functions from that point will use the locale settings that were specified.</p>\n\n<p>Options include:</p>\n\n<ul>\n<li>thousandSeparator</li>\n<li>decimalSeparator</li>\n<li>currenyPrecision</li>\n<li>currencySign</li>\n<li>currencyAtEnd</li>\n</ul>\n\n\n<p>This class also uses the default date format defined here: <a href=\"#!/api/Ext.Date-property-defaultFormat\" rel=\"Ext.Date-property-defaultFormat\" class=\"docClass\">Ext.Date.defaultFormat</a>.</p>\n\n<h2>Using with renderers</h2>\n\n<p>There are two helper functions that return a new function that can be used in conjunction with\ngrid renderers:</p>\n\n<pre><code>columns: [{\n    dataIndex: 'date',\n    renderer: <a href=\"#!/api/Ext.util.Format-method-dateRenderer\" rel=\"Ext.util.Format-method-dateRenderer\" class=\"docClass\">Ext.util.Format.dateRenderer</a>('Y-m-d')\n}, {\n    dataIndex: 'time',\n    renderer: <a href=\"#!/api/Ext.util.Format-method-numberRenderer\" rel=\"Ext.util.Format-method-numberRenderer\" class=\"docClass\">Ext.util.Format.numberRenderer</a>('0.000')\n}]\n</code></pre>\n\n<p>Functions that only take a single argument can also be passed directly:</p>\n\n<pre><code>columns: [{\n    dataIndex: 'cost',\n    renderer: <a href=\"#!/api/Ext.util.Format-method-usMoney\" rel=\"Ext.util.Format-method-usMoney\" class=\"docClass\">Ext.util.Format.usMoney</a>\n}, {\n    dataIndex: 'productCode',\n    renderer: <a href=\"#!/api/Ext.util.Format-method-uppercase\" rel=\"Ext.util.Format-method-uppercase\" class=\"docClass\">Ext.util.Format.uppercase</a>\n}]\n</code></pre>\n\n<h2>Using with XTemplates</h2>\n\n<p>XTemplates can also directly use <a href=\"#!/api/Ext.util.Format\" rel=\"Ext.util.Format\" class=\"docClass\">Ext.util.Format</a> functions:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>([\n    'Date: {startDate:date(\"Y-m-d\")}',\n    'Cost: {cost:usMoney}'\n]);\n</code></pre>\n","currencyAtEnd":{"!type":"bool","!doc":"<p>This may be set to <code>true</code> to make the <a href=\"#!/api/Ext.util.Format-method-currency\" rel=\"Ext.util.Format-method-currency\" class=\"docClass\">currency</a> function\nappend the currency sign to the formatted value.</p>\n\n<p>This may be overridden in a locale file.</p>\n"},"currencyPrecision":{"!type":"number","!doc":"<p>The number of decimal places that the <a href=\"#!/api/Ext.util.Format-method-currency\" rel=\"Ext.util.Format-method-currency\" class=\"docClass\">currency</a> function displays.</p>\n\n<p>This may be overridden in a locale file.</p>\n"},"currencySign":{"!type":"string","!doc":"<p>The currency sign that the <a href=\"#!/api/Ext.util.Format-method-currency\" rel=\"Ext.util.Format-method-currency\" class=\"docClass\">currency</a> function displays.</p>\n\n<p>This may be overridden in a locale file.</p>\n"},"decimalSeparator":{"!type":"string","!doc":"<p>The character that the <a href=\"#!/api/Ext.util.Format-method-number\" rel=\"Ext.util.Format-method-number\" class=\"docClass\">number</a> function uses as a decimal point.</p>\n\n<p>This may be overridden in a locale file.</p>\n"},"thousandSeparator":{"!type":"string","!doc":"<p>The character that the <a href=\"#!/api/Ext.util.Format-method-number\" rel=\"Ext.util.Format-method-number\" class=\"docClass\">number</a> function uses as a thousand separator.</p>\n\n<p>This may be overridden in a locale file.</p>\n"},"attributes":{"!type":"fn(attributes: ?) -> !this","!doc":"<p>Formats an object of name value properties as HTML element attribute values suitable for using when creating textual markup.</p>\n"},"capitalize":{"!type":"fn(string: ?) -> string","!doc":"<p>Alias for <a href=\"#!/api/Ext.String-method-capitalize\" rel=\"Ext.String-method-capitalize\" class=\"docClass\">Ext.String.capitalize</a>.</p>\n"},"currency":{"!type":"fn(value: ?, sign?: ?, decimals?: ?, end?: ?) -> string","!doc":"<p>Format a number as a currency.</p>\n"},"date":{"!type":"fn(value: ?, format?: ?) -> string","!doc":"<p>Formats the passed date using the specified format pattern.</p>\n"},"dateRenderer":{"!type":"fn(format: ?) -> ?","!doc":"<p>Returns a date rendering function that can be reused to apply a date format multiple times efficiently.</p>\n"},"defaultValue":{"!type":"fn(value: ?, defaultValue?: ?) -> string","!doc":"<p>Checks a reference and converts it to the default value if it's empty.</p>\n"},"ellipsis":{"!type":"fn(value: ?, length: ?, word?: ?) -> string","!doc":"<p>Alias for <a href=\"#!/api/Ext.String-method-ellipsis\" rel=\"Ext.String-method-ellipsis\" class=\"docClass\">Ext.String.ellipsis</a>.</p>\n"},"escapeRegex":{"!type":"fn(str: ?) -> string","!doc":"<p>Escapes the passed string for use in a regular expression.</p>\n"},"fileSize":{"!type":"fn(size: ?) -> string","!doc":"<p>Simple format for a file size (xxx bytes, xxx KB, xxx MB).</p>\n"},"format":{"!type":"fn(string: ?, values: ?) -> string","!doc":"<p>Alias for <a href=\"#!/api/Ext.String-method-format\" rel=\"Ext.String-method-format\" class=\"docClass\">Ext.String.format</a>.</p>\n"},"htmlDecode":{"!type":"fn(value: ?) -> string","!doc":"<p>Alias for <a href=\"#!/api/Ext.String-method-htmlDecode\" rel=\"Ext.String-method-htmlDecode\" class=\"docClass\">Ext.String.htmlDecode</a>.</p>\n"},"htmlEncode":{"!type":"fn(value: ?) -> string","!doc":"<p>Alias for <a href=\"#!/api/Ext.String-method-htmlEncode\" rel=\"Ext.String-method-htmlEncode\" class=\"docClass\">Ext.String.htmlEncode</a>.</p>\n"},"leftPad":{"!type":"fn(string: ?, size: ?, character?: ?) -> string","!doc":"<p>Alias for <a href=\"#!/api/Ext.String-method-leftPad\" rel=\"Ext.String-method-leftPad\" class=\"docClass\">Ext.String.leftPad</a>.</p>\n"},"lowercase":{"!type":"fn(value: ?) -> string","!doc":"<p>Converts a string to all lower case letters.</p>\n"},"math":{"!type":"fn() -> ?","!doc":"<p>It does simple math for use in a template, for example:</p>\n\n<pre><code>var tpl = new <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a>('{value} * 10 = {value:math(\"* 10\")}');\n</code></pre>\n"},"nl2br":{"!type":"fn(v: ?) -> string","!doc":"<p>Converts newline characters to the HTML tag <code>&lt;br/&gt;</code></p>\n"},"number":{"!type":"fn(v: ?, format: ?) -> string","!doc":"<p>Formats the passed number according to the passed format string.</p>\n\n<p>The number of digits after the decimal separator character specifies the number of\ndecimal places in the resulting string. The <em>local-specific</em> decimal character is\nused in the result.</p>\n\n<p>The <em>presence</em> of a thousand separator character in the format string specifies that\nthe <em>locale-specific</em> thousand separator (if any) is inserted separating thousand groups.</p>\n\n<p>By default, \",\" is expected as the thousand separator, and \".\" is expected as the decimal separator.</p>\n\n<h2>New to Ext JS 4</h2>\n\n<p>Locale-specific characters are always used in the formatted output when inserting\nthousand and decimal separators.</p>\n\n<p>The format string must specify separator characters according to US/UK conventions (\",\" as the\nthousand separator, and \".\" as the decimal separator)</p>\n\n<p>To allow specification of format strings according to local conventions for separator characters, add\nthe string <code>/i</code> to the end of the format string.</p>\n\n<p>examples (123456.789):</p>\n\n<ul>\n<li><code>0</code> - (123456) show only digits, no precision</li>\n<li><code>0.00</code> - (123456.78) show only digits, 2 precision</li>\n<li><code>0.0000</code> - (123456.7890) show only digits, 4 precision</li>\n<li><code>0,000</code> - (123,456) show comma and digits, no precision</li>\n<li><code>0,000.00</code> - (123,456.78) show comma and digits, 2 precision</li>\n<li><code>0,0.00</code> - (123,456.78) shortcut method, show comma and digits, 2 precision</li>\n<li><code>0.####</code> - (123,456,789) Allow maximum 4 decimal places, but do not right pad with zeroes</li>\n</ul>\n\n"},"numberRenderer":{"!type":"fn(format: ?) -> ?","!doc":"<p>Returns a number rendering function that can be reused to apply a number format multiple\ntimes efficiently.</p>\n"},"parseBox":{"!type":"fn(v: ?) -> ?","!doc":"<p>Parses a number or string representing margin sizes into an object.\nSupports CSS-style margin declarations (e.g. 10, \"10\", \"10 10\", \"10 10 10\" and\n\"10 10 10 10\" are all valid options and would return the same result).</p>\n"},"plural":{"!type":"fn(value: ?, singular: ?, plural?: ?) -> !this","!doc":"<p>Selectively do a plural form of a word based on a numeric value. For example, in a template,\n<code>{commentCount:plural(\"Comment\")}</code>  would result in <code>\"1 Comment\"</code> if commentCount was 1 or\nwould be <code>\"x Comments\"</code> if the value is 0 or greater than 1.</p>\n"},"round":{"!type":"fn(value: ?, precision: ?) -> number","!doc":"<p>Rounds the passed number to the required decimal precision.</p>\n"},"stripScripts":{"!type":"fn(value: ?) -> string","!doc":"<p>Strips all script tags.</p>\n"},"stripTags":{"!type":"fn(value: ?) -> string","!doc":"<p>Strips all HTML tags.</p>\n"},"substr":{"!type":"fn(value: ?, start: ?, length: ?) -> string","!doc":"<p>Returns a substring from within an original string.</p>\n"},"trim":{"!type":"fn(string: ?) -> string","!doc":"<p>Alias for <a href=\"#!/api/Ext.String-method-trim\" rel=\"Ext.String-method-trim\" class=\"docClass\">Ext.String.trim</a>.</p>\n"},"undef":{"!type":"fn(value: ?) -> ?","!doc":"<p>Checks a reference and converts it to empty string if it is undefined.</p>\n"},"uppercase":{"!type":"fn(value: ?) -> string","!doc":"<p>Converts a string to all upper case letters.</p>\n"},"usMoney":{"!type":"fn(value: ?) -> string","!doc":"<p>Format a number as US currency.</p>\n"}},"Grouper":{"!doc":"<p>Represents a single grouper that can be applied to a Store. The grouper works\nin the same fashion as the <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a>.</p>\n","!type":"fn(config: ?)","prototype":{"isGrouper":{"!type":"bool","!doc":"<p>End Definitions</p>\n"},"getGroupString":{"!type":"fn(instance: ?) -> string","!doc":"<p>Returns the value for grouping to be used.</p>\n"}}},"Sorter":{"prototype":{"direction":{"!type":"string","!doc":"<p>The direction to sort by.</p>\n"},"property":{"!type":"string","!doc":"<p>The property to sort by. Required unless <a href=\"#!/api/Ext.util.Sorter-cfg-sorterFn\" rel=\"Ext.util.Sorter-cfg-sorterFn\" class=\"docClass\">sorterFn</a> is provided. The property is extracted from the object\ndirectly and compared for sorting using the built in comparison operators.</p>\n"},"root":{"!type":"string","!doc":"<p>Optional root property. This is mostly useful when sorting a Store, in which case we set the root to 'data' to\nmake the filter pull the <a href=\"#!/api/Ext.util.Sorter-cfg-property\" rel=\"Ext.util.Sorter-cfg-property\" class=\"docClass\">property</a> out of the data object of each item</p>\n"},"sorterFn":{"!doc":"<p>A specific sorter function to execute. Can be passed instead of <a href=\"#!/api/Ext.util.Sorter-cfg-property\" rel=\"Ext.util.Sorter-cfg-property\" class=\"docClass\">property</a>. This sorter function allows\nfor any kind of custom/complex comparisons. The sorterFn receives two arguments, the objects being compared. The\nfunction should return:</p>\n\n<ul>\n<li>-1 if o1 is \"less than\" o2</li>\n<li>0 if o1 is \"equal\" to o2</li>\n<li>1 if o1 is \"greater than\" o2</li>\n</ul>\n\n"},"transform":{"!doc":"<p>A function that will be run on each value before it is compared in the sorter. The function will receive a single\nargument, the value.</p>\n"},"createSortFunction":{"!type":"fn(sorterFn: ?) -> ?","!doc":"<p>Creates and returns a function which sorts an array by the given property and direction</p>\n"},"defaultSorterFn":{"!type":"fn(o1: ?, o2: ?) -> !this","!doc":"<p>Basic default sorter function that just compares the defined property of each object</p>\n"},"getRoot":{"!type":"fn(item: ?) -> ?","!doc":"<p>Returns the root property of the given item, based on the configured <a href=\"#!/api/Ext.util.Sorter-cfg-root\" rel=\"Ext.util.Sorter-cfg-root\" class=\"docClass\">root</a> property</p>\n"},"serialize":{"!type":"fn() -> !this"},"setDirection":{"!type":"fn(direction: ?) -> !this","!doc":"<p>Set the sorting direction for this sorter.</p>\n"},"toggle":{"!type":"fn() -> !this","!doc":"<p>Toggles the sorting direction for this sorter.</p>\n"},"updateSortFunction":{"!type":"fn(fn?: ?) -> !this","!doc":"<p>Update the sort function for this sorter.</p>\n"}},"!doc":"<p>Represents a single sorter that can be applied to a Store. The sorter is used\nto compare two values against each other for the purpose of ordering them. Ordering\nis achieved by specifying either:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.util.Sorter-cfg-property\" rel=\"Ext.util.Sorter-cfg-property\" class=\"docClass\">A sorting property</a></li>\n<li><a href=\"#!/api/Ext.util.Sorter-cfg-sorterFn\" rel=\"Ext.util.Sorter-cfg-sorterFn\" class=\"docClass\">A sorting function</a></li>\n</ul>\n\n\n<p>As a contrived example, we can specify a custom sorter that sorts by rank:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Person', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['name', 'rank']\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'Person',\n    proxy: 'memory',\n    sorters: [{\n        sorterFn: function(o1, o2){\n            var getRank = function(o){\n                var name = o.get('rank');\n                if (name === 'first') {\n                    return 1;\n                } else if (name === 'second') {\n                    return 2;\n                } else {\n                    return 3;\n                }\n            },\n            rank1 = getRank(o1),\n            rank2 = getRank(o2);\n\n            if (rank1 === rank2) {\n                return 0;\n            }\n\n            return rank1 &lt; rank2 ? -1 : 1;\n        }\n    }],\n    data: [{\n        name: 'Person1',\n        rank: 'second'\n    }, {\n        name: 'Person2',\n        rank: 'third'\n    }, {\n        name: 'Person3',\n        rank: 'first'\n    }]\n});\n</code></pre>\n","!type":"fn(config: ?)"},"History":{"!doc":"<p>History management component that allows you to register arbitrary tokens that signify application\nhistory state on navigation actions.  You can then handle the history <a href=\"#!/api/Ext.util.History-event-change\" rel=\"Ext.util.History-event-change\" class=\"docClass\">change</a> event in order\nto reset your application UI to the appropriate state when the user navigates forward or backward through\nthe browser history stack.</p>\n\n<h2>Initializing</h2>\n\n<p>The <a href=\"#!/api/Ext.util.History-method-init\" rel=\"Ext.util.History-method-init\" class=\"docClass\">init</a> method of the History object must be called before using History. This sets up the internal\nstate and must be the first thing called before using History.</p>\n","!type":"fn()","fieldId":{"!type":"string","!doc":"<p>The id of the hidden field required for storing the current history token.</p>\n"},"iframeId":{"!type":"string","!doc":"<p>The id of the iframe required by IE to manage the history stack.</p>\n"},"useTopWindow":{"!type":"bool","!doc":"<p>True to use <code>window.top.location.hash</code> or false to use <code>window.location.hash</code>.</p>\n"},"add":{"!type":"fn(token: ?, preventDuplicates?: ?) -> !this","!doc":"<p>Add a new token to the history stack. This can be any arbitrary value, although it would\ncommonly be the concatenation of a component id and another id marking the specific history\nstate of that component. Example usage:</p>\n\n<pre><code>// Handle tab changes on a TabPanel\ntabPanel.on('tabchange', function(tabPanel, tab){\n     <a href=\"#!/api/Ext.util.History-method-add\" rel=\"Ext.util.History-method-add\" class=\"docClass\">Ext.History.add</a>(tabPanel.id + ':' + tab.id);\n});\n</code></pre>\n"},"back":{"!type":"fn() -> !this","!doc":"<p>Programmatically steps back one step in browser history (equivalent to the user pressing the Back button).</p>\n"},"checkIFrame":{"!type":"fn() -> !this"},"doSave":{"!type":"fn() -> !this"},"forward":{"!type":"fn() -> !this","!doc":"<p>Programmatically steps forward one step in browser history (equivalent to the user pressing the Forward button).</p>\n"},"getHash":{"!type":"fn() -> !this"},"getToken":{"!type":"fn() -> string","!doc":"<p>Retrieves the currently-active history token.</p>\n"},"handleStateChange":{"!type":"fn(token: ?) -> !this"},"init":{"!type":"fn(onReady?: ?, scope?: ?) -> !this","!doc":"<p>Initializes the global History instance.</p>\n"},"setHash":{"!type":"fn(hash: ?) -> !this"},"startUp":{"!type":"fn() -> !this"},"updateIFrame":{"!type":"fn(token: ?) -> !this"},"change":{"!type":"fn(token: ?, eOpts: ?)","!doc":"<p>Fires when navigation back or forwards within the local page's history occurs.</p>\n"},"ready":{"!type":"fn(The: ?, eOpts: ?)","!doc":"<p>Fires when the <a href=\"#!/api/Ext.util.History\" rel=\"Ext.util.History\" class=\"docClass\">Ext.util.History</a> singleton has been initialized and is ready for use.</p>\n"}},"Inflector":{"!doc":"<p>General purpose inflector class that <a href=\"#!/api/Ext.util.Inflector-method-pluralize\" rel=\"Ext.util.Inflector-method-pluralize\" class=\"docClass\">pluralizes</a>, <a href=\"#!/api/Ext.util.Inflector-method-singularize\" rel=\"Ext.util.Inflector-method-singularize\" class=\"docClass\">singularizes</a> and\n<a href=\"#!/api/Ext.util.Inflector-method-ordinalize\" rel=\"Ext.util.Inflector-method-ordinalize\" class=\"docClass\">ordinalizes</a> words. Sample usage:</p>\n\n<pre><code>//turning singular words into plurals\n<a href=\"#!/api/Ext.util.Inflector-method-pluralize\" rel=\"Ext.util.Inflector-method-pluralize\" class=\"docClass\">Ext.util.Inflector.pluralize</a>('word'); //'words'\n<a href=\"#!/api/Ext.util.Inflector-method-pluralize\" rel=\"Ext.util.Inflector-method-pluralize\" class=\"docClass\">Ext.util.Inflector.pluralize</a>('person'); //'people'\n<a href=\"#!/api/Ext.util.Inflector-method-pluralize\" rel=\"Ext.util.Inflector-method-pluralize\" class=\"docClass\">Ext.util.Inflector.pluralize</a>('sheep'); //'sheep'\n\n//turning plurals into singulars\n<a href=\"#!/api/Ext.util.Inflector-method-singularize\" rel=\"Ext.util.Inflector-method-singularize\" class=\"docClass\">Ext.util.Inflector.singularize</a>('words'); //'word'\n<a href=\"#!/api/Ext.util.Inflector-method-singularize\" rel=\"Ext.util.Inflector-method-singularize\" class=\"docClass\">Ext.util.Inflector.singularize</a>('people'); //'person'\n<a href=\"#!/api/Ext.util.Inflector-method-singularize\" rel=\"Ext.util.Inflector-method-singularize\" class=\"docClass\">Ext.util.Inflector.singularize</a>('sheep'); //'sheep'\n\n//ordinalizing numbers\n<a href=\"#!/api/Ext.util.Inflector-method-ordinalize\" rel=\"Ext.util.Inflector-method-ordinalize\" class=\"docClass\">Ext.util.Inflector.ordinalize</a>(11); //\"11th\"\n<a href=\"#!/api/Ext.util.Inflector-method-ordinalize\" rel=\"Ext.util.Inflector-method-ordinalize\" class=\"docClass\">Ext.util.Inflector.ordinalize</a>(21); //\"21st\"\n<a href=\"#!/api/Ext.util.Inflector-method-ordinalize\" rel=\"Ext.util.Inflector-method-ordinalize\" class=\"docClass\">Ext.util.Inflector.ordinalize</a>(1043); //\"1043rd\"\n</code></pre>\n\n<h1>Customization</h1>\n\n<p>The Inflector comes with a default set of US English pluralization rules. These can be augmented with additional\nrules if the default rules do not meet your application's requirements, or swapped out entirely for other languages.\nHere is how we might add a rule that pluralizes \"ox\" to \"oxen\":</p>\n\n<pre><code><a href=\"#!/api/Ext.util.Inflector-method-plural\" rel=\"Ext.util.Inflector-method-plural\" class=\"docClass\">Ext.util.Inflector.plural</a>(/^(ox)$/i, \"$1en\");\n</code></pre>\n\n<p>Each rule consists of two items - a regular expression that matches one or more rules, and a replacement string. In\nthis case, the regular expression will only match the string \"ox\", and will replace that match with \"oxen\". Here's\nhow we could add the inverse rule:</p>\n\n<pre><code><a href=\"#!/api/Ext.util.Inflector-method-singular\" rel=\"Ext.util.Inflector-method-singular\" class=\"docClass\">Ext.util.Inflector.singular</a>(/^(ox)en$/i, \"$1\");\n</code></pre>\n\n<p>Note that the ox/oxen rules are present by default.</p>\n","plurals":{"!doc":"<p>The registered plural tuples. Each item in the array should contain two items - the first must be a regular\nexpression that matchers the singular form of a word, the second must be a String that replaces the matched\npart of the regular expression. This is managed by the <a href=\"#!/api/Ext.util.Inflector-method-plural\" rel=\"Ext.util.Inflector-method-plural\" class=\"docClass\">plural</a> method.</p>\n"},"singulars":{"!doc":"<p>The set of registered singular matchers. Each item in the array should contain two items - the first must be a\nregular expression that matches the plural form of a word, the second must be a String that replaces the\nmatched part of the regular expression. This is managed by the <a href=\"#!/api/Ext.util.Inflector-method-singular\" rel=\"Ext.util.Inflector-method-singular\" class=\"docClass\">singular</a> method.</p>\n"},"uncountable":{"!doc":"<p>The registered uncountable words</p>\n"},"classify":{"!type":"fn(word: ?) -> string","!doc":"<p>Returns the correct <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> name for a given string. Mostly used internally by the data\npackage</p>\n"},"clearPlurals":{"!type":"fn() -> !this","!doc":"<p>Removes all registered pluralization rules</p>\n"},"clearSingulars":{"!type":"fn() -> !this","!doc":"<p>Removes all registered singularization rules</p>\n"},"isTransnumeral":{"!type":"fn(word: ?) -> bool","!doc":"<p>Returns true if the given word is transnumeral (the word is its own singular and plural form - e.g. sheep, fish)</p>\n"},"ordinalize":{"!type":"fn(number: ?) -> string","!doc":"<p>Ordinalizes a given number by adding a prefix such as 'st', 'nd', 'rd' or 'th' based on the last digit of the\nnumber. 21 -> 21st, 22 -> 22nd, 23 -> 23rd, 24 -> 24th etc</p>\n"},"plural":{"!type":"fn(matcher: ?, replacer: ?) -> !this","!doc":"<p>Adds a new pluralization rule to the Inflector. See the intro docs for more information</p>\n"},"pluralize":{"!type":"fn(word: ?) -> string","!doc":"<p>Returns the pluralized form of a word (e.g. <a href=\"#!/api/Ext.util.Inflector-method-pluralize\" rel=\"Ext.util.Inflector-method-pluralize\" class=\"docClass\">Ext.util.Inflector.pluralize</a>('word') returns 'words')</p>\n"},"singular":{"!type":"fn(matcher: ?, replacer: ?) -> !this","!doc":"<p>Adds a new singularization rule to the Inflector. See the intro docs for more information</p>\n"},"singularize":{"!type":"fn(word: ?) -> string","!doc":"<p>Returns the singularized form of a word (e.g. <a href=\"#!/api/Ext.util.Inflector-method-singularize\" rel=\"Ext.util.Inflector-method-singularize\" class=\"docClass\">Ext.util.Inflector.singularize</a>('words') returns 'word')</p>\n"}},"KeyMap":{"!doc":"<p>Handles mapping key events to handling functions for an element or a Component. One KeyMap can be used for multiple\nactions.</p>\n\n<p>A KeyMap must be configured with a <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a> as an event source which may be an Element or a Component.</p>\n\n<p>If the target is an element, then the <code>keydown</code> event will trigger the invocation of <a href=\"#!/api/Ext.util.KeyMap-cfg-binding\" rel=\"Ext.util.KeyMap-cfg-binding\" class=\"docClass\">binding</a>s.</p>\n\n<p>It is possible to configure the KeyMap with a custom <a href=\"#!/api/Ext.util.KeyMap-cfg-eventName\" rel=\"Ext.util.KeyMap-cfg-eventName\" class=\"docClass\">eventName</a> to listen for. This may be useful when the\n<a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a> is a Component.</p>\n\n<p>The KeyMap's event handling requires that the first parameter passed is a key event. So if the Component's event\nsignature is different, specify a <a href=\"#!/api/Ext.util.KeyMap-cfg-processEvent\" rel=\"Ext.util.KeyMap-cfg-processEvent\" class=\"docClass\">processEvent</a> configuration which accepts the event's parameters and\nreturns a key event.</p>\n\n<p>Functions specified in <a href=\"#!/api/Ext.util.KeyMap-cfg-binding\" rel=\"Ext.util.KeyMap-cfg-binding\" class=\"docClass\">binding</a>s are called with this signature : <code>(String key, <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a> e)</code> (if the\nmatch is a multi-key combination the callback will still be called only once). A KeyMap can also handle a string\nrepresentation of keys. By default KeyMap starts enabled.</p>\n\n<p>Usage:</p>\n\n<pre><code>// map one key by key code\nvar map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>({\n    target: \"my-element\",\n    key: 13, // or <a href=\"#!/api/Ext.EventObject-property-ENTER\" rel=\"Ext.EventObject-property-ENTER\" class=\"docClass\">Ext.EventObject.ENTER</a>\n    fn: myHandler,\n    scope: myObject\n});\n\n// map multiple keys to one action by string\nvar map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>({\n    target: \"my-element\",\n    key: \"a\\r\\n\\t\",\n    fn: myHandler,\n    scope: myObject\n});\n\n// map multiple keys to multiple actions by strings and array of codes\nvar map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>({\n    target: \"my-element\",\n    binding: [{\n        key: [10,13],\n        fn: function(){ alert(\"Return was pressed\"); }\n    }, {\n        key: \"abc\",\n        fn: function(){ alert('a, b or c was pressed'); }\n    }, {\n        key: \"\\t\",\n        ctrl:true,\n        shift:true,\n        fn: function(){ alert('Control + shift + tab was pressed.'); }\n    }]\n});\n</code></pre>\n\n<p>Since 4.1.0, KeyMaps can bind to Components and process key-based events fired by Components.</p>\n\n<p>To bind to a Component, use the single parameter form of constructor and include the Component event name\nto listen for, and a <code>processEvent</code> implementation which returns the key event for further processing by\nthe KeyMap:</p>\n\n<pre><code>var map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>({\n    target: myGridView,\n    eventName: 'itemkeydown',\n    processEvent: function(view, record, node, index, event) {\n\n        // Load the event with the extra information needed by the mappings\n        event.view = view;\n        event.store = view.getStore();\n        event.record = record;\n        event.index = index;\n        return event;\n    },\n    binding: {\n        key: <a href=\"#!/api/Ext.EventObject-property-DELETE\" rel=\"Ext.EventObject-property-DELETE\" class=\"docClass\">Ext.EventObject.DELETE</a>,\n        fn: function(keyCode, e) {\n            e.store.remove(e.record);\n\n            // Attempt to select the record that's now in its place\n            e.view.getSelectionModel().select(e.index);\n            e.view.el.focus();\n        }\n    }\n});\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"binding":{"!doc":"<p>Either a single object describing a handling function for s specified key (or set of keys), or\nan array of such objects.</p>\n"},"eventName":{"!type":"string","!doc":"<p>The event to listen for to pick up key events.</p>\n"},"ignoreInputFields":{"!type":"bool","!doc":"<p>Configure this as <code>true</code> if there are any input fields within the <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a>, and this KeyNav\nshould not process events from input fields, (<code>&amp;lt;input&gt;, &amp;lt;textarea&gt; and elements with</code>contentEditable=\"true\"`)</p>\n"},"processEvent":{"!doc":"<p>An optional event processor function which accepts the argument list provided by the\n<a href=\"#!/api/Ext.util.KeyMap-cfg-eventName\" rel=\"Ext.util.KeyMap-cfg-eventName\" class=\"docClass\">configured event</a> of the <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a>, and returns a keyEvent for processing by the KeyMap.</p>\n\n<p>This may be useful when the <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a> is a Component with s complex event signature, where the event is not\nthe first parameter. Extra information from the event arguments may be injected into the event for use by the handler\nfunctions before returning it.</p>\n"},"processEventScope":{"!doc":"<p>The scope (<code>this</code> context) in which the <a href=\"#!/api/Ext.util.KeyMap-cfg-processEvent\" rel=\"Ext.util.KeyMap-cfg-processEvent\" class=\"docClass\">processEvent</a> method is executed.</p>\n"},"target":{"!doc":"<p>The object on which to listen for the event specified by the <a href=\"#!/api/Ext.util.KeyMap-cfg-eventName\" rel=\"Ext.util.KeyMap-cfg-eventName\" class=\"docClass\">eventName</a> config option.</p>\n"},"addBinding":{"!type":"fn(binding: ?) -> !this","!doc":"<p>Add a new binding to this KeyMap.</p>\n\n<p>Usage:</p>\n\n<pre><code>// Create a KeyMap\nvar map = new <a href=\"#!/api/Ext.util.KeyMap\" rel=\"Ext.util.KeyMap\" class=\"docClass\">Ext.util.KeyMap</a>(document, {\n    key: <a href=\"#!/api/Ext.EventObject-property-ENTER\" rel=\"Ext.EventObject-property-ENTER\" class=\"docClass\">Ext.EventObject.ENTER</a>,\n    fn: handleKey,\n    scope: this\n});\n\n//Add a new binding to the existing KeyMap later\nmap.addBinding({\n    key: 'abc',\n    shift: true,\n    fn: handleKey,\n    scope: this\n});\n</code></pre>\n"},"checkModifiers":{"!type":"fn(binding: ?, event: ?) -> bool","!doc":"<p>Check if the modifiers on the event match those on the binding</p>\n"},"destroy":{"!type":"fn(removeTarget: ?) -> !this","!doc":"<p>Destroys the KeyMap instance and removes all handlers.</p>\n"},"disable":{"!type":"fn() -> !this","!doc":"<p>Disable this KeyMap</p>\n"},"enable":{"!type":"fn() -> !this","!doc":"<p>Enables this KeyMap</p>\n"},"handleTargetEvent":{"!type":"fn(event: ?) -> !this","!doc":"<p>Process the <a href=\"#!/api/Ext.util.KeyMap-cfg-eventName\" rel=\"Ext.util.KeyMap-cfg-eventName\" class=\"docClass\">event</a> from the <a href=\"#!/api/Ext.util.KeyMap-cfg-target\" rel=\"Ext.util.KeyMap-cfg-target\" class=\"docClass\">target</a>.</p>\n"},"isEnabled":{"!type":"fn() -> bool","!doc":"<p>Returns true if this KeyMap is enabled</p>\n"},"legacyConstructor":{"!type":"fn(el: ?, binding: ?, eventName?: ?) -> !this","!doc":"<p>Old constructor signature</p>\n"},"on":{"!type":"fn(key: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Shorthand for adding a single key listener.</p>\n"},"processBinding":{"!type":"fn(binding: ?, event: ?) -> !this","!doc":"<p>Process a particular binding and fire the handler if necessary.</p>\n"},"processKeys":{"!type":"fn(keyCode: ?) -> !this"},"removeBinding":{"!type":"fn(binding: ?) -> !this","!doc":"<p>Remove a binding from this KeyMap.</p>\n"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Convenience function for setting disabled/enabled by boolean.</p>\n"},"un":{"!type":"fn(key: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Shorthand for removing a single key listener.</p>\n"}}},"Memento":{"!doc":"<p>This class manages a set of captured properties from an object. These captured properties\ncan later be restored to an object.</p>\n","!type":"fn(target: ?, props: ?)","prototype":{"data":{"!doc":"<p>The collection of captured properties.</p>\n"},"target":{"!doc":"<p>The default target object for capture/restore (passed to the constructor).</p>\n"},"capture":{"!type":"fn(props: ?, target: ?) -> !this","!doc":"<p>Captures the specified properties from the target object in this memento.</p>\n"},"remove":{"!type":"fn(props: ?) -> !this","!doc":"<p>Removes the specified properties from this memento. These properties will not be\nrestored later without re-capturing their values.</p>\n"},"restore":{"!type":"fn(props: ?, clear: ?, target: ?) -> !this","!doc":"<p>Restores the specified properties from this memento to the target object.</p>\n"},"restoreAll":{"!type":"fn(clear: ?, target: ?) -> !this","!doc":"<p>Restores all captured properties in this memento to the target object.</p>\n"}}},"Offset":{"!type":"fn(x: ?, y: ?)","prototype":{"copy":{"!type":"fn() -> !this"},"copyFrom":{"!type":"fn(p: ?) -> !this"},"equals":{"!type":"fn(offset: ?) -> !this"},"isZero":{"!type":"fn() -> !this"},"round":{"!type":"fn(to: ?) -> !this"},"toString":{"!type":"fn() -> !this"},"fromObject":{"!type":"fn(obj: ?) -> !this"}}},"Point":{"!doc":"<p>Represents a 2D point with x and y properties, useful for comparison and instantiation\nfrom an event:</p>\n\n<pre><code>var point = <a href=\"#!/api/Ext.util.Point-static-method-fromEvent\" rel=\"Ext.util.Point-static-method-fromEvent\" class=\"docClass\">Ext.util.Point.fromEvent</a>(e);\n</code></pre>\n","!type":"fn(x: ?, y: ?)","prototype":{"equals":{"!type":"fn(p: ?) -> bool","!doc":"<p>Compare this point and another point</p>\n"},"isContainedBy":{"!type":"fn(region: ?) -> bool","!doc":"<p>Determins whether this Point contained by the passed Region, Component or element.</p>\n"},"isWithin":{"!type":"fn(p: ?, threshold: ?) -> bool","!doc":"<p>Whether the given point is not away from this point within the given threshold amount.</p>\n"},"roundedEquals":{"!type":"fn(p: ?) -> bool","!doc":"<p>Compare this point with another point when the x and y values of both points are rounded. E.g:\n[100.3,199.8] will equals to [100, 200]</p>\n"},"toString":{"!type":"fn() -> string","!doc":"<p>Returns a human-eye-friendly string that represents this point,\nuseful for debugging</p>\n"},"translate":{"!type":"fn(x: ?, y: ?) -> ?","!doc":"<p>Alias for <a href=\"#!/api/Ext.util.Point-method-translateBy\" rel=\"Ext.util.Point-method-translateBy\" class=\"docClass\">translateBy</a></p>\n"},"fromEvent":{"!type":"fn(e: ?) -> ?","!doc":"<p>Returns a new instance of <a href=\"#!/api/Ext.util.Point\" rel=\"Ext.util.Point\" class=\"docClass\">Ext.util.Point</a> base on the pageX / pageY values of the given event</p>\n"}}},"Region":{"prototype":{"adjust":{"!type":"fn(top: ?, right: ?, bottom: ?, left: ?) -> ?","!doc":"<p>Modifies the current region to be adjusted by offsets.</p>\n"},"constrainTo":{"!type":"fn(targetRegion: ?) -> ?","!doc":"<p>Modifies the current region to be constrained to the targetRegion.</p>\n"},"contains":{"!type":"fn(region: ?) -> bool","!doc":"<p>Checks if this region completely contains the region that is passed in.</p>\n"},"copy":{"!type":"fn() -> ?","!doc":"<p>Create a copy of this Region.</p>\n"},"copyFrom":{"!type":"fn(p: ?) -> ?","!doc":"<p>Copy the values of another Region to this Region</p>\n"},"getOutOfBoundOffset":{"!type":"fn(axis?: ?, p?: ?) -> ?","!doc":"<p>Get the offset amount of a point outside the region</p>\n"},"getOutOfBoundOffsetX":{"!type":"fn(p: ?) -> number","!doc":"<p>Get the offset amount on the x-axis</p>\n"},"getOutOfBoundOffsetY":{"!type":"fn(p: ?) -> number","!doc":"<p>Get the offset amount on the y-axis</p>\n"},"getSize":{"!type":"fn() -> ?","!doc":"<p>Get the width / height of this region</p>\n"},"intersect":{"!type":"fn(region: ?) -> ?","!doc":"<p>Checks if this region intersects the region passed in.</p>\n"},"isOutOfBound":{"!type":"fn(axis?: ?, p?: ?) -> bool","!doc":"<p>Check whether the point / offset is out of bound</p>\n"},"isOutOfBoundX":{"!type":"fn(p: ?) -> bool","!doc":"<p>Check whether the offset is out of bound in the x-axis</p>\n"},"isOutOfBoundY":{"!type":"fn(p: ?) -> bool","!doc":"<p>Check whether the offset is out of bound in the y-axis</p>\n"},"restrict":{"!type":"fn(axis?: ?, p?: ?, factor?: ?) -> ?","!doc":"<p>Restrict a point within the region by a certain factor.</p>\n"},"restrictX":{"!type":"fn(p: ?, factor?: ?) -> number","!doc":"<p>Restrict an offset within the region by a certain factor, on the x-axis</p>\n"},"restrictY":{"!type":"fn(p: ?, factor?: ?) -> number","!doc":"<p>Restrict an offset within the region by a certain factor, on the y-axis</p>\n"},"round":{"!type":"fn() -> ?","!doc":"<p>Round all the properties of this region</p>\n"},"translateBy":{"!type":"fn(x: ?, y: ?) -> ?","!doc":"<p>Translate this region by the given offset amount</p>\n"},"union":{"!type":"fn(region: ?) -> ?","!doc":"<p>Returns the smallest region that contains the current AND targetRegion.</p>\n"},"equals":{"!type":"fn(region: ?) -> bool","!doc":"<p>Check whether this region is equivalent to the given region</p>\n"},"toString":{"!type":"fn() -> string","!doc":"<p>Dump this to an eye-friendly string, great for debugging</p>\n"},"from":{"!type":"fn(o: ?) -> ?","!doc":"<p>Creates a Region from a \"box\" Object which contains four numeric properties <code>top</code>, <code>right</code>, <code>bottom</code> and <code>left</code>.</p>\n"},"getRegion":{"!type":"fn(el: ?) -> ?","!doc":"<p>Retrieves an <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a> for a particular element.</p>\n"}},"!doc":"<p>This class represents a rectangular region in X,Y space, and performs geometric\ntransformations or tests upon the region.</p>\n\n<p>This class may be used to compare the document regions occupied by elements.</p>\n","!type":"fn(top: ?, right: ?, bottom: ?, left: ?)"},"ProtoElement":{"!doc":"<p>Manages certain element-like data prior to rendering. These values are passed\non to the render process. This is currently used to manage the \"class\" and \"style\" attributes\nof a component's primary el as well as the bodyEl of panels. This allows things like\naddBodyCls in Panel to share logic with addCls in AbstractComponent.</p>\n","prototype":{"clsProp":{"!type":"string","!doc":"<p>The property name for the className on the data object passed to <a href=\"#!/api/Ext.util.ProtoElement-method-writeTo\" rel=\"Ext.util.ProtoElement-method-writeTo\" class=\"docClass\">writeTo</a>.</p>\n"},"removedProp":{"!type":"string","!doc":"<p>The property name for the removed classes on the data object passed to <a href=\"#!/api/Ext.util.ProtoElement-method-writeTo\" rel=\"Ext.util.ProtoElement-method-writeTo\" class=\"docClass\">writeTo</a>.</p>\n"},"styleIsText":{"!type":"bool","!doc":"<p>True if the style must be converted to text during <a href=\"#!/api/Ext.util.ProtoElement-method-writeTo\" rel=\"Ext.util.ProtoElement-method-writeTo\" class=\"docClass\">writeTo</a>. When used to\npopulate tpl data, this will be true. When used to populate <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">Ext.DomHelper</a>\nspecs, this will be false (the default).</p>\n"},"styleProp":{"!type":"string","!doc":"<p>The property name for the style on the data object passed to <a href=\"#!/api/Ext.util.ProtoElement-method-writeTo\" rel=\"Ext.util.ProtoElement-method-writeTo\" class=\"docClass\">writeTo</a>.</p>\n"},"addCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Adds class to the element.</p>\n"},"flush":{"!type":"fn() -> !this","!doc":"<p>Indicates that the current state of the object has been flushed to the DOM, so we need\nto track any subsequent changes</p>\n"},"hasCls":{"!type":"fn(cls: ?) -> bool","!doc":"<p>True if the element has given class.</p>\n"},"removeCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Removes class from the element.</p>\n"},"setStyle":{"!type":"fn(prop: ?, value?: ?) -> ?","!doc":"<p>Adds styles to the element.</p>\n"},"writeTo":{"!type":"fn(to: ?) -> ?","!doc":"<p>Writes style and class properties to given object.\nStyles will be written to <a href=\"#!/api/Ext.util.ProtoElement-property-styleProp\" rel=\"Ext.util.ProtoElement-property-styleProp\" class=\"docClass\">styleProp</a> and class names to <a href=\"#!/api/Ext.util.ProtoElement-property-clsProp\" rel=\"Ext.util.ProtoElement-property-clsProp\" class=\"docClass\">clsProp</a>.</p>\n"}}},"Queue":{"!doc":"<p>An internal Queue class.</p>\n","!type":"fn()","prototype":{"add":{"!type":"fn(obj: ?) -> !this"},"clear":{"!type":"fn() -> !this","!doc":"<p>Removes all items from the collection.</p>\n"},"contains":{"!type":"fn(obj: ?) -> !this"},"getCount":{"!type":"fn() -> number","!doc":"<p>Returns the number of items in the collection.</p>\n"},"getKey":{"!type":"fn(obj: ?) -> !this"},"remove":{"!type":"fn(obj: ?) -> ?","!doc":"<p>Remove an item from the collection.</p>\n"}}},"TaskManager":{"!doc":"<p>A static <a href=\"#!/api/Ext.util.TaskRunner\" rel=\"Ext.util.TaskRunner\" class=\"docClass\">Ext.util.TaskRunner</a> instance that can be used to start and stop\narbitrary tasks. See <a href=\"#!/api/Ext.util.TaskRunner\" rel=\"Ext.util.TaskRunner\" class=\"docClass\">Ext.util.TaskRunner</a> for supported methods and task\nconfig properties.</p>\n\n<p>   // Start a simple clock task that updates a div once per second\n   var task = {\n      run: function(){\n          <a href=\"#!/api/Ext-method-fly\" rel=\"Ext-method-fly\" class=\"docClass\">Ext.fly</a>('clock').update(new Date().format('g:i:s A'));\n      },\n      interval: 1000 //1 second\n   }</p>\n\n<p>   <a href=\"#!/api/Ext.util.TaskManager-method-start\" rel=\"Ext.util.TaskManager-method-start\" class=\"docClass\">Ext.TaskManager.start</a>(task);</p>\n\n<p>See the <a href=\"#!/api/Ext.util.TaskManager-method-start\" rel=\"Ext.util.TaskManager-method-start\" class=\"docClass\">start</a> method for details about how to configure a task object.</p>\n","!type":"fn(interval?: ?)"},"TaskRunner":{"fireIdleEvent":{"!type":"bool","!doc":"<p>This may be configured <code>false</code> to inhibit firing of the <a href=\"#!/api/Ext.EventManager-property-idleEvent\" rel=\"Ext.EventManager-property-idleEvent\" class=\"docClass\">idle event</a> after task invocation.</p>\n"},"interval":{"!type":"number","!doc":"<p>The timer resolution.</p>\n"},"firing":{"!type":"bool","!doc":"<hr />\n"},"nextExpires":{"!type":"number"},"timerId":{"!doc":"<p>The id of the current timer.</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroys this instance, stopping all tasks that are currently running.</p>\n"},"newTask":{"!type":"fn(config: ?) -> !this","!doc":"<p>Creates a new <a href=\"#!/api/Ext.util.TaskRunner.Task\" rel=\"Ext.util.TaskRunner.Task\" class=\"docClass\">Task</a> instance. These instances can\nbe easily started and stopped.</p>\n"},"onTick":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"start":{"!type":"fn(task: ?) -> ?","!doc":"<p>Starts a new task.</p>\n\n<p>Before each invocation, Ext injects the property <code>taskRunCount</code> into the task object\nso that calculations based on the repeat count can be performed.</p>\n\n<p>The returned task will contain a <code>destroy</code> method that can be used to destroy the\ntask and cancel further calls. This is equivalent to the <a href=\"#!/api/Ext.util.TaskRunner-method-stop\" rel=\"Ext.util.TaskRunner-method-stop\" class=\"docClass\">stop</a> method.</p>\n"},"startTimer":{"!type":"fn(timeout: ?, now: ?) -> !this","!doc":"<p>private</p>\n"},"stop":{"!type":"fn(task: ?) -> ?","!doc":"<p>Stops an existing running task.</p>\n"},"stopAll":{"!type":"fn() -> !this","!doc":"<p>Stops all tasks that are currently running.</p>\n"},"!doc":"<p>Provides the ability to execute one or more arbitrary tasks in a asynchronous manner.\nGenerally, you can use the singleton <a href=\"#!/api/Ext.util.TaskManager\" rel=\"Ext.util.TaskManager\" class=\"docClass\">Ext.TaskManager</a> instead, but if needed,\nyou can create separate instances of TaskRunner. Any number of separate tasks can be\nstarted at any time and will run independently of each other.</p>\n\n<p>Example usage:</p>\n\n<pre><code> // Start a simple clock task that updates a div once per second\n var updateClock = function () {\n     <a href=\"#!/api/Ext-method-fly\" rel=\"Ext-method-fly\" class=\"docClass\">Ext.fly</a>('clock').update(new Date().format('g:i:s A'));\n }\n\n var runner = new <a href=\"#!/api/Ext.util.TaskRunner\" rel=\"Ext.util.TaskRunner\" class=\"docClass\">Ext.util.TaskRunner</a>();\n var task = runner.start({\n     run: updateClock,\n     interval: 1000\n }\n</code></pre>\n\n<p>The equivalent using TaskManager:</p>\n\n<pre><code> var task = <a href=\"#!/api/Ext.util.TaskManager-method-start\" rel=\"Ext.util.TaskManager-method-start\" class=\"docClass\">Ext.TaskManager.start</a>({\n     run: updateClock,\n     interval: 1000\n });\n</code></pre>\n\n<p>To end a running task:</p>\n\n<pre><code> task.destroy();\n</code></pre>\n\n<p>If a task needs to be started and stopped repeated over time, you can create a\n<a href=\"#!/api/Ext.util.TaskRunner.Task\" rel=\"Ext.util.TaskRunner.Task\" class=\"docClass\">Task</a> instance.</p>\n\n<pre><code> var task = runner.newTask({\n     run: function () {\n         // useful code\n     },\n     interval: 1000\n });\n\n task.start();\n\n // ...\n\n task.stop();\n\n // ...\n\n task.start();\n</code></pre>\n\n<p>A re-usable, one-shot task can be managed similar to the above:</p>\n\n<pre><code> var task = runner.newTask({\n     run: function () {\n         // useful code to run once\n     },\n     repeat: 1\n });\n\n task.start();\n\n // ...\n\n task.start();\n</code></pre>\n\n<p>See the <a href=\"#!/api/Ext.util.TaskRunner-method-start\" rel=\"Ext.util.TaskRunner-method-start\" class=\"docClass\">start</a> method for details about how to configure a task object.</p>\n\n<p>Also see <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a>.</p>\n","!type":"fn(interval?: ?)","prototype":{"fireIdleEvent":{"!type":"bool","!doc":"<p>This may be configured <code>false</code> to inhibit firing of the <a href=\"#!/api/Ext.EventManager-property-idleEvent\" rel=\"Ext.EventManager-property-idleEvent\" class=\"docClass\">idle event</a> after task invocation.</p>\n"},"interval":{"!type":"number","!doc":"<p>The timer resolution.</p>\n"},"firing":{"!type":"bool","!doc":"<hr />\n"},"nextExpires":{"!type":"number"},"timerId":{"!doc":"<p>The id of the current timer.</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroys this instance, stopping all tasks that are currently running.</p>\n"},"newTask":{"!type":"fn(config: ?) -> !this","!doc":"<p>Creates a new <a href=\"#!/api/Ext.util.TaskRunner.Task\" rel=\"Ext.util.TaskRunner.Task\" class=\"docClass\">Task</a> instance. These instances can\nbe easily started and stopped.</p>\n"},"onTick":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"start":{"!type":"fn(task: ?) -> ?","!doc":"<p>Starts a new task.</p>\n\n<p>Before each invocation, Ext injects the property <code>taskRunCount</code> into the task object\nso that calculations based on the repeat count can be performed.</p>\n\n<p>The returned task will contain a <code>destroy</code> method that can be used to destroy the\ntask and cancel further calls. This is equivalent to the <a href=\"#!/api/Ext.util.TaskRunner-method-stop\" rel=\"Ext.util.TaskRunner-method-stop\" class=\"docClass\">stop</a> method.</p>\n"},"startTimer":{"!type":"fn(timeout: ?, now: ?) -> !this","!doc":"<p>private</p>\n"},"stop":{"!type":"fn(task: ?) -> ?","!doc":"<p>Stops an existing running task.</p>\n"},"stopAll":{"!type":"fn() -> !this","!doc":"<p>Stops all tasks that are currently running.</p>\n"}},"Task":{"!doc":"<p>Instances of this class are created by <a href=\"#!/api/Ext.util.TaskRunner-method-newTask\" rel=\"Ext.util.TaskRunner-method-newTask\" class=\"docClass\">Ext.util.TaskRunner.newTask</a> method.</p>\n\n<p>For details on config properties, see <a href=\"#!/api/Ext.util.TaskRunner-method-start\" rel=\"Ext.util.TaskRunner-method-start\" class=\"docClass\">Ext.util.TaskRunner.start</a>.</p>\n","prototype":{"fireOnStart":{"!type":"bool","!doc":"<p>Override default behavior</p>\n"},"stopped":{"!type":"bool","!doc":"<p>This flag is set to <code>true</code> by <a href=\"#!/api/Ext.util.TaskRunner.Task-method-stop\" rel=\"Ext.util.TaskRunner.Task-method-stop\" class=\"docClass\">stop</a>.</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroys this instance, stopping this task's execution.</p>\n"},"restart":{"!type":"fn(interval?: ?) -> !this","!doc":"<p>Restarts this task, clearing it duration, expiration and run count.</p>\n"},"start":{"!type":"fn(interval?: ?) -> !this","!doc":"<p>Starts this task if it is not already started.</p>\n"},"stop":{"!type":"fn() -> !this","!doc":"<p>Stops this task.</p>\n"}}}},"TextMetrics":{"!doc":"<p>Provides precise pixel measurements for blocks of text so that you can determine exactly how high and\nwide, in pixels, a given block of text will be. Note that when measuring text, it should be plain text and\nshould not contain any HTML, otherwise it may not be measured correctly.</p>\n\n<p>The measurement works by copying the relevant CSS styles that can affect the font related display,\nthen checking the size of an element that is auto-sized. Note that if the text is multi-lined, you must\nprovide a <strong>fixed width</strong> when doing the measurement.</p>\n\n<p>If multiple measurements are being done on the same element, you create a new instance to initialize\nto avoid the overhead of copying the styles to the element repeatedly.</p>\n","!type":"fn(bindTo: ?, fixedWidth?: ?)","prototype":{"shared":{},"bind":{"!type":"fn(el: ?) -> !this","!doc":"<p>Binds this TextMetrics instance to a new element</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroy the TextMetrics instance created by <a href=\"#!/api/Ext.util.TextMetrics-static-method-measure\" rel=\"Ext.util.TextMetrics-static-method-measure\" class=\"docClass\">measure</a>.</p>\n"},"getHeight":{"!type":"fn(text: ?) -> number","!doc":"<p>Returns the measured height of the specified text</p>\n"},"getSize":{"!type":"fn(text: ?) -> ?","!doc":"<p>Returns the size of the specified text based on the internal element's style and width properties</p>\n"},"getWidth":{"!type":"fn(text: ?) -> number","!doc":"<p>Returns the measured width of the specified text</p>\n"},"setFixedWidth":{"!type":"fn(width: ?) -> !this","!doc":"<p>Sets a fixed width on the internal measurement element.  If the text will be multiline, you have\nto set a fixed width in order to accurately measure the text height.</p>\n"},"measure":{"!type":"fn(el: ?, text: ?, fixedWidth?: ?) -> ?","!doc":"<p>Measures the size of the specified text</p>\n"}}}},"state":{"Stateful":{"prototype":{"saveDelay":{"!type":"number","!doc":"<p>A buffer to be applied if many state events are fired within a short period.</p>\n"},"stateEvents":{"!doc":"<p>An array of events that, when fired, should trigger this object to\nsave its state. Defaults to none. <code>stateEvents</code> may be any type\nof event supported by this object, including browser or custom events\n(e.g., <tt>['click', 'customerchange']</tt>).</p>\n\n\n<p>See <code><a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring object state.</p>\n\n"},"stateId":{"!type":"string","!doc":"<p>The unique id for this object to use for state management purposes.</p>\n\n<p>See <a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a> for an explanation of saving and restoring state.</p>\n\n"},"stateful":{"!type":"bool","!doc":"<p>A flag which causes the object to attempt to restore the state of\ninternal properties from a saved state on startup. The object must have\na <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a> for state to be managed.</p>\n\n<p>Auto-generated ids are not guaranteed to be stable across page loads and\ncannot be relied upon to save and restore the same state for a object.</p>\n\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n\n<p>To set the state provider for the current page:</p>\n\n<p>   <a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n       expires: new Date(new Date().getTime()+(1000<em>60</em>60<em>24</em>7)), //7 days from now\n   }));</p>\n\n<p>A stateful object attempts to save state when one of the events\nlisted in the <a href=\"#!/api/Ext.state.Stateful-cfg-stateEvents\" rel=\"Ext.state.Stateful-cfg-stateEvents\" class=\"docClass\">stateEvents</a> configuration fires.</p>\n\n<p>To save state, a stateful object first serializes its state by\ncalling <em><a href=\"#!/api/Ext.state.Stateful-method-getState\" rel=\"Ext.state.Stateful-method-getState\" class=\"docClass\">getState</a></em>.</p>\n\n<p>The Component base class implements <a href=\"#!/api/Ext.state.Stateful-method-getState\" rel=\"Ext.state.Stateful-method-getState\" class=\"docClass\">getState</a> to save its width and height within the state\nonly if they were initially configured, and have changed from the configured value.</p>\n\n<p>The Panel class saves its collapsed state in addition to that.</p>\n\n<p>The Grid class saves its column state in addition to its superclass state.</p>\n\n<p>If there is more application state to be save, the developer must provide an implementation which\nfirst calls the superclass method to inherit the above behaviour, and then injects new properties\ninto the returned object.</p>\n\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a>.</p>\n\n<p>During construction, a stateful object attempts to <em>restore</em> its state by calling\n<a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a></p>\n\n<p>The resulting object is passed to <a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a>*. The default implementation of\n<a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a> simply copies properties into the object, but a developer may\noverride this to support restoration of more complex application state.</p>\n\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.state.Stateful-event-beforestaterestore\" rel=\"Ext.state.Stateful-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.state.Stateful-event-staterestore\" rel=\"Ext.state.Stateful-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.state.Stateful-event-beforestatesave\" rel=\"Ext.state.Stateful-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.state.Stateful-event-statesave\" rel=\"Ext.state.Stateful-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n"},"addStateEvents":{"!type":"fn(events: ?) -> !this","!doc":"<p>Add events that will trigger the state to be saved. If the first argument is an\narray, each element of that array is the name of a state event. Otherwise, each\nargument passed to this method is the name of a state event.</p>\n"},"applyState":{"!type":"fn(state: ?) -> !this","!doc":"<p>Applies the state to the object. This should be overridden in subclasses to do\nmore complex state operations. By default it applies the state properties onto\nthe current object.</p>\n"},"getStateId":{"!type":"fn() -> string","!doc":"<p>Gets the state id for this object.</p>\n"},"initState":{"!type":"fn() -> !this","!doc":"<p>Initializes the state of the object upon construction.</p>\n"},"onStateChange":{"!type":"fn() -> !this","!doc":"<p>This method is called when any of the <a href=\"#!/api/Ext.state.Stateful-cfg-stateEvents\" rel=\"Ext.state.Stateful-cfg-stateEvents\" class=\"docClass\">stateEvents</a> are fired.</p>\n"},"savePropToState":{"!type":"fn(propName: ?, state: ?, stateName?: ?) -> bool","!doc":"<p>Conditionally saves a single property from this object to the given state object.\nThe idea is to only save state which has changed from the initial state so that\ncurrent software settings do not override future software settings. Only those\nvalues that are user-changed state should be saved.</p>\n"},"savePropsToState":{"!type":"fn(propNames: ?, state: ?) -> ?","!doc":"<p>Gathers additional named properties of the instance and adds their current values\nto the passed state object.</p>\n"},"saveState":{"!type":"fn() -> !this","!doc":"<p>Saves the state of the object to the persistence store.</p>\n"},"beforestaterestore":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires before the state of the object is restored. Return false from an event handler to stop the restore.</p>\n"},"beforestatesave":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires before the state of the object is saved to the configured state provider. Return false to stop the save.</p>\n"},"staterestore":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires after the state of the object is restored.</p>\n"},"statesave":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires after the state of the object is saved to the configured state provider.</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Destroys this stateful object.</p>\n"},"getState":{"!type":"fn() -> ?","!doc":"<p>Gets the current state of the object. By default this function returns null,\nit should be overridden in subclasses to implement methods for getting the state.</p>\n"}},"saveDelay":{"!type":"number","!doc":"<p>A buffer to be applied if many state events are fired within a short period.</p>\n"},"stateEvents":{"!doc":"<p>An array of events that, when fired, should trigger this object to\nsave its state. Defaults to none. <code>stateEvents</code> may be any type\nof event supported by this object, including browser or custom events\n(e.g., <tt>['click', 'customerchange']</tt>).</p>\n\n\n<p>See <code><a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring object state.</p>\n\n"},"stateId":{"!type":"string","!doc":"<p>The unique id for this object to use for state management purposes.</p>\n\n<p>See <a href=\"#!/api/Ext.state.Stateful-cfg-stateful\" rel=\"Ext.state.Stateful-cfg-stateful\" class=\"docClass\">stateful</a> for an explanation of saving and restoring state.</p>\n\n"},"stateful":{"!type":"bool","!doc":"<p>A flag which causes the object to attempt to restore the state of\ninternal properties from a saved state on startup. The object must have\na <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a> for state to be managed.</p>\n\n<p>Auto-generated ids are not guaranteed to be stable across page loads and\ncannot be relied upon to save and restore the same state for a object.</p>\n\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n\n<p>To set the state provider for the current page:</p>\n\n<p>   <a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n       expires: new Date(new Date().getTime()+(1000<em>60</em>60<em>24</em>7)), //7 days from now\n   }));</p>\n\n<p>A stateful object attempts to save state when one of the events\nlisted in the <a href=\"#!/api/Ext.state.Stateful-cfg-stateEvents\" rel=\"Ext.state.Stateful-cfg-stateEvents\" class=\"docClass\">stateEvents</a> configuration fires.</p>\n\n<p>To save state, a stateful object first serializes its state by\ncalling <em><a href=\"#!/api/Ext.state.Stateful-method-getState\" rel=\"Ext.state.Stateful-method-getState\" class=\"docClass\">getState</a></em>.</p>\n\n<p>The Component base class implements <a href=\"#!/api/Ext.state.Stateful-method-getState\" rel=\"Ext.state.Stateful-method-getState\" class=\"docClass\">getState</a> to save its width and height within the state\nonly if they were initially configured, and have changed from the configured value.</p>\n\n<p>The Panel class saves its collapsed state in addition to that.</p>\n\n<p>The Grid class saves its column state in addition to its superclass state.</p>\n\n<p>If there is more application state to be save, the developer must provide an implementation which\nfirst calls the superclass method to inherit the above behaviour, and then injects new properties\ninto the returned object.</p>\n\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a>.</p>\n\n<p>During construction, a stateful object attempts to <em>restore</em> its state by calling\n<a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the <a href=\"#!/api/Ext.state.Stateful-cfg-stateId\" rel=\"Ext.state.Stateful-cfg-stateId\" class=\"docClass\">stateId</a></p>\n\n<p>The resulting object is passed to <a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a>*. The default implementation of\n<a href=\"#!/api/Ext.state.Stateful-method-applyState\" rel=\"Ext.state.Stateful-method-applyState\" class=\"docClass\">applyState</a> simply copies properties into the object, but a developer may\noverride this to support restoration of more complex application state.</p>\n\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.state.Stateful-event-beforestaterestore\" rel=\"Ext.state.Stateful-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.state.Stateful-event-staterestore\" rel=\"Ext.state.Stateful-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.state.Stateful-event-beforestatesave\" rel=\"Ext.state.Stateful-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.state.Stateful-event-statesave\" rel=\"Ext.state.Stateful-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n"},"addStateEvents":{"!type":"fn(events: ?) -> !this","!doc":"<p>Add events that will trigger the state to be saved. If the first argument is an\narray, each element of that array is the name of a state event. Otherwise, each\nargument passed to this method is the name of a state event.</p>\n"},"getStateId":{"!type":"fn() -> string","!doc":"<p>Gets the state id for this object.</p>\n"},"initState":{"!type":"fn() -> !this","!doc":"<p>Initializes the state of the object upon construction.</p>\n"},"onStateChange":{"!type":"fn() -> !this","!doc":"<p>This method is called when any of the <a href=\"#!/api/Ext.state.Stateful-cfg-stateEvents\" rel=\"Ext.state.Stateful-cfg-stateEvents\" class=\"docClass\">stateEvents</a> are fired.</p>\n"},"savePropToState":{"!type":"fn(propName: ?, state: ?, stateName?: ?) -> bool","!doc":"<p>Conditionally saves a single property from this object to the given state object.\nThe idea is to only save state which has changed from the initial state so that\ncurrent software settings do not override future software settings. Only those\nvalues that are user-changed state should be saved.</p>\n"},"savePropsToState":{"!type":"fn(propNames: ?, state: ?) -> ?","!doc":"<p>Gathers additional named properties of the instance and adds their current values\nto the passed state object.</p>\n"},"saveState":{"!type":"fn() -> !this","!doc":"<p>Saves the state of the object to the persistence store.</p>\n"},"beforestaterestore":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires before the state of the object is restored. Return false from an event handler to stop the restore.</p>\n"},"beforestatesave":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires before the state of the object is saved to the configured state provider. Return false to stop the save.</p>\n"},"staterestore":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires after the state of the object is restored.</p>\n"},"statesave":{"!type":"fn(this: ?, state: ?, eOpts: ?)","!doc":"<p>Fires after the state of the object is saved to the configured state provider.</p>\n"},"!doc":"<p>A mixin for being able to save the state of an object to an underlying\n<a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a>.</p>\n","!type":"fn(config: ?)"},"CookieProvider":{"!doc":"<p>A Provider implementation which saves and retrieves state via cookies. The CookieProvider supports the usual cookie\noptions, such as:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.state.CookieProvider-cfg-path\" rel=\"Ext.state.CookieProvider-cfg-path\" class=\"docClass\">path</a></li>\n<li><a href=\"#!/api/Ext.state.CookieProvider-cfg-expires\" rel=\"Ext.state.CookieProvider-cfg-expires\" class=\"docClass\">expires</a></li>\n<li><a href=\"#!/api/Ext.state.CookieProvider-cfg-domain\" rel=\"Ext.state.CookieProvider-cfg-domain\" class=\"docClass\">domain</a></li>\n<li><a href=\"#!/api/Ext.state.CookieProvider-cfg-secure\" rel=\"Ext.state.CookieProvider-cfg-secure\" class=\"docClass\">secure</a></li>\n</ul>\n\n\n<p>Example:</p>\n\n<pre><code>var cp = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>', {\n    path: \"/cgi-bin/\",\n    expires: new Date(new Date().getTime()+(1000*60*60*24*30)), //30 days\n    domain: \"sencha.com\"\n});\n\n<a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(cp);\n</code></pre>\n","!type":"fn(config?: ?)","prototype":{"domain":{"!type":"string","!doc":"<p>The domain to save the cookie for. Note that you cannot specify a different domain than your page is on, but you can\nspecify a sub-domain, or simply the domain itself like 'sencha.com' to include all sub-domains if you need to access\ncookies across different sub-domains. Defaults to null which uses the same domain the page is running on including\nthe 'www' like 'www.sencha.com'.</p>\n"},"expires":{"!doc":"<p>The cookie expiration date. Defaults to 7 days from now.</p>\n"},"path":{"!type":"string","!doc":"<p>The path for which the cookie is active. Defaults to root '/' which makes it active for all pages in the site.</p>\n"},"secure":{"!type":"bool","!doc":"<p>True if the site is using SSL</p>\n"},"clear":{"!type":"fn(name: ?) -> !this","!doc":"<p>private</p>\n"},"clearCookie":{"!type":"fn(name: ?) -> !this","!doc":"<p>private</p>\n"},"readCookies":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"set":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>private</p>\n"},"setCookie":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>private</p>\n"}}},"Provider":{"prototype":{"prefix":{"!type":"string","!doc":"<p>A string to prefix to items stored in the underlying state store.\nDefaults to <tt>'ext-'</tt></p>\n"},"decodeValue":{"!type":"fn(value: ?) -> ?","!doc":"<p>Decodes a string previously encoded with <a href=\"#!/api/Ext.state.Provider-method-encodeValue\" rel=\"Ext.state.Provider-method-encodeValue\" class=\"docClass\">encodeValue</a>.</p>\n"},"encodeValue":{"!type":"fn(value: ?) -> string","!doc":"<p>Encodes a value including type information.  Decode with <a href=\"#!/api/Ext.state.Provider-method-decodeValue\" rel=\"Ext.state.Provider-method-decodeValue\" class=\"docClass\">decodeValue</a>.</p>\n"},"get":{"!type":"fn(name: ?, defaultValue: ?) -> ?","!doc":"<p>Returns the current value for a key</p>\n"},"statechange":{"!type":"fn(this: ?, key: ?, value: ?, eOpts: ?)","!doc":"<p>Fires when a state change occurs.</p>\n"},"clear":{"!type":"fn(name: ?) -> !this","!doc":"<p>Clears a value from the state</p>\n"},"set":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>Sets the value for a key</p>\n"}},"!doc":"<p>Abstract base class for state provider implementations. The provider is responsible\nfor setting values  and extracting values to/from the underlying storage source. The \nstorage source can vary and the details should be implemented in a subclass. For example\na provider could use a server side database or the browser localstorage where supported.</p>\n\n\n\n\n<p>This class provides methods for encoding and decoding <b>typed</b> variables including \ndates and defines the Provider interface. By default these methods put the value and the\ntype information into a delimited string that can be stored. These should be overridden in \na subclass if you want to change the format of the encoded value and subsequent decoding.</p>\n\n","!type":"fn(config: ?)"},"LocalStorageProvider":{"!doc":"<p>A Provider implementation which saves and retrieves state via the HTML5 localStorage object.\nIf the browser does not support local storage, there will be no attempt to read the state.\nBefore creating this class, a check should be made to <a href=\"#!/api/Ext.supports-property-LocalStorage\" rel=\"Ext.supports-property-LocalStorage\" class=\"docClass\">Ext.supports.LocalStorage</a>.</p>\n","!type":"fn()","prototype":{"clear":{"!type":"fn(name: ?) -> !this","!doc":"<p>private</p>\n"},"getStorageObject":{"!type":"fn() -> !this"},"readLocalStorage":{"!type":"fn() -> !this"},"set":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>Sets the value for a key</p>\n"}}},"Manager":{"!doc":"<p>This is the global state manager. By default all components that are \"state aware\" check this class\nfor state information if you don't pass them a custom state provider. In order for this class\nto be useful, it must be initialized with a provider when your application initializes. Example usage:</p>\n\n<pre><code>// in your initialization function\ninit : function(){\n   <a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>());\n}\n </code></pre>\n\n\n<p>This class passes on calls from components to the underlying <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> so that\nthere is a common interface that can be used without needing to refer to a specific provider instance\nin every component.</p>\n","!type":"fn()","clear":{"!type":"fn(name: ?) -> !this","!doc":"<p>Clears a value from the state</p>\n"},"get":{"!type":"fn(name: ?, defaultValue: ?) -> ?","!doc":"<p>Returns the current value for a key</p>\n"},"getProvider":{"!type":"fn() -> ?","!doc":"<p>Gets the currently configured state provider</p>\n"},"set":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>Sets the value for a key</p>\n"},"setProvider":{"!type":"fn(stateProvider: ?) -> !this","!doc":"<p>Configures the default state provider for your application</p>\n"}}},"Base":{"prototype":{"$className":{"!type":"string"},"configMap":{},"initConfigList":{},"initConfigMap":{},"isInstance":{"!type":"bool"},"self":{"!doc":"<p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); // dependent on 'this'\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n"},"$onExtended":{},"callOverridden":{"!type":"fn(args: ?) -> ?","!doc":"<p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n"},"callParent":{"!type":"fn(args: ?) -> ?","!doc":"<p>Call the \"parent\" method of the current method. That is the method previously\noverridden by derivation or by an override (see <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>).</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Base', {\n     constructor: function (x) {\n         this.x = x;\n     },\n\n     statics: {\n         method: function (x) {\n             return x;\n         }\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived', {\n     extend: 'My.Base',\n\n     constructor: function () {\n         this.callParent([21]);\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // alerts 21\n</code></pre>\n\n<p>This can be used with an override as follows:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.DerivedOverride', {\n     override: 'My.Derived',\n\n     constructor: function (x) {\n         this.callParent([x*2]); // calls original My.Derived constructor\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // now alerts 42\n</code></pre>\n\n<p>This also works with static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2', {\n     extend: 'My.Base',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Base.method\n         }\n     }\n });\n\n alert(My.Base.method(10);     // alerts 10\n alert(My.Derived2.method(10); // alerts 20\n</code></pre>\n\n<p>Lastly, it also works with overridden static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2Override', {\n     override: 'My.Derived2',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Derived2.method\n         }\n     }\n });\n\n alert(My.Derived2.method(10); // now alerts 40\n</code></pre>\n\n<p>To override a method and replace it and also call the superclass method, use\n<a href=\"#!/api/Ext.Base-method-callSuper\" rel=\"Ext.Base-method-callSuper\" class=\"docClass\">callSuper</a>. This is often done to patch a method to fix a bug.</p>\n"},"callSuper":{"!type":"fn(args: ?) -> ?","!doc":"<p>This method is used by an override to call the superclass method but bypass any\noverridden method. This is often done to \"patch\" a method that contains a bug\nbut for whatever reason cannot be fixed directly.</p>\n\n<p>Consider:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.some.Class', {\n     method: function () {\n         console.log('Good');\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.some.DerivedClass', {\n     method: function () {\n         console.log('Bad');\n\n         // ... logic but with a bug ...\n\n         this.callParent();\n     }\n });\n</code></pre>\n\n<p>To patch the bug in <code>DerivedClass.method</code>, the typical solution is to create an\noverride:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('App.paches.DerivedClass', {\n     override: 'Ext.some.DerivedClass',\n\n     method: function () {\n         console.log('Fixed');\n\n         // ... logic but with bug fixed ...\n\n         this.callSuper();\n     }\n });\n</code></pre>\n\n<p>The patch method cannot use <code>callParent</code> to call the superclass <code>method</code> since\nthat would call the overridden method containing the bug. In other words, the\nabove patch would only produce \"Fixed\" then \"Good\" in the console log, whereas,\nusing <code>callParent</code> would produce \"Fixed\" then \"Bad\" then \"Good\".</p>\n"},"configClass":{"!type":"fn() -> !this"},"getConfig":{"!type":"fn(name: ?) -> !this"},"getInitialConfig":{"!type":"fn(name?: ?) -> ?","!doc":"<p>Returns the initial configuration passed to constructor when instantiating\nthis class.</p>\n"},"hasConfig":{"!type":"fn(config: ?) -> !this"},"initConfig":{"!type":"fn(config: ?) -> ?","!doc":"<p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n"},"onConfigUpdate":{"!type":"fn(names: ?, callback: ?, scope: ?) -> !this"},"setConfig":{"!type":"fn(config: ?, applyIfNotSet: ?) -> ?"},"statics":{"!type":"fn() -> ?","!doc":"<p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n"},"addConfig":{"!type":"fn(config: ?) -> !this"},"addInheritableStatics":{"!type":"fn(members: ?) -> !this"},"addMember":{"!type":"fn(name: ?, member: ?) -> !this"},"addMembers":{"!type":"fn(members: ?) -> !this","!doc":"<p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.addMembers({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n"},"addStatics":{"!type":"fn(members: ?) -> ?","!doc":"<p>Add / override static properties of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n"},"addXtype":{"!type":"fn(xtype: ?) -> !this"},"borrow":{"!type":"fn(fromClass: ?, members: ?) -> ?","!doc":"<p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n"},"create":{"!type":"fn() -> ?","!doc":"<p>Create a new instance of this Class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n"},"createAlias":{"!type":"fn(alias: ?, origin: ?) -> !this","!doc":"<p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n"},"extend":{"!type":"fn(config: ?) -> !this"},"getName":{"!type":"fn() -> string","!doc":"<p>Get the current class' name in string format.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n"},"implement":{"!type":"fn() -> !this","!doc":"<p>Adds members to class.</p>\n"},"mixin":{"!type":"fn(name: ?, mixinClass: ?) -> !this","!doc":"<p>Used internally by the mixins pre-processor</p>\n"},"onExtended":{"!type":"fn(fn: ?, scope: ?) -> !this"},"override":{"!type":"fn(members: ?) -> ?","!doc":"<p>Override members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a>.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n\n<p>As of 4.1, direct use of this method is deprecated. Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>\ninstead:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.CatOverride', {\n    override: 'My.Cat',\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n    }\n});\n</code></pre>\n\n<p>The above accomplishes the same result but can be managed by the <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a>\nwhich can properly order the override and its target class and the build process\ncan determine whether the override is needed based on the required state of the\ntarget class (My.Cat).</p>\n"},"triggerExtended":{"!type":"fn() -> !this"},"destroy":{"!type":"fn() -> !this"}},"$className":{"!type":"string"},"configMap":{},"initConfigList":{},"initConfigMap":{},"isInstance":{"!type":"bool"},"self":{"!doc":"<p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); // dependent on 'this'\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n"},"$onExtended":{},"callOverridden":{"!type":"fn(args: ?) -> ?","!doc":"<p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n"},"callParent":{"!type":"fn(args: ?) -> ?","!doc":"<p>Call the \"parent\" method of the current method. That is the method previously\noverridden by derivation or by an override (see <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>).</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Base', {\n     constructor: function (x) {\n         this.x = x;\n     },\n\n     statics: {\n         method: function (x) {\n             return x;\n         }\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived', {\n     extend: 'My.Base',\n\n     constructor: function () {\n         this.callParent([21]);\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // alerts 21\n</code></pre>\n\n<p>This can be used with an override as follows:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.DerivedOverride', {\n     override: 'My.Derived',\n\n     constructor: function (x) {\n         this.callParent([x*2]); // calls original My.Derived constructor\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // now alerts 42\n</code></pre>\n\n<p>This also works with static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2', {\n     extend: 'My.Base',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Base.method\n         }\n     }\n });\n\n alert(My.Base.method(10);     // alerts 10\n alert(My.Derived2.method(10); // alerts 20\n</code></pre>\n\n<p>Lastly, it also works with overridden static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2Override', {\n     override: 'My.Derived2',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Derived2.method\n         }\n     }\n });\n\n alert(My.Derived2.method(10); // now alerts 40\n</code></pre>\n\n<p>To override a method and replace it and also call the superclass method, use\n<a href=\"#!/api/Ext.Base-method-callSuper\" rel=\"Ext.Base-method-callSuper\" class=\"docClass\">callSuper</a>. This is often done to patch a method to fix a bug.</p>\n"},"callSuper":{"!type":"fn(args: ?) -> ?","!doc":"<p>This method is used by an override to call the superclass method but bypass any\noverridden method. This is often done to \"patch\" a method that contains a bug\nbut for whatever reason cannot be fixed directly.</p>\n\n<p>Consider:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.some.Class', {\n     method: function () {\n         console.log('Good');\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Ext.some.DerivedClass', {\n     method: function () {\n         console.log('Bad');\n\n         // ... logic but with a bug ...\n\n         this.callParent();\n     }\n });\n</code></pre>\n\n<p>To patch the bug in <code>DerivedClass.method</code>, the typical solution is to create an\noverride:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('App.paches.DerivedClass', {\n     override: 'Ext.some.DerivedClass',\n\n     method: function () {\n         console.log('Fixed');\n\n         // ... logic but with bug fixed ...\n\n         this.callSuper();\n     }\n });\n</code></pre>\n\n<p>The patch method cannot use <code>callParent</code> to call the superclass <code>method</code> since\nthat would call the overridden method containing the bug. In other words, the\nabove patch would only produce \"Fixed\" then \"Good\" in the console log, whereas,\nusing <code>callParent</code> would produce \"Fixed\" then \"Bad\" then \"Good\".</p>\n"},"configClass":{"!type":"fn() -> !this"},"destroy":{"!type":"fn() -> !this"},"getConfig":{"!type":"fn(name: ?) -> !this"},"getInitialConfig":{"!type":"fn(name?: ?) -> ?","!doc":"<p>Returns the initial configuration passed to constructor when instantiating\nthis class.</p>\n"},"hasConfig":{"!type":"fn(config: ?) -> !this"},"initConfig":{"!type":"fn(config: ?) -> ?","!doc":"<p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n"},"onConfigUpdate":{"!type":"fn(names: ?, callback: ?, scope: ?) -> !this"},"setConfig":{"!type":"fn(config: ?, applyIfNotSet: ?) -> ?"},"statics":{"!type":"fn() -> ?","!doc":"<p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n"},"addConfig":{"!type":"fn(config: ?) -> !this"},"addInheritableStatics":{"!type":"fn(members: ?) -> !this"},"addMember":{"!type":"fn(name: ?, member: ?) -> !this"},"addMembers":{"!type":"fn(members: ?) -> !this","!doc":"<p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.addMembers({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n"},"addStatics":{"!type":"fn(members: ?) -> ?","!doc":"<p>Add / override static properties of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n"},"addXtype":{"!type":"fn(xtype: ?) -> !this"},"borrow":{"!type":"fn(fromClass: ?, members: ?) -> ?","!doc":"<p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n"},"create":{"!type":"fn() -> ?","!doc":"<p>Create a new instance of this Class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n"},"createAlias":{"!type":"fn(alias: ?, origin: ?) -> !this","!doc":"<p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n"},"extend":{"!type":"fn(config: ?) -> !this"},"getName":{"!type":"fn() -> string","!doc":"<p>Get the current class' name in string format.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n"},"implement":{"!type":"fn() -> !this","!doc":"<p>Adds members to class.</p>\n"},"mixin":{"!type":"fn(name: ?, mixinClass: ?) -> !this","!doc":"<p>Used internally by the mixins pre-processor</p>\n"},"onExtended":{"!type":"fn(fn: ?, scope: ?) -> !this"},"override":{"!type":"fn(members: ?) -> ?","!doc":"<p>Override members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a>.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n\n<p>As of 4.1, direct use of this method is deprecated. Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>\ninstead:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.CatOverride', {\n    override: 'My.Cat',\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n    }\n});\n</code></pre>\n\n<p>The above accomplishes the same result but can be managed by the <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a>\nwhich can properly order the override and its target class and the build process\ncan determine whether the override is needed based on the required state of the\ntarget class (My.Cat).</p>\n"},"triggerExtended":{"!type":"fn() -> !this"},"!doc":"<p>The root of all classes created with <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>.</p>\n\n<p><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a> is the building block of all Ext classes. All classes in Ext inherit from <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a>.\nAll prototype and static members of this class are inherited by all other classes.</p>\n"},"AbstractManager":{"!doc":"<p>Base Manager class</p>\n","!type":"fn(config: ?)","prototype":{"all":{"!doc":"<p>Contains all of the items currently managed</p>\n"},"typeName":{"!type":"string","!doc":"<p>End Definitions</p>\n"},"create":{"!type":"fn(config: ?, defaultType: ?) -> ?","!doc":"<p>Creates and returns an instance of whatever this manager manages, based on the supplied type and\nconfig object.</p>\n"},"each":{"!type":"fn(fn: ?, scope: ?) -> !this","!doc":"<p>Executes the specified function once for each item in the collection.</p>\n"},"get":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns an item by id.\nFor additional details see <a href=\"#!/api/Ext.util.HashMap-method-get\" rel=\"Ext.util.HashMap-method-get\" class=\"docClass\">Ext.util.HashMap.get</a>.</p>\n"},"getCount":{"!type":"fn() -> number","!doc":"<p>Gets the number of items in the collection.</p>\n"},"isRegistered":{"!type":"fn(type: ?) -> bool","!doc":"<p>Checks if an item type is registered.</p>\n"},"onAvailable":{"!type":"fn(id: ?, fn: ?, scope: ?) -> !this","!doc":"<p>Registers a function that will be called when an item with the specified id is added to the manager.\nThis will happen on instantiation.</p>\n"},"register":{"!type":"fn(item: ?) -> !this","!doc":"<p>Registers an item to be managed</p>\n"},"registerType":{"!type":"fn(type: ?, cls: ?) -> !this","!doc":"<p>Registers a new item constructor, keyed by a type key.</p>\n"},"unregister":{"!type":"fn(item: ?) -> !this","!doc":"<p>Unregisters an item by removing it from this manager</p>\n"}},"all":{"!doc":"<p>Contains all of the items currently managed</p>\n"},"each":{"!type":"fn(fn: ?, scope: ?) -> !this","!doc":"<p>Executes the specified function once for each item in the collection.</p>\n"},"get":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns an item by id.\nFor additional details see <a href=\"#!/api/Ext.util.HashMap-method-get\" rel=\"Ext.util.HashMap-method-get\" class=\"docClass\">Ext.util.HashMap.get</a>.</p>\n"},"getCount":{"!type":"fn() -> number","!doc":"<p>Gets the number of items in the collection.</p>\n"},"isRegistered":{"!type":"fn(type: ?) -> bool","!doc":"<p>Checks if an item type is registered.</p>\n"},"onAvailable":{"!type":"fn(id: ?, fn: ?, scope: ?) -> !this","!doc":"<p>Registers a function that will be called when an item with the specified id is added to the manager.\nThis will happen on instantiation.</p>\n"},"register":{"!type":"fn(item: ?) -> !this","!doc":"<p>Registers an item to be managed</p>\n"},"unregister":{"!type":"fn(item: ?) -> !this","!doc":"<p>Unregisters an item by removing it from this manager</p>\n"},"registerType":{"!type":"fn(type: ?, cls: ?) -> !this","!doc":"<p>Registers a new item constructor, keyed by a type key.</p>\n"}},"AbstractPlugin":{"!doc":"<p>The AbstractPlugin class is the base class from which user-implemented plugins should inherit.</p>\n\n<p>This class defines the essential API of plugins as used by Components by defining the following methods:</p>\n\n<ul>\n<li><p><code>init</code> : The plugin initialization method which the owning Component calls at Component initialization time.</p>\n\n<p>The Component passes itself as the sole parameter.</p>\n\n<p>Subclasses should set up bidirectional links between the plugin and its client Component here.</p></li>\n<li><p><code>destroy</code> : The plugin cleanup method which the owning Component calls at Component destruction time.</p>\n\n<p>Use this method to break links between the plugin and the Component and to free any allocated resources.</p></li>\n<li><p><code>enable</code> : The base implementation just sets the plugin's <code>disabled</code> flag to <code>false</code></p></li>\n<li><p><code>disable</code> : The base implementation just sets the plugin's <code>disabled</code> flag to <code>true</code></p></li>\n</ul>\n\n","!type":"fn(config?: ?)","prototype":{"pluginId":{"!type":"string","!doc":"<p>A name for the plugin that can be set at creation time to then retrieve the plugin\nthrough <a href=\"#!/api/Ext.AbstractComponent-method-getPlugin\" rel=\"Ext.AbstractComponent-method-getPlugin\" class=\"docClass\">getPlugin</a> method.  For example:</p>\n\n<pre><code>var grid = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Ext.grid.Panel</a>', {\n    plugins: [{\n        ptype: 'cellediting',\n        clicksToEdit: 2,\n        pluginId: 'cellplugin'\n    }]\n});\n\n// later on:\nvar plugin = grid.getPlugin('cellplugin');\n</code></pre>\n"},"disabled":{"!type":"bool"},"isPlugin":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Plugin, or subclass thereof.</p>\n"},"clonePlugin":{"!type":"fn(overrideCfg?: ?) -> !this","!doc":"<p>Creates clone of the plugin.</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>The destroy method is invoked by the owning Component at the time the Component is being destroyed.</p>\n\n<p>The supplied implementation is empty. Subclasses should perform plugin cleanup in their own implementation of\nthis method.</p>\n"},"disable":{"!type":"fn() -> !this","!doc":"<p>The base implementation just sets the plugin's <code>disabled</code> flag to <code>true</code></p>\n\n<p>Plugin subclasses which need more complex processing may implement an overriding implementation.</p>\n"},"enable":{"!type":"fn() -> !this","!doc":"<p>The base implementation just sets the plugin's <code>disabled</code> flag to <code>false</code></p>\n\n<p>Plugin subclasses which need more complex processing may implement an overriding implementation.</p>\n"},"getCmp":{"!type":"fn() -> ?","!doc":"<p>Returns the component to which this plugin is attached.</p>\n"},"init":{"!type":"fn(client: ?) -> !this","!doc":"<p>The init method is invoked after initComponent method has been run for the client Component.</p>\n\n<p>The supplied implementation is empty. Subclasses should perform plugin initialization, and set up bidirectional\nlinks between the plugin and its client Component in their own implementation of this method.</p>\n"},"onClassExtended":{"!type":"fn(cls: ?, data: ?, hooks: ?) -> !this","!doc":"<p>Private.\nInject a ptype property so that AbstractComponent.findPlugin(ptype) works.</p>\n"},"setCmp":{"!type":"fn(cmp: ?) -> !this","!doc":"<p>Sets the component to which this plugin is attached.</p>\n"}}},"Action":{"!doc":"<p>An Action is a piece of reusable functionality that can be abstracted out of any particular component so that it\ncan be usefully shared among multiple components.  Actions let you share handlers, configuration options and UI\nupdates across any components that support the Action interface (primarily <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Ext.toolbar.Toolbar</a>,\n<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a> and <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a> components).</p>\n\n<p>Use a single Action instance as the config object for any number of UI Components which share the same configuration. The\nAction not only supplies the configuration, but allows all Components based upon it to have a common set of methods\ncalled at once through a single call to the Action.</p>\n\n<p>Any Component that is to be configured with an Action must also support\nthe following methods:</p>\n\n<ul>\n<li>setText(string)</li>\n<li>setIconCls(string)</li>\n<li>setDisabled(boolean)</li>\n<li>setVisible(boolean)</li>\n<li>setHandler(function)</li>\n</ul>\n\n\n<p>This allows the Action to control its associated Components.</p>\n\n<p>Example usage:</p>\n\n<pre><code>// Define the shared Action.  Each Component below will have the same\n// display text and icon, and will display the same message on click.\nvar action = new <a href=\"#!/api/Ext.Action\" rel=\"Ext.Action\" class=\"docClass\">Ext.Action</a>({\n    <a href=\"#!/api/Ext.Action-cfg-text\" rel=\"Ext.Action-cfg-text\" class=\"docClass\">text</a>: 'Do something',\n    <a href=\"#!/api/Ext.Action-cfg-handler\" rel=\"Ext.Action-cfg-handler\" class=\"docClass\">handler</a>: function(){\n        <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Click', 'You did something.');\n    },\n    <a href=\"#!/api/Ext.Action-cfg-iconCls\" rel=\"Ext.Action-cfg-iconCls\" class=\"docClass\">iconCls</a>: 'do-something',\n    <a href=\"#!/api/Ext.Action-cfg-itemId\" rel=\"Ext.Action-cfg-itemId\" class=\"docClass\">itemId</a>: 'myAction'\n});\n\nvar panel = new <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>({\n    title: 'Actions',\n    width: 500,\n    height: 300,\n    tbar: [\n        // Add the Action directly to a toolbar as a menu button\n        action,\n        {\n            text: 'Action Menu',\n            // Add the Action to a menu as a text item\n            menu: [action]\n        }\n    ],\n    items: [\n        // Add the Action to the panel body as a standard button\n        new <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>(action)\n    ],\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>()\n});\n\n// Change the text for all components using the Action\naction.setText('Something else');\n\n// Reference an Action through a container using the itemId\nvar btn = panel.getComponent('myAction');\nvar aRef = btn.baseAction;\naRef.setText('New text');\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"disabled":{"!type":"bool","!doc":"<p>True to disable all components configured by this Action, false to enable them.</p>\n"},"handler":{"!doc":"<p>The function that will be invoked by each component tied to this Action\nwhen the component's primary event is triggered.</p>\n"},"hidden":{"!type":"bool","!doc":"<p>True to hide all components configured by this Action, false to show them.</p>\n"},"iconCls":{"!type":"string","!doc":"<p>The CSS class selector that specifies a background image to be used as the header icon for\nall components configured by this Action.</p>\n\n<p>An example of specifying a custom icon class would be something like:</p>\n\n<pre><code>// specify the property in the config for the class:\n     ...\n     iconCls: 'do-something'\n\n// css class that specifies background image to be used as the icon image:\n.do-something { background-image: url(../images/my-icon.gif) 0 6px no-repeat !important; }\n</code></pre>\n"},"itemId":{"!type":"string","!doc":"<p>See <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.<a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a>.</p>\n"},"scope":{"!doc":"<p>The scope (this reference) in which the <a href=\"#!/api/Ext.Action-cfg-handler\" rel=\"Ext.Action-cfg-handler\" class=\"docClass\">handler</a> is executed.\nDefaults to the browser window.</p>\n"},"text":{"!type":"string","!doc":"<p>The text to set for all components configured by this Action.</p>\n"},"isAction":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Action, or subclass thereof.</p>\n"},"addComponent":{"!type":"fn(comp: ?) -> !this"},"callEach":{"!type":"fn(fnName: ?, args: ?) -> !this"},"disable":{"!type":"fn() -> !this","!doc":"<p>Disables all components configured by this Action.</p>\n"},"each":{"!type":"fn(fn: ?, scope: ?) -> !this","!doc":"<p>Executes the specified function once for each Component currently tied to this Action.  The function passed\nin should accept a single argument that will be an object that supports the basic Action config/method interface.</p>\n"},"enable":{"!type":"fn() -> !this","!doc":"<p>Enables all components configured by this Action.</p>\n"},"execute":{"!type":"fn(args: ?) -> !this","!doc":"<p>Executes this Action manually using the handler function specified in the original config object\nor the handler function set with <a href=\"#!/api/Ext.Action-method-setHandler\" rel=\"Ext.Action-method-setHandler\" class=\"docClass\">setHandler</a>.  Any arguments passed to this\nfunction will be passed on to the handler function.</p>\n"},"getIconCls":{"!type":"fn() -> !this","!doc":"<p>Gets the icon CSS class currently used by all components configured by this Action.</p>\n"},"getText":{"!type":"fn() -> !this","!doc":"<p>Gets the text currently displayed by all components configured by this Action.</p>\n"},"hide":{"!type":"fn() -> !this","!doc":"<p>Hides all components configured by this Action.</p>\n"},"isDisabled":{"!type":"fn() -> !this","!doc":"<p>Returns true if the components using this Action are currently disabled, else returns false.</p>\n"},"isHidden":{"!type":"fn() -> !this","!doc":"<p>Returns true if the components configured by this Action are currently hidden, else returns false.</p>\n"},"removeComponent":{"!type":"fn(comp: ?) -> !this"},"setDisabled":{"!type":"fn(disabled: ?) -> !this","!doc":"<p>Sets the disabled state of all components configured by this Action.  Shortcut method\nfor <a href=\"#!/api/Ext.Action-method-enable\" rel=\"Ext.Action-method-enable\" class=\"docClass\">enable</a> and <a href=\"#!/api/Ext.Action-method-disable\" rel=\"Ext.Action-method-disable\" class=\"docClass\">disable</a>.</p>\n"},"setHandler":{"!type":"fn(fn: ?, scope: ?) -> !this","!doc":"<p>Sets the function that will be called by each Component using this action when its primary event is triggered.</p>\n"},"setHidden":{"!type":"fn(hidden: ?) -> !this","!doc":"<p>Sets the hidden state of all components configured by this Action.  Shortcut method\nfor <code><a href=\"#!/api/Ext.Action-method-hide\" rel=\"Ext.Action-method-hide\" class=\"docClass\">hide</a></code> and <code><a href=\"#!/api/Ext.Action-method-show\" rel=\"Ext.Action-method-show\" class=\"docClass\">show</a></code>.</p>\n"},"setIconCls":{"!type":"fn(cls: ?) -> !this","!doc":"<p>Sets the icon CSS class for all components configured by this Action.  The class should supply\na background image that will be used as the icon image.</p>\n"},"setText":{"!type":"fn(text: ?) -> !this","!doc":"<p>Sets the text to be displayed by all components configured by this Action.</p>\n"},"show":{"!type":"fn() -> !this","!doc":"<p>Shows all components configured by this Action.</p>\n"}}},"Ajax":{"!doc":"<p>A singleton instance of an <a href=\"#!/api/Ext.data.Connection\" rel=\"Ext.data.Connection\" class=\"docClass\">Ext.data.Connection</a>. This class\nis used to communicate with your server side code. It can be used as follows:</p>\n\n<pre><code><a href=\"#!/api/Ext.Ajax-method-request\" rel=\"Ext.Ajax-method-request\" class=\"docClass\">Ext.Ajax.request</a>({\n    url: 'page.php',\n    params: {\n        id: 1\n    },\n    success: function(response){\n        var text = response.responseText;\n        // process server response here\n    }\n});\n</code></pre>\n\n<p>Default options for all requests can be set by changing a property on the <a href=\"#!/api/Ext.Ajax\" rel=\"Ext.Ajax\" class=\"docClass\">Ext.Ajax</a> class:</p>\n\n<pre><code><a href=\"#!/api/Ext.Ajax-property-timeout\" rel=\"Ext.Ajax-property-timeout\" class=\"docClass\">Ext.Ajax.timeout</a> = 60000; // 60 seconds\n</code></pre>\n\n<p>Any options specified in the request method for the Ajax request will override any\ndefaults set on the <a href=\"#!/api/Ext.Ajax\" rel=\"Ext.Ajax\" class=\"docClass\">Ext.Ajax</a> class. In the code sample below, the timeout for the\nrequest will be 60 seconds.</p>\n\n<pre><code><a href=\"#!/api/Ext.Ajax-property-timeout\" rel=\"Ext.Ajax-property-timeout\" class=\"docClass\">Ext.Ajax.timeout</a> = 120000; // 120 seconds\n<a href=\"#!/api/Ext.Ajax-method-request\" rel=\"Ext.Ajax-method-request\" class=\"docClass\">Ext.Ajax.request</a>({\n    url: 'page.aspx',\n    timeout: 60000\n});\n</code></pre>\n\n<p>In general, this class will be used for all Ajax requests in your application.\nThe main reason for creating a separate <a href=\"#!/api/Ext.data.Connection\" rel=\"Ext.data.Connection\" class=\"docClass\">Ext.data.Connection</a> is for a\nseries of requests that share common settings that are different to all other\nrequests in the application.</p>\n","!type":"fn(config: ?)","autoAbort":{"!type":"bool","!doc":"<p>Whether a new request should abort any pending requests.</p>\n"},"defaultHeaders":{"!doc":"<p>An object containing request headers which are added to each request made by this object.</p>\n"},"disableCaching":{"!type":"bool","!doc":"<p>True to add a unique cache-buster param to GET requests. Defaults to true.</p>\n"},"extraParams":{"!doc":"<p>An object containing properties which are used as extra parameters to each request made\nby this object. Session information and other data that you need\nto pass with each request are commonly put here.</p>\n"},"method":{"!type":"string","!doc":"<p>The default HTTP method to be used for requests. Note that this is case-sensitive and\nshould be all caps (if not set but params are present will use\n<tt>\"POST\"</tt>, otherwise will use <tt>\"GET\"</tt>.)</p>\n"},"timeout":{"!type":"number","!doc":"<p>The timeout in milliseconds to be used for requests. Defaults to 30000.</p>\n"},"url":{"!type":"string","!doc":"<p>The default URL to be used for requests to the server.\nIf the server receives all requests through one URL, setting this once is easier than\nentering it on every request.</p>\n"}},"data":{"Connection":{"binary":{"!type":"bool","!doc":"<p>True if the response should be treated as binary data.  If true, the binary\ndata will be accessible as a \"responseBytes\" property on the response object.</p>\n"},"cors":{"!type":"bool","!doc":"<p>True to enable CORS support on the XHR object. Currently the only effect of this option\nis to use the XDomainRequest object instead of XMLHttpRequest if the browser is IE8 or above.</p>\n"},"disableCachingParam":{"!type":"string","!doc":"<p>Change the parameter which is sent went disabling caching through a cache buster.</p>\n"},"withCredentials":{"!type":"bool","!doc":"<p>True to set <code>withCredentials = true</code> on the XHR object</p>\n"},"async":{"!type":"bool"},"defaultPostHeader":{"!type":"string"},"defaultXdrContentType":{"!type":"string"},"defaultXhrHeader":{"!type":"string"},"getXhrInstance":{"!doc":"<p>Creates the appropriate XHR transport for this browser.</p>\n"},"isXdr":{"!type":"bool"},"password":{"!type":"string"},"useDefaultXhrHeader":{"!type":"bool"},"username":{"!type":"string"},"abort":{"!type":"fn(request?: ?) -> !this","!doc":"<p>Aborts an active request.</p>\n"},"abortAll":{"!type":"fn() -> !this","!doc":"<p>Aborts all active requests</p>\n"},"cleanup":{"!type":"fn(request: ?) -> !this","!doc":"<p>Cleans up any left over information from the request</p>\n"},"clearTimeout":{"!type":"fn(request: ?) -> !this","!doc":"<p>Clears the timeout on the request</p>\n"},"createException":{"!type":"fn(request: ?) -> !this","!doc":"<p>Creates the exception object</p>\n"},"createResponse":{"!type":"fn(request: ?) -> !this","!doc":"<p>Creates the response object</p>\n"},"getByteArray":{"!type":"fn(xhr: ?) -> ?","!doc":"<p>Gets binary data from the xhr response object and returns it as a byte array</p>\n"},"getForm":{"!type":"fn(options: ?) -> ?","!doc":"<p>Gets the form object from options.</p>\n"},"getLatest":{"!type":"fn() -> ?","!doc":"<p>Gets the most recent request</p>\n"},"getXdrInstance":{"!type":"fn() -> !this","!doc":"<p>Creates the appropriate XDR transport for this browser.\n- IE 7 and below don't support CORS\n- IE 8 and 9 support CORS with native XDomainRequest object\n- IE 10 (and above?) supports CORS with native XMLHttpRequest object</p>\n"},"injectVBScript":{"!type":"fn() -> !this","!doc":"<p>Injects a vbscript tag containing a 'getIEByteArray' method for reading\nbinary data from an xhr response in IE8 and below.</p>\n"},"isFormUpload":{"!type":"fn(options: ?) -> !this","!doc":"<p>Detects whether the form is intended to be used for an upload.</p>\n"},"isLoading":{"!type":"fn(request?: ?) -> bool","!doc":"<p>Determines whether this object has a request outstanding.</p>\n"},"nativeBinaryPostSupport":{"!type":"fn() -> ?"},"newRequest":{"!type":"fn(options: ?) -> !this","!doc":"<p>Creates the appropriate XHR transport for a given request on this browser. On IE\nthis may be an <code>XDomainRequest</code> rather than an <code>XMLHttpRequest</code>.</p>\n"},"onComplete":{"!type":"fn(request: ?) -> ?","!doc":"<p>To be called when the request has come back from the server</p>\n"},"onStateChange":{"!type":"fn(request: ?) -> !this","!doc":"<p>Fires when the state of the xhr changes</p>\n"},"onUploadComplete":{"!type":"fn(frame: ?, options: ?) -> !this","!doc":"<p>Callback handler for the upload function. After we've submitted the form via the iframe this creates a bogus\nresponse object to simulate an XHR and populates its responseText from the now-loaded iframe's document body\n(or a textarea inside the body). We then clean up by removing the iframe</p>\n"},"openRequest":{"!type":"fn(options: ?, requestOptions: ?, async: ?, username: ?, password: ?) -> !this","!doc":"<p>Creates and opens an appropriate XHR transport for a given request on this browser.\nThis logic is contained in an individual method to allow for overrides to process all\nof the parameters and options and return a suitable, open connection.</p>\n"},"parseStatus":{"!type":"fn(status: ?) -> ?","!doc":"<p>Checks if the response status was successful</p>\n"},"processXdrRequest":{"!type":"fn(request: ?, xhr: ?) -> !this"},"processXdrResponse":{"!type":"fn(response: ?, xhr: ?) -> !this"},"request":{"!type":"fn(options: ?) -> ?","!doc":"<p>Sends an HTTP request to a remote server.</p>\n\n<p><strong>Important:</strong> Ajax server requests are asynchronous, and this call will\nreturn before the response has been received. Process any returned data\nin a callback function.</p>\n\n<pre><code><a href=\"#!/api/Ext.Ajax-method-request\" rel=\"Ext.Ajax-method-request\" class=\"docClass\">Ext.Ajax.request</a>({\n    url: 'ajax_demo/sample.json',\n    success: function(response, opts) {\n        var obj = <a href=\"#!/api/Ext-method-decode\" rel=\"Ext-method-decode\" class=\"docClass\">Ext.decode</a>(response.responseText);\n        console.dir(obj);\n    },\n    failure: function(response, opts) {\n        console.log('server-side failure with status code ' + response.status);\n    }\n});\n</code></pre>\n\n<p>To execute a callback function in the correct scope, use the <code>scope</code> option.</p>\n"},"setOptions":{"!type":"fn(options: ?, scope: ?) -> ?","!doc":"<p>Sets various options such as the url, params for the request</p>\n"},"setupHeaders":{"!type":"fn(xhr: ?, options: ?, data: ?, params: ?) -> !this","!doc":"<p>Setup all the headers for the request</p>\n"},"setupMethod":{"!type":"fn(options: ?, method: ?) -> string","!doc":"<p>Template method for overriding method</p>\n"},"setupParams":{"!type":"fn(options: ?, params: ?) -> string","!doc":"<p>Template method for overriding params</p>\n"},"setupUrl":{"!type":"fn(options: ?, url: ?) -> string","!doc":"<p>Template method for overriding url</p>\n"},"upload":{"!type":"fn(form: ?, url: ?, params: ?, options: ?) -> !this","!doc":"<p>Uploads a form using a hidden iframe.</p>\n"},"beforerequest":{"!type":"fn(conn: ?, options: ?, eOpts: ?)","!doc":"<p>Fires before a network request is made to retrieve a data object.</p>\n"},"requestcomplete":{"!type":"fn(conn: ?, response: ?, options: ?, eOpts: ?)","!doc":"<p>Fires if the request was successfully completed.</p>\n"},"requestexception":{"!type":"fn(conn: ?, response: ?, options: ?, eOpts: ?)","!doc":"<p>Fires if an error HTTP status was returned from the server. This event may also\nbe listened to in the event that a request has timed out or has been aborted.\nSee <a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html\">HTTP Status Code Definitions</a>\nfor details of HTTP status codes.</p>\n"},"!doc":"<p>The Connection class encapsulates a connection to the page's originating domain, allowing requests to be made either\nto a configured URL, or to a URL specified at request time.</p>\n\n<p>Requests made by this class are asynchronous, and will return immediately. No data from the server will be available\nto the statement immediately following the <a href=\"#!/api/Ext.data.Connection-method-request\" rel=\"Ext.data.Connection-method-request\" class=\"docClass\">request</a> call. To process returned data, use a success callback\nin the request options object, or an <a href=\"#!/api/Ext.data.Connection-event-requestcomplete\" rel=\"Ext.data.Connection-event-requestcomplete\" class=\"docClass\">event listener</a>.</p>\n\n<h1>File Uploads</h1>\n\n<p>File uploads are not performed using normal \"Ajax\" techniques, that is they are not performed using XMLHttpRequests.\nInstead the form is submitted in the standard manner with the DOM &lt;form&gt; element temporarily modified to have its\ntarget set to refer to a dynamically generated, hidden &lt;iframe&gt; which is inserted into the document but removed\nafter the return data has been gathered.</p>\n\n<p>The server response is parsed by the browser to create the document for the IFRAME. If the server is using JSON to\nsend the return object, then the Content-Type header must be set to \"text/html\" in order to tell the browser to\ninsert the text unchanged into the document body.</p>\n\n<p>Characters which are significant to an HTML parser must be sent as HTML entities, so encode <code>&lt;</code> as <code>&amp;lt;</code>, <code>&amp;</code> as\n<code>&amp;amp;</code> etc.</p>\n\n<p>The response text is retrieved from the document, and a fake XMLHttpRequest object is created containing a\nresponseText property in order to conform to the requirements of event handlers and callbacks.</p>\n\n<p>Be aware that file upload packets are sent with the content type multipart/form and some server technologies\n(notably JEE) may require some custom processing in order to retrieve parameter names and parameter values from the\npacket content.</p>\n\n<p>Also note that it's not possible to check the response code of the hidden iframe, so the success handler will ALWAYS fire.</p>\n\n<h1>Binary Posts</h1>\n\n<p>The class supports posting binary data to the server by using native browser capabilities, or a flash polyfill plugin in browsers that do not support native binary posting (e.g. Internet Explorer version 9 or less). A number of limitations exist when the polyfill is used:</p>\n\n<ul>\n<li>Only asynchronous connections are supported.</li>\n<li>Only the POST method can be used.</li>\n<li>The return data can only be binary for now. Set the <a href=\"#!/api/Ext.data.Connection-cfg-binary\" rel=\"Ext.data.Connection-cfg-binary\" class=\"docClass\">binary</a> parameter to <tt>true</tt>.</li>\n<li>Only the 0, 1 and 4 (complete) readyState values will be reported to listeners.</li>\n<li>The flash object will be injected at the bottom of the document and should be invisible.</li>\n<li>Important: See note about packaing the flash plugin with the app in the documenetation of <a href=\"#!/api/Ext.data.flash.BinaryXhr\" rel=\"Ext.data.flash.BinaryXhr\" class=\"docClass\">BinaryXhr</a>.</li>\n</ul>\n\n","!type":"fn(config: ?)","prototype":{"autoAbort":{"!type":"bool","!doc":"<p>Whether this request should abort any pending requests.</p>\n"},"binary":{"!type":"bool","!doc":"<p>True if the response should be treated as binary data.  If true, the binary\ndata will be accessible as a \"responseBytes\" property on the response object.</p>\n"},"cors":{"!type":"bool","!doc":"<p>True to enable CORS support on the XHR object. Currently the only effect of this option\nis to use the XDomainRequest object instead of XMLHttpRequest if the browser is IE8 or above.</p>\n"},"defaultHeaders":{"!doc":"<p>An object containing request headers which are added to each request made by this object.</p>\n"},"disableCaching":{"!type":"bool","!doc":"<p>True to add a unique cache-buster param to GET requests.</p>\n"},"disableCachingParam":{"!type":"string","!doc":"<p>Change the parameter which is sent went disabling caching through a cache buster.</p>\n"},"extraParams":{"!doc":"<p>Any parameters to be appended to the request.</p>\n"},"method":{},"timeout":{"!type":"number","!doc":"<p>The timeout in milliseconds to be used for requests.</p>\n"},"withCredentials":{"!type":"bool","!doc":"<p>True to set <code>withCredentials = true</code> on the XHR object</p>\n"},"async":{"!type":"bool"},"defaultPostHeader":{"!type":"string"},"defaultXdrContentType":{"!type":"string"},"defaultXhrHeader":{"!type":"string"},"getXhrInstance":{"!doc":"<p>Creates the appropriate XHR transport for this browser.</p>\n"},"isXdr":{"!type":"bool"},"password":{"!type":"string"},"url":{},"useDefaultXhrHeader":{"!type":"bool"},"username":{"!type":"string"},"requestId":{"!type":"number"},"abort":{"!type":"fn(request?: ?) -> !this","!doc":"<p>Aborts an active request.</p>\n"},"abortAll":{"!type":"fn() -> !this","!doc":"<p>Aborts all active requests</p>\n"},"cleanup":{"!type":"fn(request: ?) -> !this","!doc":"<p>Cleans up any left over information from the request</p>\n"},"clearTimeout":{"!type":"fn(request: ?) -> !this","!doc":"<p>Clears the timeout on the request</p>\n"},"createException":{"!type":"fn(request: ?) -> !this","!doc":"<p>Creates the exception object</p>\n"},"createResponse":{"!type":"fn(request: ?) -> !this","!doc":"<p>Creates the response object</p>\n"},"getByteArray":{"!type":"fn(xhr: ?) -> ?","!doc":"<p>Gets binary data from the xhr response object and returns it as a byte array</p>\n"},"getForm":{"!type":"fn(options: ?) -> ?","!doc":"<p>Gets the form object from options.</p>\n"},"getLatest":{"!type":"fn() -> ?","!doc":"<p>Gets the most recent request</p>\n"},"getXdrInstance":{"!type":"fn() -> !this","!doc":"<p>Creates the appropriate XDR transport for this browser.\n- IE 7 and below don't support CORS\n- IE 8 and 9 support CORS with native XDomainRequest object\n- IE 10 (and above?) supports CORS with native XMLHttpRequest object</p>\n"},"injectVBScript":{"!type":"fn() -> !this","!doc":"<p>Injects a vbscript tag containing a 'getIEByteArray' method for reading\nbinary data from an xhr response in IE8 and below.</p>\n"},"isFormUpload":{"!type":"fn(options: ?) -> !this","!doc":"<p>Detects whether the form is intended to be used for an upload.</p>\n"},"isLoading":{"!type":"fn(request?: ?) -> bool","!doc":"<p>Determines whether this object has a request outstanding.</p>\n"},"nativeBinaryPostSupport":{"!type":"fn() -> ?"},"newRequest":{"!type":"fn(options: ?) -> !this","!doc":"<p>Creates the appropriate XHR transport for a given request on this browser. On IE\nthis may be an <code>XDomainRequest</code> rather than an <code>XMLHttpRequest</code>.</p>\n"},"onComplete":{"!type":"fn(request: ?) -> ?","!doc":"<p>To be called when the request has come back from the server</p>\n"},"onStateChange":{"!type":"fn(request: ?) -> !this","!doc":"<p>Fires when the state of the xhr changes</p>\n"},"onUploadComplete":{"!type":"fn(frame: ?, options: ?) -> !this","!doc":"<p>Callback handler for the upload function. After we've submitted the form via the iframe this creates a bogus\nresponse object to simulate an XHR and populates its responseText from the now-loaded iframe's document body\n(or a textarea inside the body). We then clean up by removing the iframe</p>\n"},"openRequest":{"!type":"fn(options: ?, requestOptions: ?, async: ?, username: ?, password: ?) -> !this","!doc":"<p>Creates and opens an appropriate XHR transport for a given request on this browser.\nThis logic is contained in an individual method to allow for overrides to process all\nof the parameters and options and return a suitable, open connection.</p>\n"},"parseStatus":{"!type":"fn(status: ?) -> ?","!doc":"<p>Checks if the response status was successful</p>\n"},"processXdrRequest":{"!type":"fn(request: ?, xhr: ?) -> !this"},"processXdrResponse":{"!type":"fn(response: ?, xhr: ?) -> !this"},"request":{"!type":"fn(options: ?) -> ?","!doc":"<p>Sends an HTTP request to a remote server.</p>\n\n<p><strong>Important:</strong> Ajax server requests are asynchronous, and this call will\nreturn before the response has been received. Process any returned data\nin a callback function.</p>\n\n<pre><code><a href=\"#!/api/Ext.Ajax-method-request\" rel=\"Ext.Ajax-method-request\" class=\"docClass\">Ext.Ajax.request</a>({\n    url: 'ajax_demo/sample.json',\n    success: function(response, opts) {\n        var obj = <a href=\"#!/api/Ext-method-decode\" rel=\"Ext-method-decode\" class=\"docClass\">Ext.decode</a>(response.responseText);\n        console.dir(obj);\n    },\n    failure: function(response, opts) {\n        console.log('server-side failure with status code ' + response.status);\n    }\n});\n</code></pre>\n\n<p>To execute a callback function in the correct scope, use the <code>scope</code> option.</p>\n"},"setOptions":{"!type":"fn(options: ?, scope: ?) -> ?","!doc":"<p>Sets various options such as the url, params for the request</p>\n"},"setupHeaders":{"!type":"fn(xhr: ?, options: ?, data: ?, params: ?) -> !this","!doc":"<p>Setup all the headers for the request</p>\n"},"setupMethod":{"!type":"fn(options: ?, method: ?) -> string","!doc":"<p>Template method for overriding method</p>\n"},"setupParams":{"!type":"fn(options: ?, params: ?) -> string","!doc":"<p>Template method for overriding params</p>\n"},"setupUrl":{"!type":"fn(options: ?, url: ?) -> string","!doc":"<p>Template method for overriding url</p>\n"},"upload":{"!type":"fn(form: ?, url: ?, params: ?, options: ?) -> !this","!doc":"<p>Uploads a form using a hidden iframe.</p>\n"},"beforerequest":{"!type":"fn(conn: ?, options: ?, eOpts: ?)","!doc":"<p>Fires before a network request is made to retrieve a data object.</p>\n"},"requestcomplete":{"!type":"fn(conn: ?, response: ?, options: ?, eOpts: ?)","!doc":"<p>Fires if the request was successfully completed.</p>\n"},"requestexception":{"!type":"fn(conn: ?, response: ?, options: ?, eOpts: ?)","!doc":"<p>Fires if an error HTTP status was returned from the server. This event may also\nbe listened to in the event that a request has timed out or has been aborted.\nSee <a href=\"http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html\">HTTP Status Code Definitions</a>\nfor details of HTTP status codes.</p>\n"}}},"AbstractStore":{"!doc":"<p>AbstractStore is a superclass of <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> and <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>. It's never used directly,\nbut offers a set of methods used by both of those subclasses.</p>\n\n<p>We've left it here in the docs for reference purposes, but unless you need to make a whole new type of Store, what\nyou're probably looking for is <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>. If you're still interested, here's a brief description of what\nAbstractStore is and is not.</p>\n\n<p>AbstractStore provides the basic configuration for anything that can be considered a Store. It expects to be\ngiven a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> that represents the type of data in the Store. It also expects to be given a\n<a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a> that handles the loading of data into the Store.</p>\n\n<p>AbstractStore provides a few helpful methods such as <a href=\"#!/api/Ext.data.AbstractStore-method-load\" rel=\"Ext.data.AbstractStore-method-load\" class=\"docClass\">load</a> and <a href=\"#!/api/Ext.data.AbstractStore-method-sync\" rel=\"Ext.data.AbstractStore-method-sync\" class=\"docClass\">sync</a>, which load and save data\nrespectively, passing the requests through the configured <a href=\"#!/api/Ext.data.AbstractStore-cfg-proxy\" rel=\"Ext.data.AbstractStore-cfg-proxy\" class=\"docClass\">proxy</a>. Both built-in Store subclasses add extra\nbehavior to each of these functions. Note also that each AbstractStore subclass has its own way of storing data -\nin <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> the data is saved as a flat <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">MixedCollection</a>, whereas in\n<a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">TreeStore</a> we use a <a href=\"#!/api/Ext.data.Tree\" rel=\"Ext.data.Tree\" class=\"docClass\">Ext.data.Tree</a> to maintain the data's hierarchy.</p>\n\n<p>The store provides filtering and sorting support. This sorting/filtering can happen on the client side\nor can be completed on the server. This is controlled by the <a href=\"#!/api/Ext.data.Store-cfg-remoteSort\" rel=\"Ext.data.Store-cfg-remoteSort\" class=\"docClass\">remoteSort</a> and\n<a href=\"#!/api/Ext.data.Store-cfg-remoteFilter\" rel=\"Ext.data.Store-cfg-remoteFilter\" class=\"docClass\">remoteFilter</a> config options. For more information see the <a href=\"#!/api/Ext.data.AbstractStore-method-sort\" rel=\"Ext.data.AbstractStore-method-sort\" class=\"docClass\">sort</a> and\n<a href=\"#!/api/Ext.data.Store-method-filter\" rel=\"Ext.data.Store-method-filter\" class=\"docClass\">filter</a> methods.</p>\n","!type":"fn(config: ?)","prototype":{"autoLoad":{"!doc":"<p>If data is not specified, and if autoLoad is true or an Object, this store's load method is automatically called\nafter creation. If the value of autoLoad is an Object, this Object will be passed to the store's load method.</p>\n"},"autoSync":{"!type":"bool","!doc":"<p>True to automatically sync the Store with its Proxy after every edit to one of its Records. Defaults to false.</p>\n"},"batchUpdateMode":{"!type":"string","!doc":"<p>Sets the updating behavior based on batch synchronization. 'operation' (the default) will update the Store's\ninternal representation of the data after each operation of the batch has completed, 'complete' will wait until\nthe entire batch has been completed before updating the Store's data. 'complete' is a good choice for local\nstorage proxies, 'operation' is better for remote proxies, where there is a comparatively high latency.</p>\n"},"fields":{"!doc":"<p>This may be used in place of specifying a <a href=\"#!/api/Ext.data.AbstractStore-cfg-model\" rel=\"Ext.data.AbstractStore-cfg-model\" class=\"docClass\">model</a> configuration. The fields should be a\nset of <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Ext.data.Field</a> configuration objects. The store will automatically create a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>\nwith these fields. In general this configuration option should only be used for simple stores like\na two-field store of ComboBox. For anything more complicated, such as specifying a particular id property or\nassociations, a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> should be defined and specified for the <a href=\"#!/api/Ext.data.AbstractStore-cfg-model\" rel=\"Ext.data.AbstractStore-cfg-model\" class=\"docClass\">model</a>\nconfig.</p>\n"},"filterOnLoad":{"!type":"bool","!doc":"<p>If true, any filters attached to this Store will be run after loading data, before the datachanged event is fired.\nDefaults to true, ignored if <a href=\"#!/api/Ext.data.Store-cfg-remoteFilter\" rel=\"Ext.data.Store-cfg-remoteFilter\" class=\"docClass\">remoteFilter</a> is true</p>\n"},"filters":{"!doc":"<p>The collection of <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Filters</a> currently applied to this Store</p>\n"},"model":{"!type":"string","!doc":"<p>Name of the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> associated with this store.\nThe string is used as an argument for <a href=\"#!/api/Ext.ModelManager-method-getModel\" rel=\"Ext.ModelManager-method-getModel\" class=\"docClass\">Ext.ModelManager.getModel</a>.</p>\n"},"proxy":{"!doc":"<p>The Proxy to use for this Store. This can be either a string, a config object or a Proxy instance -\nsee <a href=\"#!/api/Ext.data.AbstractStore-method-setProxy\" rel=\"Ext.data.AbstractStore-method-setProxy\" class=\"docClass\">setProxy</a> for details.</p>\n"},"remoteFilter":{"!type":"bool","!doc":"<p>True to defer any filtering operation to the server. If false, filtering is done locally on the client.</p>\n"},"remoteSort":{"!type":"bool","!doc":"<p>True to defer any sorting operation to the server. If false, sorting is done locally on the client.</p>\n"},"sortOnLoad":{"!type":"bool","!doc":"<p>If true, any sorters attached to this Store will be run after loading data, before the datachanged event is fired.\nDefaults to true, igored if <a href=\"#!/api/Ext.data.Store-cfg-remoteSort\" rel=\"Ext.data.Store-cfg-remoteSort\" class=\"docClass\">remoteSort</a> is true</p>\n"},"statefulFilters":{"!type":"bool","!doc":"<p>Configure as <code>true</code> to have the filters saved when a client <a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">grid</a> saves its state.</p>\n"},"storeId":{"!type":"string","!doc":"<p>Unique identifier for this store. If present, this Store will be registered with the <a href=\"#!/api/Ext.data.StoreManager\" rel=\"Ext.data.StoreManager\" class=\"docClass\">Ext.data.StoreManager</a>,\nmaking it easy to reuse elsewhere.</p>\n\n<p>Note that when store is instatiated by Controller, the storeId will be overridden by the name of the store.</p>\n"},"defaultProxyType":{"!type":"string","!doc":"<p>The string type of the Proxy to create if none is specified. This defaults to creating a\n<a href=\"#!/api/Ext.data.proxy.Memory\" rel=\"Ext.data.proxy.Memory\" class=\"docClass\">memory proxy</a>.</p>\n"},"implicitModel":{"!type":"bool","!doc":"<p>True if a model was created implicitly for this Store. This happens if a fields array is passed to the Store's\nconstructor instead of a model constructor or name.</p>\n"},"isDestroyed":{"!type":"bool","!doc":"<p>True if the Store has already been destroyed. If this is true, the reference to Store should be deleted\nas it will not function correctly any more.</p>\n"},"isStore":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Store, or subclass thereof.</p>\n"},"modelDefaults":{"!doc":"<p>A set of default values to be applied to every model instance added via <a href=\"#!/api/Ext.data.Store-method-insert\" rel=\"Ext.data.Store-method-insert\" class=\"docClass\">insert</a> or created\nvia <a href=\"#!/api/Ext.data.Store-method-createModel\" rel=\"Ext.data.Store-method-createModel\" class=\"docClass\">createModel</a>. This is used internally by associations to set foreign keys and\nother fields. See the Association classes source code for examples. This should not need to be used by application developers.</p>\n"},"removed":{"!doc":"<p>Temporary cache in which removed model instances are kept until successfully synchronised with a Proxy,\nat which point this is cleared.</p>\n"},"afterCommit":{"!type":"fn(record: ?) -> !this","!doc":"<p>A model instance should call this method on the Store it has been <a href=\"#!/api/Ext.data.Model-method-join\" rel=\"Ext.data.Model-method-join\" class=\"docClass\">joined</a> to.</p>\n"},"afterEdit":{"!type":"fn(record: ?, modifiedFieldNames: ?) -> !this","!doc":"<p>A model instance should call this method on the Store it has been <a href=\"#!/api/Ext.data.Model-method-join\" rel=\"Ext.data.Model-method-join\" class=\"docClass\">joined</a> to.</p>\n"},"afterReject":{"!type":"fn(record: ?) -> !this","!doc":"<p>A model instance should call this method on the Store it has been <a href=\"#!/api/Ext.data.Model-method-join\" rel=\"Ext.data.Model-method-join\" class=\"docClass\">joined</a> to..</p>\n"},"applyState":{"!type":"fn(state: ?) -> !this","!doc":"<p>Restores state to the passed state</p>\n"},"clearData":{"!type":"fn() -> !this","!doc":"<p>to be implemented by subclasses</p>\n"},"clearFilter":{"!type":"fn(supressEvent: ?) -> !this"},"create":{"!type":"fn(data: ?, options: ?) -> !this","!doc":"<p>saves any phantom records</p>\n"},"decodeFilters":{"!type":"fn(filters: ?) -> ?","!doc":"<p>Normalizes an array of filter objects, ensuring that they are all <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Ext.util.Filter</a> instances</p>\n"},"destroy":{"!type":"fn(options: ?) -> !this","!doc":"<p>tells the attached proxy to destroy the given records</p>\n"},"destroyStore":{"!type":"fn() -> !this","!doc":"<p>private</p>\n"},"doSort":{"!type":"fn(sorterFn: ?) -> !this","!doc":"<p>private</p>\n"},"filter":{"!type":"fn(filters: ?, value: ?) -> !this"},"filterBy":{"!type":"fn(fn: ?, scope: ?) -> !this"},"filterNew":{"!type":"fn(item: ?) -> !this","!doc":"<p>Filter function for new records.</p>\n"},"filterUpdated":{"!type":"fn(item: ?) -> !this","!doc":"<p>Filter function for updated records.</p>\n"},"getBatchListeners":{"!type":"fn() -> ?","!doc":"<p>Returns an object which is passed in as the listeners argument to proxy.batch inside this.sync.\nThis is broken out into a separate function to allow for customisation of the listeners</p>\n"},"getById":{"!type":"fn() -> !this","!doc":"<p>to be implemented by subclasses</p>\n"},"getCount":{"!type":"fn() -> !this","!doc":"<p>to be implemented by subclasses</p>\n"},"getModifiedRecords":{"!type":"fn() -> ?","!doc":"<p>Gets all <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">records</a> added or updated since the last commit. Note that the order of records\nreturned is not deterministic and does not indicate the order in which records were modified. Note also that\nremoved records are not included (use <a href=\"#!/api/Ext.data.AbstractStore-method-getRemovedRecords\" rel=\"Ext.data.AbstractStore-method-getRemovedRecords\" class=\"docClass\">getRemovedRecords</a> for that).</p>\n"},"getNewRecords":{"!type":"fn() -> ?","!doc":"<p>Returns all Model instances that are either currently a phantom (e.g. have no id), or have an ID but have not\nyet been saved on this Store (this happens when adding a non-phantom record from another Store into this one)</p>\n"},"getProxy":{"!type":"fn() -> ?","!doc":"<p>Returns the proxy currently attached to this proxy instance</p>\n"},"getRemovedRecords":{"!type":"fn() -> ?","!doc":"<p>Returns any records that have been removed from the store but not yet destroyed on the proxy.</p>\n"},"getState":{"!type":"fn() -> !this","!doc":"<p>Returns the grouping, sorting and filtered state of this Store.</p>\n"},"getUpdatedRecords":{"!type":"fn() -> ?","!doc":"<p>Returns all Model instances that have been updated in the Store but not yet synchronized with the Proxy</p>\n"},"isFiltered":{"!type":"fn() -> !this"},"isLoading":{"!type":"fn() -> bool","!doc":"<p>Returns true if the Store is currently performing a load operation</p>\n"},"load":{"!type":"fn(this: ?, records: ?, successful: ?, eOpts: ?)","!doc":"<p>Fires whenever the store reads data from a remote data source.</p>\n"},"onBatchComplete":{"!type":"fn(batch: ?, operation: ?) -> !this","!doc":"<p>Attached as the 'complete' event listener to a proxy's Batch object. Iterates over the batch operations\nand updates the Store's internal data MixedCollection.</p>\n"},"onBatchException":{"!type":"fn(batch: ?, operation: ?) -> !this"},"onBatchOperationComplete":{"!type":"fn(batch: ?, operation: ?) -> !this","!doc":"<p>Attached as the 'operationcomplete' event listener to a proxy's Batch object. By default just calls through\nto onProxyWrite.</p>\n"},"onClassExtended":{"!type":"fn(cls: ?, data: ?, hooks: ?) -> !this"},"onCreateRecords":{"!type":"fn() -> !this","!doc":"<p>may be implemented by store subclasses</p>\n"},"onDestroyRecords":{"!type":"fn(records: ?, operation: ?, success: ?) -> !this","!doc":"<p>Removes any records when a write is returned from the server.</p>\n"},"onIdChanged":{"!type":"fn(model: ?, oldId: ?, newId: ?, oldInternalId: ?) -> !this"},"onMetaChange":{"!type":"fn(proxy: ?, meta: ?) -> !this","!doc":"<p>private</p>\n"},"onProxyWrite":{"!type":"fn(operation: ?) -> !this","!doc":"<p>Callback for any write Operation over the Proxy. Updates the Store's MixedCollection to reflect\nthe updates provided by the Proxy</p>\n"},"onUpdate":{"!type":"fn() -> !this"},"onUpdateRecords":{"!type":"fn() -> !this","!doc":"<p>may be implemented by store subclasses</p>\n"},"read":{"!type":"fn() -> !this"},"reload":{"!type":"fn(options: ?) -> !this","!doc":"<p>Reloads the store using the last options passed to the <a href=\"#!/api/Ext.data.AbstractStore-method-load\" rel=\"Ext.data.AbstractStore-method-load\" class=\"docClass\">load</a> method.</p>\n"},"removeAll":{"!type":"fn() -> !this","!doc":"<p>Removes all records from the store. This method does a \"fast remove\",\nindividual remove events are not called. The <a href=\"#!/api/Ext.data.AbstractStore-event-clear\" rel=\"Ext.data.AbstractStore-event-clear\" class=\"docClass\">clear</a> event is\nfired upon completion.</p>\n"},"resumeAutoSync":{"!type":"fn() -> !this","!doc":"<p>Resumes automatically syncing the Store with its Proxy.  Only applicable if <a href=\"#!/api/Ext.data.AbstractStore-cfg-autoSync\" rel=\"Ext.data.AbstractStore-cfg-autoSync\" class=\"docClass\">autoSync</a> is <code>true</code></p>\n"},"save":{"!type":"fn() -> !this","!doc":"<p>Saves all pending changes via the configured <a href=\"#!/api/Ext.data.AbstractStore-cfg-proxy\" rel=\"Ext.data.AbstractStore-cfg-proxy\" class=\"docClass\">proxy</a>. Use <a href=\"#!/api/Ext.data.AbstractStore-method-sync\" rel=\"Ext.data.AbstractStore-method-sync\" class=\"docClass\">sync</a> instead.</p>\n"},"setProxy":{"!type":"fn(proxy: ?) -> ?","!doc":"<p>Sets the Store's Proxy by string, config object or Proxy instance</p>\n"},"suspendAutoSync":{"!type":"fn() -> !this","!doc":"<p>Suspends automatically syncing the Store with its Proxy.  Only applicable if <a href=\"#!/api/Ext.data.AbstractStore-cfg-autoSync\" rel=\"Ext.data.AbstractStore-cfg-autoSync\" class=\"docClass\">autoSync</a> is <code>true</code></p>\n"},"sync":{"!type":"fn(options?: ?) -> ?","!doc":"<p>Synchronizes the store with its <a href=\"#!/api/Ext.data.AbstractStore-cfg-proxy\" rel=\"Ext.data.AbstractStore-cfg-proxy\" class=\"docClass\">proxy</a>. This asks the proxy to batch together any new, updated\nand deleted records in the store, updating the store's internal representation of the records\nas each operation completes.</p>\n"},"update":{"!type":"fn(this: ?, record: ?, operation: ?, modifiedFieldNames: ?, eOpts: ?)","!doc":"<p>Fires when a Model instance has been updated.</p>\n"},"add":{"!type":"fn(store: ?, records: ?, index: ?, eOpts: ?)","!doc":"<p>Fired when a Model instance has been added to this Store.</p>\n"},"beforeload":{"!type":"fn(store: ?, operation: ?, eOpts: ?)","!doc":"<p>Fires before a request is made for a new data object. If the beforeload handler returns false the load\naction will be canceled.</p>\n"},"beforesync":{"!type":"fn(options: ?, eOpts: ?)","!doc":"<p>Fired before a call to <a href=\"#!/api/Ext.data.AbstractStore-method-sync\" rel=\"Ext.data.AbstractStore-method-sync\" class=\"docClass\">sync</a> is executed. Return false from any listener to cancel the sync</p>\n"},"bulkremove":{"!type":"fn(store: ?, records: ?, indexes: ?, isMove: ?, eOpts: ?)","!doc":"<p>Fired at the <em>end</em> of the <a href=\"#!/api/Ext.data.Store-method-remove\" rel=\"Ext.data.Store-method-remove\" class=\"docClass\">remove</a> method when all records in the passed array have been removed.</p>\n\n<p>If many records may be removed in one go, then it is more efficient to listen for this event\nand perform any processing for a bulk remove than to listen for many <a href=\"#!/api/Ext.data.AbstractStore-event-remove\" rel=\"Ext.data.AbstractStore-event-remove\" class=\"docClass\">remove</a> events.</p>\n"},"clear":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fired after the <a href=\"#!/api/Ext.data.AbstractStore-method-removeAll\" rel=\"Ext.data.AbstractStore-method-removeAll\" class=\"docClass\">removeAll</a> method is called.</p>\n"},"datachanged":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires whenever the records in the Store have changed in some way - this could include adding or removing\nrecords, or updating the data in existing records</p>\n"},"metachange":{"!type":"fn(this: ?, meta: ?, eOpts: ?)","!doc":"<p>Fires when this store's underlying reader (available via the proxy) provides new metadata.\nMetadata usually consists of new field definitions, but can include any configuration data\nrequired by an application, and can be processed as needed in the event handler.\nThis event is currently only fired for JsonReaders.</p>\n"},"refresh":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires when the data cache has changed in a bulk manner (e.g., it has been sorted, filtered, etc.) and a\nwidget that is using this Store as a Record cache should refresh its view.</p>\n"},"remove":{"!type":"fn(store: ?, record: ?, index: ?, isMove: ?, eOpts: ?)","!doc":"<p>Fired when a Model instance has been removed from this Store.</p>\n\n<p><strong>If many records may be removed in one go, then it is more efficient to listen for the <a href=\"#!/api/Ext.data.AbstractStore-event-bulkremove\" rel=\"Ext.data.AbstractStore-event-bulkremove\" class=\"docClass\">bulkremove</a> event\nand perform any processing for a bulk remove than to listen for this <a href=\"#!/api/Ext.data.AbstractStore-event-remove\" rel=\"Ext.data.AbstractStore-event-remove\" class=\"docClass\">remove</a> event.</strong></p>\n"},"write":{"!type":"fn(store: ?, operation: ?, eOpts: ?)","!doc":"<p>Fires whenever a successful write has been made via the configured <a href=\"#!/api/Ext.data.AbstractStore-cfg-proxy\" rel=\"Ext.data.AbstractStore-cfg-proxy\" class=\"docClass\">Proxy</a></p>\n"}}},"ArrayStore":{"!doc":"<p>Small helper class to make creating <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>s from Array data easier. An ArrayStore will be\nautomatically configured with a <a href=\"#!/api/Ext.data.reader.Array\" rel=\"Ext.data.reader.Array\" class=\"docClass\">Ext.data.reader.Array</a>.</p>\n\n<p>A store configuration would be something like:</p>\n\n<pre><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.ArrayStore\" rel=\"Ext.data.ArrayStore\" class=\"docClass\">Ext.data.ArrayStore</a>', {\n    // store configs\n    storeId: 'myStore',\n    // reader configs\n    fields: [\n       'company',\n       {name: 'price', type: 'float'},\n       {name: 'change', type: 'float'},\n       {name: 'pctChange', type: 'float'},\n       {name: 'lastChange', type: 'date', dateFormat: 'n/j h:ia'}\n    ]\n});\n</code></pre>\n\n<p>This store is configured to consume a returned object of the form:</p>\n\n<pre><code>var myData = [\n    ['3m Co',71.72,0.02,0.03,'9/1 12:00am'],\n    ['Alcoa Inc',29.01,0.42,1.47,'9/1 12:00am'],\n    ['Boeing Co.',75.43,0.53,0.71,'9/1 12:00am'],\n    ['Hewlett-Packard Co.',36.53,-0.03,-0.08,'9/1 12:00am'],\n    ['Wal-Mart Stores, Inc.',45.45,0.73,1.63,'9/1 12:00am']\n];\n</code></pre>\n\n<p>An object literal of this form could also be used as the <a href=\"#!/api/Ext.data.ArrayStore-cfg-data\" rel=\"Ext.data.ArrayStore-cfg-data\" class=\"docClass\">data</a> config option.</p>\n","!type":"fn(config: ?)","prototype":{"loadData":{"!type":"fn(data: ?, append: ?) -> !this","!doc":"<p>Loads an array of data straight into the Store.</p>\n\n<p>Using this method is great if the data is in the correct format already (e.g. it doesn't need to be\nprocessed by a reader). If your data requires processing to decode the data structure, use a\n<a href=\"#!/api/Ext.data.proxy.Memory\" rel=\"Ext.data.proxy.Memory\" class=\"docClass\">MemoryProxy</a> or <a href=\"#!/api/Ext.data.ArrayStore-method-loadRawData\" rel=\"Ext.data.ArrayStore-method-loadRawData\" class=\"docClass\">loadRawData</a>.</p>\n"}}},"Store":{"prototype":{"autoDestroy":{"!type":"bool","!doc":"<p>When a Store is used by only one <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">DataView</a>, and should only exist for the lifetime of that view, then\nconfigure the autoDestroy flag as <code>true</code>. This causes the destruction of the view to trigger the destruction of its Store.</p>\n"},"buffered":{"!type":"bool","!doc":"<p>Allows the Store to prefetch and cache in a <strong>page cache</strong>, pages of Records, and to then satisfy\nloading requirements from this page cache.</p>\n\n<p>To use buffered Stores, initiate the process by loading the first page. The number of rows rendered are\ndetermined automatically, and the range of pages needed to keep the cache primed for scrolling is\nrequested and cached.\nExample:</p>\n\n<pre><code>myStore.loadPage(1); // Load page 1\n</code></pre>\n\n<p>A <a href=\"#!/api/Ext.grid.plugin.BufferedRenderer\" rel=\"Ext.grid.plugin.BufferedRenderer\" class=\"docClass\">BufferedRenderer</a> is instantiated which will monitor the scrolling in the grid, and\nrefresh the view's rows from the page cache as needed. It will also pull new data into the page\ncache when scrolling of the view draws upon data near either end of the prefetched data.</p>\n\n<p>The margins which trigger view refreshing from the prefetched data are <a href=\"#!/api/Ext.grid.plugin.BufferedRenderer-cfg-numFromEdge\" rel=\"Ext.grid.plugin.BufferedRenderer-cfg-numFromEdge\" class=\"docClass\">Ext.grid.plugin.BufferedRenderer.numFromEdge</a>,\n<a href=\"#!/api/Ext.grid.plugin.BufferedRenderer-cfg-leadingBufferZone\" rel=\"Ext.grid.plugin.BufferedRenderer-cfg-leadingBufferZone\" class=\"docClass\">Ext.grid.plugin.BufferedRenderer.leadingBufferZone</a> and <a href=\"#!/api/Ext.grid.plugin.BufferedRenderer-cfg-trailingBufferZone\" rel=\"Ext.grid.plugin.BufferedRenderer-cfg-trailingBufferZone\" class=\"docClass\">Ext.grid.plugin.BufferedRenderer.trailingBufferZone</a>.</p>\n\n<p>The margins which trigger loading more data into the page cache are, <a href=\"#!/api/Ext.data.Store-cfg-leadingBufferZone\" rel=\"Ext.data.Store-cfg-leadingBufferZone\" class=\"docClass\">leadingBufferZone</a> and\n<a href=\"#!/api/Ext.data.Store-cfg-trailingBufferZone\" rel=\"Ext.data.Store-cfg-trailingBufferZone\" class=\"docClass\">trailingBufferZone</a>.</p>\n\n<p>By default, only 5 pages of data are cached in the page cache, with pages \"scrolling\" out of the buffer\nas the view moves down through the dataset.\nSetting this value to zero means that no pages are <em>ever</em> scrolled out of the page cache, and\nthat eventually the whole dataset may become present in the page cache. This is sometimes desirable\nas long as datasets do not reach astronomical proportions.</p>\n\n<p>Selection state may be maintained across page boundaries by configuring the SelectionModel not to discard\nrecords from its collection when those Records cycle out of the Store's primary collection. This is done\nby configuring the SelectionModel like this:</p>\n\n<pre><code>selModel: {\n    pruneRemoved: false\n}\n</code></pre>\n"},"clearOnPageLoad":{"!type":"bool","!doc":"<p>True to empty the store when loading another page via <a href=\"#!/api/Ext.data.Store-method-loadPage\" rel=\"Ext.data.Store-method-loadPage\" class=\"docClass\">loadPage</a>,\n<a href=\"#!/api/Ext.data.Store-method-nextPage\" rel=\"Ext.data.Store-method-nextPage\" class=\"docClass\">nextPage</a> or <a href=\"#!/api/Ext.data.Store-method-previousPage\" rel=\"Ext.data.Store-method-previousPage\" class=\"docClass\">previousPage</a>. Setting to false keeps existing records, allowing\nlarge data sets to be loaded one page at a time but rendered all together.</p>\n"},"clearRemovedOnLoad":{"!type":"bool","!doc":"<p><code>true</code> to clear anything in the <a href=\"#!/api/Ext.data.Store-property-removed\" rel=\"Ext.data.Store-property-removed\" class=\"docClass\">removed</a> record collection when the store loads.</p>\n"},"data":{"!doc":"<p>When this Store is not <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, the <code>data</code> property is a MixedCollection which holds this store's local cache of records.</p>\n\n<p>When this store <em>is</em> <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, the <code>data</code> property is a cache of <em>pages</em> of records used to satisfy load requests from the Store when the associated view\nscrolls. Depending on how the <a href=\"#!/api/Ext.data.Store-cfg-leadingBufferZone\" rel=\"Ext.data.Store-cfg-leadingBufferZone\" class=\"docClass\">buffer zone</a> and <a href=\"#!/api/Ext.data.Store-cfg-purgePageCount\" rel=\"Ext.data.Store-cfg-purgePageCount\" class=\"docClass\">purgePageCount</a> are configured,\npages which are scrolled out of view may be evicted from the cache, and need to be re-requested from the server\nwhen scrolled back into view. For this reason, if using <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, it is recommended that you configure\nyour Model definitions with a unique <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">Ext.data.Model.idProperty</a> so that records which return to the page\ncache may be matched against previously selected records.</p>\n\n<p>Pages in the direction of scroll are prefetched from the remote server and loaded into this cache <em>before</em>\nthey are needed based upon the <a href=\"#!/api/Ext.data.Store-cfg-leadingBufferZone\" rel=\"Ext.data.Store-cfg-leadingBufferZone\" class=\"docClass\">buffer zone</a> so that scrolling can proceed without visible pauses for data loading.</p>\n"},"groupDir":{"!type":"string","!doc":"<p>The direction in which sorting should be applied when grouping. Supported values are \"ASC\" and \"DESC\".</p>\n"},"groupField":{"!type":"string","!doc":"<p>The field by which to group data in the store. Internally, grouping is very similar to sorting - the\ngroupField and <a href=\"#!/api/Ext.data.Store-cfg-groupDir\" rel=\"Ext.data.Store-cfg-groupDir\" class=\"docClass\">groupDir</a> are injected as the first sorter (see <a href=\"#!/api/Ext.data.Store-method-sort\" rel=\"Ext.data.Store-method-sort\" class=\"docClass\">sort</a>). Stores support a single\nlevel of grouping, and groups can be fetched via the <a href=\"#!/api/Ext.data.Store-method-getGroups\" rel=\"Ext.data.Store-method-getGroups\" class=\"docClass\">getGroups</a> method.</p>\n"},"groupers":{"!doc":"<p>The collection of <a href=\"#!/api/Ext.util.Grouper\" rel=\"Ext.util.Grouper\" class=\"docClass\">Groupers</a> currently applied to this Store.</p>\n"},"leadingBufferZone":{"!type":"number","!doc":"<p>When <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, the number of extra rows to keep cached on the leading side of scrolling buffer\nas scrolling proceeds. A larger number means fewer replenishments from the server.</p>\n"},"pageSize":{"!type":"number","!doc":"<p>The number of records considered to form a 'page'. This is used to power the built-in\npaging using the nextPage and previousPage functions when the grid is paged using a\n<a href=\"#!/api/Ext.toolbar.Paging\" rel=\"Ext.toolbar.Paging\" class=\"docClass\">PagingToolbar</a> Defaults to 25.</p>\n\n<p>If this Store is <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, pages are loaded into a page cache before the Store's\ndata is updated from the cache. The pageSize is the number of rows loaded into the cache in one request.\nThis will not affect the rendering of a buffered grid, but a larger page size will mean fewer loads.</p>\n\n<p>In a buffered grid, scrolling is monitored, and the page cache is kept primed with data ahead of the\ndirection of scroll to provide rapid access to data when scrolling causes it to be required. Several pages\nin advance may be requested depending on various parameters.</p>\n\n<p>It is recommended to tune the <a href=\"#!/api/Ext.data.Store-cfg-pageSize\" rel=\"Ext.data.Store-cfg-pageSize\" class=\"docClass\">pageSize</a>, <a href=\"#!/api/Ext.data.Store-cfg-trailingBufferZone\" rel=\"Ext.data.Store-cfg-trailingBufferZone\" class=\"docClass\">trailingBufferZone</a> and\n<a href=\"#!/api/Ext.data.Store-cfg-leadingBufferZone\" rel=\"Ext.data.Store-cfg-leadingBufferZone\" class=\"docClass\">leadingBufferZone</a> configurations based upon the conditions pertaining in your deployed application.</p>\n\n<p>The provided SDK example <code>examples/grid/infinite-scroll-grid-tuner.html</code> can be used to experiment with\ndifferent settings including simulating Ajax latency.</p>\n"},"proxy":{"!doc":"<p>The Proxy to use for this Store. This can be either a string, a config object or a Proxy instance -\nsee <a href=\"#!/api/Ext.data.Store-method-setProxy\" rel=\"Ext.data.Store-method-setProxy\" class=\"docClass\">setProxy</a> for details.</p>\n"},"purgePageCount":{"!type":"number","!doc":"<p><em>Valid only when used with a <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a> Store.</em></p>\n\n<p>The number of pages <em>additional to the required buffered range</em> to keep in the prefetch cache before purging least recently used records.</p>\n\n<p>For example, if the height of the view area and the configured <a href=\"#!/api/Ext.data.Store-cfg-trailingBufferZone\" rel=\"Ext.data.Store-cfg-trailingBufferZone\" class=\"docClass\">trailingBufferZone</a> and <a href=\"#!/api/Ext.data.Store-cfg-leadingBufferZone\" rel=\"Ext.data.Store-cfg-leadingBufferZone\" class=\"docClass\">leadingBufferZone</a> require that there\nare three pages in the cache, then a <code>purgePageCount</code> of 5 ensures that up to 8 pages can be in the page cache any any one time.</p>\n\n<p>A value of 0 indicates to never purge the prefetched data.</p>\n"},"remoteFilter":{"!type":"bool","!doc":"<p><code>true</code> if the grouping should be performed on the server side, false if it is local only.</p>\n\n<p><a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">Buffered</a> stores automatically set this to <code>true</code>. Buffered stores contain an abitrary\nsubset of the full dataset which depends upon various configurations and which pages have been requested\nfor rendering. Such <em>sparse</em> datasets are ineligible for local filtering.</p>\n"},"remoteGroup":{"!type":"bool","!doc":"<p><code>true</code> if the grouping should apply on the server side, false if it is local only.  If the\ngrouping is local, it can be applied immediately to the data.  If it is remote, then it will simply act as a\nhelper, automatically sending the grouping information to the server.</p>\n\n<p><a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">Buffered</a> stores automatically set this to <code>true</code>. Buffered stores contain an abitrary\nsubset of the full dataset which depends upon various configurations and which pages have been requested\nfor rendering. Such <em>sparse</em> datasets are ineligible for local grouping.</p>\n"},"remoteSort":{"!type":"bool","!doc":"<p><code>true</code> if the sorting should be performed on the server side, false if it is local only.</p>\n\n<p><a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">Buffered</a> stores automatically set this to <code>true</code>. Buffered stores contain an abitrary\nsubset of the full dataset which depends upon various configurations and which pages have been requested\nfor rendering. Such <em>sparse</em> datasets are ineligible for local sorting.</p>\n"},"sortOnFilter":{"!type":"bool","!doc":"<p>For local filtering only, causes <a href=\"#!/api/Ext.data.Store-method-sort\" rel=\"Ext.data.Store-method-sort\" class=\"docClass\">sort</a> to be called whenever <a href=\"#!/api/Ext.data.Store-method-filter\" rel=\"Ext.data.Store-method-filter\" class=\"docClass\">filter</a> is called,\ncausing the sorters to be reapplied after filtering.</p>\n"},"trailingBufferZone":{"!type":"number","!doc":"<p>When <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, the number of extra records to keep cached on the trailing side of scrolling buffer\nas scrolling proceeds. A larger number means fewer replenishments from the server.</p>\n"},"addRecordsOptions":{"!doc":"<p>Private. Used as parameter to loadRecords</p>\n"},"currentPage":{"!type":"number","!doc":"<p>The page that the Store has most recently loaded (see <a href=\"#!/api/Ext.data.Store-method-loadPage\" rel=\"Ext.data.Store-method-loadPage\" class=\"docClass\">loadPage</a>)</p>\n"},"defaultPageSize":{"!type":"number"},"defaultViewSize":{"!type":"number","!doc":"<p>Number of records to load into a buffered grid before it has been bound to a view of known size</p>\n"},"loading":{"!type":"bool","!doc":"<p><code>true</code> if the Store is currently loading via its Proxy.</p>\n"},"snapshot":{"!doc":"<p>A pristine (unfiltered) collection of the records in this store. This is used to reinstate\nrecords when a filter is removed or changed</p>\n"},"add":{"!type":"fn(model: ?) -> ?","!doc":"<p>Adds Model instance to the Store. This method accepts either:</p>\n\n<ul>\n<li>An array of Model instances or Model configuration objects.</li>\n<li>Any number of Model instance or Model configuration object arguments.</li>\n</ul>\n\n\n<p>The new Model instances will be added at the end of the existing collection.</p>\n\n<p>Sample usage:</p>\n\n<pre><code>myStore.add({some: 'data'}, {some: 'other data'});\n</code></pre>\n\n<p>Note that if this Store is sorted, the new Model instances will be inserted\nat the correct point in the Store to maintain the sort order.</p>\n"},"addFilter":{"!type":"fn(filters: ?, applyFilters?: ?) -> !this","!doc":"<p>Adds a new Filter to this Store's <a href=\"#!/api/Ext.data.Store-property-filters\" rel=\"Ext.data.Store-property-filters\" class=\"docClass\">filter set</a> and\nby default, applys the updated filter set to the Store's unfiltered dataset.</p>\n"},"addSorted":{"!type":"fn(record: ?) -> !this","!doc":"<p>(Local sort only) Inserts the passed Record into the Store at the index where it\nshould go based on the current sort information.</p>\n"},"aggregate":{"!type":"fn(fn: ?, scope?: ?, grouped?: ?, args?: ?) -> ?","!doc":"<p>Runs the aggregate function for all the records in the store.</p>\n\n<p>When store is filtered, only items within the filter are aggregated.</p>\n"},"average":{"!type":"fn(field: ?, grouped?: ?) -> ?","!doc":"<p>Gets the average value in the store.</p>\n\n<p>When store is filtered, only items within the filter are aggregated.</p>\n"},"cachePage":{"!type":"fn(records: ?, page: ?) -> !this","!doc":"<p>Caches the records in the prefetch and stripes them with their server-side\nindex.</p>\n"},"clearData":{"!type":"fn(isLoad: ?) -> !this","!doc":"<p>private</p>\n"},"clearFilter":{"!type":"fn(suppressEvent?: ?) -> !this","!doc":"<p>Reverts to a view of the Record cache with no filtering applied.</p>\n"},"clearGrouping":{"!type":"fn() -> !this","!doc":"<p>Clear any groupers in the store</p>\n"},"collect":{"!type":"fn(dataIndex: ?, allowNull?: ?, bypassFilter?: ?) -> ?","!doc":"<p>Collects unique values for a particular dataIndex from this store.</p>\n"},"commitChanges":{"!type":"fn() -> !this","!doc":"<p>Commits all Records with <a href=\"#!/api/Ext.data.Store-method-getModifiedRecords\" rel=\"Ext.data.Store-method-getModifiedRecords\" class=\"docClass\">outstanding changes</a>. To handle updates for changes,\nsubscribe to the Store's <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">update event</a>, and perform updating when the third parameter is\n<a href=\"#!/api/Ext.data.Model-static-property-COMMIT\" rel=\"Ext.data.Model-static-property-COMMIT\" class=\"docClass\">Ext.data.Record.COMMIT</a>.</p>\n"},"constructGroups":{"!type":"fn() -> !this"},"count":{"!type":"fn(grouped?: ?) -> number","!doc":"<p>Gets the count of items in the store.</p>\n\n<p>When store is filtered, only items within the filter are counted.</p>\n"},"createFilterFn":{"!type":"fn(property: ?, value: ?, anyMatch?: ?, caseSensitive?: ?, exactMatch?: ?) -> !this","!doc":"<p>Returns a filter function used to test a the given property's value. Defers most of the work to\n<a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>'s createValueMatcher function.</p>\n"},"createModel":{"!type":"fn(record: ?) -> ?","!doc":"<p>Converts a literal to a model, if it's not a model already</p>\n"},"decodeGroupers":{"!type":"fn(groupers: ?) -> ?","!doc":"<p>Normalizes an array of grouper objects, ensuring that they are all <a href=\"#!/api/Ext.util.Grouper\" rel=\"Ext.util.Grouper\" class=\"docClass\">Ext.util.Grouper</a> instances</p>\n"},"doSort":{"!type":"fn(sorterFn: ?) -> !this","!doc":"<p>overriden to provide striping of the indexes as sorting occurs.\nthis cannot be done inside of sort because datachanged has already\nfired and will trigger a repaint of the bound view.</p>\n"},"each":{"!type":"fn(fn: ?, scope?: ?) -> !this","!doc":"<p>Calls the specified function for each <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">record</a> in the store.</p>\n\n<p>When store is filtered, only loops over the filtered records.</p>\n"},"filter":{"!type":"fn(filters?: ?, value?: ?) -> !this","!doc":"<p>Filters the loaded set of records by a given set of filters.</p>\n\n<p>By default, the passed filter(s) are <em>added</em> to the collection of filters being used to filter this Store.</p>\n\n<p>To remove existing filters before applying a new set of filters use</p>\n\n<pre><code>// Clear the filter collection without updating the UI\nstore.clearFilter(true);\n</code></pre>\n\n<p>see <a href=\"#!/api/Ext.data.Store-method-clearFilter\" rel=\"Ext.data.Store-method-clearFilter\" class=\"docClass\">clearFilter</a>.</p>\n\n<p>Alternatively, if filters are configured with an <code>id</code>, then existing filters store may be <em>replaced</em> by new\nfilters having the same <code>id</code>.</p>\n\n<p>Filtering by single field:</p>\n\n<pre><code>store.filter(\"email\", /\\.com$/);\n</code></pre>\n\n<p>Using multiple filters:</p>\n\n<pre><code>store.filter([\n    {property: \"email\", value: /\\.com$/},\n    {filterFn: function(item) { return item.get(\"age\") &gt; 10; }}\n]);\n</code></pre>\n\n<p>Using <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Ext.util.Filter</a> instances instead of config objects\n(note that we need to specify the <a href=\"#!/api/Ext.util.Filter-cfg-root\" rel=\"Ext.util.Filter-cfg-root\" class=\"docClass\">root</a> config option in this case):</p>\n\n<pre><code>store.filter([\n    <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Ext.util.Filter</a>', {property: \"email\", value: /\\.com$/, root: 'data'}),\n    <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Ext.util.Filter</a>', {filterFn: function(item) { return item.get(\"age\") &gt; 10; }, root: 'data'})\n]);\n</code></pre>\n\n<p>When store is filtered, most of the methods for accessing store data will be working only\nwithin the set of filtered records. Two notable exceptions are <a href=\"#!/api/Ext.data.Store-method-queryBy\" rel=\"Ext.data.Store-method-queryBy\" class=\"docClass\">queryBy</a> and\n<a href=\"#!/api/Ext.data.Store-method-getById\" rel=\"Ext.data.Store-method-getById\" class=\"docClass\">getById</a>.</p>\n"},"filterBy":{"!type":"fn(fn: ?, scope?: ?) -> !this","!doc":"<p>Filters by a function. The specified function will be called for each\nRecord in this Store. If the function returns <code>true</code> the Record is included,\notherwise it is filtered out.</p>\n\n<p>When store is filtered, most of the methods for accessing store data will be working only\nwithin the set of filtered records. Two notable exceptions are <a href=\"#!/api/Ext.data.Store-method-queryBy\" rel=\"Ext.data.Store-method-queryBy\" class=\"docClass\">queryBy</a> and\n<a href=\"#!/api/Ext.data.Store-method-getById\" rel=\"Ext.data.Store-method-getById\" class=\"docClass\">getById</a>.</p>\n"},"filterNewOnly":{"!type":"fn(item: ?) -> !this"},"find":{"!type":"fn(fieldName: ?, value: ?, startIndex?: ?, anyMatch?: ?, caseSensitive?: ?, exactMatch?: ?) -> number","!doc":"<p>Finds the index of the first matching Record in this store by a specific field value.</p>\n\n<p>When store is filtered, finds records only within filter.</p>\n\n<p>**IMPORTANT</p>\n\n<p>If this store is <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, this can ONLY find records which happen to be cached in the page cache.\nThis will be parts of the dataset around the currently visible zone, or recently visited zones if the pages\nhave not yet been purged from the cache.**</p>\n"},"findBy":{"!type":"fn(fn: ?, scope?: ?, startIndex?: ?) -> number","!doc":"<p>Find the index of the first matching Record in this Store by a function.\nIf the function returns <code>true</code> it is considered a match.</p>\n\n<p>When store is filtered, finds records only within filter.</p>\n\n<p>**IMPORTANT</p>\n\n<p>If this store is <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, this can ONLY find records which happen to be cached in the page cache.\nThis will be parts of the dataset around the currently visible zone, or recently visited zones if the pages\nhave not yet been purged from the cache.**</p>\n"},"findExact":{"!type":"fn(fieldName: ?, value: ?, startIndex?: ?) -> number","!doc":"<p>Finds the index of the first matching Record in this store by a specific field value.</p>\n\n<p>When store is filtered, finds records only within filter.</p>\n\n<p>**IMPORTANT</p>\n\n<p>If this store is <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, this can ONLY find records which happen to be cached in the page cache.\nThis will be parts of the dataset around the currently visible zone, or recently visited zones if the pages\nhave not yet been purged from the cache.**</p>\n"},"findRecord":{"!type":"fn(fieldName: ?, value: ?, startIndex?: ?, anyMatch?: ?, caseSensitive?: ?, exactMatch?: ?) -> ?","!doc":"<p>Finds the first matching Record in this store by a specific field value.</p>\n\n<p>When store is filtered, finds records only within filter.</p>\n\n<p>**IMPORTANT</p>\n\n<p>If this store is <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, this can ONLY find records which happen to be cached in the page cache.\nThis will be parts of the dataset around the currently visible zone, or recently visited zones if the pages\nhave not yet been purged from the cache.**</p>\n"},"fireGroupChange":{"!type":"fn() -> !this","!doc":"<p>Fires the groupchange event. Abstracted out so we can use it\nas a callback</p>\n"},"first":{"!type":"fn(grouped?: ?) -> ?","!doc":"<p>Convenience function for getting the first model instance in the store.</p>\n\n<p>When store is filtered, will return first item within the filter.</p>\n"},"getAggregate":{"!type":"fn(fn: ?, scope: ?, records: ?, args: ?) -> !this"},"getAt":{"!type":"fn(index: ?) -> ?","!doc":"<p>Get the Record at the specified index.</p>\n\n<p>The index is effected by filtering.</p>\n"},"getAverage":{"!type":"fn(records: ?, field: ?) -> !this","!doc":"<p>, see average</p>\n"},"getById":{"!type":"fn(id: ?) -> ?","!doc":"<p>Get the Record with the specified id.</p>\n\n<p>This method is not effected by filtering, lookup will be performed from all records\ninside the store, filtered or not.</p>\n"},"getCount":{"!type":"fn() -> number","!doc":"<p>Gets the number of records in store.</p>\n\n<p>If using paging, this may not be the total size of the dataset. If the data object\nused by the Reader contains the dataset size, then the <a href=\"#!/api/Ext.data.Store-method-getTotalCount\" rel=\"Ext.data.Store-method-getTotalCount\" class=\"docClass\">getTotalCount</a> function returns\nthe dataset size.  <strong>Note</strong>: see the Important note in <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a>.</p>\n\n<p>When store is filtered, it's the number of records matching the filter.</p>\n"},"getGroupData":{"!type":"fn(sort?: ?) -> ?","!doc":"<p>Returns records grouped by the configured <a href=\"#!/api/Ext.data.Store-cfg-groupers\" rel=\"Ext.data.Store-cfg-groupers\" class=\"docClass\">grouper</a> configuration. Sample return value (in\nthis case grouping by genre and then author in a fictional books dataset):</p>\n\n<pre><code>[\n    {\n        name: 'Fantasy',\n        depth: 0,\n        records: [\n            //book1, book2, book3, book4\n        ],\n        children: [\n            {\n                name: 'Rowling',\n                depth: 1,\n                records: [\n                    //book1, book2\n                ]\n            },\n            {\n                name: 'Tolkein',\n                depth: 1,\n                records: [\n                    //book3, book4\n                ]\n            }\n        ]\n    }\n]\n</code></pre>\n"},"getGroupField":{"!type":"fn() -> !this"},"getGroupString":{"!type":"fn(instance: ?) -> string","!doc":"<p>Returns the string to group on for a given model instance. The default implementation of this method returns\nthe model's <a href=\"#!/api/Ext.data.Store-cfg-groupField\" rel=\"Ext.data.Store-cfg-groupField\" class=\"docClass\">groupField</a>, but this can be overridden to group by an arbitrary string. For example, to\ngroup by the first letter of a model's 'name' field, use the following code:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    groupDir: 'ASC',\n    getGroupString: function(instance) {\n        return instance.get('name')[0];\n    }\n});\n</code></pre>\n"},"getGroups":{"!type":"fn(groupName?: ?) -> ?","!doc":"<p>Returns an array containing the result of applying grouping to the records in this store.\nSee <a href=\"#!/api/Ext.data.Store-cfg-groupField\" rel=\"Ext.data.Store-cfg-groupField\" class=\"docClass\">groupField</a>, <a href=\"#!/api/Ext.data.Store-cfg-groupDir\" rel=\"Ext.data.Store-cfg-groupDir\" class=\"docClass\">groupDir</a> and <a href=\"#!/api/Ext.data.Store-method-getGroupString\" rel=\"Ext.data.Store-method-getGroupString\" class=\"docClass\">getGroupString</a>. Example for a store\ncontaining records with a color field:</p>\n\n<pre><code>var myStore = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    groupField: 'color',\n    groupDir  : 'DESC'\n});\n\nmyStore.getGroups(); // returns:\n[\n    {\n        name: 'yellow',\n        children: [\n            // all records where the color field is 'yellow'\n        ]\n    },\n    {\n        name: 'red',\n        children: [\n            // all records where the color field is 'red'\n        ]\n    }\n]\n</code></pre>\n\n<p>Group contents are effected by filtering.</p>\n"},"getGroupsForGrouper":{"!type":"fn(records: ?, grouper: ?) -> !this","!doc":"<p>For a given set of records and a Grouper, returns an array of arrays - each of which is the set of records\nmatching a certain group.</p>\n"},"getGroupsForGrouperIndex":{"!type":"fn(records: ?, grouperIndex: ?) -> ?","!doc":"<p>This is used recursively to gather the records into the configured Groupers. The data MUST have been sorted for\nthis to work properly (see <a href=\"#!/api/Ext.data.Store-method-getGroupData\" rel=\"Ext.data.Store-method-getGroupData\" class=\"docClass\">getGroupData</a> and <a href=\"#!/api/Ext.data.Store-method-getGroupsForGrouper\" rel=\"Ext.data.Store-method-getGroupsForGrouper\" class=\"docClass\">getGroupsForGrouper</a>) Most of the work is done by\n<a href=\"#!/api/Ext.data.Store-method-getGroupsForGrouper\" rel=\"Ext.data.Store-method-getGroupsForGrouper\" class=\"docClass\">getGroupsForGrouper</a> - this function largely just handles the recursion.</p>\n"},"getMax":{"!type":"fn(records: ?, field: ?) -> !this","!doc":"<p>, see max</p>\n"},"getMin":{"!type":"fn(records: ?, field: ?) -> !this","!doc":"<p>, see min</p>\n"},"getNewRecords":{"!type":"fn() -> ?","!doc":"<p>inherit docs</p>\n"},"getPageFromRecordIndex":{"!type":"fn(index: ?) -> number","!doc":"<p>Determines the page from a record index</p>\n"},"getRange":{"!type":"fn(start: ?, end: ?, options?: ?) -> ?","!doc":"<p>Gathers a range of Records between specified indices.</p>\n\n<p>If this store is <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, the indices are relative to the entire dataset, not the local record cache.</p>\n\n<p>If this store is <a href=\"#!/api/Ext.data.Store-cfg-buffered\" rel=\"Ext.data.Store-cfg-buffered\" class=\"docClass\">buffered</a>, then the requested data range <em>may</em> not be immediately available, and will\nbe returned through a passed callback function.</p>\n\n<p>This method is affected by filtering.</p>\n"},"getRejectRecords":{"!type":"fn() -> !this","!doc":"<p>Ideally in the future this will use getModifiedRecords, where there will be a param\nto getNewRecords &amp; getUpdatedRecords to indicate whether to get only the valid\nrecords or grab all of them</p>\n"},"getSum":{"!type":"fn(records: ?, field: ?) -> !this","!doc":"<p>, see sum</p>\n"},"getTotalCount":{"!type":"fn() -> number","!doc":"<p>Returns the total number of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> instances that the <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a>\nindicates exist. This will usually differ from <a href=\"#!/api/Ext.data.Store-method-getCount\" rel=\"Ext.data.Store-method-getCount\" class=\"docClass\">getCount</a> when using paging - getCount returns the\nnumber of records loaded into the Store at the moment, getTotalCount returns the number of records that\ncould be loaded into the Store if the Store contained all data</p>\n"},"getUpdatedRecords":{"!type":"fn() -> ?","!doc":"<p>inherit docs</p>\n"},"group":{"!type":"fn(groupers: ?, direction?: ?) -> !this","!doc":"<p>Groups data inside the store.</p>\n"},"guaranteeRange":{"!type":"fn(start: ?, end: ?, callback: ?, scope: ?, options: ?) -> !this","!doc":"<p>Guarantee a specific range, this will load the store with a range (that\nmust be the <code>pageSize</code> or smaller) and take care of any loading that may\nbe necessary.</p>\n"},"indexOf":{"!type":"fn(record: ?) -> number","!doc":"<p>Get the index of the record within the store.</p>\n\n<p>When store is filtered, records outside of filter will not be found.</p>\n"},"indexOfId":{"!type":"fn(id: ?) -> number","!doc":"<p>Get the index within the store of the Record with the passed id.</p>\n\n<p>Like <a href=\"#!/api/Ext.data.Store-method-indexOf\" rel=\"Ext.data.Store-method-indexOf\" class=\"docClass\">indexOf</a>, this method is effected by filtering.</p>\n"},"indexOfTotal":{"!type":"fn(record: ?) -> number","!doc":"<p>Get the index within the entire dataset. From 0 to the totalCount.</p>\n\n<p>Like <a href=\"#!/api/Ext.data.Store-method-indexOf\" rel=\"Ext.data.Store-method-indexOf\" class=\"docClass\">indexOf</a>, this method is effected by filtering.</p>\n"},"insert":{"!type":"fn(index: ?, records: ?) -> ?","!doc":"<p>Inserts Model instances into the Store at the given index and fires the <a href=\"#!/api/Ext.data.Store-event-add\" rel=\"Ext.data.Store-event-add\" class=\"docClass\">add</a> event.\nSee also <a href=\"#!/api/Ext.data.Store-method-add\" rel=\"Ext.data.Store-method-add\" class=\"docClass\">add</a>.</p>\n"},"isFiltered":{"!type":"fn() -> bool","!doc":"<p>Returns <code>true</code> if this store is currently filtered</p>\n"},"isGrouped":{"!type":"fn() -> bool","!doc":"<p>Checks if the store is currently grouped</p>\n"},"last":{"!type":"fn(grouped?: ?) -> ?","!doc":"<p>Convenience function for getting the last model instance in the store.</p>\n\n<p>When store is filtered, will return last item within the filter.</p>\n"},"load":{"!type":"fn(options?: ?) -> !this","!doc":"<p>Loads data into the Store via the configured <a href=\"#!/api/Ext.data.Store-cfg-proxy\" rel=\"Ext.data.Store-cfg-proxy\" class=\"docClass\">proxy</a>. This uses the Proxy to make an\nasynchronous call to whatever storage backend the Proxy uses, automatically adding the retrieved\ninstances into the Store and calling an optional callback if required. Example usage:</p>\n\n<pre><code>store.load({\n    scope: this,\n    callback: function(records, operation, success) {\n        // the <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">operation</a> object\n        // contains all of the details of the load operation\n        console.log(records);\n    }\n});\n</code></pre>\n\n<p>If the callback scope does not need to be set, a function can simply be passed:</p>\n\n<pre><code>store.load(function(records, operation, success) {\n    console.log('loaded records');\n});\n</code></pre>\n"},"loadPage":{"!type":"fn(page: ?, options?: ?) -> !this","!doc":"<p>Loads a given 'page' of data by setting the start and limit values appropriately. Internally this just causes a normal\nload operation, passing in calculated 'start' and 'limit' params.</p>\n"},"loadRawData":{"!type":"fn(data: ?, append?: ?) -> !this","!doc":"<p>Loads data via the bound Proxy's reader</p>\n\n<p>Use this method if you are attempting to load data and want to utilize the configured data reader.</p>\n"},"loadRecords":{"!type":"fn(records: ?, options: ?) -> !this","!doc":"<p>Loads an array of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model</a> instances into the store, fires the datachanged event. This should only usually\nbe called internally when loading from the <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a>, when adding records manually use <a href=\"#!/api/Ext.data.Store-method-add\" rel=\"Ext.data.Store-method-add\" class=\"docClass\">add</a> instead</p>\n"},"loadToPrefetch":{"!type":"fn(options: ?) -> !this"},"max":{"!type":"fn(field: ?, grouped?: ?) -> ?","!doc":"<p>Gets the maximum value in the store.</p>\n\n<p>When store is filtered, only items within the filter are aggregated.</p>\n"},"min":{"!type":"fn(field: ?, grouped?: ?) -> ?","!doc":"<p>Gets the minimum value in the store.</p>\n\n<p>When store is filtered, only items within the filter are aggregated.</p>\n"},"nextPage":{"!type":"fn(options: ?) -> !this","!doc":"<p>Loads the next 'page' in the current data set</p>\n"},"onBeforeSort":{"!type":"fn() -> !this"},"onGuaranteedRange":{"!type":"fn(options: ?) -> !this","!doc":"<p>Handles a guaranteed range being loaded</p>\n"},"onIdChanged":{"!type":"fn(rec: ?, oldId: ?, newId: ?, oldInternalId: ?) -> !this"},"onPageMapClear":{"!type":"fn() -> !this","!doc":"<p>Cancels all pending prefetch requests.</p>\n\n<p>This is called when the page map is cleared.</p>\n\n<p>Any requests which still make it through will be for the previous pageMapGeneration\n(pageMapGeneration is incremented upon clear), and so will be rejected upon arrival.</p>\n"},"onProxyLoad":{"!type":"fn(operation: ?) -> !this","!doc":"<p>Called internally when a Proxy has completed a load request</p>\n"},"onProxyPrefetch":{"!type":"fn(operation: ?) -> !this","!doc":"<p>Called after the configured proxy completes a prefetch operation.</p>\n"},"onUpdate":{"!type":"fn(record: ?, type: ?, modifiedFieldNames: ?) -> !this"},"pageCached":{"!type":"fn(page: ?) -> !this","!doc":"<p>Determines if the passed page is available in the page cache.</p>\n"},"pagePending":{"!type":"fn(page: ?) -> !this","!doc":"<p>Determines if a request for a page is currently running</p>\n"},"prefetch":{"!type":"fn(this: ?, records: ?, successful: ?, operation: ?, eOpts: ?)","!doc":"<p>Fires whenever records have been prefetched.</p>\n"},"prefetchPage":{"!type":"fn(page: ?, options?: ?) -> !this","!doc":"<p>Prefetches a page of data.</p>\n"},"prefetchRange":{"!type":"fn(start: ?, end: ?) -> !this","!doc":"<p>Ensures that the specified range of rows is present in the cache.</p>\n\n<p>Converts the row range to a page range and then only load pages which are not already\npresent in the page cache.</p>\n"},"previousPage":{"!type":"fn(options: ?) -> !this","!doc":"<p>Loads the previous 'page' in the current data set</p>\n"},"primeCache":{"!type":"fn(start: ?, end: ?, direction: ?) -> !this"},"query":{"!type":"fn(property: ?, value: ?, anyMatch?: ?, caseSensitive?: ?, exactMatch?: ?) -> ?","!doc":"<p>Query all the cached records in this Store by name/value pair.\nThe parameters will be used to generated a filter function that is given\nto the queryBy method.</p>\n\n<p>This method compliments queryBy by generating the query function automatically.</p>\n"},"queryBy":{"!type":"fn(fn: ?, scope?: ?) -> ?","!doc":"<p>Query all the cached records in this Store using a filtering function. The specified function\nwill be called with each record in this Store. If the function returns <code>true</code> the record is\nincluded in the results.</p>\n\n<p>This method is not effected by filtering, it will always look from all records inside the store\nno matter if filter is applied or not.</p>\n"},"rangeCached":{"!type":"fn(start: ?, end: ?) -> !this","!doc":"<p>Determines if the passed range is available in the page cache.</p>\n"},"rangeSatisfied":{"!type":"fn(start: ?, end: ?) -> bool","!doc":"<p>Determines if the passed range is available in the page cache.</p>\n"},"rejectChanges":{"!type":"fn() -> !this","!doc":"<p><a href=\"#!/api/Ext.data.Model-method-reject\" rel=\"Ext.data.Model-method-reject\" class=\"docClass\">Rejects</a> outstanding changes on all <a href=\"#!/api/Ext.data.Store-method-getModifiedRecords\" rel=\"Ext.data.Store-method-getModifiedRecords\" class=\"docClass\">modified records</a>\nand re-insert any records that were removed locally. Any phantom records will be removed.</p>\n"},"reload":{"!type":"fn(options: ?) -> !this","!doc":"<p>Reloads the store using the last options passed to the <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> method.</p>\n"},"remove":{"!type":"fn(records: ?) -> !this","!doc":"<p>Removes the specified record(s) from the Store, firing the <a href=\"#!/api/Ext.data.Store-event-remove\" rel=\"Ext.data.Store-event-remove\" class=\"docClass\">remove</a> event for each instance that is removed.</p>\n\n<p>A <a href=\"#!/api/Ext.data.Store-event-bulkremove\" rel=\"Ext.data.Store-event-bulkremove\" class=\"docClass\">bulkremove</a> event is called at the end passing all removed records and their indices.\nplus a single 'datachanged' event after removal.</p>\n"},"removeAll":{"!type":"fn(silent?: ?) -> !this","!doc":"<p>Removes all items from the store.</p>\n\n<p>Individual record <code><a href=\"#!/api/Ext.data.Store-event-remove\" rel=\"Ext.data.Store-event-remove\" class=\"docClass\">remove</a></code> events are not fired by this method.</p>\n"},"removeAt":{"!type":"fn(index: ?, count?: ?) -> !this","!doc":"<p>Removes the model instance(s) at the given index</p>\n"},"removeFilter":{"!type":"fn(toRemove: ?, applyFilters?: ?) -> !this","!doc":"<p>Removes an individual Filter from the current <a href=\"#!/api/Ext.data.Store-property-filters\" rel=\"Ext.data.Store-property-filters\" class=\"docClass\">filter set</a> using the passed Filter/Filter id and\nby default, applys the updated filter set to the Store's unfiltered dataset.</p>\n"},"sort":{"!type":"fn() -> ?","!doc":"<p>because prefetchData is stored by index\nthis invalidates all of the prefetchedData</p>\n"},"sum":{"!type":"fn(field: ?, grouped?: ?) -> number","!doc":"<p>Sums the value of <code>field</code> for each <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">record</a> in store\nand returns the result.</p>\n\n<p>When store is filtered, only sums items within the filter.</p>\n"},"updateGroupsOnAdd":{"!type":"fn(records: ?) -> !this"},"updateGroupsOnRemove":{"!type":"fn(records: ?) -> !this"},"updateGroupsOnUpdate":{"!type":"fn(record: ?, modifiedFieldNames: ?) -> !this"},"beforeprefetch":{"!type":"fn(this: ?, operation: ?, eOpts: ?)","!doc":"<p>Fires before a prefetch occurs. Return <code>false</code> to cancel.</p>\n"},"filterchange":{"!type":"fn(store: ?, filters: ?, eOpts: ?)","!doc":"<p>Fired whenever the filter set changes.</p>\n"},"groupchange":{"!type":"fn(store: ?, groupers: ?, eOpts: ?)","!doc":"<p>Fired whenever the grouping in the grid changes.</p>\n"},"loadData":{"!type":"fn(data: ?, append?: ?) -> !this","!doc":"<p>Loads an array of data straight into the Store.</p>\n\n<p>Using this method is great if the data is in the correct format already (e.g. it doesn't need to be\nprocessed by a reader). If your data requires processing to decode the data structure, use a\n<a href=\"#!/api/Ext.data.proxy.Memory\" rel=\"Ext.data.proxy.Memory\" class=\"docClass\">MemoryProxy</a> or <a href=\"#!/api/Ext.data.Store-method-loadRawData\" rel=\"Ext.data.Store-method-loadRawData\" class=\"docClass\">loadRawData</a>.</p>\n"},"groupIdFn":{"!type":"fn(group: ?) -> !this"},"grouperIdFn":{"!type":"fn(grouper: ?) -> !this"},"recordIdFn":{"!type":"fn(record: ?) -> !this"},"recordIndexFn":{"!type":"fn(record: ?) -> !this"}},"!doc":"<p>The Store class encapsulates a client side cache of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> objects. Stores load data via a\n<a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a>, and also provide functions for <a href=\"#!/api/Ext.data.Store-method-sort\" rel=\"Ext.data.Store-method-sort\" class=\"docClass\">sorting</a>, <a href=\"#!/api/Ext.data.Store-method-filter\" rel=\"Ext.data.Store-method-filter\" class=\"docClass\">filtering</a>\nand querying the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model</a> instances contained within it.</p>\n\n<p>Creating a Store is easy - we just tell it the Model and the Proxy to use for loading and saving its data:</p>\n\n<pre><code> // Set up a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model</a> to use in our Store\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n     extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n     fields: [\n         {name: 'firstName', type: 'string'},\n         {name: 'lastName',  type: 'string'},\n         {name: 'age',       type: 'int'},\n         {name: 'eyeColor',  type: 'string'}\n     ]\n });\n\n var myStore = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n     model: 'User',\n     proxy: {\n         type: 'ajax',\n         url: '/users.json',\n         reader: {\n             type: 'json',\n             root: 'users'\n         }\n     },\n     autoLoad: true\n });\n</code></pre>\n\n<p>In the example above we configured an AJAX proxy to load data from the url '/users.json'. We told our Proxy to use a\n<a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">JsonReader</a> to parse the response from the server into Model object - <a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">see the docs on JsonReader</a> for details.</p>\n\n<h2>Inline data</h2>\n\n<p>Stores can also load data inline. Internally, Store converts each of the objects we pass in as <a href=\"#!/api/Ext.data.Store-cfg-data\" rel=\"Ext.data.Store-cfg-data\" class=\"docClass\">data</a> into\nModel instances:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n     model: 'User',\n     data : [\n         {firstName: 'Ed',    lastName: 'Spencer'},\n         {firstName: 'Tommy', lastName: 'Maintz'},\n         {firstName: 'Aaron', lastName: 'Conran'},\n         {firstName: 'Jamie', lastName: 'Avins'}\n     ]\n });\n</code></pre>\n\n<p>Loading inline data using the method above is great if the data is in the correct format already (e.g. it doesn't\nneed to be processed by a <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">reader</a>). If your inline data requires processing to decode\nthe data structure, use a <a href=\"#!/api/Ext.data.proxy.Memory\" rel=\"Ext.data.proxy.Memory\" class=\"docClass\">MemoryProxy</a> instead (see the <a href=\"#!/api/Ext.data.proxy.Memory\" rel=\"Ext.data.proxy.Memory\" class=\"docClass\">MemoryProxy</a> docs for an example).</p>\n\n<p>Additional data can also be loaded locally using <a href=\"#!/api/Ext.data.Store-method-add\" rel=\"Ext.data.Store-method-add\" class=\"docClass\">add</a>.</p>\n\n<h2>Dynamic Loading</h2>\n\n<p>Stores can be dynamically updated by calling the <a href=\"#!/api/Ext.data.Store-method-load\" rel=\"Ext.data.Store-method-load\" class=\"docClass\">load</a> method:</p>\n\n<pre><code>store.load({\n    params: {\n        group: 3,\n        type: 'user'\n    },\n    callback: function(records, operation, success) {\n        // do something after the load finishes\n    },\n    scope: this\n});\n</code></pre>\n\n<p>Here a bunch of arbitrary parameters is passed along with the load request and a callback function is set\nup to do something after the loading is over.</p>\n\n<h2>Loading Nested Data</h2>\n\n<p>Applications often need to load sets of associated data - for example a CRM system might load a User and her Orders.\nInstead of issuing an AJAX request for the User and a series of additional AJAX requests for each Order, we can load\na nested dataset and allow the Reader to automatically populate the associated models. Below is a brief example, see\nthe <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a> intro docs for a full explanation:</p>\n\n<pre><code> var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n     autoLoad: true,\n     model: \"User\",\n     proxy: {\n         type: 'ajax',\n         url: 'users.json',\n         reader: {\n             type: 'json',\n             root: 'users'\n         }\n     }\n });\n</code></pre>\n\n<p>Which would consume a response like this:</p>\n\n<pre><code> {\n     \"users\": [{\n         \"id\": 1,\n         \"name\": \"Ed\",\n         \"orders\": [{\n             \"id\": 10,\n             \"total\": 10.76,\n             \"status\": \"invoiced\"\n        },{\n             \"id\": 11,\n             \"total\": 13.45,\n             \"status\": \"shipped\"\n        }]\n     }]\n }\n</code></pre>\n\n<p>See the <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a> intro docs for a full explanation.</p>\n\n<h2>Filtering and Sorting</h2>\n\n<p>Stores can be sorted and filtered - in both cases either remotely or locally. The <a href=\"#!/api/Ext.data.Store-cfg-sorters\" rel=\"Ext.data.Store-cfg-sorters\" class=\"docClass\">sorters</a> and\n<a href=\"#!/api/Ext.data.Store-cfg-filters\" rel=\"Ext.data.Store-cfg-filters\" class=\"docClass\">filters</a> are held inside <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">MixedCollection</a> instances to make them easy to manage.\nUsually it is sufficient to either just specify sorters and filters in the Store configuration or call <a href=\"#!/api/Ext.data.Store-method-sort\" rel=\"Ext.data.Store-method-sort\" class=\"docClass\">sort</a>\nor <a href=\"#!/api/Ext.data.Store-method-filter\" rel=\"Ext.data.Store-method-filter\" class=\"docClass\">filter</a>:</p>\n\n<pre><code> var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n     model: 'User',\n     sorters: [{\n         property: 'age',\n         direction: 'DESC'\n     }, {\n         property: 'firstName',\n         direction: 'ASC'\n     }],\n\n     filters: [{\n         property: 'firstName',\n         value: /Ed/\n     }]\n });\n</code></pre>\n\n<p>The new Store will keep the configured sorters and filters in the MixedCollection instances mentioned above. By\ndefault, sorting and filtering are both performed locally by the Store - see <a href=\"#!/api/Ext.data.Store-cfg-remoteSort\" rel=\"Ext.data.Store-cfg-remoteSort\" class=\"docClass\">remoteSort</a> and\n<a href=\"#!/api/Ext.data.Store-cfg-remoteFilter\" rel=\"Ext.data.Store-cfg-remoteFilter\" class=\"docClass\">remoteFilter</a> to allow the server to perform these operations instead.</p>\n\n<p>Filtering and sorting after the Store has been instantiated is also easy. Calling <a href=\"#!/api/Ext.data.Store-method-filter\" rel=\"Ext.data.Store-method-filter\" class=\"docClass\">filter</a> adds another filter\nto the Store and automatically filters the dataset (calling <a href=\"#!/api/Ext.data.Store-method-filter\" rel=\"Ext.data.Store-method-filter\" class=\"docClass\">filter</a> with no arguments simply re-applies all\nexisting filters). Note that by default <a href=\"#!/api/Ext.data.Store-cfg-sortOnFilter\" rel=\"Ext.data.Store-cfg-sortOnFilter\" class=\"docClass\">sortOnFilter</a> is set to true, which means that your sorters are\nautomatically reapplied if using local sorting.</p>\n\n<pre><code>store.filter('eyeColor', 'Brown');\n</code></pre>\n\n<p>Change the sorting at any time by calling <a href=\"#!/api/Ext.data.Store-method-sort\" rel=\"Ext.data.Store-method-sort\" class=\"docClass\">sort</a>:</p>\n\n<pre><code>store.sort('height', 'ASC');\n</code></pre>\n\n<p>Note that all existing sorters will be removed in favor of the new sorter data (if <a href=\"#!/api/Ext.data.Store-method-sort\" rel=\"Ext.data.Store-method-sort\" class=\"docClass\">sort</a> is called with no\narguments, the existing sorters are just reapplied instead of being removed). To keep existing sorters and add new\nones, just add them to the MixedCollection:</p>\n\n<pre><code>store.sorters.add(new <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a>({\n    property : 'shoeSize',\n    direction: 'ASC'\n}));\n\nstore.sort();\n</code></pre>\n\n<h2>Registering with StoreManager</h2>\n\n<p>Any Store that is instantiated with a <a href=\"#!/api/Ext.data.Store-cfg-storeId\" rel=\"Ext.data.Store-cfg-storeId\" class=\"docClass\">storeId</a> will automatically be registered with the <a href=\"#!/api/Ext.data.StoreManager\" rel=\"Ext.data.StoreManager\" class=\"docClass\">StoreManager</a>. This makes it easy to reuse the same store in multiple views:</p>\n\n<pre><code>//this store can be used several times\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n    storeId: 'usersStore'\n});\n\nnew Ext.List({\n    store: 'usersStore',\n    //other config goes here\n});\n\nnew <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a>({\n    store: 'usersStore',\n    //other config goes here\n});\n</code></pre>\n\n<h2>Further Reading</h2>\n\n<p>Stores are backed up by an ecosystem of classes that enables their operation. To gain a full understanding of these\npieces and how they fit together, see:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a> - overview of what Proxies are and how they are used</li>\n<li><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> - the core class in the data package</li>\n<li><a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Reader</a> - used by any subclass of <a href=\"#!/api/Ext.data.proxy.Server\" rel=\"Ext.data.proxy.Server\" class=\"docClass\">ServerProxy</a> to read a response</li>\n</ul>\n\n","!type":"fn(config?: ?)"},"association":{"Association":{"!doc":"<p>Associations enable you to express relationships between different <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Models</a>. Let's say we're\nwriting an ecommerce system where Users can make Orders - there's a relationship between these Models that we can\nexpress like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'email'],\n\n    hasMany: {model: 'Order', name: 'orders'}\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Order', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'user_id', 'status', 'price'],\n\n    belongsTo: 'User'\n});\n</code></pre>\n\n<p>We've set up two models - User and Order - and told them about each other. You can set up as many associations on\neach Model as you need using the two default types - <a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">hasMany</a> and <a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">belongsTo</a>. There's much more detail on the usage of each of those inside their\ndocumentation pages. If you're not familiar with Models already, <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">there is plenty on those too</a>.</p>\n\n<p><strong>Further Reading</strong></p>\n\n<ul>\n<li><a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">hasMany associations</a></li>\n<li><a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">belongsTo associations</a></li>\n<li><a href=\"#!/api/Ext.data.association.HasOne\" rel=\"Ext.data.association.HasOne\" class=\"docClass\">hasOne associations</a></li>\n<li><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">using Models</a></li>\n</ul>\n\n\n<h1>Self association models</h1>\n\n<p>We can also have models that create parent/child associations between the same type. Below is an example, where\ngroups can be nested inside other groups:</p>\n\n<pre><code>// Server Data\n{\n    \"groups\": {\n        \"id\": 10,\n        \"parent_id\": 100,\n        \"name\": \"Main Group\",\n        \"parent_group\": {\n            \"id\": 100,\n            \"parent_id\": null,\n            \"name\": \"Parent Group\"\n        },\n        \"nested\" : {\n            \"child_groups\": [{\n                \"id\": 2,\n                \"parent_id\": 10,\n                \"name\": \"Child Group 1\"\n            },{\n                \"id\": 3,\n                \"parent_id\": 10,\n                \"name\": \"Child Group 2\"\n            },{\n                \"id\": 4,\n                \"parent_id\": 10,\n                \"name\": \"Child Group 3\"\n            }]\n        }\n    }\n}\n\n// Client code\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Group', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'parent_id', 'name'],\n    proxy: {\n        type: 'ajax',\n        url: 'data.json',\n        reader: {\n            type: 'json',\n            root: 'groups'\n        }\n    },\n    associations: [{\n        type: 'hasMany',\n        model: 'Group',\n        primaryKey: 'id',\n        foreignKey: 'parent_id',\n        autoLoad: true,\n        associationKey: 'nested.child_groups' // read child data from nested.child_groups\n    }, {\n        type: 'belongsTo',\n        model: 'Group',\n        primaryKey: 'id',\n        foreignKey: 'parent_id',\n        associationKey: 'parent_group' // read parent data from parent_group\n    }]\n});\n\n<a href=\"#!/api/Ext-method-onReady\" rel=\"Ext-method-onReady\" class=\"docClass\">Ext.onReady</a>(function(){\n\n    Group.load(10, {\n        success: function(group){\n            console.log(group.getGroup().get('name'));\n\n            group.groups().each(function(rec){\n                console.log(rec.get('name'));\n            });\n        }\n    });\n\n});\n</code></pre>\n","!type":"fn(config?: ?)","prototype":{"associatedModel":{"!type":"string","!doc":"<p>The string name of the model that is being associated with.</p>\n\n<p><strong>NB!</strong> This config is required when instantiating the Association directly.\nWhen defining the association as a config object inside Model, the <a href=\"#!/api/Ext.data.association.Association-cfg-model\" rel=\"Ext.data.association.Association-cfg-model\" class=\"docClass\">model</a>\nconfiguration will shadow this config.</p>\n"},"associationKey":{"!type":"string","!doc":"<p>The name of the property in the data to read the association from. Defaults to the name of the associated model.</p>\n"},"model":{"!type":"string","!doc":"<p>The string name of the model that is being associated with.</p>\n\n<p>This config option is to be used when defining the association as a config\nobject within Model.  The value is then mapped to <a href=\"#!/api/Ext.data.association.Association-cfg-associatedModel\" rel=\"Ext.data.association.Association-cfg-associatedModel\" class=\"docClass\">associatedModel</a> when\nAssociation is instantiated inside Model.</p>\n"},"ownerModel":{"!type":"string","!doc":"<p>The string name of the model that owns the association.</p>\n\n<p><strong>NB!</strong> This config is required when instantiating the Association directly.\nHowever, it cannot be used at all when defining the association as a config\nobject inside Model, because the name of the model itself will be supplied\nautomatically as the value of this config.</p>\n"},"primaryKey":{"!type":"string","!doc":"<p>The name of the primary key on the associated model. In general this will be the\n<a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">Ext.data.Model.idProperty</a> of the Model.</p>\n"},"reader":{"!doc":"<p>A special reader to read associated data</p>\n"},"associatedName":{"!type":"string","!doc":"<p>The name of the model is on the other end of the association (e.g. if a User model hasMany Orders, this is\n'Order')</p>\n"},"defaultReaderType":{"!type":"string"},"initialConfig":{},"isAssociation":{"!type":"bool"},"ownerName":{"!type":"string","!doc":"<p>The name of the model that 'owns' the association</p>\n"},"AUTO_ID":{"!type":"number"},"getReader":{"!type":"fn() -> ?","!doc":"<p>Get a specialized reader for reading associated data</p>\n"},"create":{"!type":"fn(association: ?) -> !this"}}},"BelongsTo":{"!doc":"<p>Represents a many to one association with another model. The owner model is expected to have\na foreign key which references the primary key of the associated model:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Category', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        { name: 'id',   type: 'int' },\n        { name: 'name', type: 'string' }\n    ]\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Product', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        { name: 'id',          type: 'int' },\n        { name: 'category_id', type: 'int' },\n        { name: 'name',        type: 'string' }\n    ],\n    // we can use the belongsTo shortcut on the model to create a belongsTo association\n    associations: [\n        { type: 'belongsTo', model: 'Category' }\n    ]\n});\n</code></pre>\n\n<p>In the example above we have created models for Products and Categories, and linked them together\nby saying that each Product belongs to a Category. This automatically links each Product to a Category\nbased on the Product's category_id, and provides new functions on the Product model:</p>\n\n<h2>Generated getter function</h2>\n\n<p>The first function that is added to the owner model is a getter function:</p>\n\n<pre><code>var product = new Product({\n    id: 100,\n    category_id: 20,\n    name: 'Sneakers'\n});\n\nproduct.getCategory(function(category, operation) {\n    // do something with the category object\n    alert(category.get('id')); // alerts 20\n}, this);\n</code></pre>\n\n<p>The getCategory function was created on the Product model when we defined the association. This uses the\nCategory's configured <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">proxy</a> to load the Category asynchronously, calling the provided\ncallback when it has loaded.</p>\n\n<p>The new getCategory function will also accept an object containing success, failure and callback properties\n- callback will always be called, success will only be called if the associated model was loaded successfully\nand failure will only be called if the associatied model could not be loaded:</p>\n\n<pre><code>product.getCategory({\n    reload: true, // force a reload if the owner model is already cached\n    callback: function(category, operation) {}, // a function that will always be called\n    success : function(category, operation) {}, // a function that will only be called if the load succeeded\n    failure : function(category, operation) {}, // a function that will only be called if the load did not succeed\n    scope   : this // optionally pass in a scope object to execute the callbacks in\n});\n</code></pre>\n\n<p>In each case above the callbacks are called with two arguments - the associated model instance and the\n<a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">operation</a> object that was executed to load that instance. The Operation object is\nuseful when the instance could not be loaded.</p>\n\n<p>Once the getter has been called on the model, it will be cached if the getter is called a second time. To\nforce the model to reload, specify reload: true in the options object.</p>\n\n<h2>Generated setter function</h2>\n\n<p>The second generated function sets the associated model instance - if only a single argument is passed to\nthe setter then the following two calls are identical:</p>\n\n<pre><code>// this call...\nproduct.setCategory(10);\n\n// is equivalent to this call:\nproduct.set('category_id', 10);\n</code></pre>\n\n<p>An instance of the owner model can also be passed as a parameter.</p>\n\n<p>If we pass in a second argument, the model will be automatically saved and the second argument passed to\nthe owner model's <a href=\"#!/api/Ext.data.Model-method-save\" rel=\"Ext.data.Model-method-save\" class=\"docClass\">save</a> method:</p>\n\n<pre><code>product.setCategory(10, function(product, operation) {\n    // the product has been saved\n    alert(product.get('category_id')); //now alerts 10\n});\n\n//alternative syntax:\nproduct.setCategory(10, {\n    callback: function(product, operation), // a function that will always be called\n    success : function(product, operation), // a function that will only be called if the load succeeded\n    failure : function(product, operation), // a function that will only be called if the load did not succeed\n    scope   : this //optionally pass in a scope object to execute the callbacks in\n})\n</code></pre>\n\n<h2>Customisation</h2>\n\n<p>Associations reflect on the models they are linking to automatically set up properties such as the\n<a href=\"#!/api/Ext.data.association.BelongsTo-cfg-primaryKey\" rel=\"Ext.data.association.BelongsTo-cfg-primaryKey\" class=\"docClass\">primaryKey</a> and <a href=\"#!/api/Ext.data.association.BelongsTo-cfg-foreignKey\" rel=\"Ext.data.association.BelongsTo-cfg-foreignKey\" class=\"docClass\">foreignKey</a>. These can alternatively be specified:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Product', {\n    fields: [...],\n\n    associations: [\n        { type: 'belongsTo', model: 'Category', primaryKey: 'unique_id', foreignKey: 'cat_id' }\n    ]\n});\n</code></pre>\n\n<p>Here we replaced the default primary key (defaults to 'id') and foreign key (calculated as 'category_id')\nwith our own settings. Usually this will not be needed.</p>\n","!type":"fn(config?: ?)","prototype":{"foreignKey":{"!type":"string","!doc":"<p>The name of the foreign key on the owner model that links it to the associated\nmodel. Defaults to the lowercased name of the associated model plus \"_id\", e.g. an association with a\nmodel called Product would set up a product_id foreign key.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Order', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'date'],\n    hasMany: 'Product'\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Product', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'order_id'], // refers to the id of the order that this product belongs to\n    belongsTo: 'Order'\n});\nvar product = new Product({\n    id: 1,\n    name: 'Product 1',\n    order_id: 22\n}, 1);\nproduct.getOrder(); // Will make a call to the server asking for order_id 22\n</code></pre>\n"},"getterName":{"!type":"string","!doc":"<p>The name of the getter function that will be added to the local model's prototype.\nDefaults to 'get' + the name of the foreign model, e.g. getCategory</p>\n"},"setterName":{"!type":"string","!doc":"<p>The name of the setter function that will be added to the local model's prototype.\nDefaults to 'set' + the name of the foreign model, e.g. setCategory</p>\n"},"type":{"!type":"string","!doc":"<p>The type configuration can be used when creating associations using a configuration object.\nUse 'belongsTo' to create a BelongsTo association.</p>\n\n<pre><code>associations: [{\n    type: 'belongsTo',\n    model: 'User'\n}]\n</code></pre>\n"},"createGetter":{"!type":"fn() -> ?","!doc":"<p>Returns a getter function to be placed on the owner model's prototype. We cache the loaded instance\nthe first time it is loaded so that subsequent calls to the getter always receive the same reference.</p>\n"},"createSetter":{"!type":"fn() -> ?","!doc":"<p>Returns a setter function to be placed on the owner model's prototype</p>\n"},"read":{"!type":"fn(record: ?, reader: ?, associationData: ?) -> !this","!doc":"<p>Read associated data</p>\n"}}},"HasMany":{"!doc":"<p>Represents a one-to-many relationship between two models. Usually created indirectly via a model definition:</p>\n\n\n\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Product', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'id',      type: 'int'},\n        {name: 'user_id', type: 'int'},\n        {name: 'name',    type: 'string'}\n    ]\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'id',   type: 'int'},\n        {name: 'name', type: 'string'}\n    ],\n    // we can use the hasMany shortcut on the model to create a hasMany association\n    hasMany: {model: 'Product', name: 'products'}\n});\n</code></pre>\n\n\n\n\n<p>Above we created Product and User models, and linked them by saying that a User hasMany Products. This gives\nus a new function on every User instance, in this case the function is called 'products' because that is the name\nwe specified in the association configuration above.</p>\n\n\n\n\n<p>This new function returns a specialized <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> which is automatically filtered to load\nonly Products for the given model instance:</p>\n\n\n\n\n<pre><code>//first, we load up a User with id of 1\nvar user = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {id: 1, name: 'Ed'});\n\n//the user.products function was created automatically by the association and returns a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>\n//the created store is automatically scoped to the set of Products for the User with id of 1\nvar products = user.products();\n\n//we still have all of the usual Store functions, for example it's easy to add a Product for this User\nproducts.add({\n    name: 'Another Product'\n});\n\n//saves the changes to the store - this automatically sets the new Product's user_id to 1 before saving\nproducts.sync();\n</code></pre>\n\n\n\n\n<p>The new Store is only instantiated the first time you call products() to conserve memory and processing time,\nthough calling products() a second time returns the same store instance.</p>\n\n\n\n\n<p><u>Custom filtering</u></p>\n\n\n\n\n<p>The Store is automatically furnished with a filter - by default this filter tells the store to only return\nrecords where the associated model's foreign key matches the owner model's primary key. For example, if a User\nwith ID = 100 hasMany Products, the filter loads only Products with user_id == 100.</p>\n\n\n\n\n<p>Sometimes we want to filter by another field - for example in the case of a Twitter search application we may\nhave models for Search and Tweet:</p>\n\n\n\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Search', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        'id', 'query'\n    ],\n\n    hasMany: {\n        model: 'Tweet',\n        name : 'tweets',\n        filterProperty: 'query'\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Tweet', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        'id', 'text', 'from_user'\n    ]\n});\n\n//returns a Store filtered by the filterProperty\nvar store = new Search({query: 'Sencha Touch'}).tweets();\n</code></pre>\n\n\n\n\n<p>The tweets association above is filtered by the query property by setting the <a href=\"#!/api/Ext.data.association.HasMany-cfg-filterProperty\" rel=\"Ext.data.association.HasMany-cfg-filterProperty\" class=\"docClass\">filterProperty</a>, and is\nequivalent to this:</p>\n\n\n\n\n<pre><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'Tweet',\n    filters: [\n        {\n            property: 'query',\n            value   : 'Sencha Touch'\n        }\n    ]\n});\n</code></pre>\n\n","!type":"fn(config?: ?)","prototype":{"autoLoad":{"!type":"bool","!doc":"<p>True to automatically load the related store from a remote source when instantiated.\nDefaults to <tt>false</tt>.</p>\n"},"filterProperty":{"!type":"string","!doc":"<p>Optionally overrides the default filter that is set up on the associated Store. If\nthis is not set, a filter is automatically created which filters the association based on the configured\n<a href=\"#!/api/Ext.data.association.HasMany-cfg-foreignKey\" rel=\"Ext.data.association.HasMany-cfg-foreignKey\" class=\"docClass\">foreignKey</a>. See intro docs for more details. Defaults to undefined</p>\n"},"foreignKey":{"!type":"string","!doc":"<p>The name of the foreign key on the associated model that links it to the owner\nmodel. Defaults to the lowercased name of the owner model plus \"_id\", e.g. an association with a where a\nmodel called Group hasMany Users would create 'group_id' as the foreign key. When the remote store is loaded,\nthe store is automatically filtered so that only records with a matching foreign key are included in the\nresulting child store. This can be overridden by specifying the <a href=\"#!/api/Ext.data.association.HasMany-cfg-filterProperty\" rel=\"Ext.data.association.HasMany-cfg-filterProperty\" class=\"docClass\">filterProperty</a>.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Group', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name'],\n    hasMany: 'User'\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'group_id'], // refers to the id of the group that this user belongs to\n    belongsTo: 'Group'\n});\n</code></pre>\n\n"},"name":{"!type":"string","!doc":"<p>The name of the function to create on the owner model to retrieve the child store.\nIf not specified, the pluralized name of the child model is used.</p>\n\n<pre><code>// This will create a users() method on any Group model instance\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Group', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name'],\n    hasMany: 'User'\n});\nvar group = new Group();\nconsole.log(group.users());\n\n// The method to retrieve the users will now be getUserList\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Group', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name'],\n    hasMany: {model: 'User', name: 'getUserList'}\n});\nvar group = new Group();\nconsole.log(group.getUserList());\n</code></pre>\n\n"},"storeConfig":{"!doc":"<p>Optional configuration object that will be passed to the generated Store. Defaults to\nundefined.</p>\n"},"type":{"!type":"string","!doc":"<p>The type configuration can be used when creating associations using a configuration object.\nUse 'hasMany' to create a HasMany association</p>\n\n<pre><code>associations: [{\n    type: 'hasMany',\n    model: 'User'\n}]\n</code></pre>\n\n"},"createStore":{"!type":"fn() -> ?","!doc":"<p>Creates a function that returns an <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> which is configured to load a set of data filtered\nby the owner model's primary key - e.g. in a hasMany association where Group hasMany Users, this function\nreturns a Store configured to return the filtered set of a single Group's Users.</p>\n"},"read":{"!type":"fn(record: ?, reader: ?, associationData: ?) -> !this","!doc":"<p>Read associated data</p>\n"}}},"HasOne":{"!doc":"<p>Represents a one to one association with another model. The owner model is expected to have\na foreign key which references the primary key of the associated model:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Address', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        { name: 'id',          type: 'int' },\n        { name: 'number', type: 'string' },\n        { name: 'street', type: 'string' },\n        { name: 'city', type: 'string' },\n        { name: 'zip', type: 'string' },\n    ]\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Person', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        { name: 'id',   type: 'int' },\n        { name: 'name', type: 'string' },\n        { name: 'address_id', type: 'int'}\n    ],\n    // we can use the hasOne shortcut on the model to create a hasOne association\n    associations: [{ type: 'hasOne', model: 'Address' }]\n});\n</code></pre>\n\n<p>In the example above we have created models for People and Addresses, and linked them together\nby saying that each Person has a single Address. This automatically links each Person to an Address\nbased on the Persons address_id, and provides new functions on the Person model:</p>\n\n<h2>Generated getter function</h2>\n\n<p>The first function that is added to the owner model is a getter function:</p>\n\n<pre><code>var person = new Person({\n    id: 100,\n    address_id: 20,\n    name: 'John Smith'\n});\n\nperson.getAddress(function(address, operation) {\n    // do something with the address object\n    alert(address.get('id')); // alerts 20\n}, this);\n</code></pre>\n\n<p>The getAddress function was created on the Person model when we defined the association. This uses the\nPersons configured <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">proxy</a> to load the Address asynchronously, calling the provided\ncallback when it has loaded.</p>\n\n<p>The new getAddress function will also accept an object containing success, failure and callback properties\n- callback will always be called, success will only be called if the associated model was loaded successfully\nand failure will only be called if the associatied model could not be loaded:</p>\n\n<pre><code>person.getAddress({\n    reload: true, // force a reload if the owner model is already cached\n    callback: function(address, operation) {}, // a function that will always be called\n    success : function(address, operation) {}, // a function that will only be called if the load succeeded\n    failure : function(address, operation) {}, // a function that will only be called if the load did not succeed\n    scope   : this // optionally pass in a scope object to execute the callbacks in\n});\n</code></pre>\n\n<p>In each case above the callbacks are called with two arguments - the associated model instance and the\n<a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">operation</a> object that was executed to load that instance. The Operation object is\nuseful when the instance could not be loaded.</p>\n\n<p>Once the getter has been called on the model, it will be cached if the getter is called a second time. To\nforce the model to reload, specify reload: true in the options object.</p>\n\n<h2>Generated setter function</h2>\n\n<p>The second generated function sets the associated model instance - if only a single argument is passed to\nthe setter then the following two calls are identical:</p>\n\n<pre><code>// this call...\nperson.setAddress(10);\n\n// is equivalent to this call:\nperson.set('address_id', 10);\n</code></pre>\n\n<p>An instance of the owner model can also be passed as a parameter.</p>\n\n<p>If we pass in a second argument, the model will be automatically saved and the second argument passed to\nthe owner model's <a href=\"#!/api/Ext.data.Model-method-save\" rel=\"Ext.data.Model-method-save\" class=\"docClass\">save</a> method:</p>\n\n<pre><code>person.setAddress(10, function(address, operation) {\n    // the address has been saved\n    alert(address.get('address_id')); //now alerts 10\n});\n\n//alternative syntax:\nperson.setAddress(10, {\n    callback: function(address, operation), // a function that will always be called\n    success : function(address, operation), // a function that will only be called if the load succeeded\n    failure : function(address, operation), // a function that will only be called if the load did not succeed\n    scope   : this //optionally pass in a scope object to execute the callbacks in\n})\n</code></pre>\n\n<h2>Customisation</h2>\n\n<p>Associations reflect on the models they are linking to automatically set up properties such as the\n<a href=\"#!/api/Ext.data.association.HasOne-cfg-primaryKey\" rel=\"Ext.data.association.HasOne-cfg-primaryKey\" class=\"docClass\">primaryKey</a> and <a href=\"#!/api/Ext.data.association.HasOne-cfg-foreignKey\" rel=\"Ext.data.association.HasOne-cfg-foreignKey\" class=\"docClass\">foreignKey</a>. These can alternatively be specified:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Person', {\n    fields: [...],\n\n    associations: [\n        { type: 'hasOne', model: 'Address', primaryKey: 'unique_id', foreignKey: 'addr_id' }\n    ]\n});\n</code></pre>\n\n<p>Here we replaced the default primary key (defaults to 'id') and foreign key (calculated as 'address_id')\nwith our own settings. Usually this will not be needed.</p>\n","!type":"fn(config?: ?)","prototype":{"foreignKey":{"!type":"string","!doc":"<p>The name of the foreign key on the owner model that links it to the associated\nmodel. Defaults to the lowercased name of the associated model plus \"_id\", e.g. an association with a\nmodel called Person would set up a address_id foreign key.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Person', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'address_id'], // refers to the id of the address object\n    hasOne: 'Address'\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Address', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'number', 'street', 'city', 'zip'], \n    belongsTo: 'Person'\n});\nvar Person = new Person({\n    id: 1,\n    name: 'John Smith',\n    address_id: 13\n}, 1);\nperson.getAddress(); // Will make a call to the server asking for address_id 13\n</code></pre>\n"},"getterName":{"!type":"string","!doc":"<p>The name of the getter function that will be added to the local model's prototype.\nDefaults to 'get' + the name of the foreign model, e.g. getAddress</p>\n"},"setterName":{"!type":"string","!doc":"<p>The name of the setter function that will be added to the local model's prototype.\nDefaults to 'set' + the name of the foreign model, e.g. setAddress</p>\n"},"type":{"!type":"string","!doc":"<p>The type configuration can be used when creating associations using a configuration object.\nUse 'hasOne' to create a HasOne association.</p>\n\n<pre><code>associations: [{\n    type: 'hasOne',\n    model: 'Address'\n}]\n</code></pre>\n"},"createGetter":{"!type":"fn() -> ?","!doc":"<p>Returns a getter function to be placed on the owner model's prototype. We cache the loaded instance\nthe first time it is loaded so that subsequent calls to the getter always receive the same reference.</p>\n"},"createSetter":{"!type":"fn() -> ?","!doc":"<p>Returns a setter function to be placed on the owner model's prototype</p>\n"},"read":{"!type":"fn(record: ?, reader: ?, associationData: ?) -> !this","!doc":"<p>Read associated data</p>\n"}}}},"Batch":{"!doc":"<p>Provides a mechanism to run one or more <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">operations</a> in a given order. Fires the 'operationcomplete' event\nafter the completion of each Operation, and the 'complete' event when all Operations have been successfully executed. Fires an 'exception'\nevent if any of the Operations encounter an exception.</p>\n\n\n\n\n<p>Usually these are only used internally by <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Ext.data.proxy.Proxy</a> classes</p>\n\n","!type":"fn(config?: ?)","prototype":{"autoStart":{"!type":"bool","!doc":"<p>True to immediately start processing the batch as soon as it is constructed (defaults to false)</p>\n"},"pauseOnException":{"!type":"bool","!doc":"<p>True to pause the execution of the batch if any operation encounters an exception\n(defaults to false). If you set this to true you are responsible for implementing the appropriate\nhandling logic and restarting or discarding the batch as needed. There are different ways you could\ndo this, e.g. by handling the batch's <a href=\"#!/api/Ext.data.Batch-event-exception\" rel=\"Ext.data.Batch-event-exception\" class=\"docClass\">exception</a> event directly, or perhaps by overriding\n<a href=\"#!/api/Ext.data.AbstractStore-method-onBatchException\" rel=\"Ext.data.AbstractStore-method-onBatchException\" class=\"docClass\">onBatchException</a> at the store level. If you do pause\nand attempt to handle the exception you can call <a href=\"#!/api/Ext.data.Batch-method-retry\" rel=\"Ext.data.Batch-method-retry\" class=\"docClass\">retry</a> to process the same operation again.</p>\n\n<p>Note that <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">operations</a> are atomic, so any operations that may have succeeded\nprior to an exception (and up until pausing the batch) will be finalized at the server level and will\nnot be automatically reversible. Any transactional / rollback behavior that might be desired would have\nto be implemented at the application level. Pausing on exception will likely be most beneficial when\nused in coordination with such a scheme, where an exception might actually affect subsequent operations\nin the same batch and so should be handled before continuing with the next operation.</p>\n\n<p>If you have not implemented transactional operation handling then this option should typically be left\nto the default of false (e.g. process as many operations as possible, and handle any exceptions\nasynchronously without holding up the rest of the batch).</p>\n"},"current":{"!type":"number","!doc":"<p>The index of the current operation being executed. Read only</p>\n"},"exceptions":{"!doc":"<p>Ordered array of operations that raised an exception during the most recent\nbatch execution and did not successfully complete</p>\n"},"hasException":{"!type":"bool","!doc":"<p>True if this batch has encountered an exception. This is cleared at the start of each operation. Read only</p>\n"},"isComplete":{"!type":"bool","!doc":"<p>True if this batch has been executed completely. Read only</p>\n"},"isRunning":{"!type":"bool","!doc":"<p>True if the batch is currently running. Read only</p>\n"},"operations":{"!doc":"<p>Ordered array of operations that will be executed by this batch</p>\n"},"total":{"!type":"number","!doc":"<p>The total number of operations in this batch. Read only</p>\n"},"add":{"!type":"fn(operation: ?) -> ?","!doc":"<p>Adds a new operation to this batch at the end of the <a href=\"#!/api/Ext.data.Batch-property-operations\" rel=\"Ext.data.Batch-property-operations\" class=\"docClass\">operations</a> array</p>\n"},"pause":{"!type":"fn() -> ?","!doc":"<p>Pauses execution of the batch, but does not cancel the current operation</p>\n"},"retry":{"!type":"fn() -> ?","!doc":"<p>Kicks off execution of the batch, continuing from the current operation. This is intended\nfor restarting a <a href=\"#!/api/Ext.data.Batch-method-pause\" rel=\"Ext.data.Batch-method-pause\" class=\"docClass\">paused</a> batch after an exception, and the operation that raised\nthe exception will now be retried. The batch will then continue with its normal processing until\nall operations are complete or another exception is encountered.</p>\n\n<p>Note that if the batch is already running any call to retry will be ignored.</p>\n"},"runNextOperation":{"!type":"fn() -> ?","!doc":"<p>Runs the next operation, relative to this.current.</p>\n"},"runOperation":{"!type":"fn(index: ?) -> ?","!doc":"<p>Executes an operation by its numeric index in the <a href=\"#!/api/Ext.data.Batch-property-operations\" rel=\"Ext.data.Batch-property-operations\" class=\"docClass\">operations</a> array</p>\n"},"start":{"!type":"fn(index: ?) -> ?","!doc":"<p>Kicks off execution of the batch, continuing from the next operation if the previous\noperation encountered an exception, or if execution was paused. Use this method to start\nthe batch for the first time or to restart a paused batch by skipping the current\nunsuccessful operation.</p>\n\n<p>To retry processing the current operation before continuing to the rest of the batch (e.g.\nbecause you explicitly handled the operation's exception), call <a href=\"#!/api/Ext.data.Batch-method-retry\" rel=\"Ext.data.Batch-method-retry\" class=\"docClass\">retry</a> instead.</p>\n\n<p>Note that if the batch is already running any call to start will be ignored.</p>\n"},"complete":{"!type":"fn(batch: ?, operation: ?, eOpts: ?)","!doc":"<p>Fired when all operations of this batch have been completed</p>\n"},"exception":{"!type":"fn(batch: ?, operation: ?, eOpts: ?)","!doc":"<p>Fired when a operation encountered an exception</p>\n"},"operationcomplete":{"!type":"fn(batch: ?, operation: ?, eOpts: ?)","!doc":"<p>Fired when each operation of the batch completes</p>\n"}}},"BufferStore":{"!type":"fn()","prototype":{"filterOnLoad":{"!type":"bool","!doc":"<p>If true, any filters attached to this Store will be run after loading data, before the datachanged event is fired.\nDefaults to true, ignored if <a href=\"#!/api/Ext.data.Store-cfg-remoteFilter\" rel=\"Ext.data.Store-cfg-remoteFilter\" class=\"docClass\">remoteFilter</a> is true</p>\n"},"sortOnLoad":{"!type":"bool","!doc":"<p>If true, any sorters attached to this Store will be run after loading data, before the datachanged event is fired.\nDefaults to true, igored if <a href=\"#!/api/Ext.data.Store-cfg-remoteSort\" rel=\"Ext.data.Store-cfg-remoteSort\" class=\"docClass\">remoteSort</a> is true</p>\n"}}},"DirectStore":{"!doc":"<p>Small helper class to create an <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> configured with an <a href=\"#!/api/Ext.data.proxy.Direct\" rel=\"Ext.data.proxy.Direct\" class=\"docClass\">Ext.data.proxy.Direct</a>\nand <a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">Ext.data.reader.Json</a> to make interacting with an <a href=\"#!/api/Ext.direct.Manager\" rel=\"Ext.direct.Manager\" class=\"docClass\">Ext.direct.Manager</a> server-side\n<a href=\"#!/api/Ext.direct.Provider\" rel=\"Ext.direct.Provider\" class=\"docClass\">Provider</a> easier. To create a different proxy/reader combination create a basic\n<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> configured as needed.</p>\n\n<p><strong>Note:</strong> Although they are not listed, this class inherits all of the config options of:</p>\n\n<ul>\n<li><p><strong><a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a></strong></p></li>\n<li><p><strong><a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">JsonReader</a></strong></p>\n\n<ul>\n<li><strong><a href=\"#!/api/Ext.data.reader.Json-cfg-root\" rel=\"Ext.data.reader.Json-cfg-root\" class=\"docClass\">root</a></strong></li>\n<li><strong><a href=\"#!/api/Ext.data.reader.Json-cfg-idProperty\" rel=\"Ext.data.reader.Json-cfg-idProperty\" class=\"docClass\">idProperty</a></strong></li>\n<li><strong><a href=\"#!/api/Ext.data.reader.Json-cfg-totalProperty\" rel=\"Ext.data.reader.Json-cfg-totalProperty\" class=\"docClass\">totalProperty</a></strong></li>\n</ul>\n</li>\n<li><p><strong><a href=\"#!/api/Ext.data.proxy.Direct\" rel=\"Ext.data.proxy.Direct\" class=\"docClass\">DirectProxy</a></strong></p>\n\n<ul>\n<li><strong><a href=\"#!/api/Ext.data.proxy.Direct-cfg-directFn\" rel=\"Ext.data.proxy.Direct-cfg-directFn\" class=\"docClass\">directFn</a></strong></li>\n<li><strong><a href=\"#!/api/Ext.data.proxy.Direct-cfg-paramOrder\" rel=\"Ext.data.proxy.Direct-cfg-paramOrder\" class=\"docClass\">paramOrder</a></strong></li>\n<li><strong><a href=\"#!/api/Ext.data.proxy.Direct-cfg-paramsAsHash\" rel=\"Ext.data.proxy.Direct-cfg-paramsAsHash\" class=\"docClass\">paramsAsHash</a></strong></li>\n</ul>\n</li>\n</ul>\n\n","!type":"fn(config: ?)"},"Errors":{"!doc":"<p>Wraps a collection of validation error responses and provides convenient functions for\naccessing and errors for specific fields.</p>\n\n\n\n\n<p>Usually this class does not need to be instantiated directly - instances are instead created\nautomatically when <a href=\"#!/api/Ext.data.Model-method-validate\" rel=\"Ext.data.Model-method-validate\" class=\"docClass\">validate</a> on a model instance:</p>\n\n\n\n\n<pre><code>//validate some existing model instance - in this case it returned 2 failures messages\nvar errors = myModel.validate();\n\nerrors.isValid(); //false\n\nerrors.length; //2\nerrors.getByField('name');  // [{field: 'name',  message: 'must be present'}]\nerrors.getByField('title'); // [{field: 'title', message: 'is too short'}]\n</code></pre>\n\n","!type":"fn(config: ?)","prototype":{"getByField":{"!type":"fn(fieldName: ?) -> ?","!doc":"<p>Returns all of the errors for the given field</p>\n"},"isValid":{"!type":"fn() -> bool","!doc":"<p>Returns true if there are no errors in the collection</p>\n"}}},"Field":{"!doc":"<p>Fields are used to define what a Model is. They aren't instantiated directly - instead, when we create a class that\nextends <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>, it will automatically create a Field instance for each field configured in a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a>. For example, we might set up a model like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        'name', 'email',\n        {name: 'age', type: 'int'},\n        {name: 'gender', type: 'string', defaultValue: 'Unknown'}\n    ]\n});\n</code></pre>\n\n<p>Four fields will have been created for the User Model - name, email, age and gender. Note that we specified a couple\nof different formats here; if we only pass in the string name of the field (as with name and email), the field is set\nup with the 'auto' type. It's as if we'd done this instead:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'name', type: 'auto'},\n        {name: 'email', type: 'auto'},\n        {name: 'age', type: 'int'},\n        {name: 'gender', type: 'string', defaultValue: 'Unknown'}\n    ]\n});\n</code></pre>\n\n<h1>Types and conversion</h1>\n\n<p>The <a href=\"#!/api/Ext.data.Field-cfg-type\" rel=\"Ext.data.Field-cfg-type\" class=\"docClass\">type</a> is important - it's used to automatically convert data passed to the field into the correct format.\nIn our example above, the name and email fields used the 'auto' type and will just accept anything that is passed\ninto them. The 'age' field had an 'int' type however, so if we passed 25.4 this would be rounded to 25.</p>\n\n<p>Sometimes a simple type isn't enough, or we want to perform some processing when we load a Field's data. We can do\nthis using a <a href=\"#!/api/Ext.data.Field-cfg-convert\" rel=\"Ext.data.Field-cfg-convert\" class=\"docClass\">convert</a> function. Here, we're going to create a new field based on another:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {\n            name: 'firstName',\n            convert: function(value, record) {\n                var fullName  = record.get('name'),\n                    splits    = fullName.split(\" \"),\n                    firstName = splits[0];\n\n                return firstName;\n            }\n        },\n        'name', 'email',\n        {name: 'age', type: 'int'},\n        {name: 'gender', type: 'string', defaultValue: 'Unknown'}\n    ]\n});\n</code></pre>\n\n<p>Now when we create a new User, the firstName is populated automatically based on the name:</p>\n\n<pre><code>var ed = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {name: 'Ed Spencer'});\n\nconsole.log(ed.get('firstName')); //logs 'Ed', based on our convert function\n</code></pre>\n\n<p>Fields which are configured with a custom <code>convert</code> function are read <em>after</em> all other fields\nwhen constructing and reading records, so that if convert functions rely on other, non-converted fields\n(as in this example), they can be sure of those fields being present.</p>\n\n<p>In fact, if we log out all of the data inside ed, we'll see this:</p>\n\n<pre><code>console.log(ed.data);\n\n//outputs this:\n{\n    age: 0,\n    email: \"\",\n    firstName: \"Ed\",\n    gender: \"Unknown\",\n    name: \"Ed Spencer\"\n}\n</code></pre>\n\n<p>The age field has been given a default of zero because we made it an int type. As an auto field, email has defaulted\nto an empty string. When we registered the User model we set gender's <a href=\"#!/api/Ext.data.Field-cfg-defaultValue\" rel=\"Ext.data.Field-cfg-defaultValue\" class=\"docClass\">defaultValue</a> to 'Unknown' so we see\nthat now. Let's correct that and satisfy ourselves that the types work as we expect:</p>\n\n<pre><code>ed.set('gender', 'Male');\ned.get('gender'); //returns 'Male'\n\ned.set('age', 25.4);\ned.get('age'); //returns 25 - we wanted an int, not a float, so no decimal places allowed\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"allowBlank":{"!type":"bool","!doc":"<p>Used for validating a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model</a>. Defaults to true. An empty value here will cause\n<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>.<a href=\"#!/api/Ext.data.Model-method-isValid\" rel=\"Ext.data.Model-method-isValid\" class=\"docClass\">isValid</a> to evaluate to false.</p>\n"},"convert":{"!doc":"<p>A function which converts the value provided by the Reader into an object that will be stored in the Model.</p>\n\n<p>If configured as <code>null</code>, then no conversion will be applied to the raw data property when this Field\nis read. This will increase performance. but you must ensure that the data is of the correct type and does\nnot <em>need</em> converting.</p>\n\n<p>It is passed the following parameters:</p>\n\n<ul>\n<li><p><strong>v</strong> : Mixed</p>\n\n<p>The data value as read by the Reader, if undefined will use the configured <code><a href=\"#!/api/Ext.data.Field-cfg-defaultValue\" rel=\"Ext.data.Field-cfg-defaultValue\" class=\"docClass\">defaultValue</a></code>.</p></li>\n<li><p><strong>rec</strong> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></p>\n\n<p>The data object containing the Model as read so far by the Reader. Note that the Model may not be fully populated\nat this point as the fields are read in the order that they are defined in your\n<a href=\"#!/api/Ext.data.Model-cfg-fields\" rel=\"Ext.data.Model-cfg-fields\" class=\"docClass\">fields</a> array.</p></li>\n</ul>\n\n\n<p>Example of convert functions:</p>\n\n<pre><code>function fullName(v, record){\n    return record.data.last + ', ' + record.data.first;\n}\n\nfunction location(v, record){\n    return !record.data.city ? '' : (record.data.city + ', ' + record.data.state);\n}\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Dude', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'fullname',  convert: fullName},\n        {name: 'firstname', mapping: 'name.first'},\n        {name: 'lastname',  mapping: 'name.last'},\n        {name: 'city', defaultValue: 'homeless'},\n        'state',\n        {name: 'location',  convert: location}\n    ]\n});\n\n// create the data store\nvar store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    reader: {\n        type: 'json',\n        model: 'Dude',\n        idProperty: 'key',\n        root: 'daRoot',\n        totalProperty: 'total'\n    }\n});\n\nvar myData = [\n    { key: 1,\n      name: { first: 'Fat',    last:  'Albert' }\n      // notice no city, state provided in data object\n    },\n    { key: 2,\n      name: { first: 'Barney', last:  'Rubble' },\n      city: 'Bedrock', state: 'Stoneridge'\n    },\n    { key: 3,\n      name: { first: 'Cliff',  last:  'Claven' },\n      city: 'Boston',  state: 'MA'\n    }\n];\n</code></pre>\n"},"dateFormat":{"!type":"string","!doc":"<p>Serves as a default for the <a href=\"#!/api/Ext.data.Field-cfg-dateReadFormat\" rel=\"Ext.data.Field-cfg-dateReadFormat\" class=\"docClass\">dateReadFormat</a> and <a href=\"#!/api/Ext.data.Field-cfg-dateWriteFormat\" rel=\"Ext.data.Field-cfg-dateWriteFormat\" class=\"docClass\">dateWriteFormat</a> config options. This\nwill be used in place of those other configurations if not specified.</p>\n\n<p>A format string for the <a href=\"#!/api/Ext.Date-method-parse\" rel=\"Ext.Date-method-parse\" class=\"docClass\">Ext.Date.parse</a> function, or \"timestamp\" if the value provided by\nthe Reader is a UNIX timestamp, or \"time\" if the value provided by the Reader is a javascript millisecond\ntimestamp. See <a href=\"#!/api/Ext.Date\" rel=\"Ext.Date\" class=\"docClass\">Ext.Date</a>.</p>\n\n<p>It is quite important to note that while this config is optional, it will default to using the base\nJavaScript Date object's <code>parse</code> function if not specified, rather than <a href=\"#!/api/Ext.Date-method-parse\" rel=\"Ext.Date-method-parse\" class=\"docClass\">Ext.Date.parse</a>.\nThis can cause unexpected issues, especially when converting between timezones, or when converting dates that\ndo not have a timezone specified. The behavior of the native <code>Date.parse</code> is implementation-specific, and\ndepending on the value of the date string, it might return the UTC date or the local date. <strong>For this reason\nit is strongly recommended that you always specify an explicit date format when parsing dates.</strong></p>\n"},"dateReadFormat":{"!type":"string","!doc":"<p>Used when converting received data into a Date when the <a href=\"#!/api/Ext.data.Field-cfg-type\" rel=\"Ext.data.Field-cfg-type\" class=\"docClass\">type</a> is specified as <code>\"date\"</code>.\nThis configuration takes precedence over <a href=\"#!/api/Ext.data.Field-cfg-dateFormat\" rel=\"Ext.data.Field-cfg-dateFormat\" class=\"docClass\">dateFormat</a>.\nSee <a href=\"#!/api/Ext.data.Field-cfg-dateFormat\" rel=\"Ext.data.Field-cfg-dateFormat\" class=\"docClass\">dateFormat</a> for more information.</p>\n"},"dateWriteFormat":{"!type":"string","!doc":"<p>Used to provide a custom format when serializing dates with a <a href=\"#!/api/Ext.data.writer.Writer\" rel=\"Ext.data.writer.Writer\" class=\"docClass\">Ext.data.writer.Writer</a>.\nIf this is not specified, the <a href=\"#!/api/Ext.data.Field-cfg-dateFormat\" rel=\"Ext.data.Field-cfg-dateFormat\" class=\"docClass\">dateFormat</a> will be used. See the <a href=\"#!/api/Ext.data.writer.Writer\" rel=\"Ext.data.writer.Writer\" class=\"docClass\">Ext.data.writer.Writer</a>\ndocs for more information on writing dates.</p>\n\n<p><strong>Note that to use a <a href=\"#!/api/Ext.data.writer.Json\" rel=\"Ext.data.writer.Json\" class=\"docClass\">JsonWriter</a> to send Microsoft format \"JSON\" dates, which are in fact\ninvalid JSON, it is not possible to use the standard date serialization pathway or\n<a href=\"#!/api/Ext-property-USE_NATIVE_JSON\" rel=\"Ext-property-USE_NATIVE_JSON\" class=\"docClass\">native browser JSON production</a>.</strong></p>\n\n<p>To use a <a href=\"#!/api/Ext.data.writer.Json\" rel=\"Ext.data.writer.Json\" class=\"docClass\">JsonWriter</a> to write dates in a JSON packet in the form <code>\"\\/Date(1357372800000)\\/\"</code>\nconfigure the field like this:</p>\n\n<p>   {\n       type: 'date',\n       dateFormat: 'MS',             // To parse incoming dates from server correctly\n       serialize: <a href=\"#!/api/Ext-method-identityFn\" rel=\"Ext-method-identityFn\" class=\"docClass\">Ext.identityFn</a>     // An ExtJS-supplied function which returns the arg unchanged\n   }</p>\n\n<p>Then override ExtJS's JSON date serialize function:</p>\n\n<p>   <a href=\"#!/api/Ext.JSON-method-encodeDate\" rel=\"Ext.JSON-method-encodeDate\" class=\"docClass\">Ext.JSON.encodeDate</a> = function (d) {\n       return '\"' + <a href=\"#!/api/Ext.Date-method-format\" rel=\"Ext.Date-method-format\" class=\"docClass\">Ext.Date.format</a>(d, 'MS') + '\"';\n   };</p>\n"},"defaultValue":{"!doc":"<p>The default value used when the creating an instance from a raw data object, and the property referenced by the\n<code><a href=\"#!/api/Ext.data.Field-cfg-mapping\" rel=\"Ext.data.Field-cfg-mapping\" class=\"docClass\">mapping</a></code> does not exist in that data object.</p>\n\n<p>May be specified as <code>undefined</code> to prevent defaulting in a value.</p>\n"},"mapping":{"!doc":"<p>(Optional) A path expression for use by the <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a> implementation that is creating the\n<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> to extract the Field value from the data object. If the path expression is the same\nas the field name, the mapping may be omitted.</p>\n\n<p>The form of the mapping expression depends on the Reader being used.</p>\n\n<ul>\n<li><p><a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">Ext.data.reader.Json</a></p>\n\n<p>The mapping is a string containing the javascript expression to reference the data from an element of the data\nitem's <a href=\"#!/api/Ext.data.reader.Json-cfg-root\" rel=\"Ext.data.reader.Json-cfg-root\" class=\"docClass\">root</a> Array. Defaults to the field name.</p></li>\n<li><p><a href=\"#!/api/Ext.data.reader.Xml\" rel=\"Ext.data.reader.Xml\" class=\"docClass\">Ext.data.reader.Xml</a></p>\n\n<p>The mapping is an <a href=\"#!/api/Ext.dom.Query\" rel=\"Ext.dom.Query\" class=\"docClass\">Ext.DomQuery</a> path to the data item relative to the DOM element that represents the\n<a href=\"#!/api/Ext.data.reader.Xml-cfg-record\" rel=\"Ext.data.reader.Xml-cfg-record\" class=\"docClass\">record</a>. Defaults to the field name.</p></li>\n<li><p><a href=\"#!/api/Ext.data.reader.Array\" rel=\"Ext.data.reader.Array\" class=\"docClass\">Ext.data.reader.Array</a></p>\n\n<p>The mapping is a number indicating the Array index of the field's value. Defaults to the field specification's\nArray position.</p></li>\n</ul>\n\n\n<p>If a more complex value extraction strategy is required, then configure the Field with a <a href=\"#!/api/Ext.data.Field-cfg-convert\" rel=\"Ext.data.Field-cfg-convert\" class=\"docClass\">convert</a>\nfunction. This is passed the whole row object, and may interrogate it in whatever way is necessary in order to\nreturn the desired data.</p>\n"},"name":{"!type":"string","!doc":"<p>The name by which the field is referenced within the Model. This is referenced by, for example, the <code>dataIndex</code>\nproperty in column definition objects passed to <a href=\"#!/api/Ext.grid.property.HeaderContainer\" rel=\"Ext.grid.property.HeaderContainer\" class=\"docClass\">Ext.grid.property.HeaderContainer</a>.</p>\n\n<p>Note: In the simplest case, if no properties other than <code>name</code> are required, a field definition may consist of\njust a String for the field name.</p>\n"},"persist":{"!type":"bool","!doc":"<p>False to exclude this field from the <a href=\"#!/api/Ext.data.Model-property-modified\" rel=\"Ext.data.Model-property-modified\" class=\"docClass\">Ext.data.Model.modified</a> fields in a model. This will also exclude\nthe field from being written using a <a href=\"#!/api/Ext.data.writer.Writer\" rel=\"Ext.data.writer.Writer\" class=\"docClass\">Ext.data.writer.Writer</a>. This option is useful when model fields are\nused to keep state on the client but do not need to be persisted to the server. Defaults to true.</p>\n"},"serialize":{"!doc":"<p>A function which converts the Model's value for this Field into a form which can be used by whatever <a href=\"#!/api/Ext.data.writer.Writer\" rel=\"Ext.data.writer.Writer\" class=\"docClass\">Writer</a>\nis being used to sync data with the server.</p>\n\n<p>The function should return a string which represents the Field's value.</p>\n\n<p>It is passed the following parameters:</p>\n\n<ul>\n<li><p><strong>v</strong> : Mixed</p>\n\n<p>The Field's value - the value to be serialized.</p></li>\n<li><p><strong>rec</strong> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></p>\n\n<p>The record being serialized.</p></li>\n</ul>\n\n"},"sortDir":{"!type":"string","!doc":"<p>Initial direction to sort (<code>\"ASC\"</code> or <code>\"DESC\"</code>). Defaults to <code>\"ASC\"</code>.</p>\n"},"sortType":{"!doc":"<p>A function which converts a Field's value to a comparable value in order to ensure correct sort ordering.\nPredefined functions are provided in <a href=\"#!/api/Ext.data.SortTypes\" rel=\"Ext.data.SortTypes\" class=\"docClass\">Ext.data.SortTypes</a>. A custom sort example:</p>\n\n<pre><code>// current sort     after sort we want\n// +-+------+          +-+------+\n// |1|First |          |1|First |\n// |2|Last  |          |3|Second|\n// |3|Second|          |2|Last  |\n// +-+------+          +-+------+\n\nsortType: function(value) {\n   switch (value.toLowerCase()) // native toLowerCase():\n   {\n      case 'first': return 1;\n      case 'second': return 2;\n      default: return 3;\n   }\n}\n</code></pre>\n\n<p>May also be set to a String value, corresponding to one of the named sort types in <a href=\"#!/api/Ext.data.SortTypes\" rel=\"Ext.data.SortTypes\" class=\"docClass\">Ext.data.SortTypes</a>.</p>\n"},"type":{"!doc":"<p>The data type for automatic conversion from received data to the <em>stored</em> value if\n<code><a href=\"#!/api/Ext.data.Field-cfg-convert\" rel=\"Ext.data.Field-cfg-convert\" class=\"docClass\">convert</a></code> has not been specified. This may be specified as a string value.\nPossible values are</p>\n\n<ul>\n<li>auto (Default, implies no conversion)</li>\n<li>string</li>\n<li>int</li>\n<li>float</li>\n<li>boolean</li>\n<li>date</li>\n</ul>\n\n\n<p>This may also be specified by referencing a member of the <a href=\"#!/api/Ext.data.Types\" rel=\"Ext.data.Types\" class=\"docClass\">Ext.data.Types</a> class.</p>\n\n<p>Developers may create their own application-specific data types by defining new members of the <a href=\"#!/api/Ext.data.Types\" rel=\"Ext.data.Types\" class=\"docClass\">Ext.data.Types</a> class.</p>\n"},"useNull":{"!type":"bool","!doc":"<p>Use when converting received data into a INT, FLOAT, BOOL or STRING type. If the value cannot be\nparsed, <code>null</code> will be used if useNull is true, otherwise a default value for that type will be used:</p>\n\n<ul>\n<li>for INT and FLOAT - <code>0</code>.</li>\n<li>for STRING - <code>\"\"</code>.</li>\n<li>for BOOL - <code>false</code>.</li>\n</ul>\n\n\n<p>Note that when parsing of DATE type fails, the value will be <code>null</code> regardless of this setting.</p>\n"},"isField":{"!type":"bool"}}},"flash":{"BinaryXhr":{"!doc":"<p>Simulates an XMLHttpRequest object's methods and properties as returned\nform the flash polyfill plugin. Used in submitting binary data in browsers that do\nnot support doing so from JavaScript.\nNOTE: By default this will look for the flash object in the ext directory. When packaging and deploying the app, copy the <tt>ext/plugins</tt> directory and its contents to your root directory. For custom deployments where just the <tt>FlashPlugin.swf</tt> file gets copied (e.g. to <tt>/resources/FlashPlugin.swf</tt>), make sure to notify the framework of the location of the plugin before making the first attempt to post binary data, e.g. in the <tt>launch</tt> method of your app do:</p>\n\n<pre><code>Ext.flashPluginPath=\"/resources/FlashPlugin.swf\";\n </code></pre>\n\n","!type":"fn(config: ?)","prototype":{"javascriptId":{"!doc":"<p>An ID representing this connection with flash.</p>\n"},"readyState":{"!doc":"<p>The connection's simulated readyState. Note that the only supported values are 0, 1 and 4. States 2 and 3 will never be reported.</p>\n"},"responseBytes":{"!doc":"<p>The binary bytes returned.</p>\n"},"status":{"!doc":"<p>Connection status code returned by flash or the server.</p>\n"},"statusText":{"!type":"string","!doc":"<p>Status text (if any) returned by flash or the server.</p>\n"},"connectionIndex":{"!type":"number","!doc":"<p>Counts IDs for new connections.</p>\n"},"flashPlugin":{"!doc":"<p>Reference to the actual plugin, once activated.</p>\n"},"flashPluginActive":{"!type":"bool","!doc":"<p>Set to <tt>trut</tt> once the plugin registers and is active.</p>\n"},"flashPluginInjected":{"!type":"bool","!doc":"<p>Flag to avoid installing the plugin twice.</p>\n"},"liveConnections":{"!doc":"<p>Plcaeholder for active connections.</p>\n"},"abort":{"!type":"fn() -> !this","!doc":"<p>Abort this connection. Sets its readyState to 4.</p>\n"},"getAllResponseHeaders":{"!type":"fn() -> !this","!doc":"<p>As in XMLHttpRequest.</p>\n"},"getResponseHeader":{"!type":"fn(header: ?) -> !this","!doc":"<p>As in XMLHttpRequest.</p>\n"},"onFlashReady":{"!type":"fn() -> !this","!doc":"<p>Called by send, or once flash is loaded, to actually send the bytes.</p>\n"},"onFlashStateChange":{"!type":"fn(javascriptId: ?, state: ?, data: ?) -> !this","!doc":"<p>Called by the flash plugin once the state of one of the active connections changes.</p>\n"},"onreadystatechange":{"!type":"fn() -> !this","!doc":"<p>As in XMLHttpRequest.</p>\n"},"open":{"!type":"fn(method: ?, url: ?, async: ?, user: ?, password: ?) -> !this","!doc":"<p>As in XMLHttpRequest.</p>\n"},"overrideMimeType":{"!type":"fn(mimeType: ?) -> !this","!doc":"<p>As in XMLHttpRequest.</p>\n"},"parseData":{"!type":"fn(data: ?) -> !this","!doc":"<p>Parses data returned from flash once a connection is done.</p>\n"},"send":{"!type":"fn(body: ?) -> !this","!doc":"<p>Initiate the request.</p>\n"},"setReadyState":{"!type":"fn(state: ?) -> !this","!doc":"<p>Updates readyState and notifies listeners.</p>\n"},"setRequestHeader":{"!type":"fn(header: ?, value: ?) -> !this","!doc":"<p>As in XMLHttpRequest.</p>\n"},"flashPluginActivated":{"!type":"fn() -> !this","!doc":"<p>Called by the flash plugin once it's installed and open for business.</p>\n"},"injectFlashPlugin":{"!type":"fn() -> !this","!doc":"<p>Injects the flash polyfill plugin to allow posting binary data.\nThis is done in two steps: First we load the javascript loader for flash objects, then we call it to inject the flash object.</p>\n"},"registerConnection":{"!type":"fn(conn: ?) -> number","!doc":"<p>Adds the BinaryXhr object to the tracked connection list and assigns it an ID</p>\n"}}}},"Group":{"!type":"fn()","prototype":{"dirty":{"!type":"bool"},"key":{},"add":{"!type":"fn(records: ?) -> !this"},"commit":{"!type":"fn() -> !this"},"contains":{"!type":"fn(record: ?) -> !this"},"getAggregateRecord":{"!type":"fn(forceNew: ?) -> !this"},"hasAggregate":{"!type":"fn() -> !this"},"isCollapsed":{"!type":"fn() -> !this"},"isDirty":{"!type":"fn() -> !this"},"remove":{"!type":"fn(records: ?) -> !this"},"setDirty":{"!type":"fn() -> !this"}}},"IdGenerator":{"!doc":"<p>This class is a base for all id generators. It also provides lookup of id generators by\ntheir id.</p>\n\n<p>Generally, id generators are used to generate a primary key for new model instances. There\nare different approaches to solving this problem, so this mechanism has both simple use\ncases and is open to custom implementations. A <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> requests id generation\nusing the <a href=\"#!/api/Ext.data.Model-cfg-idgen\" rel=\"Ext.data.Model-cfg-idgen\" class=\"docClass\">Ext.data.Model.idgen</a> property.</p>\n\n<h1>Identity, Type and Shared IdGenerators</h1>\n\n<p>It is often desirable to share IdGenerators to ensure uniqueness or common configuration.\nThis is done by giving IdGenerator instances an id property by which they can be looked\nup using the <a href=\"#!/api/Ext.data.IdGenerator-static-method-get\" rel=\"Ext.data.IdGenerator-static-method-get\" class=\"docClass\">get</a> method. To configure two <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> classes\nto share one <a href=\"#!/api/Ext.data.SequentialIdGenerator\" rel=\"Ext.data.SequentialIdGenerator\" class=\"docClass\">sequential</a> id generator, you simply\nassign them the same id:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelA', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: {\n        type: 'sequential',\n        id: 'foo'\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelB', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: {\n        type: 'sequential',\n        id: 'foo'\n    }\n});\n</code></pre>\n\n<p>To make this as simple as possible for generator types that are shared by many (or all)\nModels, the IdGenerator types (such as 'sequential' or 'uuid') are also reserved as\ngenerator id's. This is used by the <a href=\"#!/api/Ext.data.UuidGenerator\" rel=\"Ext.data.UuidGenerator\" class=\"docClass\">Ext.data.UuidGenerator</a> which has an id equal\nto its type ('uuid'). In other words, the following Models share the same generator:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelX', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: 'uuid'\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelY', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: 'uuid'\n});\n</code></pre>\n\n<p>This can be overridden (by specifying the id explicitly), but there is no particularly\ngood reason to do so for this generator type.</p>\n\n<h1>Creating Custom Generators</h1>\n\n<p>An id generator should derive from this class and implement the <a href=\"#!/api/Ext.data.IdGenerator-method-generate\" rel=\"Ext.data.IdGenerator-method-generate\" class=\"docClass\">generate</a> method.\nThe constructor will apply config properties on new instances, so a constructor is often\nnot necessary.</p>\n\n<p>To register an id generator type, a derived class should provide an <code>alias</code> like so:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.CustomIdGenerator', {\n    extend: '<a href=\"#!/api/Ext.data.IdGenerator\" rel=\"Ext.data.IdGenerator\" class=\"docClass\">Ext.data.IdGenerator</a>',\n    alias: 'idgen.custom',\n\n    configProp: 42, // some config property w/default value\n\n    generate: function () {\n        return ... // a new id\n    }\n});\n</code></pre>\n\n<p>Using the custom id generator is then straightforward:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModel', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: 'custom'\n});\n// or...\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModel', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: {\n        type: 'custom',\n        configProp: value\n    }\n});\n</code></pre>\n\n<p>It is not recommended to mix shared generators with generator configuration. This leads\nto unpredictable results unless all configurations match (which is also redundant). In\nsuch cases, a custom generator with a default id is the best approach.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.CustomIdGenerator', {\n    extend: '<a href=\"#!/api/Ext.data.SequentialIdGenerator\" rel=\"Ext.data.SequentialIdGenerator\" class=\"docClass\">Ext.data.SequentialIdGenerator</a>',\n    alias: 'idgen.custom',\n\n    id: 'custom', // shared by default\n\n    prefix: 'ID_',\n    seed: 1000\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelX', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: 'custom'\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelY', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: 'custom'\n});\n\n// the above models share a generator that produces ID_1000, ID_1001, etc..\n</code></pre>\n","!type":"fn(config?: ?)","prototype":{"id":{"!type":"string","!doc":"<p>The id by which to register a new instance. This instance can be found using the\n<a href=\"#!/api/Ext.data.IdGenerator-static-method-get\" rel=\"Ext.data.IdGenerator-static-method-get\" class=\"docClass\">get</a> static method.</p>\n"},"isGenerator":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated IdGenerator, or subclass thereof.</p>\n"},"all":{"!doc":"<p>This object is keyed by id to lookup instances.</p>\n"},"generate":{"!type":"fn() -> string","!doc":"<p>Generates and returns the next id. This method must be implemented by the derived\nclass.</p>\n"},"get":{"!type":"fn(config: ?) -> !this","!doc":"<p>Returns the IdGenerator given its config description.</p>\n"}}},"JsonP":{"!doc":"<p>This class is used to create JSONP requests. JSONP is a mechanism that allows for making\nrequests for data cross domain. More information is available <a href=\"http://en.wikipedia.org/wiki/JSONP\">here</a>.</p>\n","callbackKey":{"!type":"string","!doc":"<p>Specifies the GET parameter that will be sent to the server containing the function name to be executed when\nthe request completes. Defaults to <tt>callback</tt>. Thus, a common request will be in the form of\nurl?callback=Ext.data.JsonP.callback1</p>\n"},"disableCaching":{"!type":"bool","!doc":"<p>True to add a unique cache-buster param to requests. Defaults to <tt>true</tt>.</p>\n"},"disableCachingParam":{"!type":"string","!doc":"<p>Change the parameter which is sent went disabling caching through a cache buster. Defaults to <tt>'_dc'</tt>.</p>\n"},"requestCount":{"!type":"number","!doc":"<p>Number of requests done so far.</p>\n"},"requests":{"!doc":"<p>Hash of pending requests.</p>\n"},"timeout":{"!type":"number","!doc":"<p>A default timeout for any JsonP requests. If the request has not completed in this time the\nfailure callback will be fired. The timeout is in ms. Defaults to <tt>30000</tt>.</p>\n"},"abort":{"!type":"fn(request?: ?) -> !this","!doc":"<p>Abort a request. If the request parameter is not specified all open requests will\nbe aborted.</p>\n"},"cleanupErrorHandling":{"!type":"fn(request: ?) -> !this","!doc":"<p>Cleans up anu script handling errors</p>\n"},"createScript":{"!type":"fn(url: ?, params: ?, options: ?) -> !this","!doc":"<p>Create the script tag given the specified url, params and options. The options\nparameter is passed to allow an override to access it.</p>\n"},"handleAbort":{"!type":"fn(request: ?) -> !this","!doc":"<p>Handles any aborts when loading the script</p>\n"},"handleError":{"!type":"fn(request: ?) -> !this","!doc":"<p>Handles any script errors when loading the script</p>\n"},"handleResponse":{"!type":"fn(result: ?, request: ?) -> !this","!doc":"<p>Handle a successful response</p>\n"},"handleTimeout":{"!type":"fn(request: ?) -> !this","!doc":"<p>Handle any script timeouts</p>\n"},"loadScript":{"!type":"fn(request: ?) -> !this","!doc":"<p>Loads the script for the given request by appending it to the HEAD element. This is\nits own method so that users can override it (as well as <a href=\"#!/api/Ext.data.JsonP-method-createScript\" rel=\"Ext.data.JsonP-method-createScript\" class=\"docClass\">createScript</a>).</p>\n"},"request":{"!type":"fn(options: ?) -> ?","!doc":"<p>Makes a JSONP request.</p>\n"},"setupErrorHandling":{"!type":"fn(request: ?) -> !this","!doc":"<p>Sets up error handling for the script</p>\n"}},"JsonPStore":{"!doc":"<p>Small helper class to make creating <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>s from different domain JSON data easier.\nA JsonPStore will be automatically configured with a <a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">Ext.data.reader.Json</a> and a <a href=\"#!/api/Ext.data.proxy.JsonP\" rel=\"Ext.data.proxy.JsonP\" class=\"docClass\">JsonPProxy</a>.</p>\n\n\n<p>A store configuration would be something like:\n<pre><code>var store = new <a href=\"#!/api/Ext.data.JsonPStore\" rel=\"Ext.data.JsonPStore\" class=\"docClass\">Ext.data.JsonPStore</a>({\n    // store configs\n    storeId: 'myStore',\n\n    // proxy configs\n    url: 'get-images.php',\n\n    // reader configs\n    root: 'images',\n    idProperty: 'name',\n    fields: ['name', 'url', {name:'size', type: 'float'}, {name:'lastmod', type:'date'}]\n});\n</code></pre></p>\n\n\n<p>This store is configured to consume a returned object of the form:\n<pre><code>stcCallback({\n    images: [\n        {name: 'Image one', url:'/GetImage.php?id=1', size:46.5, lastmod: new Date(2007, 10, 29)},\n        {name: 'Image Two', url:'/GetImage.php?id=2', size:43.2, lastmod: new Date(2007, 10, 30)}\n    ]\n})\n</code></pre>\n<p>Where stcCallback is the callback name passed in the request to the remote domain. See <a href=\"#!/api/Ext.data.proxy.JsonP\" rel=\"Ext.data.proxy.JsonP\" class=\"docClass\">JsonPProxy</a>\nfor details of how this works.</p>\nAn object literal of this form could also be used as the <a href=\"#!/api/Ext.data.JsonPStore-cfg-data\" rel=\"Ext.data.JsonPStore-cfg-data\" class=\"docClass\">data</a> config option.</p>\n\n","!type":"fn(config: ?)"},"JsonStore":{"!doc":"<p>Small helper class to make creating <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>s from JSON data easier.\nA JsonStore will be automatically configured with a <a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">Ext.data.reader.Json</a>.</p>\n\n<p>A store configuration would be something like:</p>\n\n<pre><code>var store = new <a href=\"#!/api/Ext.data.JsonStore\" rel=\"Ext.data.JsonStore\" class=\"docClass\">Ext.data.JsonStore</a>({\n    // store configs\n    storeId: 'myStore',\n\n    proxy: {\n        type: 'ajax',\n        url: 'get-images.php',\n        reader: {\n            type: 'json',\n            root: 'images',\n            idProperty: 'name'\n        }\n    },\n\n    //alternatively, a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> name can be given (see <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> for an example)\n    fields: ['name', 'url', {name:'size', type: 'float'}, {name:'lastmod', type:'date'}]\n});\n</code></pre>\n\n<p>This store is configured to consume a returned object of the form:</p>\n\n<pre><code>{\n    images: [\n        {name: 'Image one', url:'/GetImage.php?id=1', size:46.5, lastmod: new Date(2007, 10, 29)},\n        {name: 'Image Two', url:'/GetImage.php?id=2', size:43.2, lastmod: new Date(2007, 10, 30)}\n    ]\n}\n</code></pre>\n\n<p>An object literal of this form could also be used as the <a href=\"#!/api/Ext.data.JsonStore-cfg-data\" rel=\"Ext.data.JsonStore-cfg-data\" class=\"docClass\">data</a> config option.</p>\n","!type":"fn(config: ?)"},"Model":{"!doc":"<p>A Model represents some object that your application manages. For example, one might define a Model for Users,\nProducts, Cars, or any other real-world object that we want to model in the system. Models are registered via the\n<a href=\"#!/api/Ext.ModelManager\" rel=\"Ext.ModelManager\" class=\"docClass\">model manager</a>, and are used by <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">stores</a>, which are in turn used by many\nof the data-bound components in Ext.</p>\n\n<p>Models are defined as a set of fields and any arbitrary methods and properties relevant to the model. For example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'name',  type: 'string'},\n        {name: 'age',   type: 'int', convert: null},\n        {name: 'phone', type: 'string'},\n        {name: 'alive', type: 'boolean', defaultValue: true, convert: null}\n    ],\n\n    changeName: function() {\n        var oldName = this.get('name'),\n            newName = oldName + \" The Barbarian\";\n\n        this.set('name', newName);\n    }\n});\n</code></pre>\n\n<p>The fields array is turned into a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">MixedCollection</a> automatically by the <a href=\"#!/api/Ext.ModelManager\" rel=\"Ext.ModelManager\" class=\"docClass\">ModelManager</a>, and all other functions and properties are copied to the new Model's prototype.</p>\n\n<p>A Model definition always has an <em>identifying field</em> which should yield a unique key for each instance. By default, a field\nnamed \"id\" will be created with a <a href=\"#!/api/Ext.data.Field-cfg-mapping\" rel=\"Ext.data.Field-cfg-mapping\" class=\"docClass\">mapping</a> of \"id\". This happens because of the default\n<a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">idProperty</a> provided in Model definitions.</p>\n\n<p>To alter which field is the identifying field, use the <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">idProperty</a> config.</p>\n\n<p>If the Model should not have any identifying field (for example if you are defining ab abstract base class for your\napplication models), configure the {@liknk <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">idProperty</a>} as <code>null</code>.</p>\n\n<p>By default, the built in numeric and boolean field types have a <a href=\"#!/api/Ext.data.Field-cfg-convert\" rel=\"Ext.data.Field-cfg-convert\" class=\"docClass\">Ext.data.Field.convert</a> function which coerces string\nvalues in raw data into the field's type. For better performance with <a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">Json</a> or <a href=\"#!/api/Ext.data.reader.Array\" rel=\"Ext.data.reader.Array\" class=\"docClass\">Array</a>\nreaders <em>if you are in control of the data fed into this Model</em>, you can null out the default convert function which will cause\nthe raw property to be copied directly into the Field's value.</p>\n\n<p>Now we can create instances of our User model and call any model logic we defined:</p>\n\n<pre><code>var user = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {\n    id   : 'ABCD12345',\n    name : 'Conan',\n    age  : 24,\n    phone: '555-555-5555'\n});\n\nuser.changeName();\nuser.get('name'); //returns \"Conan The Barbarian\"\n</code></pre>\n\n<h1>Validations</h1>\n\n<p>Models have built-in support for validations, which are executed against the validator functions in <a href=\"#!/api/Ext.data.validations\" rel=\"Ext.data.validations\" class=\"docClass\">Ext.data.validations</a> (<a href=\"#!/api/Ext.data.validations\" rel=\"Ext.data.validations\" class=\"docClass\">see all validation functions</a>). Validations are easy to add to\nmodels:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'name',     type: 'string'},\n        {name: 'age',      type: 'int'},\n        {name: 'phone',    type: 'string'},\n        {name: 'gender',   type: 'string'},\n        {name: 'username', type: 'string'},\n        {name: 'alive',    type: 'boolean', defaultValue: true}\n    ],\n\n    validations: [\n        {type: 'presence',  field: 'age'},\n        {type: 'length',    field: 'name',     min: 2},\n        {type: 'inclusion', field: 'gender',   list: ['Male', 'Female']},\n        {type: 'exclusion', field: 'username', list: ['Admin', 'Operator']},\n        {type: 'format',    field: 'username', matcher: /([a-z]+)[0-9]{2,3}/}\n    ]\n});\n</code></pre>\n\n<p>The validations can be run by simply calling the <a href=\"#!/api/Ext.data.Model-method-validate\" rel=\"Ext.data.Model-method-validate\" class=\"docClass\">validate</a> function, which returns a <a href=\"#!/api/Ext.data.Errors\" rel=\"Ext.data.Errors\" class=\"docClass\">Ext.data.Errors</a>\nobject:</p>\n\n<pre><code>var instance = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {\n    name: 'Ed',\n    gender: 'Male',\n    username: 'edspencer'\n});\n\nvar errors = instance.validate();\n</code></pre>\n\n<h1>Associations</h1>\n\n<p>Models can have associations with other Models via <a href=\"#!/api/Ext.data.association.HasOne\" rel=\"Ext.data.association.HasOne\" class=\"docClass\">Ext.data.association.HasOne</a>,\n<a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">belongsTo</a> and <a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">hasMany</a> associations.\nFor example, let's say we're writing a blog administration application which deals with Users, Posts and Comments.\nWe can express the relationships between these models like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Post', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'user_id'],\n\n    belongsTo: 'User',\n    hasMany  : {model: 'Comment', name: 'comments'}\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Comment', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'user_id', 'post_id'],\n\n    belongsTo: 'Post'\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id'],\n\n    hasMany: [\n        'Post',\n        {model: 'Comment', name: 'comments'}\n    ]\n});\n</code></pre>\n\n<p>See the docs for <a href=\"#!/api/Ext.data.association.HasOne\" rel=\"Ext.data.association.HasOne\" class=\"docClass\">Ext.data.association.HasOne</a>, <a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">Ext.data.association.BelongsTo</a> and\n<a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">Ext.data.association.HasMany</a> for details on the usage and configuration of associations.\nNote that associations can also be specified like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id'],\n\n    associations: [\n        {type: 'hasMany', model: 'Post',    name: 'posts'},\n        {type: 'hasMany', model: 'Comment', name: 'comments'}\n    ]\n});\n</code></pre>\n\n<h1>Using a Proxy</h1>\n\n<p>Models are great for representing types of data and relationships, but sooner or later we're going to want to load or\nsave that data somewhere. All loading and saving of data is handled via a <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a>, which\ncan be set directly on the Model:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'email'],\n\n    proxy: {\n        type: 'rest',\n        url : '/users'\n    }\n});\n</code></pre>\n\n<p>Here we've set up a <a href=\"#!/api/Ext.data.proxy.Rest\" rel=\"Ext.data.proxy.Rest\" class=\"docClass\">Rest Proxy</a>, which knows how to load and save data to and from a\nRESTful backend. Let's see how this works:</p>\n\n<pre><code>var user = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {name: 'Ed Spencer', email: 'ed@sencha.com'});\n\nuser.save(); //POST /users\n</code></pre>\n\n<p>Calling <a href=\"#!/api/Ext.data.Model-method-save\" rel=\"Ext.data.Model-method-save\" class=\"docClass\">save</a> on the new Model instance tells the configured RestProxy that we wish to persist this Model's\ndata onto our server. RestProxy figures out that this Model hasn't been saved before because it doesn't have an id,\nand performs the appropriate action - in this case issuing a POST request to the url we configured (/users). We\nconfigure any Proxy on any Model and always follow this API - see <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Ext.data.proxy.Proxy</a> for a full list.</p>\n\n<p>Loading data via the Proxy is equally easy:</p>\n\n<pre><code>//get a reference to the User model class\nvar User = <a href=\"#!/api/Ext.ModelManager-method-getModel\" rel=\"Ext.ModelManager-method-getModel\" class=\"docClass\">Ext.ModelManager.getModel</a>('User');\n\n//Uses the configured RestProxy to make a GET request to /users/123\nUser.load(123, {\n    success: function(user) {\n        console.log(user.getId()); //logs 123\n    }\n});\n</code></pre>\n\n<p>Models can also be updated and destroyed easily:</p>\n\n<pre><code>//the user Model we loaded in the last snippet:\nuser.set('name', 'Edward Spencer');\n\n//tells the Proxy to save the Model. In this case it will perform a PUT request to /users/123 as this Model already has an id\nuser.save({\n    success: function() {\n        console.log('The User was updated');\n    }\n});\n\n//tells the Proxy to destroy the Model. Performs a DELETE request to /users/123\nuser.destroy({\n    success: function() {\n        console.log('The User was destroyed!');\n    }\n});\n</code></pre>\n\n<h1>Usage in Stores</h1>\n\n<p>It is very common to want to load a set of Model instances to be displayed and manipulated in the UI. We do this by\ncreating a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>:</p>\n\n<pre><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User'\n});\n\n//uses the Proxy we set up on Model to load the Store data\nstore.load();\n</code></pre>\n\n<p>A Store is just a collection of Model instances - usually loaded from a server somewhere. Store can also maintain a\nset of added, updated and removed Model instances to be synchronized with the server via the Proxy. See the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store docs</a> for more information on Stores.</p>\n","!type":"fn(data: ?)","prototype":{"associations":{"!doc":"<p>An array of <a href=\"#!/api/Ext.data.association.Association\" rel=\"Ext.data.association.Association\" class=\"docClass\">associations</a> for this model.</p>\n"},"belongsTo":{"!doc":"<p>One or more <a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">BelongsTo associations</a> for this model.</p>\n"},"clientIdProperty":{"!type":"string","!doc":"<p>The name of a property that is used for submitting this Model's unique client-side identifier\nto the server when multiple phantom records are saved as part of the same <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Operation</a>.\nIn such a case, the server response should include the client id for each record\nso that the server response data can be used to update the client-side records if necessary.\nThis property cannot have the same name as any of this Model's fields.</p>\n"},"defaultProxyType":{"!type":"string","!doc":"<p>The string type of the default Model Proxy. Defaults to 'ajax'.</p>\n"},"fields":{"!doc":"<p>The fields for this model. This is an Array of <strong><a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field</a></strong> definition objects. A Field\ndefinition may simply be the <em>name</em> of the Field, but a Field encapsulates <a href=\"#!/api/Ext.data.Field-cfg-type\" rel=\"Ext.data.Field-cfg-type\" class=\"docClass\">data type</a>,\n<a href=\"#!/api/Ext.data.Field-cfg-convert\" rel=\"Ext.data.Field-cfg-convert\" class=\"docClass\">custom conversion</a> of raw data, and a <a href=\"#!/api/Ext.data.Field-cfg-mapping\" rel=\"Ext.data.Field-cfg-mapping\" class=\"docClass\">mapping</a>\nproperty to specify by name of index, how to extract a field's value from a raw data object, so it is best practice\nto specify a full set of <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field</a> config objects.</p>\n"},"hasMany":{"!doc":"<p>One or more <a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">HasMany associations</a> for this model.</p>\n"},"idProperty":{"!doc":"<p>The name of the field treated as this Model's unique id. Defaults to 'id'.</p>\n\n<p>This may also be specified as a Field config object. This means that the identifying field can be calculated\nusing a <a href=\"#!/api/Ext.data.Field-cfg-convert\" rel=\"Ext.data.Field-cfg-convert\" class=\"docClass\">convert</a> function which might aggregate several values from the\nraw data object to use as an identifier.</p>\n\n<p>The resulting <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field</a> is added to the Model's field collection unless there is already\na configured field with a mapping that reads the same property.</p>\n\n<p>If defining an <strong>abstract</strong> base Model class, the <code>idProperty</code> may be configured as <code>null</code> which will mean that\nno identifying field will be generated.</p>\n"},"idgen":{"!doc":"<p>The id generator to use for this model. The default id generator does not generate\nvalues for the <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">idProperty</a>.</p>\n\n<p>This can be overridden at the model level to provide a custom generator for a model.\nThe simplest form of this would be:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModel', {\n     extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n     requires: ['<a href=\"#!/api/Ext.data.SequentialIdGenerator\" rel=\"Ext.data.SequentialIdGenerator\" class=\"docClass\">Ext.data.SequentialIdGenerator</a>'],\n     idgen: 'sequential',\n     ...\n });\n</code></pre>\n\n<p>The above would generate <a href=\"#!/api/Ext.data.SequentialIdGenerator\" rel=\"Ext.data.SequentialIdGenerator\" class=\"docClass\">sequential</a> id's such\nas 1, 2, 3 etc..</p>\n\n<p>Another useful id generator is <a href=\"#!/api/Ext.data.UuidGenerator\" rel=\"Ext.data.UuidGenerator\" class=\"docClass\">Ext.data.UuidGenerator</a>:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModel', {\n     extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n     requires: ['<a href=\"#!/api/Ext.data.UuidGenerator\" rel=\"Ext.data.UuidGenerator\" class=\"docClass\">Ext.data.UuidGenerator</a>'],\n     idgen: 'uuid',\n     ...\n });\n</code></pre>\n\n<p>An id generation can also be further configured:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModel', {\n     extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n     idgen: {\n         type: 'sequential',\n         seed: 1000,\n         prefix: 'ID_'\n     }\n });\n</code></pre>\n\n<p>The above would generate id's such as ID_1000, ID_1001, ID_1002 etc..</p>\n\n<p>If multiple models share an id space, a single generator can be shared:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelX', {\n     extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n     idgen: {\n         type: 'sequential',\n         id: 'xy'\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelY', {\n     extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n     idgen: {\n         type: 'sequential',\n         id: 'xy'\n     }\n });\n</code></pre>\n\n<p>For more complex, shared id generators, a custom generator is the best approach.\nSee <a href=\"#!/api/Ext.data.IdGenerator\" rel=\"Ext.data.IdGenerator\" class=\"docClass\">Ext.data.IdGenerator</a> for details on creating custom id generators.</p>\n"},"persistenceProperty":{"!type":"string","!doc":"<p>The name of the property on this Persistable object that its data is saved to. Defaults to 'data'\n(i.e: all persistable data resides in <code>this.data</code>.)</p>\n"},"proxy":{"!doc":"<p>The <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">proxy</a> to use for this model.</p>\n"},"validations":{"!doc":"<p>An array of <a href=\"#!/api/Ext.data.validations\" rel=\"Ext.data.validations\" class=\"docClass\">validations</a> for this model.</p>\n"},"_singleProp":{"!doc":"<p>This object is used whenever the set() method is called and given a string as the\nfirst argument. This approach saves memory (and GC costs) since we could be called\na lot.</p>\n"},"dirty":{"!type":"bool","!doc":"<p>True if this Record has been modified.</p>\n"},"editing":{"!type":"bool","!doc":"<p>Internal flag used to track whether or not the model instance is currently being edited.</p>\n"},"emptyData":{"!doc":"<p>Used as a dummy source array when constructor is called with no args</p>\n"},"evented":{"!type":"bool"},"internalId":{"!doc":"<p>An internal unique ID for each Model instance, used to identify Models that don't have an ID yet</p>\n"},"isModel":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Model, or subclass thereof.</p>\n"},"modified":{"!doc":"<p>Key: value pairs of all fields whose values have changed</p>\n"},"phantom":{"!type":"bool","!doc":"<p>True when the record does not yet exist in a server-side database (see <a href=\"#!/api/Ext.data.Model-method-setDirty\" rel=\"Ext.data.Model-method-setDirty\" class=\"docClass\">setDirty</a>).\nAny record which has a real database pk set as its id property is NOT a phantom -- it's real.</p>\n"},"raw":{"!doc":"<p>The raw data used to create this model if created via a reader.</p>\n"},"store":{"!doc":"<p>The <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> to which this instance belongs. NOTE: If this\ninstance is bound to multiple stores, this property will reference only the\nfirst. To examine all the stores, use the <a href=\"#!/api/Ext.data.Model-property-stores\" rel=\"Ext.data.Model-property-stores\" class=\"docClass\">stores</a> property instead.</p>\n"},"stores":{"!doc":"<p>The <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Stores</a> to which this instance is bound.</p>\n"},"AUTO_ID":{"!type":"number"},"COMMIT":{"!type":"string","!doc":"<p>The update operation of type 'commit'. Used by <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">Store.update</a> event.</p>\n"},"EDIT":{"!type":"string","!doc":"<p>The update operation of type 'edit'. Used by <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">Store.update</a> event.</p>\n"},"PREFIX":{"!type":"string"},"REJECT":{"!type":"string","!doc":"<p>The update operation of type 'reject'. Used by <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">Store.update</a> event.</p>\n"},"afterCommit":{"!type":"fn(modifiedFieldNames?: ?) -> !this","!doc":"<p>If this Model instance has been <a href=\"#!/api/Ext.data.Model-method-join\" rel=\"Ext.data.Model-method-join\" class=\"docClass\">joined</a> to a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a>, the store's\nafterCommit method is called,</p>\n"},"afterEdit":{"!type":"fn(modifiedFieldNames?: ?) -> !this","!doc":"<p>If this Model instance has been <a href=\"#!/api/Ext.data.Model-method-join\" rel=\"Ext.data.Model-method-join\" class=\"docClass\">joined</a> to a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a>, the store's\nafterEdit method is called.</p>\n"},"afterReject":{"!type":"fn() -> !this","!doc":"<p>If this Model instance has been <a href=\"#!/api/Ext.data.Model-method-join\" rel=\"Ext.data.Model-method-join\" class=\"docClass\">joined</a> to a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a>, the store's\nafterReject method is called.</p>\n"},"beginEdit":{"!type":"fn() -> !this","!doc":"<p>Begins an edit. While in edit mode, no events (e.g.. the <code>update</code> event) are relayed to the containing store.\nWhen an edit has begun, it must be followed by either <a href=\"#!/api/Ext.data.Model-method-endEdit\" rel=\"Ext.data.Model-method-endEdit\" class=\"docClass\">endEdit</a> or <a href=\"#!/api/Ext.data.Model-method-cancelEdit\" rel=\"Ext.data.Model-method-cancelEdit\" class=\"docClass\">cancelEdit</a>.</p>\n"},"callStore":{"!type":"fn(fn: ?) -> !this","!doc":"<p>Helper function used by afterEdit, afterReject and afterCommit. Calls the given method on the\n<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a> that this instance has <a href=\"#!/api/Ext.data.Model-method-join\" rel=\"Ext.data.Model-method-join\" class=\"docClass\">joined</a>, if any. The store function\nwill always be called with the model instance as its single argument. If this model is joined to\na <a href=\"#!/api/Ext.data.NodeStore\" rel=\"Ext.data.NodeStore\" class=\"docClass\">Ext.data.NodeStore</a>, then this method calls the given method on the NodeStore and the associated <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a></p>\n"},"cancelEdit":{"!type":"fn() -> !this","!doc":"<p>Cancels all changes made in the current edit operation.</p>\n"},"changeId":{"!type":"fn(oldId: ?, newId: ?) -> !this"},"commit":{"!type":"fn(silent?: ?, modifiedFieldNames?: ?) -> !this","!doc":"<p>Usually called by the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> which owns the model instance. Commits all changes made to the\ninstance since either creation or the last commit operation.</p>\n\n<p>Developers should subscribe to the <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">Ext.data.Store.update</a> event to have their code notified of commit\noperations.</p>\n"},"compareConvertFields":{"!type":"fn(f1: ?, f2: ?) -> !this"},"copy":{"!type":"fn(id?: ?) -> ?","!doc":"<p>Creates a copy (clone) of this Model instance.</p>\n"},"copyFrom":{"!type":"fn(sourceRecord: ?) -> ?","!doc":"<p>Copies data from the passed record into this record. If the passed record is undefined, does nothing.</p>\n\n<p>If this is a phantom record (represented only in the client, with no corresponding database entry), and\nthe source record is not a phantom, then this record acquires the id of the source record.</p>\n"},"destroy":{"!type":"fn(options: ?) -> ?","!doc":"<p>Destroys the model using the configured proxy.</p>\n"},"endEdit":{"!type":"fn(silent?: ?, modifiedFieldNames?: ?) -> !this","!doc":"<p>Ends an edit. If any data was modified, the containing store is notified\n(ie, the store's <code>update</code> event will fire).</p>\n"},"get":{"!type":"fn(fieldName: ?) -> ?","!doc":"<p>Returns the value of the given field</p>\n"},"getAssociatedData":{"!type":"fn() -> ?","!doc":"<p>Gets all of the data from this Models <em>loaded</em> associations. It does this recursively - for example if we have a\nUser which hasMany Orders, and each Order hasMany OrderItems, it will return an object like this:</p>\n\n<pre><code>{\n    orders: [\n        {\n            id: 123,\n            status: 'shipped',\n            orderItems: [\n                ...\n            ]\n        }\n    ]\n}\n</code></pre>\n"},"getChanges":{"!type":"fn() -> ?","!doc":"<p>Gets a hash of only the fields that have been modified since this Model was created or commited.</p>\n"},"getData":{"!type":"fn(includeAssociated: ?) -> ?","!doc":"<p>Gets all values for each field in this model and returns an object\ncontaining the current data.</p>\n"},"getId":{"!type":"fn() -> ?","!doc":"<p>Returns the unique ID allocated to this model instance as defined by <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">idProperty</a>.</p>\n"},"getModifiedFieldNames":{"!type":"fn(saved?: ?) -> ?","!doc":"<p>Gets the names of all the fields that were modified during an edit</p>\n"},"getObservableId":{"!type":"fn() -> !this"},"getProxy":{"!type":"fn() -> ?","!doc":"<p>Returns the configured Proxy for this Model</p>\n"},"hasId":{"!type":"fn(id?: ?) -> bool","!doc":"<p>Checks if this model has an id assigned</p>\n"},"isEqual":{"!type":"fn(a: ?, b: ?) -> bool","!doc":"<p>Checks if two values are equal, taking into account certain\nspecial factors, for example dates.</p>\n"},"isModified":{"!type":"fn(fieldName: ?) -> bool","!doc":"<p>Returns true if the passed field name has been <code><a href=\"#!/api/Ext.data.Model-property-modified\" rel=\"Ext.data.Model-property-modified\" class=\"docClass\">modified</a></code> since the load or last commit.</p>\n"},"isValid":{"!type":"fn() -> bool","!doc":"<p>Checks if the model is valid. See <a href=\"#!/api/Ext.data.Model-method-validate\" rel=\"Ext.data.Model-method-validate\" class=\"docClass\">validate</a>.</p>\n"},"itemNameFn":{"!type":"fn(item: ?) -> !this"},"join":{"!type":"fn(store: ?) -> !this","!doc":"<p>Tells this model instance that it has been added to a store.</p>\n"},"markDirty":{"!type":"fn() -> !this","!doc":"<p><debug></debug></p>\n"},"onClassExtended":{"!type":"fn(cls: ?, data: ?, hooks: ?) -> !this"},"prepareAssociatedData":{"!type":"fn(seenKeys: ?, depth: ?) -> ?","!doc":"<p>This complex-looking method takes a given Model instance and returns an object containing all data from\nall of that Model's <em>loaded</em> associations. See <a href=\"#!/api/Ext.data.Model-method-getAssociatedData\" rel=\"Ext.data.Model-method-getAssociatedData\" class=\"docClass\">getAssociatedData</a></p>\n"},"reject":{"!type":"fn(silent?: ?) -> !this","!doc":"<p>Usually called by the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> to which this model instance has been <a href=\"#!/api/Ext.data.Model-method-join\" rel=\"Ext.data.Model-method-join\" class=\"docClass\">joined</a>. Rejects\nall changes made to the model instance since either creation, or the last commit operation. Modified fields are\nreverted to their original values.</p>\n\n<p>Developers should subscribe to the <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">Ext.data.Store.update</a> event to have their code notified of reject\noperations.</p>\n"},"save":{"!type":"fn(options?: ?) -> ?","!doc":"<p>Saves the model instance using the configured proxy.</p>\n"},"set":{"!type":"fn(fieldName: ?, newValue: ?) -> ?","!doc":"<p>Sets the given field to the given value, marks the instance as dirty</p>\n"},"setDirty":{"!type":"fn() -> !this","!doc":"<p>Marks this <strong>Record</strong> as <code><a href=\"#!/api/Ext.data.Model-property-dirty\" rel=\"Ext.data.Model-property-dirty\" class=\"docClass\">dirty</a></code>. This method is used interally when adding <code><a href=\"#!/api/Ext.data.Model-property-phantom\" rel=\"Ext.data.Model-property-phantom\" class=\"docClass\">phantom</a></code> records\nto a <a href=\"#!/api/Ext.data.proxy.Server-cfg-writer\" rel=\"Ext.data.proxy.Server-cfg-writer\" class=\"docClass\">writer enabled store</a>.</p>\n\n<p>Marking a record <code><a href=\"#!/api/Ext.data.Model-property-dirty\" rel=\"Ext.data.Model-property-dirty\" class=\"docClass\">dirty</a></code> causes the phantom to be returned by <a href=\"#!/api/Ext.data.Store-method-getUpdatedRecords\" rel=\"Ext.data.Store-method-getUpdatedRecords\" class=\"docClass\">Ext.data.Store.getUpdatedRecords</a>\nwhere it will have a create action composed for it during <a href=\"#!/api/Ext.data.Model-method-save\" rel=\"Ext.data.Model-method-save\" class=\"docClass\">model save</a> operations.</p>\n"},"setId":{"!type":"fn(id: ?) -> !this","!doc":"<p>Sets the model instance's id field to the given id.</p>\n"},"setProxy":{"!type":"fn(proxy: ?) -> ?","!doc":"<p>Sets the Proxy to use for this model. Accepts any options that can be accepted by\n<a href=\"#!/api/Ext-method-createByAlias\" rel=\"Ext-method-createByAlias\" class=\"docClass\">Ext.createByAlias</a>.</p>\n"},"unjoin":{"!type":"fn(store: ?) -> !this","!doc":"<p>Tells this model instance that it has been removed from the store.</p>\n"},"validate":{"!type":"fn() -> ?","!doc":"<p>Validates the current data against all of its configured <a href=\"#!/api/Ext.data.Model-cfg-validations\" rel=\"Ext.data.Model-cfg-validations\" class=\"docClass\">validations</a>.</p>\n"},"getFields":{"!type":"fn() -> ?","!doc":"<p>Returns an Array of <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field</a> definitions which define this Model's structure</p>\n\n<p>Fields are sorted upon Model class definition. Fields with custom <a href=\"#!/api/Ext.data.Field-cfg-convert\" rel=\"Ext.data.Field-cfg-convert\" class=\"docClass\">convert</a> functions\nare moved to <em>after</em> fields with no convert functions. This is so that convert functions which rely on existing\nfield values will be able to read those field values.</p>\n"},"id":{"!type":"fn(rec: ?) -> string","!doc":"<p>Generates a sequential id. This method is typically called when a record is <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">create</a>d and <a href=\"#!/api/Ext.data.Model-method-constructor\" rel=\"Ext.data.Model-method-constructor\" class=\"docClass\">no id has been specified</a> either as a parameter, or through the <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">idProperty</a>\nin the passed data. The generated id will automatically be assigned to the\nrecord. The returned id takes the form: {PREFIX}-{AUTO_ID}.</p>\n\n<ul>\n<li><strong>PREFIX</strong> : String - <a href=\"#!/api/Ext.data.Model-static-property-PREFIX\" rel=\"Ext.data.Model-static-property-PREFIX\" class=\"docClass\">Ext.data.Model.PREFIX</a> (defaults to 'ext-record')</li>\n<li><strong>AUTO_ID</strong> : String - <a href=\"#!/api/Ext.data.Model-static-property-AUTO_ID\" rel=\"Ext.data.Model-static-property-AUTO_ID\" class=\"docClass\">Ext.data.Model.AUTO_ID</a> (defaults to 1 initially)</li>\n</ul>\n\n"},"load":{"!type":"fn(id: ?, config?: ?) -> !this","!doc":"<p>Asynchronously loads a model instance by id. Sample usage:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'id', type: 'int'},\n        {name: 'name', type: 'string'}\n    ]\n});\n\nMyApp.User.load(10, {\n    scope: this,\n    failure: function(record, operation) {\n        //do something if the load failed\n        //record is null\n    },\n    success: function(record, operation) {\n        //do something if the load succeeded\n    },\n    callback: function(record, operation, success) {\n        //do something whether the load succeeded or failed\n        //if operation is unsuccessful, record is null\n    }\n});\n</code></pre>\n"},"setFields":{"!type":"fn(fields: ?, idProperty: ?, clientIdProperty: ?) -> !this","!doc":"<p>Apply a new set of field and/or property definitions to the existing model. This will replace any existing\nfields, including fields inherited from superclasses. Mainly for reconfiguring the\nmodel based on changes in meta data (called from Reader's onMetaChange method).</p>\n"},"idchanged":{"!type":"fn(this: ?, oldId: ?, newId: ?, eOpts: ?)","!doc":"<p>Fired when this model's id changes</p>\n"}}},"NodeInterface":{"!doc":"<p>This class is used as a set of methods that are applied to the prototype of a\nModel to decorate it with a Node API. This means that models used in conjunction with a tree\nwill have all of the tree related methods available on the model. In general this class will\nnot be used directly by the developer. This class also creates extra fields on the model if\nthey do not exist, to help maintain the tree state and UI. These fields are documented as\nconfig options.</p>\n","prototype":{"allowDrag":{"!type":"bool","!doc":"<p>Set to false to deny dragging of this node.</p>\n"},"allowDrop":{"!type":"bool","!doc":"<p>Set to false to deny dropping on this node.</p>\n"},"checked":{"!type":"bool","!doc":"<p>Set to true or false to show a checkbox alongside this node.</p>\n"},"children":{"!doc":"<p>Array of child nodes.</p>\n"},"cls":{"!type":"string","!doc":"<p>CSS class to apply for this node.</p>\n"},"depth":{"!type":"number","!doc":"<p>The number of parents this node has. A root node has depth 0, a child of it depth 1, and so on...</p>\n"},"expandable":{"!type":"bool","!doc":"<p>Set to true to allow for expanding/collapsing of this node.</p>\n"},"expanded":{"!type":"bool","!doc":"<p>True if the node is expanded.</p>\n"},"href":{"!type":"string","!doc":"<p>An URL for a link that's created when this config is specified.</p>\n"},"hrefTarget":{"!type":"string","!doc":"<p>Target for link. Only applicable when <a href=\"#!/api/Ext.data.NodeInterface-cfg-href\" rel=\"Ext.data.NodeInterface-cfg-href\" class=\"docClass\">href</a> also specified.</p>\n"},"icon":{"!type":"string","!doc":"<p>URL for this node's icon.</p>\n"},"iconCls":{"!type":"string","!doc":"<p>CSS class to apply for this node's icon.</p>\n"},"index":{"!type":"number","!doc":"<p>The position of the node inside its parent. When parent has 4 children and the node is third amongst them,\nindex will be 2.</p>\n"},"isFirst":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node is the first child of its parent</p>\n"},"isLast":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node is the last child of its parent</p>\n"},"leaf":{"!type":"bool","!doc":"<p>Set to true to indicate that this child can have no children. The expand icon/arrow will then not be\nrendered for this node.</p>\n"},"loaded":{"!type":"bool","!doc":"<p>True if the node has finished loading.</p>\n"},"loading":{"!type":"bool","!doc":"<p>True if the node is currently loading.</p>\n"},"parentId":{"!type":"string","!doc":"<p>ID of parent node.</p>\n"},"qshowDelay":{"!type":"number","!doc":"<p>Tooltip showDelay.</p>\n"},"qtip":{"!type":"string","!doc":"<p>Tooltip text to show on this node.</p>\n"},"qtitle":{"!type":"string","!doc":"<p>Tooltip title.</p>\n"},"root":{"!type":"bool","!doc":"<p>True if this is the root node.</p>\n"},"text":{"!type":"string","!doc":"<p>The text to show on node label.</p>\n"},"childNodes":{"!doc":"<p>An array of this nodes children.  Array will be empty if this node has no chidren.</p>\n"},"firstChild":{"!doc":"<p>A reference to this node's first child node. <code>null</code> if this node has no children.</p>\n"},"isNode":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Node, or subclass thereof.</p>\n"},"lastChild":{"!doc":"<p>A reference to this node's last child node. <code>null</code> if this node has no children.</p>\n"},"nextSibling":{"!doc":"<p>A reference to this node's next sibling node. <code>null</code> if this node does not have a next sibling.</p>\n"},"parentNode":{"!doc":"<p>A reference to this node's parent node. <code>null</code> if this node is the root node.</p>\n"},"previousSibling":{"!doc":"<p>A reference to this node's previous sibling node. <code>null</code> if this node does not have a previous sibling.</p>\n"},"appendChild":{"!type":"fn(node: ?, suppressEvents?: ?, commit?: ?) -> ?","!doc":"<p>Inserts node(s) as the last child node of this node.</p>\n\n<p>If the node was previously a child node of another parent node, it will be removed from that node first.</p>\n"},"bubble":{"!type":"fn(fn: ?, scope?: ?, args?: ?) -> !this","!doc":"<p>Bubbles up the tree from this node, calling the specified function with each node. The arguments to the function\nwill be the args provided or the current node. If the function returns false at any point,\nthe bubble is stopped.</p>\n"},"cascadeBy":{"!type":"fn(fn: ?, scope?: ?, args?: ?) -> !this","!doc":"<p>Cascades down the tree from this node, calling the specified function with each node. The arguments to the function\nwill be the args provided or the current node. If the function returns false at any point,\nthe cascade is stopped on that branch.</p>\n"},"clear":{"!type":"fn(destroy?: ?) -> !this","!doc":"<p>Clears the node.</p>\n"},"collapse":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires when this node is collapsed.</p>\n"},"collapseChildren":{"!type":"fn(recursive?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Collapse all the children of this node.</p>\n"},"contains":{"!type":"fn(node: ?) -> bool","!doc":"<p>Returns true if this node is an ancestor (at any point) of the passed node.</p>\n"},"copy":{"!type":"fn(id?: ?, deep?: ?) -> ?","!doc":"<p>Creates a copy (clone) of this Node.</p>\n"},"createNode":{"!type":"fn(node: ?) -> ?","!doc":"<p>Ensures that the passed object is an instance of a Record with the NodeInterface applied</p>\n"},"destroy":{"!type":"fn(silent: ?) -> !this","!doc":"<p>Destroys the node.</p>\n"},"eachChild":{"!type":"fn(fn: ?, scope?: ?, args?: ?) -> !this","!doc":"<p>Interates the child nodes of this node, calling the specified function with each node. The arguments to the function\nwill be the args provided or the current node. If the function returns false at any point,\nthe iteration stops.</p>\n"},"expand":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires when this node is expanded.</p>\n"},"expandChildren":{"!type":"fn(recursive?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Expand all the children of this node.</p>\n"},"findChild":{"!type":"fn(attribute: ?, value: ?, deep?: ?) -> ?","!doc":"<p>Finds the first child that has the attribute with the specified value.</p>\n"},"findChildBy":{"!type":"fn(fn: ?, scope?: ?, deep?: ?) -> ?","!doc":"<p>Finds the first child by a custom function. The child matches if the function passed returns true.</p>\n"},"getChildAt":{"!type":"fn(index: ?) -> ?","!doc":"<p>Returns the child node at the specified index.</p>\n"},"getDepth":{"!type":"fn() -> number","!doc":"<p>Returns depth of this node (the root node has a depth of 0)</p>\n"},"getOwnerTree":{"!type":"fn() -> ?","!doc":"<p>Returns the tree this node is in.</p>\n"},"getPath":{"!type":"fn(field?: ?, separator?: ?) -> string","!doc":"<p>Gets the hierarchical path from the root of the current node.</p>\n"},"hasChildNodes":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node has one or more child nodes, else false.</p>\n"},"indexOf":{"!type":"fn(node: ?) -> number","!doc":"<p>Returns the index of a child node</p>\n"},"indexOfId":{"!type":"fn(id: ?) -> number","!doc":"<p>Returns the index of a child node that matches the id</p>\n"},"insertBefore":{"!type":"fn(node: ?, refNode: ?) -> ?","!doc":"<p>Inserts the first node before the second node in this nodes childNodes collection.</p>\n"},"insertChild":{"!type":"fn(index: ?, node: ?) -> ?","!doc":"<p>Inserts a node into this node.</p>\n"},"isAncestor":{"!type":"fn(node: ?) -> bool","!doc":"<p>Returns true if the passed node is an ancestor (at any point) of this node.</p>\n"},"isExpandable":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node has one or more child nodes, or if the <tt>expandable</tt>\nnode attribute is explicitly specified as true, otherwise returns false.</p>\n"},"isExpanded":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node is expaned</p>\n"},"isLeaf":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node is a leaf</p>\n"},"isLoaded":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node is loaded</p>\n"},"isLoading":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node is loading</p>\n"},"isRoot":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node is the root node</p>\n"},"isVisible":{"!type":"fn() -> bool","!doc":"<p>Returns true if this node is visible. Note that visibility refers to\nthe structure of the tree, the <a href=\"#!/api/Ext.tree.Panel-cfg-rootVisible\" rel=\"Ext.tree.Panel-cfg-rootVisible\" class=\"docClass\">Ext.tree.Panel.rootVisible</a>\nconfiguration is not taken into account here. If this method is called\non the root node, it will always be visible.</p>\n"},"onChildNodesAvailable":{"!type":"fn(records: ?, recursive: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Called as a callback from the beforeexpand listener fired by <a href=\"#!/api/Ext.data.NodeInterface-method-expand\" rel=\"Ext.data.NodeInterface-method-expand\" class=\"docClass\">expand</a> when the child nodes have been loaded and appended.</p>\n"},"remove":{"!type":"fn(this: ?, node: ?, isMove: ?, eOpts: ?)","!doc":"<p>Fires when a child node is removed</p>\n"},"removeAll":{"!type":"fn(destroy?: ?) -> ?","!doc":"<p>Removes all child nodes from this node.</p>\n"},"removeChild":{"!type":"fn(node: ?, destroy?: ?) -> ?","!doc":"<p>Removes a child node from this node.</p>\n"},"replaceChild":{"!type":"fn(newChild: ?, oldChild: ?) -> ?","!doc":"<p>Replaces one child node in this node with another.</p>\n"},"serialize":{"!type":"fn() -> !this","!doc":"<p>Creates an object representation of this node including its children.</p>\n"},"setCollapsed":{"!type":"fn(recursive: ?) -> !this","!doc":"<p>Sets the node into the collapsed state without affecting the UI.</p>\n\n<p>This is called when a node is collapsed with the recursive flag. All the descendant\nnodes will have been removed from the store, but descendant non-leaf nodes still\nneed to be set to the collapsed state without affecting the UI.</p>\n"},"setFirstChild":{"!type":"fn(node: ?) -> !this","!doc":"<p>Sets the first child of this node</p>\n"},"setLastChild":{"!type":"fn(node: ?) -> !this","!doc":"<p>Sets the last child of this node</p>\n"},"sort":{"!type":"fn(this: ?, childNodes: ?, eOpts: ?)","!doc":"<p>Fires when this node's childNodes are sorted.</p>\n"},"updateInfo":{"!type":"fn(commit: ?, info: ?) -> !this","!doc":"<p>Updates general data of this node like isFirst, isLast, depth. This\nmethod is internally called after a node is moved. This shouldn't\nhave to be called by the developer unless they are creating custom\nTree plugins.</p>\n"},"applyFields":{"!type":"fn(modelClass: ?, addFields: ?) -> !this"},"decorate":{"!type":"fn(modelClass: ?) -> !this","!doc":"<p>This method allows you to decorate a Model's class to implement the NodeInterface.\nThis adds a set of methods, new events, new properties and new fields on every Record.</p>\n"},"getPrototypeBody":{"!type":"fn() -> !this"},"append":{"!type":"fn(this: ?, node: ?, index: ?, eOpts: ?)","!doc":"<p>Fires when a new child node is appended</p>\n"},"beforeappend":{"!type":"fn(this: ?, node: ?, eOpts: ?)","!doc":"<p>Fires before a new child is appended, return false to cancel the append.</p>\n"},"beforecollapse":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before this node is collapsed.</p>\n"},"beforeexpand":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before this node is expanded.</p>\n"},"beforeinsert":{"!type":"fn(this: ?, node: ?, refNode: ?, eOpts: ?)","!doc":"<p>Fires before a new child is inserted, return false to cancel the insert.</p>\n"},"beforemove":{"!type":"fn(this: ?, oldParent: ?, newParent: ?, index: ?, eOpts: ?)","!doc":"<p>Fires before this node is moved to a new location in the tree. Return false to cancel the move.</p>\n"},"beforeremove":{"!type":"fn(this: ?, node: ?, isMove: ?, eOpts: ?)","!doc":"<p>Fires before a child is removed, return false to cancel the remove.</p>\n"},"insert":{"!type":"fn(this: ?, node: ?, refNode: ?, eOpts: ?)","!doc":"<p>Fires when a new child node is inserted.</p>\n"},"move":{"!type":"fn(this: ?, oldParent: ?, newParent: ?, index: ?, eOpts: ?)","!doc":"<p>Fires when this node is moved to a new location in the tree</p>\n"}}},"NodeStore":{"!doc":"<p>Node Store</p>\n","!type":"fn(config: ?)","prototype":{"node":{"!doc":"<p>The Record you want to bind this Store to. Note that\nthis record will be decorated with the <a href=\"#!/api/Ext.data.NodeInterface\" rel=\"Ext.data.NodeInterface\" class=\"docClass\">Ext.data.NodeInterface</a> if this is not the\ncase yet.</p>\n"},"recursive":{"!type":"bool","!doc":"<p>Set this to true if you want this NodeStore to represent\nall the descendents of the node in its flat data collection. This is useful for\nrendering a tree structure to a DataView and is being used internally by\nthe TreeView. Any records that are moved, removed, inserted or appended to the\nnode at any depth below the node this store is bound to will be automatically\nupdated in this Store's internal flat data structure.</p>\n"},"rootVisible":{"!type":"bool","!doc":"<p>False to not include the root node in this Stores collection.</p>\n"},"treeStore":{"!doc":"<p>The TreeStore that is used by this NodeStore's <a href=\"#!/api/Ext.tree.View\" rel=\"Ext.tree.View\" class=\"docClass\">Ext.tree.View</a>.</p>\n"},"isExpandingOrCollapsing":{"!type":"number","!doc":"<p>Recursion level counter. Incremented when expansion or collaping of a node is initiated,\nincluding when nested nodes below the expanding/collapsing root begin expanding or collapsing.</p>\n\n<p>This ensures that collapsestart, collapsecomplete, expandstart and expandcomplete only\nfire on the top level node being collapsed/expanded.</p>\n\n<p>Also, allows listeners to the <code>add</code> and <code>remove</code> events to know whether a collapse of expand is in progress.</p>\n"},"isNodeStore":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated NodeStore, or subclass thereof.</p>\n"},"getTotalCount":{"!type":"fn() -> number","!doc":"<p>NodeStores are never buffered or paged. They are loaded from the TreeStore to reflect all visible\nnodes.\nBufferedRenderer always asks for the <em>total</em> count, so this must return the count.</p>\n"},"handleNodeExpand":{"!type":"fn(parent: ?, records: ?, toAdd: ?) -> !this","!doc":"<p>Collects child nodes to remove into the passed toRemove array.\nWhen available, all descendant nodes are pushed into that array using recursion.</p>\n"},"isVisible":{"!type":"fn(node: ?) -> !this"},"onBulkRemove":{"!type":"fn(parent: ?, childNodes: ?, isMove: ?) -> !this","!doc":"<p>Triggered by NodeInterface's bubbled bulkremove event</p>\n"},"onNodeAppend":{"!type":"fn(parent: ?, node: ?, index: ?) -> !this"},"onNodeCollapse":{"!type":"fn(parent: ?, records: ?, suppressEvent: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Triggered by a NodeInterface's bubbled \"collapse\" event.</p>\n"},"onNodeExpand":{"!type":"fn(parent: ?, records: ?, suppressEvent: ?) -> !this","!doc":"<p>Triggered by a NodeInterface's bubbled \"expand\" event.</p>\n"},"onNodeInsert":{"!type":"fn(parent: ?, node: ?, refNode: ?) -> !this"},"onNodeRemove":{"!type":"fn(parent: ?, node: ?, isMove: ?) -> !this"},"onNodeSort":{"!type":"fn(node: ?, childNodes: ?) -> !this"},"setNode":{"!type":"fn(node: ?) -> !this"}}},"Operation":{"!doc":"<p>Represents a single read or write operation performed by a <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a>. Operation objects are\nused to enable communication between Stores and Proxies. Application developers should rarely need to interact with\nOperation objects directly.</p>\n\n<p>Several Operations can be batched together in a <a href=\"#!/api/Ext.data.Batch\" rel=\"Ext.data.Batch\" class=\"docClass\">batch</a>.</p>\n","!type":"fn(config?: ?)","prototype":{"action":{"!type":"string","!doc":"<p>The action being performed by this Operation. Should be one of 'create', 'read', 'update' or 'destroy'.</p>\n"},"batch":{"!doc":"<p>The batch that this Operation is a part of.</p>\n"},"callback":{"!doc":"<p>Function to execute when operation completed.</p>\n"},"filters":{"!doc":"<p>Optional array of filter objects. Only applies to 'read' actions.</p>\n"},"groupers":{"!doc":"<p>Optional grouping configuration. Only applies to 'read' actions where grouping is desired.</p>\n"},"limit":{"!type":"number","!doc":"<p>The number of records to load. Used on 'read' actions when paging is being used.</p>\n"},"params":{"!doc":"<p>Parameters to pass along with the request when performing the operation.</p>\n"},"scope":{"!doc":"<p>Scope for the <a href=\"#!/api/Ext.data.Operation-cfg-callback\" rel=\"Ext.data.Operation-cfg-callback\" class=\"docClass\">callback</a> function.</p>\n"},"sorters":{"!doc":"<p>Optional array of sorter objects. Only applies to 'read' actions.</p>\n"},"start":{"!type":"number","!doc":"<p>The start index (offset), used in paging when running a 'read' action.</p>\n"},"synchronous":{"!type":"bool","!doc":"<p>True if this Operation is to be executed synchronously. This property is inspected by a\n<a href=\"#!/api/Ext.data.Batch\" rel=\"Ext.data.Batch\" class=\"docClass\">Batch</a> to see if a series of Operations can be executed in parallel or not.</p>\n"},"actionCommitRecordsRe":{"!doc":"<p>The RegExp used to categorize actions that require record commits.</p>\n"},"actionSkipSyncRe":{"!doc":"<p>The RegExp used to categorize actions that skip local record synchronization. This defaults\nto match 'destroy'.</p>\n"},"complete":{"!type":"bool","!doc":"<p>The completion status of this Operation. Use <a href=\"#!/api/Ext.data.Operation-method-isComplete\" rel=\"Ext.data.Operation-method-isComplete\" class=\"docClass\">isComplete</a>.</p>\n"},"error":{"!doc":"<p>The error object passed when <a href=\"#!/api/Ext.data.Operation-method-setException\" rel=\"Ext.data.Operation-method-setException\" class=\"docClass\">setException</a> was called. This could be any object or primitive.</p>\n"},"exception":{"!type":"bool","!doc":"<p>The exception status of this Operation. Use <a href=\"#!/api/Ext.data.Operation-method-hasException\" rel=\"Ext.data.Operation-method-hasException\" class=\"docClass\">hasException</a> and see <a href=\"#!/api/Ext.data.Operation-method-getError\" rel=\"Ext.data.Operation-method-getError\" class=\"docClass\">getError</a>.</p>\n"},"running":{"!type":"bool","!doc":"<p>The run status of this Operation. Use <a href=\"#!/api/Ext.data.Operation-method-isRunning\" rel=\"Ext.data.Operation-method-isRunning\" class=\"docClass\">isRunning</a>.</p>\n"},"started":{"!type":"bool","!doc":"<p>The start status of this Operation. Use <a href=\"#!/api/Ext.data.Operation-method-isStarted\" rel=\"Ext.data.Operation-method-isStarted\" class=\"docClass\">isStarted</a>.</p>\n"},"success":{"!type":"bool","!doc":"<p>Whether the Operation was successful or not. This starts as undefined and is set to true\nor false by the Proxy that is executing the Operation. It is also set to false by <a href=\"#!/api/Ext.data.Operation-method-setException\" rel=\"Ext.data.Operation-method-setException\" class=\"docClass\">setException</a>. Use\n<a href=\"#!/api/Ext.data.Operation-method-wasSuccessful\" rel=\"Ext.data.Operation-method-wasSuccessful\" class=\"docClass\">wasSuccessful</a> to query success status.</p>\n"},"allowWrite":{"!type":"fn() -> bool","!doc":"<p>Checks whether this operation should cause writing to occur.</p>\n"},"commitRecords":{"!type":"fn(serverRecords: ?) -> !this","!doc":"<p>This method is called to commit data to this instance's records given the records in\nthe server response. This is followed by calling <a href=\"#!/api/Ext.data.Model-method-commit\" rel=\"Ext.data.Model-method-commit\" class=\"docClass\">Ext.data.Model.commit</a> on all\nthose records (for 'create' and 'update' actions).</p>\n\n<p>If this <a href=\"#!/api/Ext.data.Operation-cfg-action\" rel=\"Ext.data.Operation-cfg-action\" class=\"docClass\">action</a> is 'destroy', any server records are ignored and the\n<a href=\"#!/api/Ext.data.Model-method-commit\" rel=\"Ext.data.Model-method-commit\" class=\"docClass\">Ext.data.Model.commit</a> method is not called.</p>\n"},"getError":{"!type":"fn() -> ?","!doc":"<p>Returns the error string or object that was set using <a href=\"#!/api/Ext.data.Operation-method-setException\" rel=\"Ext.data.Operation-method-setException\" class=\"docClass\">setException</a></p>\n"},"getRecords":{"!type":"fn() -> ?","!doc":"<p>Returns the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">record</a>s associated with this operation.  For read operations the records as set by the <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a> will be returned (returns <code>null</code> if the proxy has not yet set the records).\nFor create, update, and destroy operations the operation's initially configured records will be returned, although the proxy may modify these records' data at some point after the operation is initialized.</p>\n"},"getResultSet":{"!type":"fn() -> ?","!doc":"<p>Returns the ResultSet object (if set by the Proxy). This object will contain the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model</a>\ninstances as well as meta data such as number of instances fetched, number available etc</p>\n"},"hasException":{"!type":"fn() -> bool","!doc":"<p>Returns true if this Operation encountered an exception (see also <a href=\"#!/api/Ext.data.Operation-method-getError\" rel=\"Ext.data.Operation-method-getError\" class=\"docClass\">getError</a>)</p>\n"},"isComplete":{"!type":"fn() -> bool","!doc":"<p>Returns true if the Operation has been completed</p>\n"},"isRunning":{"!type":"fn() -> bool","!doc":"<p>Returns true if the Operation has been started but has not yet completed.</p>\n"},"isStarted":{"!type":"fn() -> bool","!doc":"<p>Returns true if the Operation has been started. Note that the Operation may have started AND completed, see\n<a href=\"#!/api/Ext.data.Operation-method-isRunning\" rel=\"Ext.data.Operation-method-isRunning\" class=\"docClass\">isRunning</a> to test if the Operation is currently running.</p>\n"},"matchClientRec":{"!type":"fn(record: ?) -> !this","!doc":"<p>Private.\nRecord matching function used by commitRecords\nIMPORTANT: This is called in the scope of the clientRec being matched</p>\n"},"setBatch":{"!type":"fn(batch: ?) -> !this","!doc":"<p>Associates this Operation with a Batch</p>\n"},"setCompleted":{"!type":"fn() -> !this","!doc":"<p>Marks the Operation as completed.</p>\n"},"setException":{"!type":"fn(error?: ?) -> !this","!doc":"<p>Marks the Operation as having experienced an exception. Can be supplied with an option error message/object.</p>\n"},"setStarted":{"!type":"fn() -> !this","!doc":"<p>Marks the Operation as started.</p>\n"},"setSuccessful":{"!type":"fn() -> !this","!doc":"<p>Marks the Operation as successful.</p>\n"},"updateRecord":{"!type":"fn(clientRec: ?, serverRec: ?) -> !this"},"wasSuccessful":{"!type":"fn() -> bool","!doc":"<p>Returns true if the Operation has completed and was successful</p>\n"}}},"PageMap":{"!doc":"<p>Private class for use by only Store when configured <code>buffered: true</code>.</p>\n","!type":"fn(config?: ?)","prototype":{"addAll":{"!type":"fn(records: ?) -> !this"},"addPage":{"!type":"fn(pageNumber: ?, records: ?) -> !this"},"clear":{"!type":"fn(initial: ?) -> ?","!doc":"<p>Maintain a generation counter, so that the Store can reject incoming pages destined for the previous generation</p>\n"},"findBy":{"!type":"fn(fn: ?, scope?: ?) -> ?","!doc":"<p>Returns the first record in this page map which elicits a true return value from the\npassed selection function.</p>\n\n<p>**IMPORTANT\nThis can ONLY find records which happen to be cached in the page cache. This will be parts of the dataset around the currently\nvisible zone, or recently visited zones if the pages have not yet been purged from the cache.</p>\n\n<p>This CAN NOT find records which have not been loaded into the cache.**</p>\n\n<p>If full client side searching is required, do not use a buffered store, instead use a regular, fully loaded store and\nuse the <a href=\"#!/api/Ext.grid.plugin.BufferedRenderer\" rel=\"Ext.grid.plugin.BufferedRenderer\" class=\"docClass\">BufferedRenderer</a> plugin to minimize DOM footprint.</p>\n"},"findIndexBy":{"!type":"fn(fn: ?, scope?: ?) -> number","!doc":"<p>Returns the index <em>in the whole dataset</em> of the first record in this page map which elicits a true return value from the\npassed selection function.</p>\n\n<p>**IMPORTANT\nThis can ONLY find records which happen to be cached in the page cache. This will be parts of the dataset around the currently\nvisible zone, or recently visited zones if the pages have not yet been purged from the cache.</p>\n\n<p>This CAN NOT find records which have not been loaded into the cache.**</p>\n\n<p>If full client side searching is required, do not use a buffered store, instead use a regular, fully loaded store and\nuse the <a href=\"#!/api/Ext.grid.plugin.BufferedRenderer\" rel=\"Ext.grid.plugin.BufferedRenderer\" class=\"docClass\">BufferedRenderer</a> plugin to minimize DOM footprint.</p>\n"},"forEach":{"!type":"fn(fn: ?, scope: ?) -> !this"},"getAt":{"!type":"fn(index: ?) -> !this"},"getCount":{"!type":"fn() -> number","!doc":"<p>Gets the number of items in the hash.</p>\n"},"getPage":{"!type":"fn(pageNumber: ?) -> !this"},"getPageFromRecordIndex":{"!type":"fn() -> !this"},"getRange":{"!type":"fn(start: ?, end: ?) -> !this"},"hasPage":{"!type":"fn(pageNumber: ?) -> !this"},"hasRange":{"!type":"fn(start: ?, end: ?) -> !this"},"indexOf":{"!type":"fn(record: ?) -> !this"},"insert":{"!type":"fn() -> !this"},"remove":{"!type":"fn() -> bool","!doc":"<p>Remove an item from the hash.</p>\n"},"removeAt":{"!type":"fn() -> !this"}}},"proxy":{"Ajax":{"!doc":"<p>AjaxProxy is one of the most widely-used ways of getting data into your application. It uses AJAX requests to load\ndata from the server, usually to be placed into a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>. Let's take a look at a typical setup.\nHere we're going to set up a Store that has an AjaxProxy. To prepare, we'll also set up a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a>:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'email']\n});\n\n//The Store contains the AjaxProxy as an inline configuration\nvar store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n    proxy: {\n        type: 'ajax',\n        url : 'users.json'\n    }\n});\n\nstore.load();\n</code></pre>\n\n<p>Our example is going to load user data into a Store, so we start off by defining a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> with\nthe fields that we expect the server to return. Next we set up the Store itself, along with a\n<a href=\"#!/api/Ext.data.Store-cfg-proxy\" rel=\"Ext.data.Store-cfg-proxy\" class=\"docClass\">proxy</a> configuration. This configuration was automatically turned into an\n<a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a> instance, with the url we specified being passed into AjaxProxy's constructor.\nIt's as if we'd done this:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a>({\n    url: 'users.json',\n    model: 'User',\n    reader: 'json'\n});\n</code></pre>\n\n<p>A couple of extra configurations appeared here - <a href=\"#!/api/Ext.data.proxy.Ajax-cfg-model\" rel=\"Ext.data.proxy.Ajax-cfg-model\" class=\"docClass\">model</a> and <a href=\"#!/api/Ext.data.proxy.Ajax-cfg-reader\" rel=\"Ext.data.proxy.Ajax-cfg-reader\" class=\"docClass\">reader</a>. These are set by default when we\ncreate the proxy via the Store - the Store already knows about the Model, and Proxy's default <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Reader</a> is <a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">JsonReader</a>.</p>\n\n<p>Now when we call store.load(), the AjaxProxy springs into action, making a request to the url we configured\n('users.json' in this case). As we're performing a read, it sends a GET request to that url (see\n<a href=\"#!/api/Ext.data.proxy.Ajax-property-actionMethods\" rel=\"Ext.data.proxy.Ajax-property-actionMethods\" class=\"docClass\">actionMethods</a> to customize this - by default any kind of read will be sent as a GET request and any kind of write\nwill be sent as a POST request).</p>\n\n<h1>Limitations</h1>\n\n<p>AjaxProxy cannot be used to retrieve data from other domains. If your application is running on http://domainA.com it\ncannot load data from http://domainB.com because browsers have a built-in security policy that prohibits domains\ntalking to each other via AJAX.</p>\n\n<p>If you need to read data from another domain and can't set up a proxy server (some software that runs on your own\ndomain's web server and transparently forwards requests to http://domainB.com, making it look like they actually came\nfrom http://domainA.com), you can use <a href=\"#!/api/Ext.data.proxy.JsonP\" rel=\"Ext.data.proxy.JsonP\" class=\"docClass\">Ext.data.proxy.JsonP</a> and a technique known as JSON-P (JSON with\nPadding), which can help you get around the problem so long as the server on http://domainB.com is set up to support\nJSON-P responses. See <a href=\"#!/api/Ext.data.proxy.JsonP\" rel=\"Ext.data.proxy.JsonP\" class=\"docClass\">JsonPProxy</a>'s introduction docs for more details.</p>\n\n<h1>Readers and Writers</h1>\n\n<p>AjaxProxy can be configured to use any type of <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Reader</a> to decode the server's response.\nIf no Reader is supplied, AjaxProxy will default to using a <a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">JsonReader</a>. Reader\nconfiguration can be passed in as a simple object, which the Proxy automatically turns into a <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Reader</a> instance:</p>\n\n<pre><code>var proxy = new <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a>({\n    model: 'User',\n    reader: {\n        type: 'xml',\n        root: 'users'\n    }\n});\n\nproxy.getReader(); //returns an <a href=\"#!/api/Ext.data.reader.Xml\" rel=\"Ext.data.reader.Xml\" class=\"docClass\">XmlReader</a> instance based on the config we supplied\n</code></pre>\n\n<h1>Url generation</h1>\n\n<p>AjaxProxy automatically inserts any sorting, filtering, paging and grouping options into the url it generates for\neach request. These are controlled with the following configuration options:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.data.proxy.Ajax-cfg-pageParam\" rel=\"Ext.data.proxy.Ajax-cfg-pageParam\" class=\"docClass\">pageParam</a> - controls how the page number is sent to the server (see also <a href=\"#!/api/Ext.data.proxy.Ajax-cfg-startParam\" rel=\"Ext.data.proxy.Ajax-cfg-startParam\" class=\"docClass\">startParam</a> and <a href=\"#!/api/Ext.data.proxy.Ajax-cfg-limitParam\" rel=\"Ext.data.proxy.Ajax-cfg-limitParam\" class=\"docClass\">limitParam</a>)</li>\n<li><a href=\"#!/api/Ext.data.proxy.Ajax-cfg-sortParam\" rel=\"Ext.data.proxy.Ajax-cfg-sortParam\" class=\"docClass\">sortParam</a> - controls how sort information is sent to the server</li>\n<li><a href=\"#!/api/Ext.data.proxy.Ajax-cfg-groupParam\" rel=\"Ext.data.proxy.Ajax-cfg-groupParam\" class=\"docClass\">groupParam</a> - controls how grouping information is sent to the server</li>\n<li><a href=\"#!/api/Ext.data.proxy.Ajax-cfg-filterParam\" rel=\"Ext.data.proxy.Ajax-cfg-filterParam\" class=\"docClass\">filterParam</a> - controls how filter information is sent to the server</li>\n</ul>\n\n\n<p>Each request sent by AjaxProxy is described by an <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Operation</a>. To see how we can customize\nthe generated urls, let's say we're loading the Proxy with the following Operation:</p>\n\n<pre><code>var operation = new <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Ext.data.Operation</a>({\n    action: 'read',\n    page  : 2\n});\n</code></pre>\n\n<p>Now we'll issue the request for this Operation by calling <a href=\"#!/api/Ext.data.proxy.Ajax-method-read\" rel=\"Ext.data.proxy.Ajax-method-read\" class=\"docClass\">read</a>:</p>\n\n<pre><code>var proxy = new <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a>({\n    url: '/users'\n});\n\nproxy.read(operation); //GET /users?page=2\n</code></pre>\n\n<p>Easy enough - the Proxy just copied the page property from the Operation. We can customize how this page data is sent\nto the server:</p>\n\n<pre><code>var proxy = new <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a>({\n    url: '/users',\n    pageParam: 'pageNumber'\n});\n\nproxy.read(operation); //GET /users?pageNumber=2\n</code></pre>\n\n<p>Alternatively, our Operation could have been configured to send start and limit parameters instead of page:</p>\n\n<pre><code>var operation = new <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Ext.data.Operation</a>({\n    action: 'read',\n    start : 50,\n    limit : 25\n});\n\nvar proxy = new <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a>({\n    url: '/users'\n});\n\nproxy.read(operation); //GET /users?start=50&amp;limit;=25\n</code></pre>\n\n<p>Again we can customize this url:</p>\n\n<pre><code>var proxy = new <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a>({\n    url: '/users',\n    startParam: 'startIndex',\n    limitParam: 'limitIndex'\n});\n\nproxy.read(operation); //GET /users?startIndex=50&amp;limitIndex;=25\n</code></pre>\n\n<p>AjaxProxy will also send sort and filter information to the server. Let's take a look at how this looks with a more\nexpressive Operation object:</p>\n\n<pre><code>var operation = new <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Ext.data.Operation</a>({\n    action: 'read',\n    sorters: [\n        new <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a>({\n            property : 'name',\n            direction: 'ASC'\n        }),\n        new <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a>({\n            property : 'age',\n            direction: 'DESC'\n        })\n    ],\n    filters: [\n        new <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Ext.util.Filter</a>({\n            property: 'eyeColor',\n            value   : 'brown'\n        })\n    ]\n});\n</code></pre>\n\n<p>This is the type of object that is generated internally when loading a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> with sorters and\nfilters defined. By default the AjaxProxy will JSON encode the sorters and filters, resulting in something like this\n(note that the url is escaped before sending the request, but is left unescaped here for clarity):</p>\n\n<pre><code>var proxy = new <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a>({\n    url: '/users'\n});\n\nproxy.read(operation); //GET /users?sort=[{\"property\":\"name\",\"direction\":\"ASC\"},{\"property\":\"age\",\"direction\":\"DESC\"}]&amp;filter;=[{\"property\":\"eyeColor\",\"value\":\"brown\"}]\n</code></pre>\n\n<p>We can again customize how this is created by supplying a few configuration options. Let's say our server is set up\nto receive sorting information is a format like \"sortBy=name#ASC,age#DESC\". We can configure AjaxProxy to provide\nthat format like this:</p>\n\n<pre><code> var proxy = new <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a>({\n     url: '/users',\n     sortParam: 'sortBy',\n     filterParam: 'filterBy',\n\n     //our custom implementation of sorter encoding - turns our sorters into \"name#ASC,age#DESC\"\n     encodeSorters: function(sorters) {\n         var length   = sorters.length,\n             sortStrs = [],\n             sorter, i;\n\n         for (i = 0; i &lt; length; i++) {\n             sorter = sorters[i];\n\n             sortStrs[i] = sorter.property + '#' + sorter.direction\n         }\n\n         return sortStrs.join(\",\");\n     }\n });\n\n proxy.read(operation); //GET /users?sortBy=name#ASC,age#DESC&amp;filterBy;=[{\"property\":\"eyeColor\",\"value\":\"brown\"}]\n</code></pre>\n\n<p>We can also provide a custom <a href=\"#!/api/Ext.data.proxy.Ajax-method-encodeFilters\" rel=\"Ext.data.proxy.Ajax-method-encodeFilters\" class=\"docClass\">encodeFilters</a> function to encode our filters.</p>\n","!type":"fn(config?: ?)","prototype":{"binary":{"!type":"bool","!doc":"<p>True to request binary data from the server.  This feature requires\nthe use of a binary reader such as AMF Reader</p>\n"},"headers":{"!doc":"<p>Any headers to add to the Ajax request. Defaults to undefined.</p>\n"},"actionMethods":{"!doc":"<p>Mapping of action name to HTTP request method. In the basic AjaxProxy these are set to 'GET' for 'read' actions\nand 'POST' for 'create', 'update' and 'destroy' actions. The <a href=\"#!/api/Ext.data.proxy.Rest\" rel=\"Ext.data.proxy.Rest\" class=\"docClass\">Ext.data.proxy.Rest</a> maps these to the\ncorrect RESTful methods.</p>\n"},"createRequestCallback":{"!type":"fn(request: ?, operation: ?, callback: ?, scope: ?) -> ?","!doc":"<p>TODO: This is currently identical to the JsonPProxy version except for the return function's signature. There is a lot\nof code duplication inside the returned function so we need to find a way to DRY this up.</p>\n"},"getMethod":{"!type":"fn(request: ?) -> string","!doc":"<p>Returns the HTTP method name for a given request. By default this returns based on a lookup on\n<a href=\"#!/api/Ext.data.proxy.Ajax-property-actionMethods\" rel=\"Ext.data.proxy.Ajax-property-actionMethods\" class=\"docClass\">actionMethods</a>.</p>\n"}}},"Server":{"prototype":{"api":{"!doc":"<p>Specific urls to call on CRUD action methods \"create\", \"read\", \"update\" and \"destroy\". Defaults to:</p>\n\n<pre><code>api: {\n    create  : undefined,\n    read    : undefined,\n    update  : undefined,\n    destroy : undefined\n}\n</code></pre>\n\n<p>The url is built based upon the action being executed [create|read|update|destroy] using the commensurate\n<a href=\"#!/api/Ext.data.proxy.Server-cfg-api\" rel=\"Ext.data.proxy.Server-cfg-api\" class=\"docClass\">api</a> property, or if undefined default to the configured\n<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>.<a href=\"#!/api/Ext.data.proxy.Server-cfg-url\" rel=\"Ext.data.proxy.Server-cfg-url\" class=\"docClass\">url</a>.</p>\n\n<p>For example:</p>\n\n<pre><code>api: {\n    create  : '/controller/new',\n    read    : '/controller/load',\n    update  : '/controller/update',\n    destroy : '/controller/destroy_action'\n}\n</code></pre>\n\n<p>If the specific URL for a given CRUD action is undefined, the CRUD action request will be directed to the\nconfigured <a href=\"#!/api/Ext.data.proxy.Server-cfg-url\" rel=\"Ext.data.proxy.Server-cfg-url\" class=\"docClass\">url</a>.</p>\n"},"cacheString":{"!type":"string","!doc":"<p>The name of the cache param added to the url when using noCache. Defaults to \"_dc\".</p>\n"},"directionParam":{"!type":"string","!doc":"<p>The name of the direction parameter to send in a request. <strong>This is only used when simpleSortMode is set to\ntrue.</strong></p>\n"},"extraParams":{"!doc":"<p>Extra parameters that will be included on every request. Individual requests with params of the same name\nwill override these params when they are in conflict.</p>\n"},"filterParam":{"!type":"string","!doc":"<p>The name of the 'filter' parameter to send in a request. Defaults to 'filter'. Set this to undefined if you don't\nwant to send a filter parameter.</p>\n"},"groupDirectionParam":{"!type":"string","!doc":"<p>The name of the direction parameter to send in a request. <strong>This is only used when simpleGroupMode is set to\ntrue.</strong></p>\n"},"groupParam":{"!type":"string","!doc":"<p>The name of the 'group' parameter to send in a request. Defaults to 'group'. Set this to undefined if you don't\nwant to send a group parameter.</p>\n"},"idParam":{"!type":"string","!doc":"<p>The name of the parameter which carries the id of the entity being operated upon.</p>\n"},"limitParam":{"!type":"string","!doc":"<p>The name of the 'limit' parameter to send in a request. Defaults to 'limit'. Set this to undefined if you don't\nwant to send a limit parameter.</p>\n"},"noCache":{"!type":"bool","!doc":"<p>Disable caching by adding a unique parameter name to the request. Set to false to allow caching. Defaults to true.</p>\n"},"pageParam":{"!type":"string","!doc":"<p>The name of the 'page' parameter to send in a request. Defaults to 'page'. Set this to undefined if you don't\nwant to send a page parameter.</p>\n"},"simpleGroupMode":{"!type":"bool","!doc":"<p>Enabling simpleGroupMode in conjunction with remoteGroup will only send one group property and a direction when a\nremote group is requested. The <a href=\"#!/api/Ext.data.proxy.Server-cfg-groupDirectionParam\" rel=\"Ext.data.proxy.Server-cfg-groupDirectionParam\" class=\"docClass\">groupDirectionParam</a> and <a href=\"#!/api/Ext.data.proxy.Server-cfg-groupParam\" rel=\"Ext.data.proxy.Server-cfg-groupParam\" class=\"docClass\">groupParam</a> will be sent with the property name and either 'ASC'\nor 'DESC'.</p>\n"},"simpleSortMode":{"!type":"bool","!doc":"<p>Enabling simpleSortMode in conjunction with remoteSort will only send one sort property and a direction when a\nremote sort is requested. The <a href=\"#!/api/Ext.data.proxy.Server-cfg-directionParam\" rel=\"Ext.data.proxy.Server-cfg-directionParam\" class=\"docClass\">directionParam</a> and <a href=\"#!/api/Ext.data.proxy.Server-cfg-sortParam\" rel=\"Ext.data.proxy.Server-cfg-sortParam\" class=\"docClass\">sortParam</a> will be sent with the property name\nand either 'ASC' or 'DESC'.</p>\n"},"sortParam":{"!type":"string","!doc":"<p>The name of the 'sort' parameter to send in a request. Defaults to 'sort'. Set this to undefined if you don't\nwant to send a sort parameter.</p>\n"},"startParam":{"!type":"string","!doc":"<p>The name of the 'start' parameter to send in a request. Defaults to 'start'. Set this to undefined if you don't\nwant to send a start parameter.</p>\n"},"timeout":{"!type":"number","!doc":"<p>The number of milliseconds to wait for a response. Defaults to 30000 milliseconds (30 seconds).</p>\n"},"url":{"!type":"string","!doc":"<p>The URL from which to request the data object.</p>\n"},"afterRequest":{"!type":"fn(request: ?, success: ?) -> !this","!doc":"<p>Optional callback function which can be used to clean up after a request has been completed.</p>\n"},"applyEncoding":{"!type":"fn(value: ?) -> ?","!doc":"<p>Encode any values being sent to the server. Can be overridden in subclasses.</p>\n"},"buildRequest":{"!type":"fn(operation: ?) -> ?","!doc":"<p>Creates an <a href=\"#!/api/Ext.data.Request\" rel=\"Ext.data.Request\" class=\"docClass\">Request</a> object from <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Operation</a>.</p>\n\n<p>This gets called from doRequest methods in subclasses of Server proxy.</p>\n"},"buildUrl":{"!type":"fn(request: ?) -> string","!doc":"<p>Generates a url based on a given <a href=\"#!/api/Ext.data.Request\" rel=\"Ext.data.Request\" class=\"docClass\">Ext.data.Request</a> object. By default, ServerProxy's buildUrl will add the\ncache-buster param to the end of the url. Subclasses may need to perform additional modifications to the url.</p>\n"},"create":{"!type":"fn() -> !this","!doc":"<p>in a ServerProxy all four CRUD operations are executed in the same manner, so we delegate to doRequest in each case</p>\n"},"destroy":{"!type":"fn() -> !this","!doc":"<p>Performs the given destroy operation.</p>\n"},"doRequest":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>In ServerProxy subclasses, the <a href=\"#!/api/Ext.data.proxy.Server-method-create\" rel=\"Ext.data.proxy.Server-method-create\" class=\"docClass\">create</a>, <a href=\"#!/api/Ext.data.proxy.Server-method-read\" rel=\"Ext.data.proxy.Server-method-read\" class=\"docClass\">read</a>, <a href=\"#!/api/Ext.data.proxy.Server-method-update\" rel=\"Ext.data.proxy.Server-method-update\" class=\"docClass\">update</a> and <a href=\"#!/api/Ext.data.proxy.Server-method-destroy\" rel=\"Ext.data.proxy.Server-method-destroy\" class=\"docClass\">destroy</a> methods all\npass through to doRequest. Each ServerProxy subclass must implement the doRequest method - see <a href=\"#!/api/Ext.data.proxy.JsonP\" rel=\"Ext.data.proxy.JsonP\" class=\"docClass\">Ext.data.proxy.JsonP</a> and <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a> for examples. This method carries the same signature as\neach of the methods that delegate to it.</p>\n"},"encodeFilters":{"!type":"fn(filters: ?) -> string","!doc":"<p>Encodes the array of <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Ext.util.Filter</a> objects into a string to be sent in the request url. By default,\nthis simply JSON-encodes the filter data</p>\n"},"encodeSorters":{"!type":"fn(sorters: ?) -> string","!doc":"<p>Encodes the array of <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Ext.util.Sorter</a> objects into a string to be sent in the request url. By default,\nthis simply JSON-encodes the sorter data</p>\n"},"extractResponseData":{"!type":"fn(response: ?) -> ?","!doc":"<p>Template method to allow subclasses to specify how to get the response for the reader.</p>\n"},"getParams":{"!type":"fn(operation: ?) -> !this","!doc":"<p>Copy any sorters, filters etc into the params so they can be sent over the wire</p>\n"},"getUrl":{"!type":"fn(request: ?) -> string","!doc":"<p>Get the url for the request taking into account the order of priority,\n- The request\n- The api\n- The url</p>\n"},"onDestroy":{"!type":"fn() -> !this"},"processResponse":{"!type":"fn(success: ?, operation: ?, request: ?, response: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Should this be documented as protected method?</p>\n"},"read":{"!type":"fn() -> !this","!doc":"<p>Performs the given read operation.</p>\n"},"setException":{"!type":"fn(operation: ?, response: ?) -> !this","!doc":"<p>Sets up an exception on the operation</p>\n"},"setExtraParam":{"!type":"fn(name: ?, value: ?) -> !this","!doc":"<p>Sets a value in the underlying <a href=\"#!/api/Ext.data.proxy.Server-cfg-extraParams\" rel=\"Ext.data.proxy.Server-cfg-extraParams\" class=\"docClass\">extraParams</a>.</p>\n"},"update":{"!type":"fn() -> !this","!doc":"<p>Performs the given update operation.</p>\n"},"exception":{"!type":"fn(this: ?, response: ?, operation: ?, eOpts: ?)","!doc":"<p>Fires when the server returns an exception. This event may also be listened\nto in the event that a request has timed out or has been aborted.</p>\n"}},"!doc":"<p>ServerProxy is a superclass of <a href=\"#!/api/Ext.data.proxy.JsonP\" rel=\"Ext.data.proxy.JsonP\" class=\"docClass\">JsonPProxy</a> and <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">AjaxProxy</a>, and\nwould not usually be used directly.</p>\n\n<p>ServerProxy should ideally be named HttpProxy as it is a superclass for all HTTP proxies - for Ext JS 4.x it has been\ncalled ServerProxy to enable any 3.x applications that reference the HttpProxy to continue to work (HttpProxy is now\nan alias of AjaxProxy).</p>\n","!type":"fn(config?: ?)"},"Proxy":{"prototype":{"batchActions":{"!type":"bool","!doc":"<p>True to batch actions of a particular type when synchronizing the store. Defaults to true.</p>\n"},"batchOrder":{"!type":"string","!doc":"<p>Comma-separated ordering 'create', 'update' and 'destroy' actions when batching. Override this to set a different\norder for the batched CRUD actions to be executed in. Defaults to 'create,update,destroy'.</p>\n"},"defaultReaderType":{"!type":"string","!doc":"<p>The default registered reader type. Defaults to 'json'.</p>\n"},"defaultWriterType":{"!type":"string","!doc":"<p>The default registered writer type. Defaults to 'json'.</p>\n"},"model":{"!doc":"<p>The name of the Model to tie to this Proxy. Can be either the string name of the Model, or a reference to the\nModel constructor. Required.</p>\n"},"reader":{"!doc":"<p>The <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a> to use to decode the server's response or data read from client. This can either be a\nReader instance, a config object or just a valid Reader type name (e.g. 'json', 'xml').</p>\n"},"writer":{"!doc":"<p>The <a href=\"#!/api/Ext.data.writer.Writer\" rel=\"Ext.data.writer.Writer\" class=\"docClass\">Ext.data.writer.Writer</a> to use to encode any request sent to the server or saved to client. This can either be\na Writer instance, a config object or just a valid Writer type name (e.g. 'json', 'xml').</p>\n"},"isProxy":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Proxy, or subclass thereof.</p>\n"},"isSynchronous":{"!type":"bool","!doc":"<p>Identifies the proxy as (a)synchronous.</p>\n"},"batch":{"!type":"fn(options: ?) -> ?","!doc":"<p>Performs a batch of <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Operations</a>, in the order specified by <a href=\"#!/api/Ext.data.proxy.Proxy-cfg-batchOrder\" rel=\"Ext.data.proxy.Proxy-cfg-batchOrder\" class=\"docClass\">batchOrder</a>. Used\ninternally by <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>'s <a href=\"#!/api/Ext.data.Store-method-sync\" rel=\"Ext.data.Store-method-sync\" class=\"docClass\">sync</a> method. Example usage:</p>\n\n<pre><code>myProxy.batch({\n    create : [myModel1, myModel2],\n    update : [myModel3],\n    destroy: [myModel4, myModel5]\n});\n</code></pre>\n\n<p>Where the myModel* above are <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> instances - in this case 1 and 2 are new instances and\nhave not been saved before, 3 has been saved previously but needs to be updated, and 4 and 5 have already been\nsaved but should now be destroyed.</p>\n\n<p>Note that the previous version of this method took 2 arguments (operations and listeners). While this is still\nsupported for now, the current signature is now a single <code>options</code> argument that can contain both operations and\nlisteners, in addition to other options. The multi-argument signature will likely be deprecated in a future release.</p>\n"},"clone":{"!type":"fn() -> !this"},"getModel":{"!type":"fn() -> ?","!doc":"<p>Returns the model attached to this Proxy</p>\n"},"getReader":{"!type":"fn() -> ?","!doc":"<p>Returns the reader currently attached to this proxy instance</p>\n"},"getWriter":{"!type":"fn() -> ?","!doc":"<p>Returns the writer currently attached to this proxy instance</p>\n"},"onBatchComplete":{"!type":"fn(batchOptions: ?, batch: ?) -> !this","!doc":"<p>The internal callback that the proxy uses to call any specified user callbacks after completion of a batch</p>\n"},"onMetaChange":{"!type":"fn(meta: ?) -> !this","!doc":"<p>Called each time the reader's onMetaChange is called so that the proxy can fire the metachange event</p>\n"},"setModel":{"!type":"fn(model: ?, setOnStore: ?) -> !this","!doc":"<p>Sets the model associated with this proxy. This will only usually be called by a Store</p>\n"},"setReader":{"!type":"fn(reader: ?) -> ?","!doc":"<p>Sets the Proxy's Reader by string, config object or Reader instance</p>\n"},"setWriter":{"!type":"fn(writer: ?) -> ?","!doc":"<p>Sets the Proxy's Writer by string, config object or Writer instance</p>\n"},"metachange":{"!type":"fn(this: ?, meta: ?, eOpts: ?)","!doc":"<p>Fires when this proxy's reader provides new metadata. Metadata usually consists\nof new field definitions, but can include any configuration data required by an\napplication, and can be processed as needed in the event handler.\nThis event is currently only fired for JsonReaders. Note that this event is also\npropagated by <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>, which is typically where it would be handled.</p>\n"},"create":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Performs the given create operation.</p>\n"},"destroy":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Performs the given destroy operation.</p>\n"},"read":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Performs the given read operation.</p>\n"},"update":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Performs the given update operation.</p>\n"}},"!doc":"<p>Proxies are used by <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Stores</a> to handle the loading and saving of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a>\ndata. Usually developers will not need to create or interact with proxies directly.</p>\n\n<h1>Types of Proxy</h1>\n\n<p>There are two main types of Proxy - <a href=\"#!/api/Ext.data.proxy.Client\" rel=\"Ext.data.proxy.Client\" class=\"docClass\">Client</a> and <a href=\"#!/api/Ext.data.proxy.Server\" rel=\"Ext.data.proxy.Server\" class=\"docClass\">Server</a>.\nThe Client proxies save their data locally and include the following subclasses:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.data.proxy.LocalStorage\" rel=\"Ext.data.proxy.LocalStorage\" class=\"docClass\">LocalStorageProxy</a> - saves its data to localStorage if the browser supports it</li>\n<li><a href=\"#!/api/Ext.data.proxy.SessionStorage\" rel=\"Ext.data.proxy.SessionStorage\" class=\"docClass\">SessionStorageProxy</a> - saves its data to sessionStorage if the browsers supports it</li>\n<li><a href=\"#!/api/Ext.data.proxy.Memory\" rel=\"Ext.data.proxy.Memory\" class=\"docClass\">MemoryProxy</a> - holds data in memory only, any data is lost when the page is refreshed</li>\n</ul>\n\n\n<p>The Server proxies save their data by sending requests to some remote server. These proxies include:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ajax</a> - sends requests to a server on the same domain</li>\n<li><a href=\"#!/api/Ext.data.proxy.JsonP\" rel=\"Ext.data.proxy.JsonP\" class=\"docClass\">JsonP</a> - uses JSON-P to send requests to a server on a different domain</li>\n<li><a href=\"#!/api/Ext.data.proxy.Rest\" rel=\"Ext.data.proxy.Rest\" class=\"docClass\">Rest</a> - uses RESTful HTTP methods (GET/PUT/POST/DELETE) to communicate with server</li>\n<li><a href=\"#!/api/Ext.data.proxy.Direct\" rel=\"Ext.data.proxy.Direct\" class=\"docClass\">Direct</a> - uses <a href=\"#!/api/Ext.direct.Manager\" rel=\"Ext.direct.Manager\" class=\"docClass\">Ext.direct.Manager</a> to send requests</li>\n</ul>\n\n\n<p>Proxies operate on the principle that all operations performed are either Create, Read, Update or Delete. These four\noperations are mapped to the methods <a href=\"#!/api/Ext.data.proxy.Proxy-method-create\" rel=\"Ext.data.proxy.Proxy-method-create\" class=\"docClass\">create</a>, <a href=\"#!/api/Ext.data.proxy.Proxy-method-read\" rel=\"Ext.data.proxy.Proxy-method-read\" class=\"docClass\">read</a>, <a href=\"#!/api/Ext.data.proxy.Proxy-method-update\" rel=\"Ext.data.proxy.Proxy-method-update\" class=\"docClass\">update</a> and <a href=\"#!/api/Ext.data.proxy.Proxy-method-destroy\" rel=\"Ext.data.proxy.Proxy-method-destroy\" class=\"docClass\">destroy</a>\nrespectively. Each Proxy subclass implements these functions.</p>\n\n<p>The CRUD methods each expect an <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Operation</a> object as the sole argument. The Operation\nencapsulates information about the action the Store wishes to perform, the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model</a> instances\nthat are to be modified, etc. See the <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Operation</a> documentation for more details. Each CRUD\nmethod also accepts a callback function to be called asynchronously on completion.</p>\n\n<p>Proxies also support batching of Operations via a <a href=\"#!/api/Ext.data.Batch\" rel=\"Ext.data.Batch\" class=\"docClass\">batch</a> object, invoked by the <a href=\"#!/api/Ext.data.proxy.Proxy-method-batch\" rel=\"Ext.data.proxy.Proxy-method-batch\" class=\"docClass\">batch</a>\nmethod.</p>\n","!type":"fn(config?: ?)"},"Client":{"!doc":"<p>Base class for any client-side storage. Used as a superclass for <a href=\"#!/api/Ext.data.proxy.Memory\" rel=\"Ext.data.proxy.Memory\" class=\"docClass\">Memory</a> and\n<a href=\"#!/api/Ext.data.proxy.WebStorage\" rel=\"Ext.data.proxy.WebStorage\" class=\"docClass\">Web Storage</a> proxies. Do not use directly, use one of the subclasses instead.</p>\n","!type":"fn(config?: ?)","prototype":{"isSynchronous":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify that requests made on this proxy are\nperformed synchronously</p>\n"},"clear":{"!type":"fn() -> !this","!doc":"<p>Abstract function that must be implemented by each ClientProxy subclass. This should purge all record data\nfrom the client side storage, as well as removing any supporting data (such as lists of record IDs)</p>\n"}}},"Direct":{"!doc":"<p>This class is used to send requests to the server using <a href=\"#!/api/Ext.direct.Manager\" rel=\"Ext.direct.Manager\" class=\"docClass\">Ext.Direct</a>. When a\nrequest is made, the transport mechanism is handed off to the appropriate\n<a href=\"#!/api/Ext.direct.RemotingProvider\" rel=\"Ext.direct.RemotingProvider\" class=\"docClass\">Provider</a> to complete the call.</p>\n\n<h1>Specifying the function</h1>\n\n<p>This proxy expects a Direct remoting method to be passed in order to be able to complete requests.\nThis can be done by specifying the <a href=\"#!/api/Ext.data.proxy.Direct-cfg-directFn\" rel=\"Ext.data.proxy.Direct-cfg-directFn\" class=\"docClass\">directFn</a> configuration. This will use the same direct\nmethod for all requests. Alternatively, you can provide an <a href=\"#!/api/Ext.data.proxy.Direct-cfg-api\" rel=\"Ext.data.proxy.Direct-cfg-api\" class=\"docClass\">api</a> configuration. This\nallows you to specify a different remoting method for each CRUD action.</p>\n\n<h1>Parameters</h1>\n\n<p>This proxy provides options to help configure which parameters will be sent to the server.\nBy specifying the <a href=\"#!/api/Ext.data.proxy.Direct-cfg-paramsAsHash\" rel=\"Ext.data.proxy.Direct-cfg-paramsAsHash\" class=\"docClass\">paramsAsHash</a> option, it will send an object literal containing each\nof the passed parameters. The <a href=\"#!/api/Ext.data.proxy.Direct-cfg-paramOrder\" rel=\"Ext.data.proxy.Direct-cfg-paramOrder\" class=\"docClass\">paramOrder</a> option can be used to specify the order in which\nthe remoting method parameters are passed.</p>\n\n<h1>Example Usage</h1>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['firstName', 'lastName'],\n    proxy: {\n        type: 'direct',\n        directFn: MyApp.getUsers,\n        paramOrder: 'id' // Tells the proxy to pass the id as the first parameter to the remoting method.\n    }\n});\nUser.load(1);\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"api":{"!doc":"<p>The same as <a href=\"#!/api/Ext.data.proxy.Server-cfg-api\" rel=\"Ext.data.proxy.Server-cfg-api\" class=\"docClass\">Ext.data.proxy.Server.api</a>, however instead of providing urls, you should provide a direct\nfunction call. See <a href=\"#!/api/Ext.data.proxy.Direct-cfg-directFn\" rel=\"Ext.data.proxy.Direct-cfg-directFn\" class=\"docClass\">directFn</a>.</p>\n"},"directFn":{"!doc":"<p>Function to call when executing a request. directFn is a simple alternative to defining the api configuration-parameter\nfor Store's which will not implement a full CRUD api. The directFn may also be a string reference to the fully qualified\nname of the function, for example: 'MyApp.company.GetProfile'. This can be useful when using dynamic loading. The string\nwill be looked up when the proxy is created.</p>\n"},"extraParams":{"!doc":"<p>Extra parameters that will be included on every read request. Individual requests with params\nof the same name will override these params when they are in conflict.</p>\n"},"paramOrder":{"!doc":"<p>Defaults to undefined. A list of params to be executed server side.  Specify the params in the order in\nwhich they must be executed on the server-side as either (1) an Array of String values, or (2) a String\nof params delimited by either whitespace, comma, or pipe. For example, any of the following would be\nacceptable:</p>\n\n<pre><code>paramOrder: ['param1','param2','param3']\nparamOrder: 'param1 param2 param3'\nparamOrder: 'param1,param2,param3'\nparamOrder: 'param1|param2|param'\n</code></pre>\n"},"paramsAsHash":{"!type":"bool","!doc":"<p>Send parameters as a collection of named arguments.\nProviding a <a href=\"#!/api/Ext.data.proxy.Direct-cfg-paramOrder\" rel=\"Ext.data.proxy.Direct-cfg-paramOrder\" class=\"docClass\">paramOrder</a> nullifies this configuration.</p>\n"},"applyEncoding":{"!doc":"<p>Inherit docs. We don't apply any encoding here because\nall of the direct requests go out as jsonData</p>\n"},"paramOrderRe":{"!doc":"<p>private</p>\n"},"buildUrl":{"!type":"fn() -> string","!doc":"<p>inherit docs</p>\n"},"createRequestCallback":{"!type":"fn(request: ?, operation: ?, callback: ?, scope: ?) -> !this"},"doRequest":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>In ServerProxy subclasses, the <a href=\"#!/api/Ext.data.proxy.Direct-method-create\" rel=\"Ext.data.proxy.Direct-method-create\" class=\"docClass\">create</a>, <a href=\"#!/api/Ext.data.proxy.Direct-method-read\" rel=\"Ext.data.proxy.Direct-method-read\" class=\"docClass\">read</a>, <a href=\"#!/api/Ext.data.proxy.Direct-method-update\" rel=\"Ext.data.proxy.Direct-method-update\" class=\"docClass\">update</a> and <a href=\"#!/api/Ext.data.proxy.Direct-method-destroy\" rel=\"Ext.data.proxy.Direct-method-destroy\" class=\"docClass\">destroy</a> methods all\npass through to doRequest. Each ServerProxy subclass must implement the doRequest method - see <a href=\"#!/api/Ext.data.proxy.JsonP\" rel=\"Ext.data.proxy.JsonP\" class=\"docClass\">Ext.data.proxy.JsonP</a> and <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ext.data.proxy.Ajax</a> for examples. This method carries the same signature as\neach of the methods that delegate to it.</p>\n"},"extractResponseData":{"!type":"fn(response: ?) -> ?","!doc":"<p>inherit docs</p>\n"},"resolveMethods":{"!type":"fn() -> !this"},"setException":{"!type":"fn(operation: ?, response: ?) -> !this","!doc":"<p>inherit docs</p>\n"}}},"JsonP":{"!doc":"<p>The JsonP proxy is useful when you need to load data from a domain other than the one your application is running on. If\nyour application is running on http://domainA.com it cannot use <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ajax</a> to load its data\nfrom http://domainB.com because cross-domain ajax requests are prohibited by the browser.</p>\n\n<p>We can get around this using a JsonP proxy. JsonP proxy injects a <code>&lt;script&gt;</code> tag into the DOM whenever an AJAX request\nwould usually be made. Let's say we want to load data from http://domainB.com/users - the script tag that would be\ninjected might look like this:</p>\n\n<pre><code>&lt;script src=\"http://domainB.com/users?callback=someCallback\"&gt;&lt;/script&gt;\n</code></pre>\n\n<p>When we inject the tag above, the browser makes a request to that url and includes the response as if it was any\nother type of JavaScript include. By passing a callback in the url above, we're telling domainB's server that we want\nto be notified when the result comes in and that it should call our callback function with the data it sends back. So\nlong as the server formats the response to look like this, everything will work:</p>\n\n<pre><code>someCallback({\n    users: [\n        {\n            id: 1,\n            name: \"Ed Spencer\",\n            email: \"ed@sencha.com\"\n        }\n    ]\n});\n</code></pre>\n\n<p>As soon as the script finishes loading, the 'someCallback' function that we passed in the url is called with the JSON\nobject that the server returned.</p>\n\n<p>JsonP proxy takes care of all of this automatically. It formats the url you pass, adding the callback parameter\nautomatically. It even creates a temporary callback function, waits for it to be called and then puts the data into\nthe Proxy making it look just like you loaded it through a normal <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">AjaxProxy</a>. Here's how\nwe might set that up:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'email']\n});\n\nvar store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n    proxy: {\n        type: 'jsonp',\n        url : 'http://domainB.com/users'\n    }\n});\n\nstore.load();\n</code></pre>\n\n<p>That's all we need to do - JsonP proxy takes care of the rest. In this case the Proxy will have injected a script tag\nlike this:</p>\n\n<pre><code>&lt;script src=\"http://domainB.com/users?callback=callback1\"&gt;&lt;/script&gt;\n</code></pre>\n\n<h1>Customization</h1>\n\n<p>This script tag can be customized using the <a href=\"#!/api/Ext.data.proxy.JsonP-cfg-callbackKey\" rel=\"Ext.data.proxy.JsonP-cfg-callbackKey\" class=\"docClass\">callbackKey</a> configuration. For example:</p>\n\n<pre><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n    proxy: {\n        type: 'jsonp',\n        url : 'http://domainB.com/users',\n        callbackKey: 'theCallbackFunction'\n    }\n});\n\nstore.load();\n</code></pre>\n\n<p>Would inject a script tag like this:</p>\n\n<pre><code>&lt;script src=\"http://domainB.com/users?theCallbackFunction=callback1\"&gt;&lt;/script&gt;\n</code></pre>\n\n<h1>Implementing on the server side</h1>\n\n<p>The remote server side needs to be configured to return data in this format. Here are suggestions for how you might\nachieve this using Java, PHP and ASP.net:</p>\n\n<p>Java:</p>\n\n<pre><code>boolean jsonP = false;\nString cb = request.getParameter(\"callback\");\nif (cb != null) {\n    jsonP = true;\n    response.setContentType(\"text/javascript\");\n} else {\n    response.setContentType(\"application/x-json\");\n}\nWriter out = response.getWriter();\nif (jsonP) {\n    out.write(cb + \"(\");\n}\nout.print(dataBlock.toJsonString());\nif (jsonP) {\n    out.write(\");\");\n}\n</code></pre>\n\n<p>PHP:</p>\n\n<pre><code>$callback = $_REQUEST['callback'];\n\n// Create the output object.\n$output = array('a' =&gt; 'Apple', 'b' =&gt; 'Banana');\n\n//start output\nif ($callback) {\n    header('Content-Type: text/javascript');\n    echo $callback . '(' . json_encode($output) . ');';\n} else {\n    header('Content-Type: application/x-json');\n    echo json_encode($output);\n}\n</code></pre>\n\n<p>ASP.net:</p>\n\n<pre><code>String jsonString = \"{success: true}\";\nString cb = Request.Params.Get(\"callback\");\nString responseString = \"\";\nif (!String.IsNullOrEmpty(cb)) {\n    responseString = cb + \"(\" + jsonString + \")\";\n} else {\n    responseString = jsonString;\n}\nResponse.Write(responseString);\n</code></pre>\n","!type":"fn()","prototype":{"autoAppendParams":{"!type":"bool","!doc":"<p>True to automatically append the request's params to the generated url. Defaults to true</p>\n"},"callbackKey":{"!type":"string","!doc":"<p>See <a href=\"#!/api/Ext.data.JsonP-property-callbackKey\" rel=\"Ext.data.JsonP-property-callbackKey\" class=\"docClass\">Ext.data.JsonP.callbackKey</a>.</p>\n"},"defaultWriterType":{"!type":"string","!doc":"<p>The default registered writer type. Defaults to 'json'.</p>\n"},"recordParam":{"!type":"string","!doc":"<p>The HTTP parameter name to use when passing records to the server and the <a href=\"#!/api/Ext.data.proxy.JsonP-cfg-writer\" rel=\"Ext.data.proxy.JsonP-cfg-writer\" class=\"docClass\">Json writer</a> is not configured\nto <a href=\"#!/api/Ext.data.writer.Json-cfg-encode\" rel=\"Ext.data.writer.Json-cfg-encode\" class=\"docClass\">encode</a> records into a parameter.</p>\n\n<p>The <a href=\"#!/api/Ext.data.proxy.JsonP-method-encodeRecords\" rel=\"Ext.data.proxy.JsonP-method-encodeRecords\" class=\"docClass\">encodeRecords</a> method is used to encode the records to create this parameter's value.</p>\n"},"abort":{"!type":"fn() -> !this","!doc":"<p>Aborts the current server request if one is currently running</p>\n"},"buildUrl":{"!type":"fn(request: ?) -> string","!doc":"<p>Generates a url based on a given <a href=\"#!/api/Ext.data.Request\" rel=\"Ext.data.Request\" class=\"docClass\">Ext.data.Request</a> object. Adds the params and callback function name to the url</p>\n"},"createRequestCallback":{"!type":"fn(request: ?, operation: ?, callback: ?, scope: ?) -> ?","!doc":"<p>Creates and returns the function that is called when the request has completed. The returned function\nshould accept a Response object, which contains the response to be read by the configured Reader.\nThe third argument is the callback that should be called after the request has been completed and the Reader has decoded\nthe response. This callback will typically be the callback passed by a store, e.g. in proxy.read(operation, theCallback, scope)\ntheCallback refers to the callback argument received by this function.\nSee <a href=\"#!/api/Ext.data.proxy.JsonP-method-doRequest\" rel=\"Ext.data.proxy.JsonP-method-doRequest\" class=\"docClass\">doRequest</a> for details.</p>\n"},"doRequest":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Performs the read request to the remote domain. JsonP proxy does not actually create an Ajax request,\ninstead we write out a <code>&lt;script&gt;</code> tag based on the configuration of the internal <a href=\"#!/api/Ext.data.Request\" rel=\"Ext.data.Request\" class=\"docClass\">Ext.data.Request</a> object</p>\n"},"encodeRecords":{"!type":"fn(records: ?) -> ?","!doc":"<p>Encodes an array of records into a value suitable to be added to the request <code>params</code> as the <a href=\"#!/api/Ext.data.proxy.JsonP-cfg-recordParam\" rel=\"Ext.data.proxy.JsonP-cfg-recordParam\" class=\"docClass\">recordParam</a> parameter.\nThis is broken out into its own function so that it can be easily overridden.</p>\n\n<p>The default implementation</p>\n"},"setException":{"!type":"fn(operation: ?, response: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"exception":{"!type":"fn(this: ?, request: ?, operation: ?, eOpts: ?)","!doc":"<p>Fires when the server returns an exception. This event may also be listened\nto in the event that a request has timed out or has been aborted.</p>\n"}}},"LocalStorage":{"!doc":"<p>The LocalStorageProxy uses the new HTML5 localStorage API to save <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> data locally on the\nclient browser. HTML5 localStorage is a key-value store (e.g. cannot save complex objects like JSON), so\nLocalStorageProxy automatically serializes and deserializes data when saving and retrieving it.</p>\n\n<p>localStorage is extremely useful for saving user-specific information without needing to build server-side\ninfrastructure to support it. Let's imagine we're writing a Twitter search application and want to save the user's\nsearches locally so they can easily perform a saved search again later. We'd start by creating a Search model:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Search', {\n    fields: ['id', 'query'],\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    proxy: {\n        type: 'localstorage',\n        id  : 'twitter-Searches'\n    }\n});\n</code></pre>\n\n<p>Our Search model contains just two fields - id and query - plus a Proxy definition. The only configuration we need to\npass to the LocalStorage proxy is an <a href=\"#!/api/Ext.data.proxy.LocalStorage-cfg-id\" rel=\"Ext.data.proxy.LocalStorage-cfg-id\" class=\"docClass\">id</a>. This is important as it separates the Model data in this Proxy from\nall others. The localStorage API puts all data into a single shared namespace, so by setting an id we enable\nLocalStorageProxy to manage the saved Search data.</p>\n\n<p>Saving our data into localStorage is easy and would usually be done with a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>:</p>\n\n<pre><code>//our Store automatically picks up the LocalStorageProxy defined on the Search model\nvar store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: \"Search\"\n});\n\n//loads any existing Search data from localStorage\nstore.load();\n\n//now add some Searches\nstore.add({query: 'Sencha Touch'});\nstore.add({query: 'Ext JS'});\n\n//finally, save our Search data to localStorage\nstore.sync();\n</code></pre>\n\n<p>The LocalStorageProxy automatically gives our new Searches an id when we call store.sync(). It encodes the Model data\nand places it into localStorage. We can also save directly to localStorage, bypassing the Store altogether:</p>\n\n<pre><code>var search = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('Search', {query: 'Sencha Animator'});\n\n//uses the configured LocalStorageProxy to save the new Search to localStorage\nsearch.save();\n</code></pre>\n\n<h1>Limitations</h1>\n\n<p>If this proxy is used in a browser where local storage is not supported, the constructor will throw an error. A local\nstorage proxy requires a unique ID which is used as a key in which all record data are stored in the local storage\nobject.</p>\n\n<p>It's important to supply this unique ID as it cannot be reliably determined otherwise. If no id is provided but the\nattached store has a storeId, the storeId will be used. If neither option is presented the proxy will throw an error.</p>\n","!type":"fn(config?: ?)","prototype":{"getStorageObject":{"!type":"fn() -> ?","!doc":"<p>inherit docs</p>\n"}}},"WebStorage":{"prototype":{"id":{"!type":"string","!doc":"<p>The unique ID used as the key in which all record data are stored in the local storage object.</p>\n"},"cache":{"!doc":"<p>Cached map of records already retrieved by this Proxy. Ensures that the same instance is always retrieved.</p>\n"},"clear":{"!type":"fn() -> !this","!doc":"<p>Destroys all records stored in the proxy and removes all keys and values used to support the proxy from the\nstorage object.</p>\n"},"create":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"destroy":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>inherit</p>\n"},"getIds":{"!type":"fn() -> ?","!doc":"<p>Returns the array of record IDs stored in this Proxy</p>\n"},"getNextId":{"!type":"fn() -> number","!doc":"<p>Returns the next numerical ID that can be used when realizing a model instance (see getRecordCounterKey).\nIncrements the counter.</p>\n"},"getRecord":{"!type":"fn(id: ?) -> ?","!doc":"<p>Fetches record data from the Proxy by ID.</p>\n"},"getRecordCounterKey":{"!type":"fn() -> string","!doc":"<p>Returns the unique key used to store the current record counter for this proxy. This is used internally when\nrealizing models (creating them when they used to be phantoms), in order to give each model instance a unique id.</p>\n"},"getRecordKey":{"!type":"fn(id: ?) -> string","!doc":"<p>Given the id of a record, returns a unique string based on that id and the id of this proxy. This is used when\nstoring data in the local storage object and should prevent naming collisions.</p>\n"},"getTreeData":{"!type":"fn() -> ?","!doc":"<p>Gets tree data and transforms it from key value pairs into a hierarchical structure.</p>\n"},"getTreeKey":{"!type":"fn() -> string","!doc":"<p>Returns the unique key used to store the tree indicator. This is used internally to determine if the stored data is hierarchical</p>\n"},"initialize":{"!type":"fn() -> !this","!doc":"<p>Sets up the Proxy by claiming the key in the storage object that corresponds to the unique id of this Proxy. Called\nautomatically by the constructor, this should not need to be called again unless <a href=\"#!/api/Ext.data.proxy.WebStorage-method-clear\" rel=\"Ext.data.proxy.WebStorage-method-clear\" class=\"docClass\">clear</a> has been called.</p>\n"},"read":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"removeRecord":{"!type":"fn(record: ?) -> ?","!doc":"<p>Physically removes a given record from the local storage and recursively removes children if the record is a tree node. Used internally by <a href=\"#!/api/Ext.data.proxy.WebStorage-method-destroy\" rel=\"Ext.data.proxy.WebStorage-method-destroy\" class=\"docClass\">destroy</a>.</p>\n"},"setIds":{"!type":"fn(ids: ?) -> !this","!doc":"<p>Saves the array of ids representing the set of all records in the Proxy</p>\n"},"setRecord":{"!type":"fn(record: ?, id?: ?) -> !this","!doc":"<p>Saves the given record in the Proxy.</p>\n"},"sortByParentId":{"!type":"fn(node1: ?, node2: ?) -> number","!doc":"<p>Sorter function for sorting records by parentId</p>\n"},"update":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"getStorageObject":{"!type":"fn() -> ?","!doc":"<p>Abstract function which should return the storage object that data will be saved to. This must be implemented\nin each subclass.</p>\n"}},"!doc":"<p>WebStorageProxy is simply a superclass for the <a href=\"#!/api/Ext.data.proxy.LocalStorage\" rel=\"Ext.data.proxy.LocalStorage\" class=\"docClass\">LocalStorage</a> and <a href=\"#!/api/Ext.data.proxy.SessionStorage\" rel=\"Ext.data.proxy.SessionStorage\" class=\"docClass\">SessionStorage</a> proxies. It uses the new HTML5 key/value client-side storage objects to\nsave <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model instances</a> for offline use.</p>\n","!type":"fn(config?: ?)"},"Memory":{"!doc":"<p>In-memory proxy. This proxy simply uses a local variable for data storage/retrieval, so its contents are lost on\nevery page refresh.</p>\n\n<p>Usually this Proxy isn't used directly, serving instead as a helper to a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> where a reader\nis required to load data. For example, say we have a Store for a User model and have some inline data we want to\nload, but this data isn't in quite the right format: we can use a MemoryProxy with a JsonReader to read it into our\nStore:</p>\n\n<pre><code>//this is the model we will be using in the store\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'id',    type: 'int'},\n        {name: 'name',  type: 'string'},\n        {name: 'phone', type: 'string', mapping: 'phoneNumber'}\n    ]\n});\n\n//this data does not line up to our model fields - the phone field is called phoneNumber\nvar data = {\n    users: [\n        {\n            id: 1,\n            name: 'Ed Spencer',\n            phoneNumber: '555 1234'\n        },\n        {\n            id: 2,\n            name: 'Abe Elias',\n            phoneNumber: '666 1234'\n        }\n    ]\n};\n\n//note how we set the 'root' in the reader to match the data structure above\nvar store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    autoLoad: true,\n    model: 'User',\n    data : data,\n    proxy: {\n        type: 'memory',\n        reader: {\n            type: 'json',\n            root: 'users'\n        }\n    }\n});\n</code></pre>\n","!type":"fn(config?: ?)","prototype":{"data":{"!doc":"<p>Optional data to pass to configured Reader.</p>\n"},"enablePaging":{"!type":"bool","!doc":"<p>Configure as <code>true</code> to enable this MemoryProxy to honour a read operation's <code>start</code> and <code>limit</code> options.</p>\n\n<p>When <code>true</code>, read operations will be able to read <em>pages</em> of records from the data object.</p>\n"},"clear":{"!type":"fn() -> !this","!doc":"<p>Abstract function that must be implemented by each ClientProxy subclass. This should purge all record data\nfrom the client side storage, as well as removing any supporting data (such as lists of record IDs)</p>\n"},"create":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Currently this is a hard-coded method that simply commits any records and sets the operation to successful,\nthen calls the callback function, if provided. It is essentially mocking a server call in memory, but since\nthere is no real back end in this case there's not much else to do. This method can be easily overridden to\nimplement more complex logic if needed.</p>\n"},"destroy":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Currently this is a hard-coded method that simply commits any records and sets the operation to successful,\nthen calls the callback function, if provided. It is essentially mocking a server call in memory, but since\nthere is no real back end in this case there's not much else to do. This method can be easily overridden to\nimplement more complex logic if needed.</p>\n"},"read":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Reads data from the configured <a href=\"#!/api/Ext.data.proxy.Memory-cfg-data\" rel=\"Ext.data.proxy.Memory-cfg-data\" class=\"docClass\">data</a> object. Uses the Proxy's <a href=\"#!/api/Ext.data.proxy.Memory-cfg-reader\" rel=\"Ext.data.proxy.Memory-cfg-reader\" class=\"docClass\">reader</a>, if present.</p>\n"},"update":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Currently this is a hard-coded method that simply commits any records and sets the operation to successful,\nthen calls the callback function, if provided. It is essentially mocking a server call in memory, but since\nthere is no real back end in this case there's not much else to do. This method can be easily overridden to\nimplement more complex logic if needed.</p>\n"},"updateOperation":{"!type":"fn(operation: ?, callback: ?, scope: ?) -> !this","!doc":"<p>Fake processing function to commit the records, set the current operation\nto successful and call the callback if provided. This function is shared\nby the create, update and destroy methods to perform the bare minimum\nprocessing required for the proxy to register a result from the action.</p>\n"}}},"Rest":{"!doc":"<p>The Rest proxy is a specialization of the <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">AjaxProxy</a> which simply maps the four actions\n(create, read, update and destroy) to RESTful HTTP verbs. For example, let's set up a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a>\nwith an inline Rest proxy</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'email'],\n\n    proxy: {\n        type: 'rest',\n        url : '/users'\n    }\n});\n</code></pre>\n\n<p>Now we can create a new User instance and save it via the Rest proxy. Doing this will cause the Proxy to send a POST\nrequest to '/users':</p>\n\n<pre><code>var user = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {name: 'Ed Spencer', email: 'ed@sencha.com'});\n\nuser.save(); //POST /users\n</code></pre>\n\n<p>Let's expand this a little and provide a callback for the <a href=\"#!/api/Ext.data.Model-method-save\" rel=\"Ext.data.Model-method-save\" class=\"docClass\">Ext.data.Model.save</a> call to update the Model once\nit has been created. We'll assume the creation went successfully and that the server gave this user an ID of 123:</p>\n\n<pre><code>user.save({\n    success: function(user) {\n        user.set('name', 'Khan Noonien Singh');\n\n        user.save(); //PUT /users/123\n    }\n});\n</code></pre>\n\n<p>Now that we're no longer creating a new Model instance, the request method is changed to an HTTP PUT, targeting the\nrelevant url for that user. Now let's delete this user, which will use the DELETE method:</p>\n\n<pre><code>    user.destroy(); //DELETE /users/123\n</code></pre>\n\n<p>Finally, when we perform a load of a Model or Store, Rest proxy will use the GET method:</p>\n\n<pre><code>//1. Load via Store\n\n//the Store automatically picks up the Proxy from the User model\nvar store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User'\n});\n\nstore.load(); //GET /users\n\n//2. Load directly from the Model\n\n//GET /users/123\n<a href=\"#!/api/Ext.ModelManager-method-getModel\" rel=\"Ext.ModelManager-method-getModel\" class=\"docClass\">Ext.ModelManager.getModel</a>('User').load(123, {\n    success: function(user) {\n        console.log(user.getId()); //outputs 123\n    }\n});\n</code></pre>\n\n<h1>Url generation</h1>\n\n<p>The Rest proxy is able to automatically generate the urls above based on two configuration options - <a href=\"#!/api/Ext.data.proxy.Rest-cfg-appendId\" rel=\"Ext.data.proxy.Rest-cfg-appendId\" class=\"docClass\">appendId</a> and\n<a href=\"#!/api/Ext.data.proxy.Rest-cfg-format\" rel=\"Ext.data.proxy.Rest-cfg-format\" class=\"docClass\">format</a>. If appendId is true (it is by default) then Rest proxy will automatically append the ID of the Model\ninstance in question to the configured url, resulting in the '/users/123' that we saw above.</p>\n\n<p>If the request is not for a specific Model instance (e.g. loading a Store), the url is not appended with an id.\nThe Rest proxy will automatically insert a '/' before the ID if one is not already present.</p>\n\n<pre><code>new <a href=\"#!/api/Ext.data.proxy.Rest\" rel=\"Ext.data.proxy.Rest\" class=\"docClass\">Ext.data.proxy.Rest</a>({\n    url: '/users',\n    appendId: true //default\n});\n\n// Collection url: /users\n// Instance url  : /users/123\n</code></pre>\n\n<p>The Rest proxy can also optionally append a format string to the end of any generated url:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.data.proxy.Rest\" rel=\"Ext.data.proxy.Rest\" class=\"docClass\">Ext.data.proxy.Rest</a>({\n    url: '/users',\n    format: 'json'\n});\n\n// Collection url: /users.json\n// Instance url  : /users/123.json\n</code></pre>\n\n<p>If further customization is needed, simply implement the <a href=\"#!/api/Ext.data.proxy.Rest-method-buildUrl\" rel=\"Ext.data.proxy.Rest-method-buildUrl\" class=\"docClass\">buildUrl</a> method and add your custom generated url\nonto the <a href=\"#!/api/Ext.data.Request\" rel=\"Ext.data.Request\" class=\"docClass\">Request</a> object that is passed to buildUrl. See <a href=\"source/Rest.html#Ext-data-proxy-Rest-method-buildUrl\">Rest proxy's implementation</a> for\nan example of how to achieve this.</p>\n\n<p>Note that Rest proxy inherits from <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">AjaxProxy</a>, which already injects all of the sorter,\nfilter, group and paging options into the generated url. See the <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">AjaxProxy docs</a> for more\ndetails.</p>\n","!type":"fn(config?: ?)","prototype":{"appendId":{"!type":"bool","!doc":"<p>True to automatically append the ID of a Model instance when performing a request based on that single instance.\nSee Rest proxy intro docs for more details. Defaults to true.</p>\n"},"batchActions":{"!type":"bool","!doc":"<p>True to batch actions of a particular type when synchronizing the store. Defaults to false.</p>\n"},"format":{"!type":"string","!doc":"<p>Optional data format to send to the server when making any request (e.g. 'json'). See the Rest proxy intro docs\nfor full details. Defaults to undefined.</p>\n"},"actionMethods":{"!doc":"<p>Mapping of action name to HTTP request method. These default to RESTful conventions for the 'create', 'read',\n'update' and 'destroy' actions (which map to 'POST', 'GET', 'PUT' and 'DELETE' respectively). This object\nshould not be changed except globally via <a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a> - the <a href=\"#!/api/Ext.data.proxy.Rest-method-getMethod\" rel=\"Ext.data.proxy.Rest-method-getMethod\" class=\"docClass\">getMethod</a> function\ncan be overridden instead.</p>\n"},"buildUrl":{"!type":"fn(request: ?) -> !this","!doc":"<p>Specialized version of buildUrl that incorporates the <a href=\"#!/api/Ext.data.proxy.Rest-cfg-appendId\" rel=\"Ext.data.proxy.Rest-cfg-appendId\" class=\"docClass\">appendId</a> and <a href=\"#!/api/Ext.data.proxy.Rest-cfg-format\" rel=\"Ext.data.proxy.Rest-cfg-format\" class=\"docClass\">format</a> options into the\ngenerated url. Override this to provide further customizations, but remember to call the superclass buildUrl so\nthat additional parameters like the cache buster string are appended.</p>\n"},"isValidId":{"!type":"fn(id: ?) -> !this"}}},"SessionStorage":{"!doc":"<p>Proxy which uses HTML5 session storage as its data storage/retrieval mechanism. If this proxy is used in a browser\nwhere session storage is not supported, the constructor will throw an error. A session storage proxy requires a\nunique ID which is used as a key in which all record data are stored in the session storage object.</p>\n\n<p>It's important to supply this unique ID as it cannot be reliably determined otherwise. If no id is provided but the\nattached store has a storeId, the storeId will be used. If neither option is presented the proxy will throw an error.</p>\n\n<p>Proxies are almost always used with a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a>:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>({\n    proxy: {\n        type: 'sessionstorage',\n        id  : 'myProxyKey'\n    }\n});\n</code></pre>\n\n<p>Alternatively you can instantiate the Proxy directly:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.data.proxy.SessionStorage\" rel=\"Ext.data.proxy.SessionStorage\" class=\"docClass\">Ext.data.proxy.SessionStorage</a>({\n    id  : 'myOtherProxyKey'\n});\n</code></pre>\n\n<p>Note that session storage is different to local storage (see <a href=\"#!/api/Ext.data.proxy.LocalStorage\" rel=\"Ext.data.proxy.LocalStorage\" class=\"docClass\">Ext.data.proxy.LocalStorage</a>) - if a browser\nsession is ended (e.g. by closing the browser) then all data in a SessionStorageProxy are lost. Browser restarts\ndon't affect the <a href=\"#!/api/Ext.data.proxy.LocalStorage\" rel=\"Ext.data.proxy.LocalStorage\" class=\"docClass\">Ext.data.proxy.LocalStorage</a> - the data are preserved.</p>\n","!type":"fn(config?: ?)","prototype":{"getStorageObject":{"!type":"fn() -> ?","!doc":"<p>inherit docs</p>\n"}}}},"reader":{"Array":{"!doc":"<p>Data reader class to create an Array of <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> objects from an Array.\nEach element of that Array represents a row of data fields. The\nfields are pulled into a Record object using as a subscript, the <code>mapping</code> property\nof the field definition if it exists, or the field's ordinal position in the definition.</p>\n\n\n\n\n<p><u>Example code:</u></p>\n\n\n\n\n<pre><code>Employee = <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Employee', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        'id',\n        {name: 'name', mapping: 1},         // \"mapping\" only needed if an \"id\" field is present which\n        {name: 'occupation', mapping: 2}    // precludes using the ordinal position as the index.        \n    ]\n});\n\nvar myReader = new <a href=\"#!/api/Ext.data.reader.Array\" rel=\"Ext.data.reader.Array\" class=\"docClass\">Ext.data.reader.Array</a>({\n    model: 'Employee'\n}, Employee);\n</code></pre>\n\n\n\n\n<p>This would consume an Array like this:</p>\n\n\n\n\n<pre><code>[ [1, 'Bill', 'Gardener'], [2, 'Ben', 'Horticulturalist'] ]\n</code></pre>\n\n","!type":"fn(meta: ?)","prototype":{"successProperty":{"!type":"string","!doc":"<p>Name of the property from which to retrieve the <code>success</code> attribute, the value of which indicates\nwhether a given request succeeded or failed (typically a boolean or 'true'|'false'). See\n<a href=\"#!/api/Ext.data.proxy.Server\" rel=\"Ext.data.proxy.Server\" class=\"docClass\">Ext.data.proxy.Server</a>.<a href=\"#!/api/Ext.data.proxy.Server-event-exception\" rel=\"Ext.data.proxy.Server-event-exception\" class=\"docClass\">exception</a> for additional information.</p>\n"},"totalProperty":{"!type":"string","!doc":"<p>For Array Reader, methods in the base which use these properties must not see the defaults</p>\n"},"createFieldAccessExpression":{"!type":"fn(field: ?, fieldVarName: ?, dataName: ?) -> !this","!doc":"<p>Returns an accessor expression for the passed Field from an Array using either the Field's mapping, or\nits ordinal position in the fields collsction as the index.\nThis is used by buildExtractors to create optimized on extractor function which converts raw data into model instances.</p>\n"}}},"Reader":{"prototype":{"idProperty":{"!type":"string","!doc":"<p>Name of the property within a row object that contains a record identifier value. Defaults to the id of the\nmodel. If an idProperty is explicitly specified it will take precedence over idProperty defined on the model.</p>\n"},"implicitIncludes":{"!type":"bool","!doc":"<p>True to automatically parse models nested within other models in a response object. See the\n<a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a> intro docs for full explanation.</p>\n"},"messageProperty":{"!type":"string","!doc":"<p>The name of the property which contains a response message. This property is optional.</p>\n"},"readRecordsOnFailure":{"!type":"bool","!doc":"<p>True to extract the records from a data packet even if the <a href=\"#!/api/Ext.data.reader.Reader-cfg-successProperty\" rel=\"Ext.data.reader.Reader-cfg-successProperty\" class=\"docClass\">successProperty</a> returns false.</p>\n"},"applyDefaults":{"!type":"bool","!doc":"<p>Private flag to the generated convertRecordData function to indicate whether to apply Field default\nvalues to fields for which no value is present in the raw data.\nThis is set to false by a Server Proxy which is reading the response from a \"create\" or \"update\" operation.</p>\n"},"isReader":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Reader, or subclass thereof.</p>\n"},"lastFieldGeneration":{},"metaData":{"!doc":"<p>The raw meta data that was most recently read, if any. Meta data can include existing\nReader config options like <a href=\"#!/api/Ext.data.reader.Reader-cfg-idProperty\" rel=\"Ext.data.reader.Reader-cfg-idProperty\" class=\"docClass\">idProperty</a>, <a href=\"#!/api/Ext.data.reader.Reader-cfg-totalProperty\" rel=\"Ext.data.reader.Reader-cfg-totalProperty\" class=\"docClass\">totalProperty</a>, etc. that get\nautomatically applied to the Reader, and those can still be accessed directly from the Reader\nif needed. However, meta data is also often used to pass other custom data to be processed\nby application code. For example, it is common when reconfiguring the data model of a grid to\nalso pass a corresponding column model config to be applied to the grid. Any such data will\nnot get applied to the Reader directly (it just gets passed through and is ignored by Ext).\nThis metaData property gives you access to all meta data that was passed, including any such\ncustom data ignored by the reader.</p>\n\n<p>This is a read-only property, and it will get replaced each time a new meta data object is\npassed to the reader. Note that typically you would handle proxy's\n<a href=\"#!/api/Ext.data.proxy.Proxy-event-metachange\" rel=\"Ext.data.proxy.Proxy-event-metachange\" class=\"docClass\">metachange</a> event which passes this exact same meta\nobject to listeners. However this property is available if it's more convenient to access it\nvia the reader directly in certain cases.</p>\n"},"rawData":{"!doc":"<p>The raw data object that was last passed to <a href=\"#!/api/Ext.data.reader.Reader-method-readRecords\" rel=\"Ext.data.reader.Reader-method-readRecords\" class=\"docClass\">readRecords</a>. Stored for further processing if needed.</p>\n"},"recordDataExtractorTemplate":{},"buildRecordDataExtractor":{"!type":"fn() -> !this","!doc":"<p>Return a function which will read a raw row object in the format this Reader accepts, and populates\na record's data object with converted data values.</p>\n\n<p>The returned function must be passed the following parameters:</p>\n\n<ul>\n<li>dest A record's empty data object into which the new field value properties are injected.</li>\n<li>source A raw row data object of whatever type this Reader consumes</li>\n<li>record The record which is being populated.</li>\n</ul>\n\n"},"destroyReader":{"!type":"fn() -> !this"},"getAssociatedDataRoot":{"!type":"fn(data: ?, associationName: ?) -> ?","!doc":"<p>Used internally by <a href=\"#!/api/Ext.data.reader.Reader-method-readAssociated\" rel=\"Ext.data.reader.Reader-method-readAssociated\" class=\"docClass\">readAssociated</a>. Given a data object (which could be json, xml etc) for a specific\nrecord, this should return the relevant part of that data for the given association name. If a complex\nmapping, this will traverse arrays and objects to resolve the data.</p>\n"},"getData":{"!type":"fn(data: ?) -> ?","!doc":"<p>By default this function just returns what is passed to it. It can be overridden in a subclass\nto return something else. See XmlReader for an example.</p>\n"},"getFields":{"!type":"fn() -> !this"},"getIdProperty":{"!type":"fn() -> string","!doc":"<p>Get the idProperty to use for extracting data</p>\n"},"getRoot":{"!type":"fn(data: ?) -> ?","!doc":"<p>This will usually need to be implemented in a subclass. Given a generic data object (the type depends on the type\nof data we are reading), this function should return the object as configured by the Reader's 'root' meta data config.\nSee XmlReader's getRoot implementation for an example. By default the same data object will simply be returned.</p>\n"},"onMetaChange":{"!type":"fn(meta: ?) -> !this","!doc":"<p>Reconfigures the meta data tied to this Reader</p>\n"},"read":{"!type":"fn(response: ?) -> ?","!doc":"<p>Reads the given response object. This method normalizes the different types of response object that may be passed to it.\nIf it's an XMLHttpRequest object, hand off to the subclass' <a href=\"#!/api/Ext.data.reader.Reader-method-getResponseData\" rel=\"Ext.data.reader.Reader-method-getResponseData\" class=\"docClass\">getResponseData</a> method.\nElse, hand off the reading of records to the <a href=\"#!/api/Ext.data.reader.Reader-method-readRecords\" rel=\"Ext.data.reader.Reader-method-readRecords\" class=\"docClass\">readRecords</a> method.</p>\n"},"readAssociated":{"!type":"fn(record: ?, data: ?) -> string","!doc":"<p>Loads a record's associations from the data object. This prepopulates hasMany and belongsTo associations\non the record provided.</p>\n"},"setModel":{"!type":"fn(model: ?, setOnProxy: ?) -> !this","!doc":"<p>Sets a new model for the reader.</p>\n"},"exception":{"!type":"fn(reader: ?, response: ?, error: ?, eOpts: ?)","!doc":"<p>Fires when the reader receives improperly encoded data from the server</p>\n"},"successProperty":{"!type":"string","!doc":"<p>Name of the property from which to retrieve the <code>success</code> attribute, the value of which indicates\nwhether a given request succeeded or failed (typically a boolean or 'true'|'false'). See\n<a href=\"#!/api/Ext.data.proxy.Server\" rel=\"Ext.data.proxy.Server\" class=\"docClass\">Ext.data.proxy.Server</a>.<a href=\"#!/api/Ext.data.proxy.Server-event-exception\" rel=\"Ext.data.proxy.Server-event-exception\" class=\"docClass\">exception</a> for additional information.</p>\n"},"totalProperty":{"!type":"string","!doc":"<p>Name of the property from which to retrieve the total number of records in the dataset. This is only needed if\nthe whole dataset is not passed in one go, but is being paged from the remote server.</p>\n"},"root":{"!type":"string","!doc":"<p>The name of the property which contains the data items corresponding to the Model(s) for which this\nReader is configured.  For JSON reader it's a property name (or a dot-separated list of property names\nif the root is nested).  For XML reader it's a CSS selector.  For Array reader the root is not applicable\nsince the data is assumed to be a single-level array of arrays.</p>\n\n<p>By default the natural root of the data will be used: the root JSON array, the root XML element, or the array.</p>\n\n<p>The data packet value for this property should be an empty array to clear the data or show no data.</p>\n"},"buildExtractors":{"!type":"fn(force?: ?) -> !this","!doc":"<p>This builds optimized functions for retrieving record data and meta data from an object.\nSubclasses may need to implement their own getRoot function.</p>\n"},"extractData":{"!type":"fn(root: ?) -> ?","!doc":"<p>Returns extracted, type-cast rows of data.</p>\n"},"getResponseData":{"!type":"fn(response: ?) -> ?","!doc":"<p>Takes a raw response object (as passed to the <a href=\"#!/api/Ext.data.reader.Reader-method-read\" rel=\"Ext.data.reader.Reader-method-read\" class=\"docClass\">read</a> method) and returns the useful data\nsegment from it. This must be implemented by each subclass.</p>\n"},"readRecords":{"!type":"fn(data: ?) -> ?","!doc":"<p>Abstracts common functionality used by all Reader subclasses. Each subclass is expected to call this function\nbefore running its own logic and returning the <a href=\"#!/api/Ext.data.ResultSet\" rel=\"Ext.data.ResultSet\" class=\"docClass\">Ext.data.ResultSet</a> instance. For most Readers additional\nprocessing should not be needed.</p>\n"}},"!doc":"<p>Readers are used to interpret data to be loaded into a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> instance or a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> - often in response to an AJAX request. In general there is usually no need to create\na Reader instance directly, since a Reader is almost always used together with a <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a>,\nand is configured using the Proxy's <a href=\"#!/api/Ext.data.proxy.Proxy-cfg-reader\" rel=\"Ext.data.proxy.Proxy-cfg-reader\" class=\"docClass\">reader</a> configuration property:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n    proxy: {\n        type: 'ajax',\n        url : 'users.json',\n        reader: {\n            type: 'json',\n            root: 'users'\n        }\n    },\n});\n</code></pre>\n\n<p>The above reader is configured to consume a JSON string that looks something like this:</p>\n\n<pre><code>{\n    \"success\": true,\n    \"users\": [\n        { \"name\": \"User 1\" },\n        { \"name\": \"User 2\" }\n    ]\n}\n</code></pre>\n\n<h1>Loading Nested Data</h1>\n\n<p>Readers have the ability to automatically load deeply-nested data objects based on the <a href=\"#!/api/Ext.data.association.Association\" rel=\"Ext.data.association.Association\" class=\"docClass\">associations</a> configured on each Model. Below is an example demonstrating the flexibility of these associations in a\nfictional CRM system which manages a User, their Orders, OrderItems and Products. First we'll define the models:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"User\", {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        'id', 'name'\n    ],\n\n    hasMany: {model: 'Order', name: 'orders'},\n\n    proxy: {\n        type: 'rest',\n        url : 'users.json',\n        reader: {\n            type: 'json',\n            root: 'users'\n        }\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"Order\", {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        'id', 'total'\n    ],\n\n    hasMany  : {model: 'OrderItem', name: 'orderItems', associationKey: 'order_items'},\n    belongsTo: 'User'\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"OrderItem\", {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        'id', 'price', 'quantity', 'order_id', 'product_id'\n    ],\n\n    belongsTo: ['Order', {model: 'Product', associationKey: 'product'}]\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"Product\", {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        'id', 'name'\n    ],\n\n    hasMany: 'OrderItem'\n});\n</code></pre>\n\n<p>This may be a lot to take in - basically a User has many Orders, each of which is composed of several OrderItems.\nFinally, each OrderItem has a single Product. This allows us to consume data like this:</p>\n\n<pre><code>{\n    \"users\": [\n        {\n            \"id\": 123,\n            \"name\": \"Ed\",\n            \"orders\": [\n                {\n                    \"id\": 50,\n                    \"total\": 100,\n                    \"order_items\": [\n                        {\n                            \"id\"      : 20,\n                            \"price\"   : 40,\n                            \"quantity\": 2,\n                            \"product\" : {\n                                \"id\": 1000,\n                                \"name\": \"MacBook Pro\"\n                            }\n                        },\n                        {\n                            \"id\"      : 21,\n                            \"price\"   : 20,\n                            \"quantity\": 3,\n                            \"product\" : {\n                                \"id\": 1001,\n                                \"name\": \"iPhone\"\n                            }\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}\n</code></pre>\n\n<p>The JSON response is deeply nested - it returns all Users (in this case just 1 for simplicity's sake), all of the\nOrders for each User (again just 1 in this case), all of the OrderItems for each Order (2 order items in this case),\nand finally the Product associated with each OrderItem. Now we can read the data and use it as follows:</p>\n\n<pre><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: \"User\"\n});\n\nstore.load({\n    callback: function() {\n        //the user that was loaded\n        var user = store.first();\n\n        console.log(\"Orders for \" + user.get('name') + \":\")\n\n        //iterate over the Orders for each User\n        user.orders().each(function(order) {\n            console.log(\"Order ID: \" + order.getId() + \", which contains items:\");\n\n            //iterate over the OrderItems for each Order\n            order.orderItems().each(function(orderItem) {\n                //we know that the Product data is already loaded, so we can use the synchronous getProduct\n                //usually, we would use the asynchronous version (see <a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">Ext.data.association.BelongsTo</a>)\n                var product = orderItem.getProduct();\n\n                console.log(orderItem.get('quantity') + ' orders of ' + product.get('name'));\n            });\n        });\n    }\n});\n</code></pre>\n\n<p>Running the code above results in the following:</p>\n\n<pre><code>Orders for Ed:\nOrder ID: 50, which contains items:\n2 orders of MacBook Pro\n3 orders of iPhone\n</code></pre>\n","!type":"fn(config?: ?)"},"Json":{"prototype":{"metaProperty":{"!type":"string","!doc":"<p>Name of the property from which to retrieve the <code>metaData</code> attribute. See <a href=\"#!/api/Ext.data.reader.Json-property-metaData\" rel=\"Ext.data.reader.Json-property-metaData\" class=\"docClass\">metaData</a>.</p>\n"},"record":{"!type":"string","!doc":"<p>The optional location within the JSON response that the record data itself can be found at.\nSee the JsonReader intro docs for more details. This is not often needed.</p>\n"},"root":{"!type":"string","!doc":"<p>The name of the property which contains the data items corresponding to the Model(s) for which this\nReader is configured.  For JSON reader it's a property name (or a dot-separated list of property names\nif the root is nested).  For XML reader it's a CSS selector.  For Array reader the root is not applicable\nsince the data is assumed to be a single-level array of arrays.</p>\n\n<p>By default the natural root of the data will be used: the root JSON array, the root XML element, or the array.</p>\n\n<p>The data packet value for this property should be an empty array to clear the data or show no data.</p>\n"},"useSimpleAccessors":{"!type":"bool","!doc":"<p>True to ensure that field names/mappings are treated as literals when\nreading values.</p>\n\n<p>For example, by default, using the mapping \"foo.bar.baz\" will try and read a property foo from the root, then a property bar\nfrom foo, then a property baz from bar. Setting the simple accessors to true will read the property with the name\n\"foo.bar.baz\" direct from the root object.</p>\n"},"jsonData":{"!doc":"<p>A copy of this.rawData.</p>\n"},"buildExtractors":{"!type":"fn(force?: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"createAccessor":{"!type":"fn() -> !this","!doc":"<p>Returns an accessor function for the given property string. Gives support for properties such as the following:</p>\n\n<ul>\n<li>'someProperty'</li>\n<li>'some.property'</li>\n<li>'[\"someProperty\"]'</li>\n<li>'values[0]'</li>\n</ul>\n\n\n<p>This is used by <a href=\"#!/api/Ext.data.reader.Json-method-buildExtractors\" rel=\"Ext.data.reader.Json-method-buildExtractors\" class=\"docClass\">buildExtractors</a> to create optimized extractor functions for properties that are looked\nup directly on the source object (e.g. <a href=\"#!/api/Ext.data.reader.Json-cfg-successProperty\" rel=\"Ext.data.reader.Json-cfg-successProperty\" class=\"docClass\">successProperty</a>, <a href=\"#!/api/Ext.data.reader.Json-cfg-messageProperty\" rel=\"Ext.data.reader.Json-cfg-messageProperty\" class=\"docClass\">messageProperty</a>, etc.).</p>\n"},"extractData":{"!type":"fn(root: ?) -> ?","!doc":"<p>We're just preparing the data for the superclass by pulling out the record objects we want. If a <a href=\"#!/api/Ext.data.reader.Json-cfg-record\" rel=\"Ext.data.reader.Json-cfg-record\" class=\"docClass\">record</a>\nwas specified we have to pull those out of the larger JSON object, which is most of what this function is doing</p>\n"},"getResponseData":{"!type":"fn(response: ?) -> ?","!doc":"<p>inherit docs</p>\n"},"readRecords":{"!type":"fn(data: ?) -> ?","!doc":"<p>Reads a JSON object and returns a ResultSet. Uses the internal getTotal and getSuccess extractors to\nretrieve meta data from the response, and extractData to turn the JSON data into model instances.</p>\n"},"createFieldAccessExpression":{"!type":"fn() -> !this","!doc":"<p>Returns an accessor expression for the passed Field. Gives support for properties such as the following:</p>\n\n<ul>\n<li>'someProperty'</li>\n<li>'some.property'</li>\n<li>'[\"someProperty\"]'</li>\n<li>'values[0]'</li>\n</ul>\n\n\n<p>This is used by <a href=\"#!/api/Ext.data.reader.Json-method-buildRecordDataExtractor\" rel=\"Ext.data.reader.Json-method-buildRecordDataExtractor\" class=\"docClass\">buildRecordDataExtractor</a> to create optimized extractor expressions when converting raw\ndata into model instances. This method is used at the field level to dynamically map values to model fields.</p>\n"}},"!doc":"<p>The JSON Reader is used by a Proxy to read a server response that is sent back in JSON format. This usually\nhappens as a result of loading a Store - for example we might create something like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'email']\n});\n\nvar store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n    proxy: {\n        type: 'ajax',\n        url : 'users.json',\n        reader: {\n            type: 'json'\n        }\n    }\n});\n</code></pre>\n\n<p>The example above creates a 'User' model. Models are explained in the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> docs if you're\nnot already familiar with them.</p>\n\n<p>We created the simplest type of JSON Reader possible by simply telling our <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>'s\n<a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a> that we want a JSON Reader. The Store automatically passes the configured model to the\nStore, so it is as if we passed this instead:</p>\n\n<pre><code>reader: {\n    type : 'json',\n    model: 'User'\n}\n</code></pre>\n\n<p>The reader we set up is ready to read data from our server - at the moment it will accept a response like this:</p>\n\n<pre><code>[\n    {\n        \"id\": 1,\n        \"name\": \"Ed Spencer\",\n        \"email\": \"ed@sencha.com\"\n    },\n    {\n        \"id\": 2,\n        \"name\": \"Abe Elias\",\n        \"email\": \"abe@sencha.com\"\n    }\n]\n</code></pre>\n\n<h2>Reading other JSON formats</h2>\n\n<p>If you already have your JSON format defined and it doesn't look quite like what we have above, you can usually\npass JsonReader a couple of configuration options to make it parse your format. For example, we can use the\n<a href=\"#!/api/Ext.data.reader.Json-cfg-root\" rel=\"Ext.data.reader.Json-cfg-root\" class=\"docClass\">root</a> configuration to parse data that comes back like this:</p>\n\n<pre><code>{\n    \"users\": [\n       {\n           \"id\": 1,\n           \"name\": \"Ed Spencer\",\n           \"email\": \"ed@sencha.com\"\n       },\n       {\n           \"id\": 2,\n           \"name\": \"Abe Elias\",\n           \"email\": \"abe@sencha.com\"\n       }\n    ]\n}\n</code></pre>\n\n<p>To parse this we just pass in a <a href=\"#!/api/Ext.data.reader.Json-cfg-root\" rel=\"Ext.data.reader.Json-cfg-root\" class=\"docClass\">root</a> configuration that matches the 'users' above:</p>\n\n<pre><code>reader: {\n    type: 'json',\n    root: 'users'\n}\n</code></pre>\n\n<p>Sometimes the JSON structure is even more complicated. Document databases like CouchDB often provide metadata\naround each record inside a nested structure like this:</p>\n\n<pre><code>{\n    \"total\": 122,\n    \"offset\": 0,\n    \"users\": [\n        {\n            \"id\": \"ed-spencer-1\",\n            \"value\": 1,\n            \"user\": {\n                \"id\": 1,\n                \"name\": \"Ed Spencer\",\n                \"email\": \"ed@sencha.com\"\n            }\n        }\n    ]\n}\n</code></pre>\n\n<p>In the case above the record data is nested an additional level inside the \"users\" array as each \"user\" item has\nadditional metadata surrounding it ('id' and 'value' in this case). To parse data out of each \"user\" item in the\nJSON above we need to specify the <a href=\"#!/api/Ext.data.reader.Json-cfg-record\" rel=\"Ext.data.reader.Json-cfg-record\" class=\"docClass\">record</a> configuration like this:</p>\n\n<pre><code>reader: {\n    type  : 'json',\n    root  : 'users',\n    record: 'user'\n}\n</code></pre>\n\n<h2>Response MetaData</h2>\n\n<p>The server can return metadata in its response, in addition to the record data, that describe attributes\nof the data set itself or are used to reconfigure the Reader. To pass metadata in the response you simply\nadd a <code>metaData</code> attribute to the root of the response data. The metaData attribute can contain anything,\nbut supports a specific set of properties that are handled by the Reader if they are present:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.data.reader.Json-cfg-root\" rel=\"Ext.data.reader.Json-cfg-root\" class=\"docClass\">root</a>: the property name of the root response node containing the record data</li>\n<li><a href=\"#!/api/Ext.data.reader.Json-cfg-idProperty\" rel=\"Ext.data.reader.Json-cfg-idProperty\" class=\"docClass\">idProperty</a>: property name for the primary key field of the data</li>\n<li><a href=\"#!/api/Ext.data.reader.Json-cfg-totalProperty\" rel=\"Ext.data.reader.Json-cfg-totalProperty\" class=\"docClass\">totalProperty</a>: property name for the total number of records in the data</li>\n<li><a href=\"#!/api/Ext.data.reader.Json-cfg-successProperty\" rel=\"Ext.data.reader.Json-cfg-successProperty\" class=\"docClass\">successProperty</a>: property name for the success status of the response</li>\n<li><a href=\"#!/api/Ext.data.reader.Json-cfg-messageProperty\" rel=\"Ext.data.reader.Json-cfg-messageProperty\" class=\"docClass\">messageProperty</a>: property name for an optional response message</li>\n<li><a href=\"#!/api/Ext.data.Model-cfg-fields\" rel=\"Ext.data.Model-cfg-fields\" class=\"docClass\">fields</a>: Config used to reconfigure the Model's fields before converting the\nresponse data into records</li>\n</ul>\n\n\n<p>An initial Reader configuration containing all of these properties might look like this (\"fields\" would be\nincluded in the Model definition, not shown):</p>\n\n<pre><code>reader: {\n    type : 'json',\n    root : 'root',\n    idProperty     : 'id',\n    totalProperty  : 'total',\n    successProperty: 'success',\n    messageProperty: 'message'\n}\n</code></pre>\n\n<p>If you were to pass a response object containing attributes different from those initially defined above, you could\nuse the <code>metaData</code> attribute to reconifgure the Reader on the fly. For example:</p>\n\n<pre><code>{\n    \"count\": 1,\n    \"ok\": true,\n    \"msg\": \"Users found\",\n    \"users\": [{\n        \"userId\": 123,\n        \"name\": \"Ed Spencer\",\n        \"email\": \"ed@sencha.com\"\n    }],\n    \"metaData\": {\n        \"root\": \"users\",\n        \"idProperty\": 'userId',\n        \"totalProperty\": 'count',\n        \"successProperty\": 'ok',\n        \"messageProperty\": 'msg'\n    }\n}\n</code></pre>\n\n<p>You can also place any other arbitrary data you need into the <code>metaData</code> attribute which will be ignored by the Reader,\nbut will be accessible via the Reader's <a href=\"#!/api/Ext.data.reader.Json-property-metaData\" rel=\"Ext.data.reader.Json-property-metaData\" class=\"docClass\">metaData</a> property (which is also passed to listeners via the Proxy's\n<a href=\"#!/api/Ext.data.proxy.Proxy-event-metachange\" rel=\"Ext.data.proxy.Proxy-event-metachange\" class=\"docClass\">metachange</a> event (also relayed by the <a href=\"#!/api/Ext.data.AbstractStore-event-metachange\" rel=\"Ext.data.AbstractStore-event-metachange\" class=\"docClass\">store</a>). Application code can then process the passed metadata in any way it chooses.</p>\n\n<p>A simple example for how this can be used would be customizing the fields for a Model that is bound to a grid. By passing\nthe <code>fields</code> property the Model will be automatically updated by the Reader internally, but that change will not be\nreflected automatically in the grid unless you also update the column configuration. You could do this manually, or you\ncould simply pass a standard grid <a href=\"#!/api/Ext.panel.Table-cfg-columns\" rel=\"Ext.panel.Table-cfg-columns\" class=\"docClass\">column</a> config object as part of the <code>metaData</code> attribute\nand then pass that along to the grid. Here's a very simple example for how that could be accomplished:</p>\n\n<pre><code>// response format:\n{\n    ...\n    \"metaData\": {\n        \"fields\": [\n            { \"name\": \"userId\", \"type\": \"int\" },\n            { \"name\": \"name\", \"type\": \"string\" },\n            { \"name\": \"birthday\", \"type\": \"date\", \"dateFormat\": \"Y-j-m\" },\n        ],\n        \"columns\": [\n            { \"text\": \"User ID\", \"dataIndex\": \"userId\", \"width\": 40 },\n            { \"text\": \"User Name\", \"dataIndex\": \"name\", \"flex\": 1 },\n            { \"text\": \"Birthday\", \"dataIndex\": \"birthday\", \"flex\": 1, \"format\": 'Y-j-m', \"xtype\": \"datecolumn\" }\n        ]\n    }\n}\n</code></pre>\n\n<p>The Reader will automatically read the meta fields config and rebuild the Model based on the new fields, but to handle\nthe new column configuration you would need to handle the metadata within the application code. This is done simply enough\nby handling the metachange event on either the store or the proxy, e.g.:</p>\n\n<pre><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    ...\n    listeners: {\n        'metachange': function(store, meta) {\n            myGrid.reconfigure(store, meta.columns);\n        }\n    }\n});\n</code></pre>\n","!type":"fn(config?: ?)"},"Xml":{"!doc":"<p>The XML Reader is used by a Proxy to read a server response that is sent back in XML format. This usually happens as\na result of loading a Store - for example we might create something like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'email']\n});\n\nvar store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n    proxy: {\n        type: 'ajax',\n        url : 'users.xml',\n        reader: {\n            type: 'xml',\n            record: 'user',\n            root: 'users'\n        }\n    }\n});\n</code></pre>\n\n<p>The example above creates a 'User' model. Models are explained in the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> docs if you're not\nalready familiar with them.</p>\n\n<p>We created the simplest type of XML Reader possible by simply telling our <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>'s <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a> that we want a XML Reader. The Store automatically passes the configured model to the\nStore, so it is as if we passed this instead:</p>\n\n<pre><code>reader: {\n    type : 'xml',\n    model: 'User',\n    record: 'user',\n    root: 'users'\n}\n</code></pre>\n\n<p>The reader we set up is ready to read data from our server - at the moment it will accept a response like this:</p>\n\n<pre><code>&lt;?xml version=\"1.0\" encoding=\"UTF-8\"?&gt;\n&lt;users&gt;\n    &lt;user&gt;\n        &lt;id&gt;1&lt;/id&gt;\n        &lt;name&gt;Ed Spencer&lt;/name&gt;\n        &lt;email&gt;ed@sencha.com&lt;/email&gt;\n    &lt;/user&gt;\n    &lt;user&gt;\n        &lt;id&gt;2&lt;/id&gt;\n        &lt;name&gt;Abe Elias&lt;/name&gt;\n        &lt;email&gt;abe@sencha.com&lt;/email&gt;\n    &lt;/user&gt;\n&lt;/users&gt;\n</code></pre>\n\n<p>First off there's <a href=\"#!/api/Ext.data.reader.Xml-cfg-root\" rel=\"Ext.data.reader.Xml-cfg-root\" class=\"docClass\">root</a> option to define the root node <code>&lt;users&gt;</code> (there should be only one in a well-formed\nXML document). Then the XML Reader uses the configured <a href=\"#!/api/Ext.data.reader.Xml-cfg-record\" rel=\"Ext.data.reader.Xml-cfg-record\" class=\"docClass\">record</a> option to pull out the data for each record -\nin this case we set record to 'user', so each <code>&lt;user&gt;</code> above will be converted into a User model.</p>\n\n<p>Note that XmlReader doesn't care whether your <a href=\"#!/api/Ext.data.reader.Xml-cfg-root\" rel=\"Ext.data.reader.Xml-cfg-root\" class=\"docClass\">root</a> and <a href=\"#!/api/Ext.data.reader.Xml-cfg-record\" rel=\"Ext.data.reader.Xml-cfg-record\" class=\"docClass\">record</a> elements are nested deep inside a\nlarger structure, so a response like this will still work:</p>\n\n<pre><code>&lt;?xml version=\"1.0\" encoding=\"UTF-8\"?&gt;\n&lt;deeply&gt;\n    &lt;nested&gt;\n        &lt;xml&gt;\n            &lt;users&gt;\n                &lt;user&gt;\n                    &lt;id&gt;1&lt;/id&gt;\n                    &lt;name&gt;Ed Spencer&lt;/name&gt;\n                    &lt;email&gt;ed@sencha.com&lt;/email&gt;\n                &lt;/user&gt;\n                &lt;user&gt;\n                    &lt;id&gt;2&lt;/id&gt;\n                    &lt;name&gt;Abe Elias&lt;/name&gt;\n                    &lt;email&gt;abe@sencha.com&lt;/email&gt;\n                &lt;/user&gt;\n            &lt;/users&gt;\n        &lt;/xml&gt;\n    &lt;/nested&gt;\n&lt;/deeply&gt;\n</code></pre>\n\n<p>If this Reader is being used by a <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">TreeStore</a> to read tree-structured data in which records\nare nested as descendant nodes of other records, then this lenient behaviour must be overridden by using a more specific\nchild node selector as your <a href=\"#!/api/Ext.data.reader.Xml-cfg-record\" rel=\"Ext.data.reader.Xml-cfg-record\" class=\"docClass\">record</a> selector which will not select all descendants, such as:</p>\n\n<p>   record: '>user'</p>\n\n<h1>Response metadata</h1>\n\n<p>The server can return additional data in its response, such as the <a href=\"#!/api/Ext.data.reader.Xml-cfg-totalProperty\" rel=\"Ext.data.reader.Xml-cfg-totalProperty\" class=\"docClass\">total number of records</a> and\nthe <a href=\"#!/api/Ext.data.reader.Xml-cfg-successProperty\" rel=\"Ext.data.reader.Xml-cfg-successProperty\" class=\"docClass\">success status of the response</a>. These are typically included in the XML response like\nthis:</p>\n\n<pre><code>&lt;?xml version=\"1.0\" encoding=\"UTF-8\"?&gt;\n&lt;users&gt;\n    &lt;total&gt;100&lt;/total&gt;\n    &lt;success&gt;true&lt;/success&gt;\n    &lt;user&gt;\n        &lt;id&gt;1&lt;/id&gt;\n        &lt;name&gt;Ed Spencer&lt;/name&gt;\n        &lt;email&gt;ed@sencha.com&lt;/email&gt;\n    &lt;/user&gt;\n    &lt;user&gt;\n        &lt;id&gt;2&lt;/id&gt;\n        &lt;name&gt;Abe Elias&lt;/name&gt;\n        &lt;email&gt;abe@sencha.com&lt;/email&gt;\n    &lt;/user&gt;\n&lt;/users&gt;\n</code></pre>\n\n<p>If these properties are present in the XML response they can be parsed out by the XmlReader and used by the Store\nthat loaded it. We can set up the names of these properties by specifying a final pair of configuration options:</p>\n\n<pre><code>reader: {\n    type: 'xml',\n    root: 'users',\n    totalProperty  : 'total',\n    successProperty: 'success'\n}\n</code></pre>\n\n<p>These final options are not necessary to make the Reader work, but can be useful when the server needs to report an\nerror or if it needs to indicate that there is a lot of data available of which only a subset is currently being\nreturned.</p>\n\n<h1>Response format</h1>\n\n<p><strong>Note:</strong> in order for the browser to parse a returned XML document, the Content-Type header in the HTTP response\nmust be set to \"text/xml\" or \"application/xml\". This is very important - the XmlReader will not work correctly\notherwise.</p>\n","!type":"fn(config?: ?)","prototype":{"namespace":{"!type":"string","!doc":"<p>A namespace prefix that will be prepended to the field name when reading a\nfield from an XML node.  Take, for example, the following Model:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Foo', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['bar', 'baz']\n});\n</code></pre>\n\n<p>The reader would need to be configured with a namespace of 'n' in order to read XML\ndata in the following format:</p>\n\n<pre><code>&lt;foo&gt;\n    &lt;n:bar&gt;bar&lt;/n:bar&gt;\n    &lt;n:baz&gt;baz&lt;/n:baz&gt;\n&lt;/foo&gt;\n</code></pre>\n"},"record":{"!type":"string","!doc":"<p>The DomQuery path to the repeated element which contains record information.</p>\n\n<p>By default, the elements which match the selector may be nested at any level below the <a href=\"#!/api/Ext.data.reader.Xml-cfg-root\" rel=\"Ext.data.reader.Xml-cfg-root\" class=\"docClass\">root</a></p>\n\n<p>If this Reader is being used by a <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">TreeStore</a> to read tree-structured data,\nthen only first generation child nodes of the root element must be selected, so the record selector must be\nspecified with a more specific selector which will not select all descendants. For example:</p>\n\n<p>   record: '>node'</p>\n"},"xmlData":{"!doc":"<p>Copy of <a href=\"#!/api/Ext.data.reader.Xml-property-rawData\" rel=\"Ext.data.reader.Xml-property-rawData\" class=\"docClass\">rawData</a>.</p>\n"},"createAccessor":{"!type":"fn(key: ?) -> ?","!doc":"<p>Creates a function to return some particular key of data from a response. The totalProperty and\nsuccessProperty are treated as special cases for type casting, everything else is just a simple selector.</p>\n"},"createFieldAccessExpression":{"!type":"fn(field: ?, fieldVarName: ?, dataName: ?) -> !this","!doc":"<p>Returns an accessor expression for the passed Field from an XML element using either the Field's mapping, or\nits ordinal position in the fields collsction as the index.\nThis is used by buildExtractors to create optimized on extractor function which converts raw data into model instances.</p>\n"},"extractData":{"!type":"fn(root: ?) -> ?","!doc":"<p>We're just preparing the data for the superclass by pulling out the record nodes we want.</p>\n"},"getAssociatedDataRoot":{"!type":"fn(data: ?, associationName: ?) -> ?","!doc":"<p>See <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a>'s getAssociatedDataRoot docs.</p>\n"},"getData":{"!type":"fn(data: ?) -> ?","!doc":"<p>Normalizes the data object.</p>\n"},"getNodeValue":{"!type":"fn(node: ?) -> !this"},"getResponseData":{"!type":"fn(response: ?) -> ?","!doc":"<p>inherit docs</p>\n"},"getRoot":{"!type":"fn(data: ?) -> ?","!doc":"<p>Given an XML object, returns the Element that represents the root as configured by the Reader's meta data.</p>\n"},"readRecords":{"!type":"fn(doc: ?) -> ?","!doc":"<p>Parses an XML document and returns a ResultSet containing the model instances.</p>\n"}}}},"Request":{"!doc":"<p>Simple class that represents a Request that will be made by any <a href=\"#!/api/Ext.data.proxy.Server\" rel=\"Ext.data.proxy.Server\" class=\"docClass\">Ext.data.proxy.Server</a> subclass.\nAll this class does is standardize the representation of a Request as used by any ServerProxy subclass,\nit does not contain any actual logic or perform the request itself.</p>\n","!type":"fn(config?: ?)","prototype":{"action":{"!type":"string","!doc":"<p>The name of the action this Request represents. Usually one of 'create', 'read', 'update' or 'destroy'.</p>\n"},"method":{"!type":"string","!doc":"<p>The HTTP method to use on this Request. Should be one of 'GET', 'POST', 'PUT' or 'DELETE'.</p>\n"},"params":{"!doc":"<p>HTTP request params. The Proxy and its Writer have access to and can modify this object.</p>\n"},"url":{"!type":"string","!doc":"<p>The url to access on this Request</p>\n"}}},"ResultSet":{"!doc":"<p>Simple wrapper class that represents a set of records returned by a Proxy.</p>\n","!type":"fn(config?: ?)","prototype":{"count":{"!type":"number","!doc":"<p>The number of records in this ResultSet. Note that total may differ from this number.</p>\n"},"loaded":{"!type":"bool","!doc":"<p>True if the records have already been loaded. This is only meaningful when dealing with\nSQL-backed proxies.</p>\n"},"records":{"!doc":"<p>The array of record instances.</p>\n"},"success":{"!type":"bool","!doc":"<p>True if the ResultSet loaded successfully, false if any errors were encountered.</p>\n"},"total":{"!type":"number","!doc":"<p>The total number of records reported by the data source. This ResultSet may form a subset of\nthose records (see <a href=\"#!/api/Ext.data.ResultSet-cfg-count\" rel=\"Ext.data.ResultSet-cfg-count\" class=\"docClass\">count</a>).</p>\n"},"totalRecords":{"!type":"number","!doc":"<p>Copy of this.total.</p>\n"}}},"SequentialIdGenerator":{"!doc":"<p>This class is a sequential id generator. A simple use of this class would be like so:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModel', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: 'sequential'\n});\n// assign id's of 1, 2, 3, etc.\n</code></pre>\n\n<p>An example of a configured generator would be:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModel', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: {\n        type: 'sequential',\n        prefix: 'ID_',\n        seed: 1000\n    }\n});\n// assign id's of ID_1000, ID_1001, ID_1002, etc.\n</code></pre>\n","!type":"fn()","prototype":{"prefix":{"!type":"string","!doc":"<p>The string to place in front of the sequential number for each generated id. The\ndefault is blank.</p>\n"},"seed":{"!type":"number","!doc":"<p>The number at which to start generating sequential id's. The default is 1.</p>\n"},"generate":{"!type":"fn() -> string","!doc":"<p>Generates and returns the next id.</p>\n"}}},"SortTypes":{"!doc":"<p>This class defines a series of static methods that are used on a\n<a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Ext.data.Field</a> for performing sorting. The methods cast the\nunderlying values into a data type that is appropriate for sorting on\nthat particular field.  If a <a href=\"#!/api/Ext.data.Field-cfg-type\" rel=\"Ext.data.Field-cfg-type\" class=\"docClass\">Ext.data.Field.type</a> is specified,\nthe sortType will be set to a sane default if the sortType is not\nexplicitly defined on the field. The sortType will make any necessary\nmodifications to the value and return it.</p>\n\n<ul>\n<li><b>asText</b> - Removes any tags and converts the value to a string</li>\n<li><b>asUCText</b> - Removes any tags and converts the value to an uppercase string</li>\n<li><b>asUCText</b> - Converts the value to an uppercase string</li>\n<li><b>asDate</b> - Converts the value into Unix epoch time</li>\n<li><b>asFloat</b> - Converts the value to a floating point number</li>\n<li><b>asInt</b> - Converts the value to an integer number</li>\n</ul>\n\n\n<p>\nIt is also possible to create a custom sortType that can be used throughout\nan application.\n<pre><code><a href=\"#!/api/Ext-method-apply\" rel=\"Ext-method-apply\" class=\"docClass\">Ext.apply</a>(<a href=\"#!/api/Ext.data.SortTypes\" rel=\"Ext.data.SortTypes\" class=\"docClass\">Ext.data.SortTypes</a>, {\n    asPerson: function(person){\n        // expects an object with a first and last name property\n        return person.lastName.toUpperCase() + person.firstName.toLowerCase();\n    }    \n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Employee', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [{\n        name: 'person',\n        sortType: 'asPerson'\n    }, {\n        name: 'salary',\n        type: 'float' // sortType set to asFloat\n    }]\n});\n</code></pre>\n</p>\n\n","stripTagsRE":{"!doc":"<p>The regular expression used to strip tags</p>\n"},"asDate":{"!type":"fn(s: ?) -> number","!doc":"<p>Date sorting</p>\n"},"asFloat":{"!type":"fn(s: ?) -> number","!doc":"<p>Float sorting</p>\n"},"asInt":{"!type":"fn(s: ?) -> number","!doc":"<p>Integer sorting</p>\n"},"asText":{"!type":"fn(s: ?) -> string","!doc":"<p>Strips all HTML tags to sort on text only</p>\n"},"asUCString":{"!type":"fn(s: ?) -> string","!doc":"<p>Case insensitive string</p>\n"},"asUCText":{"!type":"fn(s: ?) -> string","!doc":"<p>Strips all HTML tags to sort on text only - Case insensitive</p>\n"},"none":{"!type":"fn(s: ?) -> ?","!doc":"<p>Default sort that does nothing</p>\n"}},"StoreManager":{"!doc":"<p>Contains a collection of all stores that are created that have an identifier. An identifier can be assigned by\nsetting the <a href=\"#!/api/Ext.data.AbstractStore-cfg-storeId\" rel=\"Ext.data.AbstractStore-cfg-storeId\" class=\"docClass\">storeId</a> property. When a store is in the StoreManager, it can be\nreferred to via it's identifier:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'SomeModel',\n    storeId: 'myStore'\n});\n\nvar store = <a href=\"#!/api/Ext.data.StoreManager-method-lookup\" rel=\"Ext.data.StoreManager-method-lookup\" class=\"docClass\">Ext.data.StoreManager.lookup</a>('myStore');\n</code></pre>\n\n<p>Also note that the <a href=\"#!/api/Ext.data.StoreManager-method-lookup\" rel=\"Ext.data.StoreManager-method-lookup\" class=\"docClass\">lookup</a> method is aliased to <a href=\"#!/api/Ext-method-getStore\" rel=\"Ext-method-getStore\" class=\"docClass\">Ext.getStore</a> for convenience.</p>\n\n<p>If a store is registered with the StoreManager, you can also refer to the store by it's identifier when registering\nit with any Component that consumes data from a store:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'SomeModel',\n    storeId: 'myStore'\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">Ext.view.View</a>', {\n    store: 'myStore',\n    // other configuration here\n});\n</code></pre>\n","!type":"fn(config: ?)","listeners":{},"getKey":{"!type":"fn(o: ?) -> ?","!doc":"<p>getKey implementation for MixedCollection</p>\n"},"lookup":{"!type":"fn(store: ?) -> ?","!doc":"<p>Gets a registered Store by id</p>\n"},"register":{"!type":"fn(stores: ?) -> !this","!doc":"<p>Registers one or more Stores with the StoreManager. You do not normally need to register stores manually. Any\nstore initialized with a <a href=\"#!/api/Ext.data.Store-cfg-storeId\" rel=\"Ext.data.Store-cfg-storeId\" class=\"docClass\">Ext.data.Store.storeId</a> will be auto-registered.</p>\n"},"unregister":{"!type":"fn(stores: ?) -> !this","!doc":"<p>Unregisters one or more Stores with the StoreManager</p>\n"}},"Tree":{"!doc":"<p>This class is used as a container for a series of nodes. The nodes themselves maintain\nthe relationship between parent/child. The tree itself acts as a manager. It gives functionality\nto retrieve a node by its identifier: <a href=\"#!/api/Ext.data.Tree-method-getNodeById\" rel=\"Ext.data.Tree-method-getNodeById\" class=\"docClass\">getNodeById</a>.</p>\n\n<p>The tree also relays events from any of it's child nodes, allowing them to be handled in a\ncentralized fashion. In general this class is not used directly, rather used internally\nby other parts of the framework.</p>\n","!type":"fn(root?: ?)","prototype":{"root":{"!doc":"<p>The root node for this tree</p>\n"},"filter":{"!type":"fn(sorterFn: ?, recursive: ?) -> !this","!doc":"<p>Filters this tree</p>\n"},"flatten":{"!type":"fn() -> ?","!doc":"<p>Flattens all the nodes in the tree into an array.</p>\n"},"getNodeById":{"!type":"fn(id: ?) -> ?","!doc":"<p>Gets a node in this tree by its id.</p>\n"},"getRootNode":{"!type":"fn() -> ?","!doc":"<p>Returns the root node for this tree.</p>\n"},"onNodeAppend":{"!type":"fn(parent: ?, node: ?) -> !this","!doc":"<p>Fired when a node is appended into the root or one of it's children</p>\n"},"onNodeIdChanged":{"!type":"fn(node: ?, oldId: ?, newId: ?) -> !this","!doc":"<p>Fired when a node's id changes.  Updates the node's id in the node hash.</p>\n"},"onNodeInsert":{"!type":"fn(parent: ?, node: ?) -> !this","!doc":"<p>Fired when a node is inserted into the root or one of it's children</p>\n"},"onNodeRemove":{"!type":"fn(parent: ?, node: ?) -> !this","!doc":"<p>Fired when a node is removed from the root or one of it's children</p>\n"},"registerNode":{"!type":"fn(node: ?, includeChildren?: ?) -> !this","!doc":"<p>Registers a node with the tree</p>\n"},"removeRootNode":{"!type":"fn() -> ?","!doc":"<p>Removes the root node from this tree.</p>\n"},"setRootNode":{"!type":"fn(node: ?) -> ?","!doc":"<p>Sets the root node for this tree.</p>\n"},"sort":{"!type":"fn(this: ?, childNodes: ?, eOpts: ?)","!doc":"<p>Fires when this node's childNodes are sorted.</p>\n"},"unregisterNode":{"!type":"fn(node: ?, includeChildren?: ?) -> !this","!doc":"<p>Unregisters a node with the tree</p>\n"},"append":{"!type":"fn(this: ?, node: ?, index: ?, eOpts: ?)","!doc":"<p>Fires when a new child node is appended</p>\n"},"beforeappend":{"!type":"fn(this: ?, node: ?, eOpts: ?)","!doc":"<p>Fires before a new child is appended, return false to cancel the append.</p>\n"},"beforecollapse":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before this node is collapsed.</p>\n"},"beforeexpand":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before this node is expanded.</p>\n"},"beforeinsert":{"!type":"fn(this: ?, node: ?, refNode: ?, eOpts: ?)","!doc":"<p>Fires before a new child is inserted, return false to cancel the insert.</p>\n"},"beforemove":{"!type":"fn(this: ?, oldParent: ?, newParent: ?, index: ?, eOpts: ?)","!doc":"<p>Fires before this node is moved to a new location in the tree. Return false to cancel the move.</p>\n"},"beforeremove":{"!type":"fn(this: ?, node: ?, isMove: ?, eOpts: ?)","!doc":"<p>Fires before a child is removed, return false to cancel the remove.</p>\n"},"collapse":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires when this node is collapsed.</p>\n"},"expand":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires when this node is expanded.</p>\n"},"insert":{"!type":"fn(this: ?, node: ?, refNode: ?, eOpts: ?)","!doc":"<p>Fires when a new child node is inserted.</p>\n"},"move":{"!type":"fn(this: ?, oldParent: ?, newParent: ?, index: ?, eOpts: ?)","!doc":"<p>Fires when this node is moved to a new location in the tree</p>\n"},"remove":{"!type":"fn(this: ?, node: ?, isMove: ?, eOpts: ?)","!doc":"<p>Fires when a child node is removed</p>\n"},"rootchange":{"!type":"fn(root: ?, eOpts: ?)","!doc":"<p>Fires whenever the root node is changed in the tree.</p>\n"}}},"TreeModel":{"!doc":"<p>This class can be used as a base class from which to derived Models used in Trees.</p>\n","!type":"fn(data: ?)"},"TreeStore":{"!doc":"<p>The TreeStore is a store implementation that is backed by by an <a href=\"#!/api/Ext.data.Tree\" rel=\"Ext.data.Tree\" class=\"docClass\">Ext.data.Tree</a>.\nIt provides convenience methods for loading nodes, as well as the ability to use\nthe hierarchical tree structure combined with a store. This class is generally used\nin conjunction with <a href=\"#!/api/Ext.tree.Panel\" rel=\"Ext.tree.Panel\" class=\"docClass\">Ext.tree.Panel</a>. This class also relays many events from\nthe Tree for convenience.</p>\n\n<h1>Using Models</h1>\n\n<p>If no Model is specified, an implicit model will be created that implements <a href=\"#!/api/Ext.data.NodeInterface\" rel=\"Ext.data.NodeInterface\" class=\"docClass\">Ext.data.NodeInterface</a>.\nThe standard Tree fields will also be copied onto the Model for maintaining their state. These fields are listed\nin the <a href=\"#!/api/Ext.data.NodeInterface\" rel=\"Ext.data.NodeInterface\" class=\"docClass\">Ext.data.NodeInterface</a> documentation.</p>\n\n<h1>Reading Nested Data</h1>\n\n<p>For the tree to read nested data, the <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a> must be configured with a root property,\nso the reader can find nested data for each node (if a root is not specified, it will default to\n'children'). This will tell the tree to look for any nested tree nodes by the same keyword, i.e., 'children'.\nIf a root is specified in the config make sure that any nested nodes with children have the same name.\nNote that setting <a href=\"#!/api/Ext.data.TreeStore-cfg-defaultRootProperty\" rel=\"Ext.data.TreeStore-cfg-defaultRootProperty\" class=\"docClass\">defaultRootProperty</a> accomplishes the same thing.</p>\n","!type":"fn(config: ?)","prototype":{"clearOnLoad":{"!type":"bool","!doc":"<p>Remove previously existing child nodes before loading.</p>\n"},"clearRemovedOnLoad":{"!type":"bool","!doc":"<p>If <code>true</code>, when a node is reloaded, any records in the <a href=\"#!/api/Ext.data.TreeStore-property-removed\" rel=\"Ext.data.TreeStore-property-removed\" class=\"docClass\">removed</a> record collection that were previously descendants of the node being reloaded will be cleared from the <a href=\"#!/api/Ext.data.TreeStore-property-removed\" rel=\"Ext.data.TreeStore-property-removed\" class=\"docClass\">removed</a> collection.\nOnly applicable if <a href=\"#!/api/Ext.data.TreeStore-cfg-clearOnLoad\" rel=\"Ext.data.TreeStore-cfg-clearOnLoad\" class=\"docClass\">clearOnLoad</a> is <code>true</code>.</p>\n"},"defaultRootId":{"!type":"string","!doc":"<p>The default root id.</p>\n"},"defaultRootProperty":{"!type":"string","!doc":"<p>The root property to specify on the reader if one is not explicitly defined.</p>\n"},"defaultRootText":{"!type":"string","!doc":"<p>The default root text (if not specified)/</p>\n"},"folderSort":{"!type":"bool","!doc":"<p>Set to true to automatically prepend a leaf sorter.</p>\n"},"nodeParam":{"!type":"string","!doc":"<p>The name of the parameter sent to the server which contains the identifier of the node.</p>\n"},"root":{"!doc":"<p>The root node for this store. For example:</p>\n\n<pre><code>root: {\n    expanded: true,\n    text: \"My Root\",\n    children: [\n        { text: \"Child 1\", leaf: true },\n        { text: \"Child 2\", expanded: true, children: [\n            { text: \"GrandChild\", leaf: true }\n        ] }\n    ]\n}\n</code></pre>\n\n<p>Setting the <code>root</code> config option is the same as calling <a href=\"#!/api/Ext.data.TreeStore-method-setRootNode\" rel=\"Ext.data.TreeStore-method-setRootNode\" class=\"docClass\">setRootNode</a>.</p>\n"},"fields":{"!doc":"<p>If we have no fields declare for the store, add some defaults.\nThese will be ignored if a model is explicitly specified.</p>\n"},"fillCount":{"!type":"number"},"rootProperty":{"!type":"string","!doc":"<p>Keep a copy of the default so we know if it's been changed in a subclass/config</p>\n"},"cleanRecords":{"!type":"fn(node: ?, records: ?) -> !this"},"clearRemoved":{"!type":"fn(node: ?) -> !this","!doc":"<p>Removes all records that used to be descendants of the passed node from the removed array</p>\n"},"doSort":{"!type":"fn(sorterFn: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"fillNode":{"!type":"fn(node: ?, newNodes: ?) -> !this","!doc":"<p>Fills a node with a series of child records.</p>\n"},"getById":{"!type":"fn(id: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"getNewRecords":{"!type":"fn() -> ?","!doc":"<p>inherit docs</p>\n"},"getNodeById":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns the record node by id</p>\n"},"getRootNode":{"!type":"fn() -> ?","!doc":"<p>Returns the root node for this tree.</p>\n"},"getUpdatedRecords":{"!type":"fn() -> ?","!doc":"<p>inherit docs</p>\n"},"load":{"!type":"fn(this: ?, node: ?, records: ?, successful: ?, eOpts: ?)","!doc":"<p>Fires whenever the store reads data from a remote data source.</p>\n"},"onBeforeNodeExpand":{"!type":"fn(node: ?, callback: ?, scope: ?, args: ?) -> !this","!doc":"<p>Fired by the root node.</p>\n\n<p>Called before a node is expanded.</p>\n\n<p>This ensures that the child nodes are available before calling the passed callback.</p>\n"},"onBeforeSort":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"},"onIdChanged":{"!type":"fn(model: ?, oldId: ?, newId: ?, oldInternalId: ?) -> !this"},"onNodeAdded":{"!type":"fn(parent: ?, node: ?) -> !this"},"onNodeRemove":{"!type":"fn(parent: ?, node: ?, isMove: ?) -> !this"},"onNodeSort":{"!type":"fn() -> !this"},"onProxyLoad":{"!type":"fn(operation: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"removeAll":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"},"setProxy":{"!type":"fn(proxy: ?) -> ?","!doc":"<p>inherit docs</p>\n"},"setRootNode":{"!type":"fn(root: ?) -> ?","!doc":"<p>Sets the root node for this store.  See also the <a href=\"#!/api/Ext.data.TreeStore-cfg-root\" rel=\"Ext.data.TreeStore-cfg-root\" class=\"docClass\">root</a> config option.</p>\n"},"sortByIndex":{"!type":"fn(node1: ?, node2: ?) -> number","!doc":"<p>Sorter function for sorting records in index order</p>\n"},"append":{"!type":"fn(this: ?, node: ?, index: ?, eOpts: ?)","!doc":"<p>Fires when a new child node is appended</p>\n"},"beforeappend":{"!type":"fn(this: ?, node: ?, eOpts: ?)","!doc":"<p>Fires before a new child is appended, return false to cancel the append.</p>\n"},"beforecollapse":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before this node is collapsed.</p>\n"},"beforeexpand":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires before this node is expanded.</p>\n"},"beforeinsert":{"!type":"fn(this: ?, node: ?, refNode: ?, eOpts: ?)","!doc":"<p>Fires before a new child is inserted, return false to cancel the insert.</p>\n"},"beforemove":{"!type":"fn(this: ?, oldParent: ?, newParent: ?, index: ?, eOpts: ?)","!doc":"<p>Fires before this node is moved to a new location in the tree. Return false to cancel the move.</p>\n"},"beforeremove":{"!type":"fn(this: ?, node: ?, isMove: ?, eOpts: ?)","!doc":"<p>Fires before a child is removed, return false to cancel the remove.</p>\n"},"collapse":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires when this node is collapsed.</p>\n"},"expand":{"!type":"fn(this: ?, eOpts: ?)","!doc":"<p>Fires when this node is expanded.</p>\n"},"insert":{"!type":"fn(this: ?, node: ?, refNode: ?, eOpts: ?)","!doc":"<p>Fires when a new child node is inserted.</p>\n"},"move":{"!type":"fn(this: ?, oldParent: ?, newParent: ?, index: ?, eOpts: ?)","!doc":"<p>Fires when this node is moved to a new location in the tree</p>\n"},"remove":{"!type":"fn(this: ?, node: ?, isMove: ?, eOpts: ?)","!doc":"<p>Fires when a child node is removed</p>\n"},"sort":{"!type":"fn(this: ?, childNodes: ?, eOpts: ?)","!doc":"<p>Fires when this node's childNodes are sorted.</p>\n"}}},"Types":{"!doc":"<p>This is a static class containing the system-supplied data types\nwhich may be given to a <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field</a>.</p>\n\n<p>The properties in this class are used as type indicators in the\n<a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field</a> class, so to test whether a Field is\nof a certain type, compare the <a href=\"#!/api/Ext.data.Field-cfg-type\" rel=\"Ext.data.Field-cfg-type\" class=\"docClass\">type</a>\nproperty against properties of this class.</p>\n\n<p>Developers may add their own application-specific data types to\nthis class. Definition names must be UPPERCASE. Each type\ndefinition must contain three properties:</p>\n\n<ul>\n<li><p><code>convert</code> : Function<br>\nA function to convert raw data values from a data block into\nthe data to be stored in the Field. The function is passed the\ncollowing parameters:</p>\n\n<ul>\n<li><strong>v</strong> : Mixed<br>\nThe data value as read by the Reader, if undefined will use\nthe configured <a href=\"#!/api/Ext.data.Field-cfg-defaultValue\" rel=\"Ext.data.Field-cfg-defaultValue\" class=\"docClass\">defaultValue</a>.</li>\n<li><strong>rec</strong> : Mixed<br>\nThe data object containing the row as read by the Reader.\nDepending on the Reader type, this could be an Array\n(<a href=\"#!/api/Ext.data.reader.Array\" rel=\"Ext.data.reader.Array\" class=\"docClass\">ArrayReader</a>), an object\n(<a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">JsonReader</a>), or an XML element.</li>\n</ul>\n</li>\n<li><p><code>sortType</code> : Function<br>\nA function to convert the stored data into comparable form, as\ndefined by <a href=\"#!/api/Ext.data.SortTypes\" rel=\"Ext.data.SortTypes\" class=\"docClass\">Ext.data.SortTypes</a>.</p></li>\n<li><p><code>type</code> : String<br>\nA textual data type name.</p></li>\n</ul>\n\n\n<p>For example, to create a VELatLong field (See the Microsoft Bing\nMapping API) containing the latitude/longitude value of a datapoint\non a map from a JsonReader data block</p>\n\n<p>which contained the properties <code>lat</code> and <code>long</code>, you would define a\nnew data type like this:</p>\n\n<pre><code>// Add a new Field data type which stores a VELatLong object in the Record.\nExt.data.Types.VELATLONG = {\n    convert: function(v, data) {\n        return new VELatLong(data.lat, data.long);\n    },\n    sortType: function(v) {\n        return v.Latitude;  // When sorting, order by latitude\n    },\n    type: 'VELatLong'\n};\n</code></pre>\n\n<p>Then, when declaring a Model, use:</p>\n\n<pre><code>var types = <a href=\"#!/api/Ext.data.Types\" rel=\"Ext.data.Types\" class=\"docClass\">Ext.data.Types</a>; // allow shorthand type access\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Unit',\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        { name: 'unitName', mapping: 'UnitName' },\n        { name: 'curSpeed', mapping: 'CurSpeed', type: types.INT },\n        { name: 'latitude', mapping: 'lat', type: types.FLOAT },\n        { name: 'longitude', mapping: 'long', type: types.FLOAT },\n        { name: 'position', type: types.VELATLONG }\n    ]\n});\n</code></pre>\n","AUTO":{"!doc":"<p>This data type means that no conversion is applied to the raw data before it is placed into a Record.</p>\n"},"BOOL":{"!doc":"<p>This data type means that the raw data is converted into a boolean before it is placed into\na Record. The string \"true\" and the number 1 are converted to boolean true.</p>\n\n<p>The synonym <code>BOOLEAN</code> is equivalent.</p>\n"},"BOOLEAN":{"!doc":"<p>This data type means that the raw data is converted into a boolean before it is placed into\na Record. The string \"true\" and the number 1 are converted to boolean <code>true</code>.</p>\n\n<p>The synonym <code>BOOL</code> is equivalent.</p>\n"},"DATE":{"!doc":"<p>This data type means that the raw data is converted into a Date before it is placed into a Record.\nThe date format is specified in the constructor of the <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Ext.data.Field</a> to which this type is\nbeing applied.</p>\n"},"FLOAT":{"!doc":"<p>This data type means that the raw data is converted into a number before it is placed into a Record.</p>\n\n<p>The synonym <code>NUMBER</code> is equivalent.</p>\n"},"INT":{"!doc":"<p>This data type means that the raw data is converted into an integer before it is placed into a Record.</p>\n\n<p>The synonym <code>INTEGER</code> is equivalent.</p>\n"},"INTEGER":{"!doc":"<p>This data type means that the raw data is converted into an integer before it is placed into a Record.</p>\n\n<p>The synonym <code>INT</code> is equivalent.</p>\n"},"NUMBER":{"!doc":"<p>This data type means that the raw data is converted into a number before it is placed into a Record.</p>\n\n<p>The synonym <code>FLOAT</code> is equivalent.</p>\n"},"STRING":{"!doc":"<p>This data type means that the raw data is converted into a String before it is placed into a Record.</p>\n"},"stripRe":{"!doc":"<p>A regular expression for stripping non-numeric characters from a numeric value.\nThis should be overridden for localization.</p>\n"}},"UuidGenerator":{"!doc":"<p>This class generates UUID's according to RFC 4122. This class has a default id property.\nThis means that a single instance is shared unless the id property is overridden. Thus,\ntwo <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> instances configured like the following share one generator:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelX', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: 'uuid'\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.data.MyModelY', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    idgen: 'uuid'\n});\n</code></pre>\n\n<p>This allows all models using this class to share a commonly configured instance.</p>\n\n<h1>Using Version 1 (\"Sequential\") UUID's</h1>\n\n<p>If a server can provide a proper timestamp and a \"cryptographic quality random number\"\n(as described in RFC 4122), the shared instance can be configured as follows:</p>\n\n<pre><code><a href=\"#!/api/Ext.data.IdGenerator-static-method-get\" rel=\"Ext.data.IdGenerator-static-method-get\" class=\"docClass\">Ext.data.IdGenerator.get</a>('uuid').reconfigure({\n    version: 1,\n    clockSeq: clock, // 14 random bits\n    salt: salt,      // 48 secure random bits (the Node field)\n    timestamp: ts    // timestamp per Section 4.1.4\n});\n\n// or these values can be split into 32-bit chunks:\n\n<a href=\"#!/api/Ext.data.IdGenerator-static-method-get\" rel=\"Ext.data.IdGenerator-static-method-get\" class=\"docClass\">Ext.data.IdGenerator.get</a>('uuid').reconfigure({\n    version: 1,\n    clockSeq: clock,\n    salt: { lo: saltLow32, hi: saltHigh32 },\n    timestamp: { lo: timestampLow32, hi: timestamptHigh32 }\n});\n</code></pre>\n\n<p>This approach improves the generator's uniqueness by providing a valid timestamp and\nhigher quality random data. Version 1 UUID's should not be used unless this information\ncan be provided by a server and care should be taken to avoid caching of this data.</p>\n\n<p>See http://www.ietf.org/rfc/rfc4122.txt for details.</p>\n","!type":"fn(config?: ?)","prototype":{"version":{"!type":"number","!doc":"<p>The Version of UUID. Supported values are:</p>\n\n<ul>\n<li>1 : Time-based, \"sequential\" UUID.</li>\n<li>4 : Pseudo-random UUID.</li>\n</ul>\n\n\n<p>The default is 4.</p>\n"},"salt":{"!doc":"<p>When created, this value is a 48-bit number. For computation, this value is split\ninto 32-bit parts and stored in an object with <code>hi</code> and <code>lo</code> properties.</p>\n"},"timestamp":{"!doc":"<p>When created, this value is a 60-bit number. For computation, this value is split\ninto 32-bit parts and stored in an object with <code>hi</code> and <code>lo</code> properties.</p>\n"},"init":{"!type":"fn() -> !this"},"reconfigure":{"!type":"fn(config: ?) -> !this","!doc":"<p>Reconfigures this generator given new config properties.</p>\n"}}},"validations":{"!doc":"<p>This singleton contains a set of validation functions that can be used to validate any type of data. They are most\noften used in <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Models</a>, where they are automatically set up and executed.</p>\n","emailMessage":{"!type":"string","!doc":"<p>The default error message used when an email validation fails</p>\n"},"emailRe":{"!doc":"<p>The regular expression used to validate email addresses</p>\n"},"exclusionMessage":{"!type":"string","!doc":"<p>The default error message used when an exclusion validation fails.</p>\n"},"formatMessage":{"!type":"string","!doc":"<p>The default error message used when a format validation fails.</p>\n"},"inclusionMessage":{"!type":"string","!doc":"<p>The default error message used when an inclusion validation fails.</p>\n"},"lengthMessage":{"!type":"string","!doc":"<p>The default error message used when a length validation fails.</p>\n"},"presenceMessage":{"!type":"string","!doc":"<p>The default error message used when a presence validation fails.</p>\n"},"email":{"!type":"fn(config: ?, email: ?) -> bool","!doc":"<p>Validates that an email string is in the correct format</p>\n"},"exclusion":{"!type":"fn(config: ?, value: ?) -> bool","!doc":"<p>Validates that the given value is not present in the configured <code>list</code>.\nFor example:</p>\n\n<pre><code>validations: [{type: 'exclusion', field: 'username', list: ['Admin', 'Operator']}]\n</code></pre>\n"},"format":{"!type":"fn(config: ?, value: ?) -> bool","!doc":"<p>Returns true if the given value passes validation against the configured <code>matcher</code> regex.\nFor example:</p>\n\n<pre><code>validations: [{type: 'format', field: 'username', matcher: /([a-z]+)[0-9]{2,3}/}]\n</code></pre>\n"},"inclusion":{"!type":"fn(config: ?, value: ?) -> bool","!doc":"<p>Validates that the given value is present in the configured <code>list</code>.\nFor example:</p>\n\n<pre><code>validations: [{type: 'inclusion', field: 'gender', list: ['Male', 'Female']}]\n</code></pre>\n"},"length":{"!type":"fn(config: ?, value: ?) -> bool","!doc":"<p>Returns true if the given value is between the configured min and max values.\nFor example:</p>\n\n<pre><code>validations: [{type: 'length', field: 'name', min: 2}]\n</code></pre>\n"},"presence":{"!type":"fn(config: ?, value: ?) -> bool","!doc":"<p>Validates that the given value is present.\nFor example:</p>\n\n<pre><code>validations: [{type: 'presence', field: 'age'}]\n</code></pre>\n"}},"writer":{"Json":{"!doc":"<p>This class is used to write <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> data to the server in a JSON format.\nThe <a href=\"#!/api/Ext.data.writer.Json-cfg-allowSingle\" rel=\"Ext.data.writer.Json-cfg-allowSingle\" class=\"docClass\">allowSingle</a> configuration can be set to false to force the records to always be\nencoded in an array, even if there is only a single record being sent.</p>\n","!type":"fn(config?: ?)","prototype":{"allowSingle":{"!type":"bool","!doc":"<p>Configure with <code>false</code> to ensure that records are always wrapped in an array, even if there is only\none record being sent. When there is more than one record, they will always be encoded into an array.</p>\n"},"encode":{"!type":"bool","!doc":"<p>Configure <code>true</code> to send record data (all record fields if <a href=\"#!/api/Ext.data.writer.Json-cfg-writeAllFields\" rel=\"Ext.data.writer.Json-cfg-writeAllFields\" class=\"docClass\">writeAllFields</a> is <code>true</code>)\nas a JSON encoded HTTP parameter named by the <a href=\"#!/api/Ext.data.writer.Json-cfg-root\" rel=\"Ext.data.writer.Json-cfg-root\" class=\"docClass\">root</a> configuration.</p>\n\n<p>The encode option should only be set to true when a <a href=\"#!/api/Ext.data.writer.Json-cfg-root\" rel=\"Ext.data.writer.Json-cfg-root\" class=\"docClass\">root</a> is defined, because the values will be\nsent as part of the request parameters as opposed to a raw post. The root will be the name of the parameter\nsent to the server.</p>\n"},"expandData":{"!type":"bool","!doc":"<p>By default, when dot-delimited field <a href=\"#!/api/Ext.data.writer.Json-cfg-nameProperty\" rel=\"Ext.data.writer.Json-cfg-nameProperty\" class=\"docClass\">mappings</a> are\nused (e.g. <code>name: 'myProperty', mapping: 'my.nested.property'</code>) the writer will simply output a flat data\nobject containing the mapping string literal as the property name (e.g. <code>{ 'my.nested.property': 'foo' }</code>).</p>\n\n<p>Mappings are used to map incoming nested JSON to flat Ext models. In many case, the data output by the\nwriter should preferrably match the original nested data format. Setting this config to <code>true</code> will ensure\nthat the output will instead look like <code>{ my: { nested: { property: 'foo' }}}</code>. The output is generated\nby <a href=\"#!/api/Ext.data.writer.Json-method-getExpandedData\" rel=\"Ext.data.writer.Json-method-getExpandedData\" class=\"docClass\">getExpandedData</a>, which can optionally be overridden to apply more customized logic.</p>\n"},"root":{"!type":"string","!doc":"<p>The HTTP parameter name by which JSON encoded records will be passed to the server if the\n<a href=\"#!/api/Ext.data.writer.Json-cfg-encode\" rel=\"Ext.data.writer.Json-cfg-encode\" class=\"docClass\">encode</a> option is <code>true</code>.</p>\n"},"getExpandedData":{"!type":"fn(data: ?) -> !this","!doc":"<p>The Reader classes support dot-delimited data mappings for extracting nested raw data into fields, so the\nwriter must support converting the flat <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> structure back into the original nested data\nformat. Using the same mappings when available, the Writer will simply split each delimiter into a nested\nobject in the output, which should exactly match the input format. For example, record data like this:</p>\n\n<pre><code>my.nested.property: 'foo',\nmy.nested.another: 'bar',\nmy.somethingElse: 123\n</code></pre>\n\n<p>should write out as...</p>\n\n<pre><code>my: {\n    nested: {\n        property: 'foo',\n        another: 'bar\n    },\n    somethingElse: 123\n}\n</code></pre>\n\n<p>This behavior is governed by the <a href=\"#!/api/Ext.data.writer.Json-cfg-expandData\" rel=\"Ext.data.writer.Json-cfg-expandData\" class=\"docClass\">expandData</a> config. By default, this option is <code>false</code> for\ncompatibility reasons, and will output a flat structure matching the flat record format. Setting this config\nto <code>true</code> will enable the expanded mapping behavior as shown here. This method could also be overridden\nto provide an even more customized output data structure.</p>\n"},"writeRecords":{"!type":"fn(request: ?, data: ?) -> !this","!doc":"<p>inherit docs</p>\n"}}},"Writer":{"prototype":{"dateFormat":{"!type":"string","!doc":"<p>This is used for each field of type date in the model to format the value before\nit is sent to the server.</p>\n"},"nameProperty":{"!type":"string","!doc":"<p>This property is used to read the key for each value that will be sent to the server. For example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Person', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [{\n        name: 'first',\n        mapping: 'firstName'\n    }, {\n        name: 'last',\n        mapping: 'lastName'\n    }, {\n        name: 'age'\n    }]\n});\nnew <a href=\"#!/api/Ext.data.writer.Writer\" rel=\"Ext.data.writer.Writer\" class=\"docClass\">Ext.data.writer.Writer</a>({\n    writeAllFields: true,\n    nameProperty: 'mapping'\n});\n\n// This will be sent to the server\n{\n    firstName: 'first name value',\n    lastName: 'last name value',\n    age: 1\n}\n</code></pre>\n\n<p>If the value is not present, the field name will always be used.</p>\n"},"writeAllFields":{"!type":"bool","!doc":"<p>True to write all fields from the record to the server. If set to false it will only send the fields that were\nmodified. Note that any fields that have <a href=\"#!/api/Ext.data.Field-cfg-persist\" rel=\"Ext.data.Field-cfg-persist\" class=\"docClass\">Ext.data.Field.persist</a> set to false will still be ignored.</p>\n"},"writeRecordId":{"!type":"bool","!doc":"<p>By default, each record's id is always included in the output for non-phantom records since in most\ncases the id will be required on the server to process the record action. This is helpful since the id\nwill normally not be modified, and so would not be sent to the server unless <a href=\"#!/api/Ext.data.writer.Writer-cfg-writeAllFields\" rel=\"Ext.data.writer.Writer-cfg-writeAllFields\" class=\"docClass\">writeAllFields</a>\nwas explicitly enabled.</p>\n\n<p>However, there are cases where it is not desirable for the record id to be passed in the data directly.\nFor example, when using a RESTful API the record id would typically be appended to the url instead.</p>\n"},"isWriter":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Writer, or subclass thereof.</p>\n"},"getRecordData":{"!type":"fn(record: ?, operation?: ?) -> ?","!doc":"<p>Formats the data for each record before sending it to the server. This\nmethod should be overridden to format the data in a way that differs from the default.</p>\n"},"write":{"!type":"fn(request: ?) -> ?","!doc":"<p>Prepares a Proxy's <a href=\"#!/api/Ext.data.Request\" rel=\"Ext.data.Request\" class=\"docClass\">Ext.data.Request</a> object</p>\n"},"writeValue":{"!type":"fn(data: ?, field: ?, record: ?) -> !this"}},"!doc":"<p>Base Writer class used by most subclasses of <a href=\"#!/api/Ext.data.proxy.Server\" rel=\"Ext.data.proxy.Server\" class=\"docClass\">Ext.data.proxy.Server</a>. This class is responsible for taking a\nset of <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Ext.data.Operation</a> objects and a <a href=\"#!/api/Ext.data.Request\" rel=\"Ext.data.Request\" class=\"docClass\">Ext.data.Request</a> object and modifying that request based on\nthe Operations.</p>\n\n<p>For example a <a href=\"#!/api/Ext.data.writer.Json\" rel=\"Ext.data.writer.Json\" class=\"docClass\">Ext.data.writer.Json</a> would format the Operations and their <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> instances based on\nthe config options passed to the JsonWriter's constructor.</p>\n\n<p>Writers are not needed for any kind of local storage - whether via a <a href=\"#!/api/Ext.data.proxy.WebStorage\" rel=\"Ext.data.proxy.WebStorage\" class=\"docClass\">Web Storage\nproxy</a> (see <a href=\"#!/api/Ext.data.proxy.LocalStorage\" rel=\"Ext.data.proxy.LocalStorage\" class=\"docClass\">localStorage</a> and <a href=\"#!/api/Ext.data.proxy.SessionStorage\" rel=\"Ext.data.proxy.SessionStorage\" class=\"docClass\">sessionStorage</a>) or just in memory via a <a href=\"#!/api/Ext.data.proxy.Memory\" rel=\"Ext.data.proxy.Memory\" class=\"docClass\">MemoryProxy</a>.</p>\n\n<h1>Dates</h1>\n\n<p>Before sending dates to the server, they can be formatted using one of the <a href=\"#!/api/Ext.Date\" rel=\"Ext.Date\" class=\"docClass\">Ext.Date</a> formats.\nThese formats can be specified both on the field and the writer itself. In terms of precedence, from highest to lowest:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.data.writer.Writer-cfg-dateFormat\" rel=\"Ext.data.writer.Writer-cfg-dateFormat\" class=\"docClass\">Writer.dateFormat</a> The writer dateFormat will always have the highest precedence</li>\n<li><a href=\"#!/api/Ext.data.Field-cfg-dateWriteFormat\" rel=\"Ext.data.Field-cfg-dateWriteFormat\" class=\"docClass\">Ext.data.Field.dateWriteFormat</a> The dateWriteFormat will be used if no format is specified on the writer</li>\n<li><a href=\"#!/api/Ext.data.Field-cfg-dateFormat\" rel=\"Ext.data.Field-cfg-dateFormat\" class=\"docClass\">Field.dateFormat</a>/<a href=\"#!/api/Ext.data.Field-cfg-dateReadFormat\" rel=\"Ext.data.Field-cfg-dateReadFormat\" class=\"docClass\">Field.dateReadFormat</a>\nFinally, if none of the above options are specified the field will be formatted using the format that was used to read the date from the server.</li>\n</ul>\n\n","!type":"fn(config?: ?)"},"Xml":{"!doc":"<p>This class is used to write <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> data to the server in an XML format.\nThe <a href=\"#!/api/Ext.data.writer.Xml-cfg-documentRoot\" rel=\"Ext.data.writer.Xml-cfg-documentRoot\" class=\"docClass\">documentRoot</a> property is used to specify the root element in the XML document.\nThe <a href=\"#!/api/Ext.data.writer.Xml-cfg-record\" rel=\"Ext.data.writer.Xml-cfg-record\" class=\"docClass\">record</a> option is used to specify the element name for each record that will make\nup the XML document.</p>\n","!type":"fn(config?: ?)","prototype":{"defaultDocumentRoot":{"!type":"string","!doc":"<p>The root to be used if <a href=\"#!/api/Ext.data.writer.Xml-cfg-documentRoot\" rel=\"Ext.data.writer.Xml-cfg-documentRoot\" class=\"docClass\">documentRoot</a> is empty and a root is required\nto form a valid XML document.</p>\n"},"documentRoot":{"!type":"string","!doc":"<p>The name of the root element of the document. Defaults to <tt>'xmlData'</tt>.\nIf there is more than 1 record and the root is not specified, the default document root will still be used\nto ensure a valid XML document is created.</p>\n"},"header":{"!type":"string","!doc":"<p>A header to use in the XML document (such as setting the encoding or version).\nDefaults to <tt>''</tt>.</p>\n"},"record":{"!type":"string","!doc":"<p>The name of the node to use for each record. Defaults to <tt>'record'</tt>.</p>\n"},"writeRecords":{"!type":"fn(request: ?, data: ?) -> !this","!doc":"<p>inherit docs</p>\n"}}}},"XmlStore":{"!doc":"<p>Small helper class to make creating <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>s from XML data easier.\nA XmlStore will be automatically configured with a <a href=\"#!/api/Ext.data.reader.Xml\" rel=\"Ext.data.reader.Xml\" class=\"docClass\">Ext.data.reader.Xml</a>.</p>\n\n\n<p>A store configuration would be something like:\n<pre><code>var store = new <a href=\"#!/api/Ext.data.XmlStore\" rel=\"Ext.data.XmlStore\" class=\"docClass\">Ext.data.XmlStore</a>({\n    // store configs\n    storeId: 'myStore',\n    url: 'sheldon.xml', // automatically configures a HttpProxy\n    // reader configs\n    record: 'Item', // records will have an \"Item\" tag\n    idPath: 'ASIN',\n    totalRecords: '@TotalResults'\n    fields: [\n        // set up the fields mapping into the xml doc\n        // The first needs mapping, the others are very basic\n        {name: 'Author', mapping: 'ItemAttributes > Author'},\n        'Title', 'Manufacturer', 'ProductGroup'\n    ]\n});\n</code></pre></p>\n\n\n<p>This store is configured to consume a returned object of the form:\n<pre><code>&#60?xml version=\"1.0\" encoding=\"UTF-8\"?>\n&#60ItemSearchResponse xmlns=\"http://webservices.amazon.com/AWSECommerceService/2009-05-15\">\n    &#60Items>\n        &#60Request>\n            &#60IsValid>True&#60/IsValid>\n            &#60ItemSearchRequest>\n                &#60Author>Sidney Sheldon&#60/Author>\n                &#60SearchIndex>Books&#60/SearchIndex>\n            &#60/ItemSearchRequest>\n        &#60/Request>\n        &#60TotalResults>203&#60/TotalResults>\n        &#60TotalPages>21&#60/TotalPages>\n        &#60Item>\n            &#60ASIN>0446355453&#60/ASIN>\n            &#60DetailPageURL>\n                http://www.amazon.com/\n            &#60/DetailPageURL>\n            &#60ItemAttributes>\n                &#60Author>Sidney Sheldon&#60/Author>\n                &#60Manufacturer>Warner Books&#60/Manufacturer>\n                &#60ProductGroup>Book&#60/ProductGroup>\n                &#60Title>Master of the Game&#60/Title>\n            &#60/ItemAttributes>\n        &#60/Item>\n    &#60/Items>\n&#60/ItemSearchResponse>\n</code></pre>\nAn object literal of this form could also be used as the <a href=\"#!/api/Ext.data.XmlStore-cfg-data\" rel=\"Ext.data.XmlStore-cfg-data\" class=\"docClass\">data</a> config option.</p>\n\n\n<p><b>Note:</b> This class accepts all of the configuration options of\n<b><a href=\"#!/api/Ext.data.reader.Xml\" rel=\"Ext.data.reader.Xml\" class=\"docClass\">XmlReader</a></b>.</p>\n\n","!type":"fn(config: ?)"}},"app":{"Application":{"!doc":"<p>Represents an Ext JS 4 application, which is typically a single page app using a <a href=\"#!/api/Ext.container.Viewport\" rel=\"Ext.container.Viewport\" class=\"docClass\">Viewport</a>.\nA typical <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> might look like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'MyApp',\n    launch: function() {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.container.Viewport\" rel=\"Ext.container.Viewport\" class=\"docClass\">Ext.container.Viewport</a>', {\n            items: {\n                html: 'My App'\n            }\n        });\n    }\n});\n</code></pre>\n\n<p>This does several things. First it creates a global variable called 'MyApp' - all of your Application's classes (such\nas its Models, Views and Controllers) will reside under this single namespace, which drastically lowers the chances\nof colliding global variables. The MyApp global will also have a getApplication method to get a reference to\nthe current application:</p>\n\n<pre><code>var app = MyApp.getApplication();\n</code></pre>\n\n<p>When the page is ready and all of your JavaScript has loaded, your Application's <a href=\"#!/api/Ext.app.Application-method-launch\" rel=\"Ext.app.Application-method-launch\" class=\"docClass\">launch</a> function is called,\nat which time you can run the code that starts your app. Usually this consists of creating a Viewport, as we do in\nthe example above.</p>\n\n<h1>Telling Application about the rest of the app</h1>\n\n<p>Because an <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> represents an entire app, we should tell it about the other parts of the app - namely\nthe Models, Views and Controllers that are bundled with the application. Let's say we have a blog management app; we\nmight have Models and Controllers for Posts and Comments, and Views for listing, adding and editing Posts and Comments.\nHere's how we'd tell our Application about all these things:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Blog',\n    models: ['Post', 'Comment'],\n    controllers: ['Posts', 'Comments'],\n\n    launch: function() {\n        ...\n    }\n});\n</code></pre>\n\n<p>Note that we didn't actually list the Views directly in the Application itself. This is because Views are managed by\nControllers, so it makes sense to keep those dependencies there. The Application will load each of the specified\nControllers using the pathing conventions laid out in the <a href=\"#/guide/application_architecture\">application architecture guide</a> - in this case\nexpecting the controllers to reside in app/controller/Posts.js and app/controller/Comments.js. In turn, each\nController simply needs to list the Views it uses and they will be automatically loaded. Here's how our Posts\ncontroller like be defined:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Posts', {\n    extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n    views: ['posts.List', 'posts.Edit'],\n\n    //the rest of the Controller here\n});\n</code></pre>\n\n<p>Because we told our Application about our Models and Controllers, and our Controllers about their Views, Ext JS will\nautomatically load all of our app files for us. This means we don't have to manually add script tags into our html\nfiles whenever we add a new class, but more importantly it enables us to create a minimized build of our entire\napplication using Sencha Cmd.</p>\n\n<h1>Deriving from <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a></h1>\n\n<p>Typically, applications do not derive directly from <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a>. Rather, the\nconfiguration passed to <code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a></code> mimics what you might do in a derived class.\nIn some cases, however, it can be desirable to share logic by using a derived class\nfrom <code><a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a></code>.</p>\n\n<p>Derivation works as you would expect, but using the derived class should still be the\njob of the <code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a></code> method.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.app.Application', {\n    extend: '<a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a>',\n    name: 'MyApp',\n    ...\n});\n\n<a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>('MyApp.app.Application');\n</code></pre>\n\n<p>For more information about writing Ext JS 4 applications, please see the <a href=\"#/guide/application_architecture\">application architecture guide</a>.</p>\n","!type":"fn(config?: ?)","prototype":{"appFolder":{"!type":"string","!doc":"<p>The path to the directory which contains all application's classes.\nThis path will be registered via <a href=\"#!/api/Ext.Loader-method-setPath\" rel=\"Ext.Loader-method-setPath\" class=\"docClass\">Ext.Loader.setPath</a> for the namespace specified\nin the <a href=\"#!/api/Ext.app.Application-cfg-name\" rel=\"Ext.app.Application-cfg-name\" class=\"docClass\">name</a> config.</p>\n"},"appProperty":{"!type":"string","!doc":"<p>The name of a property to be assigned to the main namespace to gain a reference to\nthis application. Can be set to an empty value to prevent the reference from\nbeing created</p>\n\n<pre><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'MyApp',\n    appProperty: 'myProp',\n\n    launch: function() {\n        console.log(MyApp.myProp === this);\n    }\n});\n</code></pre>\n"},"autoCreateViewport":{"!type":"bool","!doc":"<p>True to automatically load and instantiate AppName.view.Viewport before firing the launch\nfunction.</p>\n"},"controllers":{"!doc":"<p>Names of controllers that the app uses.</p>\n"},"enableQuickTips":{"!type":"bool","!doc":"<p>True to automatically set up <a href=\"#!/api/Ext.tip.QuickTip\" rel=\"Ext.tip.QuickTip\" class=\"docClass\">Ext.tip.QuickTip</a> support.</p>\n"},"name":{"!type":"string","!doc":"<p>The name of your application. This will also be the namespace for your views, controllers\nmodels and stores. Don't use spaces or special characters in the name. <strong>Application name\nis mandatory</strong>.</p>\n"},"namespaces":{"!doc":"<p>The list of namespace prefixes used in the application to resolve dependencies\nlike Views and Stores:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n     name: 'MyApp',\n\n     namespaces: ['Common.code'],\n\n     controllers: [ 'Common.code.controller.Foo', 'Bar' ]\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Common.code.controller.Foo', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     models: ['Foo'],    // Loads Common.code.model.Foo\n     views:  ['Bar']     // Loads Common.code.view.Bar\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Bar', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     models: ['Foo'],    // Loads MyApp.model.Foo\n     views:  ['Bar']     // Loads MyApp.view.Bar\n });\n</code></pre>\n\n<p>You don't need to include main namespace (MyApp), it will be added to the list\nautomatically.</p>\n"},"paths":{"!doc":"<p>Additional load paths to add to <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a>.\nSee <a href=\"#!/api/Ext.Loader-cfg-paths\" rel=\"Ext.Loader-cfg-paths\" class=\"docClass\">Ext.Loader.paths</a> config for more details.</p>\n"},"scope":{"!doc":"<p>The scope to execute the <a href=\"#!/api/Ext.app.Application-method-launch\" rel=\"Ext.app.Application-method-launch\" class=\"docClass\">launch</a> function in. Defaults to the Application instance.</p>\n"},"finishInitControllers":{"!type":"fn() -> !this"},"getApplication":{"!type":"fn() -> ?","!doc":"<p>Returns the base <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> for this controller.</p>\n"},"getController":{"!type":"fn(name: ?) -> ?","!doc":"<p>Returns instance of a <a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Controller</a> with the given id.\nWhen controller doesn't exist yet, it's created. Note that this method depends\non Application instance and will return undefined when Application is not\naccessible. The only exception is when this Controller instance's id is requested;\nin that case we always return the instance even if Application is no available.</p>\n"},"getModuleClassName":{"!type":"fn(name: ?, kind: ?) -> !this"},"initControllers":{"!type":"fn() -> !this"},"initNamespace":{"!type":"fn() -> !this"},"initQuickTips":{"!type":"fn() -> !this"},"initViewport":{"!type":"fn() -> !this"},"launch":{"!type":"fn(profile: ?) -> bool","!doc":"<p>Called automatically when the page has completely loaded. This is an empty function that should be\noverridden by each application that needs to take action on page load.</p>\n"},"onBeforeLaunch":{"!type":"fn() -> !this"},"onClassExtended":{"!type":"fn(cls: ?, data: ?, hooks: ?) -> !this"}}},"Controller":{"prototype":{"id":{"!type":"string","!doc":"<p>The id of this controller. You can use this id when dispatching.</p>\n"},"models":{"!doc":"<p>Array of models to require from AppName.model namespace. For example:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     models: ['User', 'Vehicle']\n });\n</code></pre>\n\n<p>This is equivalent of:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     requires: ['MyApp.model.User', 'MyApp.model.Vehicle'],\n\n     getUserModel: function() {\n         return this.getModel(\"User\");\n     },\n\n     getVehicleModel: function() {\n         return this.getModel(\"Vehicle\");\n     }\n });\n</code></pre>\n"},"refs":{"!doc":"<p>Array of configs to build up references to views on page. For example:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n\n     refs: [{\n         ref: 'list',\n         selector: 'grid'\n     }],\n });\n</code></pre>\n\n<p>This will add method <code>getList</code> to the controller which will internally use\n<a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> to reference the grid component on page.</p>\n\n<p>The following fields can be used in ref definition:</p>\n\n<ul>\n<li><code>ref</code> - name of the reference.</li>\n<li><code>selector</code> - <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> selector to access the component.</li>\n<li><code>autoCreate</code> - True to create the component automatically if not found on page.</li>\n<li><code>forceCreate</code> - Forces the creation of the component every time reference is accessed\n(when <code>get&lt;REFNAME&gt;</code> is called).</li>\n<li><code>xtype</code> - Used to create component by its xtype with autoCreate or forceCreate. If\nyou don't provide xtype, an <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> instance will be created.</li>\n</ul>\n\n"},"stores":{"!doc":"<p>Array of stores to require from AppName.store namespace and to generate getter methods for.\nFor example:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     stores: ['Users', 'Vehicles']\n });\n</code></pre>\n\n<p>This is equivalent to:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n\n     requires: [\n         'MyApp.store.Users',\n         'MyApp.store.Vehicles'\n     ]\n\n     getUsersStore: function() {\n         return this.getStore(\"Users\");\n     },\n\n     getVehiclesStore: function() {\n         return this.getStore(\"Vehicles\");\n     }\n });\n</code></pre>\n"},"views":{"!doc":"<p>Array of views to require from AppName.view namespace and to generate getter methods for.\nFor example:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     views: ['List', 'Detail']\n });\n</code></pre>\n\n<p>This is equivalent of:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(\"MyApp.controller.Foo\", {\n     extend: \"<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>\",\n     requires: ['MyApp.view.List', 'MyApp.view.Detail'],\n\n     getListView: function() {\n         return this.getView(\"List\");\n     },\n\n     getDetailView: function() {\n         return this.getView(\"Detail\");\n     }\n });\n</code></pre>\n"},"application":{"!doc":"<p>The <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> for this controller.</p>\n"},"addRef":{"!type":"fn(refs: ?) -> !this","!doc":"<p>Registers one or more <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">references</a>.</p>\n"},"control":{"!type":"fn(selectors: ?, listeners?: ?) -> !this","!doc":"<p>Adds listeners to components selected via <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a>. Accepts an\nobject containing component paths mapped to a hash of listener functions.</p>\n\n<p>In the following example the <code>updateUser</code> function is mapped to to the <code>click</code>\nevent on a button component, which is a child of the <code>useredit</code> component.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('AM.controller.Users', {\n     init: function() {\n         this.control({\n             'useredit button[action=save]': {\n                 click: this.updateUser\n             }\n         });\n     },\n\n     updateUser: function(button) {\n         console.log('clicked the Save button');\n     }\n });\n</code></pre>\n\n<p>Or alternatively one call <code>control</code> with two arguments:</p>\n\n<pre><code> this.control('useredit button[action=save]', {\n     click: this.updateUser\n });\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> for more information on component selectors.</p>\n"},"doInit":{"!type":"fn(app: ?) -> !this"},"finishInit":{"!type":"fn(app: ?) -> !this"},"getModel":{"!type":"fn(name: ?) -> ?","!doc":"<p>Returns a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> class with the given name.\nA shorthand for using <a href=\"#!/api/Ext.ModelManager-method-getModel\" rel=\"Ext.ModelManager-method-getModel\" class=\"docClass\">Ext.ModelManager.getModel</a>.</p>\n"},"getRef":{"!type":"fn(ref: ?, info: ?, config: ?) -> !this"},"getStore":{"!type":"fn(name: ?) -> ?","!doc":"<p>Returns instance of a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> with the given name.\nWhen store doesn't exist yet, it's created.</p>\n"},"getView":{"!type":"fn(name: ?) -> ?","!doc":"<p>Returns a View class with the given name.  To create an instance of the view,\nyou can use it like it's used by Application to create the Viewport:</p>\n\n<pre><code>this.getView('Viewport').create();\n</code></pre>\n"},"hasRef":{"!type":"fn(ref: ?) -> bool","!doc":"<p>Returns <code>true</code> if a <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">reference</a> is registered.</p>\n"},"init":{"!type":"fn(application: ?) -> !this","!doc":"<p>A template method that is called when your application boots. It is called before the\n<a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Application</a>'s launch function is executed so gives a hook point\nto run any code before your Viewport is created.</p>\n"},"initAutoGetters":{"!type":"fn() -> !this"},"listen":{"!type":"fn(to: ?) -> !this","!doc":"<p>Adds listeners to different event sources (also called \"event domains\"). The\nprimary event domain is that of components, but there are also other event domains:\n<a href=\"#!/api/Ext.app.domain.Global\" rel=\"Ext.app.domain.Global\" class=\"docClass\">Global</a> domain that intercepts events fired from\n<a href=\"#!/api/Ext-property-globalEvents\" rel=\"Ext-property-globalEvents\" class=\"docClass\">Ext.globalEvents</a> Observable instance, <a href=\"#!/api/Ext.app.domain.Controller\" rel=\"Ext.app.domain.Controller\" class=\"docClass\">Controller</a>\ndomain can be used to listen to events fired by other Controllers,\n<a href=\"#!/api/Ext.app.domain.Store\" rel=\"Ext.app.domain.Store\" class=\"docClass\">Store</a> domain gives access to Store events, and\n<a href=\"#!/api/Ext.app.domain.Direct\" rel=\"Ext.app.domain.Direct\" class=\"docClass\">Direct</a> domain can be used with <a href=\"#!/api/Ext.direct.Manager\" rel=\"Ext.direct.Manager\" class=\"docClass\">Ext.Direct</a> Providers\nto listen to their events.</p>\n\n<p>To listen to \"bar\" events fired by a controller with id=\"foo\":</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             controller: {\n                 '#foo': {\n                    bar: this.onFooBar\n                 }\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n\n<p>To listen to \"bar\" events fired by any controller, and \"baz\" events\nfired by Store with storeId=\"baz\":</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             controller: {\n                 '*': {\n                    bar: this.onAnyControllerBar\n                 }\n             },\n             store: {\n                 '#baz': {\n                     baz: this.onStoreBaz\n                 }\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n\n<p>To listen to \"idle\" events fired by <a href=\"#!/api/Ext-property-globalEvents\" rel=\"Ext-property-globalEvents\" class=\"docClass\">Ext.globalEvents</a> when other event\nprocessing is complete and Ext JS is about to return control to the browser:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             global: {               // Global events are always fired\n                 idle: this.onIdle   // from the same object, so there\n             }                       // are no selectors\n         });\n     }\n });\n</code></pre>\n\n<p>As this relates to components, the following example:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             component: {\n                 'useredit button[action=save]': {\n                    click: this.updateUser\n                 }\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n\n<p>Is equivalent to:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('AM.controller.Users', {\n     init: function() {\n         this.control({\n             'useredit button[action=save]': {\n                click: this.updateUser\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n\n<p>Of course, these can all be combined in a single call and used instead of\n<code>control</code>, like so:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('AM.controller.Users', {\n     init: function() {\n         this.listen({\n             global: {\n                 idle: this.onIdle\n             },\n             controller: {\n                 '*': {\n                    foobar: this.onAnyFooBar\n                 },\n                 '#foo': {\n                    bar: this.onFooBar\n                 }\n             },\n             component: {\n                 'useredit button[action=save]': {\n                    click: this.updateUser\n                 }\n             },\n             store: {\n                 '#qux': {\n                     load: this.onQuxLoad\n                 }\n             }\n         });\n     },\n     ...\n });\n</code></pre>\n"},"onLaunch":{"!type":"fn(application: ?) -> !this","!doc":"<p>A template method like <a href=\"#!/api/Ext.app.Controller-method-init\" rel=\"Ext.app.Controller-method-init\" class=\"docClass\">init</a>, but called after the viewport is created.\nThis is called after the <a href=\"#!/api/Ext.app.Application-method-launch\" rel=\"Ext.app.Application-method-launch\" class=\"docClass\">launch</a> method of Application\nis executed.</p>\n"},"ref":{"!type":"fn(refs: ?) -> !this"},"controllerRegex":{},"strings":{},"getApplication":{"!type":"fn() -> ?","!doc":"<p>Returns the base <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> for this controller.</p>\n"},"getController":{"!type":"fn(id: ?) -> ?","!doc":"<p>Returns instance of a <a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Controller</a> with the given id.\nWhen controller doesn't exist yet, it's created. Note that this method depends\non Application instance and will return undefined when Application is not\naccessible. The only exception is when this Controller instance's id is requested;\nin that case we always return the instance even if Application is no available.</p>\n"},"createGetter":{"!type":"fn(baseGetter: ?, name: ?) -> !this"},"getFullName":{"!type":"fn(name: ?, kind: ?, namespace: ?) -> !this"},"getGetterName":{"!type":"fn(name: ?, kindUpper: ?) -> !this"},"processDependencies":{"!type":"fn(cls: ?, requires: ?, namespace: ?, kind: ?, names: ?) -> !this","!doc":"<p>This method is called like so:</p>\n\n<pre><code> <a href=\"#!/api/Ext.app.Controller-static-method-processDependencies\" rel=\"Ext.app.Controller-static-method-processDependencies\" class=\"docClass\">Ext.app.Controller.processDependencies</a>(proto, requiresArray, 'MyApp', 'model', [\n     'User',\n     'Item',\n     'Foo@Common.model',\n     'Bar.Baz@Common.model'\n ]);\n</code></pre>\n\n<p>Required dependencies are added to requiresArray.</p>\n"}},"!doc":"<p>Controllers are the glue that binds an application together. All they really do is listen for events (usually from\nviews) and take some action. Here's how we might create a Controller to manage Users:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     init: function() {\n         console.log('Initialized Users! This happens before ' +\n                     'the Application launch() function is called');\n     }\n });\n</code></pre>\n\n<p>The init function is a special method that is called when your application boots. It is called before the\n<a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Application</a>'s launch function is executed so gives a hook point to run any code before\nyour Viewport is created.</p>\n\n<p>The init function is a great place to set up how your controller interacts with the view, and is usually used in\nconjunction with another Controller function - <a href=\"#!/api/Ext.app.Controller-method-control\" rel=\"Ext.app.Controller-method-control\" class=\"docClass\">control</a>. The control function\nmakes it easy to listen to events on your view classes and take some action with a handler function. Let's update\nour Users controller to tell us when the panel is rendered:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     init: function() {\n         this.control({\n             'viewport &gt; panel': {\n                 render: this.onPanelRendered\n             }\n         });\n     },\n\n     onPanelRendered: function() {\n         console.log('The panel was rendered');\n     }\n });\n</code></pre>\n\n<p>We've updated the init function to use <a href=\"#!/api/Ext.app.Controller-method-control\" rel=\"Ext.app.Controller-method-control\" class=\"docClass\">control method</a> to set up listeners on views\nin our application. The control method uses the ComponentQuery engine to quickly and easily get references to components\non the page. If you are not familiar with ComponentQuery yet, be sure to check out the\n<a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">documentation</a>. In brief though, it allows us to pass a CSS-like selector that will find\nevery matching component on the page.</p>\n\n<p>In our init function above we supplied 'viewport > panel', which translates to \"find me every Panel that is a direct\nchild of a Viewport\". We then supplied an object that maps event names (just 'render' in this case) to handler\nfunctions. The overall effect is that whenever any component that matches our selector fires a 'render' event, our\nonPanelRendered function is called.</p>\n\n<h2>Event domains</h2>\n\n<p>In Ext JS 4.2, we introduced the concept of event domains. In terms of MVC, an event domain\nis one or more base classes that fire events to which a Controller wants to listen. Besides\nComponent event domain that encompass <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>-descended Views, Controllers now\ncan listen to events from data Stores, <a href=\"#!/api/Ext.direct.Manager\" rel=\"Ext.direct.Manager\" class=\"docClass\">Ext.Direct</a> Providers, other Controllers, and <a href=\"#!/api/Ext-property-globalEvents\" rel=\"Ext-property-globalEvents\" class=\"docClass\">Ext.globalEvents</a>.\nThis feature provides a way to communicate between parts of the whole application without the need\nto bind controllers together tightly, and allows to develop and test application parts in isolation.</p>\n\n<p>See usage examples in <a href=\"#!/api/Ext.app.Controller-method-listen\" rel=\"Ext.app.Controller-method-listen\" class=\"docClass\">listen</a> method documentation.</p>\n\n<h2>Using refs</h2>\n\n<p>One of the most useful parts of Controllers is the ref system. These use the <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> to\nmake it really easy to get references to Views on your page. Let's look at an example of this now:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     refs: [{\n         ref: 'list',\n         selector: 'grid'\n     }],\n\n     init: function() {\n         this.control({\n             'button': {\n                 click: this.refreshGrid\n             }\n         });\n     },\n\n     refreshGrid: function() {\n         this.getList().store.load();\n     }\n });\n</code></pre>\n\n<p>This example assumes the existence of a <a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">Grid</a> on the page, which contains a single button to\nrefresh the Grid when clicked. In our refs array, we set up a reference to the grid. There are two parts to this -\nthe 'selector', which is a <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selector which finds any grid on the page and\nassigns it to the reference 'list'.</p>\n\n<p>By giving the reference a name, we get a number of things for free. The first is the getList function that we use in\nthe refreshGrid method above. This is generated automatically by the Controller based on the name of our ref, which\nwas capitalized and prepended with get to go from 'list' to 'getList'.</p>\n\n<p>The way this works is that the first time getList is called by your code, the ComponentQuery selector is run and the\nfirst component that matches the selector ('grid' in this case) will be returned. All future calls to getList will\nuse a cached reference to that grid. Usually it is advised to use a specific ComponentQuery selector that will only\nmatch a single View in your application (in the case above our selector will match any grid on the page).</p>\n\n<p>Bringing it all together, our init function is called when the application boots, at which time we call this.control\nto listen to any click on a <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> and call our refreshGrid function (again, this will\nmatch any button on the page so we advise a more specific selector than just 'button', but have left it this way for\nsimplicity). When the button is clicked we use out getList function to refresh the grid.</p>\n\n<p>You can create any number of refs and control any number of components this way, simply adding more functions to\nyour Controller as you go. For an example of real-world usage of Controllers see the Feed Viewer example in the\nexamples/app/feed-viewer folder in the SDK download.</p>\n\n<h2>Generated getter methods</h2>\n\n<p>Refs aren't the only thing that generate convenient getter methods. Controllers often have to deal with Models and\nStores so the framework offers a couple of easy ways to get access to those too. Let's look at another example:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Users', {\n     extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n     models: ['User'],\n     stores: ['AllUsers', 'AdminUsers'],\n\n     init: function() {\n         var User, allUsers, ed;\n\n         User = this.getUserModel();\n         allUsers = this.getAllUsersStore();\n\n         ed = new User({ name: 'Ed' });\n         allUsers.add(ed);\n     }\n });\n</code></pre>\n\n<p>By specifying Models and Stores that the Controller cares about, it again dynamically loads them from the appropriate\nlocations (app/model/User.js, app/store/AllUsers.js and app/store/AdminUsers.js in this case) and creates getter\nfunctions for them all. The example above will create a new User model instance and add it to the AllUsers Store.\nOf course, you could do anything in this function but in this case we just did something simple to demonstrate the\nfunctionality.</p>\n\n<h2>Further Reading</h2>\n\n<p>For more information about writing Ext JS 4 applications, please see the\n<a href=\"#/guide/application_architecture\">application architecture guide</a>. Also see the <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a>\ndocumentation.</p>\n","!type":"fn(config?: ?)"},"domain":{"Component":{"!doc":"<p>This class implements the component event domain. All classes extending from\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> are included in this domain. The matching criteria uses\n<a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a>.</p>\n","!type":"fn()","type":{"!type":"string"},"match":{"!type":"fn(target: ?, selector: ?) -> bool","!doc":"<p>This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.\nDefault matching is very simple: a match is true when selector equals target's\n<a href=\"#!/api/Ext.app.domain.Component-cfg-idProperty\" rel=\"Ext.app.domain.Component-cfg-idProperty\" class=\"docClass\">idProperty</a>, or when selector is '*' wildcard to match any\ntarget.</p>\n"}},"Controller":{"!doc":"<p>This class implements the controller event domain. All classes extending from\n<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a> are included in this domain. The selectors are simply id's or the\nwildcard \"*\" to match any controller.</p>\n","!type":"fn()","idProperty":{"!type":"string","!doc":"<p>Name of the identifier property for this event domain.</p>\n"},"type":{"!type":"string"}},"Direct":{"!doc":"<p>This class implements the <a href=\"#!/api/Ext.direct.Manager\" rel=\"Ext.direct.Manager\" class=\"docClass\">Ext.Direct</a> event domain. All classes extending from\n<a href=\"#!/api/Ext.direct.Provider\" rel=\"Ext.direct.Provider\" class=\"docClass\">Ext.direct.Provider</a> are included in this domain. The selectors are simply provider\nid's or the wildcard \"*\" to match any provider.</p>\n","!type":"fn()","idProperty":{"!type":"string","!doc":"<p>Name of the identifier property for this event domain.</p>\n"},"type":{"!type":"string"}},"Global":{"!doc":"<p>This class implements the global event domain. This domain represents event fired from\n<a href=\"#!/api/Ext-property-globalEvents\" rel=\"Ext-property-globalEvents\" class=\"docClass\">Ext.globalEvents</a> Observable instance. No selectors are supported for this domain.</p>\n","!type":"fn()","type":{"!type":"string"},"listen":{"!type":"fn(listeners: ?) -> !this","!doc":"<p>This method adds listeners on behalf of a controller. Since Global domain does not\nsupport selectors, we skip this layer and just accept an object keyed by events.\nFor example:</p>\n\n<pre><code> domain.listen({\n     idle: function() { ... },\n     afterlayout: {\n         fn: function() { ... },\n         delay: 10\n     }\n });\n</code></pre>\n"},"match":{"!type":"fn() -> bool","!doc":"<p>This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.\nDefault matching is very simple: a match is true when selector equals target's\n<a href=\"#!/api/Ext.app.domain.Global-cfg-idProperty\" rel=\"Ext.app.domain.Global-cfg-idProperty\" class=\"docClass\">idProperty</a>, or when selector is '*' wildcard to match any\ntarget.</p>\n"}},"Store":{"!doc":"<p>This class implements the data store event domain. All classes extending from\n<a href=\"#!/api/Ext.data.AbstractStore\" rel=\"Ext.data.AbstractStore\" class=\"docClass\">Ext.data.AbstractStore</a> are included in this domain. The selectors are simply\nstore id's or the wildcard \"*\" to match any store.</p>\n","!type":"fn()","idProperty":{"!type":"string","!doc":"<p>Name of the identifier property for this event domain.</p>\n"},"type":{"!type":"string"}}},"EventDomain":{"idProperty":{"!type":"string","!doc":"<p>Name of the identifier property for this event domain.</p>\n"},"dispatch":{"!type":"fn(target: ?, ev: ?, args: ?) -> bool","!doc":"<p>This method dispatches an event fired by an object monitored by this domain. This\nis not called directly but is called by interceptors injected by the <code>monitor</code> method.</p>\n"},"listen":{"!type":"fn(selectors: ?) -> !this","!doc":"<p>This method adds listeners on behalf of a controller. This method is passed an\nobject that is keyed by selectors. The value of these is also an object but now\nkeyed by event name. For example:</p>\n\n<pre><code> domain.listen({\n     'some[selector]': {\n         click: function() { ... }\n     },\n\n     'other selector': {\n         change: {\n             fn: function() { ... },\n             delay: 10\n         }\n     }\n\n }, controller);\n</code></pre>\n"},"monitor":{"!type":"fn(observable: ?) -> !this","!doc":"<p>This method is called by the derived class to monitor <code>fireEvent</code> calls. Any call\nto <code>fireEvent</code> on the target Observable will be intercepted and dispatched to any\nlistening Controllers. Assuming the original <code>fireEvent</code> method does not return\n<code>false</code>, the event is passed to the <code>dispatch</code> method of this object.</p>\n\n<p>This is typically called in the <code>constructor</code> of derived classes.</p>\n"},"unlisten":{"!type":"fn(controllerId: ?) -> !this","!doc":"<p>Removes all of a controller's attached listeners.</p>\n"},"match":{"!type":"fn(target: ?, selector: ?) -> bool","!doc":"<p>This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.\nDefault matching is very simple: a match is true when selector equals target's\n<a href=\"#!/api/Ext.app.EventDomain-cfg-idProperty\" rel=\"Ext.app.EventDomain-cfg-idProperty\" class=\"docClass\">idProperty</a>, or when selector is '*' wildcard to match any\ntarget.</p>\n"},"!doc":"<p>This class is a base class for an event domain. In the context of MVC, an \"event domain\"\nis one or more base classes that fire events to which a Controller wants to listen. A\ncontroller listens to events by describing the selectors for events of interest to it.</p>\n\n<p>Matching selectors to the firer of an event is one key aspect that defines an event\ndomain. All event domain instances must provide a <code>match</code> method that tests selectors\nagainst the event firer.</p>\n\n<p>When an event domain instance is created (typically as a <code>singleton</code>), its <code>type</code>\nproperty is used to catalog the domain in the\n<a href=\"#!/api/Ext.app.EventDomain-static-property-instances\" rel=\"Ext.app.EventDomain-static-property-instances\" class=\"docClass\">Ext.app.EventDomain.instances</a> map.</p>\n\n<p>There are five event domains provided by default:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.app.domain.Component\" rel=\"Ext.app.domain.Component\" class=\"docClass\">Component domain</a>. This is the primary event domain that\nhas been available since Ext JS MVC was introduced. This domain is defined as any class that\nextends <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>, where the selectors use\n<a href=\"#!/api/Ext.ComponentQuery-method-query\" rel=\"Ext.ComponentQuery-method-query\" class=\"docClass\">Ext.ComponentQuery</a>.</li>\n<li><a href=\"#!/api/Ext.app.domain.Global\" rel=\"Ext.app.domain.Global\" class=\"docClass\">Global domain</a>. This domain provides Controllers with access\nto events fired from <a href=\"#!/api/Ext-property-globalEvents\" rel=\"Ext-property-globalEvents\" class=\"docClass\">Ext.globalEvents</a> Observable instance. These events represent\nthe state of the application as a whole, and are always anonymous. Because of this, Global\ndomain does not provide selectors at all.</li>\n<li><a href=\"#!/api/Ext.app.domain.Controller\" rel=\"Ext.app.domain.Controller\" class=\"docClass\">Controller domain</a>. This domain includes all classes\nthat extend <a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>. Events fired by Controllers will be available\nwithin this domain; selectors are either Controller's <a href=\"#!/api/Ext.app.Controller-cfg-id\" rel=\"Ext.app.Controller-cfg-id\" class=\"docClass\">id</a> or\n'*' wildcard for any Controller.</li>\n<li><a href=\"#!/api/Ext.app.domain.Store\" rel=\"Ext.app.domain.Store\" class=\"docClass\">Store domain</a>. This domain is for classes extending\n<a href=\"#!/api/Ext.data.AbstractStore\" rel=\"Ext.data.AbstractStore\" class=\"docClass\">Ext.data.AbstractStore</a>. Selectors are either Store's\n<a href=\"#!/api/Ext.data.AbstractStore-cfg-storeId\" rel=\"Ext.data.AbstractStore-cfg-storeId\" class=\"docClass\">storeId</a> or '*' wildcard for any Store.</li>\n<li><a href=\"#!/api/Ext.app.domain.Direct\" rel=\"Ext.app.domain.Direct\" class=\"docClass\">Direct domain</a>. This domain includes all classes that extend\n<a href=\"#!/api/Ext.direct.Provider\" rel=\"Ext.direct.Provider\" class=\"docClass\">Ext.direct.Provider</a>. Selectors are either Provider's <a href=\"#!/api/Ext.direct.Provider-cfg-id\" rel=\"Ext.direct.Provider-cfg-id\" class=\"docClass\">id</a>\nor '*' wildcard for any Provider. This domain is optional and will be loaded only if\n<a href=\"#!/api/Ext.direct.Manager\" rel=\"Ext.direct.Manager\" class=\"docClass\">Ext.direct.Manager</a> singleton is required in your application.</li>\n</ul>\n\n","!type":"fn()","prototype":{"idProperty":{"!type":"string","!doc":"<p>Name of the identifier property for this event domain.</p>\n"},"instances":{"!doc":"<p>An object map containing <code><a href=\"#!/api/Ext.app.EventDomain\" rel=\"Ext.app.EventDomain\" class=\"docClass\">Ext.app.EventDomain</a></code> instances keyed by the value\nof their <code>type</code> property.</p>\n"},"dispatch":{"!type":"fn(target: ?, ev: ?, args: ?) -> bool","!doc":"<p>This method dispatches an event fired by an object monitored by this domain. This\nis not called directly but is called by interceptors injected by the <code>monitor</code> method.</p>\n"},"listen":{"!type":"fn(selectors: ?) -> !this","!doc":"<p>This method adds listeners on behalf of a controller. This method is passed an\nobject that is keyed by selectors. The value of these is also an object but now\nkeyed by event name. For example:</p>\n\n<pre><code> domain.listen({\n     'some[selector]': {\n         click: function() { ... }\n     },\n\n     'other selector': {\n         change: {\n             fn: function() { ... },\n             delay: 10\n         }\n     }\n\n }, controller);\n</code></pre>\n"},"match":{"!type":"fn(target: ?, selector: ?) -> bool","!doc":"<p>This method matches the firer of the event (the <code>target</code>) to the given <code>selector</code>.\nDefault matching is very simple: a match is true when selector equals target's\n<a href=\"#!/api/Ext.app.EventDomain-cfg-idProperty\" rel=\"Ext.app.EventDomain-cfg-idProperty\" class=\"docClass\">idProperty</a>, or when selector is '*' wildcard to match any\ntarget.</p>\n"},"monitor":{"!type":"fn(observable: ?) -> !this","!doc":"<p>This method is called by the derived class to monitor <code>fireEvent</code> calls. Any call\nto <code>fireEvent</code> on the target Observable will be intercepted and dispatched to any\nlistening Controllers. Assuming the original <code>fireEvent</code> method does not return\n<code>false</code>, the event is passed to the <code>dispatch</code> method of this object.</p>\n\n<p>This is typically called in the <code>constructor</code> of derived classes.</p>\n"},"unlisten":{"!type":"fn(controllerId: ?) -> !this","!doc":"<p>Removes all of a controller's attached listeners.</p>\n"}}},"EventBus":{"!doc":"<p>This class manages event dispatching for Controllers. The details of connecting classes\nto this dispatching mechanism is delegated to <a href=\"#!/api/Ext.app.EventDomain\" rel=\"Ext.app.EventDomain\" class=\"docClass\">Ext.app.EventDomain</a> instances.</p>\n","!type":"fn()","control":{"!type":"fn(selectors: ?, controller: ?) -> !this","!doc":"<p>Adds a set of component event listeners for a controller. To work with event domains\nother than component, see <a href=\"#!/api/Ext.app.EventBus-method-listen\" rel=\"Ext.app.EventBus-method-listen\" class=\"docClass\">listen</a>.</p>\n"},"listen":{"!type":"fn(to: ?, controller: ?) -> !this","!doc":"<p>Adds a set of event domain listeners for a controller. For more information on event\ndomains, see <a href=\"#!/api/Ext.app.EventDomain\" rel=\"Ext.app.EventDomain\" class=\"docClass\">Ext.app.EventDomain</a> and <a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>.</p>\n"},"unlisten":{"!type":"fn(controllerId: ?) -> !this","!doc":"<p>Removes all of a controller's attached listeners.</p>\n"}}},"Array":{"!doc":"<p>A set of useful static methods to deal with arrays; provide missing methods for older browsers.</p>\n","clean":{"!type":"fn(array: ?) -> ?","!doc":"<p>Filter through an array and remove empty item as defined in <a href=\"#!/api/Ext-method-isEmpty\" rel=\"Ext-method-isEmpty\" class=\"docClass\">Ext.isEmpty</a></p>\n\n<p>See <a href=\"#!/api/Ext.Array-method-filter\" rel=\"Ext.Array-method-filter\" class=\"docClass\">filter</a></p>\n"},"clone":{"!type":"fn(array: ?) -> ?","!doc":"<p>Clone a flat array without referencing the previous one. Note that this is different\nfrom <a href=\"#!/api/Ext-method-clone\" rel=\"Ext-method-clone\" class=\"docClass\">Ext.clone</a> since it doesn't handle recursive cloning. It's simply a convenient, easy-to-remember method\nfor Array.prototype.slice.call(array)</p>\n"},"contains":{"!type":"fn(array: ?, item: ?) -> bool","!doc":"<p>Checks whether or not the given <code>array</code> contains the specified <code>item</code></p>\n"},"difference":{"!type":"fn(arrayA: ?, arrayB: ?) -> ?","!doc":"<p>Perform a set difference A-B by subtracting all items in array B from array A.</p>\n"},"each":{"!type":"fn(iterable: ?, fn: ?, scope?: ?, reverse?: ?) -> bool","!doc":"<p>Iterates an array or an iterable value and invoke the given callback function for each item.</p>\n\n<pre><code>var countries = ['Vietnam', 'Singapore', 'United States', 'Russia'];\n\n<a href=\"#!/api/Ext.Array-method-each\" rel=\"Ext.Array-method-each\" class=\"docClass\">Ext.Array.each</a>(countries, function(name, index, countriesItSelf) {\n    console.log(name);\n});\n\nvar sum = function() {\n    var sum = 0;\n\n    <a href=\"#!/api/Ext.Array-method-each\" rel=\"Ext.Array-method-each\" class=\"docClass\">Ext.Array.each</a>(arguments, function(value) {\n        sum += value;\n    });\n\n    return sum;\n};\n\nsum(1, 2, 3); // returns 6\n</code></pre>\n\n<p>The iteration can be stopped by returning false in the function callback.</p>\n\n<pre><code><a href=\"#!/api/Ext.Array-method-each\" rel=\"Ext.Array-method-each\" class=\"docClass\">Ext.Array.each</a>(countries, function(name, index, countriesItSelf) {\n    if (name === 'Singapore') {\n        return false; // break here\n    }\n});\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-each\" rel=\"Ext-method-each\" class=\"docClass\">Ext.each</a> is alias for <a href=\"#!/api/Ext.Array-method-each\" rel=\"Ext.Array-method-each\" class=\"docClass\">Ext.Array.each</a></p>\n"},"equals":{"!type":"fn(array1: ?, array2: ?) -> bool","!doc":"<p>Shallow compares the contents of 2 arrays using strict equality.</p>\n"},"erase":{"!type":"fn(array: ?, index: ?, removeCount: ?) -> ?","!doc":"<p>Removes items from an array. This is functionally equivalent to the splice method\nof Array, but works around bugs in IE8's splice method and does not copy the\nremoved elements in order to return them (because very often they are ignored).</p>\n"},"every":{"!type":"fn(array: ?, fn: ?, scope: ?) -> bool","!doc":"<p>Executes the specified function for each array element until the function returns a falsy value.\nIf such an item is found, the function will return false immediately.\nOtherwise, it will return true.</p>\n"},"filter":{"!type":"fn(array: ?, fn: ?, scope: ?) -> ?","!doc":"<p>Creates a new array with all of the elements of this array for which\nthe provided filtering function returns true.</p>\n"},"findBy":{"!type":"fn(array: ?, fn: ?, scope?: ?) -> ?","!doc":"<p>Returns the first item in the array which elicits a true return value from the\npassed selection function.</p>\n"},"flatten":{"!type":"fn(array: ?) -> ?","!doc":"<p>Recursively flattens into 1-d Array. Injects Arrays inline.</p>\n"},"forEach":{"!type":"fn(array: ?, fn: ?, scope?: ?) -> !this","!doc":"<p>Iterates an array and invoke the given callback function for each item. Note that this will simply\ndelegate to the native Array.prototype.forEach method if supported. It doesn't support stopping the\niteration by returning false in the callback function like <a href=\"#!/api/Ext.Array-method-each\" rel=\"Ext.Array-method-each\" class=\"docClass\">each</a>. However, performance\ncould be much better in modern browsers comparing with <a href=\"#!/api/Ext.Array-method-each\" rel=\"Ext.Array-method-each\" class=\"docClass\">each</a></p>\n"},"from":{"!type":"fn(value: ?, newReference?: ?) -> ?","!doc":"<p>Converts a value to an array if it's not already an array; returns:</p>\n\n<ul>\n<li>An empty array if given value is <code>undefined</code> or <code>null</code></li>\n<li>Itself if given value is already an array</li>\n<li>An array copy if given value is <a href=\"#!/api/Ext-method-isIterable\" rel=\"Ext-method-isIterable\" class=\"docClass\">iterable</a> (arguments, NodeList and alike)</li>\n<li>An array with one item which is the given value, otherwise</li>\n</ul>\n\n"},"include":{"!type":"fn(array: ?, item: ?) -> !this","!doc":"<p>Push an item into the array only if the array doesn't contain it yet</p>\n"},"indexOf":{"!type":"fn(array: ?, item: ?, from?: ?) -> number","!doc":"<p>Get the index of the provided <code>item</code> in the given <code>array</code>, a supplement for the\nmissing arrayPrototype.indexOf in Internet Explorer.</p>\n"},"insert":{"!type":"fn(array: ?, index: ?, items: ?) -> ?","!doc":"<p>Inserts items in to an array.</p>\n"},"intersect":{"!type":"fn(array1: ?, array2: ?, etc: ?) -> ?","!doc":"<p>Merge multiple arrays into one with unique items that exist in all of the arrays.</p>\n"},"map":{"!type":"fn(array: ?, fn: ?, scope?: ?) -> ?","!doc":"<p>Creates a new array with the results of calling a provided function on every element in this array.</p>\n"},"max":{"!type":"fn(array: ?, comparisonFn?: ?) -> ?","!doc":"<p>Returns the maximum value in the Array.</p>\n"},"mean":{"!type":"fn(array: ?) -> number","!doc":"<p>Calculates the mean of all items in the array.</p>\n"},"merge":{"!type":"fn(array1: ?, array2: ?, etc: ?) -> ?","!doc":"<p>Merge multiple arrays into one with unique items.</p>\n\n<p><a href=\"#!/api/Ext.Array-method-union\" rel=\"Ext.Array-method-union\" class=\"docClass\">union</a> is alias for <a href=\"#!/api/Ext.Array-method-merge\" rel=\"Ext.Array-method-merge\" class=\"docClass\">merge</a></p>\n"},"min":{"!type":"fn(array: ?, comparisonFn?: ?) -> ?","!doc":"<p>Returns the minimum value in the Array.</p>\n"},"pluck":{"!type":"fn(array: ?, propertyName: ?) -> ?","!doc":"<p>Plucks the value of a property from each item in the Array. Example:</p>\n\n<pre><code><a href=\"#!/api/Ext.Array-method-pluck\" rel=\"Ext.Array-method-pluck\" class=\"docClass\">Ext.Array.pluck</a>(<a href=\"#!/api/Ext-method-query\" rel=\"Ext-method-query\" class=\"docClass\">Ext.query</a>(\"p\"), \"className\"); // [el1.className, el2.className, ..., elN.className]\n</code></pre>\n"},"push":{"!type":"fn(target: ?, elements: ?) -> ?","!doc":"<p>Pushes new items onto the end of an Array.</p>\n\n<p>Passed parameters may be single items, or arrays of items. If an Array is found in the argument list, all its\nelements are pushed into the end of the target Array.</p>\n"},"remove":{"!type":"fn(array: ?, item: ?) -> ?","!doc":"<p>Removes the specified item from the array if it exists</p>\n"},"replace":{"!type":"fn(array: ?, index: ?, removeCount: ?, insert?: ?) -> ?","!doc":"<p>Replaces items in an array. This is functionally equivalent to the splice method\nof Array, but works around bugs in IE8's splice method and is often more convenient\nto call because it accepts an array of items to insert rather than use a variadic\nargument list.</p>\n"},"slice":{"!type":"fn(array: ?, begin: ?, end: ?) -> ?","!doc":"<p>Returns a shallow copy of a part of an array. This is equivalent to the native\ncall \"Array.prototype.slice.call(array, begin, end)\". This is often used when \"array\"\nis \"arguments\" since the arguments object does not supply a slice method but can\nbe the context object to Array.prototype.slice.</p>\n"},"some":{"!type":"fn(array: ?, fn: ?, scope: ?) -> bool","!doc":"<p>Executes the specified function for each array element until the function returns a truthy value.\nIf such an item is found, the function will return true immediately. Otherwise, it will return false.</p>\n"},"sort":{"!type":"fn(array: ?, sortFn?: ?) -> ?","!doc":"<p>Sorts the elements of an Array.\nBy default, this method sorts the elements alphabetically and ascending.</p>\n"},"splice":{"!type":"fn(array: ?, index: ?, removeCount: ?, elements: ?) -> ?","!doc":"<p>Replaces items in an array. This is equivalent to the splice method of Array, but\nworks around bugs in IE8's splice method. The signature is exactly the same as the\nsplice method except that the array is the first argument. All arguments following\nremoveCount are inserted in the array at index.</p>\n"},"sum":{"!type":"fn(array: ?) -> number","!doc":"<p>Calculates the sum of all items in the given array.</p>\n"},"toArray":{"!type":"fn(iterable: ?, start?: ?, end?: ?) -> ?","!doc":"<p>Converts any iterable (numeric indices and a length property) into a true array.</p>\n\n<pre><code>function test() {\n    var args = <a href=\"#!/api/Ext.Array-method-toArray\" rel=\"Ext.Array-method-toArray\" class=\"docClass\">Ext.Array.toArray</a>(arguments),\n        fromSecondToLastArgs = <a href=\"#!/api/Ext.Array-method-toArray\" rel=\"Ext.Array-method-toArray\" class=\"docClass\">Ext.Array.toArray</a>(arguments, 1);\n\n    alert(args.join(' '));\n    alert(fromSecondToLastArgs.join(' '));\n}\n\ntest('just', 'testing', 'here'); // alerts 'just testing here';\n                                 // alerts 'testing here';\n\n<a href=\"#!/api/Ext.Array-method-toArray\" rel=\"Ext.Array-method-toArray\" class=\"docClass\">Ext.Array.toArray</a>(document.getElementsByTagName('div')); // will convert the NodeList into an array\n<a href=\"#!/api/Ext.Array-method-toArray\" rel=\"Ext.Array-method-toArray\" class=\"docClass\">Ext.Array.toArray</a>('splitted'); // returns ['s', 'p', 'l', 'i', 't', 't', 'e', 'd']\n<a href=\"#!/api/Ext.Array-method-toArray\" rel=\"Ext.Array-method-toArray\" class=\"docClass\">Ext.Array.toArray</a>('splitted', 0, 3); // returns ['s', 'p', 'l']\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-toArray\" rel=\"Ext-method-toArray\" class=\"docClass\">Ext.toArray</a> is alias for <a href=\"#!/api/Ext.Array-method-toArray\" rel=\"Ext.Array-method-toArray\" class=\"docClass\">Ext.Array.toArray</a></p>\n"},"toMap":{"!type":"fn(array: ?, getKey?: ?, scope?: ?) -> ?","!doc":"<p>Creates a map (object) keyed by the elements of the given array. The values in\nthe map are the index+1 of the array element. For example:</p>\n\n<pre><code> var map = <a href=\"#!/api/Ext.Array-method-toMap\" rel=\"Ext.Array-method-toMap\" class=\"docClass\">Ext.Array.toMap</a>(['a','b','c']);\n\n // map = { a: 1, b: 2, c: 3 };\n</code></pre>\n\n<p>Or a key property can be specified:</p>\n\n<pre><code> var map = <a href=\"#!/api/Ext.Array-method-toMap\" rel=\"Ext.Array-method-toMap\" class=\"docClass\">Ext.Array.toMap</a>([\n         { name: 'a' },\n         { name: 'b' },\n         { name: 'c' }\n     ], 'name');\n\n // map = { a: 1, b: 2, c: 3 };\n</code></pre>\n\n<p>Lastly, a key extractor can be provided:</p>\n\n<pre><code> var map = <a href=\"#!/api/Ext.Array-method-toMap\" rel=\"Ext.Array-method-toMap\" class=\"docClass\">Ext.Array.toMap</a>([\n         { name: 'a' },\n         { name: 'b' },\n         { name: 'c' }\n     ], function (obj) { return obj.name.toUpperCase(); });\n\n // map = { A: 1, B: 2, C: 3 };\n</code></pre>\n"},"toValueMap":{"!type":"fn(array: ?, getKey?: ?, scope?: ?) -> ?","!doc":"<p>Creates a map (object) keyed by a property of elements of the given array. The values in\nthe map are the array element. For example:</p>\n\n<pre><code> var map = <a href=\"#!/api/Ext.Array-method-toMap\" rel=\"Ext.Array-method-toMap\" class=\"docClass\">Ext.Array.toMap</a>(['a','b','c']);\n\n // map = { a: 'a', b: 'b', c: 'c' };\n</code></pre>\n\n<p>Or a key property can be specified:</p>\n\n<pre><code> var map = <a href=\"#!/api/Ext.Array-method-toMap\" rel=\"Ext.Array-method-toMap\" class=\"docClass\">Ext.Array.toMap</a>([\n         { name: 'a' },\n         { name: 'b' },\n         { name: 'c' }\n     ], 'name');\n\n // map = { a: {name: 'a'}, b: {name: 'b'}, c: {name: 'c'} };\n</code></pre>\n\n<p>Lastly, a key extractor can be provided:</p>\n\n<pre><code> var map = <a href=\"#!/api/Ext.Array-method-toMap\" rel=\"Ext.Array-method-toMap\" class=\"docClass\">Ext.Array.toMap</a>([\n         { name: 'a' },\n         { name: 'b' },\n         { name: 'c' }\n     ], function (obj) { return obj.name.toUpperCase(); });\n\n // map = { A: {name: 'a'}, B: {name: 'b'}, C: {name: 'c'} };\n</code></pre>\n"},"union":{"!type":"fn(array1: ?, array2: ?, etc: ?) -> ?","!doc":"<p>Merge multiple arrays into one with unique items.</p>\n\n<p><a href=\"#!/api/Ext.Array-method-union\" rel=\"Ext.Array-method-union\" class=\"docClass\">union</a> is alias for <a href=\"#!/api/Ext.Array-method-merge\" rel=\"Ext.Array-method-merge\" class=\"docClass\">merge</a></p>\n"},"unique":{"!type":"fn(array: ?) -> ?","!doc":"<p>Returns a new array with unique items</p>\n"}},"button":{"Button":{"!doc":"<p>Create simple buttons with this component. Customisations include <a href=\"#!/api/Ext.button.Button-cfg-iconAlign\" rel=\"Ext.button.Button-cfg-iconAlign\" class=\"docClass\">aligned</a>\n<a href=\"#!/api/Ext.button.Button-cfg-iconCls\" rel=\"Ext.button.Button-cfg-iconCls\" class=\"docClass\">icons</a>, <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">dropdown menus</a>, <a href=\"#!/api/Ext.button.Button-cfg-tooltip\" rel=\"Ext.button.Button-cfg-tooltip\" class=\"docClass\">tooltips</a>\nand <a href=\"#!/api/Ext.button.Button-cfg-scale\" rel=\"Ext.button.Button-cfg-scale\" class=\"docClass\">sizing options</a>. Specify a <a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a> to run code when\na user clicks the button, or use <a href=\"#!/api/Ext.button.Button-cfg-listeners\" rel=\"Ext.button.Button-cfg-listeners\" class=\"docClass\">listeners</a> for other events such as\n<a href=\"#!/api/Ext.button.Button-event-mouseover\" rel=\"Ext.button.Button-event-mouseover\" class=\"docClass\">mouseover</a>. Example usage:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    text: 'Click me',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    handler: function() {\n        alert('You clicked the button!');\n    }\n});\n</code></pre>\n\n<p>The <a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a> configuration can also be updated dynamically using the <a href=\"#!/api/Ext.button.Button-method-setHandler\" rel=\"Ext.button.Button-method-setHandler\" class=\"docClass\">setHandler</a>\nmethod.  Example usage:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    text    : 'Dynamic Handler Button',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    handler : function() {\n        // this button will spit out a different number every time you click it.\n        // so firstly we must check if that number is already set:\n        if (this.clickCount) {\n            // looks like the property is already set, so lets just add 1 to that number and alert the user\n            this.clickCount++;\n            alert('You have clicked the button \"' + this.clickCount + '\" times.\\n\\nTry clicking it again..');\n        } else {\n            // if the clickCount property is not set, we will set it and alert the user\n            this.clickCount = 1;\n            alert('You just clicked the button for the first time!\\n\\nTry pressing it again..');\n        }\n    }\n});\n</code></pre>\n\n<p>A button within a container:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Ext.Container</a>', {\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items   : [\n        {\n            xtype: 'button',\n            text : 'My Button'\n        }\n    ]\n});\n</code></pre>\n\n<p>A useful option of Button is the <a href=\"#!/api/Ext.button.Button-cfg-scale\" rel=\"Ext.button.Button-cfg-scale\" class=\"docClass\">scale</a> configuration. This configuration has three different options:</p>\n\n<ul>\n<li><code>'small'</code></li>\n<li><code>'medium'</code></li>\n<li><code>'large'</code></li>\n</ul>\n\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    renderTo: document.body,\n    text    : 'Click me',\n    scale   : 'large'\n});\n</code></pre>\n\n<p>Buttons can also be toggled. To enable this, you simple set the <a href=\"#!/api/Ext.button.Button-cfg-enableToggle\" rel=\"Ext.button.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> property to <code>true</code>.\nExample usage:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    text: 'Click Me',\n    enableToggle: true\n});\n</code></pre>\n\n<p>You can assign a menu to a button by using the <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a> configuration. This standard configuration\ncan either be a reference to a <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">menu</a> object, a <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">menu</a> id or a\n<a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">menu</a> config blob. When assigning a menu to a button, an arrow is automatically\nadded to the button.  You can change the alignment of the arrow using the <a href=\"#!/api/Ext.button.Button-cfg-arrowAlign\" rel=\"Ext.button.Button-cfg-arrowAlign\" class=\"docClass\">arrowAlign</a> configuration\non button.  Example usage:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    text      : 'Menu button',\n    renderTo  : <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    arrowAlign: 'bottom',\n    menu      : [\n        {text: 'Item 1'},\n        {text: 'Item 2'},\n        {text: 'Item 3'},\n        {text: 'Item 4'}\n    ]\n});\n</code></pre>\n\n<p>Using listeners, you can easily listen to events fired by any component, using the <a href=\"#!/api/Ext.button.Button-cfg-listeners\" rel=\"Ext.button.Button-cfg-listeners\" class=\"docClass\">listeners</a>\nconfiguration or using the <a href=\"#!/api/Ext.button.Button-method-addListener\" rel=\"Ext.button.Button-method-addListener\" class=\"docClass\">addListener</a> method.  Button has a variety of different listeners:</p>\n\n<ul>\n<li><code>click</code></li>\n<li><code>toggle</code></li>\n<li><code>mouseover</code></li>\n<li><code>mouseout</code></li>\n<li><code>mouseshow</code></li>\n<li><code>menuhide</code></li>\n<li><code>menutriggerover</code></li>\n<li><code>menutriggerout</code></li>\n</ul>\n\n\n<p>Example usage:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.Button</a>', {\n    text     : 'Button',\n    renderTo : <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    listeners: {\n        click: function() {\n            // this == the button, as we are in the local scope\n            this.setText('I was clicked!');\n        },\n        mouseover: function() {\n            // set a new config which says we moused over, if not already set\n            if (!this.mousedOver) {\n                this.mousedOver = true;\n                alert('You moused over a button!\\n\\nI wont do this again.');\n            }\n        }\n    }\n});\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"allowDepress":{"!type":"bool","!doc":"<p>False to not allow a pressed Button to be depressed. Only valid when <a href=\"#!/api/Ext.button.Button-cfg-enableToggle\" rel=\"Ext.button.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> is true.</p>\n"},"arrowAlign":{"!type":"string","!doc":"<p>The side of the Button box to render the arrow if the button has an associated <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>. Two\nvalues are allowed:</p>\n\n<ul>\n<li>'right'</li>\n<li>'bottom'</li>\n</ul>\n\n"},"arrowCls":{"!type":"string","!doc":"<p>The className used for the inner arrow element if the button has a menu.</p>\n"},"baseCls":{"!type":"string","!doc":"<p>The base CSS class to add to all buttons.</p>\n"},"baseParams":{"!doc":"<p>An object literal of parameters to pass to the url when the <a href=\"#!/api/Ext.button.Button-cfg-href\" rel=\"Ext.button.Button-cfg-href\" class=\"docClass\">href</a> property is specified.</p>\n"},"clickEvent":{"!type":"string","!doc":"<p>The DOM event that will fire the handler of the button. This can be any valid event name (dblclick, contextmenu).</p>\n"},"cls":{"!type":"string","!doc":"<p>A CSS class string to apply to the button's main element.</p>\n"},"componentLayout":{"!doc":"<p>The sizing and positioning of a Component's internal Elements is the responsibility of the Component's layout\nmanager which sizes a Component's internal structure in response to the Component being sized.</p>\n\n<p>Generally, developers will not use this configuration as all provided Components which need their internal\nelements sizing (Such as <a href=\"#!/api/Ext.form.field.Base\" rel=\"Ext.form.field.Base\" class=\"docClass\">input fields</a>) come with their own componentLayout managers.</p>\n\n<p>The <a href=\"#!/api/Ext.layout.container.Auto\" rel=\"Ext.layout.container.Auto\" class=\"docClass\">default layout manager</a> will be used on instances of the base <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nclass which simply sizes the Component's encapsulating element to the height and width specified in the\n<a href=\"#!/api/Ext.button.Button-method-setSize\" rel=\"Ext.button.Button-method-setSize\" class=\"docClass\">setSize</a> method.</p>\n"},"destroyMenu":{"!type":"bool","!doc":"<p>Whether or not to destroy any associated menu when this button is destroyed. The menu\nwill be destroyed unless this is explicitly set to false.</p>\n"},"disabled":{"!type":"bool","!doc":"<p>True if this button is disabled.</p>\n"},"enableToggle":{"!type":"bool","!doc":"<p>True to enable pressed/not pressed toggling. If a <a href=\"#!/api/Ext.button.Button-cfg-toggleGroup\" rel=\"Ext.button.Button-cfg-toggleGroup\" class=\"docClass\">toggleGroup</a> is specified, this\noption will be set to true.</p>\n"},"focusCls":{"!type":"string","!doc":"<p>The CSS class to add to a button when it is in the focussed state.</p>\n"},"frame":{"!type":"bool","!doc":"<p>Specify as <code>true</code> to have the Component inject framing elements within the Component at render time to provide a\ngraphical rounded frame around the Component content.</p>\n\n<p>This is only necessary when running on outdated, or non standard-compliant browsers such as Microsoft's Internet\nExplorer prior to version 9 which do not support rounded corners natively.</p>\n\n<p>The extra space taken up by this framing is available from the read only property <a href=\"#!/api/Ext.button.Button-property-frameSize\" rel=\"Ext.button.Button-property-frameSize\" class=\"docClass\">frameSize</a>.</p>\n"},"glyph":{"!doc":"<p>A numeric unicode character code to use as the icon for this button. The default\nfont-family for glyphs can be set globally using\n<a href=\"#!/api/Ext-method-setGlyphFontFamily\" rel=\"Ext-method-setGlyphFontFamily\" class=\"docClass\">Ext.setGlyphFontFamily()</a>. Alternatively, this\nconfig option accepts a string with the charCode and font-family separated by the\n<code>@</code> symbol. For example '65@My Font Family'.</p>\n"},"handleMouseEvents":{"!type":"bool","!doc":"<p>False to disable visual cues on mouseover, mouseout and mousedown.</p>\n"},"handler":{"!doc":"<p>A function called when the button is clicked (can be used instead of click event).</p>\n"},"hidden":{"!type":"bool","!doc":"<p>True if this button is hidden.</p>\n"},"href":{"!type":"string","!doc":"<p>The URL to open when the button is clicked. Specifying this config causes the Button to be\nrendered with the specified URL as the <code>href</code> attribute of its <code>&lt;a&gt;</code> Element.</p>\n\n<p>This is better than specifying a click handler of</p>\n\n<pre><code>function() { window.location = \"http://www.sencha.com\" }\n</code></pre>\n\n<p>because the UI will provide meaningful hints to the user as to what to expect upon clicking\nthe button, and will also allow the user to open in a new tab or window, bookmark or drag the URL, or directly save\nthe URL stream to disk.</p>\n\n<p>See also the <a href=\"#!/api/Ext.button.Button-cfg-hrefTarget\" rel=\"Ext.button.Button-cfg-hrefTarget\" class=\"docClass\">hrefTarget</a> config.</p>\n"},"hrefTarget":{"!type":"string","!doc":"<p>The target attribute to use for the underlying anchor. Only used if the <a href=\"#!/api/Ext.button.Button-cfg-href\" rel=\"Ext.button.Button-cfg-href\" class=\"docClass\">href</a>\nproperty is specified.</p>\n"},"icon":{"!type":"string","!doc":"<p>The path to an image to display in the button.</p>\n"},"iconAlign":{"!type":"string","!doc":"<p>The side of the Button box to render the icon. Four values are allowed:</p>\n\n<ul>\n<li>'top'</li>\n<li>'right'</li>\n<li>'bottom'</li>\n<li>'left'</li>\n</ul>\n\n"},"iconCls":{"!type":"string","!doc":"<p>A css class which sets a background image to be used as the icon for this button.</p>\n"},"menu":{"!doc":"<p>The <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a> object associated with this Button when configured with the <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a> config\noption.</p>\n"},"menuActiveCls":{"!type":"string","!doc":"<p>The CSS class to add to a button when it's menu is active.</p>\n"},"menuAlign":{"!type":"string","!doc":"<p>The position to align the menu to (see <a href=\"#!/api/Ext.util.Positionable-method-alignTo\" rel=\"Ext.util.Positionable-method-alignTo\" class=\"docClass\">Ext.util.Positionable.alignTo</a> for more details).</p>\n"},"minWidth":{"!type":"number","!doc":"<p>The minimum width for this button (used to give a set of buttons a common width).\nSee also <a href=\"#!/api/Ext.panel.Panel\" rel=\"Ext.panel.Panel\" class=\"docClass\">Ext.panel.Panel</a>.<a href=\"#!/api/Ext.panel.Panel-cfg-minButtonWidth\" rel=\"Ext.panel.Panel-cfg-minButtonWidth\" class=\"docClass\">minButtonWidth</a>.</p>\n"},"overCls":{"!type":"string","!doc":"<p>The CSS class to add to a button when it is in the over (hovered) state.</p>\n"},"overflowText":{"!type":"string","!doc":"<p>If used in a <a href=\"#!/api/Ext.toolbar.Toolbar\" rel=\"Ext.toolbar.Toolbar\" class=\"docClass\">Toolbar</a>, the text to be used if this item is shown in the overflow menu.\nSee also <a href=\"#!/api/Ext.toolbar.Item\" rel=\"Ext.toolbar.Item\" class=\"docClass\">Ext.toolbar.Item</a>.<code><a href=\"#!/api/Ext.toolbar.Item-cfg-overflowText\" rel=\"Ext.toolbar.Item-cfg-overflowText\" class=\"docClass\">overflowText</a></code>.</p>\n"},"params":{"!doc":"<p>An object literal of parameters to pass to the url when the <a href=\"#!/api/Ext.button.Button-cfg-href\" rel=\"Ext.button.Button-cfg-href\" class=\"docClass\">href</a> property is specified. Any params\noverride <a href=\"#!/api/Ext.button.Button-cfg-baseParams\" rel=\"Ext.button.Button-cfg-baseParams\" class=\"docClass\">baseParams</a>. New params can be set using the <a href=\"#!/api/Ext.button.Button-method-setParams\" rel=\"Ext.button.Button-method-setParams\" class=\"docClass\">setParams</a> method.</p>\n"},"pressed":{"!type":"bool","!doc":"<p>True if this button is pressed (only if enableToggle = true).</p>\n"},"pressedCls":{"!type":"string","!doc":"<p>The CSS class to add to a button when it is in the pressed state.</p>\n"},"preventDefault":{"!type":"bool","!doc":"<p>True to prevent the default action when the <a href=\"#!/api/Ext.button.Button-cfg-clickEvent\" rel=\"Ext.button.Button-cfg-clickEvent\" class=\"docClass\">clickEvent</a> is processed.</p>\n"},"renderTpl":{"!doc":"<p>We have to keep \"unselectable\" attribute on all elements because it's not inheritable.\nWithout it, clicking anywhere on a button disrupts current selection and cursor position\nin HtmlEditor.</p>\n"},"repeat":{"!doc":"<p>True to repeat fire the click event while the mouse is down. This can also be a\n<a href=\"#!/api/Ext.util.ClickRepeater\" rel=\"Ext.util.ClickRepeater\" class=\"docClass\">ClickRepeater</a> config object.</p>\n"},"scale":{"!doc":"<p>The size of the Button. Three values are allowed:</p>\n\n<ul>\n<li>'small' - Results in the button element being 16px high.</li>\n<li>'medium' - Results in the button element being 24px high.</li>\n<li>'large' - Results in the button element being 32px high.</li>\n</ul>\n\n"},"scope":{"!doc":"<p>The scope (<strong>this</strong> reference) in which the <code><a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a></code> and <code><a href=\"#!/api/Ext.button.Button-cfg-toggleHandler\" rel=\"Ext.button.Button-cfg-toggleHandler\" class=\"docClass\">toggleHandler</a></code> is executed.\nDefaults to this Button.</p>\n"},"showEmptyMenu":{"!type":"bool","!doc":"<p>True to force an attached <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a> with no items to be shown when clicking\nthis button. By default, the menu will not show if it is empty.</p>\n"},"shrinkWrap":{"!doc":"<p>If this property is a number, it is interpreted as follows:</p>\n\n<ul>\n<li>0: Neither width nor height depend on content. This is equivalent to <code>false</code>.</li>\n<li>1: Width depends on content (shrink wraps), but height does not.</li>\n<li>2: Height depends on content (shrink wraps), but width does not. The default.</li>\n<li>3: Both width and height depend on content (shrink wrap). This is equivalent to <code>true</code>.</li>\n</ul>\n\n\n<p>In CSS terms, shrink-wrap width is analogous to an inline-block element as opposed\nto a block-level element. Some container layouts always shrink-wrap their children,\neffectively ignoring this property (e.g., <a href=\"#!/api/Ext.layout.container.HBox\" rel=\"Ext.layout.container.HBox\" class=\"docClass\">Ext.layout.container.HBox</a>,\n<a href=\"#!/api/Ext.layout.container.VBox\" rel=\"Ext.layout.container.VBox\" class=\"docClass\">Ext.layout.container.VBox</a>, <a href=\"#!/api/Ext.layout.component.Dock\" rel=\"Ext.layout.component.Dock\" class=\"docClass\">Ext.layout.component.Dock</a>).</p>\n"},"tabIndex":{"!type":"number","!doc":"<p>Set a DOM tabIndex for this button.</p>\n"},"text":{"!type":"string","!doc":"<p>The button text to be used as innerHTML (html tags are accepted).</p>\n"},"textAlign":{"!type":"string","!doc":"<p>The text alignment for this button (center, left, right).</p>\n"},"toggleGroup":{"!type":"string","!doc":"<p>The group this toggle button is a member of (only 1 per group can be pressed). If a toggleGroup\nis specified, the <a href=\"#!/api/Ext.button.Button-cfg-enableToggle\" rel=\"Ext.button.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> configuration will automatically be set to true.</p>\n"},"toggleHandler":{"!doc":"<p>Function called when a Button with <a href=\"#!/api/Ext.button.Button-cfg-enableToggle\" rel=\"Ext.button.Button-cfg-enableToggle\" class=\"docClass\">enableToggle</a> set to true is clicked.</p>\n"},"tooltip":{"!doc":"<p>The tooltip for the button - can be a string to be used as innerHTML (html tags are accepted) or\nQuickTips config object.</p>\n"},"tooltipType":{"!type":"string","!doc":"<p>The type of tooltip to use. Either 'qtip' for QuickTips or 'title' for title attribute.</p>\n"},"_triggerRegion":{"!doc":"<p>A reusable object used by getTriggerRegion to avoid excessive object creation.</p>\n"},"allowedScales":{"!doc":"<p>An array of allowed scales.</p>\n"},"isAction":{"!type":"bool","!doc":"<p><code>true</code> in this class to identify an object as an instantiated Button, or subclass thereof.</p>\n"},"template":{"!doc":"<p>A <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Template</a> used to create the Button's DOM structure.</p>\n\n<p>Instances, or subclasses which need a different DOM structure may provide a different template layout in\nconjunction with an implementation of <a href=\"#!/api/Ext.button.Button-method-getTemplateArgs\" rel=\"Ext.button.Button-method-getTemplateArgs\" class=\"docClass\">getTemplateArgs</a>.</p>\n"},"addOverCls":{"!type":"fn() -> !this","!doc":"<p></p>\n"},"beforeDestroy":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is destroyed.</p>\n"},"beforeRender":{"!type":"fn() -> !this"},"clearTip":{"!type":"fn() -> !this"},"didIconStateChange":{"!type":"fn(old: ?, current: ?) -> bool","!doc":"<p>Checks if the icon/iconCls changed from being empty to having a value, or having a value to being empty.</p>\n"},"disable":{"!type":"fn(silent: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"doToggle":{"!type":"fn() -> !this"},"enable":{"!type":"fn(silent: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"fireHandler":{"!type":"fn(e: ?) -> !this"},"getActionEl":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"},"getBtnWrapFrameWidth":{"!type":"fn(side: ?) -> !this"},"getComponentCls":{"!type":"fn() -> !this"},"getFocusEl":{"!type":"fn() -> ?","!doc":"<p>inherit docs</p>\n"},"getHref":{"!type":"fn() -> ?","!doc":"<p>If there is a configured href for this Button, returns the href with parameters appended.</p>\n"},"getInnerCls":{"!type":"fn() -> !this"},"getRefItems":{"!type":"fn(deep: ?) -> !this"},"getSplitCls":{"!type":"fn() -> !this"},"getTemplateArgs":{"!type":"fn() -> ?","!doc":"<p>This method returns an object which provides substitution parameters for the <a href=\"#!/api/Ext.button.Button-cfg-renderTpl\" rel=\"Ext.button.Button-cfg-renderTpl\" class=\"docClass\">XTemplate</a> used to\ncreate this Button's DOM structure.</p>\n\n<p>Instances or subclasses which use a different Template to create a different DOM structure may need to provide\ntheir own implementation of this method.</p>\n"},"getText":{"!type":"fn() -> string","!doc":"<p>Gets the text for this Button</p>\n"},"getTipAttr":{"!type":"fn() -> !this"},"getTriggerRegion":{"!type":"fn() -> ?","!doc":"<p>Returns an object containing <code>begin</code> and <code>end</code> properties that indicate the\nleft/right bounds of a right trigger or the top/bottom bounds of a bottom trigger.</p>\n"},"getTriggerSize":{"!type":"fn() -> !this","!doc":"<p>Measures the size of the trigger area for menu and split buttons. Will be a width for\na right-aligned trigger and a height for a bottom-aligned trigger. Cached after first measurement.</p>\n"},"hasVisibleMenu":{"!type":"fn() -> bool","!doc":"<p>Returns true if the button has a menu and it is visible</p>\n"},"hideMenu":{"!type":"fn() -> ?","!doc":"<p>Hides this button's menu (if it has one)</p>\n"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"},"maybeShowMenu":{"!type":"fn() -> !this"},"onClick":{"!type":"fn(e: ?) -> !this"},"onDestroy":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the destroy operation.\nAfter calling the superclass's onDestroy, the Component will be destroyed.</p>\n"},"onDisable":{"!type":"fn() -> !this","!doc":"<p>See comments in onFocus</p>\n"},"onDownKey":{"!type":"fn(k: ?, e: ?) -> !this"},"onMenuHide":{"!type":"fn(e: ?) -> !this"},"onMenuShow":{"!type":"fn(e: ?) -> !this"},"onMenuTriggerOut":{"!type":"fn(e: ?) -> !this","!doc":"<p>virtual mouseleave handler called when it is detected that the mouseout event\nsignified the mouse leaving the arrow area of the button - the <code>&lt;em&gt;</code>.</p>\n"},"onMenuTriggerOver":{"!type":"fn(e: ?) -> !this","!doc":"<p>virtual mouseenter handler called when it is detected that the mouseover event\nsignified the mouse entering the arrow area of the button - the <code>&lt;em&gt;</code>.</p>\n"},"onMouseDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Mousedown brings to front, and programatically grabs focus <em>unless the mousedown was on a focusable element</em></p>\n"},"onMouseEnter":{"!type":"fn(e: ?) -> !this","!doc":"<p>virtual mouseenter handler called when it is detected that the mouseout event\nsignified the mouse entering the encapsulating element.</p>\n"},"onMouseLeave":{"!type":"fn(e: ?) -> !this","!doc":"<p>virtual mouseleave handler called when it is detected that the mouseover event\nsignified the mouse entering the encapsulating element.</p>\n"},"onMouseMove":{"!type":"fn(e: ?) -> !this","!doc":"<p>mousemove handler called when the mouse moves anywhere within the encapsulating element.\nThe position is checked to determine if the mouse is entering or leaving the trigger area. Using\nmousemove to check this is more resource intensive than we'd like, but it is necessary because\nthe trigger area does not line up exactly with sub-elements so we don't always get mouseover/out\nevents when needed. In the future we should consider making the trigger a separate element that\nis absolutely positioned and sized over the trigger area.</p>\n"},"onMouseOut":{"!type":"fn(e: ?) -> !this","!doc":"<p>mouseout handler called when a mouseout event occurs anywhere within the encapsulating element -\nor the mouse leaves the encapsulating element.\nThe targets are interrogated to see what is being exited to where.</p>\n"},"onMouseOver":{"!type":"fn(e: ?) -> !this","!doc":"<p>mouseover handler called when a mouseover event occurs anywhere within the encapsulating element.\nThe targets are interrogated to see what is being entered from where.</p>\n"},"onMouseUp":{"!type":"fn(e: ?) -> !this"},"onRender":{"!type":"fn() -> !this","!doc":"<p>Template method called when this Component's DOM structure is created.</p>\n\n<p>At this point, this Component's (and all descendants') DOM structure <em>exists</em> but it has not\nbeen layed out (positioned and sized).</p>\n\n<p>Subclasses which override this to gain access to the structure at render time should\ncall the parent class's method before attempting to access any child elements of the Component.</p>\n"},"onRepeatClick":{"!type":"fn(repeat: ?, e: ?) -> !this"},"removeOverCls":{"!type":"fn() -> !this"},"restoreClick":{"!type":"fn() -> !this"},"setComponentCls":{"!type":"fn() -> !this"},"setGlyph":{"!type":"fn(glyph: ?) -> ?","!doc":"<p>Sets this button's glyph</p>\n"},"setHandler":{"!type":"fn(handler: ?, scope?: ?) -> ?","!doc":"<p>Assigns this Button's click handler</p>\n"},"setHref":{"!type":"fn(href: ?) -> !this","!doc":"<p>Sets the href of the embedded anchor element to the passed URL.</p>\n\n<p>Also appends any configured <a href=\"#!/api/Ext.button.Button-cfg-baseParams\" rel=\"Ext.button.Button-cfg-baseParams\" class=\"docClass\">baseParams</a> and parameters set through <a href=\"#!/api/Ext.button.Button-method-setParams\" rel=\"Ext.button.Button-method-setParams\" class=\"docClass\">setParams</a>.</p>\n"},"setIcon":{"!type":"fn(icon: ?) -> ?","!doc":"<p>Sets the background image (inline style) of the button. This method also changes the value of the <a href=\"#!/api/Ext.button.Button-cfg-icon\" rel=\"Ext.button.Button-cfg-icon\" class=\"docClass\">icon</a>\nconfig internally.</p>\n"},"setIconCls":{"!type":"fn(cls: ?) -> ?","!doc":"<p>Sets the CSS class that provides a background image to use as the button's icon. This method also changes the\nvalue of the <a href=\"#!/api/Ext.button.Button-cfg-iconCls\" rel=\"Ext.button.Button-cfg-iconCls\" class=\"docClass\">iconCls</a> config internally.</p>\n"},"setParams":{"!type":"fn(params: ?) -> !this","!doc":"<p>Sets the href of the link dynamically according to the params passed, and any <a href=\"#!/api/Ext.button.Button-cfg-baseParams\" rel=\"Ext.button.Button-cfg-baseParams\" class=\"docClass\">baseParams</a> configured.</p>\n\n<p><strong>Only valid if the Button was originally configured with a <a href=\"#!/api/Ext.button.Button-cfg-href\" rel=\"Ext.button.Button-cfg-href\" class=\"docClass\">href</a></strong></p>\n"},"setScale":{"!type":"fn(scale: ?) -> !this","!doc":"<p>Method to change the scale of the button. See <a href=\"#!/api/Ext.button.Button-cfg-scale\" rel=\"Ext.button.Button-cfg-scale\" class=\"docClass\">scale</a> for allowed configurations.</p>\n"},"setText":{"!type":"fn(text: ?) -> ?","!doc":"<p>Sets this Button's text</p>\n"},"setTextAlign":{"!type":"fn(align: ?) -> !this","!doc":"<p>Sets the text alignment for this button.</p>\n"},"setTooltip":{"!type":"fn(tooltip: ?) -> ?","!doc":"<p>Sets the tooltip for this Button.</p>\n"},"setUI":{"!type":"fn(ui: ?) -> !this","!doc":"<p>inherit docs</p>\n"},"showMenu":{"!type":"fn(fromEvent: ?) -> !this","!doc":"<p>Shows this button's menu (if it has one)</p>\n"},"toggle":{"!type":"fn(this: ?, pressed: ?, eOpts: ?)","!doc":"<p>Fires when the 'pressed' state of this button changes (only if enableToggle = true)</p>\n"},"click":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when this button is clicked, before the configured <a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a> is invoked. Execution of the\n<a href=\"#!/api/Ext.button.Button-cfg-handler\" rel=\"Ext.button.Button-cfg-handler\" class=\"docClass\">handler</a> may be vetoed by returning <code>false</code> to this event.</p>\n"},"glyphchange":{"!type":"fn(this: ?, newGlyph: ?, oldGlyph: ?, eOpts: ?)","!doc":"<p>Fired when the button's glyph is changed by the <a href=\"#!/api/Ext.button.Button-method-setGlyph\" rel=\"Ext.button.Button-method-setGlyph\" class=\"docClass\">setGlyph</a> method.</p>\n"},"iconchange":{"!type":"fn(this: ?, oldIcon: ?, newIcon: ?, eOpts: ?)","!doc":"<p>Fired when the button's icon is changed by the <a href=\"#!/api/Ext.button.Button-method-setIcon\" rel=\"Ext.button.Button-method-setIcon\" class=\"docClass\">setIcon</a> or <a href=\"#!/api/Ext.button.Button-method-setIconCls\" rel=\"Ext.button.Button-method-setIconCls\" class=\"docClass\">setIconCls</a> methods.</p>\n"},"menuhide":{"!type":"fn(this: ?, menu: ?, eOpts: ?)","!doc":"<p>If this button has a menu, this event fires when it is hidden</p>\n"},"menushow":{"!type":"fn(this: ?, menu: ?, eOpts: ?)","!doc":"<p>If this button has a menu, this event fires when it is shown</p>\n"},"menutriggerout":{"!type":"fn(this: ?, menu: ?, e: ?, eOpts: ?)","!doc":"<p>If this button has a menu, this event fires when the mouse leaves the menu triggering element</p>\n"},"menutriggerover":{"!type":"fn(this: ?, menu: ?, e: ?, eOpts: ?)","!doc":"<p>If this button has a menu, this event fires when the mouse enters the menu triggering element</p>\n"},"mouseout":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse exits the button</p>\n"},"mouseover":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when the mouse hovers over the button</p>\n"},"textchange":{"!type":"fn(this: ?, oldText: ?, newText: ?, eOpts: ?)","!doc":"<p>Fired when the button's text is changed by the <a href=\"#!/api/Ext.button.Button-method-setText\" rel=\"Ext.button.Button-method-setText\" class=\"docClass\">setText</a> method.</p>\n"}}},"Cycle":{"!doc":"<p>A specialized SplitButton that contains a menu of <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">Ext.menu.CheckItem</a> elements. The button automatically\ncycles through each menu item on click, raising the button's <a href=\"#!/api/Ext.button.Cycle-event-change\" rel=\"Ext.button.Cycle-event-change\" class=\"docClass\">change</a> event (or calling the button's\n<a href=\"#!/api/Ext.button.Cycle-cfg-changeHandler\" rel=\"Ext.button.Cycle-cfg-changeHandler\" class=\"docClass\">changeHandler</a> function, if supplied) for the active menu item. Clicking on the arrow section of the\nbutton displays the dropdown menu just like a normal SplitButton.  Example usage:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.button.Cycle\" rel=\"Ext.button.Cycle\" class=\"docClass\">Ext.button.Cycle</a>', {\n    showText: true,\n    prependText: 'View as ',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    menu: {\n        id: 'view-type-menu',\n        items: [{\n            text: 'text only',\n            iconCls: 'view-text',\n            checked: true\n        },{\n            text: 'HTML',\n            iconCls: 'view-html'\n        }]\n    },\n    changeHandler: function(cycleBtn, activeItem) {\n        <a href=\"#!/api/Ext.MessageBox-method-alert\" rel=\"Ext.MessageBox-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Change View', activeItem.text);\n    }\n});\n</code></pre>\n","!type":"fn(config: ?)","prototype":{"changeHandler":{"!doc":"<p>A callback function that will be invoked each time the active menu item in the button's menu has changed. If this\ncallback is not supplied, the SplitButton will instead fire the <a href=\"#!/api/Ext.button.Cycle-event-change\" rel=\"Ext.button.Cycle-event-change\" class=\"docClass\">change</a> event on active item change. The\nchangeHandler function will be called with the following argument list: (SplitButton this, <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">Ext.menu.CheckItem</a>\nitem)</p>\n"},"forceGlyph":{"!doc":"<p>The charCode to be used as the static icon for this button.  This icon will always be\ndisplayed regardless of which item is selected in the dropdown list. This override\nthe default behavior of changing the button's icon to match the selected item's icon\non change. This property expects a format consistent with that of <a href=\"#!/api/Ext.button.Cycle-cfg-glyph\" rel=\"Ext.button.Cycle-cfg-glyph\" class=\"docClass\">glyph</a></p>\n"},"forceIcon":{"!type":"string","!doc":"<p>A css class which sets an image to be used as the static icon for this button. This icon will always be displayed\nregardless of which item is selected in the dropdown list. This overrides the default behavior of changing the\nbutton's icon to match the selected item's icon on change.</p>\n"},"items":{"!doc":"<p>An array of <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">Ext.menu.CheckItem</a> <strong>config</strong> objects to be used when creating the button's menu items (e.g.,\n<code>{text:'Foo', iconCls:'foo-icon'}</code>)</p>\n"},"prependText":{"!type":"string","!doc":"<p>A static string to prepend before the active item's text when displayed as the button's text (only applies when\nshowText = true).</p>\n"},"showText":{"!type":"bool","!doc":"<p>True to display the active item's text as the button text. The Button will show its\nconfigured <a href=\"#!/api/Ext.button.Cycle-cfg-text\" rel=\"Ext.button.Cycle-cfg-text\" class=\"docClass\">text</a> if this config is omitted.</p>\n"},"menu":{"!doc":"<p>The <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a> object used to display the <a href=\"#!/api/Ext.menu.CheckItem\" rel=\"Ext.menu.CheckItem\" class=\"docClass\">CheckItems</a> representing the\navailable choices.</p>\n"},"checkHandler":{"!type":"fn(item: ?, pressed: ?) -> !this"},"getActiveItem":{"!type":"fn() -> ?","!doc":"<p>Gets the currently active menu item.</p>\n"},"getButtonText":{"!type":"fn(item: ?) -> !this"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"},"setActiveItem":{"!type":"fn(item: ?, suppressEvent?: ?) -> !this","!doc":"<p>Sets the button's active menu item.</p>\n"},"toggleSelected":{"!type":"fn() -> !this","!doc":"<p>This is normally called internally on button click, but can be called externally to advance the button's active\nitem programmatically to the next one in the menu. If the current item is the last one in the menu the active\nitem will be set to the first item in the menu.</p>\n"},"change":{"!type":"fn(this: ?, item: ?, eOpts: ?)","!doc":"<p>Fires after the button's active menu item has changed. Note that if a <a href=\"#!/api/Ext.button.Cycle-cfg-changeHandler\" rel=\"Ext.button.Cycle-cfg-changeHandler\" class=\"docClass\">changeHandler</a> function is\nset on this CycleButton, it will be called instead on active item change and this change event will not\nbe fired.</p>\n"}}},"Split":{"prototype":{"arrowCls":{"!type":"string","!doc":"<p>The className used for the inner arrow element if the button has a menu.</p>\n"},"arrowHandler":{"!doc":"<p>A function called when the arrow button is clicked (can be used instead of click event)</p>\n"},"arrowTooltip":{"!type":"string","!doc":"<p>The title attribute of the arrow.</p>\n"},"split":{"!type":"bool"},"onClick":{"!type":"fn(e: ?, t: ?) -> !this"},"setArrowHandler":{"!type":"fn(handler: ?, scope?: ?) -> !this","!doc":"<p>Sets this button's arrow click handler.</p>\n"},"arrowclick":{"!type":"fn(this: ?, e: ?, eOpts: ?)","!doc":"<p>Fires when this button's arrow is clicked.</p>\n"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>inherit docs</p>\n"}},"!doc":"<p>A split button that provides a built-in dropdown arrow that can fire an event separately from the default click event\nof the button. Typically this would be used to display a dropdown menu that provides additional options to the\nprimary button action, but any custom handler can provide the arrowclick implementation.  Example usage:</p>\n\n<pre class='inline-example '><code>// display a dropdown menu:\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.button.Split\" rel=\"Ext.button.Split\" class=\"docClass\">Ext.button.Split</a>', {\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    text: 'Options',\n    // handle a click on the button itself\n    handler: function() {\n        alert(\"The button was clicked\");\n    },\n    menu: new <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a>({\n        items: [\n            // these will render as dropdown menu items when the arrow is clicked:\n            {text: 'Item 1', handler: function(){ alert(\"Item 1 clicked\"); }},\n            {text: 'Item 2', handler: function(){ alert(\"Item 2 clicked\"); }}\n        ]\n    })\n});\n</code></pre>\n\n<p>Instead of showing a menu, you can provide any type of custom functionality you want when the dropdown\narrow is clicked:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.button.Split\" rel=\"Ext.button.Split\" class=\"docClass\">Ext.button.Split</a>', {\n    renderTo: 'button-ct',\n    text: 'Options',\n    handler: optionsHandler,\n    arrowHandler: myCustomHandler\n});\n</code></pre>\n","!type":"fn(config: ?)"},"Manager":{"buttonSelector":{"!type":"string"},"groups":{},"pressedButton":{},"getPressed":{"!type":"fn(group: ?) -> ?","!doc":"<p>Gets the pressed button in the passed group or null</p>\n"},"init":{"!type":"fn() -> !this"},"onButtonMousedown":{"!type":"fn(button: ?, e: ?) -> !this","!doc":"<p>Called by buton instances.\nTrack the button which was mousedowned upon so that the next <em>document</em> mouseup can be delivered to it\nin case mouse is moved outside of button element.</p>\n"},"onDocumentKeyDown":{"!type":"fn(e: ?) -> !this","!doc":"<p>Buttons must react to SPACE and ENTER to trigger the click handler.\nNow that they are <code>&lt;a&gt;</code> elements, we use a keydown listener.</p>\n"},"onDocumentMouseUp":{"!type":"fn(e: ?) -> !this"},"register":{"!type":"fn(btn: ?) -> !this"},"toggleGroup":{"!type":"fn(btn: ?, state: ?) -> !this"},"unregister":{"!type":"fn(btn: ?) -> !this"}}},"Component":{"prototype":{"autoScroll":{"!type":"bool","!doc":"<p><code>true</code> to use overflow:'auto' on the components layout element and show scroll bars automatically when necessary,\n<code>false</code> to clip any overflowing content.\nThis should not be combined with <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> or  <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a>.</p>\n"},"columnWidth":{"!doc":"<p>Defines the column width inside <a href=\"#!/api/Ext.layout.container.Column\" rel=\"Ext.layout.container.Column\" class=\"docClass\">column layout</a>.</p>\n\n<p>Can be specified as a number or as a percentage.</p>\n"},"constrainTo":{"!doc":"<p>A <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Region</a> (or an element from which a Region measurement will be read) which is used\nto constrain the component. Only applies when the component is floating.</p>\n"},"constraintInsets":{"!doc":"<p>An object or a string (in TRBL order) specifying insets from the configured <a href=\"#!/api/Ext.Component-cfg-constrainTo\" rel=\"Ext.Component-cfg-constrainTo\" class=\"docClass\">constrain region</a>\nwithin which this component must be constrained when positioning or sizing.\nexample:</p>\n\n<p>   constraintInsets: '10 10 10 10' // Constrain with 10px insets from parent</p>\n"},"defaultAlign":{"!type":"string","!doc":"<p>The default <a href=\"#!/api/Ext.util.Positionable-method-getAlignToXY\" rel=\"Ext.util.Positionable-method-getAlignToXY\" class=\"docClass\">Ext.Element#getAlignToXY</a> anchor position value for this menu\nrelative to its element of origin. Used in conjunction with <a href=\"#!/api/Ext.Component-method-showBy\" rel=\"Ext.Component-method-showBy\" class=\"docClass\">showBy</a>.</p>\n"},"draggable":{"!doc":"<p>Specify as true to make a <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Component draggable using the Component's encapsulating element as\nthe drag handle.</p>\n\n<p>This may also be specified as a config object for the <a href=\"#!/api/Ext.util.ComponentDragger\" rel=\"Ext.util.ComponentDragger\" class=\"docClass\">ComponentDragger</a> which is\ninstantiated to perform dragging.</p>\n\n<p>For example to create a Component which may only be dragged around using a certain internal element as the drag\nhandle, use the delegate option:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>({\n    constrain: true,\n    floating: true,\n    style: {\n        backgroundColor: '#fff',\n        border: '1px solid black'\n    },\n    html: '&lt;h1 style=\"cursor:move\"&gt;The title&lt;/h1&gt;&lt;p&gt;The content&lt;/p&gt;',\n    draggable: {\n        delegate: 'h1'\n    }\n}).show();\n</code></pre>\n"},"floating":{"!type":"bool","!doc":"<p>Specify as true to float the Component outside of the document flow using CSS absolute positioning.</p>\n\n<p>Components such as <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s and <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a>s are floating by default.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will register\nthemselves with the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<h3>Floating Components as child items of a Container</h3>\n\n<p>A floating Component may be used as a child item of a Container. This just allows the floating Component to seek\na ZIndexManager by examining the ownerCt chain.</p>\n\n<p>When configured as floating, Components acquire, at render time, a <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which\nmanages a stack of related floating Components. The ZIndexManager brings a single floating Component to the top\nof its stack when the Component's <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> method is called.</p>\n\n<p>The ZIndexManager is found by traversing up the <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a> chain to find an ancestor which itself is\nfloating. This is so that descendant floating Components of floating <em>Containers</em> (Such as a ComboBox dropdown\nwithin a Window) can have its zIndex managed relative to any siblings, but always <strong>above</strong> that floating\nancestor Container.</p>\n\n<p>If no floating ancestor is found, a floating Component registers itself with the default <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a>.</p>\n\n<p>Floating components <em>do not participate in the Container's layout</em>. Because of this, they are not rendered until\nyou explicitly <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> them.</p>\n\n<p>After rendering, the ownerCt reference is deleted, and the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property is set to the found\nfloating ancestor Container. If no floating ancestor Container was found the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property will\nnot be set.</p>\n"},"formBind":{"!type":"bool","!doc":"<p>When inside FormPanel, any component configured with <code>formBind: true</code> will\nbe enabled/disabled depending on the validity state of the form.\nSee <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a> for more information and example.</p>\n"},"overflowX":{"!type":"string","!doc":"<p>Possible values are:\n * <code>'auto'</code> to enable automatic horizontal scrollbar (overflow-x: 'auto').\n * <code>'scroll'</code> to always enable horizontal scrollbar (overflow-x: 'scroll').\nThe default is overflow-x: 'hidden'. This should not be combined with <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>.</p>\n"},"overflowY":{"!type":"string","!doc":"<p>Possible values are:\n * <code>'auto'</code> to enable automatic vertical scrollbar (overflow-y: 'auto').\n * <code>'scroll'</code> to always enable vertical scrollbar (overflow-y: 'scroll').\nThe default is overflow-y: 'hidden'. This should not be combined with <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>.</p>\n"},"region":{"!doc":"<p>Defines the region inside <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</p>\n\n<p>Possible values:</p>\n\n<ul>\n<li>north - Positions component at top.</li>\n<li>south - Positions component at bottom.</li>\n<li>east - Positions component at right.</li>\n<li>west - Positions component at left.</li>\n<li>center - Positions component at the remaining space.\nThere <strong>must</strong> be a component with <code>region: \"center\"</code> in every border layout.</li>\n</ul>\n\n"},"resizable":{"!doc":"<p>Specify as <code>true</code> to apply a <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Resizer</a> to this Component after rendering.</p>\n\n<p>May also be specified as a config object to be passed to the constructor of <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Resizer</a>\nto override any defaults. By default the Component passes its minimum and maximum size, and uses\n<code><a href=\"#!/api/Ext.resizer.Resizer-cfg-dynamic\" rel=\"Ext.resizer.Resizer-cfg-dynamic\" class=\"docClass\">Ext.resizer.Resizer.dynamic</a>: false</code></p>\n"},"resizeHandles":{"!type":"string","!doc":"<p>A valid <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Ext.resizer.Resizer</a> handles config string. Only applies when resizable = true.</p>\n"},"toFrontOnShow":{"!type":"bool","!doc":"<p>True to automatically call <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> when the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method is called on an already visible,\nfloating component.</p>\n"},"bubbleEvents":{},"defaultComponentLayoutType":{"!type":"string"},"floatParent":{"!doc":"<p><strong>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which were inserted as child items of Containers.</strong></p>\n\n<p>There are other similar relationships such as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will not have a <code>floatParent</code>\nproperty.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">zIndexManager</a></p>\n"},"offsetsCls":{"!type":"string"},"scrollFlags":{"!doc":"<p>An object property which provides unified information as to which dimensions are scrollable based upon\nthe <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>, <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> and <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a> settings (And for <em>views</em> of trees and grids, the owning panel's <a href=\"#!/api/Ext.panel.Table-cfg-scroll\" rel=\"Ext.panel.Table-cfg-scroll\" class=\"docClass\">scroll</a> setting).</p>\n\n<p>Note that if you set overflow styles using the <a href=\"#!/api/Ext.Component-cfg-style\" rel=\"Ext.Component-cfg-style\" class=\"docClass\">style</a> config or <a href=\"#!/api/Ext.panel.Panel-cfg-bodyStyle\" rel=\"Ext.panel.Panel-cfg-bodyStyle\" class=\"docClass\">bodyStyle</a> config, this object does not include that information;\nit is best to use <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>, <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> and <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a> if you need to access these flags.</p>\n\n<p>This object has the following properties:</p>\n"},"zIndexManager":{"!doc":"<p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components after they have been rendered.</p>\n\n<p>A reference to the ZIndexManager which is managing this Component's z-index.</p>\n\n<p>The <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> maintains a stack of floating Component z-indices, and also provides\na single modal mask which is insert just beneath the topmost visible modal floating Component.</p>\n\n<p>Floating Components may be <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">brought to the front</a> or <a href=\"#!/api/Ext.Component-method-toBack\" rel=\"Ext.Component-method-toBack\" class=\"docClass\">sent to the back</a> of the\nz-index stack.</p>\n\n<p>This defaults to the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> for floating Components that are\nprogramatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a>.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are added to a Container, the ZIndexManager is acquired from the first\nancestor Container found which is floating. If no floating ancestor is found, the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> is\nused.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexParent\" rel=\"Ext.Component-property-zIndexParent\" class=\"docClass\">zIndexParent</a></p>\n"},"zIndexParent":{"!doc":"<p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which were inserted as child items of Containers, and which have a floating\nContainer in their containment ancestry.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are child items of a Container, the zIndexParent will be a floating\nancestor Container which is responsible for the base z-index value of all its floating descendants. It provides\na <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which provides z-indexing services for all its descendant floating\nComponents.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will not have a <code>zIndexParent</code>\nproperty.</p>\n\n<p>For example, the dropdown <a href=\"#!/api/Ext.view.BoundList\" rel=\"Ext.view.BoundList\" class=\"docClass\">BoundList</a> of a ComboBox which is in a Window will have the\nWindow as its <code>zIndexParent</code>, and will always show above that Window, wherever the Window is placed in the z-index stack.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">zIndexManager</a></p>\n"},"adjustPosition":{"!type":"fn(x: ?, y: ?) -> !this"},"afterComponentLayout":{"!type":"fn() -> !this","!doc":"<p>Called by the layout system after the Component has been laid out.</p>\n"},"afterHide":{"!type":"fn(callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the Component has been hidden.</p>\n\n<p>Gets passed the same <code>callback</code> and <code>scope</code> parameters that <a href=\"#!/api/Ext.Component-method-onHide\" rel=\"Ext.Component-method-onHide\" class=\"docClass\">onHide</a> received.</p>\n"},"afterRender":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior after rendering is complete. At this stage the Component’s Element\nwill have been styled according to the configuration, will have had any configured CSS class\nnames added, and will be in the configured visibility and the configured enable state.</p>\n"},"afterSetPosition":{"!type":"fn(ax: ?, ay: ?) -> !this","!doc":"<p>Template method called after a Component has been positioned.</p>\n"},"afterShow":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the Component is shown (after <a href=\"#!/api/Ext.Component-method-onShow\" rel=\"Ext.Component-method-onShow\" class=\"docClass\">onShow</a> is called).</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a>.</p>\n"},"beforeLayout":{"!type":"fn() -> !this","!doc":"<p>Occurs before componentLayout is run. In previous releases, this method could\nreturn <code>false</code> to prevent its layout but that is not supported in Ext JS 4.1 or\nhigher. This method is simply a notification of the impending layout to give the\ncomponent a chance to adjust the DOM. Ideally, DOM reads should be avoided at this\ntime to reduce expensive document reflows.</p>\n"},"beforeSetPosition":{"!type":"fn() -> !this","!doc":"<p>Template method called before a Component is positioned.</p>\n\n<p>Ensures that the position is adjusted so that the Component is constrained if so configured.</p>\n"},"beforeShow":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is shown.</p>\n"},"blur":{"!type":"fn() -> ?"},"bubble":{"!type":"fn(fn: ?, scope?: ?, args?: ?) -> ?","!doc":"<p>Bubbles up the component/container heirarchy, calling the specified function with each component. The scope\n(<em>this</em>) of function call will be the scope provided or the current component. The arguments to the function will\nbe the args provided or the current component. If the function returns false at any point, the bubble is stopped.</p>\n"},"cancelFocus":{"!type":"fn() -> !this","!doc":"<p>Cancel any deferred focus on this component</p>\n"},"cloneConfig":{"!type":"fn(overrides: ?) -> ?","!doc":"<p>Clone the current component using the original config values passed into this instance by default.</p>\n"},"deleteMembers":{"!type":"fn() -> !this"},"findParentBy":{"!type":"fn(fn: ?) -> ?","!doc":"<p>Find a container above this component at any level by a custom function. If the passed function returns true, the\ncontainer will be returned.</p>\n\n<p>See also the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n"},"findParentByType":{"!type":"fn(xtype: ?) -> ?","!doc":"<p>Find a container above this component at any level by xtype or class</p>\n\n<p>See also the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n"},"fireHierarchyEvent":{"!type":"fn(ename: ?) -> !this","!doc":"<p>For more information on the hierarchy events, see the note for the\nhierarchyEventSource observer defined in the onClassCreated callback.</p>\n\n<p>This functionality is contained in Component (as opposed to Container)\nbecause a Component can be the ownerCt for a floating component (loadmask),\nand the loadmask needs to know when its owner is shown/hidden via the\nhierarchyEventSource so that its hidden state can be synchronized.</p>\n\n<p>TODO: merge this functionality with <a href=\"#!/api/Ext-property-globalEvents\" rel=\"Ext-property-globalEvents\" class=\"docClass\">Ext.globalEvents</a></p>\n"},"focus":{"!type":"fn(selectText?: ?, delay?: ?, callback?: ?, scope?: ?) -> ?","!doc":"<p>Try to focus this component.</p>\n"},"getAnimateTarget":{"!type":"fn(target: ?) -> !this"},"getBubbleTarget":{"!type":"fn() -> !this","!doc":"<p>Implements an upward event bubbling policy. By default a Component bubbles events up to its <a href=\"#!/api/Ext.Component-method-getRefOwner\" rel=\"Ext.Component-method-getRefOwner\" class=\"docClass\">reference owner</a>.</p>\n\n<p>Component subclasses may implement a different bubbling strategy by overriding this method.</p>\n"},"getContentTarget":{"!type":"fn() -> !this"},"getDragEl":{"!type":"fn() -> !this"},"getEl":{"!type":"fn() -> ?","!doc":"<p>Retrieves the top level element representing this component.</p>\n"},"getId":{"!type":"fn() -> string","!doc":"<p>Retrieves the <code>id</code> of this component. Will auto-generate an <code>id</code> if one has not already been set.</p>\n"},"getOuterSize":{"!type":"fn() -> !this","!doc":"<p>Include margins</p>\n"},"getOwningBorderContainer":{"!type":"fn() -> ?","!doc":"<p>Returns the owning container if that container uses <code>border</code> layout. Otherwise\nthis method returns <code>null</code>.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"getOwningBorderLayout":{"!type":"fn() -> ?","!doc":"<p>Returns the owning <code>border</code> (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>) instance if there is\none. Otherwise this method returns <code>null</code>.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"getPosition":{"!type":"fn(local?: ?) -> ?","!doc":"<p>Gets the current XY position of the component's underlying element.</p>\n"},"getPositionEl":{"!type":"fn() -> !this","!doc":"<p>Deprecate 5.0</p>\n"},"getProxy":{"!type":"fn() -> !this"},"getRefOwner":{"!type":"fn() -> !this","!doc":"<p>Used by <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a>, and the <a href=\"#!/api/Ext.AbstractComponent-method-up\" rel=\"Ext.AbstractComponent-method-up\" class=\"docClass\">up</a> method to find the\nowning Component in the linkage hierarchy.</p>\n\n<p>By default this returns the Container which contains this Component.</p>\n\n<p>This may be overriden by Component authors who implement ownership hierarchies which are not\nbased upon ownerCt, such as BoundLists being owned by Fields or Menus being owned by Buttons.</p>\n"},"getResizeEl":{"!type":"fn() -> !this","!doc":"<p>Deprecate 5.0</p>\n"},"getVisibilityEl":{"!type":"fn() -> !this","!doc":"<p>Deprecate 5.0</p>\n"},"getXType":{"!type":"fn() -> string","!doc":"<p>Gets the xtype for this component as registered with <a href=\"#!/api/Ext.ComponentManager\" rel=\"Ext.ComponentManager\" class=\"docClass\">Ext.ComponentManager</a>. For a list of all available\nxtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header. Example usage:</p>\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nalert(t.getXType());  // alerts 'textfield'\n</code></pre>\n"},"hide":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> ?","!doc":"<p>Hides this Component, setting it to invisible using the configured <a href=\"#!/api/Ext.Component-cfg-hideMode\" rel=\"Ext.Component-cfg-hideMode\" class=\"docClass\">hideMode</a>.</p>\n"},"initBorderRegion":{"!type":"fn() -> !this","!doc":"<p>This method is called by the <code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code> class when instances are\nadded as regions to the layout. Since it is valid to add any component to a border\nlayout as a region, this method must be added to <code><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></code> but is only ever\ncalled when that component is owned by a <code>border</code> layout.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"initDraggable":{"!type":"fn() -> !this"},"initResizable":{"!type":"fn(resizable: ?) -> !this"},"isContainedFloater":{"!type":"fn() -> !this","!doc":"<p>Utility method to determine if a Component is floating, and has an owning Container whose coordinate system\nit must be positioned in when using setPosition.</p>\n"},"makeFloating":{"!type":"fn(dom: ?) -> !this"},"onAdded":{"!type":"fn() -> !this","!doc":"<p>Method to manage awareness of when components are added to their\nrespective Container, firing an <a href=\"#!/api/Ext.Component-event-added\" rel=\"Ext.Component-event-added\" class=\"docClass\">added</a> event. References are\nestablished at add time rather than at render time.</p>\n\n<p>Allows addition of behavior when a Component is added to a\nContainer. At this stage, the Component is in the parent\nContainer's collection of child items. After calling the\nsuperclass's <code>onAdded</code>, the <code>ownerCt</code> reference will be present,\nand if configured with a ref, the <code>refOwner</code> will be set.</p>\n"},"onHide":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Possibly animates down to a target element.</p>\n\n<p>Allows addition of behavior to the hide operation. After\ncalling the superclass’s onHide, the Component will be hidden.</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.Component-event-hide\" rel=\"Ext.Component-event-hide\" class=\"docClass\">hide</a>.</p>\n"},"onShow":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Allows addition of behavior to the show operation. After\ncalling the superclass's onShow, the Component will be visible.</p>\n\n<p>Override in subclasses where more complex behaviour is needed.</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a>.</p>\n"},"onShowComplete":{"!type":"fn(callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the <a href=\"#!/api/Ext.Component-method-afterShow\" rel=\"Ext.Component-method-afterShow\" class=\"docClass\">afterShow</a> method is complete.</p>\n\n<p>Gets passed the same <code>callback</code> and <code>scope</code> parameters that <a href=\"#!/api/Ext.Component-method-afterShow\" rel=\"Ext.Component-method-afterShow\" class=\"docClass\">afterShow</a> received.</p>\n"},"onShowVeto":{"!type":"fn() -> !this"},"scrollBy":{"!type":"fn(deltaX: ?, deltaY: ?, animate: ?) -> !this","!doc":"<p>Scrolls this Component's <a href=\"#!/api/Ext.Component-method-getTargetEl\" rel=\"Ext.Component-method-getTargetEl\" class=\"docClass\">target element</a> by the passed delta values, optionally animating.</p>\n\n<p>All of the following are equivalent:</p>\n\n<pre><code> comp.scrollBy(10, 10, true);\n comp.scrollBy([10, 10], true);\n comp.scrollBy({ x: 10, y: 10 }, true);\n</code></pre>\n"},"setAutoScroll":{"!type":"fn(scroll: ?) -> ?","!doc":"<p>Sets the overflow on the content element of the component.</p>\n"},"setBorderRegion":{"!type":"fn(region: ?) -> string","!doc":"<p>This method changes the <code>region</code> config property for this border region. This is\nonly valid if this component is in a <code>border</code> layout (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>).</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"setLoading":{"!type":"fn(load: ?, targetEl?: ?) -> ?","!doc":"<p>This method allows you to show or hide a LoadMask on top of this component.</p>\n"},"setOverflowXY":{"!type":"fn(overflowX: ?, overflowY: ?) -> ?","!doc":"<p>Sets the overflow x/y on the content element of the component. The x/y overflow\nvalues can be any valid CSS overflow (e.g., 'auto' or 'scroll'). By default, the\nvalue is 'hidden'. Passing null for one of the values will erase the inline style.\nPassing <code>undefined</code> will preserve the current value.</p>\n"},"setPagePosition":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Sets the page XY position of the component. To set the left and top instead, use <a href=\"#!/api/Ext.Component-method-setPosition\" rel=\"Ext.Component-method-setPosition\" class=\"docClass\">setPosition</a>.\nThis method fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n"},"setPosition":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Sets the left and top of the component. To set the page XY position instead, use <a href=\"#!/api/Ext.Component-method-setPagePosition\" rel=\"Ext.Component-method-setPagePosition\" class=\"docClass\">setPagePosition</a>. This\nmethod fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n"},"setRegionWeight":{"!type":"fn(weight: ?) -> number","!doc":"<p>Sets the <code>weight</code> config property for this component. This is only valid if this\ncomponent is in a <code>border</code> layout (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>).</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"show":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> ?","!doc":"<p>Shows this Component, rendering it first if <a href=\"#!/api/Ext.Component-cfg-autoRender\" rel=\"Ext.Component-cfg-autoRender\" class=\"docClass\">autoRender</a> or <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> are <code>true</code>.</p>\n\n<p>After being shown, a <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Component (such as a <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Ext.window.Window</a>), is activated it and\nbrought to the front of its <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">z-index stack</a>.</p>\n"},"showAt":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Displays component at specific xy position.\nA floating component (like a menu) is positioned relative to its ownerCt if any.\nUseful for popping up a context menu:</p>\n\n<pre><code>listeners: {\n    itemcontextmenu: function(view, record, item, index, event, options) {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a>', {\n            width: 100,\n            height: 100,\n            margin: '0 0 10 0',\n            items: [{\n                text: 'regular item 1'\n            },{\n                text: 'regular item 2'\n            },{\n                text: 'regular item 3'\n            }]\n        }).showAt(event.getXY());\n    }\n}\n</code></pre>\n"},"showBy":{"!type":"fn(component: ?, position?: ?, offsets?: ?) -> ?","!doc":"<p>Shows this component by the specified <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> or <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Element</a>.\nUsed when this component is <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a>.</p>\n"},"updateBox":{"!type":"fn(box: ?) -> ?","!doc":"<p>Sets the current box measurements of the component's underlying element.</p>\n"},"wrapPrimaryEl":{"!type":"fn(dom: ?) -> !this"},"beforeRender":{"!type":"fn() -> !this"},"getActionEl":{"!type":"fn() -> !this","!doc":"<p>Deprecate 5.0</p>\n"},"onDestroy":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the destroy operation.\nAfter calling the superclass's onDestroy, the Component will be destroyed.</p>\n"},"initComponent":{"!type":"fn() -> !this","!doc":"<p>The initComponent template method is an important initialization step for a Component. It is intended to be\nimplemented by each subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> to provide any needed constructor logic. The\ninitComponent method of the class being created is called first, with each initComponent method\nup the hierarchy to <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> being called thereafter. This makes it easy to implement and,\nif needed, override the constructor logic of the Component at any step in the hierarchy.</p>\n\n<p>The initComponent method <strong>must</strong> contain a call to <a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a> in order\nto ensure that the parent class' initComponent method is also called.</p>\n\n<p>All config options passed to the constructor are applied to <code>this</code> before initComponent is called,\nso you can simply access them with <code>this.someOption</code>.</p>\n\n<p>The following example demonstrates using a dynamic string for the text of a button at the time of\ninstantiation of the class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('DynamicButtonText', {\n    extend: '<a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">Ext.button.Button</a>',\n\n    initComponent: function() {\n        this.text = new Date();\n        this.renderTo = <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>();\n        this.callParent();\n    }\n});\n\n<a href=\"#!/api/Ext-method-onReady\" rel=\"Ext-method-onReady\" class=\"docClass\">Ext.onReady</a>(function() {\n    <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('DynamicButtonText');\n});\n</code></pre>\n"},"DIRECTION_BOTTOM":{"!type":"string"},"DIRECTION_LEFT":{"!type":"string"},"DIRECTION_RIGHT":{"!type":"string"},"DIRECTION_TOP":{"!type":"string","!doc":"<p>Collapse/expand directions</p>\n"},"INVALID_ID_CHARS_Re":{"!doc":"<p>RegExp whih specifies characters in an xtype which must be translated to '-' when generating auto IDs.\nThis includes dot, comma and whitespace</p>\n"},"VERTICAL_DIRECTION_Re":{}},"!doc":"<p>Base class for all Ext components.</p>\n\n<p>The Component base class has built-in support for basic hide/show and enable/disable and size control behavior.</p>\n\n<h2>xtypes</h2>\n\n<p>Every component has a specific xtype, which is its Ext-specific type name, along with methods for checking the xtype\nlike <a href=\"#!/api/Ext.Component-method-getXType\" rel=\"Ext.Component-method-getXType\" class=\"docClass\">getXType</a> and <a href=\"#!/api/Ext.Component-method-isXType\" rel=\"Ext.Component-method-isXType\" class=\"docClass\">isXType</a>. See the <a href=\"#!/guide/components\">Component Guide</a> for more information on xtypes and the\nComponent hierarchy.</p>\n\n<h2>Finding components</h2>\n\n<p>All Components are registered with the <a href=\"#!/api/Ext.ComponentManager\" rel=\"Ext.ComponentManager\" class=\"docClass\">Ext.ComponentManager</a> on construction so that they can be referenced at\nany time via <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>, passing the <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>.</p>\n\n<p>Additionally the <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> provides a CSS-selectors-like way to look up components by their xtype\nand many other attributes.  For example the following code will find all textfield components inside component with\n<code>id: 'myform'</code>:</p>\n\n<pre><code><a href=\"#!/api/Ext.ComponentQuery-method-query\" rel=\"Ext.ComponentQuery-method-query\" class=\"docClass\">Ext.ComponentQuery.query</a>('#myform textfield');\n</code></pre>\n\n<h2>Extending <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></h2>\n\n<p>All subclasses of Component may participate in the automated Ext component\nlifecycle of creation, rendering and destruction which is provided by the <a href=\"#!/api/Ext.container.Container\" rel=\"Ext.container.Container\" class=\"docClass\">Container</a>\nclass. Components may be added to a Container through the <a href=\"#!/api/Ext.container.Container-cfg-items\" rel=\"Ext.container.Container-cfg-items\" class=\"docClass\">items</a> config option\nat the time the Container is created, or they may be added dynamically via the\n<a href=\"#!/api/Ext.container.Container-method-add\" rel=\"Ext.container.Container-method-add\" class=\"docClass\">add</a> method.</p>\n\n<p>All user-developed visual widgets that are required to participate in automated lifecycle and size management should\nsubclass Component.</p>\n\n<p>See the Creating new UI controls chapter in <a href=\"#!/guide/components\">Component Guide</a> for details on how and to either extend\nor augment Ext JS base classes to create custom Components.</p>\n\n<h2>The <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> class by itself</h2>\n\n<p>Usually one doesn't need to instantiate the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> class. There are subclasses which implement\nspecialized use cases, covering most application needs. However it is possible to instantiate a base\nComponent, and it can be rendered to document, or handled by layouts as the child item of a Container:</p>\n\n<pre class='inline-example '><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>', {\n    html: 'Hello world!',\n    width: 300,\n    height: 200,\n    padding: 20,\n    style: {\n        color: '#FFFFFF',\n        backgroundColor:'#000000'\n    },\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>()\n});\n</code></pre>\n\n<p>The Component above creates its encapsulating <code>div</code> upon render, and use the configured HTML as content. More complex\ninternal structure may be created using the <a href=\"#!/api/Ext.Component-cfg-renderTpl\" rel=\"Ext.Component-cfg-renderTpl\" class=\"docClass\">renderTpl</a> configuration, although to display database-derived\nmass data, it is recommended that an ExtJS data-backed Component such as a <a href=\"#!/api/Ext.view.View\" rel=\"Ext.view.View\" class=\"docClass\">View</a>,\n<a href=\"#!/api/Ext.grid.Panel\" rel=\"Ext.grid.Panel\" class=\"docClass\">GridPanel</a>, or <a href=\"#!/api/Ext.tree.Panel\" rel=\"Ext.tree.Panel\" class=\"docClass\">TreePanel</a> be used.</p>\n\n<p><strong>From override Ext.layout.container.border.Region:</strong> This override provides extra, border layout specific methods for <code><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></code>. The\n<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code> class requires this override so that the added functions\nare only included in a build when <code>border</code> layout is used.</p>\n","!type":"fn(config: ?)","autoScroll":{"!type":"bool","!doc":"<p><code>true</code> to use overflow:'auto' on the components layout element and show scroll bars automatically when necessary,\n<code>false</code> to clip any overflowing content.\nThis should not be combined with <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> or  <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a>.</p>\n"},"columnWidth":{"!doc":"<p>Defines the column width inside <a href=\"#!/api/Ext.layout.container.Column\" rel=\"Ext.layout.container.Column\" class=\"docClass\">column layout</a>.</p>\n\n<p>Can be specified as a number or as a percentage.</p>\n"},"constrainTo":{"!doc":"<p>A <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Region</a> (or an element from which a Region measurement will be read) which is used\nto constrain the component. Only applies when the component is floating.</p>\n"},"constraintInsets":{"!doc":"<p>An object or a string (in TRBL order) specifying insets from the configured <a href=\"#!/api/Ext.Component-cfg-constrainTo\" rel=\"Ext.Component-cfg-constrainTo\" class=\"docClass\">constrain region</a>\nwithin which this component must be constrained when positioning or sizing.\nexample:</p>\n\n<p>   constraintInsets: '10 10 10 10' // Constrain with 10px insets from parent</p>\n"},"defaultAlign":{"!type":"string","!doc":"<p>The default <a href=\"#!/api/Ext.util.Positionable-method-getAlignToXY\" rel=\"Ext.util.Positionable-method-getAlignToXY\" class=\"docClass\">Ext.Element#getAlignToXY</a> anchor position value for this menu\nrelative to its element of origin. Used in conjunction with <a href=\"#!/api/Ext.Component-method-showBy\" rel=\"Ext.Component-method-showBy\" class=\"docClass\">showBy</a>.</p>\n"},"floating":{"!type":"bool","!doc":"<p>Specify as true to float the Component outside of the document flow using CSS absolute positioning.</p>\n\n<p>Components such as <a href=\"#!/api/Ext.window.Window\" rel=\"Ext.window.Window\" class=\"docClass\">Window</a>s and <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Menu</a>s are floating by default.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will register\nthemselves with the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a></p>\n\n<h3>Floating Components as child items of a Container</h3>\n\n<p>A floating Component may be used as a child item of a Container. This just allows the floating Component to seek\na ZIndexManager by examining the ownerCt chain.</p>\n\n<p>When configured as floating, Components acquire, at render time, a <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which\nmanages a stack of related floating Components. The ZIndexManager brings a single floating Component to the top\nof its stack when the Component's <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> method is called.</p>\n\n<p>The ZIndexManager is found by traversing up the <a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a> chain to find an ancestor which itself is\nfloating. This is so that descendant floating Components of floating <em>Containers</em> (Such as a ComboBox dropdown\nwithin a Window) can have its zIndex managed relative to any siblings, but always <strong>above</strong> that floating\nancestor Container.</p>\n\n<p>If no floating ancestor is found, a floating Component registers itself with the default <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a>.</p>\n\n<p>Floating components <em>do not participate in the Container's layout</em>. Because of this, they are not rendered until\nyou explicitly <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> them.</p>\n\n<p>After rendering, the ownerCt reference is deleted, and the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property is set to the found\nfloating ancestor Container. If no floating ancestor Container was found the <a href=\"#!/api/Ext.Component-property-floatParent\" rel=\"Ext.Component-property-floatParent\" class=\"docClass\">floatParent</a> property will\nnot be set.</p>\n"},"formBind":{"!type":"bool","!doc":"<p>When inside FormPanel, any component configured with <code>formBind: true</code> will\nbe enabled/disabled depending on the validity state of the form.\nSee <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">Ext.form.Panel</a> for more information and example.</p>\n"},"overflowX":{"!type":"string","!doc":"<p>Possible values are:\n * <code>'auto'</code> to enable automatic horizontal scrollbar (overflow-x: 'auto').\n * <code>'scroll'</code> to always enable horizontal scrollbar (overflow-x: 'scroll').\nThe default is overflow-x: 'hidden'. This should not be combined with <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>.</p>\n"},"overflowY":{"!type":"string","!doc":"<p>Possible values are:\n * <code>'auto'</code> to enable automatic vertical scrollbar (overflow-y: 'auto').\n * <code>'scroll'</code> to always enable vertical scrollbar (overflow-y: 'scroll').\nThe default is overflow-y: 'hidden'. This should not be combined with <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>.</p>\n"},"region":{"!doc":"<p>Defines the region inside <a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">border layout</a>.</p>\n\n<p>Possible values:</p>\n\n<ul>\n<li>north - Positions component at top.</li>\n<li>south - Positions component at bottom.</li>\n<li>east - Positions component at right.</li>\n<li>west - Positions component at left.</li>\n<li>center - Positions component at the remaining space.\nThere <strong>must</strong> be a component with <code>region: \"center\"</code> in every border layout.</li>\n</ul>\n\n"},"resizeHandles":{"!type":"string","!doc":"<p>A valid <a href=\"#!/api/Ext.resizer.Resizer\" rel=\"Ext.resizer.Resizer\" class=\"docClass\">Ext.resizer.Resizer</a> handles config string. Only applies when resizable = true.</p>\n"},"toFrontOnShow":{"!type":"bool","!doc":"<p>True to automatically call <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">toFront</a> when the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method is called on an already visible,\nfloating component.</p>\n"},"bubbleEvents":{},"defaultComponentLayoutType":{"!type":"string"},"floatParent":{"!doc":"<p><strong>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which were inserted as child items of Containers.</strong></p>\n\n<p>There are other similar relationships such as the <a href=\"#!/api/Ext.button.Button\" rel=\"Ext.button.Button\" class=\"docClass\">button</a> which activates a <a href=\"#!/api/Ext.button.Button-cfg-menu\" rel=\"Ext.button.Button-cfg-menu\" class=\"docClass\">menu</a>, or the\n<a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">menu item</a> which activated a <a href=\"#!/api/Ext.menu.Item-cfg-menu\" rel=\"Ext.menu.Item-cfg-menu\" class=\"docClass\">submenu</a>, or the\n<a href=\"#!/api/Ext.grid.column.Column\" rel=\"Ext.grid.column.Column\" class=\"docClass\">column header</a> which activated the column menu.</p>\n\n<p>These differences are abstracted away by the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will not have a <code>floatParent</code>\nproperty.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">zIndexManager</a></p>\n"},"offsetsCls":{"!type":"string"},"scrollFlags":{"!doc":"<p>An object property which provides unified information as to which dimensions are scrollable based upon\nthe <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>, <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> and <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a> settings (And for <em>views</em> of trees and grids, the owning panel's <a href=\"#!/api/Ext.panel.Table-cfg-scroll\" rel=\"Ext.panel.Table-cfg-scroll\" class=\"docClass\">scroll</a> setting).</p>\n\n<p>Note that if you set overflow styles using the <a href=\"#!/api/Ext.Component-cfg-style\" rel=\"Ext.Component-cfg-style\" class=\"docClass\">style</a> config or <a href=\"#!/api/Ext.panel.Panel-cfg-bodyStyle\" rel=\"Ext.panel.Panel-cfg-bodyStyle\" class=\"docClass\">bodyStyle</a> config, this object does not include that information;\nit is best to use <a href=\"#!/api/Ext.Component-cfg-autoScroll\" rel=\"Ext.Component-cfg-autoScroll\" class=\"docClass\">autoScroll</a>, <a href=\"#!/api/Ext.Component-cfg-overflowX\" rel=\"Ext.Component-cfg-overflowX\" class=\"docClass\">overflowX</a> and <a href=\"#!/api/Ext.Component-cfg-overflowY\" rel=\"Ext.Component-cfg-overflowY\" class=\"docClass\">overflowY</a> if you need to access these flags.</p>\n\n<p>This object has the following properties:</p>\n"},"zIndexManager":{"!doc":"<p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components after they have been rendered.</p>\n\n<p>A reference to the ZIndexManager which is managing this Component's z-index.</p>\n\n<p>The <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> maintains a stack of floating Component z-indices, and also provides\na single modal mask which is insert just beneath the topmost visible modal floating Component.</p>\n\n<p>Floating Components may be <a href=\"#!/api/Ext.Component-method-toFront\" rel=\"Ext.Component-method-toFront\" class=\"docClass\">brought to the front</a> or <a href=\"#!/api/Ext.Component-method-toBack\" rel=\"Ext.Component-method-toBack\" class=\"docClass\">sent to the back</a> of the\nz-index stack.</p>\n\n<p>This defaults to the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> for floating Components that are\nprogramatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a>.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are added to a Container, the ZIndexManager is acquired from the first\nancestor Container found which is floating. If no floating ancestor is found, the global <a href=\"#!/api/Ext.WindowManager\" rel=\"Ext.WindowManager\" class=\"docClass\">ZIndexManager</a> is\nused.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexParent\" rel=\"Ext.Component-property-zIndexParent\" class=\"docClass\">zIndexParent</a></p>\n"},"zIndexParent":{"!doc":"<p>Only present for <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which were inserted as child items of Containers, and which have a floating\nContainer in their containment ancestry.</p>\n\n<p>For <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> Components which are child items of a Container, the zIndexParent will be a floating\nancestor Container which is responsible for the base z-index value of all its floating descendants. It provides\na <a href=\"#!/api/Ext.ZIndexManager\" rel=\"Ext.ZIndexManager\" class=\"docClass\">ZIndexManager</a> which provides z-indexing services for all its descendant floating\nComponents.</p>\n\n<p>Floating Components that are programatically <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">rendered</a> will not have a <code>zIndexParent</code>\nproperty.</p>\n\n<p>For example, the dropdown <a href=\"#!/api/Ext.view.BoundList\" rel=\"Ext.view.BoundList\" class=\"docClass\">BoundList</a> of a ComboBox which is in a Window will have the\nWindow as its <code>zIndexParent</code>, and will always show above that Window, wherever the Window is placed in the z-index stack.</p>\n\n<p>See <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a> and <a href=\"#!/api/Ext.Component-property-zIndexManager\" rel=\"Ext.Component-property-zIndexManager\" class=\"docClass\">zIndexManager</a></p>\n"},"adjustPosition":{"!type":"fn(x: ?, y: ?) -> !this"},"afterSetPosition":{"!type":"fn(ax: ?, ay: ?) -> !this","!doc":"<p>Template method called after a Component has been positioned.</p>\n"},"afterShow":{"!type":"fn(animateTarget?: ?, callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the Component is shown (after <a href=\"#!/api/Ext.Component-method-onShow\" rel=\"Ext.Component-method-onShow\" class=\"docClass\">onShow</a> is called).</p>\n\n<p>Gets passed the same parameters as <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a>.</p>\n"},"beforeLayout":{"!type":"fn() -> !this","!doc":"<p>Occurs before componentLayout is run. In previous releases, this method could\nreturn <code>false</code> to prevent its layout but that is not supported in Ext JS 4.1 or\nhigher. This method is simply a notification of the impending layout to give the\ncomponent a chance to adjust the DOM. Ideally, DOM reads should be avoided at this\ntime to reduce expensive document reflows.</p>\n"},"beforeSetPosition":{"!type":"fn() -> !this","!doc":"<p>Template method called before a Component is positioned.</p>\n\n<p>Ensures that the position is adjusted so that the Component is constrained if so configured.</p>\n"},"beforeShow":{"!type":"fn() -> !this","!doc":"<p>Invoked before the Component is shown.</p>\n"},"blur":{"!type":"fn() -> ?"},"bubble":{"!type":"fn(fn: ?, scope?: ?, args?: ?) -> ?","!doc":"<p>Bubbles up the component/container heirarchy, calling the specified function with each component. The scope\n(<em>this</em>) of function call will be the scope provided or the current component. The arguments to the function will\nbe the args provided or the current component. If the function returns false at any point, the bubble is stopped.</p>\n"},"cancelFocus":{"!type":"fn() -> !this","!doc":"<p>Cancel any deferred focus on this component</p>\n"},"cloneConfig":{"!type":"fn(overrides: ?) -> ?","!doc":"<p>Clone the current component using the original config values passed into this instance by default.</p>\n"},"deleteMembers":{"!type":"fn() -> !this"},"findParentBy":{"!type":"fn(fn: ?) -> ?","!doc":"<p>Find a container above this component at any level by a custom function. If the passed function returns true, the\ncontainer will be returned.</p>\n\n<p>See also the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n"},"findParentByType":{"!type":"fn(xtype: ?) -> ?","!doc":"<p>Find a container above this component at any level by xtype or class</p>\n\n<p>See also the <a href=\"#!/api/Ext.Component-method-up\" rel=\"Ext.Component-method-up\" class=\"docClass\">up</a> method.</p>\n"},"fireHierarchyEvent":{"!type":"fn(ename: ?) -> !this","!doc":"<p>For more information on the hierarchy events, see the note for the\nhierarchyEventSource observer defined in the onClassCreated callback.</p>\n\n<p>This functionality is contained in Component (as opposed to Container)\nbecause a Component can be the ownerCt for a floating component (loadmask),\nand the loadmask needs to know when its owner is shown/hidden via the\nhierarchyEventSource so that its hidden state can be synchronized.</p>\n\n<p>TODO: merge this functionality with <a href=\"#!/api/Ext-property-globalEvents\" rel=\"Ext-property-globalEvents\" class=\"docClass\">Ext.globalEvents</a></p>\n"},"focus":{"!type":"fn(selectText?: ?, delay?: ?, callback?: ?, scope?: ?) -> ?","!doc":"<p>Try to focus this component.</p>\n"},"getActionEl":{"!type":"fn() -> !this","!doc":"<p>Deprecate 5.0</p>\n"},"getAnimateTarget":{"!type":"fn(target: ?) -> !this"},"getBubbleTarget":{"!type":"fn() -> !this","!doc":"<p>Implements an upward event bubbling policy. By default a Component bubbles events up to its <a href=\"#!/api/Ext.Component-method-getRefOwner\" rel=\"Ext.Component-method-getRefOwner\" class=\"docClass\">reference owner</a>.</p>\n\n<p>Component subclasses may implement a different bubbling strategy by overriding this method.</p>\n"},"getDragEl":{"!type":"fn() -> !this"},"getEl":{"!type":"fn() -> ?","!doc":"<p>Retrieves the top level element representing this component.</p>\n"},"getId":{"!type":"fn() -> string","!doc":"<p>Retrieves the <code>id</code> of this component. Will auto-generate an <code>id</code> if one has not already been set.</p>\n"},"getOuterSize":{"!type":"fn() -> !this","!doc":"<p>Include margins</p>\n"},"getOwningBorderContainer":{"!type":"fn() -> ?","!doc":"<p>Returns the owning container if that container uses <code>border</code> layout. Otherwise\nthis method returns <code>null</code>.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"getOwningBorderLayout":{"!type":"fn() -> ?","!doc":"<p>Returns the owning <code>border</code> (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>) instance if there is\none. Otherwise this method returns <code>null</code>.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"getPosition":{"!type":"fn(local?: ?) -> ?","!doc":"<p>Gets the current XY position of the component's underlying element.</p>\n"},"getPositionEl":{"!type":"fn() -> !this","!doc":"<p>Deprecate 5.0</p>\n"},"getProxy":{"!type":"fn() -> !this"},"getRefOwner":{"!type":"fn() -> !this","!doc":"<p>Used by <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a>, and the <a href=\"#!/api/Ext.AbstractComponent-method-up\" rel=\"Ext.AbstractComponent-method-up\" class=\"docClass\">up</a> method to find the\nowning Component in the linkage hierarchy.</p>\n\n<p>By default this returns the Container which contains this Component.</p>\n\n<p>This may be overriden by Component authors who implement ownership hierarchies which are not\nbased upon ownerCt, such as BoundLists being owned by Fields or Menus being owned by Buttons.</p>\n"},"getResizeEl":{"!type":"fn() -> !this","!doc":"<p>Deprecate 5.0</p>\n"},"getVisibilityEl":{"!type":"fn() -> !this","!doc":"<p>Deprecate 5.0</p>\n"},"getXType":{"!type":"fn() -> string","!doc":"<p>Gets the xtype for this component as registered with <a href=\"#!/api/Ext.ComponentManager\" rel=\"Ext.ComponentManager\" class=\"docClass\">Ext.ComponentManager</a>. For a list of all available\nxtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header. Example usage:</p>\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.field.Text\" rel=\"Ext.form.field.Text\" class=\"docClass\">Ext.form.field.Text</a>();\nalert(t.getXType());  // alerts 'textfield'\n</code></pre>\n"},"initBorderRegion":{"!type":"fn() -> !this","!doc":"<p>This method is called by the <code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code> class when instances are\nadded as regions to the layout. Since it is valid to add any component to a border\nlayout as a region, this method must be added to <code><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></code> but is only ever\ncalled when that component is owned by a <code>border</code> layout.</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"isContainedFloater":{"!type":"fn() -> !this","!doc":"<p>Utility method to determine if a Component is floating, and has an owning Container whose coordinate system\nit must be positioned in when using setPosition.</p>\n"},"makeFloating":{"!type":"fn(dom: ?) -> !this"},"onAdded":{"!type":"fn() -> !this","!doc":"<p>Method to manage awareness of when components are added to their\nrespective Container, firing an <a href=\"#!/api/Ext.Component-event-added\" rel=\"Ext.Component-event-added\" class=\"docClass\">added</a> event. References are\nestablished at add time rather than at render time.</p>\n\n<p>Allows addition of behavior when a Component is added to a\nContainer. At this stage, the Component is in the parent\nContainer's collection of child items. After calling the\nsuperclass's <code>onAdded</code>, the <code>ownerCt</code> reference will be present,\nand if configured with a ref, the <code>refOwner</code> will be set.</p>\n"},"onDestroy":{"!type":"fn() -> !this","!doc":"<p>Allows addition of behavior to the destroy operation.\nAfter calling the superclass's onDestroy, the Component will be destroyed.</p>\n"},"onShowComplete":{"!type":"fn(callback?: ?, scope?: ?) -> !this","!doc":"<p>Invoked after the <a href=\"#!/api/Ext.Component-method-afterShow\" rel=\"Ext.Component-method-afterShow\" class=\"docClass\">afterShow</a> method is complete.</p>\n\n<p>Gets passed the same <code>callback</code> and <code>scope</code> parameters that <a href=\"#!/api/Ext.Component-method-afterShow\" rel=\"Ext.Component-method-afterShow\" class=\"docClass\">afterShow</a> received.</p>\n"},"onShowVeto":{"!type":"fn() -> !this"},"scrollBy":{"!type":"fn(deltaX: ?, deltaY: ?, animate: ?) -> !this","!doc":"<p>Scrolls this Component's <a href=\"#!/api/Ext.Component-method-getTargetEl\" rel=\"Ext.Component-method-getTargetEl\" class=\"docClass\">target element</a> by the passed delta values, optionally animating.</p>\n\n<p>All of the following are equivalent:</p>\n\n<pre><code> comp.scrollBy(10, 10, true);\n comp.scrollBy([10, 10], true);\n comp.scrollBy({ x: 10, y: 10 }, true);\n</code></pre>\n"},"setAutoScroll":{"!type":"fn(scroll: ?) -> ?","!doc":"<p>Sets the overflow on the content element of the component.</p>\n"},"setBorderRegion":{"!type":"fn(region: ?) -> string","!doc":"<p>This method changes the <code>region</code> config property for this border region. This is\nonly valid if this component is in a <code>border</code> layout (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>).</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"setLoading":{"!type":"fn(load: ?, targetEl?: ?) -> ?","!doc":"<p>This method allows you to show or hide a LoadMask on top of this component.</p>\n"},"setOverflowXY":{"!type":"fn(overflowX: ?, overflowY: ?) -> ?","!doc":"<p>Sets the overflow x/y on the content element of the component. The x/y overflow\nvalues can be any valid CSS overflow (e.g., 'auto' or 'scroll'). By default, the\nvalue is 'hidden'. Passing null for one of the values will erase the inline style.\nPassing <code>undefined</code> will preserve the current value.</p>\n"},"setPagePosition":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Sets the page XY position of the component. To set the left and top instead, use <a href=\"#!/api/Ext.Component-method-setPosition\" rel=\"Ext.Component-method-setPosition\" class=\"docClass\">setPosition</a>.\nThis method fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n"},"setPosition":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Sets the left and top of the component. To set the page XY position instead, use <a href=\"#!/api/Ext.Component-method-setPagePosition\" rel=\"Ext.Component-method-setPagePosition\" class=\"docClass\">setPagePosition</a>. This\nmethod fires the <a href=\"#!/api/Ext.Component-event-move\" rel=\"Ext.Component-event-move\" class=\"docClass\">move</a> event.</p>\n"},"setRegionWeight":{"!type":"fn(weight: ?) -> number","!doc":"<p>Sets the <code>weight</code> config property for this component. This is only valid if this\ncomponent is in a <code>border</code> layout (<code><a href=\"#!/api/Ext.layout.container.Border\" rel=\"Ext.layout.container.Border\" class=\"docClass\">Ext.layout.container.Border</a></code>).</p>\n\n<p><strong>Defined in override Ext.layout.container.border.Region.</strong></p>\n"},"showAt":{"!type":"fn(x: ?, y?: ?, animate?: ?) -> ?","!doc":"<p>Displays component at specific xy position.\nA floating component (like a menu) is positioned relative to its ownerCt if any.\nUseful for popping up a context menu:</p>\n\n<pre><code>listeners: {\n    itemcontextmenu: function(view, record, item, index, event, options) {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a>', {\n            width: 100,\n            height: 100,\n            margin: '0 0 10 0',\n            items: [{\n                text: 'regular item 1'\n            },{\n                text: 'regular item 2'\n            },{\n                text: 'regular item 3'\n            }]\n        }).showAt(event.getXY());\n    }\n}\n</code></pre>\n"},"showBy":{"!type":"fn(component: ?, position?: ?, offsets?: ?) -> ?","!doc":"<p>Shows this component by the specified <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> or <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">Element</a>.\nUsed when this component is <a href=\"#!/api/Ext.Component-cfg-floating\" rel=\"Ext.Component-cfg-floating\" class=\"docClass\">floating</a>.</p>\n"},"updateBox":{"!type":"fn(box: ?) -> ?","!doc":"<p>Sets the current box measurements of the component's underlying element.</p>\n"},"wrapPrimaryEl":{"!type":"fn(dom: ?) -> !this"}},"Queryable":{"prototype":{"isQueryable":{"!type":"bool"},"child":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Retrieves the first direct child of this container which matches the passed selector or component.\nThe passed in selector must comply with an <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> selector, or it can be an actual <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</p>\n"},"down":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Retrieves the first descendant of this container which matches the passed selector.\nThe passed in selector must comply with an <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> selector, or it can be an actual <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</p>\n"},"query":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Retrieves all descendant components which match the passed selector.\nExecutes an <a href=\"#!/api/Ext.ComponentQuery-method-query\" rel=\"Ext.ComponentQuery-method-query\" class=\"docClass\">Ext.ComponentQuery.query</a> using this container as its root.</p>\n"},"queryBy":{"!type":"fn(fn: ?, scope?: ?) -> ?","!doc":"<p>Retrieves all descendant components which match the passed function.\nThe function should return false for components that are to be\nexcluded from the selection.</p>\n"},"queryById":{"!type":"fn(id: ?) -> ?","!doc":"<p>Finds a component at any level under this container matching the id/itemId.\nThis is a shorthand for calling ct.down('#' + id);</p>\n"},"getRefItems":{"!type":"fn() -> !this"}},"isQueryable":{"!type":"bool"},"child":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Retrieves the first direct child of this container which matches the passed selector or component.\nThe passed in selector must comply with an <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> selector, or it can be an actual <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</p>\n"},"down":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Retrieves the first descendant of this container which matches the passed selector.\nThe passed in selector must comply with an <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> selector, or it can be an actual <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</p>\n"},"query":{"!type":"fn(selector?: ?) -> ?","!doc":"<p>Retrieves all descendant components which match the passed selector.\nExecutes an <a href=\"#!/api/Ext.ComponentQuery-method-query\" rel=\"Ext.ComponentQuery-method-query\" class=\"docClass\">Ext.ComponentQuery.query</a> using this container as its root.</p>\n"},"queryBy":{"!type":"fn(fn: ?, scope?: ?) -> ?","!doc":"<p>Retrieves all descendant components which match the passed function.\nThe function should return false for components that are to be\nexcluded from the selection.</p>\n"},"queryById":{"!type":"fn(id: ?) -> ?","!doc":"<p>Finds a component at any level under this container matching the id/itemId.\nThis is a shorthand for calling ct.down('#' + id);</p>\n"},"!doc":"<p>A mixin for providing query related methods for <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> for components that\nimplement getRefItems.</p>\n"},"chart":{"axis":{"Abstract":{"!doc":"<p>Base class for all axis classes.</p>\n","!type":"fn(config?: ?)","prototype":{"fields":{"!doc":"<p>The fields of model to bind to this axis.</p>\n\n<p>For example if you have a data set of lap times per car, each having the fields:\n<code>'carName'</code>, <code>'avgSpeed'</code>, <code>'maxSpeed'</code>. Then you might want to show the data on chart\nwith <code>['carName']</code> on Name axis and <code>['avgSpeed', 'maxSpeed']</code> on Speed axis.</p>\n"},"label":{"!doc":"<p>The config for chart label.</p>\n"},"alignment":{},"grid":{"!type":"bool"},"maxValue":{"!type":"number"},"minValue":{"!type":"number"},"steps":{"!type":"number"},"x":{"!type":"number"},"y":{"!type":"number"},"addDisplayAndLabels":{"!type":"fn() -> !this"},"drawAxis":{"!type":"fn() -> !this"},"getId":{"!type":"fn() -> !this"},"processView":{"!type":"fn() -> !this","!doc":"<p>Called to process a view i.e to make aggregation and filtering over\na store creating a substore to be used to render the axis. Since many axes\nmay do different things on the data and we want the final result of all these\noperations to be rendered we need to call processView on all axes before drawing\nthem.</p>\n"}}},"Axis":{"!doc":"<p>Defines axis for charts. The axis position, type, style can be configured.\nThe axes are defined in an axes array of configuration objects where the type,\nfield, grid and other configuration options can be set. To know more about how\nto create a Chart please check the Chart class documentation. Here's an example for the axes part:\nAn example of axis for a series (in this case for an area chart that has multiple layers of yFields) could be:</p>\n\n<pre><code>axes: [{\n    type: 'Numeric',\n    position: 'left',\n    fields: ['data1', 'data2', 'data3'],\n    title: 'Number of Hits',\n    grid: {\n        odd: {\n            opacity: 1,\n            fill: '#ddd',\n            stroke: '#bbb',\n            'stroke-width': 1\n        }\n    },\n    minimum: 0\n}, {\n    type: 'Category',\n    position: 'bottom',\n    fields: ['name'],\n    title: 'Month of the Year',\n    grid: true,\n    label: {\n        rotate: {\n            degrees: 315\n        }\n    }\n}]\n</code></pre>\n\n<p>In this case we use a <code>Numeric</code> axis for displaying the values of the Area series and a <code>Category</code> axis for displaying the names of\nthe store elements. The numeric axis is placed on the left of the screen, while the category axis is placed at the bottom of the chart.\nBoth the category and numeric axes have <code>grid</code> set, which means that horizontal and vertical lines will cover the chart background. In the\ncategory axis the labels will be rotated so they can fit the space better.</p>\n","!type":"fn(config?: ?)","prototype":{"adjustEnd":{"!type":"bool","!doc":"<p>Whether to adjust the label at the end of the axis.</p>\n"},"dashSize":{"!type":"number","!doc":"<p>The size of the dash marker. Default's 3.</p>\n"},"grid":{"!doc":"<p>The grid configuration enables you to set a background grid for an axis.\nIf set to <em>true</em> on a vertical axis, vertical lines will be drawn.\nIf set to <em>true</em> on a horizontal axis, horizontal lines will be drawn.\nIf both are set, a proper grid with horizontal and vertical lines will be drawn.</p>\n\n<p>You can set specific options for the grid configuration for odd and/or even lines/rows.\nSince the rows being drawn are rectangle sprites, you can set to an odd or even property\nall styles that apply to <a href=\"#!/api/Ext.draw.Sprite\" rel=\"Ext.draw.Sprite\" class=\"docClass\">Ext.draw.Sprite</a>. For more information on all the style\nproperties you can set please take a look at <a href=\"#!/api/Ext.draw.Sprite\" rel=\"Ext.draw.Sprite\" class=\"docClass\">Ext.draw.Sprite</a>. Some useful style\nproperties are <code>opacity</code>, <code>fill</code>, <code>stroke</code>, <code>stroke-width</code>, etc.</p>\n\n<p>The possible values for a grid option are then <em>true</em>, <em>false</em>, or an object with <code>{ odd, even }</code> properties\nwhere each property contains a sprite style descriptor object that is defined in <a href=\"#!/api/Ext.draw.Sprite\" rel=\"Ext.draw.Sprite\" class=\"docClass\">Ext.draw.Sprite</a>.</p>\n\n<p>For example:</p>\n\n<pre><code>axes: [{\n    type: 'Numeric',\n    position: 'left',\n    fields: ['data1', 'data2', 'data3'],\n    title: 'Number of Hits',\n    grid: {\n        odd: {\n            opacity: 1,\n            fill: '#ddd',\n            stroke: '#bbb',\n            'stroke-width': 1\n        }\n    }\n}, {\n    type: 'Category',\n    position: 'bottom',\n    fields: ['name'],\n    title: 'Month of the Year',\n    grid: true\n}]\n</code></pre>\n"},"hidden":{"!type":"bool","!doc":"<p><code>true</code> to hide the axis.</p>\n"},"length":{"!type":"number","!doc":"<p>Offset axis position. Default's 0.</p>\n"},"majorTickSteps":{"!type":"bool"},"minorTickSteps":{"!type":"number","!doc":"<p>The number of small ticks between two major ticks. Default is zero.</p>\n"},"position":{"!type":"string","!doc":"<p>Where to set the axis. Available options are <code>left</code>, <code>bottom</code>, <code>right</code>, <code>top</code>. Default's <code>bottom</code>.</p>\n"},"title":{"!type":"string","!doc":"<p>The title for the Axis</p>\n"},"width":{"!type":"number","!doc":"<p>Offset axis width. Default's 0.</p>\n"},"forceMinMax":{"!type":"bool","!doc":"<p>force min/max values from store</p>\n"},"nullGutters":{},"skipFirst":{"!type":"bool"},"applyData":{"!type":"fn() -> !this"},"calcEnds":{"!type":"fn() -> !this","!doc":"<p>creates a structure with start, end and step points.</p>\n"},"drawAxis":{"!type":"fn(init: ?) -> !this","!doc":"<p>Renders the axis into the screen and updates its position.</p>\n"},"drawGrid":{"!type":"fn() -> !this","!doc":"<p>Renders an horizontal and/or vertical grid into the Surface.</p>\n"},"drawHorizontalLabels":{"!type":"fn() -> !this"},"drawLabel":{"!type":"fn() -> !this","!doc":"<p>Renders the labels in the axes.</p>\n"},"drawTitle":{"!type":"fn(maxWidth: ?, maxHeight: ?) -> !this","!doc":"<p>draws the title for the axis.</p>\n"},"drawVerticalLabels":{"!type":"fn() -> !this"},"getOrCreateLabel":{"!type":"fn(i: ?, text: ?) -> !this"},"getRange":{"!type":"fn() -> !this"},"intersect":{"!type":"fn(l1: ?, l2: ?) -> !this"},"rect2pointArray":{"!type":"fn(sprite: ?) -> !this"},"setTitle":{"!type":"fn(title: ?) -> !this","!doc":"<p>Updates the <a href=\"#!/api/Ext.chart.axis.Axis-cfg-title\" rel=\"Ext.chart.axis.Axis-cfg-title\" class=\"docClass\">title</a> of this axis.</p>\n"}}},"Category":{"!doc":"<p>A type of axis that displays items in categories. This axis is generally used to\ndisplay categorical information like names of items, month names, quarters, etc.\nbut no quantitative values. For that other type of information <code>Number</code>\naxis are more suitable.</p>\n\n<p>As with other axis you can set the position of the axis and its title. For example:</p>\n\n<pre class='inline-example '><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.JsonStore\" rel=\"Ext.data.JsonStore\" class=\"docClass\">Ext.data.JsonStore</a>', {\n    fields: ['name', 'data1', 'data2', 'data3', 'data4', 'data5'],\n    data: [\n        {'name':'metric one', 'data1':10, 'data2':12, 'data3':14, 'data4':8, 'data5':13},\n        {'name':'metric two', 'data1':7, 'data2':8, 'data3':16, 'data4':10, 'data5':3},\n        {'name':'metric three', 'data1':5, 'data2':2, 'data3':14, 'data4':12, 'data5':7},\n        {'name':'metric four', 'data1':2, 'data2':14, 'data3':6, 'data4':1, 'data5':23},\n        {'name':'metric five', 'data1':27, 'data2':38, 'data3':36, 'data4':13, 'data5':33}\n    ]\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.chart.Chart\" rel=\"Ext.chart.Chart\" class=\"docClass\">Ext.chart.Chart</a>', {\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    width: 500,\n    height: 300,\n    store: store,\n    axes: [{\n        type: 'Numeric',\n        position: 'left',\n        fields: ['data1', 'data2', 'data3', 'data4', 'data5'],\n        title: 'Sample Values',\n        grid: {\n            odd: {\n                opacity: 1,\n                fill: '#ddd',\n                stroke: '#bbb',\n                'stroke-width': 1\n            }\n        },\n        minimum: 0,\n        adjustMinimumByMajorUnit: 0\n    }, {\n        type: 'Category',\n        position: 'bottom',\n        fields: ['name'],\n        title: 'Sample Metrics',\n        grid: true,\n        label: {\n            rotate: {\n                degrees: 315\n            }\n        }\n    }],\n    series: [{\n        type: 'area',\n        highlight: false,\n        axis: 'left',\n        xField: 'name',\n        yField: ['data1', 'data2', 'data3', 'data4', 'data5'],\n        style: {\n            opacity: 0.93\n        }\n    }]\n});\n</code></pre>\n\n<p>In this example with set the category axis to the bottom of the surface, bound the axis to\nthe <code>name</code> property and set as title <em>Month of the Year</em>.</p>\n","!type":"fn(config?: ?)","prototype":{"calculateCategoryCount":{"!type":"bool","!doc":"<p>Indicates whether or not to calculate the number of categories (ticks and\nlabels) when there is not enough room to display all labels on the axis.\nIf set to true, the axis will determine the number of categories to plot.\nIf not, all categories will be plotted.</p>\n"},"categoryNames":{"!type":"string","!doc":"<p>A list of category names to display along this axis.</p>\n"},"applyData":{"!type":"fn() -> !this","!doc":"<p>calculates labels positions and marker positions for rendering.</p>\n"},"doConstrain":{"!type":"fn() -> !this","!doc":"<p>constrains to datapoints between minimum and maximum only</p>\n"},"setLabels":{"!type":"fn() -> !this","!doc":"<p>creates an array of labels to be used when rendering.</p>\n"}}},"Gauge":{"!doc":"<p>Gauge Axis is the axis to be used with a Gauge series. The Gauge axis\ndisplays numeric data from an interval defined by the <code>minimum</code>, <code>maximum</code> and\n<code>step</code> configuration properties. The placement of the numeric data can be changed\nby altering the <code>margin</code> option that is set to <code>10</code> by default.</p>\n\n<p>A possible configuration for this axis would look like:</p>\n\n<pre><code>axes: [{\n    type: 'gauge',\n    position: 'gauge',\n    minimum: 0,\n    maximum: 100,\n    steps: 10,\n    margin: 7\n}],\n</code></pre>\n","!type":"fn(config?: ?)","prototype":{"margin":{"!type":"number","!doc":"<p>The offset positioning of the tick marks and labels in pixels.</p>\n"},"maximum":{"!type":"number","!doc":"<p>The maximum value of the interval to be displayed in the axis.</p>\n"},"minimum":{"!type":"number","!doc":"<p>The minimum value of the interval to be displayed in the axis.</p>\n"},"steps":{"!type":"number","!doc":"<p>The number of steps and tick marks to add to the interval.</p>\n"},"title":{"!type":"string","!doc":"<p>The title for the Axis.</p>\n"},"drawAxis":{"!type":"fn(init: ?) -> !this"},"drawLabel":{"!type":"fn() -> !this"},"drawTitle":{"!type":"fn() -> !this"},"setTitle":{"!type":"fn(title: ?) -> !this","!doc":"<p>Updates the <a href=\"#!/api/Ext.chart.axis.Gauge-cfg-title\" rel=\"Ext.chart.axis.Gauge-cfg-title\" class=\"docClass\">title</a> of this axis.</p>\n"}}},"Numeric":{"!doc":"<p>An axis to handle numeric values. This axis is used for quantitative data as\nopposed to the category axis. You can set mininum and maximum values to the\naxis so that the values are bound to that. If no values are set, then the\nscale will auto-adjust to the values.</p>\n\n<pre class='inline-example '><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.JsonStore\" rel=\"Ext.data.JsonStore\" class=\"docClass\">Ext.data.JsonStore</a>', {\n     fields: ['name', 'data1', 'data2', 'data3', 'data4', 'data5'],\n     data: [\n         {'name':'metric one', 'data1':10, 'data2':12, 'data3':14, 'data4':8, 'data5':13},\n         {'name':'metric two', 'data1':7, 'data2':8, 'data3':16, 'data4':10, 'data5':3},\n         {'name':'metric three', 'data1':5, 'data2':2, 'data3':14, 'data4':12, 'data5':7},\n         {'name':'metric four', 'data1':2, 'data2':14, 'data3':6, 'data4':1, 'data5':23},\n         {'name':'metric five', 'data1':27, 'data2':38, 'data3':36, 'data4':13, 'data5':33}\n     ]\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.chart.Chart\" rel=\"Ext.chart.Chart\" class=\"docClass\">Ext.chart.Chart</a>', {\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    width: 500,\n    height: 300,\n    store: store,\n    axes: [{\n        type: 'Numeric',\n        position: 'left',\n        fields: ['data1', 'data2', 'data3', 'data4', 'data5'],\n        title: 'Sample Values',\n        grid: {\n            odd: {\n                opacity: 1,\n                fill: '#ddd',\n                stroke: '#bbb',\n                'stroke-width': 1\n            }\n        },\n        minimum: 0,\n        adjustMinimumByMajorUnit: 0\n    }, {\n        type: 'Category',\n        position: 'bottom',\n        fields: ['name'],\n        title: 'Sample Metrics',\n        grid: true,\n        label: {\n            rotate: {\n                degrees: 315\n            }\n        }\n    }],\n    series: [{\n        type: 'area',\n        highlight: false,\n        axis: 'left',\n        xField: 'name',\n        yField: ['data1', 'data2', 'data3', 'data4', 'data5'],\n        style: {\n            opacity: 0.93\n        }\n    }]\n});\n</code></pre>\n\n<p>In this example we create an axis of Numeric type. We set a minimum value so that\neven if all series have values greater than zero, the grid starts at zero. We bind\nthe axis onto the left part of the surface by setting <code>position</code> to <code>left</code>.\nWe bind three different store fields to this axis by setting <code>fields</code> to an array.\nWe set the title of the axis to <em>Number of Hits</em> by using the <code>title</code> property.\nWe use a <code>grid</code> configuration to set odd background rows to a certain style and even rows\nto be transparent/ignored.</p>\n","!type":"fn(config: ?)","prototype":{"adjustMaximumByMajorUnit":{"!type":"bool","!doc":"<p>Indicates whether to extend maximum beyond data's maximum to the nearest\nmajorUnit.</p>\n"},"adjustMinimumByMajorUnit":{"!type":"bool","!doc":"<p>Indicates whether to extend the minimum beyond data's minimum to the\nnearest majorUnit.</p>\n"},"constrain":{"!type":"bool","!doc":"<p>If true, the values of the chart will be rendered only if they belong between minimum and maximum.\nIf false, all values of the chart will be rendered, regardless of whether they belong between minimum and maximum or not.\nDefault's true if maximum and minimum is specified. It is ignored for stacked charts.</p>\n"},"decimals":{"!type":"number","!doc":"<p>The number of decimals to round the value to.</p>\n"},"maximum":{"!type":"number","!doc":"<p>The maximum value drawn by the axis. If not set explicitly, the axis\nmaximum will be calculated automatically. It is ignored for stacked charts.</p>\n"},"minimum":{"!type":"number","!doc":"<p>The minimum value drawn by the axis. If not set explicitly, the axis\nminimum will be calculated automatically. It is ignored for stacked charts.</p>\n"},"position":{"!type":"string","!doc":"<p>Indicates the position of the axis relative to the chart</p>\n"},"scale":{"!type":"string","!doc":"<p>The scaling algorithm to use on this axis. May be \"linear\" or\n\"logarithmic\".  Currently only linear scale is implemented.</p>\n"},"isNumericAxis":{"!type":"bool"},"type":{"!type":"string","!doc":"<p>End Definitions</p>\n"},"applyData":{"!type":"fn() -> !this","!doc":"<p>apply data.</p>\n"},"doConstrain":{"!type":"fn() -> !this","!doc":"<p>constrains to datapoints between minimum and maximum only</p>\n"},"processView":{"!type":"fn() -> !this","!doc":"<p>applying constraint</p>\n"},"roundToDecimal":{"!type":"fn(v: ?, dec: ?) -> !this"}}},"Radial":{"!type":"fn(config: ?)","prototype":{"maximum":{"!type":"number","!doc":"<p>The maximum value drawn by the axis. If not set explicitly, the axis\nmaximum will be calculated automatically.</p>\n"},"position":{"!type":"string","!doc":"<p>End Definitions</p>\n"},"steps":{"!type":"number","!doc":"<p>The number of circles to draw outward from the center.</p>\n"},"drawLabel":{"!type":"fn() -> !this","!doc":"<p>Renders the labels in the axes.</p>\n"},"getRange":{"!type":"fn() -> !this"},"processView":{"!type":"fn() -> !this","!doc":"<p>applying constraint</p>\n"}}},"Time":{"!doc":"<p>A type of axis whose units are measured in time values. Use this axis\nfor listing dates that you will want to group or dynamically change.\nIf you just want to display dates as categories then use the\nCategory class for axis instead.</p>\n\n<p>For example:</p>\n\n<pre><code>axes: [{\n    type: 'Time',\n    position: 'bottom',\n    fields: 'date',\n    title: 'Day',\n    dateFormat: 'M d',\n\n    constrain: true,\n    fromDate: new Date('1/1/11'),\n    toDate: new Date('1/7/11')\n}]\n</code></pre>\n\n<p>In this example we're creating a time axis that has as title <em>Day</em>.\nThe field the axis is bound to is <code>date</code>.\nThe date format to use to display the text for the axis labels is <code>M d</code>\nwhich is a three letter month abbreviation followed by the day number.\nThe time axis will show values for dates between <code>fromDate</code> and <code>toDate</code>.\nSince <code>constrain</code> is set to true all other values for other dates not between\nthe fromDate and toDate will not be displayed.</p>\n","!type":"fn(config: ?)","prototype":{"constrain":{"!type":"bool","!doc":"<p>If true, the values of the chart will be rendered only if they belong between the fromDate and toDate.\nIf false, the time axis will adapt to the new values by adding/removing steps.</p>\n"},"dateFormat":{"!doc":"<p>Indicates the format the date will be rendered on.\nFor example: 'M d' will render the dates as 'Jan 30', etc.\nFor a list of possible format strings see <a href=\"#!/api/Ext.Date\" rel=\"Ext.Date\" class=\"docClass\">Date</a></p>\n"},"fromDate":{"!doc":"<p>The starting date for the time axis.</p>\n"},"step":{"!doc":"<p>An array with two components: The first is the unit of the step (day, month, year, etc). The second one is a number.\nIf the number is an integer, it represents the number of units for the step ([<a href=\"#!/api/Ext.Date-property-DAY\" rel=\"Ext.Date-property-DAY\" class=\"docClass\">Ext.Date.DAY</a>, 2] means \"Every other day\").\nIf the number is a fraction, it represents the number of steps per unit ([<a href=\"#!/api/Ext.Date-property-DAY\" rel=\"Ext.Date-property-DAY\" class=\"docClass\">Ext.Date.DAY</a>, 1/2] means \"Twice a day\").\nIf the unit is the month, the steps may be adjusted depending on the month. For instance [<a href=\"#!/api/Ext.Date-property-MONTH\" rel=\"Ext.Date-property-MONTH\" class=\"docClass\">Ext.Date.MONTH</a>, 1/3], which means \"Three times a month\",\ngenerates steps on the 1st, the 10th and the 20th of every month regardless of whether a month has 28 days or 31 days. The steps are generated\nas follows:\n- [<a href=\"#!/api/Ext.Date-property-MONTH\" rel=\"Ext.Date-property-MONTH\" class=\"docClass\">Ext.Date.MONTH</a>, n]: on the current date every 'n' months, maxed to the number of days in the month.\n- [<a href=\"#!/api/Ext.Date-property-MONTH\" rel=\"Ext.Date-property-MONTH\" class=\"docClass\">Ext.Date.MONTH</a>, 1/2]: on the 1st and 15th of every month.\n- [<a href=\"#!/api/Ext.Date-property-MONTH\" rel=\"Ext.Date-property-MONTH\" class=\"docClass\">Ext.Date.MONTH</a>, 1/3]: on the 1st, 10th and 20th of every month.\n- [<a href=\"#!/api/Ext.Date-property-MONTH\" rel=\"Ext.Date-property-MONTH\" class=\"docClass\">Ext.Date.MONTH</a>, 1/4]: on the 1st, 8th, 15th and 22nd of every month.</p>\n\n<p>Defaults to: [<a href=\"#!/api/Ext.Date-property-DAY\" rel=\"Ext.Date-property-DAY\" class=\"docClass\">Ext.Date.DAY</a>, 1].</p>\n"},"toDate":{"!doc":"<p>The ending date for the time axis.</p>\n"},"type":{"!type":"string","!doc":"<p>End Definitions</p>\n"},"calcEnds":{"!type":"fn() -> !this","!doc":"<p>modifies the store and creates the labels for the axes.</p>\n"},"processView":{"!type":"fn() -> !this","!doc":"<p>Before rendering, set current default step count to be number of records.</p>\n"}}}},"Callout":{"!doc":"<p>A mixin providing callout functionality for <a href=\"#!/api/Ext.chart.series.Series\" rel=\"Ext.chart.series.Series\" class=\"docClass\">Ext.chart.series.Series</a>.</p>\n","!type":"fn(config: ?)","prototype":{"hideCallouts":{"!type":"fn(index: ?) -> !this"},"onCreateCallout":{"!type":"fn(storeItem: ?, item: ?, i: ?, display: ?) -> !this"},"renderCallouts":{"!type":"fn() -> !this"}}},"Chart":{"!doc":"<p>Charts provide a flexible way to achieve a wide range of data visualization capablitities.\nEach Chart gets its data directly from a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>, and automatically\nupdates its display whenever data in the Store changes. In addition, the look and feel\nof a Chart can be customized using <a href=\"#!/api/Ext.chart.theme.Theme\" rel=\"Ext.chart.theme.Theme\" class=\"docClass\">Theme</a>s.</p>\n\n<h2>Creating a Simple Chart</h2>\n\n<p>Every Chart has three key parts - a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> that contains the data,\nan array of <a href=\"#!/api/Ext.chart.axis.Axis\" rel=\"Ext.chart.axis.Axis\" class=\"docClass\">Axes</a> which define the boundaries of the Chart,\nand one or more <a href=\"#!/api/Ext.chart.series.Series\" rel=\"Ext.chart.series.Series\" class=\"docClass\">Series</a> to handle the visual rendering of the data points.</p>\n\n<h3>1. Creating a Store</h3>\n\n<p>The first step is to create a <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> that represents the type of\ndata that will be displayed in the Chart. For example the data for a chart that displays\na weather forecast could be represented as a series of \"WeatherPoint\" data points with\ntwo fields - \"temperature\", and \"date\":</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('WeatherPoint', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['temperature', 'date']\n});\n</code></pre>\n\n<p>Next a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> must be created.  The stor