/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.ecore2ecore.action;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.domain.PluginAdapterFactoryMappingDomain;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcoreFactory;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcoreMappingRoot;
import org.eclipse.emf.mapping.ecore2ecore.presentation.Ecore2EcoreEditorPlugin;
import org.eclipse.emf.mapping.provider.MappingItemProviderAdapterFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class MapToEcoreActionDelegate
extends ActionDelegate {
    private static final List<String> FILE_EXTENSIONS = Arrays.asList("ecore", "emof");
    private static final String ECORE2ECORE_FILE_EXTENSION = "ecore2ecore";

    protected EPackage getInputEPackage(IStructuredSelection structuredSelection) {
        IFile file;
        if (IFile.class.isInstance(structuredSelection.getFirstElement()) && FILE_EXTENSIONS.contains((file = (IFile)structuredSelection.getFirstElement()).getFullPath().getFileExtension())) {
            return (EPackage)EcoreUtil.getObjectByType((Collection)new ResourceSetImpl().getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true).getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
        }
        return null;
    }

    protected IFile getFile(Resource resource) {
        URI uri = resource.getURI();
        uri = resource.getResourceSet().getURIConverter().normalize(uri);
        String platformResourceString = uri.toPlatformString(true);
        return platformResourceString != null ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourceString)) : null;
    }

    public void run(IAction action) {
        final IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Object selection = ((IStructuredSelection)workbenchWindow.getSelectionService().getSelection()).getFirstElement();
        final IFile selectedEcoreFile = selection instanceof IFile && FILE_EXTENSIONS.contains(((IFile)selection).getFileExtension()) ? (IFile)selection : null;
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    return FILE_EXTENSIONS.contains(file.getFileExtension()) && (selectedEcoreFile == null || !selectedEcoreFile.getFullPath().equals((Object)file.getFullPath()));
                }
                return true;
            }
        };
        final IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)workbenchWindow.getShell(), null, (String)Ecore2EcoreEditorPlugin.INSTANCE.getString("_UI_SelectOutputEcoreModels_label"), (boolean)true, null, Collections.singletonList(viewerFilter));
        if (files.length > 0) {
            final EPackage inputEPackage = this.getInputEPackage((IStructuredSelection)workbenchWindow.getSelectionService().getSelection());
            final Resource inputResource = inputEPackage.eResource();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(workbenchWindow.getShell());
            try {
                dialog.run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor progressMonitor) {
                        try {
                            progressMonitor.beginTask("", files.length);
                            int i = 0;
                            while (i < files.length) {
                                Resource outputResource = inputResource.getResourceSet().getResource(URI.createPlatformResourceURI((String)files[i].getFullPath().toString(), (boolean)true), true);
                                EPackage outputEPackage = (EPackage)EcoreUtil.getObjectByType((Collection)outputResource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
                                String base = String.valueOf(inputResource.getURI().trimFileExtension().lastSegment()) + "_2_" + outputResource.getURI().trimFileExtension().lastSegment();
                                URI mappingURI = outputResource.getURI().trimSegments(1).appendSegment(base).appendFileExtension(MapToEcoreActionDelegate.ECORE2ECORE_FILE_EXTENSION);
                                Resource mappingResource = inputResource.getResourceSet().createResource(mappingURI);
                                progressMonitor.subTask(MessageFormat.format(Ecore2EcoreEditorPlugin.INSTANCE.getString("_UI_BuildingMappingFromTo_message"), inputResource.getURI().lastSegment(), outputResource.getURI().lastSegment()));
                                mappingResource.getContents().add((Object)MapToEcoreActionDelegate.createMappingRoot(inputEPackage, outputEPackage));
                                try {
                                    mappingResource.save(null);
                                    IFile file = MapToEcoreActionDelegate.this.getFile(mappingResource);
                                    IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
                                    final IWorkbenchPart activePart = workbenchPage.getActivePart();
                                    if (activePart instanceof ISetSelectionTarget) {
                                        StructuredSelection targetSelection = new StructuredSelection((Object)file);
                                        workbenchWindow.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                                            private final /* synthetic */ ISelection val$targetSelection;
                                            {
                                                this.val$targetSelection = iSelection;
                                            }

                                            public void run() {
                                                ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                                            }
                                        });
                                    }
                                    try {
                                        workbenchPage.openEditor((IEditorInput)new FileEditorInput(file), workbenchWindow.getWorkbench().getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId());
                                    }
                                    catch (PartInitException pie) {
                                        Ecore2EcoreEditorPlugin.INSTANCE.log((Object)pie);
                                    }
                                }
                                catch (IOException ioe) {
                                    Ecore2EcoreEditorPlugin.INSTANCE.log(ioe);
                                }
                                ++i;
                            }
                        }
                        finally {
                            progressMonitor.done();
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ite) {
                Ecore2EcoreEditorPlugin.INSTANCE.log(ite);
            }
        }
    }

    protected static Ecore2EcoreMappingRoot createMappingRoot(EPackage inputEPackage, EPackage outputEPackage) {
        Ecore2EcoreMappingRoot mappingRoot = Ecore2EcoreFactory.eINSTANCE.createEcore2EcoreMappingRoot();
        mappingRoot.setTopToBottom(true);
        EcoreItemProviderAdapterFactory ecoreAdapterFactory = new EcoreItemProviderAdapterFactory();
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ResourceItemProviderAdapterFactory(), new MappingItemProviderAdapterFactory(), ecoreAdapterFactory});
        mappingRoot.setDomain((MappingDomain)new PluginAdapterFactoryMappingDomain((AdapterFactory)composedAdapterFactory, (AdapterFactory)ecoreAdapterFactory, null, null));
        mappingRoot.getInputs().add((Object)inputEPackage);
        mappingRoot.getOutputs().add((Object)outputEPackage);
        return mappingRoot;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(IStructuredSelection.class.isInstance(selection) && this.getInputEPackage((IStructuredSelection)selection) != null);
    }
}

