/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.viewer;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.validation.caret.IMovementMediator;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.jst.pagedesigner.viewer.LayoutPart;
import org.w3c.dom.Node;

public class CaretPositionResolver {
    private IPositionMediator _validator;
    private Point _point;
    private static CaretPositionResolver _instance;

    public static CaretPositionResolver getInstance(IPositionMediator validator, Point point) {
        if (_instance == null) {
            _instance = new CaretPositionResolver();
        }
        _instance.setPoint(point);
        _instance.setValidator(validator);
        return _instance;
    }

    private void setPoint(Point _point) {
        this._point = _point;
    }

    private void setValidator(IPositionMediator _validator) {
        this._validator = _validator;
    }

    static LayoutPart getCloserPart(LayoutPart part1, LayoutPart part2, Point _point) {
        Node n2;
        if (part1 == null || EditModelQuery.isTransparentText(Target.resolveNode(part1.getPart()))) {
            return part2;
        }
        if (part2 == null || EditModelQuery.isTransparentText(Target.resolveNode(part2.getPart()))) {
            return part1;
        }
        Rectangle rect1 = part1.getAbsoluteBounds();
        Rectangle rect2 = part2.getAbsoluteBounds();
        Node n1 = Target.resolveNode(part1.getPart());
        if (EditModelQuery.isChild(n1, n2 = Target.resolveNode(part2.getPart())) && CaretPositionResolver.getXDistance(rect2, _point) == 0 && !part1.isCloseToEdgeFromOutSide()) {
            return part2;
        }
        if (EditModelQuery.isChild(n2, n1) && CaretPositionResolver.getXDistance(rect1, _point) == 0 && !part2.isCloseToEdgeFromOutSide() && !part2.isCloseToEdgeFromOutSide()) {
            return part1;
        }
        if (rect1.intersect((Rectangle)new Rectangle((int)rect1.x, (int)rect2.y, (int)rect1.width, (int)rect2.height)).height == 0) {
            return CaretPositionResolver.heightFirst(part1, part2, _point);
        }
        return CaretPositionResolver.widthFirst(part1, part2, _point);
    }

    private static LayoutPart heightFirst(LayoutPart part1, LayoutPart part2, Point _point) {
        int offset2;
        Rectangle rect1 = part1.getAbsoluteBounds();
        Rectangle rect2 = part2.getAbsoluteBounds();
        int offset1 = Math.abs(CaretPositionResolver.getYDistance(rect1, _point));
        if (offset1 > (offset2 = Math.abs(CaretPositionResolver.getYDistance(rect2, _point)))) {
            return part2;
        }
        if (offset1 < offset2) {
            return part1;
        }
        offset1 = Math.abs(CaretPositionResolver.getXDistance(rect1, _point));
        if (offset1 >= (offset2 = Math.abs(CaretPositionResolver.getXDistance(rect2, _point)))) {
            return part2;
        }
        return part1;
    }

    private static LayoutPart widthFirst(LayoutPart part1, LayoutPart part2, Point _point) {
        int offset2;
        Rectangle rect1 = part1.getAbsoluteBounds();
        Rectangle rect2 = part2.getAbsoluteBounds();
        int offset1 = Math.abs(CaretPositionResolver.getXDistance(rect1, _point));
        if (offset1 > (offset2 = Math.abs(CaretPositionResolver.getXDistance(rect2, _point)))) {
            return part2;
        }
        if (offset1 < offset2) {
            return part1;
        }
        offset1 = Math.abs(CaretPositionResolver.getYDistance(rect1, _point));
        if (offset1 >= (offset2 = Math.abs(CaretPositionResolver.getYDistance(rect2, _point)))) {
            return part2;
        }
        return part1;
    }

    private LayoutPart getClosestChildPart(LayoutPart parent) {
        LayoutPart result = null;
        if (parent != null) {
            List children = null;
            children = parent.getPart().getChildren();
            if (children.size() > 0) {
                int i = 0;
                int n = children.size();
                while (i < n) {
                    LayoutPart nextPart = new LayoutPart((EditPart)children.get(i), this._point);
                    Target target = new Target(nextPart.getPart());
                    if (this._validator.isValidPosition(new DesignRefPosition(target.getPart(), false))) {
                        result = CaretPositionResolver.getCloserPart(result, nextPart, this._point);
                    } else if (this._validator.hasEditableArea(target)) {
                        LayoutPart temp = this.getClosestChildPart(nextPart);
                        if (temp == null) {
                            temp = nextPart;
                        }
                        result = CaretPositionResolver.getCloserPart(result, temp, this._point);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    LayoutPart resolveClosestPartFrom(LayoutPart closestPart) {
        Target target = new Target(closestPart.getPart());
        LayoutPart finalPart = null;
        if (EditModelQuery.isInline(Target.resolveNode(closestPart.getPart()))) {
            if (closestPart.isAfterPoint() || closestPart.isBeforePoint()) {
                finalPart = closestPart;
            } else if (this._validator.hasEditableArea(target) && (this._validator instanceof IMovementMediator && ((IMovementMediator)this._validator).allowsMoveIn(target) || !(this._validator instanceof IMovementMediator))) {
                finalPart = this.getClosestChildPartOrPart(closestPart);
            }
        } else if (closestPart.contains(this._point)) {
            if (this._validator.hasEditableArea(target) && (this._validator instanceof IMovementMediator && ((IMovementMediator)this._validator).allowsMoveIn(target) || !(this._validator instanceof IMovementMediator))) {
                finalPart = this.getClosestChildPartOrPart(closestPart);
            }
        } else if (this._validator.hasEditableArea(target) && !"table".equalsIgnoreCase(target.getNode().getNodeName()) && (this._validator instanceof IMovementMediator && ((IMovementMediator)this._validator).allowsMoveIn(target) || !(this._validator instanceof IMovementMediator))) {
            if (closestPart.atSameRow(this._point)) {
                finalPart = this.getClosestChildPartOrPart(closestPart);
            } else if (!this._validator.isValidPosition(new DesignRefPosition(target.getPart(), true))) {
                finalPart = this.getClosestChildPartOrPart(closestPart);
            }
        }
        if (finalPart == null && (this._validator.isValidPosition(new DesignRefPosition(target.getPart(), true)) || this._validator.isValidPosition(new DesignRefPosition(target.getPart(), false)))) {
            finalPart = closestPart;
        }
        return finalPart;
    }

    private LayoutPart getClosestChildPartOrPart(LayoutPart closestPart) {
        LayoutPart result = this.getClosestChildPart(closestPart);
        if (result != null) {
            result = this.resolveClosestPartFrom(result);
        } else if (closestPart.getConcretePart() == null) {
            result = closestPart;
        }
        return result;
    }

    public static int getXDistance(Rectangle rect, Point point) {
        if (rect.getRight().x <= point.x) {
            return point.x - rect.getRight().x;
        }
        if (rect.x >= point.x) {
            return point.x - rect.x;
        }
        if (rect.x <= point.x && point.x <= rect.getRight().x) {
            return 0;
        }
        return -1;
    }

    public static int toXMiddle(Rectangle rect, Point point) {
        return point.x - (rect.x + rect.getRight().x) / 2;
    }

    public static int toYMiddle(Rectangle rect, Point point) {
        return point.y - (rect.y + rect.getBottom().y) / 2;
    }

    public static int getYDistance(Rectangle rect, Point point) {
        if (rect.y + rect.height <= point.y) {
            return point.y - (rect.y + rect.height);
        }
        if (rect.y >= point.y) {
            return point.y - rect.y;
        }
        if (rect.y <= point.y && point.y <= rect.y + rect.height) {
            return 0;
        }
        return -1;
    }
}

