/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.utils.rcp.preferences;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.recommenders.internal.utils.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.utils.rcp.preferences.ContributionLink;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ContributionsReader {
    private static final String PREF_CONTRIBUTION_ID = "org.eclipse.recommenders.utils.rcp.linkContribution";
    private static final String CONTRIBUTION_ELEMENT = "linkContribution";
    private static final String PREF_PAGE_ID_ATTRIBUTE = "preferencePageId";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String COMMAND_ID_ATTRIBUTE = "commandId";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private static final String ICON_ATTRIBUTE = "icon";

    private ContributionsReader() {
    }

    public static List<ContributionLink> readContributionLinks(String preferencePageId) {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(PREF_CONTRIBUTION_ID);
        return ContributionsReader.readContributionLinks(preferencePageId, configurationElements);
    }

    @VisibleForTesting
    static List<ContributionLink> readContributionLinks(String preferencePageId, IConfigurationElement ... configurationElements) {
        ArrayList links = Lists.newArrayList();
        if (configurationElements == null) {
            return ImmutableList.of();
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            block2: {
                Image image;
                Integer priority;
                String commandIdAttribute;
                String labelAttribute;
                block9: {
                    block7: {
                        String iconAttribute;
                        block8: {
                            String pluginId;
                            IConfigurationElement configurationElement;
                            block6: {
                                block5: {
                                    block4: {
                                        block3: {
                                            configurationElement = iConfigurationElementArray[n2];
                                            if (!CONTRIBUTION_ELEMENT.equals(configurationElement.getName())) break block2;
                                            pluginId = configurationElement.getContributor().getName();
                                            String pageId = configurationElement.getAttribute(PREF_PAGE_ID_ATTRIBUTE);
                                            if (!preferencePageId.equals(pageId)) break block2;
                                            labelAttribute = configurationElement.getAttribute(LABEL_ATTRIBUTE);
                                            if (ContributionsReader.isValidAttribute(labelAttribute)) break block3;
                                            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_READ_EXTENSION_ATTRIBUTE, (Object[])new Object[]{LABEL_ATTRIBUTE, labelAttribute});
                                            break block2;
                                        }
                                        commandIdAttribute = configurationElement.getAttribute(COMMAND_ID_ATTRIBUTE);
                                        if (ContributionsReader.isValidAttribute(commandIdAttribute)) break block4;
                                        Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_READ_EXTENSION_ATTRIBUTE, (Object[])new Object[]{COMMAND_ID_ATTRIBUTE, commandIdAttribute});
                                        break block2;
                                    }
                                    String priorityAttribute = configurationElement.getAttribute(PRIORITY_ATTRIBUTE);
                                    if (priorityAttribute == null) break block5;
                                    priority = Ints.tryParse((String)priorityAttribute);
                                    if (priority != null) break block6;
                                    Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_READ_EXTENSION_ATTRIBUTE, (Object[])new Object[]{PRIORITY_ATTRIBUTE, priorityAttribute});
                                    break block2;
                                }
                                priority = Integer.MAX_VALUE;
                            }
                            if ((iconAttribute = configurationElement.getAttribute(ICON_ATTRIBUTE)) == null) break block7;
                            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconAttribute);
                            if (imageDescriptor == null) break block8;
                            image = imageDescriptor.createImage();
                            break block9;
                        }
                        Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_READ_EXTENSION_ATTRIBUTE, (Object[])new Object[]{ICON_ATTRIBUTE, iconAttribute});
                        break block2;
                    }
                    image = null;
                }
                links.add(new ContributionLink(labelAttribute, commandIdAttribute, priority, image));
            }
            ++n2;
        }
        Collections.sort(links);
        return ImmutableList.copyOf((Collection)links);
    }

    private static boolean isValidAttribute(String attribute) {
        return !Strings.isNullOrEmpty((String)attribute);
    }
}

