/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.utils.rcp.preferences;

import com.google.common.base.Preconditions;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.recommenders.internal.utils.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class ContributionLink
implements Comparable<ContributionLink> {
    private final String text;
    private final String commandId;
    private final int priority;
    private final Image icon;

    public ContributionLink(String text, String commandId, int priority, Image icon) {
        this.text = (String)Preconditions.checkNotNull((Object)text);
        this.commandId = (String)Preconditions.checkNotNull((Object)commandId);
        this.priority = (Integer)Preconditions.checkNotNull((Object)priority);
        this.icon = icon;
    }

    @Override
    public int compareTo(ContributionLink that) {
        return Integer.compare(this.getPriority(), that.getPriority());
    }

    public String getText() {
        return this.text;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getPriority() {
        return this.priority;
    }

    public Link appendLink(Composite content) {
        Label label = new Label(content, 1);
        label.setImage(this.icon);
        Link link = new Link(content, 1);
        link.setText(this.text);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContributionLink.this.executeCommand(ContributionLink.this.commandId, e.text);
            }
        });
        return link;
    }

    private void executeCommand(String commandId, String value) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Command command = commandService.getCommand(commandId);
        try {
            IParameter commandParmeter = command.getParameter("org.eclipse.recommenders.utils.rcp.linkContribution.href");
            if (commandParmeter == null) {
                handlerService.executeCommand(commandId, null);
            } else {
                Parameterization parameterization = new Parameterization(commandParmeter, value);
                ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, new Parameterization[]{parameterization});
                handlerService.executeCommand(parameterizedCommand, null);
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_EXECUTE_COMMAND, (Throwable)e, (Object[])new Object[]{commandId});
        }
    }
}

