/*
 * Decompiled with CFR 0.152.
 */
package minimatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import minimatch.Options;
import minimatch.PathAdapter;
import minimatch.internal.StringUtils;
import minimatch.internal.adapters.DefaultPathAdapter;
import minimatch.internal.parser.GlobStar;
import minimatch.internal.parser.LiteralItem;
import minimatch.internal.parser.MagicItem;
import minimatch.internal.parser.ParseContext;
import minimatch.internal.parser.ParseItem;
import minimatch.internal.parser.ParseResult;
import minimatch.internal.parser.PatternListItem;

public class Minimatch {
    private static final GlobStar GLOBSTAR = new GlobStar();
    private final String QMARK = "[^/]";
    private final String STAR = "[^/]*?";
    private final String TWO_STAR_DOT = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    private final String TWO_STAR_NO_DOT = "(?:(?!(?:\\/|^)\\.).)*?'";
    private final List<Character> reSpecials = StringUtils.asList("().*{}+?[]^$\\!".toCharArray());
    private static final Pattern hasBraces = Pattern.compile("\\{.*\\}");
    protected static final Pattern slashSplit = Pattern.compile("/+");
    protected String pattern;
    protected final Options options;
    protected boolean comment;
    protected boolean empty;
    protected boolean negate;
    private List<List<ParseItem>> set;

    public Minimatch(String pattern) {
        this(pattern, null);
    }

    public Minimatch(String pattern, Options options) {
        this.pattern = pattern.trim();
        this.options = Minimatch.getOptions(options);
        if (this.options.isAllowWindowsPaths()) {
            pattern = StringUtils.replacePath(pattern);
        }
        this.negate = false;
        this.comment = false;
        this.empty = false;
        this.make();
    }

    private void make() {
        String pattern = this.pattern;
        Options options = this.options;
        if (!options.isNocomment() && !pattern.isEmpty() && pattern.charAt(0) == '#') {
            this.comment = true;
            return;
        }
        if (pattern == null) {
            this.empty = true;
            return;
        }
        this.parseNegate();
        Object[] set = this.braceExpand(this.pattern, this.options);
        this.debug("%s %s", this.pattern, Arrays.toString(set));
        String[][] globParts = this.globParts((String[])set);
        this.debug("%s %s", this.pattern, this.toString(globParts));
        List<List<ParseItem>> results = this.globToRegExps(globParts);
        this.debug("%s %s", this.pattern, results);
        this.set = results;
    }

    private String toString(String[][] globParts) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object[] objectArray : globParts) {
            sb.append(Arrays.toString(objectArray));
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    private String[][] globParts(String[] set) {
        String[][] parts = new String[set.length][];
        for (int i = 0; i < set.length; ++i) {
            parts[i] = slashSplit.split(set[i], Integer.MAX_VALUE);
        }
        return parts;
    }

    private List<List<ParseItem>> globToRegExps(String[][] globParts) {
        String[] s = null;
        ArrayList<List<ParseItem>> parts = new ArrayList<List<ParseItem>>();
        ArrayList<ParseItem> p = null;
        for (int i = 0; i < globParts.length; ++i) {
            s = globParts[i];
            p = new ArrayList<ParseItem>();
            parts.add(p);
            for (int j = 0; j < s.length; ++j) {
                p.add(this.parse(s[j], false).getItem());
            }
        }
        return parts;
    }

    private ParseResult parse(String pattern, boolean isSub) {
        Options options = this.options;
        if (!options.isNoglobstar() && "**".equals(pattern)) {
            return new ParseResult(GLOBSTAR, false);
        }
        if (StringUtils.isEmpty(pattern)) {
            return new ParseResult(ParseItem.Empty, false);
        }
        ParseContext ctx = new ParseContext();
        ctx.re = "";
        ctx.hasMagic = options.isNocase();
        boolean escaping = false;
        Stack<PatternListItem> patternListStack = new Stack<PatternListItem>();
        Stack<PatternListItem> negativeListStack = new Stack<PatternListItem>();
        boolean inClass = false;
        int reClassStart = -1;
        int classStart = -1;
        String patternStart = pattern.charAt(0) == '.' ? "" : (options.isDot() ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)");
        block19: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            this.debug("%s\t%s %s \"%c\"", pattern, i, ctx.re, Character.valueOf(c));
            if (escaping && this.reSpecials.contains(Character.valueOf(c))) {
                ctx.re = ctx.re + "\\" + c;
                escaping = false;
                continue;
            }
            switch (c) {
                case '/': {
                    return null;
                }
                case '\\': {
                    this.clearStateChar(ctx);
                    escaping = true;
                    continue block19;
                }
                case '!': 
                case '*': 
                case '+': 
                case '?': 
                case '@': {
                    this.debug("%s\t%s %s \"%c\" <-- stateChar", pattern, i, ctx.re, Character.valueOf(c));
                    if (inClass) {
                        this.debug("  in class", new Object[0]);
                        if (c == '!' && i == classStart + 1) {
                            c = '^';
                        }
                        ctx.re = ctx.re + c;
                        continue block19;
                    }
                    this.debug("call clearStateChar \"%c\"", ctx.stateChar);
                    this.clearStateChar(ctx);
                    ctx.stateChar = Character.valueOf(c);
                    if (!options.isNoext()) continue block19;
                    this.clearStateChar(ctx);
                    continue block19;
                }
                case '(': {
                    if (inClass) {
                        ctx.re = ctx.re + "(";
                        continue block19;
                    }
                    if (ctx.stateChar == null) {
                        ctx.re = ctx.re + "\\(";
                        continue block19;
                    }
                    char plType = ctx.stateChar.charValue();
                    patternListStack.push(new PatternListItem(plType, i - 1, ctx.re.length()));
                    ctx.re = ctx.re + (ctx.stateChar.charValue() == '!' ? "(?:(?!(?:" : "(?:");
                    this.debug("plType \"%c\" \"%s\"", ctx.stateChar, ctx.re);
                    ctx.stateChar = null;
                    continue block19;
                }
                case ')': {
                    if (inClass || patternListStack.size() == 0) {
                        ctx.re = ctx.re + "\\)";
                        continue block19;
                    }
                    this.clearStateChar(ctx);
                    ctx.hasMagic = true;
                    ctx.re = ctx.re + ")";
                    PatternListItem pl = (PatternListItem)patternListStack.pop();
                    char plType = pl.type;
                    switch (plType) {
                        case '!': {
                            negativeListStack.push(pl);
                            ctx.re = ctx.re + ")[^/]*?)";
                            pl.reEnd = ctx.re.length();
                            continue block19;
                        }
                        case '*': 
                        case '+': 
                        case '?': {
                            ctx.re = ctx.re + plType;
                            continue block19;
                        }
                    }
                    continue block19;
                }
                case '|': {
                    if (inClass || patternListStack.size() == 0 || escaping) {
                        ctx.re = ctx.re + "\\|";
                        escaping = false;
                        continue block19;
                    }
                    this.clearStateChar(ctx);
                    ctx.re = ctx.re + '|';
                    continue block19;
                }
                case '[': {
                    this.clearStateChar(ctx);
                    if (inClass) {
                        ctx.re = ctx.re + (92 + c);
                        continue block19;
                    }
                    inClass = true;
                    classStart = i;
                    reClassStart = ctx.re.length();
                    ctx.re = ctx.re + c;
                    continue block19;
                }
                case ']': {
                    if (i == classStart + 1 || !inClass) {
                        ctx.re = ctx.re + "\\" + c;
                        escaping = false;
                        continue block19;
                    }
                    if (inClass) {
                        String cs = pattern.substring(classStart + 1, i);
                        try {
                            Pattern.compile("[" + cs + "]");
                        }
                        catch (Throwable e) {
                            ParseResult sp = this.parse(cs, true);
                            ctx.re = ctx.re.substring(0, reClassStart) + "\\[" + sp.getItem().getSource() + "\\]";
                            ctx.hasMagic = ctx.hasMagic || sp.isB();
                            inClass = false;
                            continue block19;
                        }
                    }
                    ctx.hasMagic = true;
                    inClass = false;
                    ctx.re = ctx.re + c;
                    continue block19;
                }
                default: {
                    this.clearStateChar(ctx);
                    if (escaping) {
                        escaping = false;
                    } else if (this.reSpecials.contains(Character.valueOf(c)) && (c != '^' || !inClass)) {
                        ctx.re = ctx.re + "\\";
                    }
                    ctx.re = ctx.re + c;
                }
            }
        }
        if (inClass) {
            String cs = pattern.substring(classStart + 1);
            ParseResult sp = this.parse(cs, true);
            ctx.re = ctx.re.substring(0, reClassStart) + "\\[" + sp.getItem().getSource();
            boolean bl = ctx.hasMagic = ctx.hasMagic || sp.isB();
        }
        while (!patternListStack.isEmpty()) {
            PatternListItem pl = (PatternListItem)patternListStack.pop();
            String tail = ctx.re.substring(pl.reStart + 3);
            Pattern p = Pattern.compile("((?:\\\\{2})*)(\\\\?)\\|");
            Matcher m = p.matcher(tail);
            StringBuilder sb = new StringBuilder();
            int lastEnd = 0;
            while (m.find()) {
                String g1 = m.group(1);
                String g2 = m.group(2);
                if (g2 == null || g2.isEmpty()) {
                    g2 = "\\";
                }
                sb.append(tail.substring(lastEnd, m.start()));
                sb.append(g1 + g1 + g2 + "|");
                lastEnd = m.end();
            }
            sb.append(tail.substring(lastEnd));
            tail = sb.toString();
            this.debug("tail=%s\n   %s", tail, tail);
            String t = "*".equals(Character.valueOf(pl.type)) ? "[^/]*?" : ("?".equals(Character.valueOf(pl.type)) ? "[^/]" : "\\" + pl.type);
            ctx.hasMagic = true;
            ctx.re = ctx.re.substring(0, pl.reStart) + t + "\\(" + tail;
        }
        this.clearStateChar(ctx);
        if (escaping) {
            ctx.re = ctx.re + "\\\\";
        }
        boolean addPatternStart = false;
        switch (ctx.re.charAt(0)) {
            case '(': 
            case '.': 
            case '[': {
                addPatternStart = true;
            }
        }
        while (!negativeListStack.isEmpty()) {
            String newRe;
            PatternListItem nl = (PatternListItem)negativeListStack.pop();
            String nlBefore = ctx.re.substring(0, nl.reStart);
            String nlFirst = ctx.re.substring(nl.reStart, nl.reEnd - 8);
            String nlLast = ctx.re.substring(nl.reEnd - 8, nl.reEnd);
            String nlAfter = ctx.re.substring(nl.reEnd);
            nlLast = nlLast + nlAfter;
            int openParensBefore = nlBefore.split("\\(").length - 1;
            String cleanAfter = nlAfter;
            for (int i = 0; i < openParensBefore; ++i) {
                cleanAfter = cleanAfter.replaceAll("\\)[+*?]?", "");
            }
            nlAfter = cleanAfter;
            String dollar = "";
            if (nlAfter.isEmpty() && !isSub) {
                dollar = "$";
            }
            ctx.re = newRe = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        }
        if (!StringUtils.isEmpty(ctx.re) && ctx.hasMagic) {
            ctx.re = "(?=.)" + ctx.re;
        }
        if (addPatternStart) {
            ctx.re = patternStart + ctx.re;
        }
        if (isSub) {
            return new ParseResult(new LiteralItem(ctx.re), ctx.hasMagic);
        }
        if (!ctx.hasMagic) {
            return new ParseResult(new LiteralItem(StringUtils.globUnescape(pattern)), false);
        }
        return new ParseResult(new MagicItem(ctx.re, options), false);
    }

    protected void debug(String pattern, Object ... arguments) {
        if (this.options.isDebug()) {
            this.options.getDebugger().debug(pattern, arguments);
        }
    }

    private void clearStateChar(ParseContext ctx) {
        if (ctx.stateChar != null) {
            switch (ctx.stateChar.charValue()) {
                case '*': {
                    ctx.re = ctx.re + "[^/]*?";
                    ctx.hasMagic = true;
                    break;
                }
                case '?': {
                    ctx.re = ctx.re + "[^/]";
                    ctx.hasMagic = true;
                    break;
                }
                default: {
                    ctx.re = ctx.re + "\\" + ctx.stateChar;
                }
            }
            this.debug("clearStateChar \"%c\" \"%s\"", ctx.stateChar, ctx.re);
            ctx.stateChar = null;
        }
    }

    private void parseNegate() {
        String pattern = this.pattern;
        boolean negate = false;
        Options options = this.options;
        int negateOffset = 0;
        if (options.isNonegate()) {
            return;
        }
        int l = pattern.length();
        for (int i = 0; i < l && pattern.charAt(i) == '!'; ++i) {
            negate = !negate;
            ++negateOffset;
        }
        if (negateOffset > 0) {
            this.pattern = pattern.substring(negateOffset);
        }
        this.negate = negate;
    }

    private String[] braceExpand(String pattern, Options options) {
        if (options.isNobrace() || !StringUtils.matches(hasBraces, pattern)) {
            return new String[]{pattern};
        }
        return this.expand(pattern);
    }

    private String[] expand(String pattern) {
        return new String[]{pattern};
    }

    private boolean match(List<String> f, boolean partial) {
        int i;
        Options options = this.options;
        List<List<ParseItem>> set = this.set;
        this.debug("%s %s %s", this.pattern, "set", set);
        String filename = null;
        for (i = f.size() - 1; i >= 0 && StringUtils.isEmpty(filename = f.get(i)); --i) {
        }
        for (i = 0; i < set.size(); ++i) {
            boolean hit;
            List<ParseItem> pattern = set.get(i);
            List<String> file = f;
            if (options.isMatchBase() && pattern.size() == 1) {
                file = new ArrayList<String>();
                file.add(filename);
            }
            if (!(hit = this.matchOne(file, pattern, partial))) continue;
            if (options.isFlipNegate()) {
                return true;
            }
            return !this.negate;
        }
        if (options.isFlipNegate()) {
            return false;
        }
        return this.negate;
    }

    protected static Options getOptions(Options options) {
        return options == null ? Options.DEFAULT : options;
    }

    private <T> boolean matchOne(List<String> file, List<ParseItem> pattern, boolean partial) {
        int pi;
        Options options = this.options;
        this.debug("matchOne\n\tOptions: %s\n\tfile: %s\n\tpattern: %s", options, file, pattern);
        this.debug("matchOne %s %s", file.size(), pattern.size());
        int fi = 0;
        int fl = file.size();
        int pl = pattern.size();
        for (pi = 0; fi < fl && pi < pl; ++fi, ++pi) {
            this.debug("matchOne loop", new Object[0]);
            ParseItem p = pattern.get(pi);
            String f = file.get(fi);
            this.debug("%s %s %s", pattern, p, f);
            if (p == null) {
                return false;
            }
            if (p instanceof GlobStar) {
                int fr;
                this.debug("GLOBSTAR [%s, %s, %s]", pattern, p, f);
                int pr = pi + 1;
                if (pr == pl) {
                    this.debug("** at the end", new Object[0]);
                    while (fi < fl) {
                        String fileitem = file.get(fi);
                        if (fileitem.equals(".") || fileitem.equals("..") || !options.isDot() && fileitem.length() > 0 && fileitem.charAt(0) == '.') {
                            return false;
                        }
                        ++fi;
                    }
                    return true;
                }
                for (fr = fi; fr < fl; ++fr) {
                    String swallowee = file.get(fr);
                    this.debug("\nglobstar while %s %s %s %s %s", file, fr, pattern, pr, swallowee);
                    if (this.matchOne(file.subList(fr, file.size()), pattern.subList(pr, pattern.size()), partial)) {
                        this.debug("globstar found match! %s %s %s", fr, fl, swallowee);
                        return true;
                    }
                    if (swallowee.equals(".") || swallowee.equals("..") || !options.isDot() && swallowee.charAt(0) == '.') {
                        this.debug("dot detected! %s %s %s %s", file, fr, pattern, pr);
                        break;
                    }
                    this.debug("globstar swallow a segment, and continue", new Object[0]);
                }
                if (partial) {
                    this.debug("\n>>> no match, partial? %s %s %s %s", file, fr, pattern, pr);
                    if (fr == fl) {
                        return true;
                    }
                }
                return false;
            }
            if (!p.match(f, options)) {
                this.debug("pattern match %s %s false", p, f);
                return false;
            }
            this.debug("pattern match %s %s true", p, f);
        }
        if (fi == fl && pi == pl) {
            return true;
        }
        if (fi == fl) {
            return partial;
        }
        if (pi == pl) {
            boolean emptyFileEnd = fi == fl - 1 && file.get(fi).equals("");
            return emptyFileEnd;
        }
        throw new IllegalStateException("wtf?");
    }

    public static boolean minimatch(String p, String pattern) {
        return Minimatch.minimatch(p, pattern, null);
    }

    public static boolean minimatch(String p, String pattern, Options options) {
        if ((options = Minimatch.getOptions(options)) == null) {
            options = Options.DEFAULT;
        }
        if (!options.isNocomment() && pattern.charAt(0) == '#') {
            return false;
        }
        if (StringUtils.isEmpty(pattern.trim())) {
            return "".equals(p);
        }
        return new Minimatch(pattern, options).match(p);
    }

    public boolean match(String p) {
        return this.match(p, false);
    }

    public boolean match(String input, boolean partial) {
        return this.match(input, DefaultPathAdapter.INSTANCE, partial);
    }

    public <T> boolean match(T f, PathAdapter<T> adapter) {
        return this.match(f, adapter, false);
    }

    public <T> boolean match(T input, PathAdapter<T> adapter, boolean partial) {
        this.debug("match %s %s", input, this.pattern);
        if (this.comment) {
            return false;
        }
        List<String> file = adapter.toArray(input, this.options);
        if (this.empty) {
            return file.isEmpty();
        }
        this.debug("%s %s %s", this.pattern, "split", file);
        return this.match(file, partial);
    }
}

