/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.jboss.tools.jst.web.kb.taglib.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.PagePaletteContents;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteCategory;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteVersionGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.HTML5DynamicPaletteGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteCountManager;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteDrawerImpl;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteRootImpl;
import org.jboss.tools.jst.web.ui.palette.model.IPaletteModel;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;

public class PaletteModelImpl
implements IPaletteModel {
    private static String POINT_ID = "org.jboss.tools.jst.web.ui.PaletteGroup";
    public static final String DYNAMIC_PALETTE_GROUP = "Dynamic Palette Group";
    private HashMap<String, IPaletteGroup> paletteGroupMap = null;
    private ArrayList<IPaletteGroup> sortedPaletteGroups = null;
    private PaletteRoot paletteRoot = null;
    private PagePaletteContents paletteContents;

    @Override
    public PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.load();
        }
        return this.paletteRoot;
    }

    @Override
    public void load() {
        this.sortedPaletteGroups = PaletteModelImpl.loadPaletteGroups();
        this.paletteGroupMap = new HashMap();
        String expandedCategory = this.getPreferredExpandedCategory();
        this.paletteRoot = new PaletteRootImpl(this);
        HTML5DynamicPaletteGroup dynamicPaletteGroup = null;
        for (IPaletteGroup paletteGroup : this.sortedPaletteGroups) {
            if (!(paletteGroup instanceof HTML5DynamicPaletteGroup)) {
                this.loadPaletteGroup(paletteGroup, expandedCategory);
                continue;
            }
            dynamicPaletteGroup = (HTML5DynamicPaletteGroup)paletteGroup;
        }
        if (dynamicPaletteGroup != null) {
            this.loadPaletteGroup(dynamicPaletteGroup, expandedCategory);
        }
    }

    private void loadPaletteGroup(IPaletteGroup paletteGroup, String expandedCategory) {
        paletteGroup.setPaletteModel(this);
        String groupName = paletteGroup.getName();
        if (paletteGroup instanceof HTML5DynamicPaletteGroup) {
            groupName = DYNAMIC_PALETTE_GROUP;
            this.calculateCounts((HTML5DynamicPaletteGroup)paletteGroup);
        }
        this.paletteGroupMap.put(groupName, paletteGroup);
        IHTMLLibraryVersion version = this.getSelectedVersion(paletteGroup);
        paletteGroup.setSelectedVersion(version);
        PaletteDrawerImpl drawer = new PaletteDrawerImpl(paletteGroup);
        if (expandedCategory != null && expandedCategory.equals(groupName)) {
            drawer.setInitialState(0);
        } else {
            drawer.setInitialState(1);
        }
        if (paletteGroup instanceof HTML5DynamicPaletteGroup) {
            this.paletteRoot.add(0, (PaletteEntry)drawer);
        } else {
            this.paletteRoot.add((PaletteEntry)drawer);
        }
    }

    private HTML5DynamicPaletteGroup getDynamicPaletteGroup() {
        return (HTML5DynamicPaletteGroup)this.paletteGroupMap.get(DYNAMIC_PALETTE_GROUP);
    }

    public static ArrayList<IPaletteGroup> loadPaletteGroups() {
        TreeMap<String, IPaletteGroup> groupsByOrderId = new TreeMap<String, IPaletteGroup>();
        HTML5DynamicPaletteGroup dynamicGroup = new HTML5DynamicPaletteGroup();
        groupsByOrderId.put("AAA", dynamicGroup);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IPaletteGroup paletteGroup = PaletteModelImpl.createPaletteGroupInstance(element);
            if (paletteGroup != null && paletteGroup.isEnabled()) {
                String orderId = element.getAttribute("orderId");
                if (orderId == null) {
                    orderId = paletteGroup.getName();
                }
                groupsByOrderId.put(orderId, paletteGroup);
                dynamicGroup.add(paletteGroup.getImageDescriptor());
            }
            ++n2;
        }
        return new ArrayList<IPaletteGroup>(groupsByOrderId.values());
    }

    public String[] getPaletteGroups() {
        if (this.sortedPaletteGroups == null) {
            this.load();
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        for (IPaletteGroup group : this.sortedPaletteGroups) {
            if (group instanceof HTML5DynamicPaletteGroup) continue;
            groupNames.add(group.getName());
        }
        return groupNames.toArray(new String[0]);
    }

    public IPaletteGroup getPaletteGroup(String name) {
        if (this.paletteGroupMap == null) {
            this.load();
        }
        return this.paletteGroupMap.get(name);
    }

    private IHTMLLibraryVersion getSelectedVersion(IPaletteGroup paletteGroup) {
        IHTMLLibraryVersion version = null;
        if (this.paletteContents != null) {
            version = this.paletteContents.getVersion(paletteGroup.getName());
        }
        if (version == null) {
            version = paletteGroup.getLastVersionGroup().getVersion();
        }
        return version;
    }

    private static IPaletteGroup createPaletteGroupInstance(IConfigurationElement element) {
        try {
            Object o = element.createExecutableExtension("class");
            if (o instanceof IPaletteGroup) {
                return (IPaletteGroup)o;
            }
            WebUiPlugin.getDefault().logError("Palette Group " + element.getAttribute("class") + " should implement IPaletteGroup.");
        }
        catch (CoreException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        return null;
    }

    @Override
    public String getType() {
        return IPaletteModel.TYPE_HTML5;
    }

    @Override
    public void setPaletteContents(PagePaletteContents paletteContents) {
        this.paletteContents = paletteContents;
    }

    @Override
    public PagePaletteContents getPaletteContents() {
        return this.paletteContents;
    }

    @Override
    public void onCategoryExpandChange(String name, boolean state) {
        IFile file = this.getFile();
        if (file != null && state) {
            try {
                file.setPersistentProperty(PaletteModel.HTML5_EXPANDED_CATEGORY_NAME, name);
            }
            catch (CoreException e) {
                WebUiPlugin.getDefault().logError(e);
            }
            WebUiPlugin.getDefault().getPreferenceStore().setValue(PaletteModel.HTML5_EXPANDED_CATEGORY, name);
        }
    }

    @Override
    public String getPreferredExpandedCategory() {
        IFile file = this.getFile();
        if (file != null) {
            try {
                String s = file.getPersistentProperty(PaletteModel.HTML5_EXPANDED_CATEGORY_NAME);
                if (s == null || s.length() == 0) {
                    s = WebUiPlugin.getDefault().getPreferenceStore().getString(PaletteModel.HTML5_EXPANDED_CATEGORY);
                    if (s == null || s.length() == 0) {
                        s = "jQuery Mobile";
                    }
                    file.setPersistentProperty(PaletteModel.HTML5_EXPANDED_CATEGORY_NAME, s);
                } else {
                    WebUiPlugin.getDefault().getPreferenceStore().setValue(PaletteModel.HTML5_EXPANDED_CATEGORY, s);
                }
                return s;
            }
            catch (CoreException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }
        return null;
    }

    public void reloadCategory() {
        for (Object child : this.paletteRoot.getChildren()) {
            if (!(child instanceof PaletteDrawerImpl)) continue;
            PaletteDrawerImpl drawer = (PaletteDrawerImpl)((Object)child);
            IHTMLLibraryVersion newVersion = this.getSelectedVersion(drawer.getPaletteGroup());
            if (drawer.getVersion().equals(newVersion)) continue;
            drawer.loadVersion(newVersion);
        }
    }

    private void calculateCounts(HTML5DynamicPaletteGroup dynamicPaletteGroup) {
        for (IPaletteGroup paletteGroup : this.sortedPaletteGroups) {
            if (paletteGroup instanceof HTML5DynamicPaletteGroup) continue;
            for (IPaletteVersionGroup versionGroup : paletteGroup.getPaletteVersionGroups()) {
                for (IPaletteCategory category : versionGroup.getCategories()) {
                    for (IPaletteItem item : category.getItems()) {
                        this.loadItemCounts(item.getId());
                        dynamicPaletteGroup.add(item);
                    }
                }
            }
        }
    }

    public void clearDynamicGroup() {
        HTML5DynamicPaletteGroup dynamicPaletteGroup = this.getDynamicPaletteGroup();
        for (IPaletteItem item : dynamicPaletteGroup.getAllItems()) {
            item.setCountIndex(0L);
            item.setNumberOfCalls(0L);
        }
        this.setProjectCountIndex(0L);
        this.saveAllItemsCount();
        this.refreshDynamicGroup();
    }

    private void refreshDynamicGroup() {
        for (Object child : this.paletteRoot.getChildren()) {
            PaletteDrawerImpl drawer;
            if (!(child instanceof PaletteDrawerImpl) || !((drawer = (PaletteDrawerImpl)((Object)child)).getPaletteGroup() instanceof HTML5DynamicPaletteGroup)) continue;
            drawer.loadVersion(drawer.getPaletteGroup().getSelectedVersionGroup().getVersion());
            return;
        }
    }

    public long getCountIndex(String id) {
        IFile file = this.getFile();
        if (file != null) {
            return PaletteCountManager.getInstance().getCountIndex(file.getProject(), id);
        }
        return 0L;
    }

    public void setCountIndex(String id, long countIndex) {
        IFile file = this.getFile();
        if (file != null) {
            PaletteCountManager.getInstance().setCountIndex(file.getProject(), id, countIndex);
        }
    }

    public void setProjectCountIndex(long countIndex) {
        IFile file = this.getFile();
        if (file != null) {
            PaletteCountManager.getInstance().setProjectCountIndex(file.getProject(), countIndex);
        }
    }

    public long getNumberOfCalls(String id) {
        IFile file = this.getFile();
        if (file != null) {
            return PaletteCountManager.getInstance().getNumberOfCalls(file.getProject(), id);
        }
        return 0L;
    }

    public void setNumberOfCalls(String id, long numberOfCalls) {
        IFile file = this.getFile();
        if (file != null) {
            PaletteCountManager.getInstance().setNumberOfCalls(file.getProject(), id, numberOfCalls);
        }
    }

    public void itemCalled(String id) {
        IFile file = this.getFile();
        if (file != null) {
            PaletteCountManager.getInstance().called(file.getProject(), id);
            if (PaletteCountManager.getInstance().getNumberOfCalls(file.getProject(), id) == Long.MAX_VALUE || PaletteCountManager.getInstance().getCountIndex(file.getProject(), id) == Long.MAX_VALUE) {
                HTML5DynamicPaletteGroup dynamicPaletteGroup = this.getDynamicPaletteGroup();
                dynamicPaletteGroup.initCounts();
                this.saveAllItemsCount();
            } else {
                this.saveItemCounts(id);
            }
            this.refreshDynamicGroup();
        }
    }

    public void loadItemCounts(String id) {
        IFile file = this.getFile();
        if (file != null) {
            PaletteCountManager.getInstance().load(file.getProject(), id);
        }
    }

    public void saveItemCounts(String id) {
        IFile file = this.getFile();
        if (file != null) {
            PaletteCountManager.getInstance().save(file.getProject(), id);
        }
    }

    public void saveAllItemsCount() {
        IFile file = this.getFile();
        if (file != null) {
            PaletteCountManager.getInstance().saveAll(file.getProject());
        }
    }

    private IFile getFile() {
        return this.paletteContents != null ? this.paletteContents.getFile() : null;
    }
}

