/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.wizard.HTMLConstants;
import org.jboss.tools.jst.web.ui.palette.html.wizard.NewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.internal.html.html5.wizard.NewListWizardPage;

public class NewListWizard
extends NewHTMLWidgetWizard<NewListWizardPage>
implements HTMLConstants {
    protected static String prefix = "list-";

    public NewListWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.LIST_IMAGE));
    }

    @Override
    protected NewListWizardPage createPage() {
        return new NewListWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        String tagName = this.isTrue("ordered-list") ? "ol" : "ul";
        IElementGenerator.ElementNode list = parent.addChild(tagName);
        this.addID(prefix, list);
        if ("ol".equals(tagName)) {
            this.addAttributeIfNotEmpty(list, "type", "type");
            this.addAttributeIfNotEmpty(list, "start", "start");
            if (this.isTrue("reversed")) {
                list.addAttribute("reversed", "reversed");
            }
        }
        int i = 0;
        while (i < ((NewListWizardPage)this.page).items.getNumber()) {
            String value;
            String text = ((NewListWizardPage)this.page).items.getLabel(i);
            IElementGenerator.ElementNode li = list.addChild("li", text);
            if ("ol".equals(tagName) && (value = ((NewListWizardPage)this.page).items.getValue(i)).length() > 0) {
                li.addAttribute("value", value);
            }
            ++i;
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode div = body.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

