/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import java.beans.PropertyChangeEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.ui.editors.dnd.ValidationException;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.LayoutUtil;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.WizardDescriptions;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public class NewTextInputWizardPage
extends NewJQueryWidgetWizardPage {
    public NewTextInputWizardPage() {
        super("newText", WizardMessages.newTextInputWizardTitle);
        this.setDescription(WizardMessages.newTextInputWizardDescription);
    }

    @Override
    protected void createFieldPanel(Composite parent) {
        GridData d;
        IFieldEditor type = JQueryFieldEditorFactory.createTextTypeEditor();
        this.addEditor(type, parent);
        IFieldEditor label = JQueryFieldEditorFactory.createLabelEditor();
        label.setValue((Object)"Input:");
        this.addEditor(label, parent);
        this.createIDEditor(parent, false);
        IFieldEditor value = JQueryFieldEditorFactory.createValueEditor();
        this.addEditor(value, parent);
        IFieldEditor pattern = JQueryFieldEditorFactory.createPatternEditor();
        this.addEditor(pattern, parent);
        LayoutUtil.TwoColumns columns = NewTextInputWizardPage.createTwoColumns(parent);
        this.addEditor(JQueryFieldEditorFactory.createPlaceholderEditor(), columns.left());
        IFieldEditor maxlength = JQueryFieldEditorFactory.createMaxlengthEditor();
        this.addEditor(maxlength, columns.right());
        if (parent != null) {
            Object[] cs = maxlength.getEditorControls();
            d = (GridData)((Text)cs[1]).getLayoutData();
            d.widthHint = 20;
            ((Text)cs[1]).setLayoutData((Object)d);
        }
        Group panel = null;
        if (parent != null) {
            panel = new Group(parent, 2048);
            panel.setText(WizardMessages.inputTypeNumberLabel);
            d = new GridData(768);
            d.horizontalSpan = 3;
            panel.setLayoutData((Object)d);
            panel.setLayout((Layout)new GridLayout(3, false));
        }
        Composite[] columns3 = NewTextInputWizardPage.createColumns(panel, 3);
        IFieldEditor min = JQueryFieldEditorFactory.createMinEditor(WizardDescriptions.textInputMin);
        min.setValue((Object)"");
        this.addEditor(min, columns3[0]);
        IFieldEditor max = JQueryFieldEditorFactory.createMaxEditor(WizardDescriptions.textInputMax);
        max.setValue((Object)"");
        this.addEditor(max, columns3[1]);
        IFieldEditor step = JQueryFieldEditorFactory.createStepEditor(WizardDescriptions.textInputStep);
        this.addEditor(step, columns3[2]);
        this.createSeparator(parent);
        columns3 = NewTextInputWizardPage.createColumns(parent, 3);
        this.addEditor(JQueryFieldEditorFactory.createClearInputEditor(), columns3[0]);
        this.addEditor(JQueryFieldEditorFactory.createMiniEditor(), columns3[1]);
        this.addEditor(JQueryFieldEditorFactory.createRequiredEditor(), columns3[2]);
        this.addEditor(JQueryFieldEditorFactory.createHideLabelEditor(), columns3[0]);
        this.addEditor(JQueryFieldEditorFactory.createDisabledEditor(), columns3[1]);
        this.addEditor(JQueryFieldEditorFactory.createAutofocusEditor(), columns3[2]);
        IFieldEditor layout = JQueryFieldEditorFactory.createLayoutEditor();
        this.addEditor(layout, parent);
        this.createSeparator(parent);
        IFieldEditor theme = JQueryFieldEditorFactory.createDataThemeEditor(this.getVersion());
        this.addEditor(theme, parent, true);
        this.updateNumberFieldsEnablement();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("text-type".equals(evt.getPropertyName())) {
            this.updateNumberFieldsEnablement();
        }
        super.propertyChange(evt);
    }

    void updateNumberFieldsEnablement() {
        boolean isNumber = "number".equals(this.getEditorValue("text-type"));
        this.setEnabled("min", isNumber);
        this.setEnabled("max", isNumber);
        this.setEnabled("step", isNumber);
    }

    @Override
    public void validate() throws ValidationException {
        String pattern = this.getEditorValue("pattern");
        if (pattern.length() > 0) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new ValidationException(e.getMessage());
            }
        }
        super.validate();
    }
}

