/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.navigator;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.jboss.tools.common.model.XModelBuffer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.ActionDeclinedException;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.common.reporting.ProblemReportingHelper;

public class XDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object target) {
        if (!(target instanceof XModelObject)) {
            return Status.CANCEL_STATUS;
        }
        XModelObject targetObject = (XModelObject)target;
        ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
        if (s == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return Status.CANCEL_STATUS;
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        Object o1 = ss.getFirstElement();
        if (!(o1 instanceof XModelObject)) {
            return Status.CANCEL_STATUS;
        }
        Properties p = new Properties();
        p.setProperty("isDrop", "true");
        if (DnDUtil.isPasteEnabled((XModelObject)targetObject)) {
            try {
                DnDUtil.paste((XModelObject)targetObject, (Properties)p);
            }
            catch (ActionDeclinedException actionDeclinedException) {
                return null;
            }
            catch (XModelException e) {
                ProblemReportingHelper.reportProblem((String)"org.jboss.tools.common.model.ui", (Throwable)e);
            }
        }
        return null;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (!(target instanceof XModelObject)) {
            return Status.CANCEL_STATUS;
        }
        XModelObject targetObject = (XModelObject)target;
        if (this.isSupportedType(transferType)) {
            ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
            if (s == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
                return Status.CANCEL_STATUS;
            }
            IStructuredSelection ss = (IStructuredSelection)s;
            Object o1 = ss.getFirstElement();
            if (!(o1 instanceof XModelObject)) {
                return Status.CANCEL_STATUS;
            }
            XModelObject source = (XModelObject)o1;
            if (DnDUtil.getEnabledCopyAction((XModelObject)source, null) == null) {
                return Status.CANCEL_STATUS;
            }
            XModelBuffer b = source.getModel().getModelBuffer();
            b.clear();
            b.addSource(source);
            if (DnDUtil.getEnabledPasteAction((XModelObject)targetObject) == null) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }
}

