/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JSPForBeanIdHyperlinkPartitioner
extends AbstractHyperlinkPartitioner {
    public static final String JSP_FOR_BEAN_ID_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_FOR_BEAN_ID";

    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            IHyperlinkRegion r = JSPForBeanIdHyperlinkPartitioner.getRegion(document, offset);
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, offset);
            String contentType = superRegion.getContentType();
            String type = JSP_FOR_BEAN_ID_PARTITION;
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(r.getOffset(), r.getLength(), axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, int offset) {
        return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis(document, offset)) + "/";
    }

    public static IHyperlinkRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > offset) {
                return null;
            }
            String attrText = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = 0;
            int bEnd = attrText.length() - 1;
            while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
                ++bStart;
            }
            while (bEnd > bStart && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength, null, null, null);
            return hyperlinkRegion;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

