/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.wst.sse.ui.views.properties.PropertySheetConfiguration;
import org.jboss.tools.jst.web.ui.internal.editor.outline.IFormPropertySheetPage;
import org.jboss.tools.jst.web.ui.internal.properties.FormPropertySheetModel;
import org.jboss.tools.jst.web.ui.internal.properties.FormPropertySheetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySheetModel;
import org.jboss.tools.jst.web.ui.internal.properties.RemoveAction;

public class FormPropertySheetPage
extends Page
implements IFormPropertySheetPage,
IPropertySheetPage,
IAdaptable {
    private IPropertySheetModel model;
    private FormPropertySheetViewer viewer;
    private IWorkbenchPart sourcePart;
    private PartListener partListener = new PartListener();
    private RemoveAction removeAction = new RemoveAction(this);
    private final PropertySheetConfiguration NULL_CONFIGURATION = new NullPropertySheetConfiguration();
    private PropertySheetConfiguration fConfiguration;
    private ISelection fInput = null;
    private Object[] fSelectedEntries = null;

    public IPropertySheetModel getModel() {
        return this.model;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.fConfiguration != null && this.sourcePart == null && selection == null) {
            this.sourcePart = part;
            return;
        }
        if (part != null && part instanceof PageBookView && ((PageBookView)part).getCurrentPage() == this) {
            return;
        }
        if (this.getControl() != null && !this.getControl().isDisposed() && this.getControl().isVisible()) {
            if (this.sourcePart != null && this.sourcePart != part) {
                return;
            }
            ISelection preferredSelection = this.getConfiguration().getInputSelection(part, selection);
            if (!preferredSelection.equals(this.fInput)) {
                this.fInput = preferredSelection;
                this.fSelectedEntries = null;
                if (this.sourcePart != null) {
                    this.sourcePart.getSite().getPage().removePartListener((IPartListener)this.partListener);
                    this.sourcePart = null;
                }
                if (selection instanceof IStructuredSelection) {
                    this.sourcePart = part;
                    if (this.model != null) {
                        this.model.setWorkbenchPart(this.sourcePart);
                    }
                    this.viewer.setInput(((IStructuredSelection)preferredSelection).toArray());
                }
                if (this.sourcePart != null) {
                    this.sourcePart.getSite().getPage().addPartListener((IPartListener)this.partListener);
                }
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (ISaveablePart.class.equals((Object)adapter)) {
            return this.getSaveablePart();
        }
        return null;
    }

    protected ISaveablePart getSaveablePart() {
        if (this.sourcePart instanceof ISaveablePart) {
            return (ISaveablePart)this.sourcePart;
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.viewer = new FormPropertySheetViewer(parent);
        if (this.model == null) {
            this.model = new FormPropertySheetModel();
        }
        this.viewer.setModel(this.model);
        this.setPropertySourceProvider(this.getConfiguration().getPropertySourceProvider((IPropertySheetPage)this));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FormPropertySheetPage.this.handleEntrySelection(event.getSelection());
            }
        });
    }

    public void dispose() {
        this.setConfiguration(null);
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        this.fSelectedEntries = null;
        this.fInput = null;
        super.dispose();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    public void handleEntrySelection(ISelection selection) {
        if (this.getControl() != null && !this.getControl().isDisposed() && selection != null) {
            this.fSelectedEntries = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : null;
            IPropertyDescriptor descriptor = this.getDescriptor(selection);
            boolean isEnabled = descriptor != null && this.model.getPropertySource().isPropertySet(descriptor.getId());
            this.removeAction.setEnabled(isEnabled);
            String tooltip = String.valueOf(this.removeAction.getText()) + (descriptor != null ? " " + descriptor.getDisplayName() : "");
            this.removeAction.setToolTipText(tooltip);
        }
    }

    private IPropertyDescriptor getDescriptor(ISelection selection) {
        Object o;
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IPropertyDescriptor) {
            return (IPropertyDescriptor)o;
        }
        return null;
    }

    public Control getControl() {
        return this.viewer == null ? null : this.viewer.getControl();
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    @Override
    public void setConfiguration(PropertySheetConfiguration configuration) {
        if (this.fConfiguration != null) {
            this.fConfiguration.unconfigure();
        }
        this.fConfiguration = configuration;
        if (this.fConfiguration != null) {
            this.setPropertySourceProvider(this.fConfiguration.getPropertySourceProvider((IPropertySheetPage)this));
        }
    }

    public PropertySheetConfiguration getConfiguration() {
        if (this.fConfiguration == null) {
            this.fConfiguration = this.NULL_CONFIGURATION;
        }
        return this.fConfiguration;
    }

    public void setPropertySourceProvider(IPropertySourceProvider provider) {
        if (this.model == null) {
            this.model = new FormPropertySheetModel();
        }
        this.model.setPropertySourceProvider(provider);
        if (this.viewer != null) {
            this.viewer.setModel(this.model);
        }
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        toolBarManager.add((IAction)this.removeAction);
    }

    private void makeActions() {
    }

    @Override
    public void refresh() {
        if (this.viewer == null) {
            return;
        }
        this.viewer.setInput(this.viewer.getInput());
    }

    public final FormPropertySheetViewer getViewer() {
        return this.viewer;
    }

    private class NullPropertySheetConfiguration
    extends PropertySheetConfiguration {
        private NullPropertySheetConfiguration() {
        }

        public IPropertySourceProvider getPropertySourceProvider(IPropertySheetPage page) {
            return null;
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (FormPropertySheetPage.this.sourcePart == part) {
                if (FormPropertySheetPage.this.sourcePart != null) {
                    FormPropertySheetPage.this.sourcePart.getSite().getPage().removePartListener((IPartListener)FormPropertySheetPage.this.partListener);
                }
                FormPropertySheetPage.this.sourcePart = null;
                if (FormPropertySheetPage.this.model != null) {
                    FormPropertySheetPage.this.model.setWorkbenchPart(null);
                }
                if (FormPropertySheetPage.this.viewer != null && !FormPropertySheetPage.this.viewer.getControl().isDisposed()) {
                    FormPropertySheetPage.this.viewer.setInput(new Object[0]);
                }
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

