/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.preferences.js;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLib;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibModel;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.js.JSLibXMLLoader;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class JSLibFactory {
    static JSLibFactory instance = new JSLibFactory();
    static String JS_CSS_LIBS_PREFERENCE_NAME = "js-css-libs";
    private JSLibModel defaultModel;
    private JSLibModel preferenceModel;
    private JSLibModel workingCopy;

    public static JSLibFactory getInstance() {
        return instance;
    }

    private JSLibFactory() {
    }

    public JSLibModel getDefaultModel() {
        if (this.defaultModel == null) {
            this.createDefaultModel();
        }
        return this.defaultModel;
    }

    public JSLibModel getPreferenceModel() {
        if (this.preferenceModel == null) {
            this.loadPreferenceModel();
        }
        return this.preferenceModel;
    }

    public synchronized JSLibModel getWorkingCopy() {
        if (this.workingCopy == null) {
            this.workingCopy = this.createCopy(this.getPreferenceModel());
        }
        return this.workingCopy;
    }

    public synchronized void applyDefault() {
        if (this.workingCopy != null) {
            this.workingCopy.applyWorkingCopy(this.createCopy(this.getDefaultModel()), false);
        }
    }

    public synchronized void applyWorkingCopy() {
        if (this.workingCopy != null) {
            this.preferenceModel.applyWorkingCopy(this.workingCopy, true);
        }
    }

    public synchronized void disposeWorkingCopy() {
        this.workingCopy = null;
    }

    synchronized void createDefaultModel() {
        if (this.defaultModel != null) {
            return;
        }
        JSLibModel model = new JSLibModel();
        List<URL> resources = JSLibFactory.getResources();
        for (URL url : resources) {
            try {
                String s = FileUtil.readStream((InputStream)url.openStream());
                JSLibModel m = JSLibXMLLoader.load(s);
                model.applyWorkingCopy(m, false);
            }
            catch (IOException e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }
        this.defaultModel = model;
    }

    synchronized void loadPreferenceModel() {
        if (this.preferenceModel != null) {
            return;
        }
        String s = this.getPreference(JS_CSS_LIBS_PREFERENCE_NAME);
        JSLibModel prev = this.getPreviousDefaultModel();
        if (s == null) {
            this.preferenceModel = this.createCopy(this.getDefaultModel());
        } else {
            this.preferenceModel = JSLibXMLLoader.load(s);
            if (this.preferenceModel == null) {
                this.preferenceModel = this.createCopy(this.getDefaultModel());
            } else if (prev != null) {
                ArrayList<String> diff = new ArrayList<String>();
                this.mergeDefaultModel(diff, this.preferenceModel, prev, this.getDefaultModel());
                if (!diff.isEmpty()) {
                    this.savePreferenceModel();
                }
            }
        }
    }

    private String getPreference(String name) {
        IEclipsePreferences node = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node("org.jboss.tools.jst.web.ui");
        return node.get(name, null);
    }

    private void setPreference(String name, String value) {
        IEclipsePreferences node = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node("org.jboss.tools.jst.web.ui");
        node.put(name, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            WebUiPlugin.getDefault().logError(e);
        }
    }

    private JSLibModel getPreviousDefaultModel() {
        Bundle bundle = Platform.getBundle((String)"org.jboss.tools.jst.web.ui");
        File location = Platform.getStateLocation((Bundle)bundle).toFile();
        File f = new File(location, ".js-css.xml");
        JSLibModel newDefaultModel = this.getDefaultModel();
        String newText = JSLibXMLLoader.saveToString(this.getDefaultModel());
        if (!f.exists()) {
            FileUtil.writeFile((File)f, (String)newText);
            return new JSLibModel();
        }
        JSLibModel oldDefaultModel = JSLibXMLLoader.load(FileUtil.readFile((File)f));
        if (newDefaultModel.equals(oldDefaultModel)) {
            return null;
        }
        FileUtil.writeFile((File)f, (String)newText);
        return oldDefaultModel;
    }

    synchronized void savePreferenceModel() {
        if (this.preferenceModel == null) {
            return;
        }
        this.setPreference(JS_CSS_LIBS_PREFERENCE_NAME, JSLibXMLLoader.saveToString(this.preferenceModel));
    }

    synchronized JSLibModel createCopy(JSLibModel source) {
        JSLibModel copy = new JSLibModel();
        for (JSLib lib : source.getLibs()) {
            this.addLibCopy(copy, lib);
        }
        return copy;
    }

    synchronized JSLib addLibCopy(JSLibModel copy, JSLib source) {
        JSLib libCopy = copy.getOrCreateLib(source.getName());
        for (JSLibVersion version : source.getVersions()) {
            this.addVersionCopy(libCopy, version);
        }
        return libCopy;
    }

    synchronized JSLibVersion addVersionCopy(JSLib copy, JSLibVersion source) {
        JSLibVersion versionCopy = copy.getOrCreateVersion(source.getVersion());
        versionCopy.getURLs().addAll(source.getURLs());
        return versionCopy;
    }

    public static List<URL> getResources() {
        ArrayList<URL> resources = new ArrayList<URL>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.jboss.tools.jst.web.ui.jscssLibs");
        IExtension[] es = point.getExtensions();
        int i = 0;
        while (i < es.length) {
            Bundle bundle = Platform.getBundle((String)es[i].getNamespaceIdentifier());
            IConfigurationElement[] elements = es[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String path = elements[j].getAttribute("path");
                if (path != null) {
                    try {
                        URL url = bundle.getResource(path);
                        if (url != null) {
                            resources.add(url);
                        } else if (WebUiPlugin.isDebugEnabled()) {
                            WebUiPlugin.getDefault().logInfo("Warning: js/css lib resource " + path + " not found.");
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        WebUiPlugin.getDefault().logError("MetaResourceLoader warning: js/css lib resource " + path + " not found.");
                    }
                }
                ++j;
            }
            ++i;
        }
        return resources;
    }

    public void mergeDefaultModel(List<String> diff, JSLibModel model, JSLibModel oldDefaultModel, JSLibModel newDefaultModel) {
        JSLib currentLib;
        for (JSLib lib : newDefaultModel.getLibs()) {
            currentLib = model.getLib(lib.getName());
            JSLib oldDefaultLib = oldDefaultModel.getLib(lib.getName());
            if (!(currentLib != null || oldDefaultLib != null && oldDefaultLib.equals(lib))) {
                this.addLibCopy(model, lib);
                diff.add("A " + lib.getName());
                continue;
            }
            if (currentLib == null) continue;
            if (oldDefaultLib == null) {
                currentLib.applyWorkingCopy(lib, false);
                diff.add("U " + lib.getName());
                continue;
            }
            this.mergeDefaultLib(diff, currentLib, oldDefaultLib, lib);
        }
        for (JSLib lib : oldDefaultModel.getLibs()) {
            currentLib = model.getLib(lib.getName());
            JSLib newDefaultLib = newDefaultModel.getLib(lib.getName());
            if (newDefaultLib != null || currentLib == null || !lib.equals(currentLib)) continue;
            model.removeLib(currentLib);
            diff.add("R " + currentLib.getName());
        }
    }

    public void mergeDefaultLib(List<String> diff, JSLib lib, JSLib oldDefaultLib, JSLib newDefaultLib) {
        JSLibVersion currentVersion;
        for (JSLibVersion version : newDefaultLib.getVersions()) {
            currentVersion = lib.getVersion(version.getVersion());
            JSLibVersion oldDefaultVersion = oldDefaultLib.getVersion(version.getVersion());
            if (!(currentVersion != null || oldDefaultVersion != null && version.equals(oldDefaultVersion))) {
                this.addVersionCopy(lib, version);
                diff.add("A " + lib.getName() + ":" + version.getVersion());
                continue;
            }
            if (currentVersion == null) continue;
            if (oldDefaultVersion == null) {
                currentVersion.applyWorkingCopy(version, false);
                diff.add("U " + lib.getName() + ":" + version.getVersion());
                continue;
            }
            this.mergeDefaultVersion(diff, currentVersion, oldDefaultVersion, version);
        }
        for (JSLibVersion version : oldDefaultLib.getVersions()) {
            currentVersion = lib.getVersion(version.getVersion());
            JSLibVersion newDefaultVersion = newDefaultLib.getVersion(version.getVersion());
            if (newDefaultVersion != null || currentVersion == null || !version.equals(currentVersion)) continue;
            lib.removeVersion(currentVersion);
            diff.add("R " + lib.getName() + ":" + currentVersion.getVersion());
        }
    }

    public void mergeDefaultVersion(List<String> diff, JSLibVersion version, JSLibVersion oldDefaultVersion, JSLibVersion newDefaultVersion) {
        boolean currentHasUrl;
        for (String url : newDefaultVersion.getURLs()) {
            currentHasUrl = version.getURLs().contains(url);
            boolean oldDefaultHasUrl = oldDefaultVersion.getURLs().contains(url);
            if (currentHasUrl || oldDefaultHasUrl) continue;
            version.getURLs().add(url);
            diff.add("A " + version.getLib().getName() + ":" + version.getVersion() + ":" + url);
        }
        for (String url : oldDefaultVersion.getURLs()) {
            currentHasUrl = version.getURLs().contains(url);
            boolean newDefaultHasUrl = newDefaultVersion.getURLs().contains(url);
            if (newDefaultHasUrl || !currentHasUrl) continue;
            version.getURLs().remove(url);
            diff.add("R " + version.getLib().getName() + ":" + version.getVersion() + ":" + url);
        }
    }
}

