/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNodeList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.jst.web.kb.ICSSContainerSupport;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSSelectorTreeModel;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSSelectorUtils;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSJSPRecognizer {
    private JSPMultiPageEditor jspMultiPageEditor;
    public static final int OK = 0;
    public static final int VOID_RESULT = 1;
    private List<CSSStyleSheet> styleSheets;
    private List<PageContextFactory.CSSStyleSheetDescriptor> styleSheetDescriptors;
    private List<CSSRuleList> cssRuleLists;
    private CSSRule[] cssRules;

    public CSSJSPRecognizer(JSPMultiPageEditor jspMultiPageEditor) {
        this.jspMultiPageEditor = jspMultiPageEditor;
    }

    private List<CSSRuleList> extractCSSRulesLists() {
        ICSSContainerSupport cssContainerSupport = null;
        ELContext context = PageContextFactory.createPageContext((IFile)this.getFile());
        if (!(context instanceof ICSSContainerSupport)) {
            return null;
        }
        cssContainerSupport = (ICSSContainerSupport)context;
        List descrs = cssContainerSupport.getCSSStyleSheetDescriptors();
        if (descrs == null || descrs.size() == 0) {
            return null;
        }
        this.styleSheetDescriptors = descrs;
        ArrayList<CSSRuleList> cssRuleLists = new ArrayList<CSSRuleList>(0);
        this.styleSheets = new ArrayList<CSSStyleSheet>(0);
        int i = 0;
        while (i < descrs.size()) {
            CSSStyleSheet sheet = ((PageContextFactory.CSSStyleSheetDescriptor)descrs.get(i)).getStylesheet();
            if (sheet != null) {
                this.styleSheets.add(sheet);
                cssRuleLists.add(sheet.getCssRules());
            }
            ++i;
        }
        if (cssRuleLists.size() == 0) {
            return null;
        }
        return cssRuleLists;
    }

    private IFile getFile() {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            IFile iFile = smw.getFile();
            return iFile;
        }
        finally {
            smw.dispose();
        }
    }

    private IDocument getDocument() {
        IDocument document = this.jspMultiPageEditor.getSourceEditor().getTextViewer().getDocument();
        return document;
    }

    private CSSRule[] extractCSSRules(List<CSSRuleList> cssRuleLists) {
        if (cssRuleLists == null) {
            return null;
        }
        ArrayList<CSSRule> cssRules = new ArrayList<CSSRule>(0);
        int i = 0;
        while (i < cssRuleLists.size()) {
            CSSRuleList cssRuleList = cssRuleLists.get(i);
            int j = 0;
            while (j < cssRuleList.getLength()) {
                cssRules.add(cssRuleList.item(j));
                ++j;
            }
            ++i;
        }
        if (cssRules.size() == 0) {
            return null;
        }
        return cssRules.toArray(new CSSRule[0]);
    }

    public Map<String, Map<String, String>> getCSSStyleMap(CSSRule[] cssRules) {
        if (cssRules == null) {
            return null;
        }
        LinkedHashMap<String, Map<String, String>> styleMap = new LinkedHashMap<String, Map<String, String>>(0);
        int i = 0;
        while (i < cssRules.length) {
            CSSRule cssRule = cssRules[i];
            if (cssRule.getType() == 1) {
                ICSSStyleRule styleRule = (ICSSStyleRule)cssRule;
                String styleClassSelector = styleRule.getSelectorText();
                String[] selectors = CSSSelectorUtils.parseSelectorName(styleClassSelector);
                int j = 0;
                while (j < selectors.length) {
                    String styleClassName = selectors[j];
                    ICSSNodeList cssNodeList = styleRule.getChildNodes();
                    if (cssNodeList != null) {
                        LinkedHashMap<String, String> attrsMap = new LinkedHashMap<String, String>(0);
                        int k = 0;
                        while (k < cssNodeList.getLength()) {
                            ICSSStyleDeclaration styleDeclaration = (ICSSStyleDeclaration)cssNodeList.item(k);
                            ICSSNodeList attrsList = styleDeclaration.getChildNodes();
                            if (attrsList != null) {
                                int l = 0;
                                while (l < attrsList.getLength()) {
                                    ICSSStyleDeclItem styleItem = (ICSSStyleDeclItem)attrsList.item(l);
                                    attrsMap.put(styleItem.getPropertyName(), styleItem.getCSSValueText());
                                    ++l;
                                }
                            }
                            ++k;
                        }
                        Map attrsForCSSStyle = (Map)styleMap.get(styleClassName);
                        if (attrsForCSSStyle == null) {
                            styleMap.put(styleClassName, attrsMap);
                        } else {
                            attrsForCSSStyle.putAll(attrsMap);
                            styleMap.remove(styleClassName);
                            styleMap.put(styleClassName, attrsForCSSStyle);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return styleMap;
    }

    public CSSSelectorTreeModel getCssStyleClassTreeModel(PageContextFactory.CSSStyleSheetDescriptor[] cssSheets) {
        if (cssSheets != null) {
            return new CSSSelectorTreeModel(cssSheets);
        }
        return null;
    }

    public CSSSelectorTreeModel getCssStyleClassTreeModel() {
        return this.getCssStyleClassTreeModel(this.styleSheetDescriptors.toArray(new PageContextFactory.CSSStyleSheetDescriptor[0]));
    }

    public Map<String, Map<String, String>> getCSSStyleMap() {
        return this.getCSSStyleMap(this.cssRules);
    }

    public int parseCSS() {
        this.cssRuleLists = this.extractCSSRulesLists();
        this.cssRules = this.extractCSSRules(this.cssRuleLists);
        if (this.cssRules != null && this.cssRules.length != 0) {
            return 0;
        }
        return 1;
    }

    public CSSStyleSheet[] getStyleSheets() {
        return this.styleSheets.toArray(new CSSStyleSheet[0]);
    }

    public CSSRule[] getCssRules() {
        return this.cssRules;
    }
}

