/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.css.dialog.parsers.BaseListener;
import org.jboss.tools.jst.web.ui.internal.css.dialog.parsers.CSSParser;
import org.xml.sax.Attributes;

public class CSSConstants {
    public static final String BACKGROUND_REPEAT = "background-repeat";
    public static final String BACKGROUND_COLOR = "background-color";
    public static final String BACKGROUND_IMAGE = "background-image";
    public static final String BORDER_STYLE = "border-style";
    public static final String BORDER_WIDTH = "border-width";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String BORDER_COLOR = "border-color";
    public static final String MARGIN = "margin";
    public static final String PADDING = "padding";
    public static final String FONT_SIZE = "font-size";
    public static final String FONT_STYLE = "font-style";
    public static final String FONT_WEIGHT = "font-weight";
    public static final String TEXT_DECORATION = "text-decoration";
    public static final String TEXT_ALIGN = "text-align";
    public static final String FONT_FAMILY = "font-family";
    public static final Map<String, ArrayList<String>> CSS_STYLE_VALUES_MAP = new HashMap<String, ArrayList<String>>();
    public static final Map<String, ArrayList<String>> CSS_STYLES_MAP = new HashMap<String, ArrayList<String>>();
    public static Map<String, String> COLORS_BY_RGB;
    public static Map<String, String> COLORS_BY_NAME;
    private static final String CSS_VALUES_FILE = "resources/cssdialog/cssElementsWithCombo.xml";
    private static final String CSS_STYLES_FILE = "resources/cssdialog/cssElements.xml";
    private static final String COLORS_FILE = "resources/cssdialog/color_properties.xml";
    private static final String NODE_NAME_ELEMENTS = "elements";
    private static final String NODE_NAME_VALUE = "value";
    private static final String NODE_NAME_ELEMENT = "element";
    private static final String NODE_ATTRIBUTE_NAME = "name";

    static {
        try {
            Properties properties = new Properties();
            InputStream is = WebUiPlugin.getDefault().getBundle().getResource(COLORS_FILE).openStream();
            properties.loadFromXML(is);
            is.close();
            COLORS_BY_RGB = properties;
            COLORS_BY_NAME = new TreeMap<String, String>();
            for (String rgb : COLORS_BY_RGB.keySet()) {
                String name = COLORS_BY_RGB.get(rgb);
                COLORS_BY_NAME.put(name.toLowerCase(), rgb);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CSSParser parser = new CSSParser();
        parser.setListener(new BaseListener((Map)CSS_STYLE_VALUES_MAP){
            private ArrayList<String> list = null;

            @Override
            public void startElement(String uri, String localName, String nodeName, Attributes attrs) {
                if (nodeName.trim().equalsIgnoreCase(CSSConstants.NODE_NAME_ELEMENTS)) {
                    return;
                }
                if (!nodeName.trim().equalsIgnoreCase(CSSConstants.NODE_NAME_VALUE)) {
                    String name = nodeName;
                    this.list = new ArrayList();
                    this.map.put(name, this.list);
                } else {
                    this.list.add(attrs.getValue(CSSConstants.NODE_ATTRIBUTE_NAME));
                }
            }
        });
        parser.parse(CSS_VALUES_FILE);
        parser.setListener(new BaseListener((Map)CSS_STYLES_MAP){
            private ArrayList<String> list = null;

            @Override
            public void startElement(String uri, String localName, String nodeName, Attributes attrs) {
                if (nodeName.trim().equalsIgnoreCase(CSSConstants.NODE_NAME_ELEMENTS)) {
                    return;
                }
                if (!nodeName.trim().equalsIgnoreCase(CSSConstants.NODE_NAME_ELEMENT)) {
                    String name = nodeName;
                    this.list = new ArrayList();
                    this.map.put(name, this.list);
                } else {
                    this.list.add(attrs.getValue(CSSConstants.NODE_ATTRIBUTE_NAME));
                }
            }
        });
        parser.parse(CSS_STYLES_FILE);
    }
}

