/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.jst.web.ui.internal.css.dialog.AbstractCSSDialog;
import org.jboss.tools.jst.web.ui.internal.css.dialog.StyleComposite;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.CSSModel;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.CSSSelectorValidator;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.ICSSDialogModel;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.Util;
import org.jboss.tools.jst.web.ui.internal.css.dialog.tabs.TabPreviewControl;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;

public class CSSClassDialog
extends AbstractCSSDialog {
    private ICSSDialogModel cssModel;
    protected IStructuredSelection selection;
    private IFile file;
    private Text fileText;
    private Combo classCombo;
    private String selectorLabel;
    private Button addNewClassButton;
    private Button applyButton;
    private TabPreviewControl preview;

    public CSSClassDialog(Shell parentShell, IFile file, IStructuredSelection selection) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400 | 0x10000);
        this.file = file;
        this.cssModel = new CSSModel(file);
        this.selection = selection;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JstUIMessages.CSS_STYLE_CLASS_EDITOR_TITLE);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateControlPane();
        return contents;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setTitle(JstUIMessages.CSS_STYLE_CLASS_EDITOR_TITLE);
        return super.createDialogArea(parent);
    }

    @Override
    protected StyleComposite createStyleComposite(Composite parent) {
        StyleComposite styleComposite = super.createStyleComposite(parent);
        this.preview = new TabPreviewControl((Composite)styleComposite.getTabFolder(), this.getStyleAttributes(), this.cssModel);
        styleComposite.createTabItem(this.preview, this.preview, JstUIMessages.PREVIEW_SHEET_TAB_NAME, JstUIMessages.PREVIEW_SHEET_TAB_NAME);
        return styleComposite;
    }

    @Override
    protected void createExtensionComposite(final Composite parent) {
        Composite fileControlPanel = new Composite(parent, 2048);
        fileControlPanel.setLayoutData((Object)new GridData(4, 1, true, false));
        fileControlPanel.setLayout((Layout)new GridLayout(3, false));
        this.addLabel(fileControlPanel, JstUIMessages.CSS_CLASS_DIALOG_FILE_LABEL);
        GridData fileLayoutData = new GridData(4, 2, true, false);
        fileLayoutData.horizontalSpan = 2;
        this.fileText = new Text(fileControlPanel, 2056);
        this.fileText.setLayoutData((Object)fileLayoutData);
        this.addLabel(fileControlPanel, JstUIMessages.CSS_CLASS_DIALOG_STYLE_CLASS_LABEL);
        this.classCombo = new Combo(fileControlPanel, 2056);
        this.classCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.classCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSSClassDialog.this.handleSelectorSwitched();
            }
        });
        this.addNewClassButton = new Button(fileControlPanel, 8);
        this.addNewClassButton.setText(JstUIMessages.BUTTON_ADD_NEW_STYLE_CLASS);
        this.addNewClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputDialog dlg = new InputDialog(parent.getShell(), JstUIMessages.ENTER_CSS_CLASS_NAME, JstUIMessages.ENTER_CSS_CLASS_NAME, CSSClassDialog.this.classCombo.getText(), (IInputValidator)CSSSelectorValidator.getInstance());
                if (dlg.open() == 0) {
                    CSSClassDialog.this.addNewClass(dlg.getValue().trim());
                }
            }
        });
    }

    @Override
    protected Composite createControlComposite(Composite parent) {
        Composite controlComposite = super.createControlComposite(parent);
        this.createCustomButtonPanel(controlComposite);
        return controlComposite;
    }

    protected Label addLabel(Composite parent, String label) {
        Label labelControl = new Label(parent, 16384);
        labelControl.setLayoutData((Object)new GridData(3, 2, false, false));
        labelControl.setText(label);
        return labelControl;
    }

    private void createCustomButtonPanel(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(3, 1, true, false));
        buttonComposite.setLayout((Layout)new GridLayout());
        this.applyButton = this.createCustomButton(buttonComposite, JstUIMessages.BUTTON_APPLY, JstUIMessages.CSS_APPLY_CHANGES, false);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CSSClassDialog.this.save();
                CSSClassDialog.this.applyButton.setEnabled(false);
            }
        });
        Button clearButton = this.createCustomButton(buttonComposite, JstUIMessages.BUTTON_CLEAR, JstUIMessages.CSS_CLEAR_STYLE_SHEET, true);
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CSSClassDialog.this.getStyleComposite().clearStyleComposite();
                CSSClassDialog.this.getStyleComposite().updateCurrentTab();
            }
        });
    }

    protected Button createCustomButton(Composite parent, String label, String tooltip, boolean defaultState) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setToolTipText(tooltip);
        button.setEnabled(defaultState);
        return button;
    }

    protected void handleSelectorSwitched() {
        if (this.selectorLabel != null) {
            this.cssModel.updateCSSStyle(this.selectorLabel, this.getStyleAttributes());
        }
        this.selectorLabel = this.classCombo.getText();
        this.preview.setSelector(this.selectorLabel);
        this.classCombo.setToolTipText(this.cssModel.getCSSRuleText(this.selectorLabel));
        this.getStyleComposite().setStyleProperties(this.cssModel.getClassProperties(this.selectorLabel));
        this.getStyleComposite().updateCurrentTab();
    }

    public void addNewClass(String styleClassName) {
        String newSelectorLabel = this.cssModel.addCSSRule(styleClassName);
        this.classCombo.add(newSelectorLabel);
        this.classCombo.select(this.classCombo.getItemCount() - 1);
        this.applyButton.setEnabled(true);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        this.preview.releaseModel();
        if (this.cssModel != null) {
            this.cssModel.release();
            this.cssModel = null;
        }
    }

    public void save() {
        this.cssModel.updateCSSStyle(this.selectorLabel, this.getStyleAttributes());
        this.cssModel.save();
    }

    public String getSelectorName() {
        return Util.formatCSSSelectorToStyleClassView(this.selectorLabel);
    }

    @Override
    public boolean close() {
        int code = this.getReturnCode();
        switch (code) {
            case 0: {
                this.save();
            }
        }
        return super.close();
    }

    public void reinit() {
        this.preview.releaseModel();
        this.cssModel.setFile(this.file);
        this.cssModel.reinit();
        this.preview.reinit(this.cssModel);
        this.getStyleComposite().clearStyleComposite();
        this.updateControlPane();
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    @Override
    protected void handleStyleChanged() {
        super.handleStyleChanged();
        if (this.getStatus().isOK()) {
            this.applyButton.setEnabled(true);
        }
    }

    @Override
    protected void handleStatusChanged(IStatus newStatus) {
        if (newStatus.getSeverity() != this.getStatus().getSeverity()) {
            this.applyButton.setEnabled(newStatus.isOK());
            this.getButton(0).setEnabled(newStatus.isOK());
            this.classCombo.setEnabled(newStatus.isOK());
            this.addNewClassButton.setEnabled(newStatus.isOK());
        }
        super.handleStatusChanged(newStatus);
    }

    protected void updateControlPane() {
        this.fileText.setText(this.file.getFullPath().toString());
        this.classCombo.removeAll();
        this.classCombo.setEnabled(true);
        this.selectorLabel = this.cssModel.getSelectorLabel(Util.getSelectionInFile((IFile)this.file).x);
        this.getStyleComposite().setStyleProperties(this.cssModel.getClassProperties(this.selectorLabel));
        this.preview.setSelector(this.selectorLabel);
        List<String> selectors = this.cssModel.getSelectorLabels();
        int i = 0;
        while (i < selectors.size()) {
            String label = selectors.get(i);
            this.classCombo.add(label);
            if (label.equals(this.selectorLabel)) {
                this.classCombo.select(i);
            }
            ++i;
        }
        if (this.classCombo.getSelectionIndex() == -1) {
            this.classCombo.select(0);
        }
        this.applyButton.setEnabled(false);
    }

    protected Button getApplyButton() {
        return this.applyButton;
    }

    protected Button getAddNewClassButton() {
        return this.addNewClassButton;
    }

    protected Combo getClassCombo() {
        return this.classCombo;
    }
}

