/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class URLUtils {
    public static final String UTF8 = "UTF-8";

    private URLUtils() {
    }

    public static String encode(String s) {
        return URLUtils.encode(s, UTF8);
    }

    public static String encode(String s, String enc) {
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("%MSG_BROKEN_VM_DOES_NOT_SUPPORT_UTF-8", e);
        }
    }

    public static String decode(String s) {
        return URLUtils.decode(s, UTF8);
    }

    public static String decode(String s, String enc) {
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("%MSG_BROKEN_VM_DOES_NOT_SUPPORT_UTF-8", e);
        }
    }

    public static String encodeURLString(String urlString) {
        try {
            URI uri = new URI(urlString);
            return uri.toASCIIString();
        }
        catch (Exception exception) {
            return urlString;
        }
    }
}

