/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;

public class TesterWSDLUtils {
    private static final String DEF_FACTORY_PROPERTY_NAME = "javax.wsdl.factory.DefinitionFactory";
    private static final String PRIVATE_DEF_FACTORY_CLASS = "org.apache.wsif.wsdl.WSIFWSDLFactoryImpl";
    public static final String SOAP_NS_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_ENVELOPE_NS_URI = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP12_NS_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String SOAP12_PREFIX = "soap12";
    public static final String SOAP_PREFIX = "soap";

    public static Definition readWSDLURL(URL contextURL, String wsdlLoc) throws WSDLException {
        Properties props = System.getProperties();
        String oldPropValue = props.getProperty(DEF_FACTORY_PROPERTY_NAME);
        props.setProperty(DEF_FACTORY_PROPERTY_NAME, PRIVATE_DEF_FACTORY_CLASS);
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        String context = null;
        if (contextURL != null) {
            context = contextURL.toString();
        }
        Definition def = wsdlReader.readWSDL(context, wsdlLoc);
        if (oldPropValue != null) {
            props.setProperty(DEF_FACTORY_PROPERTY_NAME, oldPropValue);
        } else {
            props.remove(DEF_FACTORY_PROPERTY_NAME);
        }
        return def;
    }

    public static IStatus isWSDLAccessible(URL contextURL) {
        Properties props = System.getProperties();
        String oldPropValue = props.getProperty(DEF_FACTORY_PROPERTY_NAME);
        props.setProperty(DEF_FACTORY_PROPERTY_NAME, PRIVATE_DEF_FACTORY_CLASS);
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            String context = null;
            if (contextURL != null) {
                context = contextURL.toString();
            }
            wsdlReader.readWSDL(context);
        }
        catch (WSDLException e) {
            if (contextURL.getProtocol().equalsIgnoreCase("https")) {
                return StatusUtils.warningStatus((String)JBossWSUIMessages.TesterWSDLUtils_WSDL_HTTPS_Secured_Inaccessible);
            }
            return StatusUtils.errorStatus((String)JBossWSUIMessages.TesterWSDLUtils_WSDL_Inaccessible, (Throwable)e);
        }
        if (oldPropValue != null) {
            props.setProperty(DEF_FACTORY_PROPERTY_NAME, oldPropValue);
        } else {
            props.remove(DEF_FACTORY_PROPERTY_NAME);
        }
        return Status.OK_STATUS;
    }

    public static Definition readWSDLURL(URL contextURL) throws WSDLException, NullPointerException {
        Properties props = System.getProperties();
        String oldPropValue = props.getProperty(DEF_FACTORY_PROPERTY_NAME);
        props.setProperty(DEF_FACTORY_PROPERTY_NAME, PRIVATE_DEF_FACTORY_CLASS);
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        String context = null;
        if (contextURL != null) {
            context = contextURL.toString();
        }
        Definition def = wsdlReader.readWSDL(context);
        if (oldPropValue != null) {
            props.setProperty(DEF_FACTORY_PROPERTY_NAME, oldPropValue);
        } else {
            props.remove(DEF_FACTORY_PROPERTY_NAME);
        }
        return def;
    }

    public static boolean isSOAP12(Definition wsdlDefinition, String serviceName, String portName) {
        Map services = wsdlDefinition.getServices();
        Set serviceKeys = services.keySet();
        for (QName serviceKey : serviceKeys) {
            if (serviceName == null || !serviceKey.getLocalPart().contentEquals(serviceName)) continue;
            Service service = (Service)services.get(serviceKey);
            Map ports = service.getPorts();
            Set portKeys = ports.keySet();
            for (String portKey : portKeys) {
                Port port;
                List extElements;
                Iterator it3;
                if (portName == null || !portKey.contentEquals(portName) || !(it3 = (extElements = (port = (Port)ports.get(portKey)).getExtensibilityElements()).iterator()).hasNext()) continue;
                ExtensibilityElement element = (ExtensibilityElement)it3.next();
                String nsURI = element.getElementType().getNamespaceURI();
                return nsURI.contentEquals(SOAP12_NS_URI);
            }
        }
        return false;
    }

    public static String[] getNSServiceNameAndMessageNameArray(Definition wsdlDefinition, String serviceName, String portName, String bindingName, String opName) {
        Map services = wsdlDefinition.getServices();
        Set serviceKeys = services.keySet();
        for (QName serviceKey : serviceKeys) {
            if (serviceName == null || !serviceKey.getLocalPart().contentEquals(serviceName)) continue;
            Service service = (Service)services.get(serviceKey);
            Map ports = service.getPorts();
            Set portKeys = ports.keySet();
            for (String portKey : portKeys) {
                if (portName == null || !portKey.contentEquals(portName)) continue;
                Port port = (Port)ports.get(portKey);
                Binding wsdlBinding = port.getBinding();
                PortType portType = wsdlBinding.getPortType();
                String ns = service.getQName().getNamespaceURI();
                List operations = portType.getOperations();
                for (Operation operation : operations) {
                    if (opName == null || !operation.getName().contentEquals(opName)) continue;
                    return new String[]{ns, serviceName, portName};
                }
            }
        }
        return null;
    }

    public static String getEndpointURL(Definition wsdlDefinition, String serviceName, String portName, String bindingName, String opName) {
        Map services = wsdlDefinition.getServices();
        Set serviceKeys = services.keySet();
        for (QName serviceKey : serviceKeys) {
            if (serviceName == null || !serviceKey.getLocalPart().contentEquals(serviceName)) continue;
            Service service = (Service)services.get(serviceKey);
            Map ports = service.getPorts();
            Set portKeys = ports.keySet();
            for (String portKey : portKeys) {
                if (portName == null || !portKey.contentEquals(portName)) continue;
                Port port = (Port)ports.get(portKey);
                List elements = port.getExtensibilityElements();
                for (Object element : elements) {
                    if (element instanceof SOAPAddress) {
                        SOAPAddress address = (SOAPAddress)element;
                        return address.getLocationURI();
                    }
                    if (!(element instanceof SOAP12Address)) continue;
                    SOAP12Address address = (SOAP12Address)element;
                    return address.getLocationURI();
                }
            }
        }
        return null;
    }

    public static String getActionURL(Definition wsdlDefinition, String serviceName, String portName, String bindingName, String opName) {
        Map services = wsdlDefinition.getServices();
        Set serviceKeys = services.keySet();
        for (QName serviceKey : serviceKeys) {
            if (serviceName == null || !serviceKey.getLocalPart().contentEquals(serviceName)) continue;
            Service service = (Service)services.get(serviceKey);
            Map ports = service.getPorts();
            Set portKeys = ports.keySet();
            for (String portKey : portKeys) {
                if (portName == null || !portKey.contentEquals(portName)) continue;
                Port port = (Port)ports.get(portKey);
                Binding wsdlBinding = port.getBinding();
                List operations = wsdlBinding.getBindingOperations();
                for (BindingOperation operation : operations) {
                    if (opName == null || !operation.getName().contentEquals(opName)) continue;
                    List attributesList = operation.getExtensibilityElements();
                    for (Object test : attributesList) {
                        if (test instanceof SOAPOperation) {
                            SOAPOperation soapOp = (SOAPOperation)test;
                            return soapOp.getSoapActionURI();
                        }
                        if (!(test instanceof SOAP12Operation)) continue;
                        SOAP12Operation soapOp = (SOAP12Operation)test;
                        return soapOp.getSoapActionURI();
                    }
                }
            }
        }
        return null;
    }

    public static String getFileContents(URL inURL) {
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(inURL.openStream()));
            StringBuffer buffer = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                buffer.append(String.valueOf(inputLine) + '\n');
            }
            in.close();
            return buffer.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isRequestBodySOAP12(String body) {
        boolean isSOAP12 = false;
        if (body.indexOf(SOAP12_ENVELOPE_NS_URI) > -1) {
            isSOAP12 = true;
        }
        return isSOAP12;
    }
}

