/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.dialogs;

import org.eclipse.osgi.util.NLS;
import org.jboss.tools.ws.ui.dialogs.EnumParamType;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;

public class URLTemplateParameter {
    public static final String BYTE = "byte";
    public static final String SHORT = "short";
    public static final String INT = "int";
    public static final String LONG = "Long";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String CHAR = "char";
    public static final String BOOLEAN = "boolean";
    private final String originalContent;
    private final String name;
    private final String datatype;
    private final String defaultValue;
    private final EnumParamType paramType;
    private final String regex;
    private String value = "";
    private boolean isMultiple = false;

    private URLTemplateParameter(String originalContent, String name, String datatype, String defaultValue, EnumParamType paramType) {
        this.originalContent = originalContent;
        this.name = name;
        this.datatype = datatype;
        this.value = this.defaultValue = defaultValue != null ? defaultValue : "";
        this.regex = this.getRegex(datatype);
        this.paramType = paramType;
    }

    public String getRegex(String datatype) {
        if (datatype.startsWith("List<") || datatype.startsWith("Set<") || datatype.startsWith("SortedSet<")) {
            this.isMultiple = true;
            String internalPattern = this.getRegex(datatype.substring(datatype.indexOf("<") + 1, datatype.length() - 1));
            return String.valueOf(internalPattern) + "(," + internalPattern + ")*";
        }
        if (datatype.equals(BOOLEAN) || datatype.equals(Boolean.class.getSimpleName())) {
            return "(\"true\"|\"false\"|\"yes\"|\"no\"|\"y\"|\"n\"|\"0\"|\"1\")";
        }
        if (datatype.equals(SHORT) || datatype.equals(Short.class.getSimpleName())) {
            return "(\\d)+";
        }
        if (datatype.equals(INT) || datatype.equals(Integer.class.getSimpleName())) {
            return "(\\d)+";
        }
        if (datatype.equals(LONG) || datatype.equals(Long.class.getSimpleName())) {
            return "-?\\d{1,19}";
        }
        if (datatype.equals(FLOAT) || datatype.equals(Float.class.getSimpleName())) {
            return "[-+]?[0-9]*\\.?[0-9]+";
        }
        if (datatype.equals(DOUBLE) || datatype.equals(Double.class.getSimpleName())) {
            return "[-+]?[0-9]*\\.?[0-9]+";
        }
        if (datatype.equals(CHAR) || datatype.equals(Character.class.getSimpleName())) {
            return ".";
        }
        if (datatype.equals(String.class.getSimpleName())) {
            return ".+";
        }
        return datatype;
    }

    public String validate() {
        if (this.regex == null) {
            return null;
        }
        if (this.value.isEmpty() && this.paramType != EnumParamType.PATH_PARAM) {
            return null;
        }
        if (this.paramType == EnumParamType.PATH_PARAM && this.value.isEmpty()) {
            String errorMessage = JBossWSUIMessages.WSTesterURLInputsDialog_Validation_Error_Missing_Value;
            return NLS.bind((String)errorMessage, (Object[])new String[]{this.name});
        }
        if (!this.value.matches(this.regex)) {
            String errorMessage = JBossWSUIMessages.WSTesterURLInputsDialog_Validation_Error_Invalid;
            return NLS.bind((String)errorMessage, (Object[])new String[]{this.name, this.datatype, this.value});
        }
        return null;
    }

    public static boolean isInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isFloat(String value) {
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getReplacementContent() {
        if (this.value == null || this.value.isEmpty()) {
            return "";
        }
        if (this.isMultiple) {
            StringBuilder replacementContentBuilder = new StringBuilder();
            boolean first = true;
            String[] stringArray = this.value.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                switch (this.paramType) {
                    case MATRIX_PARAM: {
                        replacementContentBuilder.append(';');
                        break;
                    }
                    case QUERY_PARAM: {
                        if (first) {
                            replacementContentBuilder.append(this.originalContent.charAt(0));
                            break;
                        }
                        replacementContentBuilder.append('&');
                    }
                }
                first = false;
                replacementContentBuilder.append(this.name).append('=').append(v.trim());
                ++n2;
            }
            return replacementContentBuilder.toString();
        }
        switch (this.paramType) {
            case MATRIX_PARAM: {
                return String.valueOf(';') + this.name + '=' + this.value;
            }
            case QUERY_PARAM: {
                return String.valueOf(this.originalContent.charAt(0)) + this.name + '=' + this.value;
            }
        }
        return this.value.trim();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public EnumParamType getParameterType() {
        return this.paramType;
    }

    public boolean isMandatory() {
        return this.paramType == EnumParamType.PATH_PARAM;
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public String toString() {
        if (this.defaultValue != null) {
            return String.valueOf(this.name) + ", " + this.datatype + "=" + this.defaultValue + ", " + this.originalContent + " (" + (Object)((Object)this.paramType) + ")";
        }
        return String.valueOf(this.name) + ", " + this.datatype + ", " + this.originalContent + " (" + (Object)((Object)this.paramType) + ")";
    }

    /* synthetic */ URLTemplateParameter(String string, String string2, String string3, String string4, EnumParamType enumParamType, URLTemplateParameter uRLTemplateParameter) {
        this(string, string2, string3, string4, enumParamType);
    }

    public static class Builder {
        private String name = null;
        private String datatype = null;
        private String defaultValue = null;
        private final String originalContent;
        private EnumParamType paramType;

        private Builder(String originalContent) {
            this.originalContent = originalContent;
        }

        public static Builder from(String originalContent) {
            return new Builder(originalContent);
        }

        public Builder withName(String name, boolean mandatory) {
            this.name = name;
            return this;
        }

        public Builder withDatatype(String datatype) {
            this.datatype = datatype;
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withParamType(EnumParamType paramType) {
            this.paramType = paramType;
            return this;
        }

        public URLTemplateParameter build() {
            return new URLTemplateParameter(this.originalContent, this.name, this.datatype, this.defaultValue, this.paramType, null);
        }
    }
}

