/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.configuration;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.tools.livereload.ui.internal.configuration.LiveReloadServerConfigurationMessages;

public class LiveReloadServerConfigurationSection
extends ServerEditorSection {
    private Text websocketPortText;
    private Button remoteConnectionsEnablementButton;
    private Button scriptInjectionEnablementButton;
    private Spinner notificationDelaySpinner;
    private ControlDecoration websocketPortDecoration;

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(LiveReloadServerConfigurationMessages.WEBSOCKET_SERVER_CONFIGURATION_TITLE);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label explanation = toolkit.createLabel(composite, LiveReloadServerConfigurationMessages.WEBSOCKET_SERVER_CONFIGURATION_DESCRIPTION, 64);
        GridData d = new GridData();
        d.horizontalSpan = 2;
        d.grabExcessHorizontalSpace = true;
        explanation.setLayoutData((Object)d);
        Label websocketPortLabel = toolkit.createLabel(composite, LiveReloadServerConfigurationMessages.WEBSOCKET_SERVER_PORT_LABEL);
        websocketPortLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.websocketPortText = toolkit.createText(composite, this.server.getAttribute("org.jboss.tools.livereload.core.websocket_port", ""));
        d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.widthHint = 100;
        d.horizontalIndent = 10;
        this.websocketPortText.setLayoutData((Object)d);
        this.websocketPortDecoration = new ControlDecoration((Control)this.websocketPortText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.websocketPortDecoration.hide();
        this.websocketPortDecoration.setImage(fieldDecoration.getImage());
        ModifyListener websocketPortModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LiveReloadServerConfigurationSection.this.execute((IUndoableOperation)new SetWebSocketPortCommand(LiveReloadServerConfigurationSection.this.server));
            }
        };
        this.websocketPortText.addModifyListener(websocketPortModifyListener);
        Label notificationDelayLabel = toolkit.createLabel(composite, LiveReloadServerConfigurationMessages.SET_NOTIFICATION_DELAY_LABEL);
        notificationDelayLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.notificationDelaySpinner = new Spinner(composite, 2048);
        this.notificationDelaySpinner.setSelection(this.server.getAttribute("org.jboss.tools.livereload.core.notification_delay", 0));
        this.notificationDelaySpinner.setMinimum(0);
        this.notificationDelaySpinner.setMaximum(60);
        this.notificationDelaySpinner.setToolTipText(LiveReloadServerConfigurationMessages.SET_NOTIFICATION_DELAY_TOOLTIP);
        d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.widthHint = 20;
        d.horizontalIndent = 10;
        this.notificationDelaySpinner.setLayoutData((Object)d);
        this.notificationDelaySpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LiveReloadServerConfigurationSection.this.execute((IUndoableOperation)new SetServerNotificationDelayCommand(LiveReloadServerConfigurationSection.this.server));
            }
        });
        this.scriptInjectionEnablementButton = toolkit.createButton(composite, LiveReloadServerConfigurationMessages.ENABLE_SCRIPT_INJECTION_LABEL, 32);
        this.scriptInjectionEnablementButton.setSelection(this.server.getAttribute("org.jboss.tools.livereload.core.enable_script_injection", false));
        this.scriptInjectionEnablementButton.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalSpan = 2;
        this.scriptInjectionEnablementButton.setLayoutData((Object)d);
        this.scriptInjectionEnablementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiveReloadServerConfigurationSection.this.execute((IUndoableOperation)new SetScriptInjectionEnablementButtonCommand(LiveReloadServerConfigurationSection.this.server));
            }
        });
        this.remoteConnectionsEnablementButton = toolkit.createButton(composite, LiveReloadServerConfigurationMessages.ALLOW_REMOTE_CONNECTIONS_LABEL, 32);
        this.remoteConnectionsEnablementButton.setSelection(this.server.getAttribute("org.jboss.tools.livereload.core.allow_remote_connections", false));
        this.remoteConnectionsEnablementButton.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalSpan = 2;
        this.remoteConnectionsEnablementButton.setLayoutData((Object)d);
        this.remoteConnectionsEnablementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiveReloadServerConfigurationSection.this.execute((IUndoableOperation)new SetRemoteConnectionsEnablementCommand(LiveReloadServerConfigurationSection.this.server));
            }
        });
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    public IStatus[] getSaveStatus() {
        return new IStatus[]{Status.OK_STATUS};
    }

    public class SetRemoteConnectionsEnablementCommand
    extends ServerCommand {
        public SetRemoteConnectionsEnablementCommand(IServerWorkingCopy server) {
            super(server, LiveReloadServerConfigurationMessages.ALLOW_REMOTE_CONNECTIONS_COMMAND);
        }

        public void execute() {
            this.server.setAttribute("org.jboss.tools.livereload.core.allow_remote_connections", LiveReloadServerConfigurationSection.this.remoteConnectionsEnablementButton.getSelection());
        }

        public void undo() {
            boolean originalValue = this.server.getOriginal().getAttribute("org.jboss.tools.livereload.core.allow_remote_connections", false);
            this.server.setAttribute("org.jboss.tools.livereload.core.allow_remote_connections", originalValue);
            LiveReloadServerConfigurationSection.this.remoteConnectionsEnablementButton.setSelection(originalValue);
        }
    }

    public class SetScriptInjectionEnablementButtonCommand
    extends ServerCommand {
        public SetScriptInjectionEnablementButtonCommand(IServerWorkingCopy server) {
            super(server, LiveReloadServerConfigurationMessages.ENABLE_SCRIPT_INJECTION_COMMAND);
        }

        public void execute() {
            this.server.setAttribute("org.jboss.tools.livereload.core.enable_script_injection", LiveReloadServerConfigurationSection.this.scriptInjectionEnablementButton.getSelection());
        }

        public void undo() {
            boolean originalValue = this.server.getOriginal().getAttribute("org.jboss.tools.livereload.core.enable_script_injection", false);
            this.server.setAttribute("org.jboss.tools.livereload.core.enable_script_injection", originalValue);
            LiveReloadServerConfigurationSection.this.scriptInjectionEnablementButton.setSelection(originalValue);
        }
    }

    public class SetServerNotificationDelayCommand
    extends ServerCommand {
        public SetServerNotificationDelayCommand(IServerWorkingCopy server) {
            super(server, LiveReloadServerConfigurationMessages.SET_NOTIFICATION_DELAY_COMMAND);
        }

        public void execute() {
            this.server.setAttribute("org.jboss.tools.livereload.core.notification_delay", LiveReloadServerConfigurationSection.this.notificationDelaySpinner.getSelection());
        }

        public void undo() {
            int originalValue = this.server.getOriginal().getAttribute("org.jboss.tools.livereload.core.notification_delay", 0);
            this.server.setAttribute("org.jboss.tools.livereload.core.notification_delay", originalValue);
            LiveReloadServerConfigurationSection.this.notificationDelaySpinner.setSelection(originalValue);
        }
    }

    public class SetWebSocketPortCommand
    extends ServerCommand {
        public SetWebSocketPortCommand(IServerWorkingCopy server) {
            super(server, LiveReloadServerConfigurationMessages.WEBSOCKET_SERVER_PORT_COMMAND);
        }

        public void execute() {
            this.server.setAttribute("org.jboss.tools.livereload.core.websocket_port", LiveReloadServerConfigurationSection.this.websocketPortText.getText());
            this.validate();
        }

        public void undo() {
            String originalValue = this.server.getOriginal().getAttribute("org.jboss.tools.livereload.core.websocket_port", "");
            this.server.setAttribute("org.jboss.tools.livereload.core.websocket_port", originalValue);
            LiveReloadServerConfigurationSection.this.websocketPortText.setText(originalValue);
            this.validate();
        }

        private void validate() {
            try {
                Integer.parseInt(LiveReloadServerConfigurationSection.this.websocketPortText.getText());
                LiveReloadServerConfigurationSection.this.websocketPortDecoration.hide();
            }
            catch (NumberFormatException numberFormatException) {
                LiveReloadServerConfigurationSection.this.websocketPortDecoration.show();
            }
        }
    }
}

