/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.command;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;
import org.jboss.tools.livereload.ui.internal.command.OpenInWebBrowserViaLiveReloadUtils;
import org.jboss.tools.livereload.ui.internal.util.Logger;
import org.jboss.tools.livereload.ui.internal.util.Pair;

public class LaunchLiveReloadServerCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Object target = this.getTarget(event);
        if (target == null) {
            Logger.warn("No valid target to open in the Web browser could be found.");
            return null;
        }
        try {
            Pair<IServer, Boolean> result = OpenInWebBrowserViaLiveReloadUtils.getLiveReloadServer(true, false);
            if (result != null) {
                final IServer liveReloadServer = (IServer)result.left;
                boolean needsStartOrRestart = (Boolean)result.right;
                if (needsStartOrRestart) {
                    Job startOrRestartJob = WSTUtils.startOrRestartServer((IServer)liveReloadServer, (int)30, (TimeUnit)TimeUnit.SECONDS);
                    startOrRestartJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            if (event.getResult().isOK()) {
                                LaunchLiveReloadServerCommandHandler.this.openInWebBrowser(target, liveReloadServer);
                            }
                        }
                    });
                    startOrRestartJob.schedule();
                } else {
                    this.openInWebBrowser(target, liveReloadServer);
                }
            }
        }
        catch (InterruptedException | java.util.concurrent.ExecutionException | TimeoutException | CoreException e) {
            Logger.error("Failed to open current selection in a Web browser", e);
        }
        return null;
    }

    private Object getTarget(ExecutionEvent event) {
        AbstractTextEditor textEditor;
        IEditorInput textEditorInput;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            Object selectedElement = ((IStructuredSelection)currentSelection).getFirstElement();
            if (selectedElement instanceof IServerModule || selectedElement instanceof IFile) {
                return selectedElement;
            }
        } else if (activeEditor instanceof AbstractTextEditor && (textEditorInput = (textEditor = (AbstractTextEditor)activeEditor).getEditorInput()) instanceof FileEditorInput) {
            return ((FileEditorInput)textEditorInput).getFile();
        }
        return null;
    }

    private void openInWebBrowser(Object target, IServer liveReloadServer) {
        if (target instanceof IServerModule) {
            OpenInWebBrowserViaLiveReloadUtils.openInWebBrowser((IServerModule)target);
        } else if (target instanceof IFile) {
            OpenInWebBrowserViaLiveReloadUtils.openInWebBrowser(((IFile)target).getLocation(), liveReloadServer);
        }
    }
}

