/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.project;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.build.ArchiveBuildDelegate;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeVisitor;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;
import org.jboss.ide.eclipse.archives.core.util.internal.TrueZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivesBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.jboss.ide.eclipse.archives.core.archivesBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!ArchivesCore.getInstance().getPreferenceManager().isArchivesBuilderEnabled(this.getProject().getLocation())) {
            return new IProject[0];
        }
        IProject[] interestingProjects = this.getInterestingProjectsInternal();
        TreeSet<IPath> addedChanged = this.createPathTreeSet();
        TreeSet<IPath> removed = this.createPathTreeSet();
        ArchiveBuildDelegate delegate = new ArchiveBuildDelegate();
        if (kind == 10 || kind == 9) {
            this.fillDeltas(interestingProjects, addedChanged, removed);
            delegate.incrementalBuild(null, addedChanged, removed, true, monitor);
        } else if (kind == 6) {
            IProject p = this.getProject();
            delegate.fullProjectBuild(p.getLocation(), monitor);
        }
        return interestingProjects;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IPath p = this.getProject().getLocation();
        IArchiveModelRootNode root = ArchivesModel.instance().getRoot(p);
        if (root != null) {
            IArchiveNode[] nodes = root.getChildren(0);
            int i = 0;
            while (i < nodes.length) {
                IPath path = ((IArchive)nodes[i]).getArchiveFilePath();
                TrueZipUtil.deleteAll(path);
                ++i;
            }
        }
    }

    protected void fillDeltas(IProject[] projects, final TreeSet<IPath> addedChanged, final TreeSet<IPath> removed) {
        int i = 0;
        while (i < projects.length) {
            final IProject proj = projects[i];
            IResourceDelta delta = this.getDelta(proj);
            if (delta != null) {
                try {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            if (delta.getResource().getType() == 1) {
                                if ((delta.getKind() & 1) > 0 || (delta.getKind() & 4) > 0) {
                                    if (!delta.getResource().equals((Object)proj.findMember(".packages"))) {
                                        addedChanged.add(delta.getResource().getFullPath());
                                    }
                                } else if ((delta.getKind() & 2) > 0) {
                                    removed.add(delta.getResource().getFullPath());
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }

    protected IProject[] getInterestingProjectsInternal() {
        final TreeSet<IProject> set = this.createProjectTreeSet();
        set.add(this.getProject());
        final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IArchiveModelRootNode root = ArchivesModel.instance().getRoot(this.getProject().getLocation());
        if (root != null) {
            root.accept(new IArchiveNodeVisitor(){

                public boolean visit(IArchiveNode node) {
                    IArchiveFileSet fileset;
                    IPath p;
                    if (node.getNodeType() == 2 && (p = PathUtils.getGlobalLocation(fileset = (IArchiveFileSet)node)) != null) {
                        IContainer[] containers = workspaceRoot.findContainersForLocation(p);
                        int i = 0;
                        while (i < containers.length) {
                            set.add(containers[i].getProject());
                            ++i;
                        }
                    }
                    return true;
                }
            });
            return set.toArray(new IProject[set.size()]);
        }
        return new IProject[0];
    }

    protected TreeSet<IProject> createProjectTreeSet() {
        return new TreeSet<IProject>(new Comparator<IProject>(){

            @Override
            public int compare(IProject o1, IProject o2) {
                if (o1.equals((Object)o2)) {
                    return 0;
                }
                return -1;
            }
        });
    }

    protected TreeSet<IPath> createPathTreeSet() {
        return new TreeSet<IPath>(new Comparator<IPath>(){

            @Override
            public int compare(IPath o1, IPath o2) {
                if (o1.equals((Object)o2)) {
                    return 0;
                }
                return -1;
            }
        });
    }
}

