/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbFileSet;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;
import org.jboss.ide.eclipse.archives.core.xpl.AntNLS;

public class ArchiveFileSetImpl
extends ArchiveNodeImpl
implements IArchiveStandardFileSet {
    private DirectoryScannerFactory.DirectoryScannerExtension scanner;
    private DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] matchingPaths;
    private HashMap<String, ArrayList<DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper>> matchingMap;
    private boolean rescanRequired = true;

    public ArchiveFileSetImpl() {
        this(new XbFileSet());
    }

    public ArchiveFileSetImpl(XbFileSet delegate) {
        super(delegate);
    }

    public String getExcludesPattern() {
        return this.getFileSetDelegate().getExcludes();
    }

    public boolean isInWorkspace() {
        return this.getFileSetDelegate().isInWorkspace();
    }

    public String getIncludesPattern() {
        return this.getFileSetDelegate().getIncludes();
    }

    public String getRawSourcePath() {
        return this.getFileSetDelegate().getDir();
    }

    public boolean isFlattened() {
        return this.getFileSetDelegate().isFlattened();
    }

    public boolean matchesPath(IPath globalPath) {
        return this.matchesPath(globalPath, false);
    }

    public boolean matchesPath(IPath path, boolean inWorkspace) throws IllegalStateException {
        ArrayList<DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper> result;
        DirectoryScannerFactory.DirectoryScannerExtension scanner = null;
        scanner = this.getScanner(false, true);
        IPath globalPath = path;
        if (inWorkspace) {
            globalPath = ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath(path);
        }
        if ((result = this.matchingMap.get(globalPath.toFile().getAbsolutePath())) != null && result.size() > 0) {
            return true;
        }
        return scanner == null ? false : scanner.couldBeIncluded(path.toString(), inWorkspace);
    }

    public DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] getMatches(IPath path) {
        this.getScanner(true, false);
        ArrayList<DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper> l = this.matchingMap.get(path.toFile().getAbsolutePath());
        if (l != null) {
            return l.toArray(new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[l.size()]);
        }
        return new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[0];
    }

    public synchronized DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] findMatchingPaths() throws IllegalStateException {
        this.getScanner(false, true);
        return this.matchingPaths;
    }

    public synchronized DirectoryScannerFactory.DirectoryScannerExtension getScanner() {
        return this.getScanner(true, false);
    }

    public synchronized DirectoryScannerFactory.DirectoryScannerExtension getScanner(boolean logError, boolean rethrow) throws IllegalStateException {
        block5: {
            if (this.scanner == null || this.rescanRequired) {
                this.rescanRequired = false;
                try {
                    this.scanner = DirectoryScannerFactory.createDirectoryScanner(this, true);
                    if (this.scanner != null) {
                        this.matchingPaths = this.scanner.getMatchedArray();
                        this.matchingMap = this.scanner.getMatchedMap();
                    }
                }
                catch (IllegalStateException ise) {
                    if (logError) {
                        ArchivesCore.getInstance().getLogger().log(2, AntNLS.bind(ArchivesCoreMessages.CouldNotCreateScanner, ise.getMessage()), ise);
                    }
                    this.matchingPaths = new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[0];
                    this.matchingMap = new HashMap();
                    if (!rethrow) break block5;
                    throw ise;
                }
            }
        }
        return this.scanner;
    }

    public int getNodeType() {
        return 2;
    }

    public void setExcludesPattern(String excludes) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.excludes", this.getExcludesPattern(), excludes);
        this.getFileSetDelegate().setExcludes(excludes);
        this.rescanRequired = true;
    }

    public void setIncludesPattern(String includes) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.includes", this.getIncludesPattern(), includes);
        this.getFileSetDelegate().setIncludes(includes);
        this.rescanRequired = true;
    }

    public void setInWorkspace(boolean isInWorkspace) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.inWorkspace", new Boolean(this.isInWorkspace()), new Boolean(isInWorkspace));
        this.getFileSetDelegate().setInWorkspace(isInWorkspace);
        this.rescanRequired = true;
    }

    public void setFlattened(boolean flat) {
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.flattened", new Boolean(this.isFlattened()), new Boolean(flat));
        this.getFileSetDelegate().setFlattened(flat);
        this.rescanRequired = true;
    }

    public void setRawSourcePath(String raw) {
        Assert.isNotNull((Object)raw);
        String src = this.getRawSourcePath();
        this.attributeChanged("org.jboss.ide.eclipse.archives.core.model.IPackageFileSet.sourcePath", src == null ? null : src.toString(), raw == null ? null : raw);
        this.getFileSetDelegate().setDir(raw);
        this.rescanRequired = true;
    }

    protected XbFileSet getFileSetDelegate() {
        return (XbFileSet)this.nodeDelegate;
    }

    public IPath getRootArchiveRelativePath() {
        return this.getParent().getRootArchiveRelativePath();
    }

    public void resetScanner() {
        this.rescanRequired = true;
    }

    public boolean validateModel() {
        return this.getAllChildren().length == 0;
    }

    public boolean canBuild() {
        return PathUtils.getGlobalLocation(this) != null && super.canBuild();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{dir=");
        sb.append(this.getFileSetDelegate().getDir());
        sb.append(",includes=");
        sb.append(this.getFileSetDelegate().getIncludes());
        sb.append(",excludes=");
        sb.append(this.getFileSetDelegate().getExcludes());
        sb.append(",inWorkspace=");
        sb.append(this.getFileSetDelegate().isInWorkspace());
        sb.append(",flatten=");
        sb.append(this.getFileSetDelegate().isFlattened());
        return sb.toString();
    }
}

