/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.EventManager;
import org.jboss.ide.eclipse.archives.core.model.IArchiveBuildListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModel;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeVisitor;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveModelNode;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XMLBinding;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackages;
import org.jboss.ide.eclipse.archives.core.util.ModelUtil;

public class ArchivesModel
implements IArchiveModel {
    protected static IArchiveModel instance;
    private HashMap<IPath, XbPackages> xbPackages = new HashMap();
    private HashMap<IPath, ArchiveModelNode> archivesRoot = new HashMap();
    private ArrayList<IArchiveBuildListener> buildListeners = new ArrayList();
    private ArrayList<IArchiveModelListener> modelListeners = new ArrayList();

    public static IArchiveModel instance() {
        if (instance == null) {
            instance = new ArchivesModel();
        }
        return instance;
    }

    public void addBuildListener(IArchiveBuildListener listener) {
        if (!this.buildListeners.contains(listener)) {
            this.buildListeners.add(listener);
        }
    }

    public void removeBuildListener(IArchiveBuildListener listener) {
        this.buildListeners.remove(listener);
    }

    public IArchiveBuildListener[] getBuildListeners() {
        return this.buildListeners.toArray(new IArchiveBuildListener[this.buildListeners.size()]);
    }

    public void addModelListener(IArchiveModelListener listener) {
        if (!this.modelListeners.contains(listener)) {
            this.modelListeners.add(listener);
        }
    }

    public void removeModelListener(IArchiveModelListener listener) {
        if (this.modelListeners.contains(listener)) {
            this.modelListeners.remove(listener);
        }
    }

    public IArchiveModelListener[] getModelListeners() {
        return this.modelListeners.toArray(new IArchiveModelListener[this.modelListeners.size()]);
    }

    public IArchiveModelRootNode[] getModelNodes() {
        Collection<ArchiveModelNode> c = this.archivesRoot.values();
        return c.toArray(new IArchiveModelRootNode[c.size()]);
    }

    public boolean accept(IArchiveNodeVisitor visitor) {
        IArchiveModelRootNode[] children = this.getModelNodes();
        boolean keepGoing = true;
        if (keepGoing) {
            int i = 0;
            while (i < children.length) {
                if (keepGoing) {
                    keepGoing = children[i].accept(visitor);
                }
                ++i;
            }
        }
        return keepGoing;
    }

    public IArchiveModelRootNode getRoot(IPath project) {
        return this.archivesRoot.get(project);
    }

    public boolean isProjectRegistered(IPath projectPath) {
        return projectPath != null && this.archivesRoot.containsKey(projectPath);
    }

    public boolean canReregister(IPath projectPath) {
        return this.canReregister(projectPath, ".packages");
    }

    public boolean canReregister(IPath projectPath, String file) {
        if (projectPath != null && file != null) {
            IPath p = projectPath.append(file);
            try {
                String result = ArchivesCore.getInstance().getVFS().performStringSubstitution(p.toString(), null, false);
                return new Path(result).toFile().exists();
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    public IArchiveModelRootNode registerProject(IPath projectPath, IProgressMonitor monitor) throws ArchivesModelException {
        return this.registerProject(projectPath, ".packages", monitor);
    }

    public IArchiveModelRootNode registerProject(IPath projectPath, String file, IProgressMonitor monitor) throws ArchivesModelException {
        XbPackages packages;
        if (projectPath == null) {
            return null;
        }
        IPath packagesFile = projectPath.append(file);
        if (packagesFile.toFile().exists()) {
            try {
                packages = XMLBinding.unmarshal(packagesFile.toFile(), monitor);
            }
            catch (XMLBinding.XbException xbe) {
                String msg = ArchivesCore.bind(ArchivesCoreMessages.ErrorUnmarshallingFile, packagesFile.toString());
                ArchivesCore.getInstance().getLogger().log(4, msg, xbe);
                throw new ArchivesModelException(new RuntimeException(msg, xbe));
            }
        } else {
            packages = new XbPackages();
            packages.setVersion(1.3);
        }
        ArchiveModelNode modelNode = new ArchiveModelNode(projectPath, projectPath.append(file), packages, this);
        ModelUtil.fillArchiveModel(packages, modelNode);
        modelNode.clearDelta();
        this.registerProject(modelNode, monitor);
        return modelNode;
    }

    public void registerProject(IArchiveModelRootNode model, IProgressMonitor monitor) {
        if (!this.isProjectRegistered(model.getProjectPath())) {
            ArchivesCore.getInstance().preRegisterProject(model.getProjectPath());
            this.xbPackages.put(model.getProjectPath(), ((ArchiveModelNode)model).getXbPackages());
            this.archivesRoot.put(model.getProjectPath(), (ArchiveModelNode)model);
            model.setModel(this);
            this.fireRegisterProjectEvent((ArchiveModelNode)model);
        }
    }

    public void unregisterProject(IPath projectPath, IProgressMonitor monitor) {
        IArchiveModelRootNode root = this.getRoot(projectPath);
        this.xbPackages.remove(projectPath);
        this.archivesRoot.remove(projectPath);
        this.fireUnregisterProjectEvent(root);
    }

    public void unregisterProject(IArchiveModelRootNode model, IProgressMonitor monitor) {
        this.xbPackages.remove(model.getProjectPath());
        this.archivesRoot.remove(model.getProjectPath());
        this.fireUnregisterProjectEvent((ArchiveModelNode)model);
    }

    protected void fireRegisterProjectEvent(IArchiveModelRootNode newRoot) {
        this.fireRegistrationEvent(null, newRoot, 2048);
    }

    protected void fireUnregisterProjectEvent(IArchiveModelRootNode oldRoot) {
        this.fireRegistrationEvent(oldRoot, null, 4096);
    }

    protected void fireRegistrationEvent(final IArchiveModelRootNode oldRoot, final IArchiveModelRootNode newRoot, final int type) {
        IArchiveNodeDelta delta = new IArchiveNodeDelta(){

            public IArchiveNodeDelta[] getAddedChildrenDeltas() {
                return null;
            }

            public IArchiveNodeDelta[] getAllAffectedChildren() {
                return null;
            }

            public IArchiveNodeDelta.INodeDelta getAttributeDelta(String key) {
                return null;
            }

            public String[] getAttributesWithDeltas() {
                return null;
            }

            public IArchiveNodeDelta[] getChangedDescendentDeltas() {
                return null;
            }

            public int getKind() {
                return type;
            }

            public IArchiveNode getPostNode() {
                return newRoot;
            }

            public IArchiveNode getPreNode() {
                return oldRoot;
            }

            public String[] getPropertiesWithDeltas() {
                return null;
            }

            public IArchiveNodeDelta.INodeDelta getPropertyDelta(String key) {
                return null;
            }

            public IArchiveNodeDelta[] getRemovedChildrenDeltas() {
                return null;
            }
        };
        EventManager.fireDelta(delta);
    }
}

