/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.build;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.jboss.ide.eclipse.archives.core.model.AbstractBuildListener;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;

public class PostBuildRefresher
extends AbstractBuildListener {
    public void finishedBuildingArchive(final IArchive pkg) {
        if (pkg.isDestinationInWorkspace()) {
            new WorkspaceJob("Refresh Project"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    PostBuildRefresher.this.handlePostBuild(pkg);
                    return Status.OK_STATUS;
                }
            }.schedule(1000L);
        }
    }

    private void handlePostBuild(IArchive pkg) {
        IProject p;
        String projectName = pkg.getProjectName();
        IProject iProject = p = projectName == null ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (p == null || !p.exists()) {
            return;
        }
        IPath loc = PathUtils.getGlobalLocation(pkg);
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(loc);
        int i = 0;
        while (i < files.length) {
            try {
                files[i].refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            ++i;
        }
        IContainer[] folders = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(loc);
        int i2 = 0;
        while (i2 < folders.length) {
            try {
                folders[i2].refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            ++i2;
        }
    }
}

