/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELMethodInvocation;
import org.jboss.tools.common.el.core.model.ELObject;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.IRelevanceCheck;
import org.jboss.tools.common.el.core.resolver.SimpleELContext;
import org.jboss.tools.common.util.BeanUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.preferences.ELSearchPreferences;

public abstract class RefactorSearcher {
    protected static final String JAVA_EXT = "java";
    protected static final String XML_EXT = "xml";
    protected static final String XHTML_EXT = "xhtml";
    protected static final String JSP_EXT = "jsp";
    protected static final String JSPX_EXT = "jspx";
    protected static final String PROPERTIES_EXT = "properties";
    protected static final String SEAM_PROPERTIES_FILE = "seam.properties";
    protected IFile baseFile;
    protected String propertyName;
    protected IJavaElement javaElement;
    protected IJavaSearchScope searchScope;
    private long timeLimit = 60000L;
    private long timeUsed = 0L;
    private HashSet<IProject> doneProjects = new HashSet();

    public RefactorSearcher(IFile baseFile, String propertyName) {
        this.baseFile = baseFile;
        this.propertyName = propertyName;
        if (baseFile != null) {
            this.timeLimit = ELSearchPreferences.getElSearchTimeLimit(baseFile.getProject());
        }
    }

    public RefactorSearcher(IFile baseFile, String propertyName, IJavaElement javaElement) {
        this(baseFile, propertyName);
        this.javaElement = javaElement;
        if (baseFile != null) {
            this.timeLimit = ELSearchPreferences.getElSearchTimeLimit(baseFile.getProject());
        }
    }

    public void setSearchScope(IJavaSearchScope searchScope) {
        this.searchScope = searchScope;
    }

    private void scanProject(IProject project, IProgressMonitor monitor) {
        IProject[] referencingProject;
        if (project == null || !project.exists()) {
            return;
        }
        if (this.doneProjects.contains(project)) {
            return;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.doneProjects.add(project);
        IProject[] iProjectArray = referencingProject = project.getReferencingProjects();
        int n = referencingProject.length;
        int n2 = 0;
        while (n2 < n) {
            IProject rProject = iProjectArray[n2];
            this.scanProject(rProject, monitor);
            ++n2;
        }
        try {
            if (!this.containsInSearchScope(project) || !project.hasNature("org.jboss.tools.jst.web.kb.kbnature")) {
                return;
            }
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
            return;
        }
        this.updateEnvironment(project);
        IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            IResource[] iResourceArray = EclipseUtil.getJavaSourceRoots((IProject)project);
            int n3 = iResourceArray.length;
            n = 0;
            while (n < n3) {
                IResource resource = iResourceArray[n];
                if (resource instanceof IFolder) {
                    if (!this.scan(monitor, (IContainer)((IFolder)resource), true)) {
                        this.outOfSynch(resource);
                        return;
                    }
                    if (resource instanceof IFile && !this.scan(monitor, (IFile)resource, true)) {
                        this.outOfSynch(resource);
                        return;
                    }
                }
                ++n;
            }
        }
        if (this.getViewFolder(project) != null) {
            if (!this.scan(monitor, this.getViewFolder(project), false)) {
                this.outOfSynch((IResource)project);
                return;
            }
        } else if (!this.scan(monitor, (IContainer)project, false)) {
            this.outOfSynch((IResource)project);
            return;
        }
    }

    public final void findELReferences(IProgressMonitor monitor) {
        IProject[] projects;
        if (this.baseFile == null) {
            return;
        }
        this.doneProjects.clear();
        IProject[] iProjectArray = projects = this.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.scanProject(project, monitor);
            ++n2;
        }
    }

    protected void updateEnvironment(IProject project) {
    }

    protected abstract IProject[] getProjects();

    protected IContainer getViewFolder(IProject project) {
        IPath path = WebUtils.getFirstWebContentPath((IProject)project);
        if (path != null) {
            return path.segmentCount() > 1 ? project.getFolder(path.removeFirstSegments(1)) : project;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean scan(IProgressMonitor monitor, IContainer container, boolean addJava) {
        if (monitor != null && monitor.isCanceled()) {
            return true;
        }
        if (this.timeUsed > this.timeLimit) {
            return true;
        }
        if (container.isDerived()) {
            return true;
        }
        if (container.getName().startsWith(".")) {
            return true;
        }
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder ? !this.scan(monitor, (IContainer)((IFolder)resource), addJava) : resource instanceof IFile && !this.scan(monitor, (IFile)resource, addJava)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            ELCorePlugin.getDefault().logError((Throwable)ex);
        }
        return true;
    }

    private String getFileContent(IFile file) {
        try {
            return FileUtil.readStream((IFile)file);
        }
        catch (CoreException e) {
            ELCorePlugin.getDefault().logError((Throwable)e);
            return null;
        }
    }

    private boolean scan(IProgressMonitor monitor, IFile file, boolean addJava) {
        if (this.isFilePhantom(file)) {
            return true;
        }
        if (this.isFileOutOfSynch(file)) {
            return false;
        }
        if (this.timeUsed > this.timeLimit) {
            return true;
        }
        if (monitor != null && monitor.isCanceled()) {
            return true;
        }
        if (addJava && PROPERTIES_EXT.equalsIgnoreCase(file.getFileExtension())) {
            if (file.getName().equals(SEAM_PROPERTIES_FILE)) {
                String content = this.getFileContent(file);
                this.scanProperties(file, content);
            } else {
                long t = System.currentTimeMillis();
                this.searchInCach(file);
                this.timeUsed += System.currentTimeMillis() - t;
            }
        } else if (addJava && JAVA_EXT.equalsIgnoreCase(file.getFileExtension()) || JSP_EXT.equalsIgnoreCase(file.getFileExtension()) || JSPX_EXT.equalsIgnoreCase(file.getFileExtension()) || XHTML_EXT.equalsIgnoreCase(file.getFileExtension()) || XML_EXT.equalsIgnoreCase(file.getFileExtension())) {
            long t = System.currentTimeMillis();
            this.searchInCach(file);
            this.timeUsed += System.currentTimeMillis() - t;
        }
        return true;
    }

    private void resolveByResolvers(ELExpression operand, ELResolver[] resolvers, ELContext context, IRelevanceCheck[] checks, int offset, List<MatchArea> areas, IFile file) {
        int i = 0;
        while (i < resolvers.length) {
            ELResolution resolution;
            ELResolver resolver = resolvers[i];
            if (checks[i].isRelevant(operand.getText()) && (resolution = resolver.resolve(context, operand, offset)) != null) {
                List segments = resolution.findSegmentsByJavaElement(this.javaElement);
                for (ELSegment segment : segments) {
                    int l;
                    int o = offset + segment.getSourceReference().getStartPosition();
                    if (this.contains(areas, o, l = segment.getSourceReference().getLength())) continue;
                    this.match(file, o, l);
                    areas.add(new MatchArea(o, l));
                }
            }
            ++i;
        }
    }

    protected void searchInCach(IFile file) {
        if (file == null || !file.isAccessible() || file.isDerived(512)) {
            return;
        }
        ELResolver[] resolvers = ELResolverFactoryManager.getInstance().getResolvers((IResource)file);
        ELContext context = PageContextFactory.createPageContext(file);
        if (context == null) {
            return;
        }
        ELReference[] references = context.getELReferences();
        if (this.javaElement != null) {
            resolvers = context.getElResolvers();
            IRelevanceCheck[] checks = this.getRelevanceChecks(resolvers);
            ArrayList<MatchArea> areas = new ArrayList<MatchArea>();
            ELReference[] eLReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                ELReference reference = eLReferenceArray[n2];
                int offset = reference.getStartPosition();
                ELExpression[] eLExpressionArray = reference.getEl();
                int n3 = eLExpressionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ELExpression operand = eLExpressionArray[n4];
                    this.resolveByResolvers(operand, resolvers, context, checks, offset, areas, file);
                    for (ELObject child : operand.getChildren()) {
                        if (!(child instanceof ELExpression)) continue;
                        this.resolveByResolvers((ELExpression)child, resolvers, context, checks, offset, areas, file);
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            ELReference[] eLReferenceArray = references;
            int n = references.length;
            int n5 = 0;
            while (n5 < n) {
                ELExpression[] expressions;
                ELReference reference = eLReferenceArray[n5];
                int offset = reference.getStartPosition();
                ELExpression[] eLExpressionArray = expressions = reference.getEl();
                int n6 = expressions.length;
                int n7 = 0;
                while (n7 < n6) {
                    ELInvocationExpression expression;
                    ELExpression operand = eLExpressionArray[n7];
                    if (operand instanceof ELInvocationExpression && (expression = this.findComponentReference((ELInvocationExpression)operand)) != null) {
                        this.checkMatch(file, (ELExpression)expression, offset + this.getOffset(expression), this.getLength(expression));
                    }
                    for (ELObject child : operand.getChildren()) {
                        ELInvocationExpression expression2;
                        if (!(child instanceof ELInvocationExpression) || (expression2 = this.findComponentReference((ELInvocationExpression)child)) == null) continue;
                        this.checkMatch(file, (ELExpression)expression2, offset + this.getOffset(expression2), this.getLength(expression2));
                    }
                    ++n7;
                }
                ++n5;
            }
        }
    }

    private boolean contains(List<MatchArea> list, int offset, int length) {
        for (MatchArea area : list) {
            if (area.offset != offset || area.length != length) continue;
            return true;
        }
        return false;
    }

    protected IRelevanceCheck[] getRelevanceChecks(ELResolver[] resolvers) {
        IRelevanceCheck[] checks = new IRelevanceCheck[resolvers.length];
        int i = 0;
        while (i < checks.length) {
            checks[i] = resolvers[i].createRelevanceCheck(this.javaElement);
            ++i;
        }
        return checks;
    }

    protected int getOffset(ELInvocationExpression expression) {
        ELMethodInvocation mi;
        if (expression instanceof ELPropertyInvocation) {
            ELPropertyInvocation pi = (ELPropertyInvocation)expression;
            if (pi.getName() != null) {
                return pi.getName().getStart();
            }
        } else if (expression instanceof ELMethodInvocation && (mi = (ELMethodInvocation)expression).getName() != null) {
            return mi.getName().getStart();
        }
        return 0;
    }

    private int getLength(ELInvocationExpression expression) {
        ELMethodInvocation mi;
        if (expression instanceof ELPropertyInvocation) {
            ELPropertyInvocation pi = (ELPropertyInvocation)expression;
            if (pi.getName() != null) {
                return pi.getName().getLength();
            }
        } else if (expression instanceof ELMethodInvocation && (mi = (ELMethodInvocation)expression).getName() != null) {
            return mi.getName().getLength();
        }
        return 0;
    }

    private void scanProperties(IFile file, String content) {
        if (!file.getName().equals(SEAM_PROPERTIES_FILE)) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(content, "#= \t\r\n\f", true);
        String lastToken = "\n";
        int offset = 0;
        boolean comment = false;
        boolean key = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken("#= \t\r\n\f");
            if (token.equals("\r")) {
                token = "\n";
            }
            if (token.equals("#") && lastToken.equals("\n")) {
                comment = true;
            } else if (token.equals("\n") && comment) {
                comment = false;
            }
            if (!comment) {
                if (!token.equals("\n") && lastToken.equals("\n")) {
                    key = true;
                } else if (key && (token.equals("=") || token.equals(" "))) {
                    key = false;
                }
                if (key && token.startsWith(this.propertyName)) {
                    this.match(file, offset, token.length());
                }
            }
            lastToken = token;
            offset += token.length();
        }
    }

    protected ELInvocationExpression findComponentReference(ELInvocationExpression invocationExpression) {
        return invocationExpression;
    }

    protected boolean isFileOutOfSynch(IFile file) {
        return !file.isSynchronized(0);
    }

    protected boolean isFilePhantom(IFile file) {
        return file.isPhantom();
    }

    protected boolean isFileReadOnly(IFile file) {
        return file.isReadOnly();
    }

    protected abstract void outOfSynch(IResource var1);

    protected abstract void match(IFile var1, int var2, int var3);

    protected void checkMatch(IFile file, ELExpression operand, int offset, int length) {
        if (this.javaElement != null && operand != null) {
            this.resolve(file, operand, offset - this.getOffset((ELInvocationExpression)operand));
        } else {
            this.match(file, offset, length);
        }
    }

    public static String getPropertyName(IMethod method, String methodName) {
        String propertyName;
        if ((BeanUtil.isGetter((IMethod)method) || BeanUtil.isSetter((IMethod)method)) && (propertyName = BeanUtil.getPropertyName((String)methodName)) != null) {
            return propertyName;
        }
        return methodName;
    }

    public static String getPropertyName(IType method, String className) {
        StringBuffer name = new StringBuffer(className);
        if (name.length() < 2 || Character.isLowerCase(name.charAt(1))) {
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        }
        String propertyName = name.toString();
        return propertyName;
    }

    private boolean containsInSearchScope(IProject project) {
        IPath[] paths;
        if (this.searchScope == null) {
            return true;
        }
        IPath[] iPathArray = paths = this.searchScope.enclosingProjectsAndJars();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (path.equals((Object)project.getFullPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void resolve(IFile file, ELExpression operand, int offset) {
        ELResolver[] resolvers;
        ELResolver[] eLResolverArray = resolvers = ELResolverFactoryManager.getInstance().getResolvers((IResource)file);
        int n = resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            ELResolver resolver = eLResolverArray[n2];
            SimpleELContext context = new SimpleELContext();
            context.setResource(file);
            context.setElResolvers(resolvers);
            List vars = ElVarSearcher.findAllVars((ELContext)context, (int)offset, (ELResolver)resolver);
            context.setVars(vars);
            ELResolution resolution = resolver.resolve((ELContext)context, operand, offset);
            if (resolution != null) {
                List segments = resolution.findSegmentsByJavaElement(this.javaElement);
                for (ELSegment segment : segments) {
                    this.match(file, offset + segment.getSourceReference().getStartPosition(), segment.getSourceReference().getLength());
                }
            }
            ++n2;
        }
    }

    class MatchArea {
        int offset;
        int length;

        public MatchArea(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

