/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.jst.web.kb.refactoring.ELProjectSetExtension;
import org.jboss.tools.jst.web.kb.refactoring.IProjectsSet;
import org.jboss.tools.jst.web.kb.refactoring.RefactorSearcher;

public class ELReferencesQueryParticipant
implements IQueryParticipant {
    private ELSearcher searcher;

    public int estimateTicks(QuerySpecification specification) {
        return 10;
    }

    public IMatchPresentation getUIParticipant() {
        return null;
    }

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        IFile file;
        IJavaElement element;
        if (querySpecification instanceof ElementQuerySpecification && this.isSearchForReferences(querySpecification.getLimitTo()) && ((element = ((ElementQuerySpecification)querySpecification).getElement()) instanceof IField || element instanceof IMethod || element instanceof IType) && (file = (IFile)element.getResource()) != null) {
            String name = element.getElementName();
            this.searcher = new ELSearcher(requestor, element, file, name);
            this.searcher.setSearchScope(querySpecification.getScope());
            this.searcher.findELReferences(monitor);
        }
    }

    public boolean isSearchForReferences(int limitTo) {
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        return maskedLimitTo == 2 || maskedLimitTo == 3;
    }

    class ELSearcher
    extends RefactorSearcher {
        ISearchRequestor requestor;
        IProjectsSet projectSet;

        public ELSearcher(ISearchRequestor requestor, IJavaElement element, IFile file, String name) {
            super(file, name, element);
            this.projectSet = null;
            this.requestor = requestor;
            ELProjectSetExtension[] extensions = ELProjectSetExtension.getInstances();
            if (extensions.length > 0) {
                this.projectSet = extensions[0].getProjectSet();
                if (this.projectSet != null) {
                    this.projectSet.init(file.getProject());
                }
            }
        }

        @Override
        protected void outOfSynch(IResource resource) {
        }

        @Override
        protected void match(IFile file, int offset, int length) {
            Match match = new Match((Object)file, offset, length);
            this.requestor.reportMatch(match);
        }

        @Override
        protected IProject[] getProjects() {
            if (this.projectSet != null) {
                return this.projectSet.getLinkedProjects();
            }
            return new IProject[]{this.baseFile.getProject()};
        }

        @Override
        protected IContainer getViewFolder(IProject project) {
            if (this.projectSet != null) {
                return this.projectSet.getViewFolder(project);
            }
            return super.getViewFolder(project);
        }
    }
}

