/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractTagLib;
import org.jboss.tools.jst.web.kb.internal.taglib.ELFunction;
import org.jboss.tools.jst.web.kb.taglib.IELFunction;
import org.jboss.tools.jst.web.kb.taglib.IFunctionLibrary;
import org.w3c.dom.Element;

public abstract class FunctionTagLib
extends AbstractTagLib
implements IFunctionLibrary {
    protected List<ELFunction> functions = new ArrayList<ELFunction>();
    protected IELFunction[] functionArray = null;

    @Override
    public IELFunction[] getFunctions() {
        if (this.functionArray == null) {
            this.functionArray = this.functions.toArray(new ELFunction[0]);
        }
        return this.functionArray;
    }

    @Override
    public FunctionTagLib clone() throws CloneNotSupportedException {
        FunctionTagLib copy = (FunctionTagLib)super.clone();
        copy.functions = new ArrayList<ELFunction>();
        copy.functionArray = null;
        IELFunction[] iELFunctionArray = this.getFunctions();
        int n = iELFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IELFunction f = iELFunctionArray[n2];
            copy.addFunction(((ELFunction)f).clone());
            ++n2;
        }
        return copy;
    }

    public void addFunction(ELFunction f) {
        this.functions.add(f);
        this.functionArray = null;
    }

    @Override
    public List<Change> merge(KbObject s) {
        List changes = super.merge(s);
        FunctionTagLib t = (FunctionTagLib)s;
        Change children = new Change((Object)this, null, null, null);
        this.mergeFunctions(t, children);
        changes = Change.addChange(changes, (Change)children);
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFunctions(FunctionTagLib c, Change children) {
        IELFunction f;
        HashMap<Object, ELFunction> functionMap = new HashMap<Object, ELFunction>();
        Object object = this.getFunctions();
        int n = ((IELFunction[])object).length;
        int n2 = 0;
        while (n2 < n) {
            f = object[n2];
            functionMap.put(((KbObject)((Object)f)).getId(), (ELFunction)f);
            ++n2;
        }
        object = c.getFunctions();
        n = ((IELFunction[])object).length;
        n2 = 0;
        while (n2 < n) {
            f = object[n2];
            ELFunction loaded = (ELFunction)f;
            ELFunction current = (ELFunction)functionMap.get(loaded.getId());
            if (current == null) {
                this.addFunction(loaded);
                Change change = new Change((Object)this, null, null, (Object)loaded);
                children.addChildren(Change.addChange(null, (Change)change));
            } else {
                List<Change> rc = current.merge(loaded);
                if (rc != null) {
                    children.addChildren(rc);
                }
            }
            ++n2;
        }
        Iterator iterator = functionMap.values().iterator();
        while (iterator.hasNext()) {
            IELFunction removed = f = (ELFunction)iterator.next();
            object = this.functions;
            synchronized (object) {
                if (this.functions.contains(removed)) {
                    continue;
                }
                this.functions.remove(((ELFunction)removed).getName());
                this.functionArray = null;
            }
            Change change = new Change((Object)this, null, (Object)removed, null);
            children.addChildren(Change.addChange(null, (Change)change));
        }
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        IELFunction[] iELFunctionArray = this.getFunctions();
        int n = iELFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IELFunction f = iELFunctionArray[n2];
            ((KbObject)((Object)f)).toXML(element, context);
            ++n2;
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        Element[] cs;
        super.loadXML(element, context);
        Element[] elementArray = cs = XMLUtilities.getChildren((Element)element, (String)"function");
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Element e = elementArray[n2];
            ELFunction f = new ELFunction();
            f.loadXML(e, context);
            this.addFunction(f);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        IELFunction[] fs;
        IELFunction[] iELFunctionArray = fs = this.getFunctions();
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            IELFunction f = iELFunctionArray[n2];
            ((KbObject)((Object)f)).dispose();
            ++n2;
        }
        List<ELFunction> list = this.functions;
        synchronized (list) {
            this.functions.clear();
            this.functionArray = null;
        }
        super.dispose();
    }
}

