/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.FaceletAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.FacesConfigAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.myfaces.MyFacesAttribute;
import org.jboss.tools.jst.web.kb.taglib.Facet;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.kb.taglib.IAttributeProvider;
import org.jboss.tools.jst.web.kb.taglib.IContextAttributeProvider;
import org.jboss.tools.jst.web.kb.taglib.IContextComponent;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.w3c.dom.Element;

public abstract class AbstractComponent
extends KbObject
implements IContextComponent {
    public static final String DESCRIPTION = "description";
    public static final String COMPONENT_CLASS = "component-class";
    public static final String COMPONENT_TYPE = "component-type";
    public static final String BODY_CONTENT = "bodycontent";
    protected boolean canHaveBody = true;
    protected String componentClass;
    protected String componentType;
    protected String description;
    protected String name;
    protected boolean hasExtendedAttributes = false;
    protected Map<String, IAttribute> attributes = new HashMap<String, IAttribute>();
    private IAttribute[] attributesArray;
    private Map<String, IAttribute> preferableAttributes = new HashMap<String, IAttribute>();
    private IAttribute[] preferableAttributesArray;
    private Map<String, IAttribute> requiredAttributes = new HashMap<String, IAttribute>();
    private IAttribute[] requiredAttributesArray;
    protected boolean ignoreCase;
    private static final IAttribute[] EMPTY_ARRAY = new IAttribute[0];
    public static final Facet[] EMPTY_FACET_SET = new Facet[0];

    @Override
    public boolean canHaveBody() {
        return this.canHaveBody;
    }

    public void setCanHaveBody(boolean canHaveBody) {
        this.canHaveBody = canHaveBody;
    }

    public void setCanHaveBody(IValueInfo s) {
        this.canHaveBody = s == null || !"empty".equals(s.getValue());
        this.attributesInfo.put(BODY_CONTENT, s);
    }

    @Override
    public IAttribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public IAttribute[] getAttributes(IPageContext context, KbQuery query, String name) {
        IAttribute atr = this.attributes.get(name);
        if (atr != null) {
            return new IAttribute[]{atr};
        }
        return new IAttribute[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAttribute[] getAttributes() {
        if (this.attributesArray == null) {
            Map<String, IAttribute> map = this.attributes;
            synchronized (map) {
                this.attributesArray = this.attributes.values().toArray(new IAttribute[this.attributes.size()]);
            }
        }
        return this.attributesArray;
    }

    protected IAttributeProvider[] getProviders() {
        return null;
    }

    @Override
    public IAttribute[] getAttributes(String nameTemplate) {
        return this.getAttributes(nameTemplate, null, null);
    }

    public IAttribute[] getAttributes(String nameTemplate, IPageContext context, KbQuery query) {
        int n;
        ArrayList<IAttribute> list = new ArrayList<IAttribute>();
        IAttributeProvider[] providers = this.getProviders();
        ArrayList<IAttribute> atts = new ArrayList<IAttribute>();
        if (providers == null) {
            IAttribute[] atrs;
            IAttribute[] iAttributeArray = atrs = this.getAttributes();
            int n2 = atrs.length;
            n = 0;
            while (n < n2) {
                IAttribute a = iAttributeArray[n];
                atts.add(a);
                ++n;
            }
        } else {
            IAttributeProvider[] iAttributeProviderArray = providers;
            n = providers.length;
            int n3 = 0;
            while (n3 < n) {
                IAttributeProvider provider = iAttributeProviderArray[n3];
                IAttribute[] atrs = provider instanceof IContextAttributeProvider ? ((IContextAttributeProvider)provider).getAttributes(context, query) : provider.getAttributes(query);
                IAttribute[] iAttributeArray = atrs;
                int n4 = atrs.length;
                int n5 = 0;
                while (n5 < n4) {
                    IAttribute a = iAttributeArray[n5];
                    atts.add(a);
                    ++n5;
                }
                ++n3;
            }
        }
        for (IAttribute attribute : atts) {
            if (this.ignoreCase) {
                if (!attribute.getName().toLowerCase().startsWith(nameTemplate.toLowerCase()) || context != null && !this.checkExtended(attribute, context, query)) continue;
                list.add(attribute);
                continue;
            }
            if (!attribute.getName().startsWith(nameTemplate) || context != null && !this.checkExtended(attribute, context, query)) continue;
            list.add(attribute);
        }
        return list.toArray(new IAttribute[list.size()]);
    }

    @Override
    public IAttribute[] getAttributes(KbQuery query, String name) {
        return this.getAttributes(null, query, name);
    }

    @Override
    public IAttribute[] getAttributes(KbQuery query) {
        return this.getAttributes(null, query);
    }

    @Override
    public IAttribute[] getAttributes(KbQuery query, IPageContext context) {
        return this.getAttributes(context, query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAttribute[] getExtendedAttributes(IPageContext context, KbQuery query) {
        if (this.hasExtendedAttributes) {
            HashSet<IAttribute> attrs = new HashSet<IAttribute>();
            Map<String, IAttribute> map = this.attributes;
            synchronized (map) {
                for (IAttribute attribute : this.attributes.values()) {
                    if (!this.checkExtended(attribute, context, query)) continue;
                    attrs.add(attribute);
                }
            }
            return attrs.toArray(new IAttribute[0]);
        }
        return this.getAttributes();
    }

    protected boolean checkExtended(IAttribute attribute, IPageContext context, KbQuery query) {
        return true;
    }

    @Override
    public IAttribute[] getAttributes(IPageContext context, KbQuery query) {
        return this.getAttributes(context, query, false);
    }

    @Override
    public IAttribute[] getAttributes(IPageContext context, KbQuery query, boolean includeExtensions) {
        if (!includeExtensions) {
            return this.getAttributes();
        }
        String attrName = null;
        boolean mask = false;
        if (query.getType() == KbQuery.Type.ATTRIBUTE_NAME) {
            attrName = query.getValue();
            mask = query.isMask();
        } else if (query.getType() == KbQuery.Type.ATTRIBUTE_VALUE) {
            attrName = query.getParent();
        }
        if (attrName == null) {
            return EMPTY_ARRAY;
        }
        if (mask) {
            return this.getAttributes(attrName, context, query);
        }
        IAttribute[] attrs = this.getAttributes(context, query, attrName);
        ArrayList<IAttribute> list = new ArrayList<IAttribute>();
        IAttribute[] iAttributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            if (this.checkExtended(attr, context, query)) {
                list.add(attr);
            }
            ++n2;
        }
        return list.toArray(new IAttribute[list.size()]);
    }

    @Override
    public String getComponentClass() {
        return this.componentClass;
    }

    public void setComponentClass(String componentClass) {
        this.componentClass = componentClass;
    }

    public void setComponentClass(IValueInfo s) {
        this.componentClass = s == null ? null : s.getValue();
        this.attributesInfo.put(COMPONENT_CLASS, s);
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setComponentType(IValueInfo s) {
        this.componentType = s == null ? null : s.getValue();
        this.attributesInfo.put(COMPONENT_TYPE, s);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDescription(IValueInfo s) {
        this.description = s == null ? null : s.getValue();
        this.attributesInfo.put(DESCRIPTION, s);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(IValueInfo s) {
        this.name = s == null ? null : s.getValue();
        this.attributesInfo.put("name", s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAttribute[] getPreferableAttributes() {
        if (this.preferableAttributesArray == null) {
            Map<String, IAttribute> map = this.preferableAttributes;
            synchronized (map) {
                this.preferableAttributesArray = this.preferableAttributes.values().toArray(new IAttribute[this.preferableAttributes.size()]);
            }
        }
        return this.preferableAttributesArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAttribute[] getRequiredAttributes() {
        if (this.requiredAttributesArray == null) {
            Map<String, IAttribute> map = this.requiredAttributes;
            synchronized (map) {
                this.requiredAttributesArray = this.requiredAttributes.values().toArray(new IAttribute[this.requiredAttributes.size()]);
            }
        }
        return this.requiredAttributesArray;
    }

    @Override
    public Facet getFacet(String name) {
        return null;
    }

    @Override
    public Facet[] getFacets() {
        return EMPTY_FACET_SET;
    }

    @Override
    public Facet[] getFacets(String nameTemplate) {
        return EMPTY_FACET_SET;
    }

    @Override
    public TextProposal[] getProposals(KbQuery query, IPageContext context) {
        IAttribute[] attributes = this.getAttributes(context, query, true);
        if (attributes == null || attributes.length == 0) {
            return EMPTY_PROPOSAL_LIST;
        }
        ArrayList<TextProposal> proposals = null;
        if (query.getType() == KbQuery.Type.ATTRIBUTE_NAME) {
            proposals = new ArrayList<TextProposal>();
            int i = 0;
            while (i < attributes.length) {
                TextProposal proposal = new TextProposal();
                proposal.setSource((Object)attributes[i]);
                proposal.setContextInfo(attributes[i].getDescription());
                proposal.setReplacementString(attributes[i].getName());
                proposal.setLabel(attributes[i].getName());
                proposals.add(proposal);
                ++i;
            }
        } else if (query.getType() == KbQuery.Type.ATTRIBUTE_VALUE) {
            int i = 0;
            while (i < attributes.length) {
                TextProposal[] attributeProposals;
                TextProposal[] textProposalArray = attributeProposals = attributes[i] == null ? null : attributes[i].getProposals(query, context);
                if (attributeProposals != null && attributeProposals.length > 0 && proposals == null) {
                    proposals = new ArrayList();
                }
                int j = 0;
                while (attributeProposals != null && j < attributeProposals.length) {
                    proposals.add(attributeProposals[j]);
                    ++j;
                }
                ++i;
            }
        }
        if (proposals == null || proposals.isEmpty()) {
            return EMPTY_PROPOSAL_LIST;
        }
        return proposals.toArray(new TextProposal[proposals.size()]);
    }

    public void addAttribute(IAttribute attribute) {
        if (attribute instanceof KbObject) {
            this.adopt((KbObject)((Object)attribute));
        }
        this.attributes.put(attribute.getName(), attribute);
        if (attribute.isExtended()) {
            this.hasExtendedAttributes = true;
        }
        if (attribute.isPreferable()) {
            this.preferableAttributes.put(attribute.getName(), attribute);
        }
        if (attribute.isRequired()) {
            this.requiredAttributes.put(attribute.getName(), attribute);
        }
        this.clearAttributeArrays();
    }

    private void clearAttributeArrays() {
        this.attributesArray = null;
        this.preferableAttributesArray = null;
        this.requiredAttributesArray = null;
    }

    public void removeAttribute(IAttribute attribute) {
        this.attributes.remove(attribute.getName());
        this.preferableAttributes.remove(attribute.getName());
        this.requiredAttributes.remove(attribute.getName());
        if (this.hasExtendedAttributes) {
            this.initExtendedAttributeFlag();
        }
        this.clearAttributeArrays();
    }

    @Override
    public boolean isExtended() {
        return false;
    }

    @Override
    public ITagLibrary getTagLib() {
        return (ITagLibrary)((Object)this.parent);
    }

    protected void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public AbstractComponent clone() throws CloneNotSupportedException {
        IAttribute[] as;
        AbstractComponent copy = (AbstractComponent)super.clone();
        copy.attributes = new HashMap<String, IAttribute>();
        copy.preferableAttributes = new HashMap<String, IAttribute>();
        copy.requiredAttributes = new HashMap<String, IAttribute>();
        IAttribute[] iAttributeArray = as = this.getAttributes();
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute a = iAttributeArray[n2];
            if (a instanceof AbstractAttribute) {
                copy.addAttribute(((AbstractAttribute)a).clone());
            }
            if (a.isExtended()) {
                copy.hasExtendedAttributes = true;
            }
            ++n2;
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExtendedAttributeFlag() {
        Map<String, IAttribute> map = this.attributes;
        synchronized (map) {
            for (IAttribute a : this.attributes.values()) {
                if (!a.isExtended()) continue;
                this.hasExtendedAttributes = true;
            }
        }
    }

    @Override
    public List<Change> merge(KbObject s) {
        List changes = super.merge(s);
        AbstractComponent c = (AbstractComponent)s;
        if (!this.stringsEqual(this.name, c.name)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "name", (Object)this.name, (Object)c.name));
            this.name = c.name;
        }
        if (!this.stringsEqual(this.description, c.description)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, DESCRIPTION, (Object)this.description, (Object)c.description));
            this.description = c.description;
        }
        if (!this.stringsEqual(this.componentClass, c.componentClass)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, COMPONENT_CLASS, (Object)this.componentClass, (Object)c.componentClass));
            this.componentClass = c.componentClass;
        }
        if (!this.stringsEqual(this.componentType, c.componentType)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, COMPONENT_CLASS, (Object)this.componentType, (Object)c.componentType));
            this.componentType = c.componentType;
        }
        if (this.canHaveBody != c.canHaveBody) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, BODY_CONTENT, (Object)("" + this.canHaveBody), (Object)("" + c.canHaveBody)));
            this.canHaveBody = c.canHaveBody;
        }
        Change children = new Change((Object)this, null, null, null);
        this.mergeAttributes(c, children);
        changes = Change.addChange((List)changes, (Change)children);
        return changes;
    }

    public void mergeAttributes(AbstractComponent c, Change children) {
        IAttribute a2;
        HashMap<Object, AbstractAttribute> attributeMap = new HashMap<Object, AbstractAttribute>();
        IAttribute[] iAttributeArray = this.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            a2 = iAttributeArray[n2];
            if (a2 instanceof AbstractAttribute) {
                attributeMap.put(((KbObject)((Object)a2)).getId(), (AbstractAttribute)a2);
            }
            ++n2;
        }
        iAttributeArray = c.getAttributes();
        n = iAttributeArray.length;
        n2 = 0;
        while (n2 < n) {
            a2 = iAttributeArray[n2];
            if (a2 instanceof AbstractAttribute) {
                AbstractAttribute loaded = (AbstractAttribute)a2;
                AbstractAttribute current = (AbstractAttribute)attributeMap.remove(loaded.getId());
                if (current == null) {
                    this.addAttribute(loaded);
                    Change change = new Change((Object)this, null, null, (Object)loaded);
                    children.addChildren(Change.addChange(null, (Change)change));
                } else {
                    this.removeAttribute(current);
                    List<Change> rc = current.merge(loaded);
                    if (rc != null) {
                        children.addChildren(rc);
                    }
                    this.addAttribute(current);
                }
            }
            ++n2;
        }
        for (IAttribute a2 : attributeMap.values()) {
            AbstractAttribute removed;
            if (!(a2 instanceof AbstractAttribute) || this.attributes.get((removed = (AbstractAttribute)a2).getName()) != removed) continue;
            this.attributes.remove(removed.getName());
            Change change = new Change((Object)this, null, (Object)removed, null);
            children.addChildren(Change.addChange(null, (Change)change));
            this.clearAttributeArrays();
        }
    }

    @Override
    public String getXMLName() {
        return "component";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        if (this.attributesInfo.get("name") == null && this.name != null) {
            element.setAttribute("name", this.name);
        }
        IAttribute[] iAttributeArray = this.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute c = iAttributeArray[n2];
            if (c instanceof KbObject) {
                ((KbObject)((Object)c)).toXML(element, context);
            }
            ++n2;
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        Element[] cs;
        super.loadXML(element, context);
        this.setName((IValueInfo)this.attributesInfo.get("name"));
        if (this.name == null && element.hasAttribute("name")) {
            this.name = element.getAttribute("name");
        }
        this.setDescription((IValueInfo)this.attributesInfo.get(DESCRIPTION));
        this.setComponentClass((IValueInfo)this.attributesInfo.get(COMPONENT_CLASS));
        this.setCanHaveBody((IValueInfo)this.attributesInfo.get(BODY_CONTENT));
        this.setComponentType((IValueInfo)this.attributesInfo.get(COMPONENT_TYPE));
        Element[] elementArray = cs = XMLUtilities.getChildren((Element)element, (String)"attribute");
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Element e = elementArray[n2];
            String cls = e.getAttribute("class");
            AbstractAttribute c = null;
            if ("tld".equals(cls)) {
                c = new TLDAttribute();
            } else if ("faces-config".equals(cls)) {
                c = new FacesConfigAttribute();
            } else if ("composite".equals(cls)) {
                c = new CompositeAttribute();
            } else if ("facelet".equals(cls)) {
                c = new FaceletAttribute();
            } else if ("myfaces".equals(cls)) {
                c = new MyFacesAttribute();
            }
            if (c != null) {
                c.loadXML(e, context);
                this.addAttribute(c);
            }
            ++n2;
        }
    }

    @Override
    public void dispose() {
        IAttribute[] as;
        IAttribute[] iAttributeArray = as = this.getAttributes();
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute a = iAttributeArray[n2];
            this.removeAttribute(a);
            if (a instanceof KbObject) {
                ((KbObject)((Object)a)).dispose();
            }
            ++n2;
        }
        super.dispose();
    }
}

