/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.impl.ValueInfo;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.kb.internal.taglib.myfaces.MyFacesAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.myfaces.MyFacesComponent;
import org.jboss.tools.jst.web.kb.internal.taglib.myfaces.MyFacesTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class MyFacesScanner
implements IFileScanner {
    public static String METADATA_FILE_NAME = "myfaces-metadata.xml";
    static String F_PREFIX = "f";
    static String F_URI = "http://java.sun.com/jsf/core";
    static String H_PREFIX = "h";
    static String H_URI = "http://java.sun.com/jsf/html";
    static String UI_PREFIX = "ui";
    static String UI_URI = "http://java.sun.com/jsf/facelets";
    static String C_PREFIX = "c";
    static String C_URI = "http://java.sun.com/jstl/core";
    static String COMPOSITE_PREFIX = "composite";
    static String COMPOSITE_URI = "http://java.sun.com/jsf/composite";
    static Map<String, String> prefixToURI = new HashMap<String, String>();
    static String TAG_PROPERTY;
    static String TAG_ATTRIBUTE;
    static String ATTR_NAME;
    static String ATTR_DESCRIPTION;
    static String ATTR_REQUIRED;
    static String ATTR_PARENT_CLASS;
    static XModelObjectLoaderUtil util;

    static {
        prefixToURI.put(F_PREFIX, F_URI);
        prefixToURI.put(H_PREFIX, H_URI);
        prefixToURI.put(UI_PREFIX, UI_URI);
        prefixToURI.put(C_PREFIX, C_URI);
        prefixToURI.put(COMPOSITE_PREFIX, COMPOSITE_URI);
        TAG_PROPERTY = "property";
        TAG_ATTRIBUTE = "attribute";
        ATTR_NAME = "name.#text";
        ATTR_DESCRIPTION = "desc.#text";
        ATTR_REQUIRED = "required.#text";
        ATTR_PARENT_CLASS = "parentClassName.#text";
        util = new XModelObjectLoaderUtil();
    }

    @Override
    public boolean isRelevant(IFile resource) {
        return resource != null && resource.getName().equals(METADATA_FILE_NAME);
    }

    @Override
    public boolean isLikelyComponentSource(IFile f) {
        return f != null && f.getName().equals(METADATA_FILE_NAME);
    }

    @Override
    public LoadedDeclarations parse(IFile f, IKbProject sp) throws ScannerException {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return null;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        return this.parse(o, f.getFullPath(), sp);
    }

    public LoadedDeclarations parse(XModelObject o, IPath source, IKbProject sp) {
        if (o == null) {
            return null;
        }
        String text = ((FileAnyImpl)o).getAsText();
        Element model = XMLUtilities.getElement((InputStream)new ByteArrayInputStream(text.getBytes()), (EntityResolver)XMLEntityResolver.getInstance());
        if (model == null) {
            return null;
        }
        HashMap<String, MyFacesTagLibrary> libraries = new HashMap<String, MyFacesTagLibrary>();
        for (String p : prefixToURI.keySet()) {
            String uri = prefixToURI.get(p);
            MyFacesTagLibrary library = new MyFacesTagLibrary();
            library.setId(String.valueOf(o.getPath()) + "/" + p);
            library.setURI(this.createValueInfo(uri));
            libraries.put(p, library);
        }
        String[] tagnames = new String[]{"component", "tag", "faceletTag"};
        HashMap<String, MyFacesComponent> componentsByClass = new HashMap<String, MyFacesComponent>();
        String[] stringArray = tagnames;
        int n = tagnames.length;
        int library = 0;
        while (library < n) {
            Element[] cs;
            String tag = stringArray[library];
            Element[] elementArray = cs = XMLUtilities.getChildren((Element)model, (String)tag);
            int n2 = cs.length;
            int n3 = 0;
            while (n3 < n2) {
                Element c = elementArray[n3];
                this.processComponent(c, libraries, componentsByClass);
                ++n3;
            }
            ++library;
        }
        HashSet<MyFacesComponent> processed = new HashSet<MyFacesComponent>();
        for (String cls : componentsByClass.keySet()) {
            MyFacesComponent component = (MyFacesComponent)componentsByClass.get(cls);
            this.loadParents(component, componentsByClass, processed);
        }
        LoadedDeclarations ds = new LoadedDeclarations();
        for (MyFacesTagLibrary library2 : libraries.values()) {
            if (library2.getComponents().length <= 0) continue;
            ds.getLibraries().add(library2);
        }
        return ds;
    }

    void processComponent(Element c, Map<String, MyFacesTagLibrary> libraries, Map<String, MyFacesComponent> componentsByClass) {
        Element[] attributes;
        String parentClass;
        String description;
        String bodyContent;
        String type;
        String name = util.getAttribute(c, ATTR_NAME);
        String className = util.getAttribute(c, "className.#text");
        MyFacesComponent component = null;
        MyFacesTagLibrary library = null;
        boolean isNew = false;
        if (!this.isEmpty(name)) {
            String componentName = name.trim();
            int pi = componentName.indexOf(":");
            if (pi < 0) {
                return;
            }
            String prefix = componentName.substring(0, pi);
            library = libraries.get(prefix);
            if (library == null) {
                return;
            }
            component = (MyFacesComponent)library.getComponent(componentName = componentName.substring(pi + 1));
            if (component == null) {
                component = new MyFacesComponent();
                component.setId(componentName);
                component.setName(this.createValueInfo(componentName));
                isNew = true;
            }
        } else if (!this.isEmpty(className) && (component = componentsByClass.get(className)) == null) {
            component = new MyFacesComponent();
        }
        if (!this.isEmpty(className)) {
            component.setComponentClass(this.createValueInfo(className.trim()));
            componentsByClass.put(className, component);
        }
        if (!this.isEmpty(type = util.getAttribute(c, "type.#text"))) {
            component.setComponentType(this.createValueInfo(type.trim()));
        }
        if (!this.isEmpty(bodyContent = util.getAttribute(c, "bodyContent.#text"))) {
            component.setCanHaveBody(this.createValueInfo(bodyContent.trim()));
        }
        if (!this.isEmpty(description = util.getAttribute(c, ATTR_DESCRIPTION)) && !description.trim().equals("no description")) {
            component.setDescription(this.createValueInfo(description.trim()));
        }
        if (!this.isEmpty(parentClass = util.getAttribute(c, ATTR_PARENT_CLASS))) {
            component.setParentClass(this.createValueInfo(parentClass.trim()));
        }
        if ((attributes = XMLUtilities.getChildren((Element)c, (String)TAG_PROPERTY)) == null || attributes.length == 0) {
            attributes = XMLUtilities.getChildren((Element)c, (String)TAG_ATTRIBUTE);
        }
        if (attributes != null) {
            Element[] elementArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Element a = elementArray[n2];
                this.processAttribute(a, component);
                ++n2;
            }
        }
        if (isNew && library != null) {
            library.addComponent(component);
        }
    }

    void processAttribute(Element a, MyFacesComponent component) {
        String required;
        String description;
        String name = util.getAttribute(a, "jspName.#text");
        if (this.isEmpty(name)) {
            name = util.getAttribute(a, ATTR_NAME);
        }
        if (this.isEmpty(name)) {
            return;
        }
        name = name.trim();
        IAttribute[] attrs = component.getAttributes(null, KbQuery.EMPTY, name);
        MyFacesAttribute attribute = null;
        if (attrs.length > 0) {
            attribute = (MyFacesAttribute)attrs[0];
        }
        boolean isNew = false;
        if (attribute == null) {
            attribute = new MyFacesAttribute();
            attribute.setId(name);
            attribute.setName(this.createValueInfo(name));
            isNew = true;
        }
        if (!this.isEmpty(description = util.getAttribute(a, ATTR_DESCRIPTION)) && !description.trim().equals("no description")) {
            attribute.setDescription(this.createValueInfo(description.trim()));
        }
        if (!this.isEmpty(required = util.getAttribute(a, ATTR_REQUIRED))) {
            attribute.setRequired(this.createValueInfo(required.trim()));
        }
        if (isNew) {
            component.addAttribute(attribute);
        }
    }

    void loadParents(MyFacesComponent current, Map<String, MyFacesComponent> componentsByClass, Set<MyFacesComponent> processed) {
        IAttribute[] as;
        if (processed.contains(current)) {
            return;
        }
        processed.add(current);
        String parentClass = current.getParentClass();
        MyFacesComponent parent = componentsByClass.get(parentClass);
        if (parent == null) {
            return;
        }
        this.loadParents(parent, componentsByClass, processed);
        IAttribute[] iAttributeArray = as = parent.getAttributes();
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute a = iAttributeArray[n2];
            if (current.getAttributes(null, KbQuery.EMPTY, a.getName()).length == 0) {
                current.addAttribute(a);
            }
            ++n2;
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private IValueInfo createValueInfo(String value) {
        ValueInfo v = new ValueInfo();
        v.setValue(value);
        return v;
    }
}

