/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.scanner;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.impl.ValueInfo;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LibraryScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeComponent;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeTagLibrary;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.jboss.tools.jst.web.model.project.ext.store.XMLValueInfo;

public class JSF2ResourcesScanner
implements IFileScanner {
    public static String ATTR_SHORT_DESCRIPTION = "shortDescription";
    public static String URI_PREFIX = "http://java.sun.com/jsf/composite";
    public static String URI_PREFIX_22 = "http://xmlns.jcp.org/jsf/composite";
    public static String ENT_COMPOSITE_COMPONENT = "FileJSF2Component";
    public static String ENT_COMPOSITE_COMPONENT_22 = "FileJSF2Component22";

    @Override
    public boolean isLikelyComponentSource(IFile f) {
        if (!f.isSynchronized(0) || !f.exists()) {
            return false;
        }
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return false;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        if (o == null) {
            return false;
        }
        if (LibraryScanner.isCompositeComponentFile(o)) {
            IContainer c = f.getParent();
            while (c != null && c instanceof IFolder) {
                if ("resources".equals(c.getName())) {
                    return true;
                }
                c = c.getParent();
            }
        }
        return false;
    }

    @Override
    public boolean isRelevant(IFile resource) {
        return false;
    }

    @Override
    public LoadedDeclarations parse(IFile f, IKbProject sp) throws ScannerException {
        return null;
    }

    public Map<IPath, LoadedDeclarations> parse(IFolder f, IKbProject sp) throws ScannerException {
        XModel model = InnerModelHelper.createXModel((IProject)f.getProject());
        if (model == null) {
            return null;
        }
        XModelObject o = EclipseResourceUtil.getObjectByResource((XModel)model, (IResource)f);
        return this.parse(o, f.getFullPath(), sp, false);
    }

    public Map<IPath, LoadedDeclarations> parse(XModelObject o, IPath source, IKbProject sp, boolean lib) {
        if (o == null) {
            return null;
        }
        HashMap<IPath, LoadedDeclarations> result = new HashMap<IPath, LoadedDeclarations>();
        this.processFolder(o, result, source, URI_PREFIX, lib);
        return result;
    }

    void processFolder(XModelObject o, Map<IPath, LoadedDeclarations> result, IPath source, String uriPrefix, boolean lib) {
        XModelObject[] cs;
        LoadedDeclarations ds = result.get(source);
        if (ds == null) {
            ds = new LoadedDeclarations();
            result.put(source, ds);
        }
        CompositeTagLibrary library20 = null;
        CompositeTagLibrary library22 = null;
        XModelObject[] xModelObjectArray = cs = o.getChildren();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            String entity;
            XModelObject c = xModelObjectArray[n2];
            if (c.getFileType() == 2) {
                String n3 = c.getAttributeValue("name");
                IPath source1 = lib ? source : source.append(n3);
                this.processFolder(c, result, source1, String.valueOf(uriPrefix) + "/" + n3, lib);
            }
            if ((entity = c.getModelEntity().getName()).startsWith(ENT_COMPOSITE_COMPONENT)) {
                boolean is22 = entity.equals(ENT_COMPOSITE_COMPONENT_22);
                if (!is22 && library20 == null) {
                    library20 = new CompositeTagLibrary();
                    library20.setId(o);
                    library20.setURI(this.createValueInfo(uriPrefix));
                    System.out.println("Create " + uriPrefix);
                    ds.getLibraries().add(library20);
                } else if (is22 && library22 == null) {
                    library22 = new CompositeTagLibrary();
                    library22.setId(o);
                    String uri = uriPrefix;
                    uri = String.valueOf(URI_PREFIX_22) + uri.substring(URI_PREFIX.length());
                    System.out.println("Create " + uri);
                    library22.setURI(this.createValueInfo(uri));
                    ds.getLibraries().add(library22);
                }
                CompositeComponent component = new CompositeComponent();
                component.setId(c);
                IResource r = (IResource)c.getAdapter(IResource.class);
                if (r instanceof IFile) {
                    component.setSourcePath(r.getFullPath());
                    try {
                        ((FolderImpl)c.getParent()).updateChildFile(c, r.getLocation().toFile());
                    }
                    catch (XModelException e) {
                        ModelPlugin.getPluginLog().logError((Throwable)e);
                    }
                }
                component.setName(this.createValueInfo(c.getAttributeValue("name")));
                if (!is22) {
                    library20.addComponent(component);
                } else {
                    library22.addComponent(component);
                }
                XModelObject is = c.getChildByPath("Interface");
                if (is != null) {
                    XModelObject[] as;
                    XModelObject[] xModelObjectArray2 = as = is.getChildren();
                    int n4 = as.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        XModelObject a = xModelObjectArray2[n5];
                        CompositeAttribute attr = new CompositeAttribute();
                        attr.setId(a);
                        attr.setName((IValueInfo)new XMLValueInfo(a, "name"));
                        attr.setDescription((IValueInfo)new XMLValueInfo(a, ATTR_SHORT_DESCRIPTION));
                        attr.setRequired((IValueInfo)new XMLValueInfo(a, "required"));
                        component.addAttribute(attr);
                        ++n5;
                    }
                }
            }
            ++n2;
        }
    }

    private IValueInfo createValueInfo(String value) {
        ValueInfo v = new ValueInfo();
        v.setValue(value);
        return v;
    }
}

