/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.jst.web.kb.KbMessages;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.preferences.KBSeverityPreferences;

public class KbBuilderMarker {
    public static final String KB_BUILDER_PROBLEM_MARKER_TYPE = "org.jboss.tools.jst.web.kb.kbBuilderProblemMarker";
    public static final int KIND_KB_NATURE_OR_BUILDER_MISSING = 1;
    public static final int KIND_DEPENDS_ON_NON_KB_POJECTS = 2;
    public static final String ATTR_KIND = "kind";

    public static IMarker[] getOwnedMarkers(IResource r, int kind) {
        ArrayList<IMarker> l = null;
        try {
            if (r != null && r.isAccessible()) {
                IMarker[] ms;
                IMarker[] iMarkerArray = ms = r.findMarkers(null, false, 1);
                int n = ms.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray[n2];
                    if (KB_BUILDER_PROBLEM_MARKER_TYPE.equals(m.getType()) && m.isSubtypeOf("org.eclipse.core.resources.problemmarker") && kind == m.getAttribute(ATTR_KIND, 1)) {
                        if (l == null) {
                            l = new ArrayList<IMarker>();
                        }
                        l.add(m);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return l == null ? null : l.toArray(new IMarker[0]);
    }

    public static IMarker createOrUpdateKbProblemMarker(IMarker m, IResource r, String message, int kind) throws CoreException {
        String preferenceValue = KbBuilderMarker.getPreference(r.getProject(), kind);
        String s = KBSeverityPreferences.getInstance().getProjectPreference(r.getProject(), "org.jboss.tools.common.validator.enableBlock");
        if ("ignore".equals(preferenceValue) || "disabled".equals(s)) {
            if (m != null) {
                m.delete();
            }
            return null;
        }
        if (m == null) {
            m = r.createMarker(KB_BUILDER_PROBLEM_MARKER_TYPE);
            m.setAttribute(ATTR_KIND, 1);
            if (kind == 1) {
                r.setPersistentProperty(KbProjectFactory.NATURE_MOCK, "true");
                KbProjectFactory.getKbProject(r.getProject(), true);
            }
        }
        int severity = 1;
        if ("error".equals(preferenceValue)) {
            severity = 2;
        }
        String location = MessageFormat.format(KbMessages.KBPROBLEM_LOCATION, r.getProject().getName());
        m.setAttribute(ATTR_KIND, kind);
        m.setAttribute("location", (Object)location);
        m.setAttribute("message", (Object)message);
        m.setAttribute("severity", severity);
        m.setAttribute("priority", 1);
        return m;
    }

    protected static String getPreference(IProject project, int kind) {
        if (kind == 1) {
            return KbBuilderMarker.getPreference(project, KBSeverityPreferences.REQUIRED_KB_CAPABILITIES_ARE_MISSING);
        }
        if (kind == 2) {
            return KbBuilderMarker.getPreference(project, KBSeverityPreferences.KB_CAPABILITIES_ARE_NOT_ENABLED_IN_JAVA_MODULE);
        }
        return KbBuilderMarker.getPreference(project, KBSeverityPreferences.REQUIRED_KB_CAPABILITIES_ARE_MISSING);
    }

    protected static String getPreference(IProject project, String preferenceKey) {
        return KBSeverityPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }
}

