/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.util.TypeResolutionCache;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.IIncrementalProjectBuilderExtension;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.KbResourceVisitor;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LibraryScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.UsedJavaProjectCheck;
import org.jboss.tools.jst.web.kb.internal.scanner.XMLScanner;

public class KbBuilder
extends IncrementalProjectBuilder {
    public static String BUILDER_ID = "org.jboss.tools.jst.web.kb.kbbuilder";
    KbResourceVisitor resourceVisitor = null;
    static String ATTR_CLASS = "class";
    static String COBUILDERS_POINT = "org.jboss.tools.jst.web.kb.cobuilders";
    static Class<?>[] cobuilders = null;

    protected KbProject getKbProject() {
        IProject p = this.getProject();
        if (p == null) {
            return null;
        }
        return (KbProject)KbProjectFactory.getKbProject(p, false);
    }

    KbResourceVisitor getResourceVisitor() {
        if (this.resourceVisitor == null) {
            KbProject p = this.getKbProject();
            this.resourceVisitor = new KbResourceVisitor(p);
        }
        return this.resourceVisitor;
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        TypeResolutionCache.getInstance().clean();
        KbProject sp = this.getKbProject();
        if (sp == null) {
            return null;
        }
        long begin = System.currentTimeMillis();
        sp.postponeFiring();
        try {
            sp.resolveStorage(kind != 6);
            sp.getClassPath().build();
            new UsedJavaProjectCheck().check(sp);
            TypeInfoCollector.cleanCache();
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
            long end = System.currentTimeMillis();
            sp.fullBuildTime += end - begin;
        }
        finally {
            sp.fireChanges();
        }
        this.resourceVisitor = null;
        this.buildExtensionModels(kind, args, monitor);
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            PageContextFactory.getInstance().cleanUp(this.getProject());
            this.getProject().accept(this.getResourceVisitor().getVisitor());
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        PageContextFactory.getInstance().cleanUp(delta);
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
    }

    public static IFileScanner getXMLScanner() {
        return new XMLScanner();
    }

    public static IFileScanner getLibraryScanner() {
        return new LibraryScanner();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        KbProject sp = this.getKbProject();
        if (sp != null) {
            sp.clean();
        }
        PageContextFactory.getInstance().cleanUp(this.getProject());
    }

    static Class<?>[] getCobuilders() {
        if (cobuilders == null) {
            IExtensionPoint p = Platform.getExtensionRegistry().getExtensionPoint(COBUILDERS_POINT);
            IConfigurationElement[] es = p.getConfigurationElements();
            ArrayList list = new ArrayList();
            IConfigurationElement[] iConfigurationElementArray = es;
            int n = es.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                try {
                    String className = c.getAttribute(ATTR_CLASS);
                    if (className != null && className.length() != 0) {
                        IncrementalProjectBuilder builder = (IncrementalProjectBuilder)c.createExecutableExtension(ATTR_CLASS);
                        IIncrementalProjectBuilderExtension extension = (IIncrementalProjectBuilderExtension)builder;
                        list.add(extension.getClass());
                    }
                }
                catch (CoreException e) {
                    WebKbPlugin.getDefault().logError(e);
                }
                catch (ClassCastException e) {
                    WebKbPlugin.getDefault().logError(e);
                }
                ++n2;
            }
            cobuilders = list.toArray(new Class[list.size()]);
        }
        return cobuilders;
    }

    void buildExtensionModels(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        Class<?>[] classArray = KbBuilder.getCobuilders();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            try {
                IncrementalProjectBuilder builder = (IncrementalProjectBuilder)c.newInstance();
                KbProjectFactory.setProjectToBuilder(builder, this.getProject());
                ((IIncrementalProjectBuilderExtension)builder).build(kind, args, monitor);
            }
            catch (CoreException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            catch (InstantiationException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            catch (IllegalAccessException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            ++n2;
        }
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    return KbBuilder.this.getResourceVisitor().getVisitor().visit(resource);
                }
                case 2: {
                    KbProject p = KbBuilder.this.getKbProject();
                    if (p == null) break;
                    p.pathRemoved(resource.getFullPath());
                    break;
                }
                case 4: {
                    return KbBuilder.this.getResourceVisitor().getVisitor().visit(resource);
                }
            }
            return true;
        }
    }
}

