/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.internal.events.InternalBuilder;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.kb.internal.KbProject;

public class KbProjectFactory {
    public static QualifiedName NATURE_MOCK = new QualifiedName("", "org.jboss.tools.jst.web.kb.kbnature.mock");
    static HashMap<IProject, IKbProject> mockProjectStore = new HashMap();
    static HashSet<IProject> underConstruction = new HashSet();
    private static IResourceChangeListener deleteProjectListener = null;

    public static IKbProject getKbProject(IProject project, boolean resolve) {
        return KbProjectFactory.getKbProject(project, resolve, false);
    }

    public static IKbProject getKbProject(IProject project, boolean resolve, boolean isNatureRequired) {
        block8: {
            block9: {
                if (project == null || !project.exists() || !project.isOpen()) {
                    return null;
                }
                try {
                    if (project.hasNature("org.jboss.tools.jst.web.kb.kbnature")) break block8;
                    if (!isNatureRequired) break block9;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            String s = project.getPersistentProperty(NATURE_MOCK);
            if (s != null && "true".equals(s)) {
                return KbProjectFactory.getMockKbProject(project);
            }
            return null;
        }
        mockProjectStore.remove(project);
        try {
            IKbProject kbProject = (IKbProject)project.getNature("org.jboss.tools.jst.web.kb.kbnature");
            if (resolve) {
                kbProject.resolve();
            }
            return kbProject;
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }

    static IKbProject getMockKbProject(final IProject project) {
        IKbProject result = mockProjectStore.get(project);
        if (result != null) {
            return result;
        }
        if (underConstruction.contains(project)) {
            return null;
        }
        underConstruction.add(project);
        final KbProject mock = new KbProject();
        mock.setMock();
        mock.setProject(project);
        mockProjectStore.put(project, mock);
        if (deleteProjectListener == null) {
            deleteProjectListener = new RCL();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(deleteProjectListener);
        }
        XJob.addRunnable((XJob.XRunnable)new XJob.XRunnable(){

            public void run() {
                System.currentTimeMillis();
                class KbBuilderEx
                extends KbBuilder {
                    private final /* synthetic */ KbProject val$mock;

                    KbBuilderEx(KbProject kbProject) {
                        this.val$mock = kbProject;
                    }

                    @Override
                    protected KbProject getKbProject() {
                        return this.val$mock;
                    }

                    public void build() {
                        try {
                            this.build(10, null, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            WebModelPlugin.getPluginLog().logError((Throwable)e);
                        }
                    }
                }
                KbBuilderEx builder = new KbBuilderEx(mock);
                KbProjectFactory.setProjectToBuilder(builder, project);
                if (WebKbPlugin.getDefault() == null) {
                    return;
                }
                builder.build();
                underConstruction.remove(project);
            }

            public String getId() {
                return "Creating Mock Kb Project";
            }
        });
        return mock;
    }

    public static void setProjectToBuilder(IncrementalProjectBuilder builder, IProject project) {
        try {
            Method m = InternalBuilder.class.getDeclaredMethod("setBuildConfig", IBuildConfiguration.class);
            m.setAccessible(true);
            m.invoke((Object)builder, new BuildConfiguration(project));
        }
        catch (Exception e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private static class RCL
    implements IResourceChangeListener {
        private RCL() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IKbProject p;
            IResource resource;
            IProject project;
            if ((event.getType() == 4 || event.getType() == 2) && (project = (IProject)(resource = event.getResource()).getAdapter(IProject.class)) != null && (p = mockProjectStore.remove(project)) instanceof KbProject) {
                ((KbProject)p).dispose();
            }
        }
    }
}

