/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl.definition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IRootDefinitionContext;
import org.jboss.tools.batch.internal.core.impl.BatchAnnotationDeclaration;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.java.impl.JavaAnnotation;
import org.jboss.tools.common.text.ITextSourceReference;

public abstract class AbstractMemberDefinition
implements IAnnotated {
    public static int FLAG_NO_ANNOTATIONS = 1;
    public static int FLAG_ALL_MEMBERS = 2;
    protected BatchProject project;
    protected BatchAnnotationDeclaration namedAnnotation;
    protected BatchAnnotationDeclaration injectAnnotation;
    protected BatchAnnotationDeclaration batchPropertyAnnotation;
    protected IAnnotatable member;
    protected ITextSourceReference originalDefinition = null;

    protected void setAnnotatable(IAnnotatable member, IType contextType, IRootDefinitionContext context, int flags) {
        this.member = member;
        try {
            this.init(contextType, context, flags);
        }
        catch (CoreException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
        }
    }

    public BatchProject getDeclaringProject() {
        return this.project;
    }

    public void setOriginalDefinition(ITextSourceReference def) {
        this.originalDefinition = def;
    }

    public IAnnotatable getMember() {
        return this.member;
    }

    public AbstractTypeDefinition getTypeDefinition() {
        return null;
    }

    protected void init(IType contextType, IRootDefinitionContext context, int flags) throws CoreException {
        this.project = context.getProject();
        if ((flags & FLAG_NO_ANNOTATIONS) == 0) {
            IAnnotation[] ts = this.member.getAnnotations();
            int i = 0;
            while (i < ts.length) {
                JavaAnnotation ja = new JavaAnnotation(ts[i], contextType);
                if (this.isRelevant((IJavaAnnotation)ja)) {
                    this.addAnnotation((IJavaAnnotation)ja, context);
                }
                ++i;
            }
        }
    }

    private boolean isRelevant(IJavaAnnotation ja) {
        String type = ja.getTypeName();
        if ("javax.inject.Inject".equals(type)) {
            return true;
        }
        if ("javax.inject.Named".equals(type)) {
            return true;
        }
        return "javax.batch.api.BatchProperty".equals(type);
    }

    private void addAnnotation(IJavaAnnotation ja, IRootDefinitionContext context) {
        BatchAnnotationDeclaration a = new BatchAnnotationDeclaration();
        a.setProject(context.getProject());
        a.setDeclaration(ja);
        this.addAnnotation(a, context);
        this.addDependency((IMember)ja.getType(), context);
    }

    protected void addDependency(IMember reference, IRootDefinitionContext context) {
        if (reference == null || reference.isBinary()) {
            return;
        }
        IResource resource = this.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile target = (IFile)resource;
        IFile source = (IFile)reference.getResource();
        if (target.exists() && source != null && source.exists()) {
            context.addDependency(source.getFullPath(), target.getFullPath());
        }
    }

    private void addAnnotation(BatchAnnotationDeclaration a, IRootDefinitionContext context) {
        String typeName = a.getTypeName();
        if ("javax.inject.Inject".equals(typeName)) {
            this.injectAnnotation = a;
        } else if ("javax.inject.Named".equals(typeName)) {
            this.namedAnnotation = a;
        } else if ("javax.batch.api.BatchProperty".equals(typeName)) {
            this.batchPropertyAnnotation = a;
        }
    }

    public void removeAnnotation(IAnnotationDeclaration a) {
        String typeName = ((BatchAnnotationDeclaration)a).getTypeName();
        if ("javax.inject.Inject".equals(typeName)) {
            this.injectAnnotation = null;
        } else if ("javax.inject.Named".equals(typeName)) {
            this.namedAnnotation = null;
        } else if ("javax.batch.api.BatchProperty".equals(typeName)) {
            this.batchPropertyAnnotation = null;
        }
    }

    public List<IAnnotationDeclaration> getAnnotations() {
        ArrayList<IAnnotationDeclaration> result = new ArrayList<IAnnotationDeclaration>();
        if (this.injectAnnotation != null) {
            result.add((IAnnotationDeclaration)this.injectAnnotation);
        }
        if (this.namedAnnotation != null) {
            result.add((IAnnotationDeclaration)this.namedAnnotation);
        }
        if (this.batchPropertyAnnotation != null) {
            result.add((IAnnotationDeclaration)this.batchPropertyAnnotation);
        }
        return result;
    }

    public BatchAnnotationDeclaration getAnnotation(String typeName) {
        if ("javax.inject.Inject".equals(typeName)) {
            return this.injectAnnotation;
        }
        if ("javax.inject.Named".equals(typeName)) {
            return this.namedAnnotation;
        }
        if ("javax.batch.api.BatchProperty".equals(typeName)) {
            return this.batchPropertyAnnotation;
        }
        return null;
    }

    public IJavaSourceReference getAnnotationPosition(String annotationTypeName) {
        return this.getAnnotation(annotationTypeName);
    }

    public boolean isAnnotationPresent(String annotationTypeName) {
        return this.getAnnotation(annotationTypeName) != null;
    }

    public BatchAnnotationDeclaration getNamedAnnotation() {
        return this.getAnnotation("javax.inject.Named");
    }

    public BatchAnnotationDeclaration getInjectAnnotation() {
        return this.getAnnotation("javax.inject.Inject");
    }

    public BatchAnnotationDeclaration getBatchPropertyAnnotation() {
        return this.getAnnotation("javax.batch.api.BatchProperty");
    }

    public IResource getResource() {
        return ((IJavaElement)this.member).getResource();
    }

    public ITextSourceReference getOriginalDefinition() {
        return this.originalDefinition;
    }

    public boolean exists() {
        return this.member instanceof IJavaElement && ((IJavaElement)this.member).exists();
    }
}

