/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.common.EclipseUtil;

public class PreferredPackageManager {
    private static final String QUALIFIED_NAME_PREFIX = "create.artifact.package.";

    public static IPackageFragment getPackageSuggestion(IBatchProject batchProject, BatchArtifactType type) {
        ArrayList<BatchArtifactType> list = new ArrayList<BatchArtifactType>();
        list.add(type);
        return PreferredPackageManager.getPackageSuggestion(batchProject, list);
    }

    public static IPackageFragment getPackageSuggestion(IBatchProject batchProject, List<BatchArtifactType> types) {
        IProject project = batchProject.getProject();
        for (BatchArtifactType type : types) {
            QualifiedName qualifiedName = new QualifiedName("", QUALIFIED_NAME_PREFIX + type.toString());
            try {
                IPackageFragment result;
                IJavaProject javaProject;
                String packPath = project.getPersistentProperty(qualifiedName);
                if (packPath == null || packPath.length() <= 0 || (javaProject = EclipseUtil.getJavaProject((IProject)project)) == null || (result = javaProject.findPackageFragment((IPath)new Path(packPath))) == null || !result.exists() || result.isReadOnly()) continue;
                return result;
            }
            catch (CoreException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
        }
        return PreferredPackageManager.findPackage(batchProject, types);
    }

    private static IPackageFragment findPackage(IBatchProject batchProject, List<BatchArtifactType> types) {
        for (BatchArtifactType type : types) {
            for (IBatchArtifact artifact : batchProject.getArtifacts(type)) {
                if (artifact.getType().isBinary()) continue;
                return artifact.getType().getPackageFragment();
            }
        }
        return null;
    }

    public static void savePreferredPackage(IBatchProject batchProject, BatchArtifactType type, String packageName) {
        QualifiedName qualifiedName = new QualifiedName("", QUALIFIED_NAME_PREFIX + type.toString());
        try {
            batchProject.getProject().setPersistentProperty(qualifiedName, packageName);
        }
        catch (CoreException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
        }
    }
}

