/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.internal.core.el.JobPropertyELSegmentImpl;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.common.el.core.ca.AbstractELCompletionEngine;
import org.jboss.tools.common.el.core.ca.MessagesELTextProposal;
import org.jboss.tools.common.el.core.model.ELArgumentInvocation;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELObjectType;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolutionImpl;
import org.jboss.tools.common.el.core.resolver.ELResolverExtension;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.ELSegmentImpl;
import org.jboss.tools.common.el.core.resolver.IOpenableReference;
import org.jboss.tools.common.el.core.resolver.IRelevanceCheck;
import org.jboss.tools.common.el.core.resolver.IVariable;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.util.StringUtil;
import org.jboss.tools.common.validation.SkipValidation;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.IXmlContext;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.XmlContextImpl;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@SkipValidation
public class JobPropertiesELCompletionEngine
extends AbstractELCompletionEngine<IVariable>
implements ELResolverExtension {
    public static final String PROPERTY_IMAGE_NAME = "property.png";
    private static final ImageDescriptor JOB_PROPERTIES_PROPOSAL_IMAGE = ImageDescriptor.createFromFile(JobPropertiesELCompletionEngine.class, (String)"property.png");
    int currentOffset = 0;
    static List<?> EMPTY_OBJECTS = Collections.unmodifiableList(new ArrayList());
    static IVariable JOB_PROPERTIES = new Variable("jobProperties");
    static IVariable JOB_PARAMETERS = new Variable("jobParameters");
    static IVariable SYSTEM_PROPERTIES = new Variable("systemProperties");
    static IVariable PARTITION_PLAN = new Variable("partitionPlan");
    public static final String GO_TO_PROPERTY_AT = "Property {0} at {1}:{2}";

    public ImageDescriptor getELProposalImageForMember(TypeInfoCollector.MemberInfo memberInfo) {
        return JOB_PROPERTIES_PROPOSAL_IMAGE;
    }

    public boolean isRelevant(ELContext context) {
        Map namespaces;
        if (context instanceof IXmlContext && (namespaces = ((IXmlContext)context).getRootNameSpaces()).containsKey("http://xmlns.jcp.org/xml/ns/javaee")) {
            for (INameSpace n : (List)namespaces.get("http://xmlns.jcp.org/xml/ns/javaee")) {
                if (!"job".equals(n.getRoot())) continue;
                return true;
            }
        }
        return false;
    }

    public ELParserFactory getParserFactory() {
        return ELParserUtil.getDefaultFactory();
    }

    protected void log(Exception e) {
        BatchCorePlugin.pluginLog().logError((Throwable)e);
    }

    public List<TextProposal> getProposals(ELContext context, String el, int offset) {
        if (!this.isRelevant(context)) {
            return null;
        }
        this.currentOffset = offset;
        List<TextProposal> proposals = null;
        try {
            proposals = this.getCompletions(context.getResource(), el.subSequence(0, el.length()), false);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.log(e);
        }
        catch (BadLocationException e) {
            this.log((Exception)((Object)e));
        }
        return proposals;
    }

    public ELResolution resolve(ELContext context, ELExpression operand, int offset) {
        this.currentOffset = offset;
        ELResolutionImpl resolution = this.resolveELOperand(operand, context, true);
        if (resolution != null) {
            resolution.setContext(context);
        }
        return resolution;
    }

    public ELResolutionImpl resolveELOperand(ELExpression operand, ELContext context, boolean returnEqualedVariablesOnly) {
        try {
            return this.resolveELOperand(context.getResource(), operand, returnEqualedVariablesOnly);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.log(e);
        }
        catch (BadLocationException e) {
            this.log((Exception)((Object)e));
        }
        return null;
    }

    private List<TextProposal> getCompletions(IFile file, CharSequence prefix, boolean returnEqualedVariablesOnly) throws BadLocationException, StringIndexOutOfBoundsException {
        ArrayList<TextProposal> completions = new ArrayList<TextProposal>();
        ELResolutionImpl status = this.resolveELOperand(file, this.parseOperand("" + prefix), returnEqualedVariablesOnly);
        if (status != null) {
            completions.addAll(status.getProposals());
        }
        return completions;
    }

    /*
     * Unable to fully structure code
     */
    protected ELResolutionImpl resolveELOperand(IFile file, ELExpression operand, boolean returnEqualedVariablesOnly) throws BadLocationException, StringIndexOutOfBoundsException {
        block19: {
            block18: {
                if (!(operand instanceof ELInvocationExpression) || file == null) {
                    return null;
                }
                expr = (ELInvocationExpression)operand;
                isIncomplete = expr.getType() == ELObjectType.EL_PROPERTY_INVOCATION && ((ELPropertyInvocation)expr).getName() == null;
                isArgument = expr.getType() == ELObjectType.EL_ARGUMENT_INVOCATION;
                resolution = new ELResolutionImpl((ELExpression)expr);
                left = expr;
                resolvedVariables = this.EMPTY_VARIABLES_LIST;
                if (expr.getLeft() == null || !isArgument) break block18;
                left = expr.getLeft();
                resolvedVariables = this.resolveVariables(file, left, false, true);
                if (resolvedVariables != null && !resolvedVariables.isEmpty()) {
                    resolution.setLastResolvedToken(left);
                    segment = new ELSegmentImpl(left.getFirstToken());
                    segment.setResolved(true);
                    for (IVariable variable : resolvedVariables) {
                        segment.getVariables().add(variable);
                    }
                    resolution.addSegment((ELSegment)segment);
                }
                break block19;
            }
            if (expr.getLeft() != null || !isIncomplete) ** GOTO lbl39
            resolvedVariables = this.resolveVariables(file, expr, true, returnEqualedVariablesOnly);
            break block19;
lbl-1000:
            // 1 sources

            {
                resolvedVars = this.resolveVariables(file, left, left == expr, returnEqualedVariablesOnly);
                if (resolvedVars != null && !resolvedVars.isEmpty()) {
                    resolvedVariables = resolvedVars;
                    resolution.setLastResolvedToken(left);
                    segment = new JobPropertyELSegmentImpl(left.getFirstToken());
                    segment.setResolved(true);
                    for (IVariable variable : resolvedVars) {
                        segment.getVariables().add(variable);
                    }
                    resolution.addSegment((ELSegment)segment);
                    break;
                }
                left = left.getLeft();
lbl39:
                // 2 sources

                ** while (left != null)
            }
        }
        if (resolution.getLastResolvedToken() == null && !returnEqualedVariablesOnly && expr != null && isIncomplete) {
            resolvedVariables = this.resolveVariables(file, expr, true, returnEqualedVariablesOnly);
            proposals = new TreeSet<E>(TextProposal.KB_PROPOSAL_ORDER);
            if (left != null) {
                segment = new JobPropertyELSegmentImpl(left.getFirstToken());
                segment.setResolved(false);
                resolution.addSegment((ELSegment)segment);
                for (IVariable var : resolvedVariables) {
                    varName = var.getName();
                    if (!varName.startsWith(operand.getText())) continue;
                    proposal = new MessagesELTextProposal();
                    proposal.setReplacementString(varName.substring(operand.getLength()));
                    proposal.setImageDescriptor(this.getELProposalImageForMember(null));
                    objects = JobPropertiesELCompletionEngine.EMPTY_OBJECTS;
                    proposal.setBaseName("");
                    proposal.setObjects(objects);
                    proposals.add(proposal);
                }
                resolution.setProposals(proposals);
                segment.setResolved(proposals.isEmpty() == false);
            }
            return resolution;
        }
        if (resolution.getLastResolvedToken() == operand) {
            proposals = new TreeSet<MessagesELTextProposal>(TextProposal.KB_PROPOSAL_ORDER);
            for (IVariable var : resolvedVariables) {
                varName = var.getName();
                if (operand.getLength() <= varName.length()) {
                    proposal = new MessagesELTextProposal();
                    proposal.setReplacementString(varName.substring(operand.getLength()));
                    proposal.setLabel(varName);
                    proposal.setImageDescriptor(this.getELProposalImageForMember(null));
                    objects = JobPropertiesELCompletionEngine.EMPTY_OBJECTS;
                    proposal.setBaseName("");
                    proposal.setObjects(objects);
                    proposals.add(proposal);
                } else if (returnEqualedVariablesOnly) {
                    proposal = new TextProposal();
                    proposal.setReplacementString(varName);
                    proposal.setLabel(varName);
                    proposal.setImageDescriptor(this.getELProposalImageForMember(null));
                    proposals.add(proposal);
                }
                resolution.getLastSegment().getVariables().add(var);
            }
            resolution.setLastResolvedToken(expr);
            resolution.setProposals(proposals);
            return resolution;
        }
        if (left != null) {
            if (left != expr) {
                if ((left = (ELInvocationExpression)left.getParent()) != expr) {
                    segment = new ELSegmentImpl(left.getLastToken());
                    segment.setResolved(true);
                    resolution.addSegment((ELSegment)segment);
                    resolution.setLastResolvedToken(left);
                    return resolution;
                }
                this.resolveLastSegment(file, (ELInvocationExpression)operand, resolvedVariables, resolution, returnEqualedVariablesOnly);
            }
        } else {
            segment = new ELSegmentImpl(expr.getFirstToken());
            resolution.addSegment((ELSegment)segment);
        }
        return resolution;
    }

    protected List<IVariable> resolveVariables(IFile file, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames) {
        ArrayList<IVariable> result = this.EMPTY_VARIABLES_LIST;
        if (expr.getLeft() != null) {
            return result;
        }
        String varName = expr.toString();
        IVariable[] iVariableArray = this.getAllVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable v = iVariableArray[n2];
            if ((isFinal && !onlyEqualNames || v.getName().equals(varName)) && v.getName().startsWith(varName)) {
                if (result == this.EMPTY_VARIABLES_LIST) {
                    result = new ArrayList<IVariable>();
                }
                result.add(v);
            }
            ++n2;
        }
        return result;
    }

    protected IVariable[] getAllVariables() {
        return new IVariable[]{JOB_PROPERTIES, JOB_PARAMETERS, SYSTEM_PROPERTIES, PARTITION_PLAN};
    }

    protected void resolveLastSegment(IFile file, ELInvocationExpression expr, List<IVariable> members, ELResolutionImpl resolution, boolean returnEqualedVariablesOnly) {
        ELSegmentImpl segment = new ELSegmentImpl(expr.getFirstToken());
        if (expr instanceof ELPropertyInvocation) {
            segment = new JobPropertyELSegmentImpl(((ELPropertyInvocation)expr).getName());
            this.processJobPropertySegment(file, expr, (JobPropertyELSegmentImpl)segment, members);
        } else if (expr instanceof ELArgumentInvocation) {
            segment = new JobPropertyELSegmentImpl(((ELArgumentInvocation)expr).getArgument().getOpenArgumentToken().getNextToken());
            this.processJobPropertySegment(file, expr, (JobPropertyELSegmentImpl)segment, members);
        }
        if (segment.getToken() != null) {
            resolution.addSegment((ELSegment)segment);
        }
        this.addTextProposals(file, expr, members, resolution, segment, returnEqualedVariablesOnly);
        if (resolution.isResolved()) {
            resolution.setLastResolvedToken(expr);
        }
    }

    protected void addTextProposals(IFile file, ELInvocationExpression expr, List<IVariable> members, ELResolutionImpl resolution, ELSegmentImpl segment, boolean returnEqualedVariablesOnly) {
        TreeSet<MessagesELTextProposal> kbProposals = new TreeSet<MessagesELTextProposal>(TextProposal.KB_PROPOSAL_ORDER);
        resolution.setProposals(kbProposals);
        if ((expr.getType() != ELObjectType.EL_PROPERTY_INVOCATION || ((ELPropertyInvocation)expr).getName() != null) && expr.getType() == ELObjectType.EL_ARGUMENT_INVOCATION && expr.getType() == ELObjectType.EL_ARGUMENT_INVOCATION) {
            String filter = expr.getMemberName() == null ? "" : expr.getMemberName();
            filter = StringUtil.trimQuotes((String)filter);
            block0: for (IVariable mbr : members) {
                if (mbr != JOB_PROPERTIES) continue;
                List<OpenableReference> properties = this.getProperties(file, this.currentOffset);
                for (OpenableReference p : properties) {
                    MessagesELTextProposal kbProposal;
                    String key = p.getValue();
                    if (returnEqualedVariablesOnly) {
                        if (!key.equals(filter)) continue;
                        kbProposal = this.createProposal(mbr, key);
                        kbProposals.add(kbProposal);
                        continue block0;
                    }
                    if (!key.startsWith(filter)) continue;
                    kbProposal = this.createProposal(mbr, key);
                    String existingString = expr.getMemberName() == null ? "" : expr.getMemberName();
                    String replacement = kbProposal.getReplacementString();
                    String label = kbProposal.getLabel();
                    if (!replacement.startsWith("'")) {
                        replacement = String.valueOf('\'') + key + '\'';
                        label = "['" + key + "']";
                    }
                    replacement = replacement.substring(existingString.length());
                    kbProposal.setReplacementString(replacement);
                    kbProposal.setLabel(label);
                    kbProposals.add(kbProposal);
                }
            }
        }
        segment.setResolved(!kbProposals.isEmpty());
    }

    private void processJobPropertySegment(IFile file, ELInvocationExpression expr, JobPropertyELSegmentImpl segment, List<IVariable> variables) {
        if (segment.getToken() == null) {
            return;
        }
        for (IVariable variable : variables) {
            if (variable != JOB_PROPERTIES || !expr.getFirstToken().getText().equals(variable.getName())) continue;
            List<OpenableReference> properties = this.getProperties(file, this.currentOffset);
            ArrayList<OpenableReference> result = new ArrayList<OpenableReference>();
            for (OpenableReference r : properties) {
                if (!r.getValue().equals(StringUtil.trimQuotes((String)segment.getToken().getText()))) continue;
                result.add(r);
            }
            segment.setResource((IResource)file);
            segment.setAttrs(result);
        }
    }

    private List<OpenableReference> getProperties(final IFile file, int offset) {
        final ArrayList<OpenableReference> result = new ArrayList<OpenableReference>();
        ELContext c = PageContextFactory.createPageContext((IFile)file);
        if (!(c instanceof XmlContextImpl)) {
            return result;
        }
        XmlContextImpl context = (XmlContextImpl)c;
        final IDocument idocument = context.getDocument();
        if (idocument == null) {
            return result;
        }
        BatchUtil.scanXMLFile(file, new BatchUtil.DocumentScanner(){

            @Override
            public void scanDocument(Document document) {
                Node n = JobPropertiesELCompletionEngine.findNodeForOffset((IDOMNode)((IDOMDocument)document), JobPropertiesELCompletionEngine.this.currentOffset);
                if (n instanceof Attr) {
                    JobPropertiesELCompletionEngine.this.fillProperties(idocument, file, result, (Element)n.getParentNode());
                } else if (n instanceof Element) {
                    JobPropertiesELCompletionEngine.this.fillProperties(idocument, file, result, (Element)n);
                }
            }
        });
        return result;
    }

    void fillProperties(IDocument document, IFile file, List<OpenableReference> result, Element element) {
        Attr exclude = null;
        if (element.getNodeName().equals("property")) {
            exclude = element.getAttributeNode("name");
            element = (Element)element.getParentNode();
        }
        if (element.getNodeName().equals("properties")) {
            element = (Element)element.getParentNode();
        }
        while (element != null) {
            Element psn = element;
            if (!element.getNodeName().equals("properties")) {
                psn = XMLUtilities.getUniqueChild((Element)element, (String)"properties");
            }
            if (psn != null) {
                Element[] ps;
                Element[] elementArray = ps = XMLUtilities.getChildren((Element)psn, (String)"property");
                int n = ps.length;
                int n2 = 0;
                while (n2 < n) {
                    Element p = elementArray[n2];
                    Attr a = p.getAttributeNode("name");
                    if (a != exclude && a instanceof IDOMAttr) {
                        result.add(new OpenableReference(document, file, (IDOMAttr)a));
                    }
                    ++n2;
                }
            }
            element = element.getParentNode() instanceof Element ? (Element)element.getParentNode() : null;
        }
    }

    public static Node findNodeForOffset(IDOMNode node, int offset) {
        IndexedRegion region = node.getModel().getIndexedRegion(offset);
        if (region instanceof Node) {
            return (Node)region;
        }
        return null;
    }

    private MessagesELTextProposal createProposal(IVariable mbr, String proposal) {
        MessagesELTextProposal kbProposal = new MessagesELTextProposal();
        if (proposal.indexOf(46) != -1) {
            kbProposal.setReplacementString(String.valueOf('\'') + proposal + '\'');
            kbProposal.setLabel("['" + proposal + "']");
        } else {
            kbProposal.setReplacementString(proposal);
            kbProposal.setLabel(proposal);
        }
        kbProposal.setAlternateMatch(proposal);
        kbProposal.setImageDescriptor(this.getELProposalImageForMember(null));
        List<?> objects = EMPTY_OBJECTS;
        kbProposal.setBaseName("");
        kbProposal.setPropertyName(proposal);
        kbProposal.setObjects(objects);
        return kbProposal;
    }

    protected TypeInfoCollector.MemberInfo getMemberInfoByVariable(IVariable var, ELContext context, boolean onlyEqualNames, int offset) {
        return null;
    }

    public List<IVariable> resolveVariables(IFile file, ELContext context, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames, int offset) {
        return null;
    }

    protected boolean isStaticMethodsCollectingEnabled() {
        return false;
    }

    public IRelevanceCheck createRelevanceCheck(IJavaElement element) {
        return IRRELEVANT;
    }

    static class OpenableReference
    implements IOpenableReference {
        IFile file;
        int start;
        int length;
        String value;
        String label;

        OpenableReference(IDocument document, IFile file, IDOMAttr attr) {
            this.file = file;
            this.start = attr.getValueRegionStartOffset();
            this.length = attr.getValueRegionText().length();
            this.value = attr.getValue();
            int line = 0;
            int pos = 0;
            try {
                line = document.getLineOfOffset(this.start);
                pos = this.start - document.getLineOffset(line);
            }
            catch (BadLocationException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
            this.label = NLS.bind((String)JobPropertiesELCompletionEngine.GO_TO_PROPERTY_AT, (Object[])new Object[]{this.value, "" + line, "" + pos});
        }

        public boolean open() {
            try {
                IEditorPart part = IDE.openEditor((IWorkbenchPage)WebKbPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file);
                StructuredTextEditor text = (StructuredTextEditor)part.getAdapter(ITextEditor.class);
                text.selectAndReveal(this.start, this.length);
            }
            catch (PartInitException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
            return false;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public Image getImage() {
            return null;
        }
    }

    static class Variable
    implements IVariable {
        String name;

        Variable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

