/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveParameter;
import tern.angular.modules.IAngularModulesRegistry;
import tern.angular.modules.IDirectiveCollector;
import tern.angular.modules.IDirectiveParameterCollector;
import tern.angular.modules.IDirectiveSyntax;
import tern.angular.modules.Module;
import tern.angular.modules.Restriction;
import tern.angular.modules.XMLAngularModulesRegistry;

public class AngularModulesManager {
    private static final AngularModulesManager INSTANCE = new AngularModulesManager();
    private final List<IAngularModulesRegistry> defaultRegistries = new ArrayList<IAngularModulesRegistry>();
    private final Map<Object, IAngularModulesRegistry> customRegistries = new HashMap<Object, IAngularModulesRegistry>();

    public static AngularModulesManager getInstance() {
        return INSTANCE;
    }

    private AngularModulesManager() {
        this.defaultRegistries.add(new XMLAngularModulesRegistry());
    }

    public void addRegistry(IAngularModulesRegistry registry) {
        this.defaultRegistries.add(registry);
    }

    public void addRegistry(Object project, IAngularModulesRegistry registry) {
        this.customRegistries.put(project, registry);
    }

    public void collectDirectives(Object project, String tagName, String directiveName, IDirectiveSyntax syntax, List<Directive> existingDirectives, Restriction restriction, IDirectiveCollector collector) {
        IAngularModulesRegistry registry;
        this.collectDefaultDirectives(tagName, directiveName, syntax, existingDirectives, restriction, collector);
        if (project != null && (registry = this.customRegistries.get(project)) != null) {
            registry.collectDirectives(tagName, directiveName, syntax, existingDirectives, restriction, collector);
        }
        if (existingDirectives != null) {
            for (Directive directive : existingDirectives) {
                this.collectDirectiveParameters(directive, directiveName, collector);
            }
        }
    }

    public void collectDirectiveParameters(Directive directive, String name, IDirectiveParameterCollector collector) {
        Collection<DirectiveParameter> parameters = directive.getParameters();
        for (DirectiveParameter parameter : parameters) {
            if (!parameter.getName().startsWith(name)) continue;
            collector.add(parameter);
        }
    }

    private void collectDefaultDirectives(String tagName, String directiveName, IDirectiveSyntax syntax, List<Directive> existingDirectives, Restriction restriction, IDirectiveCollector collector) {
        for (IAngularModulesRegistry registry : this.defaultRegistries) {
            registry.collectDirectives(tagName, directiveName, syntax, existingDirectives, restriction, collector);
        }
    }

    public Directive getDirective(String tagName, String name, Restriction restriction) {
        Directive directive = null;
        for (IAngularModulesRegistry registry : this.defaultRegistries) {
            directive = registry.getDirective(tagName, name, restriction);
            if (directive == null) continue;
            return directive;
        }
        return null;
    }

    public Module getModule(String name) {
        Module module = null;
        for (IAngularModulesRegistry registry : this.defaultRegistries) {
            module = registry.getModule(name);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public Directive getDirective(Object project, String tagName, String name, Restriction restriction) {
        IAngularModulesRegistry registry;
        Directive directive = this.getDirective(tagName, name, restriction);
        if (directive != null) {
            return directive;
        }
        if (project != null && (registry = this.customRegistries.get(project)) != null) {
            return registry.getDirective(tagName, name, restriction);
        }
        return null;
    }
}

