/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.UIJob;

public abstract class DocumentListeningEditorPart
extends EditorPart {
    private Job currentJob;
    private IDocumentListener documentListener;

    protected abstract void performAction();

    protected abstract boolean actionHappening();

    private void updatePreview() {
        if (this.currentJob == null || this.currentJob.getState() != 2) {
            if (this.currentJob != null && this.currentJob.getState() == 1) {
                this.currentJob.cancel();
            }
            this.currentJob = this.createPreviewUpdateJob();
        }
        this.currentJob.schedule(500L);
    }

    private Job createPreviewUpdateJob() {
        UIJob job = new UIJob("Preview Update"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DocumentListeningEditorPart.this.performAction();
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    protected void removeDocumentListener(IEditorPart sourceEditor) {
        IDocument document;
        if (sourceEditor != null && (document = this.getDocument(sourceEditor)) != null && this.documentListener != null) {
            document.removeDocumentListener(this.documentListener);
        }
    }

    protected void addDocumentListener(IEditorPart sourceEditor) {
        IDocument document;
        if (sourceEditor != null && (document = this.getDocument(sourceEditor)) != null) {
            document.addDocumentListener(this.getDocumentListener());
        }
    }

    private IDocument getDocument(IEditorPart sourceEditor) {
        return (IDocument)sourceEditor.getAdapter(IDocument.class);
    }

    private IDocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (DocumentListeningEditorPart.this.actionHappening()) {
                        DocumentListeningEditorPart.this.updatePreview();
                    }
                }
            };
        }
        return this.documentListener;
    }
}

