/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.web.validation.JSFSeverityPreferences;
import org.jboss.tools.jsf.web.validation.JSFValidationMessage;
import org.jboss.tools.jsf.web.validation.composite.CompositeComponentValidator;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.kb.internal.validation.KBValidator;
import org.jboss.tools.jst.web.kb.internal.validation.WebValidator;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StrictTaglibValidator
extends WebValidator {
    public static final String ID = "org.jboss.tools.jsf.StrictTagLibValidator";
    private Map<String, Map<String, Set<String>>> cache;
    private boolean shouldValidateTagLibTags;
    private boolean shouldValidateTagLibTagAttributes;
    private static final String BUNDLE_NAME = "org.jboss.tools.jsf.web.validation.messages";

    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, context, manager, reporter);
        this.cache = new HashMap<String, Map<String, Set<String>>>();
        this.shouldValidateTagLibTags = this.shouldValidateTagLibTags(project);
        this.shouldValidateTagLibTagAttributes = this.shouldValidateTagLibTagAttributes(project);
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, validationContext, (IValidator)manager, reporter);
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        for (IFile file : changedFiles) {
            if (!this.notValidatedYet((IResource)file) || !this.shouldBeValidated(file)) continue;
            filesToValidate.add(file);
        }
        for (IFile file : filesToValidate) {
            this.validateFile(file);
        }
        this.cache = null;
        return this.OK_STATUS;
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, validationContext, (IValidator)manager, reporter);
        Set files = validationHelper.getProjectSetRegisteredFiles();
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        for (IFile file : files) {
            if (!this.notValidatedYet((IResource)file) || !this.shouldBeValidated(file)) continue;
            filesToValidate.add(file);
        }
        for (IFile file : filesToValidate) {
            this.validateFile(file);
        }
        this.cache = null;
        return this.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateFile(IFile file) {
        IModelManager manager;
        if (this.reporter.isCancelled()) {
            return;
        }
        ELContext context = PageContextFactory.createPageContext((IFile)file);
        if (!(context instanceof IPageContext) || (manager = StructuredModelManager.getModelManager()) == null) return;
        IStructuredModel model = null;
        try {
            try {
                model = manager.getModelForRead(file);
                if (!(model instanceof IDOMModel)) return;
                this.displaySubtask(JSFValidationMessage.VALIDATING_RESOURCE, new String[]{file.getProject().getName(), file.getName()});
                this.coreHelper.getValidationContextManager().addValidatedProject((org.jboss.tools.common.validation.IValidator)this, file.getProject());
                this.removeAllMessagesFromResource((IResource)file);
                IDOMDocument domDocument = ((IDOMModel)model).getDocument();
                this.validateChildNodes(file, (IDocument)domDocument.getStructuredDocument(), (IDOMNode)domDocument, (IPageContext)context);
                return;
            }
            catch (CoreException e) {
                JSFModelPlugin.getDefault().logError(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                JSFModelPlugin.getDefault().logError(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private void validateChildNodes(IFile file, IDocument document, IDOMNode parent, IPageContext context) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (children != null && i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof IDOMNode) {
                this.validateNode(file, document, (IDOMNode)child, context);
                this.validateChildNodes(file, document, (IDOMNode)child, context);
            }
            ++i;
        }
    }

    private void validateNode(IFile file, IDocument document, IDOMNode node, IPageContext context) {
        NamedNodeMap nodeAttributes;
        if (!(node instanceof IDOMElement)) {
            return;
        }
        String nodeName = node.getNodeName();
        int offset = node.getStartOffset();
        int prefixDivider = nodeName.indexOf(58);
        if (prefixDivider == -1) {
            return;
        }
        String prefix = nodeName.substring(0, prefixDivider);
        String name = nodeName.substring(prefixDivider + 1);
        String uri = this.getUri(context, prefix, offset);
        Map<String, Set<String>> tagCache = this.cache.get(uri);
        if (tagCache == null) {
            tagCache = new HashMap<String, Set<String>>();
            this.cache.put(uri, tagCache);
        }
        if (!tagCache.containsKey(nodeName)) {
            KbQuery kbQuery = new KbQuery();
            kbQuery.setPrefix(prefix);
            kbQuery.setUri(uri);
            kbQuery.setMask(false);
            kbQuery.setType(KbQuery.Type.TAG_NAME);
            kbQuery.setOffset(offset);
            kbQuery.setValue(nodeName);
            IComponent[] components = PageProcessor.getInstance().getComponents(kbQuery, context, false);
            if (components.length > 0) {
                HashSet<String> tagAttributes = new HashSet<String>();
                tagCache.put(name, tagAttributes);
                IComponent[] iComponentArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    IAttribute[] attributes;
                    IComponent comp = iComponentArray[n2];
                    IAttribute[] iAttributeArray = attributes = comp.getAttributes();
                    int n3 = attributes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAttribute attribute = iAttributeArray[n4];
                        tagAttributes.add(attribute.getName());
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        if (!tagCache.containsKey(name)) {
            if (this.shouldValidateTagLibTags && this.unknownTag(file, offset + 1, nodeName.length(), nodeName) == null) {
                return;
            }
        } else if (this.shouldValidateTagLibTagAttributes && (nodeAttributes = node.getAttributes()) != null && nodeAttributes.getLength() > 0) {
            Set<String> tagAttributes = tagCache.get(name);
            int i = 0;
            while (i < nodeAttributes.getLength()) {
                int attributeOffset;
                Node attribute = nodeAttributes.item(i);
                String attributeName = attribute.getNodeName();
                int n = attributeOffset = attribute instanceof IDOMNode ? ((IDOMNode)attribute).getStartOffset() : offset;
                if (!(tagAttributes != null && tagAttributes.contains(attributeName) || this.unknownAttribute(file, attributeOffset, attributeName.length(), nodeName, attributeName) != null)) {
                    return;
                }
                ++i;
            }
        }
    }

    private String getUri(IPageContext context, String prefix, int offset) {
        if (prefix == null) {
            return null;
        }
        Map nameSpaces = context.getNameSpaces(offset);
        if (nameSpaces == null || nameSpaces.isEmpty()) {
            return null;
        }
        for (List nameSpace : nameSpaces.values()) {
            for (INameSpace n : nameSpace) {
                if (!prefix.equals(n.getPrefix())) continue;
                return n.getURI();
            }
        }
        return null;
    }

    private IMarker unknownAttribute(IFile target, int offset, int length, String tagName, String attributeName) {
        return this.addProblem(JSFValidationMessage.UNKNOWN_TAGLIB_COMPONENT_ATTRIBUTE, JSFSeverityPreferences.UNKNOWN_TAGLIB_ATTRIBUTE, new String[]{attributeName, tagName}, length, offset, (IResource)target);
    }

    private IMarker unknownTag(IFile target, int offset, int length, String tagName) {
        return this.addProblem(JSFValidationMessage.UNKNOWN_TAGLIB_COMPONENT_NAME, JSFSeverityPreferences.UNKNOWN_TAGLIB_COMPONENT, new String[]{tagName}, length, offset, (IResource)target);
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return KbBuilder.BUILDER_ID;
    }

    protected boolean shouldValidateJavaSources() {
        return false;
    }

    protected String getMessageBundleName() {
        return BUNDLE_NAME;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        return StrictTaglibValidator.createSimpleValidatingProjectTree((IProject)project);
    }

    public boolean shouldValidate(IProject project) {
        try {
            return project != null && project.isAccessible() && project.hasNature("org.jboss.tools.jsf.jsfnature") && this.validateBuilderOrder(project) && this.isEnabled(project);
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
            return false;
        }
    }

    private boolean validateBuilderOrder(IProject project) throws CoreException {
        return KBValidator.validateBuilderOrder((IProject)project, (String)this.getBuilderId(), (String)this.getId(), (SeverityPreferences)JSFSeverityPreferences.getInstance());
    }

    public boolean isEnabled(IProject project) {
        return JSFSeverityPreferences.isValidationEnabled(project) && JSFSeverityPreferences.shouldValidateTagLibs(project);
    }

    protected String getPreference(IProject project, String preferenceKey) {
        return JSFSeverityPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    protected boolean shouldValidateTagLibTags(IProject project) {
        return JSFSeverityPreferences.shouldValidateTagLibTags(project);
    }

    protected boolean shouldValidateTagLibTagAttributes(IProject project) {
        return JSFSeverityPreferences.shouldValidateTagLibTagAttributes(project);
    }

    public int getMaxNumberOfMarkersPerFile(IProject project) {
        return JSFSeverityPreferences.getMaxNumberOfProblemMarkersPerFile(project);
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new CompositeComponentValidator.CompositeComponentPreferenceInfo());
    }
}

