/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.pattern;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.jsf.web.pattern.JSFUrlPattern;
import org.jboss.tools.jsf.web.pattern.PatternLoader;

public class CompoundPattern
implements JSFUrlPattern {
    JSFUrlPattern[] patterns = PatternLoader.DEFAULT_PATTERNS;

    public void setPatterns(JSFUrlPattern[] patterns) {
        this.patterns = patterns;
    }

    @Override
    public boolean matches(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.patterns.length) {
            if (this.patterns[i].matches(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isJSFUrl(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.patterns.length) {
            if (this.patterns[i].isJSFUrl(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getJSFPath(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        int i = 0;
        while (i < this.patterns.length) {
            if (this.patterns[i].matches(url)) {
                return this.patterns[i].getJSFPath(url);
            }
            ++i;
        }
        return this.patterns[0].getJSFPath(url);
    }

    @Override
    public String getJSFUrl(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int i = 0;
        while (i < this.patterns.length) {
            if (this.patterns[i].matches(path)) {
                return path;
            }
            ++i;
        }
        return this.patterns[0].getJSFUrl(path);
    }

    @Override
    public List<String> getJSFPaths(String url) {
        ArrayList<String> result = new ArrayList<String>();
        JSFUrlPattern[] jSFUrlPatternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            JSFUrlPattern pattern = jSFUrlPatternArray[n2];
            result.addAll(pattern.getJSFPaths(url));
            ++n2;
        }
        return result;
    }
}

