/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers.refactoring;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.refactoring.RefactoringHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.ReferenceGroupImpl;
import org.jboss.tools.jsf.model.handlers.RenameViewSupport;
import org.jboss.tools.jsf.model.handlers.refactoring.JSFRenamePathDiagramChange;
import org.jboss.tools.jsf.model.helpers.JSFProcessHelper;
import org.jboss.tools.jsf.model.helpers.JSFProcessStructureHelper;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class JSFRenamePageFacesConfigChange
extends CompositeChange {
    XModelObject object;
    String newName;
    String oldText;
    String newText;
    XModelObject[] fs = new XModelObject[0];
    Properties replacements = new Properties();
    static String[] ICON_ATTRIBUTES = new String[]{"small-icon", "large-icon"};

    public JSFRenamePageFacesConfigChange(XModelObject object, String newName) {
        super(JSFUIMessages.FACES_CONFIG_CHANGES);
        this.object = object;
        this.newName = newName;
        this.replacements.clear();
        this.oldText = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        int i = this.oldText.lastIndexOf("/");
        this.newText = String.valueOf(this.oldText.substring(0, i + 1)) + newName;
        this.replacements.setProperty(this.oldText, this.newText);
        this.addChanges();
    }

    public JSFRenamePageFacesConfigChange(XModelObject object, String name, XModelObject newParent) {
        super(JSFUIMessages.FACES_CONFIG_CHANGES);
        this.object = object;
        this.newName = name;
        this.replacements.clear();
        String oldText = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        String newText = String.valueOf(XModelObjectLoaderUtil.getResourcePath((XModelObject)newParent)) + "/" + name;
        this.replacements.setProperty(oldText, newText);
        this.addChanges();
    }

    private void addChanges() {
        if (this.object == null) {
            return;
        }
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(this.object.getModel());
        XModelObject conf = root == null ? null : root.getChildByPath("Configuration");
        this.fs = conf == null ? new XModelObject[]{} : ((WebProjectNode)conf).getTreeChildren();
        this.addChanges(this.fs);
    }

    private void addChanges(XModelObject[] objects) {
        int i = 0;
        while (i < objects.length) {
            XModelObject[] gs;
            int c = this.getChildren().length;
            RefactoringHelper.addChanges((XModelObject)objects[i], (Properties)this.replacements, (CompositeChange)this);
            if (c == this.getChildren().length && (gs = this.findGroups(objects[i])).length > 0) {
                this.add((Change)new JSFRenamePathDiagramChange(objects[i], gs));
            }
            ++i;
        }
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        XModelObject parent = this.object.getParent();
        if (parent instanceof FolderImpl) {
            ((FolderImpl)parent).update();
        }
        int i = 0;
        while (i < this.fs.length) {
            this.performChangeInFile(this.fs[i]);
            ++i;
        }
        i = 0;
        while (i < this.fs.length) {
            if (this.fs[i].isModified()) {
                XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)this.fs[i], null);
            }
            ++i;
        }
        return null;
    }

    private void performChangeInFile(XModelObject f) throws XModelException {
        JSFRenamePageFacesConfigChange.replaceIcons(f, this.oldText, this.newText);
        XModelObject[] gs = this.findGroups(f);
        if (gs.length == 0) {
            return;
        }
        JSFProcessHelper h = JSFProcessHelper.getHelper(JSFProcessStructureHelper.instance.getProcess(f));
        h.addUpdateLock((Object)this);
        try {
            int j = 0;
            while (j < gs.length) {
                RenameViewSupport.replace((ReferenceGroupImpl)gs[j], this.oldText, this.newText);
                ++j;
            }
        }
        finally {
            h.removeUpdateLock((Object)this);
            h.updateProcess();
        }
    }

    XModelObject[] findGroups(XModelObject f) {
        XModelObject process = JSFProcessStructureHelper.instance.getProcess(f);
        if (process == null) {
            return new XModelObject[0];
        }
        XModelObject[] gs = JSFProcessStructureHelper.instance.getGroups(process);
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        int i = 0;
        while (i < gs.length) {
            String path = gs[i].getAttributeValue("path");
            if (path != null && path.equals(this.oldText)) {
                list.add(gs[i]);
            }
            ++i;
        }
        return list.toArray(new XModelObject[0]);
    }

    static void replaceIcons(XModelObject f, String oldText, String newText) throws XModelException {
        if (oldText == null || oldText.length() == 0) {
            return;
        }
        if (f.getModelEntity().getAttribute(ICON_ATTRIBUTES[0]) != null) {
            int i = 0;
            while (i < ICON_ATTRIBUTES.length) {
                String v = f.getAttributeValue(ICON_ATTRIBUTES[i]);
                if (oldText.equals(v)) {
                    f.getModel().editObjectAttribute(f, "small-icon", newText);
                }
                ++i;
            }
        }
        XModelObject[] cs = f.getChildrenForSave();
        int i = 0;
        while (i < cs.length) {
            JSFRenamePageFacesConfigChange.replaceIcons(cs[i], oldText, newText);
            ++i;
        }
    }
}

