/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.refactoring.action.rename;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.jsf.jsf2.model.JSF2ComponentModelManager;
import org.jboss.tools.jsf.jsf2.refactoring.core.StructuredChanges;
import org.jboss.tools.jsf.jsf2.refactoring.core.StructuredTextFileChange;
import org.jboss.tools.jsf.jsf2.util.JSF2ComponentUtil;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class CompositeAttributeRenameProcessor
extends RenameProcessor
implements INameUpdating {
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_.]*+");
    private static final GroupCategorySet CATEGORY_COMPOSITE_ATTR_RENAME = new GroupCategorySet(new GroupCategory("org.jboss.tools.jsf.jsf2.refactoring.rename.composite.attr.type", JSFUIMessages.Refactoring_JSF_2_Rename_Composite_Attr_Changes, JSFUIMessages.Refactoring_JSF_2_Changes_Rename_Composite_Attr));
    public static final String IDENTIFIER = "org.jboss.tools.jsf.jsf2.refactor.compositeattrrenameprocessor";
    private String newAttrName;
    private String currentAttrName;
    private IProject project;
    private String URI;
    private IFile baseFile;
    private IDOMAttr attrToRename;

    public void setCurrentAttrName(String currentAttrName) {
        this.currentAttrName = currentAttrName;
    }

    public CompositeAttributeRenameProcessor(IProject project) {
        this.setProject(project);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        StructuredChanges changes = new StructuredChanges(JSFUIMessages.Refactoring_JSF_2_Composite_Attr_Rename_Changes);
        changes.add((Change)this.createBaseFileChange());
        Map<IFile, List<IDOMNode>> nodesMap = JSF2ComponentUtil.findCompositeComponentsWithURI((IResource)this.getProject(), this.getURI());
        Set<Map.Entry<IFile, List<IDOMNode>>> entries = nodesMap.entrySet();
        for (Map.Entry<IFile, List<IDOMNode>> entry : entries) {
            StructuredTextFileChange fileChange = this.createFileChange(entry.getKey(), entry.getValue());
            if (fileChange == null) continue;
            changes.add((Change)fileChange);
        }
        return changes;
    }

    private StructuredTextFileChange createBaseFileChange() {
        StructuredTextFileChange baseFileChange = new StructuredTextFileChange(this.baseFile.getFullPath().toOSString(), this.baseFile);
        ReplaceEdit edit = new ReplaceEdit(this.attrToRename.getValueRegionStartOffset() + 1, this.attrToRename.getValue().length(), this.getNewElementName());
        TextChangeCompatibility.addTextEdit((TextChange)baseFileChange, (String)JSFUIMessages.Refactoring_JSF_2_Rename_Composite_Attr_Name, (TextEdit)edit, (GroupCategorySet)CATEGORY_COMPOSITE_ATTR_RENAME);
        IDOMElement element = JSF2ComponentUtil.findCompositeImpl((Node)JSF2ComponentModelManager.getReadableDOMDocument(this.baseFile));
        if (element != null) {
            IDOMAttr[] attrs = JSF2ComponentUtil.extractAttrsWithValue(element, this.computeAttrOldValue());
            int i = 0;
            while (i < attrs.length) {
                edit = new ReplaceEdit(attrs[i].getValueRegionStartOffset() + 1, attrs[i].getValue().length(), this.computeAttrNewValue());
                TextChangeCompatibility.addTextEdit((TextChange)baseFileChange, (String)JSFUIMessages.Refactoring_JSF_2_Rename_Attr_Ref_Decl, (TextEdit)edit, (GroupCategorySet)CATEGORY_COMPOSITE_ATTR_RENAME);
                ++i;
            }
        }
        return baseFileChange;
    }

    private String computeAttrOldValue() {
        return "#{cc.attrs." + this.getCurrentElementName() + "}";
    }

    private String computeAttrNewValue() {
        return "#{cc.attrs." + this.getNewElementName() + "}";
    }

    private StructuredTextFileChange createFileChange(IFile file, List<IDOMNode> nodeList) {
        StructuredTextFileChange fileChange = null;
        for (IDOMNode domNode : nodeList) {
            IDOMElement element;
            Attr attr;
            if (!(domNode instanceof IDOMElement) || !((attr = (element = (IDOMElement)domNode).getAttributeNode(this.getCurrentElementName())) instanceof IDOMAttr)) continue;
            IDOMAttr domAttr = (IDOMAttr)attr;
            if (fileChange == null) {
                fileChange = new StructuredTextFileChange(file.getFullPath().toOSString(), file);
            }
            ReplaceEdit edit = new ReplaceEdit(domAttr.getStartOffset(), domAttr.getName().length(), this.getNewElementName());
            TextChangeCompatibility.addTextEdit((TextChange)fileChange, (String)JSFUIMessages.Refactoring_JSF_2_Rename_Composite_Attr, (TextEdit)edit, (GroupCategorySet)CATEGORY_COMPOSITE_ATTR_RENAME);
        }
        return fileChange;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return JSFUIMessages.Refactoring_JSF_2_Rename_Composite_Attr;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return null;
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        RefactoringStatus status = null;
        Matcher matcher = PATTERN.matcher(this.getNewElementName());
        int includings = 0;
        String matchString = null;
        while (matcher.find()) {
            ++includings;
            matchString = matcher.group();
        }
        if (includings != 1 || !matchString.equals(this.getNewElementName())) {
            status = RefactoringStatus.createFatalErrorStatus((String)JSFUIMessages.Refactoring_JSF_2_Invalid_Attr);
        }
        return status;
    }

    public String getCurrentElementName() {
        return this.currentAttrName;
    }

    public Object getNewElement() throws CoreException {
        return null;
    }

    public String getNewElementName() {
        return this.newAttrName;
    }

    public void setNewElementName(String newName) {
        this.newAttrName = newName;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setURI(String uRI) {
        this.URI = uRI;
    }

    public String getURI() {
        return this.URI;
    }

    public void setBaseFile(IFile baseFile) {
        this.baseFile = baseFile;
    }

    public IFile getBaseFile() {
        return this.baseFile;
    }

    public void setAttrToRename(IDOMAttr attrToRename) {
        this.attrToRename = attrToRename;
    }

    public IDOMAttr getAttrToRename() {
        return this.attrToRename;
    }
}

