/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.layer;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.layer.VModelImpl;
import org.jboss.tools.common.verification.vrules.plugin.VerificationPlugin;

public class VEntityImpl
implements VEntity {
    private XModelMetaData meta;
    private String entityName;
    private XModelEntity modelEntity;
    private VModelImpl model;
    private List<VRule> rules;

    public VEntityImpl(XModelMetaData meta, String entityName, VModelImpl model) {
        this.meta = meta;
        this.entityName = entityName;
        this.model = model;
        this.rules = new ArrayList<VRule>();
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    @Override
    public VEntity[] getChildren() {
        XChild[] c = this.getModelEntity().getChildren();
        VEntity[] children = new VEntity[c.length];
        int i = 0;
        while (i < c.length) {
            children[i] = this.model.getEntity(c[i].getName());
            ++i;
        }
        return children;
    }

    @Override
    public VRule[] getRules() {
        return this.rules.toArray(new VRule[this.rules.size()]);
    }

    @Override
    public void addRule(VRule rule) {
        if (this.rules.contains(rule)) {
            return;
        }
        this.rules.add(rule);
        XModelEntity e = this.getModelEntity();
        if (e != null) {
            this.model.createRuleActionInh(this.getModelEntity(), rule);
        }
    }

    @Override
    public void removeRule(VRule rule) {
        this.model.removeRuleActionInh(this.getModelEntity(), rule);
        this.rules.remove(rule);
    }

    @Override
    public void clearRules() {
        int i = 0;
        while (i < this.rules.size()) {
            VRule rule = this.rules.get(i);
            this.model.removeRuleActionInh(this.getModelEntity(), rule);
            ++i;
        }
        this.rules.clear();
    }

    @Override
    public boolean isDescendant(String entity) {
        return this.meta.getParentInfo().isDescendant(entity, this.entityName);
    }

    public XModelEntity getModelEntity() {
        if (this.modelEntity == null) {
            this.modelEntity = this.meta.getEntity(this.entityName);
            if (this.modelEntity == null) {
                VerificationPlugin.getPluginLog().logInfo("VModelImpl:Cannot find entity " + this.entityName);
            }
        }
        return this.modelEntity;
    }

    public boolean equals(Object o) {
        if (o instanceof VEntityImpl) {
            return ((VEntityImpl)o).entityName.equals(this.entityName);
        }
        return false;
    }

    public int hashCode() {
        return this.entityName.hashCode();
    }
}

