/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.handler;

import java.util.Properties;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.verification.vrules.VAction;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.handler.VerifyHandler;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;

public class VerifyRulesHandler
extends VerifyHandler {
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        VModel vmodel = VModelFactory.getModel(object.getModel());
        VObject vobject = vmodel.getObjectByPath(object.getPath());
        VRule[] rules = vobject.getEntity().getRules();
        int i = 0;
        while (i < rules.length) {
            VRule rule = rules[i];
            VAction vaction = rule.getAction();
            if (rule.isEnabled() && rule.getRuleSet().isEnabled() && vaction != null) {
                VResult[] results = vaction.check(vobject);
                if (results == null || results.length == 0) {
                    object.getModel().getOut().println(String.valueOf(rule.getName()) + ": OK");
                } else {
                    int j = 0;
                    while (j < results.length) {
                        object.getModel().getOut().println(String.valueOf(rule.getName()) + ": " + results[j].getMessage());
                        ++j;
                    }
                }
                this.mergeResults(object.getModel(), rule, vobject, results);
            }
            ++i;
        }
    }

    public boolean isEnabled(XModelObject object) {
        return VHelper.getManager() != null;
    }
}

