/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.wizards;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefEntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.util.xpl.StringHelper;
import org.jboss.tools.hibernate.runtime.spi.IColumn;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.IProperty;
import org.jboss.tools.hibernate.runtime.spi.IService;
import org.jboss.tools.hibernate.runtime.spi.IValue;

class TypeVisitor
extends ASTVisitor {
    private String varName;
    private Map<String, IPersistentClass> rootClasses;
    private IPersistentClass rootClass;
    private EntityInfo entityInfo;
    private RefEntityInfo ref;
    private IProperty prop;
    private IService service;

    TypeVisitor(IService service, Map<String, IPersistentClass> rootClasses) {
        this.rootClasses = rootClasses;
        this.service = service;
    }

    public void init(String varName, EntityInfo entityInfo) {
        this.varName = varName;
        this.entityInfo = entityInfo;
        Map<String, RefEntityInfo> refs = entityInfo.getReferences();
        this.ref = refs.get(varName);
        this.prop = null;
        this.rootClass = this.rootClasses.get(entityInfo.getFullyQualifiedName());
    }

    public boolean visit(ArrayType type) {
        IValue array = null;
        Type componentType = type.getComponentType();
        ITypeBinding tb = componentType.resolveBinding();
        if (tb == null) {
            return false;
        }
        if (tb.isPrimitive()) {
            array = this.service.newPrimitiveArray(this.rootClass);
            IValue value = this.buildSimpleValue(tb.getName());
            value.setTable(this.rootClass.getTable());
            array.setElement(value);
            array.setCollectionTable(this.rootClass.getTable());
        } else {
            IPersistentClass associatedClass = this.rootClasses.get(tb.getBinaryName());
            array = this.service.newArray(this.rootClass);
            array.setElementClassName(tb.getBinaryName());
            array.setCollectionTable(associatedClass.getTable());
            IValue oValue = this.service.newOneToMany(this.rootClass);
            oValue.setAssociatedClass(associatedClass);
            oValue.setReferencedEntityName(tb.getBinaryName());
            array.setElement(oValue);
        }
        IValue key = this.service.newSimpleValue();
        if (StringHelper.isNotEmpty((String)this.entityInfo.getPrimaryIdName())) {
            key.addColumn(this.service.newColumn(this.entityInfo.getPrimaryIdName().toUpperCase()));
        }
        array.setKey(key);
        array.setFetchModeJoin();
        IValue index = this.service.newSimpleValue();
        array.setIndex(index);
        this.buildProperty(array);
        this.prop.setCascade("none");
        return false;
    }

    public boolean visit(ParameterizedType type) {
        Assert.isNotNull((Object)type, (String)"Type object cannot be null");
        Assert.isNotNull((Object)this.entityInfo, (String)"EntityInfo object cannot be null");
        ITypeBinding tb = type.resolveBinding();
        if (tb == null) {
            return false;
        }
        this.rootClass = this.rootClasses.get(this.entityInfo.getFullyQualifiedName());
        Assert.isNotNull((Object)this.rootClass, (String)"RootClass not found.");
        ITypeBinding[] interfaces = Utils.getAllInterfaces(tb);
        IValue value = this.buildCollectionValue(interfaces);
        if (value != null) {
            if (this.ref != null && this.rootClasses.get(this.ref.fullyQualifiedName) != null) {
                IValue oValue = this.service.newOneToMany(this.rootClass);
                IPersistentClass associatedClass = this.rootClasses.get(this.ref.fullyQualifiedName);
                oValue.setAssociatedClass(associatedClass);
                oValue.setReferencedEntityName(associatedClass.getEntityName());
                value.setCollectionTable(associatedClass.getTable());
                value.setElement(oValue);
            } else {
                IValue elementValue = this.buildSimpleValue(tb.getTypeArguments()[0].getQualifiedName());
                elementValue.setTable(this.rootClass.getTable());
                value.setElement(elementValue);
                value.setCollectionTable(this.rootClass.getTable());
            }
            if (value.isList()) {
                value.setIndex(this.service.newSimpleValue());
            } else if (value.isMap()) {
                IValue map_key = this.service.newSimpleValue();
                map_key.setTypeName(tb.getTypeArguments()[0].getBinaryName());
                value.setIndex(map_key);
            }
        }
        if (value == null) {
            value = this.buildSimpleValue(tb.getBinaryName());
        }
        this.buildProperty(value);
        if (!value.isSimpleValue()) {
            this.prop.setCascade("none");
        }
        return false;
    }

    public boolean visit(PrimitiveType type) {
        this.buildProperty(this.buildSimpleValue(type.getPrimitiveTypeCode().toString()));
        return false;
    }

    public boolean visit(QualifiedType type) {
        return super.visit(type);
    }

    public boolean visit(SimpleType type) {
        ITypeBinding tb = type.resolveBinding();
        if (tb == null) {
            return false;
        }
        ITypeBinding[] interfaces = Utils.getAllInterfaces(tb);
        IValue value = this.buildCollectionValue(interfaces);
        if (value != null) {
            IValue element = this.buildSimpleValue("string");
            value.setElement(element);
            value.setCollectionTable(this.rootClass.getTable());
            this.buildProperty(value);
            if (value.isList()) {
                value.setIndex(this.service.newSimpleValue());
            } else if (value.isMap()) {
                IValue map_key = this.service.newSimpleValue();
                map_key.setTypeName("string");
                value.setIndex(map_key);
            }
            this.prop.setCascade("none");
        } else if (tb.isEnum()) {
            value = this.buildSimpleValue("org.hibernate.type.EnumType");
            Properties typeParameters = new Properties();
            typeParameters.put("enumClass", tb.getBinaryName());
            typeParameters.put("type", (Object)12);
            value.setTypeParameters(typeParameters);
            this.buildProperty(value);
        } else if (this.ref != null) {
            IValue sValue = null;
            if (this.ref.refType == RefType.MANY2ONE) {
                sValue = this.service.newManyToOne(this.rootClass.getTable());
            } else if (this.ref.refType == RefType.ONE2ONE) {
                sValue = this.service.newOneToOne(this.rootClass);
            } else if (this.ref.refType == RefType.UNDEF) {
                sValue = this.service.newOneToOne(this.rootClass);
            } else {
                throw new IllegalStateException(this.ref.refType.toString());
            }
            IColumn column = this.service.newColumn(this.varName.toUpperCase());
            sValue.addColumn(column);
            sValue.setTypeName(tb.getBinaryName());
            sValue.setFetchModeJoin();
            sValue.setReferencedEntityName(this.ref.fullyQualifiedName);
            this.buildProperty(sValue);
            this.prop.setCascade("none");
        } else {
            value = this.buildSimpleValue(tb.getBinaryName());
            this.buildProperty(value);
        }
        return super.visit(type);
    }

    public boolean visit(WildcardType type) {
        return super.visit(type);
    }

    public IProperty getProperty() {
        return this.prop;
    }

    protected void buildProperty(IValue value) {
        this.prop = this.service.newProperty();
        this.prop.setName(this.varName);
        this.prop.setValue(value);
    }

    private IValue buildSimpleValue(String typeName) {
        IValue sValue = this.service.newSimpleValue();
        sValue.addColumn(this.service.newColumn(this.varName.toUpperCase()));
        sValue.setTypeName(typeName);
        return sValue;
    }

    private IValue buildCollectionValue(ITypeBinding[] interfaces) {
        IValue cValue = null;
        if (Utils.isImplementInterface(interfaces, Set.class.getName())) {
            cValue = this.service.newSet(this.rootClass);
        } else if (Utils.isImplementInterface(interfaces, List.class.getName())) {
            cValue = this.service.newList(this.rootClass);
        } else if (Utils.isImplementInterface(interfaces, Map.class.getName())) {
            cValue = this.service.newMap(this.rootClass);
        } else if (Utils.isImplementInterface(interfaces, Collection.class.getName())) {
            cValue = this.service.newBag(this.rootClass);
        }
        if (cValue == null) {
            return null;
        }
        cValue.setCollectionTable(this.rootClass.getTable());
        IValue key = this.service.newSimpleValue();
        key.setTypeName("string");
        if (StringHelper.isNotEmpty((String)this.entityInfo.getPrimaryIdName())) {
            key.addColumn(this.service.newColumn(this.entityInfo.getPrimaryIdName().toUpperCase()));
        }
        cValue.setKey(key);
        cValue.setLazy(true);
        cValue.setRole(StringHelper.qualify((String)this.rootClass.getEntityName(), (String)this.varName));
        return cValue;
    }
}

