/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.wizards;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.eclipse.jdt.ui.wizards.TypeVisitor;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.IProperty;
import org.jboss.tools.hibernate.runtime.spi.IService;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.jboss.tools.hibernate.runtime.spi.IValue;

class ProcessEntityInfo
extends ASTVisitor {
    private Map<String, IPersistentClass> rootClasses = new HashMap<String, IPersistentClass>();
    private IPersistentClass rootClass;
    protected EntityInfo entityInfo;
    private TypeDeclaration currentType;
    TypeVisitor typeVisitor;
    IService service;

    ProcessEntityInfo(IService service) {
        this.service = service;
    }

    public void setEntities(Map<String, EntityInfo> entities) {
        this.rootClasses.clear();
        for (Map.Entry<String, EntityInfo> entry : entities.entrySet()) {
            EntityInfo entryInfo = entry.getValue();
            String className = entryInfo.getName();
            ITable table = this.service.newTable(className.toUpperCase());
            IPersistentClass rootClass = this.service.newRootClass();
            rootClass.setEntityName(entryInfo.getFullyQualifiedName());
            rootClass.setClassName(entryInfo.getFullyQualifiedName());
            rootClass.setProxyInterfaceName(entryInfo.getFullyQualifiedName());
            rootClass.setLazy(true);
            rootClass.setTable(table);
            rootClass.setAbstract(Boolean.valueOf(entryInfo.isAbstractFlag()));
            this.rootClasses.put(entryInfo.getFullyQualifiedName(), rootClass);
        }
        this.typeVisitor = new TypeVisitor(this.service, this.rootClasses);
    }

    public void setEntityInfo(EntityInfo entityInfo) {
        this.entityInfo = entityInfo;
        this.rootClass = this.rootClasses.get(entityInfo.getFullyQualifiedName());
    }

    public boolean visit(CompilationUnit node) {
        Assert.isNotNull((Object)this.rootClass);
        this.currentType = null;
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        if (this.currentType == null) {
            this.currentType = node;
            if ("".equals(this.entityInfo.getPrimaryIdName())) {
                FieldDeclaration[] fields = node.getFields();
                String firstFieldName = "";
                int i = 0;
                while (i < fields.length) {
                    for (VariableDeclarationFragment variable : fields[i].fragments()) {
                        Type type = ((FieldDeclaration)variable.getParent()).getType();
                        if ("id".equals(variable.getName().getIdentifier()) && !type.isArrayType() && !Utils.isImplementInterface(new ITypeBinding[]{type.resolveBinding()}, Collection.class.getName())) {
                            this.entityInfo.setPrimaryIdName(variable.getName().getIdentifier());
                            return true;
                        }
                        if (!"".equals(firstFieldName) || type.isArrayType() || Utils.isImplementInterface(new ITypeBinding[]{type.resolveBinding()}, Collection.class.getName())) continue;
                        firstFieldName = variable.getName().getIdentifier();
                    }
                    ++i;
                }
                this.entityInfo.setPrimaryIdName(firstFieldName);
            }
            return true;
        }
        return false;
    }

    public void endVisit(TypeDeclaration node) {
        if (this.currentType == node && this.rootClass.getIdentifierProperty() == null) {
            IValue sValue = this.service.newSimpleValue();
            sValue.addColumn(this.service.newColumn("id".toUpperCase()));
            sValue.setTypeName(Long.class.getName());
            IProperty prop = this.service.newProperty();
            prop.setName("id");
            prop.setValue(sValue);
            this.rootClass.setIdentifierProperty(prop);
        }
    }

    public boolean visit(FieldDeclaration node) {
        if ((node.getModifiers() & 0x18) != 0) {
            return false;
        }
        Type type = node.getType();
        if (type == null) {
            return true;
        }
        String primaryIdName = this.entityInfo.getPrimaryIdName();
        for (VariableDeclarationFragment var : node.fragments()) {
            String name;
            IProperty prop = this.createProperty(var);
            if (prop == null) continue;
            if (!this.varHasGetterAndSetter(var)) {
                prop.setPropertyAccessorName("field");
            }
            if ((name = var.getName().getIdentifier()).equals(primaryIdName)) {
                this.rootClass.setIdentifierProperty(prop);
                continue;
            }
            this.rootClass.addProperty(prop);
        }
        return true;
    }

    private boolean varHasGetterAndSetter(VariableDeclarationFragment var) {
        MethodDeclaration[] mds;
        String name = var.getName().getIdentifier();
        String setterName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        String getterName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        String getterName2 = null;
        Type varType = ((FieldDeclaration)var.getParent()).getType();
        if (varType.isPrimitiveType() && ((PrimitiveType)varType).getPrimitiveTypeCode() == PrimitiveType.BOOLEAN) {
            getterName2 = "is" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        boolean setterFound = false;
        boolean getterFound = false;
        MethodDeclaration[] methodDeclarationArray = mds = ((TypeDeclaration)((FieldDeclaration)var.getParent()).getParent()).getMethods();
        int n = mds.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            String methodName = methodDeclaration.getName().getIdentifier();
            if (methodName.equals(setterName)) {
                setterFound = true;
            }
            if (methodName.equals(getterName)) {
                getterFound = true;
            }
            if (methodName.equals(getterName2)) {
                getterFound = true;
            }
            if (setterFound && getterFound) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        String varName;
        if (!this.entityInfo.isInterfaceFlag()) {
            return super.visit(node);
        }
        TypeDeclaration type = (TypeDeclaration)node.getParent();
        if (type.isInterface() && (varName = Utils.getFieldNameByGetter(node)) != null) {
            String primaryIdName = this.entityInfo.getPrimaryIdName();
            Type methodType = node.getReturnType2();
            if (varName.toLowerCase().equals(primaryIdName.toLowerCase())) {
                varName = primaryIdName;
            }
            IProperty prop = this.createProperty(varName, methodType);
            if (varName.equals(primaryIdName)) {
                this.rootClass.setIdentifierProperty(prop);
            } else {
                this.rootClass.addProperty(prop);
            }
        }
        return super.visit(node);
    }

    public IPersistentClass getPersistentClass() {
        return this.rootClass;
    }

    protected IProperty createProperty(VariableDeclarationFragment var) {
        return this.createProperty(var.getName().getIdentifier(), ((FieldDeclaration)var.getParent()).getType());
    }

    protected IProperty createProperty(String varName, Type varType) {
        this.typeVisitor.init(varName, this.entityInfo);
        varType.accept((ASTVisitor)this.typeVisitor);
        IProperty p = this.typeVisitor.getProperty();
        return p;
    }

    public Map<String, IPersistentClass> getRootClasses() {
        return this.rootClasses;
    }
}

