/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.FileUtils;
import org.hibernate.eclipse.jdt.ui.internal.JdtUiMessages;
import org.hibernate.eclipse.jdt.ui.internal.jpa.collect.AllEntitiesInfoCollector;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.eclipse.jdt.ui.wizards.ConfigurationActor;
import org.hibernate.eclipse.jdt.ui.wizards.NewHibernateMappingElementsSelectionPage2;
import org.hibernate.eclipse.jdt.ui.wizards.NewHibernateMappingFilePage;
import org.hibernate.eclipse.jdt.ui.wizards.NewHibernateMappingPreviewPage;
import org.hibernate.eclipse.nature.HibernateNature;
import org.jboss.tools.hibernate.runtime.spi.IConfiguration;
import org.jboss.tools.hibernate.runtime.spi.IExportPOJODelegate;
import org.jboss.tools.hibernate.runtime.spi.IHibernateMappingExporter;
import org.jboss.tools.hibernate.runtime.spi.IHibernateMappingGlobalSettings;
import org.jboss.tools.hibernate.runtime.spi.IPOJOClass;
import org.jboss.tools.hibernate.runtime.spi.IService;
import org.jboss.tools.hibernate.runtime.spi.ServiceLookup;

public class NewHibernateMappingFileWizard
extends Wizard
implements INewWizard,
IPageChangingListener {
    private Set<ICompilationUnit> selectionCU = null;
    private Map<IJavaProject, Collection<EntityInfo>> project_infos = new HashMap<IJavaProject, Collection<EntityInfo>>();
    private IStructuredSelection selection;
    private int processDepth = Integer.MIN_VALUE;
    private NewHibernateMappingElementsSelectionPage2 page0 = null;
    private WizardNewFileCreationPage cPage;
    private NewHibernateMappingFilePage page2 = null;
    private NewHibernateMappingPreviewPage previewPage = null;

    public NewHibernateMappingFileWizard() {
        this.setDefaultPageImageDescriptor(EclipseImages.getImageDescriptor((String)"NEW_WIZARD"));
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(JdtUiMessages.NewHibernateMappingFileWizard_create_hibernate_xml_mapping_file);
    }

    public void addPages() {
        super.addPages();
        if (this.selection == null) {
            this.selection = new StructuredSelection();
        }
        this.page0 = new NewHibernateMappingElementsSelectionPage2(JdtUiMessages.NewHibernateMappingFileWizard_create_hibernate_xml_mapping_file, this.selection);
        this.page0.setTitle(JdtUiMessages.NewHibernateMappingElementsSelectionPage2_title);
        this.page0.setDescription(JdtUiMessages.NewHibernateMappingElementsSelectionPage2_description);
        this.addPage((IWizardPage)this.page0);
        this.cPage = new WizardNewFileCreationPage("Ccfgxml", this.selection);
        this.cPage.setTitle(JdtUiMessages.NewHibernateMappingFileWizard_create_hibernate_xml_mapping_file);
        this.cPage.setDescription(JdtUiMessages.NewHibernateMappingFileWizard_create_empty_xml_mapping_file);
        this.cPage.setFileName("hibernate.hbm.xml");
        this.addPage((IWizardPage)this.cPage);
        this.page2 = new NewHibernateMappingFilePage(false);
        this.page2.setTitle(JdtUiMessages.NewHibernateMappingFilePage_title);
        this.page2.setMessage(JdtUiMessages.NewHibernateMappingFilePage_this_wizard_creates, 2);
        this.addPage((IWizardPage)this.page2);
        this.previewPage = new NewHibernateMappingPreviewPage();
        this.previewPage.setTitle(JdtUiMessages.NewHibernateMappingPreviewPage_title);
        this.addPage((IWizardPage)this.previewPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.page0 && !this.page0.getSelection().isEmpty()) {
            return this.page2;
        }
        if (page == this.cPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public void setContainer(IWizardContainer wizardContainer) {
        if (this.getContainer() instanceof WizardDialog) {
            ((WizardDialog)this.getContainer()).removePageChangingListener((IPageChangingListener)this);
        }
        super.setContainer(wizardContainer);
        if (this.getContainer() instanceof WizardDialog) {
            ((WizardDialog)this.getContainer()).addPageChangingListener((IPageChangingListener)this);
        }
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getTargetPage() != this.previewPage) {
            this.previewPage.setChange(null);
        }
        if (event.getTargetPage() == this.page2) {
            this.updateCompilationUnits();
            this.page2.setInput(this.project_infos);
        } else if (event.getTargetPage() == this.previewPage) {
            Map<IJavaProject, IPath> places2Gen = this.getPlaces2Gen();
            this.previewPage.setPlaces2Gen(places2Gen);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        HashSet<Object> filteredElements = new HashSet<Object>();
        Object[] elements = selection.toArray();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof JavaProject) {
                JavaProject project = (JavaProject)elements[i];
                try {
                    IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                    int j = 0;
                    while (j < roots.length) {
                        if (!roots[j].isArchive()) {
                            IJavaElement[] rootChildren = roots[j].getChildren();
                            int k = 0;
                            while (k < rootChildren.length) {
                                if (rootChildren[k] instanceof IPackageFragment) {
                                    IPackageFragment pkg = (IPackageFragment)rootChildren[k];
                                    try {
                                        if (pkg.containsJavaResources()) {
                                            filteredElements.add(rootChildren[k]);
                                        }
                                    }
                                    catch (JavaModelException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            } else if (elements[i] instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)elements[i];
                if (!root.isArchive()) {
                    try {
                        IJavaElement[] rootChildren = root.getChildren();
                        int k = 0;
                        while (k < rootChildren.length) {
                            if (rootChildren[k] instanceof IPackageFragment) {
                                IPackageFragment pkg = (IPackageFragment)rootChildren[k];
                                try {
                                    if (pkg.containsJavaResources()) {
                                        filteredElements.add(rootChildren[k]);
                                    }
                                }
                                catch (JavaModelException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            ++k;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            } else if (elements[i] instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)elements[i];
                try {
                    IType[] types = cu.getTypes();
                    int j = 0;
                    while (j < types.length) {
                        filteredElements.add(types[j]);
                        ++j;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            } else if (elements[i] instanceof IJavaElement) {
                filteredElements.add((IJavaElement)elements[i]);
            }
            ++i;
        }
        this.selection = new StructuredSelection(filteredElements.toArray());
    }

    private IService getService(IJavaProject project) {
        HibernateNature hibnat = HibernateNature.getHibernateNature((IJavaProject)project);
        if (hibnat != null) {
            ConsoleConfiguration cc = hibnat.getDefaultConsoleConfiguration();
            return cc.getHibernateExtension().getHibernateService();
        }
        return ServiceLookup.findService((String)"3.5");
    }

    protected Map<IJavaProject, IPath> getPlaces2Gen() {
        this.updateCompilationUnits();
        Map<IJavaProject, IConfiguration> configs = this.createConfigurations();
        HashMap<IJavaProject, IPath> places2Gen = new HashMap<IJavaProject, IPath>();
        for (Map.Entry<IJavaProject, IConfiguration> entry : configs.entrySet()) {
            IConfiguration config = entry.getValue();
            IHibernateMappingGlobalSettings hmgs = this.getService(entry.getKey()).newHibernateMappingGlobalSettings();
            IPath place2Gen = this.previewPage.getRootPlace2Gen().append(entry.getKey().getElementName());
            places2Gen.put(entry.getKey(), place2Gen);
            File folder2Gen = new File(place2Gen.toOSString());
            FileUtils.delete((File)folder2Gen);
            if (!folder2Gen.exists()) {
                folder2Gen.mkdirs();
            }
            HibernateMappingExporterWrapper hce = new HibernateMappingExporterWrapper(entry.getKey(), config, folder2Gen);
            hce.setGlobalSettings(hmgs);
            try {
                hce.start();
            }
            catch (Exception e) {
                HibernateConsolePlugin.getDefault().log((Throwable)e);
            }
        }
        return places2Gen;
    }

    protected void cleanUpGenFolders() {
        Set<IJavaProject> projs = this.previewPage.getJavaProjects();
        for (IJavaProject proj : projs) {
            IPath place2Gen = this.previewPage.getRootPlace2Gen().append(proj.getElementName());
            File folder2Gen = new File(place2Gen.toOSString());
            FileUtils.delete((File)folder2Gen);
        }
    }

    public boolean performCancel() {
        this.cleanUpGenFolders();
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean res = true;
        if (this.page0.getSelection().isEmpty()) {
            final IFile file = this.cPage.createNewFile();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            NewHibernateMappingFileWizard.this.doFinish(file, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException interruptedException) {
                res = false;
            }
            catch (InvocationTargetException e) {
                Throwable realException = e.getTargetException();
                HibernateConsolePlugin.getDefault().showError(this.getShell(), HibernateConsoleMessages.NewReverseEngineeringFileWizard_error, realException);
                res = false;
            }
            this.cleanUpGenFolders();
        } else {
            if (this.previewPage.getChange() == null) {
                Map<IJavaProject, IPath> places2Gen = this.getPlaces2Gen();
                this.previewPage.setPlaces2Gen(places2Gen);
            }
            this.previewPage.performFinish();
            Set<IJavaProject> projs = this.previewPage.getJavaProjects();
            for (IJavaProject proj : projs) {
                try {
                    IPackageFragmentRoot[] pfRoots = proj.getPackageFragmentRoots();
                    int i = 0;
                    while (i < pfRoots.length) {
                        IResource container = pfRoots[i].getResource();
                        if (container != null && container.getType() != 1) {
                            container.refreshLocal(2, null);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    HibernateConsolePlugin.getDefault().log((Throwable)e);
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().log((Throwable)e);
                }
            }
            this.cleanUpGenFolders();
        }
        return res;
    }

    private void doFinish(final IFile file, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(HibernateConsoleMessages.NewReverseEngineeringFileWizard_creating) + file.getName(), 2);
        InputStream stream = null;
        try {
            stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        monitor.worked(1);
        monitor.setTaskName(HibernateConsoleMessages.NewConfigurationWizard_open_file_for_editing);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    HibernateConsolePlugin.getDefault().log((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        StringWriter sw = new StringWriter();
        sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE hibernate-mapping PUBLIC \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\" \"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\" >\r\n<hibernate-mapping>\r\n</hibernate-mapping>");
        try {
            return new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uec) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.NewConfigurationWizard_problems_converting_to_utf8, (Throwable)uec);
            return new ByteArrayInputStream(sw.toString().getBytes());
        }
    }

    protected void initEntitiesInfo() {
        if (this.selectionCU.size() == 0) {
            return;
        }
        AllEntitiesInfoCollector collector = new AllEntitiesInfoCollector();
        Iterator<ICompilationUnit> it = this.selectionCU.iterator();
        HashMap<IJavaProject, HashSet<ICompilationUnit>> mapJP_CUSet = new HashMap<IJavaProject, HashSet<ICompilationUnit>>();
        while (it.hasNext()) {
            ICompilationUnit cu = it.next();
            HashSet<ICompilationUnit> set = (HashSet<ICompilationUnit>)mapJP_CUSet.get(cu.getJavaProject());
            if (set == null) {
                set = new HashSet<ICompilationUnit>();
                mapJP_CUSet.put(cu.getJavaProject(), set);
            }
            set.add(cu);
        }
        for (Map.Entry entry : mapJP_CUSet.entrySet()) {
            IJavaProject javaProject = (IJavaProject)entry.getKey();
            Iterator setIt = ((Set)entry.getValue()).iterator();
            collector.initCollector();
            while (setIt.hasNext()) {
                ICompilationUnit icu = (ICompilationUnit)setIt.next();
                collector.collect(icu, this.processDepth);
            }
            collector.resolveRelations();
            ArrayList<EntityInfo> c = new ArrayList<EntityInfo>();
            Iterator<EntityInfo> i = collector.getMapCUs_Info().values().iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            this.project_infos.put(javaProject, c);
        }
    }

    protected void processJavaElements(Object obj, int depth) {
        if (depth < 0) {
            return;
        }
        try {
            if (obj instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)obj;
                this.selectionCU.add(cu);
            } else if (obj instanceof JavaProject && depth > 0) {
                IPackageFragmentRoot[] pfr;
                JavaProject javaProject = (JavaProject)obj;
                IPackageFragmentRoot[] iPackageFragmentRootArray = pfr = javaProject.getAllPackageFragmentRoots();
                int n = pfr.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot element = iPackageFragmentRootArray[n2];
                    this.processJavaElements(element, depth - 1);
                    ++n2;
                }
            } else if (obj instanceof PackageFragment) {
                ICompilationUnit[] cus;
                PackageFragment packageFragment = (PackageFragment)obj;
                ICompilationUnit[] iCompilationUnitArray = cus = packageFragment.getCompilationUnits();
                int n = cus.length;
                int n3 = 0;
                while (n3 < n) {
                    ICompilationUnit cu = iCompilationUnitArray[n3];
                    this.selectionCU.add(cu);
                    ++n3;
                }
            } else if (obj instanceof PackageFragmentRoot && depth > 0) {
                IJavaElement[] je;
                JavaElement javaElement = (JavaElement)obj;
                JavaElementInfo javaElementInfo = (JavaElementInfo)javaElement.getElementInfo();
                IJavaElement[] iJavaElementArray = je = javaElementInfo.getChildren();
                int n = je.length;
                int n4 = 0;
                while (n4 < n) {
                    IJavaElement element = iJavaElementArray[n4];
                    this.processJavaElements(element, depth - 1);
                    ++n4;
                }
            } else if (obj instanceof JavaElement) {
                JavaElement javaElement = (JavaElement)obj;
                ICompilationUnit cu = javaElement.getCompilationUnit();
                this.selectionCU.add(cu);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected Map<IJavaProject, IConfiguration> createConfigurations() {
        ConfigurationActor actor = new ConfigurationActor(this.selectionCU);
        Map<IJavaProject, IConfiguration> configs = actor.createConfigurations(this.processDepth);
        return configs;
    }

    protected void updateCompilationUnits() {
        Assert.isNotNull((Object)this.page0.getSelection(), (String)JdtUiMessages.NewHibernateMappingFileWizard_selection_cant_be_empty);
        if (this.selectionCU == null || !this.page0.getSelection().equals(this.selection) || this.processDepth != this.page0.getProcessDepth()) {
            this.selectionCU = new HashSet<ICompilationUnit>();
            this.project_infos.clear();
            this.selection = this.page0.getSelection();
            this.processDepth = this.page0.getProcessDepth();
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(JdtUiMessages.NewHibernateMappingFileWizard_look_for_dependent_cu, NewHibernateMappingFileWizard.this.selection.size() + 1);
                        Iterator it = NewHibernateMappingFileWizard.this.selection.iterator();
                        int done = 1;
                        while (it.hasNext()) {
                            Object obj = it.next();
                            NewHibernateMappingFileWizard.this.processJavaElements(obj, NewHibernateMappingFileWizard.this.processDepth);
                            monitor.worked(done++);
                        }
                        NewHibernateMappingFileWizard.this.initEntitiesInfo();
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                HibernateConsolePlugin.getDefault().log((Throwable)e);
            }
            catch (InterruptedException e) {
                HibernateConsolePlugin.getDefault().log((Throwable)e);
            }
        }
    }

    public boolean canFinish() {
        return !this.page0.getSelection().isEmpty() || this.cPage.isPageComplete();
    }

    protected class HibernateMappingExporterWrapper {
        protected IJavaProject proj;
        private IExportPOJODelegate delegate = new IExportPOJODelegate(){

            public void exportPOJO(Map<Object, Object> map, IPOJOClass pojoClass) {
                File outputdir4FileOld;
                File outputdir4FileNew = outputdir4FileOld = HibernateMappingExporterWrapper.this.target.getOutputDirectory();
                String fullyQualifiedName = pojoClass.getQualifiedDeclarationName();
                ICompilationUnit icu = Utils.findCompilationUnit(HibernateMappingExporterWrapper.this.proj, fullyQualifiedName);
                if (icu != null) {
                    IResource resource = null;
                    try {
                        resource = icu.getCorrespondingResource();
                    }
                    catch (JavaModelException javaModelException) {}
                    String[] aFQName = fullyQualifiedName.split("\\.");
                    int n = aFQName.length - 1;
                    while (n >= 0 && resource != null) {
                        if (n == 0 && aFQName[n].length() == 0) break;
                        resource = resource.getParent();
                        --n;
                    }
                    if (resource != null) {
                        IPath projPath = HibernateMappingExporterWrapper.this.proj.getResource().getLocation();
                        IPath place2Gen = NewHibernateMappingFileWizard.this.previewPage.getRootPlace2Gen().append(HibernateMappingExporterWrapper.this.proj.getElementName());
                        IPath tmpPath = resource.getLocation();
                        tmpPath = tmpPath.makeRelativeTo(projPath);
                        place2Gen = place2Gen.append(tmpPath);
                        outputdir4FileNew = place2Gen.toFile();
                    }
                }
                if (!outputdir4FileNew.exists()) {
                    outputdir4FileNew.mkdirs();
                }
                HibernateMappingExporterWrapper.this.target.setOutputDirectory(outputdir4FileNew);
                HibernateMappingExporterWrapper.this.target.exportPOJO(map, pojoClass);
                HibernateMappingExporterWrapper.this.target.setOutputDirectory(outputdir4FileOld);
            }
        };
        private IHibernateMappingExporter target = null;

        public HibernateMappingExporterWrapper(IJavaProject proj, IConfiguration cfg, File outputdir) {
            this.target = NewHibernateMappingFileWizard.this.getService(proj).newHibernateMappingExporter(cfg, outputdir);
            this.target.setExportPOJODelegate(this.delegate);
            this.proj = proj;
        }

        public void setGlobalSettings(IHibernateMappingGlobalSettings hmgs) {
            this.target.setGlobalSettings(hmgs);
        }

        public void start() {
            this.target.start();
        }
    }
}

