/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.io.File;
import java.util.List;
import org.jboss.tools.ws.creation.core.commands.AbstractGenerateCodeCommand;
import org.jboss.tools.ws.creation.core.data.ServiceModel;

public class WSDL2JavaCommand
extends AbstractGenerateCodeCommand {
    private static String WSCONSUEM_FILE_NAME_LINUX = "wsconsume.sh";
    private static String WSCONSUEM_FILE_NAME_WIN = "wsconsume.bat";

    public WSDL2JavaCommand(ServiceModel model) {
        super(model);
    }

    @Override
    protected String getCommandLineFileName_linux() {
        return WSCONSUEM_FILE_NAME_LINUX;
    }

    @Override
    protected String getCommandLineFileName_win() {
        return WSCONSUEM_FILE_NAME_WIN;
    }

    @Override
    protected void addCommandlineArgs(List<String> command) {
        File catalog;
        if (this.model.getCustomPackage() != null && !"".equals(this.model.getCustomPackage())) {
            command.add("-p");
            command.add(this.model.getCustomPackage());
        }
        List<String> bindingFiles = this.model.getBindingFiles();
        for (String bindingFileLocation : bindingFiles) {
            File bindingFile = new File(bindingFileLocation);
            if (!bindingFile.exists()) continue;
            command.add("-b");
            command.add(bindingFileLocation);
        }
        if (this.model.getCatalog() != null && !"".equals(this.model.getCatalog().trim()) && (catalog = new File(this.model.getCatalog())).exists()) {
            command.add("-c");
            command.add(this.model.getCatalog());
        }
        if (this.model.getTarget() != null) {
            command.add("-t");
            command.add(this.model.getTarget());
        }
        if (this.model.enableSOAP12()) {
            command.add("-e");
        }
        command.add("-v");
    }
}

